<?php

defined( 'ABSPATH' ) or die;

$GLOBALS['processed_terms'] = array();
$GLOBALS['processed_posts'] = array();

require_once ABSPATH . 'wp-admin/includes/post.php';
require_once ABSPATH . 'wp-admin/includes/taxonomy.php';
require_once ABSPATH . 'wp-admin/includes/image.php';

/**
 * Add an Import Action, this data is stored for processing after import is done.
 *
 * Each action is sent as an Ajax request and is handled by themify-ajax.php file
 */ 
function themify_add_import_action( $action = '', $data = array() ) {
	global $import_actions;

	if ( ! isset( $import_actions[ $action ] ) ) {
		$import_actions[ $action ] = array();
	}

	$import_actions[ $action ][] = $data;
}

function themify_import_post( $post ) {
	global $processed_posts, $processed_terms;

	if ( ! post_type_exists( $post['post_type'] ) ) {
		return;
	}

	/* Menu items don't have reliable post_title, skip the post_exists check */
	if( $post['post_type'] !== 'nav_menu_item' ) {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
		if ( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
			$processed_posts[ intval( $post['ID'] ) ] = intval( $post_exists );
			return;
		}
	}

	if( $post['post_type'] == 'nav_menu_item' ) {
		if( ! isset( $post['tax_input']['nav_menu'] ) || ! term_exists( $post['tax_input']['nav_menu'], 'nav_menu' ) ) {
			return;
		}
		$_menu_item_type = $post['meta_input']['_menu_item_type'];
		$_menu_item_object_id = $post['meta_input']['_menu_item_object_id'];

		if ( 'taxonomy' == $_menu_item_type && isset( $processed_terms[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_terms[ intval( $_menu_item_object_id ) ];
		} else if ( 'post_type' == $_menu_item_type && isset( $processed_posts[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_posts[ intval( $_menu_item_object_id ) ];
		} else if ( 'custom' != $_menu_item_type ) {
			// associated object is missing or not imported yet, we'll retry later
			// $missing_menu_items[] = $item;
			return;
		}
	}

	$post_parent = ( $post['post_type'] == 'nav_menu_item' ) ? $post['meta_input']['_menu_item_menu_item_parent'] : (int) $post['post_parent'];
	$post['post_parent'] = 0;
	if ( $post_parent ) {
		// if we already know the parent, map it to the new local ID
		if ( isset( $processed_posts[ $post_parent ] ) ) {
			if( $post['post_type'] == 'nav_menu_item' ) {
				$post['meta_input']['_menu_item_menu_item_parent'] = $processed_posts[ $post_parent ];
			} else {
				$post['post_parent'] = $processed_posts[ $post_parent ];
			}
		}
	}

	/**
	 * for hierarchical taxonomies, IDs must be used so wp_set_post_terms can function properly
	 * convert term slugs to IDs for hierarchical taxonomies
	 */
	if( ! empty( $post['tax_input'] ) ) {
		foreach( $post['tax_input'] as $tax => $terms ) {
			if( is_taxonomy_hierarchical( $tax ) ) {
				$terms = explode( ', ', $terms );
				$post['tax_input'][ $tax ] = array_map( 'themify_get_term_id_by_slug', $terms, array_fill( 0, count( $terms ), $tax ) );
			}
		}
	}

	$post['post_author'] = (int) get_current_user_id();
	$post['post_status'] = 'publish';

	$old_id = $post['ID'];

	unset( $post['ID'] );
	$post_id = wp_insert_post( $post, true );
	if( is_wp_error( $post_id ) ) {
		return false;
	} else {
		$processed_posts[ $old_id ] = $post_id;

		return $post_id;
	}
}

function themify_get_placeholder_image() {
	static $placeholder_image = null;

	if( $placeholder_image == null ) {
		if ( ! function_exists( 'WP_Filesystem' ) ) {
			require_once ABSPATH . 'wp-admin/includes/file.php';
		}
		WP_Filesystem();
		global $wp_filesystem;
		$upload = wp_upload_bits( $post['post_name'] . '.jpg', null, $wp_filesystem->get_contents( THEMIFY_DIR . '/img/image-placeholder.jpg' ) );

		if ( $info = wp_check_filetype( $upload['file'] ) )
			$post['post_mime_type'] = $info['type'];
		else
			return new WP_Error( 'attachment_processing_error', __( 'Invalid file type', 'themify' ) );

		$post['guid'] = $upload['url'];
		$post_id = wp_insert_attachment( $post, $upload['file'] );
		wp_update_attachment_metadata( $post_id, wp_generate_attachment_metadata( $post_id, $upload['file'] ) );

		$placeholder_image = $post_id;
	}

	return $placeholder_image;
}

function themify_import_term( $term ) {
	global $processed_terms;

	if( $term_id = term_exists( $term['slug'], $term['taxonomy'] ) ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];
		if ( isset( $term['term_id'] ) )
			$processed_terms[ intval( $term['term_id'] ) ] = (int) $term_id;
		return (int) $term_id;
	}

	if ( empty( $term['parent'] ) ) {
		$parent = 0;
	} else {
		$parent = term_exists( $processed_terms[ intval( $term['parent'] ) ], $term['taxonomy'] );
		if ( is_array( $parent ) ) $parent = $parent['term_id'];
	}

	$id = wp_insert_term( $term['name'], $term['taxonomy'], array(
		'parent' => $parent,
		'slug' => $term['slug'],
		'description' => $term['description'],
	) );
	if ( ! is_wp_error( $id ) ) {
		if ( isset( $term['term_id'] ) ) {
			// success!
			$processed_terms[ intval($term['term_id']) ] = $id['term_id'];
			if ( isset( $term['thumbnail'] ) ) {
				themify_add_import_action( 'term_thumb', array(
					'id' => $id['term_id'],
					'thumb' => $term['thumbnail'],
				) );
			}
			return $term['term_id'];
		}
	}

	return false;
}

function themify_get_term_id_by_slug( $slug, $tax ) {
	$term = get_term_by( 'slug', $slug, $tax );
	if( $term ) {
		return $term->term_id;
	}

	return false;
}

function themify_undo_import_term( $term ) {
	$term_id = term_exists( $term['slug'], $term['taxonomy'] );
	if ( $term_id ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];

		if ( $term_thumbnail = get_term_meta( $term['term_id'], 'thumbnail_id', true ) ) {
			wp_delete_attachment( $term_thumbnail, true );
		}

		if ( isset( $term_id ) ) {
			wp_delete_term( $term_id, $term['taxonomy'] );
		}
	}
}

/**
 * Determine if a post exists based on title, content, and date
 *
 * @global wpdb $wpdb WordPress database abstraction object.
 *
 * @param array $args array of database parameters to check
 * @return int Post ID if post exists, 0 otherwise.
 */
function themify_post_exists( $args = array() ) {
	global $wpdb;

	$query = "SELECT ID FROM $wpdb->posts WHERE 1=1";
	$db_args = array();

	foreach ( $args as $key => $value ) {
		$value = wp_unslash( sanitize_post_field( $key, $value, 0, 'db' ) );
		if( ! empty( $value ) ) {
			$query .= ' AND ' . $key . ' = %s';
			$db_args[] = $value;
		}
	}

	if ( !empty ( $args ) )
		return (int) $wpdb->get_var( $wpdb->prepare($query, $args) );

	return 0;
}

function themify_undo_import_post( $post ) {
	if( $post['post_type'] == 'nav_menu_item' ) {
		$post_exists = themify_post_exists( array(
			'post_name' => $post['post_name'],
			'post_modified' => $post['post_date'],
			'post_type' => 'nav_menu_item',
		) );
	} else {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
	}
	if( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
		/**
		 * check if the post has been modified, if so leave it be
		 *
		 * NOTE: posts are imported using wp_insert_post() which modifies post_modified field
		 * to be the same as post_date, hence to check if the post has been modified,
		 * the post_modified field is compared against post_date in the original post.
		 */
		if( $post['post_date'] == get_post_field( 'post_modified', $post_exists ) ) {
			// find and remove all post attachments
			$attachments = get_posts( array(
				'post_type' => 'attachment',
				'posts_per_page' => -1,
				'post_parent' => $post_exists,
			) );
			if ( $attachments ) {
				foreach ( $attachments as $attachment ) {
					wp_delete_attachment( $attachment->ID, true );
				}
			}
			wp_delete_post( $post_exists, true ); // true: bypass trash
		}
	}
}

function themify_process_post_import( $post ) {
	if( ERASEDEMO ) {
		themify_undo_import_post( $post );
	} else {
		if ( $id = themify_import_post( $post ) ) {
			if ( defined( 'IMPORT_IMAGES' ) && ! IMPORT_IMAGES ) {
				/* if importing images is disabled and post is supposed to have a thumbnail, create a placeholder image instead */
				if ( isset( $post['thumb'] ) ) { // the post is supposed to have featured image
					$placeholder = themify_get_placeholder_image();
					if( ! is_wp_error( $placeholder ) ) {
						set_post_thumbnail( $id, $placeholder );
					}
				}
			} else {
				if ( isset( $post["thumb"] ) ) {
					themify_add_import_action( 'post_thumb', array(
						'id' => $id,
						'thumb' => $post["thumb"],
					) );
				}
				if ( isset( $post["gallery_shortcode"] ) ) {
					themify_add_import_action( 'gallery_field', array(
						'id' => $id,
						'fields' => $post["gallery_shortcode"],
					) );
				}
				if ( isset( $post["_product_image_gallery"] ) ) {
					themify_add_import_action( 'product_gallery', array(
						'id' => $id,
						'images' => $post["_product_image_gallery"],
					) );
				}
			}
		}
	}
}
$thumbs = array();
function themify_do_demo_import() {
global $import_actions;

	if ( isset( $GLOBALS["ThemifyBuilder_Data_Manager"] ) ) {
		remove_action( "save_post", array( $GLOBALS["ThemifyBuilder_Data_Manager"], "save_builder_text_only"), 10, 3 );
	}
$term = array (
  'term_id' => 2,
  'name' => 'Main Navigation',
  'slug' => 'main-navigation',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 3,
  'name' => 'Footer',
  'slug' => 'footer',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$post = array (
  'ID' => 5,
  'post_date' => '2018-12-19 04:55:01',
  'post_date_gmt' => '2018-12-19 04:55:01',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h1>The Latest Book<br />Has Arrived!</h1> <p>Read the dazzling new novel by <em>New York Times Bestselling</em> author.</p> <p>"<em>A heart-breakingly beautiful story of lost love and new lovers. Illuminating, rich, and tear jerking - you won\'t be able to put this down!</em>" - Associated Press</p>
<a href="https://themify.me/" > Buy Now </a>
<img src="https://themify.me/demo/themes/ultra-ebook/files/2018/12/woman-hold-ebook-500x691.png" width="500" alt="woman hold ebook" srcset="https://themify.me/demo/themes/ultra-ebook/files/2018/12/woman-hold-ebook-500x691.png 500w, https://themify.me/demo/themes/ultra-ebook/files/2018/12/woman-hold-ebook-217x300.png 217w, https://themify.me/demo/themes/ultra-ebook/files/2018/12/woman-hold-ebook.png 510w" sizes="(max-width: 500px) 100vw, 500px" />
<p>There wasn\'t much left of me after him. He had entered my life in one brilliant moment, and swooped out just as suddenly.</p>
<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.</p> <p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio.</p>
<h3>About</h3>
<p>“The story came to me in a dream and gripped my every waking thought. Soul and tears were poured into this novel, and I hope it wakes and soothes your heart.”</p>
<img src="https://themify.me/demo/themes/ultra-ebook/files/2018/12/signature-180x137.png" width="180" height="137" alt="signature" srcset="https://themify.me/demo/themes/ultra-ebook/files/2018/12/signature-180x137.png 180w, https://themify.me/demo/themes/ultra-ebook/files/2018/12/signature.png 248w" sizes="(max-width: 180px) 100vw, 180px" />
<h3>Now Available on Kindle</h3> <p> Kindle, Kobo, Nook, iBooks, or tablet - download the latest novel in an instant and be transported into another world.</p>
<img src="https://themify.me/demo/themes/ultra-ebook/files/2018/12/new-book-chapter-1000x320.png" width="1000" alt="new book chapter" srcset="https://themify.me/demo/themes/ultra-ebook/files/2018/12/new-book-chapter-1000x320.png 1000w, https://themify.me/demo/themes/ultra-ebook/files/2018/12/new-book-chapter-600x192.png 600w, https://themify.me/demo/themes/ultra-ebook/files/2018/12/new-book-chapter-768x246.png 768w, https://themify.me/demo/themes/ultra-ebook/files/2018/12/new-book-chapter.png 1152w" sizes="(max-width: 1000px) 100vw, 1000px" />
<a href="https://themify.me/" > Buy Now </a>
<h3>Also <br />Available</h3>
<img src="https://themify.me/demo/themes/ultra-ebook/files/2018/12/amazon-logo-155x49.png" width="155" alt="amazon logo" srcset="https://themify.me/demo/themes/ultra-ebook/files/2018/12/amazon-logo-155x49.png 155w, https://themify.me/demo/themes/ultra-ebook/files/2018/12/amazon-logo.png 152w" sizes="(max-width: 155px) 100vw, 155px" />
<img src="https://themify.me/demo/themes/ultra-ebook/files/2018/12/ebay-160x62.png" width="160" alt="ebay" srcset="https://themify.me/demo/themes/ultra-ebook/files/2018/12/ebay-160x62.png 160w, https://themify.me/demo/themes/ultra-ebook/files/2018/12/ebay.png 161w" sizes="(max-width: 160px) 100vw, 160px" />
<img src="https://themify.me/demo/themes/ultra-ebook/files/2018/12/kindle-logo-166x59.png" width="166" alt="kindle logo" srcset="https://themify.me/demo/themes/ultra-ebook/files/2018/12/kindle-logo.png 166w, https://themify.me/demo/themes/ultra-ebook/files/2018/12/kindle-logo-160x56.png 160w" sizes="(max-width: 166px) 100vw, 166px" />
<img src="https://themify.me/demo/themes/ultra-ebook/files/2018/12/barnes-noble-115x69.png" width="115" alt="barnes noble" />
<h3>Book Reviews</h3>
<ul data-id="tb_bcfa70f" data-visible="3" data-mob-visible="1" data-scroll="1" data-auto-scroll="off" data-speed="1" data-wrap="yes" data-arrow="no" data-pagination="yes" data-effect="scroll" data-height="variable" data-pause-on-hover="resume" data-horizontal="" > <li> 
 <p>" Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae illo inventore veritatis quasi architecto beatae vitae dicta explicabo " </p> <figure><img src="https://themify.me/demo/themes/ultra-ebook/files/2018/12/face4-40x40.jpg" width="40" height="40" alt="face4" srcset="https://themify.me/demo/themes/ultra-ebook/files/2018/12/face4-40x40.jpg 40w, https://themify.me/demo/themes/ultra-ebook/files/2018/12/face4-150x150.jpg 150w, https://themify.me/demo/themes/ultra-ebook/files/2018/12/face4-300x300.jpg 300w, https://themify.me/demo/themes/ultra-ebook/files/2018/12/face4-100x100.jpg 100w, https://themify.me/demo/themes/ultra-ebook/files/2018/12/face4.jpg 500w" sizes="(max-width: 40px) 100vw, 40px" /></figure> John Smithe New York Times </li> <li> 
 <p>" Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequ untur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque por ro quis quam est, qui dolorem ipsum quia "</p> <figure><img src="https://themify.me/demo/themes/ultra-ebook/files/2018/12/face5-40x40.jpg" width="40" height="40" alt="face5" srcset="https://themify.me/demo/themes/ultra-ebook/files/2018/12/face5-40x40.jpg 40w, https://themify.me/demo/themes/ultra-ebook/files/2018/12/face5-150x150.jpg 150w, https://themify.me/demo/themes/ultra-ebook/files/2018/12/face5-300x300.jpg 300w, https://themify.me/demo/themes/ultra-ebook/files/2018/12/face5-100x100.jpg 100w, https://themify.me/demo/themes/ultra-ebook/files/2018/12/face5.jpg 500w" sizes="(max-width: 40px) 100vw, 40px" /></figure> Nadia Schultz Vanity Fair </li> <li> 
 <p>" At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium sit quasi architecto beatae vitae dicta sunt explicabo voluptatum deleniti atque corrupti quos dolores et quas molestias "</p> <figure><img src="https://themify.me/demo/themes/ultra-ebook/files/2018/12/face8-40x40.jpg" width="40" height="40" alt="face8" srcset="https://themify.me/demo/themes/ultra-ebook/files/2018/12/face8-40x40.jpg 40w, https://themify.me/demo/themes/ultra-ebook/files/2018/12/face8-150x150.jpg 150w, https://themify.me/demo/themes/ultra-ebook/files/2018/12/face8-300x300.jpg 300w, https://themify.me/demo/themes/ultra-ebook/files/2018/12/face8-100x100.jpg 100w, https://themify.me/demo/themes/ultra-ebook/files/2018/12/face8.jpg 500w" sizes="(max-width: 40px) 100vw, 40px" /></figure> Jonathan Webber Film Director </li> <li> 
 <p>Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor </p> <figure><img src="https://themify.me/demo/themes/ultra-ebook/files/2018/12/face6-1-40x40.jpg" width="40" height="40" alt="face6" srcset="https://themify.me/demo/themes/ultra-ebook/files/2018/12/face6-1-40x40.jpg 40w, https://themify.me/demo/themes/ultra-ebook/files/2018/12/face6-1-150x150.jpg 150w, https://themify.me/demo/themes/ultra-ebook/files/2018/12/face6-1-300x300.jpg 300w, https://themify.me/demo/themes/ultra-ebook/files/2018/12/face6-1.jpg 500w" sizes="(max-width: 40px) 100vw, 40px" /></figure> Tammy Fransesca Editor in Chief </li> </ul>
<h3>Get the First <br />Three Chapters, <br /><strong>Free.</strong></h3> <p>Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.</p>
<form action="//themify.us2.list-manage.com/subscribe/post?u=03462cf158e86ea00590274ab&amp;id=0f2a95e5de" method="post" id="mc-embedded-subscribe-form" name="mc-embedded-subscribe-form" target="_blank" novalidate> <input type="email" value="" name="EMAIL" id="mce-EMAIL"> <input type="submit" value="Subscribe" name="subscribe" id="mc-embedded-subscribe"> <input type="text" name="b_03462cf158e86ea00590274ab_0f2a95e5de" tabindex="-1" value=""> </form>
<img src="https://themify.me/demo/themes/ultra-ebook/files/2018/12/book-550x692.png" width="550" alt="book" srcset="https://themify.me/demo/themes/ultra-ebook/files/2018/12/book-550x692.png 550w, https://themify.me/demo/themes/ultra-ebook/files/2018/12/book-238x300.png 238w, https://themify.me/demo/themes/ultra-ebook/files/2018/12/book.png 549w" sizes="(max-width: 550px) 100vw, 550px" />
<img src="https://themify.me/demo/themes/ultra-ebook/files/2018/12/woman-ebook-706x662.png" width="706" alt="woman ebook" srcset="https://themify.me/demo/themes/ultra-ebook/files/2018/12/woman-ebook.png 706w, https://themify.me/demo/themes/ultra-ebook/files/2018/12/woman-ebook-300x281.png 300w" sizes="(max-width: 706px) 100vw, 706px" />
<h3>About the Author</h3> <p>Since quitting her job as a project manager, she hasn\'t looked back. Her books have received <em>Bestseller</em> accolades, and translated into twenty-nine languages, with over twelve million copies sold worldwide. In addition, three of her novels have been optioned for the big screen and are in various stages of development.</p>
<a href="https://facebook.com/themify"> </a> <a href="https://twitter.com/themify"> </a> <a href="https://www.linkedin.com/company/themify/"> </a>
<h3>Get in touch</h3>
<form action="https://themify.me/demo/themes/ultra-ebook/wp-admin/admin-ajax.php" id="contact-0--form" method="post"> <label for="contact-0--contact-name">Your Name </label> <input type="text" name="contact-name" placeholder="" id="contact-0--contact-name" value="" /> <label for="contact-0--contact-email">Your Email </label> <input type="text" name="contact-email" placeholder="" id="contact-0--contact-email" value="" /> <label for="contact-0--contact-subject">Subject *</label> <input type="text" name="contact-subject" placeholder="" id="contact-0--contact-subject" value="" required /> <label for="contact-0--contact-message">Message *</label> <textarea name="contact-message" placeholder="" id="contact-0--contact-message" rows="8" cols="45" required></textarea> <button type="submit"> Submit </button> </form>
<p>Or you can email us directly at : <a href="eBook@site.com">eBook@site.com</a></p><!--/themify_builder_static-->',
  'post_title' => 'Home',
  'post_excerpt' => '',
  'post_name' => 'home',
  'post_modified' => '2019-09-19 15:28:02',
  'post_modified_gmt' => '2019-09-19 15:28:02',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-ebook/?page_id=5',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'section_scrolling_style' => 'single',
    'header_design' => 'header-horizontal',
    'mobile_menu_styles' => 'default',
    'header_wrap' => 'transparent',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"d24f15c\\",\\"cols\\":[{\\"element_id\\":\\"69d721f\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"da8bf0c\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_size_h1\\":\\"4\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_size_h1\\":\\"3\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_size_h1\\":\\"3\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<h1>The Latest Book<br \\\\/>Has Arrived!<\\\\/h1>\\\\n<p>Read the dazzling new novel by <em>New York Times Bestselling<\\\\/em> author.<\\\\/p>\\\\n<p>\\\\\\\\\\\\\\"<em>A heart-breakingly beautiful story of lost love and new lovers. Illuminating, rich, and tear jerking - you won\\\\\\\\\\\'t be able to put this down!<\\\\/em>\\\\\\\\\\\\\\" - Associated Press<\\\\/p>\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"3b3b866\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"border-type\\":\\"top\\",\\"button_background_color\\":\\"#333333\\",\\"link_color\\":\\"#eae7e0\\",\\"link_border-type\\":\\"top\\",\\"buttons_size\\":\\"large\\",\\"buttons_shape\\":\\"squared\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Buy Now\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\",\\"button_color_bg\\":\\"tb_default_color\\"}]}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-ebook\\\\/files\\\\/2018\\\\/12\\\\/bg-ornament-left.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"8\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"556d671\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"4f26d43\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"},\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-ebook\\\\/files\\\\/2018\\\\/12\\\\/woman-hold-ebook-500x691.png\\",\\"width_image\\":\\"500\\",\\"param_image\\":\\"regular\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-ebook\\\\/files\\\\/2018\\\\/12\\\\/bg-hero-top.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-top\\",\\"background_color\\":\\"#eae7e0\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth-content\\",\\"row_anchor\\":\\"new-release\\",\\"row_scroll_direction\\":\\"module_row_section\\"}},{\\"element_id\\":\\"106d8b4\\",\\"cols\\":[{\\"element_id\\":\\"e78aaa5\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ab05cb7\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_family\\":\\"Playfair Display\\",\\"element_font_weight\\":\\"regular\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1.7\\",\\"font_size_unit\\":\\"em\\",\\"line_height\\":\\"1.2\\",\\"line_height_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"dropcap_font_size\\":\\"2.9\\",\\"dropcap_font_size_unit\\":\\"em\\",\\"dropcap_padding_top\\":\\"8\\",\\"dropcap_padding_right\\":\\"20\\",\\"dropcap_padding_bottom\\":\\"8\\",\\"dropcap_padding_left\\":\\"20\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>There wasn\\\\\\\\\\\'t much left of me after him. He had entered my life in one brilliant moment, and swooped out just as suddenly.<\\\\/p>\\",\\"text_drop_cap\\":\\"dropcap\\",\\"dropcap_line_height_unit\\":\\"em\\",\\"dropcap_line_height\\":\\"1\\",\\"dropcap_padding_opp_left\\":\\"1\\",\\"dropcap_padding_opp_top\\":\\"1\\",\\"dropcap_background_color\\":\\"#daa36d\\",\\"background_image-type\\":\\"image\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"0d77fd3\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.<\\\\/p>\\\\n<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio.<\\\\/p>\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}]},{\\"element_id\\":\\"b665071\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"369761d\\",\\"mod_settings\\":{\\"background_image\\":\\"https://themify.me/demo/themes/ultra-ebook\\\\/files\\\\/2018\\\\/12\\\\/bg-doodle-line-title.png\\",\\"background_repeat\\":\\"no-repeat\\",\\"background_position\\":\\"left-bottom\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"6\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"4\\",\\"font_size_h3_unit\\":\\"em\\",\\"h3_margin_bottom\\":\\"10\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"no-repeat\\",\\"background_position\\":\\"left-bottom\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"3\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"no-repeat\\",\\"background_position\\":\\"left-bottom\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"3\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<h3>About<\\\\/h3>\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"b026c53\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_family\\":\\"Playfair Display\\",\\"element_font_weight\\":\\"regular\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"28\\",\\"line_height\\":\\"44\\",\\"font_style_regular\\":\\"italic\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>“The story came to me in a dream and gripped my every waking thought. Soul and tears were poured into this novel, and I hope it wakes and soothes your heart.”<\\\\/p>\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"419e1b3\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-ebook\\\\/files\\\\/2018\\\\/12\\\\/signature-180x137.png\\",\\"width_image\\":\\"180\\",\\"height_image\\":\\"137\\",\\"param_image\\":\\"regular\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_left\\":\\"6\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"row_anchor\\":\\"about\\",\\"row_scroll_direction\\":\\"module_row_section\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"15\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"0a10b0c\\",\\"cols\\":[{\\"element_id\\":\\"3041fb2\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"d82ebf5\\",\\"cols\\":[{\\"element_id\\":\\"bf3403a\\",\\"grid_class\\":\\"col4-1\\"},{\\"element_id\\":\\"6c45a81\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"eb13209\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"3\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"2.2\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<h3>Now Available on Kindle<\\\\/h3>\\\\n<p> Kindle, Kobo, Nook, iBooks, or tablet - download the latest novel in an instant and be transported into another world.<\\\\/p>\\"}}]},{\\"element_id\\":\\"6f9f957\\",\\"grid_class\\":\\"col4-1\\"}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"5cde299\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"4\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-ebook\\\\/files\\\\/2018\\\\/12\\\\/new-book-chapter-1000x320.png\\",\\"width_image\\":\\"1000\\",\\"param_image\\":\\"regular\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"}}},{\\"element_id\\":\\"b55042c\\",\\"cols\\":[{\\"element_id\\":\\"5bd74f1\\",\\"grid_class\\":\\"col4-1\\"},{\\"element_id\\":\\"64a3df1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"eb8bdaf\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"border-type\\":\\"top\\",\\"button_background_color\\":\\"#daa36d\\",\\"link_color\\":\\"#000000\\",\\"link_border-type\\":\\"top\\",\\"buttons_size\\":\\"large\\",\\"buttons_shape\\":\\"squared\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Buy Now\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\",\\"button_color_bg\\":\\"tb_default_color\\"}],\\"b_p\\":\\"left-top\\",\\"b_r\\":\\"repeat\\",\\"b_i-type\\":\\"image\\"}}]},{\\"element_id\\":\\"00d11a7\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"0362f0c\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"right\\",\\"padding_right\\":\\"32\\",\\"margin_bottom\\":\\"-80\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_family_h3\\":\\"Playfair Display\\",\\"font_weight_h3\\":\\"regular\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_h3\\":\\"#ffffff_0.60\\",\\"font_gradient_color_h3-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size_h3\\":\\"31\\",\\"line_height_h3\\":\\"41\\",\\"font_style_h3_regular\\":\\"italic\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Also <br \\\\/>Available<\\\\/h3>\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"right\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_family_h3\\":\\"Playfair Display\\",\\"font_weight_h3\\":\\"regular\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"18\\",\\"line_height_h3\\":\\"19\\",\\"font_style_h3_regular\\":\\"italic\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"4\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"853cbc4\\",\\"cols\\":[{\\"element_id\\":\\"5c826ef\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"b73f8a2\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-ebook\\\\/files\\\\/2018\\\\/12\\\\/amazon-logo-155x49.png\\",\\"width_image\\":\\"155\\",\\"param_image\\":\\"regular\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top\\":\\"10\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"}}}]},{\\"element_id\\":\\"27109df\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"f453276\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-ebook\\\\/files\\\\/2018\\\\/12\\\\/ebay-160x62.png\\",\\"width_image\\":\\"160\\",\\"param_image\\":\\"regular\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top\\":\\"10\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"}}}]},{\\"element_id\\":\\"765e8bf\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"91deaee\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-ebook\\\\/files\\\\/2018\\\\/12\\\\/kindle-logo.png\\",\\"width_image\\":\\"166\\",\\"param_image\\":\\"regular\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top\\":\\"10\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"}}}]},{\\"element_id\\":\\"8361ccd\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"da4f846\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-ebook\\\\/files\\\\/2018\\\\/12\\\\/barnes-noble.png\\",\\"width_image\\":\\"115\\",\\"param_image\\":\\"regular\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top\\":\\"10\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"}}}]}],\\"column_alignment\\":\\"col_align_bottom\\",\\"col_tablet\\":\\"column4-2\\",\\"col_mobile\\":\\"column4-2\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-ebook\\\\/files\\\\/2018\\\\/12\\\\/arrow.png\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"8\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top\\":\\"-27\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top\\":\\"15\\",\\"border-type\\":\\"top\\"}}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#282828\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#ffffff\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth\\",\\"row_anchor\\":\\"ordering\\",\\"row_scroll_direction\\":\\"module_row_section\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"15\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"2a2486d\\",\\"cols\\":[{\\"element_id\\":\\"5473211\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"cea5bc5\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"3\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Book Reviews<\\\\/h3>\\"}},{\\"mod_name\\":\\"testimonial-slider\\",\\"element_id\\":\\"bcfa70f\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_p_container_apply_all\\":\\"1\\",\\"b_container-type\\":\\"top\\",\\"checkbox_content_padding_apply_all\\":\\"1\\",\\"content_border-type\\":\\"top\\",\\"layout_testimonial\\":\\"image-bottom\\",\\"tab_content_testimonial\\":[{\\"content_testimonial\\":\\"<p>\\\\\\\\\\\\\\" Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae illo inventore veritatis quasi architecto beatae vitae dicta explicabo \\\\\\\\\\\\\\" <\\\\/p>\\",\\"person_picture_testimonial\\":\\"https://themify.me/demo/themes/ultra-ebook\\\\/files\\\\/2018\\\\/12\\\\/face4-40x40.jpg\\",\\"person_name_testimonial\\":\\"John Smithe\\",\\"person_position_testimonial\\":\\"New York Times\\"},{\\"content_testimonial\\":\\"<p>\\\\\\\\\\\\\\" Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequ untur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque por ro quis quam est, qui dolorem ipsum quia \\\\\\\\\\\\\\"<\\\\/p>\\",\\"person_picture_testimonial\\":\\"https://themify.me/demo/themes/ultra-ebook\\\\/files\\\\/2018\\\\/12\\\\/face5-40x40.jpg\\",\\"person_name_testimonial\\":\\"Nadia Schultz\\",\\"person_position_testimonial\\":\\"Vanity Fair\\"},{\\"content_testimonial\\":\\"<p>\\\\\\\\\\\\\\" At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium sit quasi architecto beatae vitae dicta sunt explicabo voluptatum deleniti atque corrupti quos dolores et quas molestias \\\\\\\\\\\\\\"<\\\\/p>\\",\\"person_picture_testimonial\\":\\"https://themify.me/demo/themes/ultra-ebook\\\\/files\\\\/2018\\\\/12\\\\/face8-40x40.jpg\\",\\"person_name_testimonial\\":\\"Jonathan Webber\\",\\"person_position_testimonial\\":\\"Film Director\\"},{\\"content_testimonial\\":\\"<p>Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor <\\\\/p>\\",\\"person_picture_testimonial\\":\\"https://themify.me/demo/themes/ultra-ebook\\\\/files\\\\/2018\\\\/12\\\\/face6-1-40x40.jpg\\",\\"person_name_testimonial\\":\\"Tammy Fransesca\\",\\"person_position_testimonial\\":\\"Editor in Chief\\"}],\\"img_w_slider\\":\\"40\\",\\"img_h_slider\\":\\"40\\",\\"visible_opt_slider\\":\\"3\\",\\"mob_visible_opt_slider\\":\\"1\\",\\"auto_scroll_opt_slider\\":\\"off\\",\\"scroll_opt_slider\\":\\"1\\",\\"speed_opt_slider\\":\\"normal\\",\\"effect_slider\\":\\"scroll\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"wrap_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"yes\\",\\"show_arrow_slider\\":\\"no\\",\\"height_slider\\":\\"variable\\"}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#ebe7df\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"7\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"7\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth\\",\\"row_anchor\\":\\"testimonial\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"15\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"4dce1d6\\",\\"cols\\":[{\\"element_id\\":\\"56af4ba\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"5050cd2\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"3\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Get the First <br \\\\/>Three Chapters, <br \\\\/><strong>Free.<\\\\/strong><\\\\/h3>\\\\n<p>Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.<\\\\/p>\\"}},{\\"mod_name\\":\\"plain-text\\",\\"element_id\\":\\"1468dc7\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"plain_text\\":\\"<div id=\\\\\\\\\\\\\\"mc_embed_signup\\\\\\\\\\\\\\">\\\\n\\\\t<form action=\\\\\\\\\\\\\\"\\\\/\\\\/themify.us2.list-manage.com\\\\/subscribe\\\\/post?u=03462cf158e86ea00590274ab&amp;id=0f2a95e5de\\\\\\\\\\\\\\" method=\\\\\\\\\\\\\\"post\\\\\\\\\\\\\\" id=\\\\\\\\\\\\\\"mc-embedded-subscribe-form\\\\\\\\\\\\\\" name=\\\\\\\\\\\\\\"mc-embedded-subscribe-form\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\"validate\\\\\\\\\\\\\\" target=\\\\\\\\\\\\\\"_blank\\\\\\\\\\\\\\" novalidate>\\\\n\\\\t\\\\t<div id=\\\\\\\\\\\\\\"mc_embed_signup_scroll\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t<div class=\\\\\\\\\\\\\\"mc-field-group\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t\\\\t<input type=\\\\\\\\\\\\\\"email\\\\\\\\\\\\\\" value=\\\\\\\\\\\\\\"\\\\\\\\\\\\\\" name=\\\\\\\\\\\\\\"EMAIL\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\"required email\\\\\\\\\\\\\\" id=\\\\\\\\\\\\\\"mce-EMAIL\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t\\\\t<input type=\\\\\\\\\\\\\\"submit\\\\\\\\\\\\\\" value=\\\\\\\\\\\\\\"Subscribe\\\\\\\\\\\\\\" name=\\\\\\\\\\\\\\"subscribe\\\\\\\\\\\\\\" id=\\\\\\\\\\\\\\"mc-embedded-subscribe\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\"button\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t<\\\\/div>\\\\n\\\\t\\\\t\\\\t<div id=\\\\\\\\\\\\\\"mce-responses\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\"clear\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t\\\\t<div class=\\\\\\\\\\\\\\"response\\\\\\\\\\\\\\" id=\\\\\\\\\\\\\\"mce-error-response\\\\\\\\\\\\\\" style=\\\\\\\\\\\\\\"display:none\\\\\\\\\\\\\\"><\\\\/div>\\\\n\\\\t\\\\t\\\\t\\\\t<div class=\\\\\\\\\\\\\\"response\\\\\\\\\\\\\\" id=\\\\\\\\\\\\\\"mce-success-response\\\\\\\\\\\\\\" style=\\\\\\\\\\\\\\"display:none\\\\\\\\\\\\\\"><\\\\/div>\\\\n\\\\t\\\\t\\\\t<\\\\/div>\\\\n\\\\t\\\\t\\\\t<!-- real people should not fill this in and expect good things - do not remove this or risk form bot signups-->\\\\n\\\\t\\\\t\\\\t<div style=\\\\\\\\\\\\\\"position: absolute; left: -5000px;\\\\\\\\\\\\\\" aria-hidden=\\\\\\\\\\\\\\"true\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t\\\\t<input type=\\\\\\\\\\\\\\"text\\\\\\\\\\\\\\" name=\\\\\\\\\\\\\\"b_03462cf158e86ea00590274ab_0f2a95e5de\\\\\\\\\\\\\\" tabindex=\\\\\\\\\\\\\\"-1\\\\\\\\\\\\\\" value=\\\\\\\\\\\\\\"\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t<\\\\/div>\\\\n\\\\t\\\\t<\\\\/div>\\\\n\\\\t<\\\\/form>\\\\n<\\\\/div>\\\\n<script type=\\\\\\\\\\\'text\\\\/javascript\\\\\\\\\\\' src=\\\\\\\\\\\'\\\\/\\\\/s3.amazonaws.com\\\\/downloads.mailchimp.com\\\\/js\\\\/mc-validate.js\\\\\\\\\\\'><\\\\/script><script type=\\\\\\\\\\\'text\\\\/javascript\\\\\\\\\\\'>(function($) {window.fnames = new Array(); window.ftypes = new Array();fnames[0]=\\\\\\\\\\\'EMAIL\\\\\\\\\\\';ftypes[0]=\\\\\\\\\\\'email\\\\\\\\\\\';fnames[1]=\\\\\\\\\\\'FNAME\\\\\\\\\\\';ftypes[1]=\\\\\\\\\\\'text\\\\\\\\\\\';fnames[2]=\\\\\\\\\\\'LNAME\\\\\\\\\\\';ftypes[2]=\\\\\\\\\\\'text\\\\\\\\\\\';fnames[5]=\\\\\\\\\\\'HOMEPAGE\\\\\\\\\\\';ftypes[5]=\\\\\\\\\\\'text\\\\\\\\\\\';}(jQuery));var $mcj = jQuery.noConflict(true);<\\\\/script>\\\\n\\\\n<style>\\\\n#pagewrap #mc_embed_signup input[type=\\\\\\\\\\\\\\"email\\\\\\\\\\\\\\"] {\\\\n\\\\tborder: 1px solid #686868;\\\\n\\\\tdisplay: inline-block;\\\\n\\\\tmax-width: 306px;\\\\n\\\\tmargin-right: 6px;\\\\n\\\\tvertical-align: top;\\\\n}\\\\n<\\\\/style>\\"}}]},{\\"element_id\\":\\"710325a\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"a728fe1\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-ebook\\\\/files\\\\/2018\\\\/12\\\\/book-550x692.png\\",\\"width_image\\":\\"550\\",\\"param_image\\":\\"regular\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"20\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"}}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-ebook\\\\/files\\\\/2018\\\\/12\\\\/bg-doodle-line-1024x281.png\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth\\",\\"row_anchor\\":\\"book\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"953a196\\",\\"cols\\":[{\\"element_id\\":\\"25ba29c\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"2a1c960\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"-123\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-ebook\\\\/files\\\\/2018\\\\/12\\\\/woman-ebook.png\\",\\"width_image\\":\\"706\\",\\"param_image\\":\\"regular\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"20\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"20\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"}}}]},{\\"element_id\\":\\"0c794ba\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"0beb0a0\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"4\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"7\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"10\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"3\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<h3>About the Author<\\\\/h3>\\\\n<p>Since quitting her job as a project manager, she hasn\\\\\\\\\\\'t looked back. Her books have received <em>Bestseller<\\\\/em> accolades, and translated into twenty-nine languages, with over twelve million copies sold worldwide. In addition, three of her novels have been optioned for the big screen and are in various stages of development.<\\\\/p>\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"ec60bc9\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"background_color_icon\\":\\"#c28f5c\\",\\"font_color_icon\\":\\"#ffffff\\",\\"icon_size\\":\\"large\\",\\"icon_style\\":\\"circle\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"fa-facebook\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/facebook.com\\\\/themify\\",\\"link_options\\":\\"regular\\"},{\\"icon\\":\\"fa-twitter\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/twitter.com\\\\/themify\\",\\"link_options\\":\\"regular\\"},{\\"icon\\":\\"ti-linkedin\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/www.linkedin.com\\\\/company\\\\/themify\\\\/\\",\\"link_options\\":\\"regular\\"}]}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_bottom\\":\\"7\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"column_alignment\\":\\"col_align_bottom\\",\\"tablet_dir\\":\\"rtl\\",\\"mobile_dir\\":\\"rtl\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#daa36d\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#000000\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth\\",\\"row_anchor\\":\\"author\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"19f42a3\\",\\"cols\\":[{\\"element_id\\":\\"9a03cd1\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"bb3f2f6\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#ffffff\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"1.7\\",\\"font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"3\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Get in touch<\\\\/h3>\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"2\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"2\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}},{\\"mod_name\\":\\"contact\\",\\"element_id\\":\\"94735fb\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"2\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"border_inputs-type\\":\\"top\\",\\"background_color_send\\":\\"#ffffff\\",\\"font_color_send\\":\\"#000000\\",\\"border_send-type\\":\\"top\\",\\"checkbox_padding_success_message_apply_all\\":\\"1\\",\\"checkbox_margin_success_message_apply_all\\":\\"1\\",\\"border_success_message-type\\":\\"top\\",\\"checkbox_padding_error_message_apply_all\\":\\"1\\",\\"checkbox_margin_error_message_apply_all\\":\\"1\\",\\"border_error_message-type\\":\\"top\\",\\"layout_contact\\":\\"animated-label\\",\\"gdpr_label\\":\\"I consent to my submitted data being collected and stored\\",\\"field_name_label\\":\\"Your Name\\",\\"field_email_label\\":\\"Your Email\\",\\"field_subject_label\\":\\"Subject\\",\\"field_subject_require\\":\\"yes\\",\\"field_subject_active\\":\\"yes\\",\\"field_message_label\\":\\"Message\\",\\"field_extra\\":\\"{ \\\\\\\\\\\\\\"fields\\\\\\\\\\\\\\": [] }\\",\\"field_sendcopy_label\\":\\"Send a copy to myself\\",\\"field_order\\":\\"{}\\",\\"field_send_label\\":\\"Submit\\",\\"field_send_align\\":\\"center\\",\\"field_email_active\\":\\"yes\\",\\"field_name_active\\":\\"yes\\",\\"field_message_active\\":\\"yes\\",\\"contact_sent_from\\":\\"enable\\",\\"send_to_admins\\":\\"true\\",\\"field_sendcopy_active\\":\\"\\",\\"field_captcha_active\\":\\"\\",\\"field_email_require\\":\\"\\",\\"field_name_require\\":\\"\\",\\"post_author\\":\\"\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"c364dc3\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Or you can email us directly at : <a href=\\\\\\\\\\\\\\"eBook@site.com\\\\\\\\\\\\\\">eBook@site.com<\\\\/a><\\\\/p>\\"}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#262627\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#b8b8b8\\",\\"text_align\\":\\"left\\",\\"link_color\\":\\"#daa36d\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth\\",\\"row_anchor\\":\\"contact\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"text_align\\":\\"left\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"15\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 120,
  'post_date' => '2018-12-19 08:44:01',
  'post_date_gmt' => '2018-12-19 08:44:01',
  'post_content' => '',
  'post_title' => 'Home',
  'post_excerpt' => '',
  'post_name' => 'home-2',
  'post_modified' => '2018-12-19 08:44:01',
  'post_modified_gmt' => '2018-12-19 08:44:01',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-ebook/?p=120',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '120',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#home',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 121,
  'post_date' => '2018-12-19 08:44:01',
  'post_date_gmt' => '2018-12-19 08:44:01',
  'post_content' => '',
  'post_title' => 'About',
  'post_excerpt' => '',
  'post_name' => 'about-2',
  'post_modified' => '2018-12-19 08:44:01',
  'post_modified_gmt' => '2018-12-19 08:44:01',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-ebook/?p=121',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '121',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#about',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 123,
  'post_date' => '2018-12-19 08:44:01',
  'post_date_gmt' => '2018-12-19 08:44:01',
  'post_content' => '',
  'post_title' => 'Ordering',
  'post_excerpt' => '',
  'post_name' => 'ordering-2',
  'post_modified' => '2018-12-19 08:44:01',
  'post_modified_gmt' => '2018-12-19 08:44:01',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-ebook/?p=123',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '123',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#ordering',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 124,
  'post_date' => '2018-12-19 08:44:01',
  'post_date_gmt' => '2018-12-19 08:44:01',
  'post_content' => '',
  'post_title' => 'Testimonial',
  'post_excerpt' => '',
  'post_name' => 'testimonial-2',
  'post_modified' => '2018-12-19 08:44:01',
  'post_modified_gmt' => '2018-12-19 08:44:01',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-ebook/?p=124',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '124',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#testimonial',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 125,
  'post_date' => '2018-12-19 08:44:01',
  'post_date_gmt' => '2018-12-19 08:44:01',
  'post_content' => '',
  'post_title' => 'Author',
  'post_excerpt' => '',
  'post_name' => 'author-2',
  'post_modified' => '2018-12-19 08:44:01',
  'post_modified_gmt' => '2018-12-19 08:44:01',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-ebook/?p=125',
  'menu_order' => 5,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '125',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#author',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 122,
  'post_date' => '2018-12-19 08:44:01',
  'post_date_gmt' => '2018-12-19 08:44:01',
  'post_content' => '',
  'post_title' => 'Contact',
  'post_excerpt' => '',
  'post_name' => 'contact-2',
  'post_modified' => '2018-12-19 08:44:01',
  'post_modified_gmt' => '2018-12-19 08:44:01',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-ebook/?p=122',
  'menu_order' => 6,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '122',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#contact',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 113,
  'post_date' => '2018-12-19 08:40:26',
  'post_date_gmt' => '2018-12-19 08:40:26',
  'post_content' => '',
  'post_title' => 'Home',
  'post_excerpt' => '',
  'post_name' => 'home',
  'post_modified' => '2018-12-19 08:41:02',
  'post_modified_gmt' => '2018-12-19 08:41:02',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-ebook/?p=113',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '113',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#new-release',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 114,
  'post_date' => '2018-12-19 08:40:26',
  'post_date_gmt' => '2018-12-19 08:40:26',
  'post_content' => '',
  'post_title' => 'About',
  'post_excerpt' => '',
  'post_name' => 'about',
  'post_modified' => '2018-12-19 08:41:02',
  'post_modified_gmt' => '2018-12-19 08:41:02',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-ebook/?p=114',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '114',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#about',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 115,
  'post_date' => '2018-12-19 08:40:26',
  'post_date_gmt' => '2018-12-19 08:40:26',
  'post_content' => '',
  'post_title' => 'Ordering',
  'post_excerpt' => '',
  'post_name' => 'ordering',
  'post_modified' => '2018-12-19 08:41:02',
  'post_modified_gmt' => '2018-12-19 08:41:02',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-ebook/?p=115',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '115',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#ordering',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 116,
  'post_date' => '2018-12-19 08:40:26',
  'post_date_gmt' => '2018-12-19 08:40:26',
  'post_content' => '',
  'post_title' => 'Testimonial',
  'post_excerpt' => '',
  'post_name' => 'testimonial',
  'post_modified' => '2018-12-19 08:41:02',
  'post_modified_gmt' => '2018-12-19 08:41:02',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-ebook/?p=116',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '116',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#testimonial',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 117,
  'post_date' => '2018-12-19 08:41:02',
  'post_date_gmt' => '2018-12-19 08:41:02',
  'post_content' => '',
  'post_title' => 'Author',
  'post_excerpt' => '',
  'post_name' => 'author',
  'post_modified' => '2018-12-19 08:41:02',
  'post_modified_gmt' => '2018-12-19 08:41:02',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-ebook/?p=117',
  'menu_order' => 5,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '117',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#author',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 118,
  'post_date' => '2018-12-19 08:41:02',
  'post_date_gmt' => '2018-12-19 08:41:02',
  'post_content' => '',
  'post_title' => 'Contact',
  'post_excerpt' => '',
  'post_name' => 'contact',
  'post_modified' => '2018-12-19 08:41:02',
  'post_modified_gmt' => '2018-12-19 08:41:02',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-ebook/?p=118',
  'menu_order' => 6,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '118',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#contact',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );



function themify_import_get_term_id_from_slug( $slug ) {
	$menu = get_term_by( "slug", $slug, "nav_menu" );
	return is_wp_error( $menu ) ? 0 : (int) $menu->term_id;
}

	$widgets = get_option( "widget_themify-social-links" );
$widgets[1002] = array (
  'title' => '',
  'show_link_name' => NULL,
  'open_new_window' => NULL,
  'icon_size' => 'icon-medium',
  'orientation' => 'horizontal',
);
update_option( "widget_themify-social-links", $widgets );

$widgets = get_option( "widget_search" );
$widgets[1003] = array (
  'title' => '',
);
update_option( "widget_search", $widgets );

$widgets = get_option( "widget_recent-posts" );
$widgets[1004] = array (
  'title' => '',
  'number' => 5,
);
update_option( "widget_recent-posts", $widgets );

$widgets = get_option( "widget_recent-comments" );
$widgets[1005] = array (
  'title' => '',
  'number' => 5,
);
update_option( "widget_recent-comments", $widgets );

$widgets = get_option( "widget_archives" );
$widgets[1006] = array (
  'title' => '',
  'count' => 0,
  'dropdown' => 0,
);
update_option( "widget_archives", $widgets );

$widgets = get_option( "widget_categories" );
$widgets[1007] = array (
  'title' => '',
  'count' => 0,
  'hierarchical' => 0,
  'dropdown' => 0,
);
update_option( "widget_categories", $widgets );

$widgets = get_option( "widget_meta" );
$widgets[1008] = array (
  'title' => '',
);
update_option( "widget_meta", $widgets );

$widgets = get_option( "widget_nav_menu" );
$widgets[1009] = array (
  'nav_menu' => themify_import_get_term_id_from_slug( "main-navigation" ),
);
update_option( "widget_nav_menu", $widgets );

$widgets = get_option( "widget_themify-social-links" );
$widgets[1010] = array (
  'title' => '',
  'show_link_name' => NULL,
  'open_new_window' => NULL,
  'icon_size' => 'icon-medium',
  'orientation' => 'horizontal',
);
update_option( "widget_themify-social-links", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1011] = array (
  'title' => '',
  'text' => '<a class="ui builder_button" href="https://themify.me/"> Buy on Amazon</a>',
  'filter' => true,
  'visual' => true,
);
update_option( "widget_text", $widgets );



$sidebars_widgets = array (
  'wp_inactive_widgets' => 
  array (
    0 => 'themify-social-links-1002',
  ),
  'sidebar-main' => 
  array (
    0 => 'search-1003',
    1 => 'recent-posts-1004',
    2 => 'recent-comments-1005',
    3 => 'archives-1006',
    4 => 'categories-1007',
    5 => 'meta-1008',
  ),
  'footer-widget-1' => 
  array (
    0 => 'nav_menu-1009',
    1 => 'themify-social-links-1010',
  ),
  'footer-widget-2' => 
  array (
    0 => 'text-1011',
  ),
); 
update_option( "sidebars_widgets", $sidebars_widgets );

$menu_locations = array();
$menu = get_terms( "nav_menu", array( "slug" => "main-navigation" ) );
if( is_array( $menu ) && ! empty( $menu ) ) $menu_locations["main-nav"] = $menu[0]->term_id;
$menu = get_terms( "nav_menu", array( "slug" => "footer" ) );
if( is_array( $menu ) && ! empty( $menu ) ) $menu_locations["footer-nav"] = $menu[0]->term_id;
set_theme_mod( "nav_menu_locations", $menu_locations );


$homepage = get_posts( array( 'name' => 'home', 'post_type' => 'page' ) );
			if( is_array( $homepage ) && ! empty( $homepage ) ) {
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $homepage[0]->ID );
			}
			
	ob_start(); ?>a:107:{s:21:"setting-webfonts_list";s:11:"recommended";s:22:"setting-default_layout";s:8:"sidebar1";s:27:"setting-default_post_layout";s:9:"list-post";s:19:"setting-post_filter";s:2:"no";s:23:"setting-disable_masonry";s:3:"yes";s:19:"setting-post_gutter";s:6:"gutter";s:30:"setting-default_layout_display";s:7:"content";s:25:"setting-default_more_text";s:4:"More";s:21:"setting-index_orderby";s:4:"date";s:19:"setting-index_order";s:4:"DESC";s:30:"setting-default_media_position";s:5:"above";s:31:"setting-image_post_feature_size";s:5:"blank";s:32:"setting-default_page_post_layout";s:8:"sidebar1";s:37:"setting-default_page_post_layout_type";s:7:"classic";s:42:"setting-default_page_single_media_position";s:5:"above";s:38:"setting-image_post_single_feature_size";s:5:"blank";s:36:"setting-search-result_layout_display";s:7:"content";s:36:"setting-search-result_media_position";s:5:"above";s:27:"setting-default_page_layout";s:8:"sidebar1";s:40:"setting-custom_post_tglobal_style_single";s:8:"sidebar1";s:38:"setting-default_portfolio_index_layout";s:12:"sidebar-none";s:43:"setting-default_portfolio_index_post_layout";s:5:"grid3";s:29:"setting-portfolio_post_filter";s:3:"yes";s:33:"setting-portfolio_disable_masonry";s:3:"yes";s:24:"setting-portfolio_gutter";s:6:"gutter";s:39:"setting-default_portfolio_index_display";s:4:"none";s:50:"setting-default_portfolio_index_post_meta_category";s:3:"yes";s:49:"setting-default_portfolio_index_unlink_post_image";s:3:"yes";s:39:"setting-default_portfolio_single_layout";s:12:"sidebar-none";s:54:"setting-default_portfolio_single_portfolio_layout_type";s:9:"fullwidth";s:50:"setting-default_portfolio_single_unlink_post_image";s:3:"yes";s:22:"themify_portfolio_slug";s:7:"project";s:53:"setting-customizer_responsive_design_tablet_landscape";s:4:"1280";s:43:"setting-customizer_responsive_design_tablet";s:3:"768";s:43:"setting-customizer_responsive_design_mobile";s:3:"680";s:33:"setting-mobile_menu_trigger_point";s:3:"900";s:24:"setting-gallery_lightbox";s:8:"lightbox";s:27:"setting-page_builder_expiry";s:1:"2";s:21:"setting-header_design";s:17:"header-horizontal";s:28:"setting-exclude_site_tagline";s:2:"on";s:27:"setting-exclude_search_form";s:2:"on";s:19:"setting_search_form";s:11:"live_search";s:19:"setting-exclude_rss";s:2:"on";s:29:"setting-exclude_social_widget";s:2:"on";s:22:"setting-header_widgets";s:17:"headerwidget-3col";s:21:"setting-footer_design";s:22:"footer-horizontal-left";s:32:"setting-exclude_footer_site_logo";s:2:"on";s:38:"setting-exclude_footer_menu_navigation";s:2:"on";s:22:"setting-use_float_back";s:2:"on";s:22:"setting-footer_widgets";s:17:"footerwidget-2col";s:30:"setting-footer_widget_position";s:3:"top";s:23:"setting-mega_menu_posts";s:1:"5";s:29:"setting-mega_menu_image_width";s:3:"180";s:30:"setting-mega_menu_image_height";s:3:"120";s:27:"setting-imagefilter_applyto";s:12:"featuredonly";s:29:"setting-color_animation_speed";s:1:"5";s:29:"setting-relationship_taxonomy";s:8:"category";s:37:"setting-relationship_taxonomy_entries";s:1:"3";s:45:"setting-relationship_taxonomy_display_content";s:4:"none";s:30:"setting-single_slider_autoplay";s:3:"off";s:27:"setting-single_slider_speed";s:6:"normal";s:28:"setting-single_slider_effect";s:5:"slide";s:28:"setting-single_slider_height";s:4:"auto";s:18:"setting-more_posts";s:8:"infinite";s:19:"setting-entries_nav";s:8:"numbered";s:25:"setting-img_php_base_size";s:5:"large";s:27:"setting-global_feature_size";s:5:"blank";s:22:"setting-link_icon_type";s:9:"font-icon";s:32:"setting-link_type_themify-link-0";s:10:"image-icon";s:33:"setting-link_title_themify-link-0";s:7:"Twitter";s:31:"setting-link_img_themify-link-0";s:109:"https://themify.me/demo/themes/ultra-ebook/wp-content/themes/themify-ultra-new/themify/img/social/twitter.png";s:32:"setting-link_type_themify-link-1";s:10:"image-icon";s:33:"setting-link_title_themify-link-1";s:8:"Facebook";s:31:"setting-link_img_themify-link-1";s:110:"https://themify.me/demo/themes/ultra-ebook/wp-content/themes/themify-ultra-new/themify/img/social/facebook.png";s:32:"setting-link_type_themify-link-2";s:10:"image-icon";s:33:"setting-link_title_themify-link-2";s:7:"Google+";s:31:"setting-link_img_themify-link-2";s:113:"https://themify.me/demo/themes/ultra-ebook/wp-content/themes/themify-ultra-new/themify/img/social/google-plus.png";s:32:"setting-link_type_themify-link-3";s:10:"image-icon";s:33:"setting-link_title_themify-link-3";s:7:"YouTube";s:31:"setting-link_img_themify-link-3";s:109:"https://themify.me/demo/themes/ultra-ebook/wp-content/themes/themify-ultra-new/themify/img/social/youtube.png";s:32:"setting-link_type_themify-link-4";s:10:"image-icon";s:33:"setting-link_title_themify-link-4";s:9:"Pinterest";s:31:"setting-link_img_themify-link-4";s:111:"https://themify.me/demo/themes/ultra-ebook/wp-content/themes/themify-ultra-new/themify/img/social/pinterest.png";s:32:"setting-link_type_themify-link-5";s:9:"font-icon";s:32:"setting-link_link_themify-link-5";s:27:"https://twitter.com/themify";s:33:"setting-link_ficon_themify-link-5";s:10:"fa-twitter";s:32:"setting-link_type_themify-link-6";s:9:"font-icon";s:32:"setting-link_link_themify-link-6";s:28:"https://facebook.com/themify";s:33:"setting-link_ficon_themify-link-6";s:11:"fa-facebook";s:32:"setting-link_type_themify-link-7";s:9:"font-icon";s:33:"setting-link_ficon_themify-link-7";s:14:"fa-google-plus";s:32:"setting-link_type_themify-link-8";s:9:"font-icon";s:33:"setting-link_ficon_themify-link-8";s:10:"fa-youtube";s:32:"setting-link_type_themify-link-9";s:9:"font-icon";s:33:"setting-link_ficon_themify-link-9";s:12:"fa-pinterest";s:33:"setting-link_type_themify-link-10";s:9:"font-icon";s:33:"setting-link_link_themify-link-10";s:41:"https://www.linkedin.com/company/themify/";s:34:"setting-link_ficon_themify-link-10";s:11:"fa-linkedin";s:22:"setting-link_field_ids";s:377:"{"themify-link-0":"themify-link-0","themify-link-1":"themify-link-1","themify-link-2":"themify-link-2","themify-link-3":"themify-link-3","themify-link-4":"themify-link-4","themify-link-5":"themify-link-5","themify-link-6":"themify-link-6","themify-link-7":"themify-link-7","themify-link-8":"themify-link-8","themify-link-9":"themify-link-9","themify-link-10":"themify-link-10"}";s:23:"setting-link_field_hash";s:2:"11";s:30:"setting-page_builder_is_active";s:6:"enable";s:41:"setting-page_builder_animation_appearance";s:4:"none";s:42:"setting-page_builder_animation_parallax_bg";s:4:"none";s:46:"setting-page_builder_animation_parallax_scroll";s:6:"mobile";s:44:"setting-page_builder_animation_sticky_scroll";s:4:"none";s:4:"skin";s:5:"ebook";s:13:"import_images";s:2:"on";}<?php $themify_data = unserialize( ob_get_clean() );

	// Fix how "skin" option used to save
	if( isset( $themify_data['skin'] ) ) {
		if ( filter_var( $themify_data['skin'], FILTER_VALIDATE_URL ) ) {
			$parsed_skin = parse_url( $value, PHP_URL_PATH );
			$themify_data['skin'] = basename( dirname( $parsed_skin ) );
		}
	}

	themify_set_data( $themify_data );
	
}
themify_do_demo_import();