<?php

defined( 'ABSPATH' ) or die;

$GLOBALS['processed_terms'] = array();
$GLOBALS['processed_posts'] = array();

require_once ABSPATH . 'wp-admin/includes/post.php';
require_once ABSPATH . 'wp-admin/includes/taxonomy.php';
require_once ABSPATH . 'wp-admin/includes/image.php';

/**
 * Add an Import Action, this data is stored for processing after import is done.
 *
 * Each action is sent as an Ajax request and is handled by themify-ajax.php file
 */ 
function themify_add_import_action( $action = '', $data = array() ) {
	global $import_actions;

	if ( ! isset( $import_actions[ $action ] ) ) {
		$import_actions[ $action ] = array();
	}

	$import_actions[ $action ][] = $data;
}

function themify_import_post( $post ) {
	global $processed_posts, $processed_terms;

	if ( ! post_type_exists( $post['post_type'] ) ) {
		return;
	}

	/* Menu items don't have reliable post_title, skip the post_exists check */
	if( $post['post_type'] !== 'nav_menu_item' ) {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
		if ( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
			$processed_posts[ intval( $post['ID'] ) ] = intval( $post_exists );
			return;
		}
	}

	if( $post['post_type'] == 'nav_menu_item' ) {
		if( ! isset( $post['tax_input']['nav_menu'] ) || ! term_exists( $post['tax_input']['nav_menu'], 'nav_menu' ) ) {
			return;
		}
		$_menu_item_type = $post['meta_input']['_menu_item_type'];
		$_menu_item_object_id = $post['meta_input']['_menu_item_object_id'];

		if ( 'taxonomy' == $_menu_item_type && isset( $processed_terms[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_terms[ intval( $_menu_item_object_id ) ];
		} else if ( 'post_type' == $_menu_item_type && isset( $processed_posts[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_posts[ intval( $_menu_item_object_id ) ];
		} else if ( 'custom' != $_menu_item_type ) {
			// associated object is missing or not imported yet, we'll retry later
			// $missing_menu_items[] = $item;
			return;
		}
	}

	$post_parent = ( $post['post_type'] == 'nav_menu_item' ) ? $post['meta_input']['_menu_item_menu_item_parent'] : (int) $post['post_parent'];
	$post['post_parent'] = 0;
	if ( $post_parent ) {
		// if we already know the parent, map it to the new local ID
		if ( isset( $processed_posts[ $post_parent ] ) ) {
			if( $post['post_type'] == 'nav_menu_item' ) {
				$post['meta_input']['_menu_item_menu_item_parent'] = $processed_posts[ $post_parent ];
			} else {
				$post['post_parent'] = $processed_posts[ $post_parent ];
			}
		}
	}

	/**
	 * for hierarchical taxonomies, IDs must be used so wp_set_post_terms can function properly
	 * convert term slugs to IDs for hierarchical taxonomies
	 */
	if( ! empty( $post['tax_input'] ) ) {
		foreach( $post['tax_input'] as $tax => $terms ) {
			if( is_taxonomy_hierarchical( $tax ) ) {
				$terms = explode( ', ', $terms );
				$post['tax_input'][ $tax ] = array_map( 'themify_get_term_id_by_slug', $terms, array_fill( 0, count( $terms ), $tax ) );
			}
		}
	}

	$post['post_author'] = (int) get_current_user_id();
	$post['post_status'] = 'publish';

	$old_id = $post['ID'];

	unset( $post['ID'] );
	$post_id = wp_insert_post( $post, true );
	if( is_wp_error( $post_id ) ) {
		return false;
	} else {
		$processed_posts[ $old_id ] = $post_id;

		return $post_id;
	}
}

function themify_get_placeholder_image() {
	static $placeholder_image = null;

	if( $placeholder_image == null ) {
		if ( ! function_exists( 'WP_Filesystem' ) ) {
			require_once ABSPATH . 'wp-admin/includes/file.php';
		}
		WP_Filesystem();
		global $wp_filesystem;
		$upload = wp_upload_bits( $post['post_name'] . '.jpg', null, $wp_filesystem->get_contents( THEMIFY_DIR . '/img/image-placeholder.jpg' ) );

		if ( $info = wp_check_filetype( $upload['file'] ) )
			$post['post_mime_type'] = $info['type'];
		else
			return new WP_Error( 'attachment_processing_error', __( 'Invalid file type', 'themify' ) );

		$post['guid'] = $upload['url'];
		$post_id = wp_insert_attachment( $post, $upload['file'] );
		wp_update_attachment_metadata( $post_id, wp_generate_attachment_metadata( $post_id, $upload['file'] ) );

		$placeholder_image = $post_id;
	}

	return $placeholder_image;
}

function themify_import_term( $term ) {
	global $processed_terms;

	if( $term_id = term_exists( $term['slug'], $term['taxonomy'] ) ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];
		if ( isset( $term['term_id'] ) )
			$processed_terms[ intval( $term['term_id'] ) ] = (int) $term_id;
		return (int) $term_id;
	}

	if ( empty( $term['parent'] ) ) {
		$parent = 0;
	} else {
		$parent = term_exists( $processed_terms[ intval( $term['parent'] ) ], $term['taxonomy'] );
		if ( is_array( $parent ) ) $parent = $parent['term_id'];
	}

	$id = wp_insert_term( $term['name'], $term['taxonomy'], array(
		'parent' => $parent,
		'slug' => $term['slug'],
		'description' => $term['description'],
	) );
	if ( ! is_wp_error( $id ) ) {
		if ( isset( $term['term_id'] ) ) {
			// success!
			$processed_terms[ intval($term['term_id']) ] = $id['term_id'];
			if ( isset( $term['thumbnail'] ) ) {
				themify_add_import_action( 'term_thumb', array(
					'id' => $id['term_id'],
					'thumb' => $term['thumbnail'],
				) );
			}
			return $term['term_id'];
		}
	}

	return false;
}

function themify_get_term_id_by_slug( $slug, $tax ) {
	$term = get_term_by( 'slug', $slug, $tax );
	if( $term ) {
		return $term->term_id;
	}

	return false;
}

function themify_undo_import_term( $term ) {
	$term_id = term_exists( $term['slug'], $term['taxonomy'] );
	if ( $term_id ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];

		if ( $term_thumbnail = get_term_meta( $term['term_id'], 'thumbnail_id', true ) ) {
			wp_delete_attachment( $term_thumbnail, true );
		}

		if ( isset( $term_id ) ) {
			wp_delete_term( $term_id, $term['taxonomy'] );
		}
	}
}

/**
 * Determine if a post exists based on title, content, and date
 *
 * @global wpdb $wpdb WordPress database abstraction object.
 *
 * @param array $args array of database parameters to check
 * @return int Post ID if post exists, 0 otherwise.
 */
function themify_post_exists( $args = array() ) {
	global $wpdb;

	$query = "SELECT ID FROM $wpdb->posts WHERE 1=1";
	$db_args = array();

	foreach ( $args as $key => $value ) {
		$value = wp_unslash( sanitize_post_field( $key, $value, 0, 'db' ) );
		if( ! empty( $value ) ) {
			$query .= ' AND ' . $key . ' = %s';
			$db_args[] = $value;
		}
	}

	if ( !empty ( $args ) )
		return (int) $wpdb->get_var( $wpdb->prepare($query, $args) );

	return 0;
}

function themify_undo_import_post( $post ) {
	if( $post['post_type'] == 'nav_menu_item' ) {
		$post_exists = themify_post_exists( array(
			'post_name' => $post['post_name'],
			'post_modified' => $post['post_date'],
			'post_type' => 'nav_menu_item',
		) );
	} else {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
	}
	if( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
		/**
		 * check if the post has been modified, if so leave it be
		 *
		 * NOTE: posts are imported using wp_insert_post() which modifies post_modified field
		 * to be the same as post_date, hence to check if the post has been modified,
		 * the post_modified field is compared against post_date in the original post.
		 */
		if( $post['post_date'] == get_post_field( 'post_modified', $post_exists ) ) {
			// find and remove all post attachments
			$attachments = get_posts( array(
				'post_type' => 'attachment',
				'posts_per_page' => -1,
				'post_parent' => $post_exists,
			) );
			if ( $attachments ) {
				foreach ( $attachments as $attachment ) {
					wp_delete_attachment( $attachment->ID, true );
				}
			}
			wp_delete_post( $post_exists, true ); // true: bypass trash
		}
	}
}

function themify_process_post_import( $post ) {
	if( ERASEDEMO ) {
		themify_undo_import_post( $post );
	} else {
		if ( $id = themify_import_post( $post ) ) {
			if ( defined( 'IMPORT_IMAGES' ) && ! IMPORT_IMAGES ) {
				/* if importing images is disabled and post is supposed to have a thumbnail, create a placeholder image instead */
				if ( isset( $post['thumb'] ) ) { // the post is supposed to have featured image
					$placeholder = themify_get_placeholder_image();
					if( ! is_wp_error( $placeholder ) ) {
						set_post_thumbnail( $id, $placeholder );
					}
				}
			} else {
				if ( isset( $post["thumb"] ) ) {
					themify_add_import_action( 'post_thumb', array(
						'id' => $id,
						'thumb' => $post["thumb"],
					) );
				}
				if ( isset( $post["gallery_shortcode"] ) ) {
					themify_add_import_action( 'gallery_field', array(
						'id' => $id,
						'fields' => $post["gallery_shortcode"],
					) );
				}
				if ( isset( $post["_product_image_gallery"] ) ) {
					themify_add_import_action( 'product_gallery', array(
						'id' => $id,
						'images' => $post["_product_image_gallery"],
					) );
				}
			}
		}
	}
}
$thumbs = array();
function themify_do_demo_import() {
global $import_actions;

	if ( isset( $GLOBALS["ThemifyBuilder_Data_Manager"] ) ) {
		remove_action( "save_post", array( $GLOBALS["ThemifyBuilder_Data_Manager"], "save_builder_text_only"), 10, 3 );
	}
$term = array (
  'term_id' => 17,
  'name' => 'Coffee',
  'slug' => 'coffee',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 18,
  'name' => 'Equipment',
  'slug' => 'equipment',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 16,
  'name' => 'Main Navigation',
  'slug' => 'main-navigation',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$post = array (
  'ID' => 144,
  'post_date' => '2019-02-12 06:59:39',
  'post_date_gmt' => '2019-02-12 06:59:39',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h1>About Us<br/></h1>
<img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/coffee-bean-divider-300x21.png" width="300" alt="coffee bean divider" />
<h3>Who We Are<br/>A little about us</h3>
<img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/coffee-bean-divider-300x21.png" width="300" alt="coffee bean divider" />
<p>Coffee is a brewed beverage using roasted coffee beans, the seeds of cherries from various Coffea species. The genus Coffea is native to tropical Africa, Madagascar, the Comoros, Mauritius, and Réunion in the Indian Ocean, amoung others.</p> <p>We’ve never been so excited to share with you our coffee knowledge and the story that every bean can tell. Come on in, take a sip, and explore with us!</p>
<p>All our coffee is ethically sourced by trusted green importers in the UK. This means the farmers are paid a higher price than fair trade as they are rewarded for the quality of their coffee. Our own quality grader has worked hard to find the best quality beans at great value prices.</p>
<p>We know that great coffee matters so we are here to provide you with a fast, hassle-free service of tasty coffee direct to your door.</p>
<img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/coffee-bean-330x186.jpg" width="330" alt="coffee bean" srcset="https://themify.me/demo/themes/ultra-coffee/files/2019/02/coffee-bean-330x186.jpg 330w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/coffee-bean.jpg 336w" sizes="(max-width: 330px) 100vw, 330px" />
<p>Our Commitment</p>
<h3>Mission Statement</h3>
<p>We believe freshness of coffee is super important. Supermarket coffee can be sitting on a shelf for up to 2 years, leaving it stale and tasteless.</p> <p>We will never send you coffee that’s more than a week old.  We provide you with high quality 100% Arabica beans which are batch roasted for maximum freshness. No mass production here! </p>
 
<h3>The Details<br/>It\'s what we do best</h3>
<img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/coffee-bean-divider-300x21.png" width="300" alt="coffee bean divider" />
<p>12</p>
<h3>Coffee Blends</h3> <p>Yup. We only have 12. When we create a coffee blend, we perfect it 200 times to make it right.</p>
<p>28</p>
<h3>Coffee Farms</h3> <p>We collaborate with 28 different coffee growers, to ensure the best quality and cultivate sustainable practices.</p>
<p>8</p>
<h3>Locations</h3> <p>We may be small, but we are mighty. We aim to grow slowly to limit our environmental footprint and protect our farmers.</p>
<p>96</p>
<h3>Team Members</h3> <p>That\'s the number of people we\'ve employed over our 8 locations and roasting warehouse. We love our team!</p>
<p>Coffee</p>
<p>Traditional</p>
<img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/ungrilled-coffee-bean-310x332.jpg" width="310" alt="ungrilled coffee bean" />
<ul data-id="testimonial-slider-0-" data-visible="1" data-mob-visible="0" data-scroll="1" data-auto-scroll="off" data-speed="1" data-wrap="yes" data-arrow="no" data-pagination="yes" data-effect="scroll" data-height="variable" data-pause-on-hover="resume" > <li> 
 <p>We tried coffee roasters from all over the US, and nothing beat their coffee quality and taste. Their assistance with equipment choices, employee training, brew recipes and general coffee education gave us the foundation we needed to provide our community with delicious coffee that is responsibly and sustainably sourced. Ordering coffee is easy, roasted fresh and still manages to ship amazingly fast.</p> <figure><img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/michael-125x125.jpg" width="125" height="125" alt="michael" srcset="https://themify.me/demo/themes/ultra-coffee/files/2019/02/michael-125x125.jpg 125w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/michael-100x100.jpg 100w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/michael.jpg 150w" sizes="(max-width: 125px) 100vw, 125px" /></figure> Michael Reid CEO Zurisch Studio </li> <li> 
 <p>This is my favourite coffee shop when I\'m in Toronto. Freshly roasted coffee with their in-house made coconut or almond milk if you want. All the staff members are lovely, compassionate, and genuine. Their non-caffeinated specialities are great too! </p> <figure><img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/joshua-125x125.jpg" width="125" height="125" alt="joshua" srcset="https://themify.me/demo/themes/ultra-coffee/files/2019/02/joshua-125x125.jpg 125w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/joshua-100x100.jpg 100w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/joshua.jpg 150w" sizes="(max-width: 125px) 100vw, 125px" /></figure> Joshua Bennet CEO Star Studio </li> <li> 
 <p>This was the first coffee shop I visited in Manhattan and I had to keep going back. The staff are so welcoming and the quality is there. From the beverages, to the interior, and even the WiFi, it\'s a perfect little coffee shop. The coolest thing was the latte art that surprised me - it\'s not everyday you find a pirate in your cup of joe!</p> <figure><img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/micchele-125x125.jpg" width="125" height="125" alt="micchele" srcset="https://themify.me/demo/themes/ultra-coffee/files/2019/02/micchele-125x125.jpg 125w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/micchele-100x100.jpg 100w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/micchele.jpg 150w" sizes="(max-width: 125px) 100vw, 125px" /></figure> Michelle Lau CEO She Boutique </li> </ul><!--/themify_builder_static-->',
  'post_title' => 'About',
  'post_excerpt' => '',
  'post_name' => 'about',
  'post_modified' => '2019-05-09 00:45:39',
  'post_modified_gmt' => '2019-05-09 00:45:39',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-coffee/?page_id=144',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"9d46abd\\",\\"cols\\":[{\\"element_id\\":\\"7928ae4\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"d137649\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#ffffff\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"2\\",\\"font_size_unit\\":\\"em\\",\\"line_height_subheading_unit\\":\\"em\\",\\"sub_margin_bottom\\":\\"40\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"50\\",\\"font_size_subheading\\":\\"28\\",\\"line_height_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\"},\\"heading\\":\\"About Us\\",\\"heading_tag\\":\\"h1\\",\\"text_alignment\\":\\"themify-text-center\\",\\"stick_at_position\\":\\"top\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"f0b96dd\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"40\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/coffee-bean-divider.png\\",\\"width_image\\":\\"300\\",\\"param_image\\":\\"regular\\",\\"stick_at_position\\":\\"top\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/bg-hero-banner-about-1600x600.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#ffffff\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"12\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth\\",\\"stick_at_position\\":\\"top\\"}},{\\"element_id\\":\\"40f477e\\",\\"cols\\":[{\\"element_id\\":\\"he9z468\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"74ms468\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#c59d5f\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"2.6\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading\\":\\"1.3\\",\\"font_size_subheading_unit\\":\\"em\\",\\"line_height_subheading_unit\\":\\"em\\",\\"sub_margin_bottom\\":\\"40\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"40\\",\\"font_size_subheading\\":\\"28\\",\\"line_height_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"2\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading\\":\\"1\\",\\"font_size_subheading_unit\\":\\"em\\",\\"line_height_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\"},\\"heading\\":\\"Who We Are\\",\\"sub_heading\\":\\"A little about us\\",\\"heading_tag\\":\\"h3\\",\\"text_alignment\\":\\"themify-text-center\\",\\"stick_at_position\\":\\"top\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"s9b4469\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"40\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/coffee-bean-divider.png\\",\\"width_image\\":\\"300\\",\\"param_image\\":\\"regular\\",\\"stick_at_position\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"35\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"}}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/natural-coffee-bean.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"7\\",\\"padding_top_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/ungrilled-coffee-bean-mobile.png\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"9\\",\\"padding_top_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/ungrilled-coffee-bean-mobile.png\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"45\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"0\\",\\"border-type\\":\\"top\\"},\\"row_width\\":\\"fullwidth\\",\\"stick_at_position\\":\\"top\\",\\"breakpoint_tablet_landscape\\":{\\"background_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/natural-coffee-bean-tablet.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"t9c8462\\",\\"cols\\":[{\\"element_id\\":\\"r6js469\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"1713dff\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<p>Coffee is a brewed beverage using roasted coffee beans, the seeds of cherries from various Coffea species. The genus Coffea is native to tropical Africa, Madagascar, the Comoros, Mauritius, and Réunion in the Indian Ocean, amoung others.<\\\\/p>\\\\n<p>We’ve never been so excited to share with you our coffee knowledge and the story that every bean can tell. Come on in, take a sip, and explore with us!<\\\\/p>\\",\\"stick_at_position\\":\\"top\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_right\\":\\"1\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"3\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"6dc7f32\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"9q6w469\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<div class=\\\\\\\\\\\\\\"block two text-container\\\\\\\\\\\\\\">\\\\n<p>All our coffee is ethically sourced by trusted green importers in the UK. This means the farmers are paid a higher price than fair trade as they are rewarded for the quality of their coffee. Our own quality grader has worked hard to find the best quality beans at great value prices.<\\\\/p>\\\\n<div class=\\\\\\\\\\\\\\"block two text-container\\\\\\\\\\\\\\">\\\\n<p>We know that great coffee matters so we are here to provide you with a fast, hassle-free service of tasty coffee direct to your door.<\\\\/p>\\\\n<\\\\/div>\\\\n<\\\\/div>\\",\\"stick_at_position\\":\\"top\\"}}],\\"styling\\":{\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_right\\":\\"3\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"1\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_bottom\\":\\"70\\",\\"border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"0\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"stick_at_position\\":\\"top\\"}},{\\"element_id\\":\\"f452d18\\",\\"cols\\":[{\\"element_id\\":\\"3ba2bff\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"d9fbefe\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/coffee-bean-330x186.jpg\\",\\"width_image\\":\\"330\\",\\"param_image\\":\\"regular\\",\\"stick_at_position\\":\\"top\\"}}]},{\\"element_id\\":\\"1373b9c\\",\\"grid_class\\":\\"col4-2\\"}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"stick_at_position\\":\\"top\\",\\"visibility_tablet\\":\\"hide\\",\\"visibility_mobile\\":\\"hide\\"}},{\\"element_id\\":\\"66d0518\\",\\"cols\\":[{\\"element_id\\":\\"30632b1\\",\\"grid_class\\":\\"col3-1\\",\\"styling\\":{\\"padding_bottom\\":\\"150\\",\\"padding_top\\":\\"150\\",\\"background_position\\":\\"center-center\\",\\"background_zoom\\":\\"\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"fullcover\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/bean-cup-of-coffee.jpg\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\"}},{\\"element_id\\":\\"ccfce94\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"d0c116a\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"p_margin_bottom\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_h3\\":\\"#c59d5f\\",\\"font_gradient_color_h3-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size_h3\\":\\"48\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"30\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<p>Our Commitment<\\\\/p>\\",\\"stick_at_position\\":\\"top\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"zytc471\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_h3\\":\\"#c59d5f\\",\\"font_gradient_color_h3-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size_h3\\":\\"48\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"2.2\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<h3>Mission Statement<\\\\/h3>\\\\n<div class=\\\\\\\\\\\\\\"block two text-container\\\\\\\\\\\\\\">\\\\n<p>We believe freshness of coffee is super important. Supermarket coffee can be sitting on a shelf for up to 2 years, leaving it stale and tasteless.<\\\\/p>\\\\n<p>We will never send you coffee that’s more than a week old.  We provide you with high quality 100% Arabica beans which are batch roasted for maximum freshness. No mass production here! <\\\\/p>\\\\n<div class=\\\\\\\\\\\\\\"block-container guide-list\\\\\\\\\\\\\\">\\\\n<div class=\\\\\\\\\\\\\\"block five guide\\\\\\\\\\\\\\"> <\\\\/div>\\\\n<\\\\/div>\\\\n<\\\\/div>\\",\\"stick_at_position\\":\\"top\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#ffffff\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"col_tablet_landscape\\":\\"column4-2\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/bg-about-our-history-1600x798.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#000000_0.50\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"7\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"7\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"row_width\\":\\"fullwidth\\",\\"stick_at_position\\":\\"top\\"}},{\\"element_id\\":\\"5b9a8aa\\",\\"cols\\":[{\\"element_id\\":\\"4d89ffa\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"ezfl471\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#c59d5f\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"2.6\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading\\":\\"1.3\\",\\"font_size_subheading_unit\\":\\"em\\",\\"line_height_subheading_unit\\":\\"em\\",\\"sub_margin_bottom\\":\\"40\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"40\\",\\"font_size_subheading\\":\\"28\\",\\"line_height_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"2\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading\\":\\"1\\",\\"font_size_subheading_unit\\":\\"em\\",\\"line_height_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\"},\\"heading\\":\\"The Details\\",\\"sub_heading\\":\\"It\\\\\\\\\\\'s what we do best\\",\\"heading_tag\\":\\"h3\\",\\"text_alignment\\":\\"themify-text-center\\",\\"stick_at_position\\":\\"top\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"e2t5471\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"40\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/coffee-bean-divider.png\\",\\"width_image\\":\\"300\\",\\"param_image\\":\\"regular\\",\\"stick_at_position\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"}}},{\\"element_id\\":\\"54f953f\\",\\"cols\\":[{\\"element_id\\":\\"b404982\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"c55dbf0\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#c59d5f\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"70\\",\\"line_height_unit\\":\\"em\\",\\"font_weight\\":\\"bold\\",\\"p_margin_bottom\\":\\"20\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>12<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"4\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"font_weight\\":\\"bold\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"82250a4\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_h3\\":\\"#c59d5f\\",\\"font_gradient_color_h3-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Coffee Blends<\\\\/h3>\\\\n<p>Yup. We only have 12. When we create a coffee blend, we perfect it 200 times to make it right.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\"}}],\\"styling\\":{\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"52a9716\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"gn0b473\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#c59d5f\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"70\\",\\"font_weight\\":\\"bold\\",\\"p_margin_bottom\\":\\"20\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>28<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"4\\",\\"font_size_unit\\":\\"em\\",\\"font_weight\\":\\"bold\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"rlsj473\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_h3\\":\\"#c59d5f\\",\\"font_gradient_color_h3-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Coffee Farms<\\\\/h3>\\\\n<p>We collaborate with 28 different coffee growers, to ensure the best quality and cultivate sustainable practices.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\"}}],\\"styling\\":{\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"3cece3b\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"uauw473\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#c59d5f\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"70\\",\\"font_weight\\":\\"bold\\",\\"p_margin_bottom\\":\\"20\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>8<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"4\\",\\"font_size_unit\\":\\"em\\",\\"font_weight\\":\\"bold\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"evcc473\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_h3\\":\\"#c59d5f\\",\\"font_gradient_color_h3-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Locations<\\\\/h3>\\\\n<p>We may be small, but we are mighty. We aim to grow slowly to limit our environmental footprint and protect our farmers.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\"}}],\\"styling\\":{\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"ba97f5a\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"4fcd475\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#c59d5f\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"70\\",\\"font_weight\\":\\"bold\\",\\"p_margin_bottom\\":\\"20\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>96<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"4\\",\\"font_size_unit\\":\\"em\\",\\"font_weight\\":\\"bold\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ama7475\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_h3\\":\\"#c59d5f\\",\\"font_gradient_color_h3-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Team Members<\\\\/h3>\\\\n<p>That\\\\\\\\\\\'s the number of people we\\\\\\\\\\\'ve employed over our 8 locations and roasting warehouse. We love our team!<\\\\/p>\\",\\"stick_at_position\\":\\"top\\"}}],\\"styling\\":{\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}}],\\"col_tablet_landscape\\":\\"column4-1\\",\\"col_tablet\\":\\"column4-2\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"4\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"4\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"text_align\\":\\"center\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"},\\"stick_at_position\\":\\"top\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/coffee-grilled-powder.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"7\\",\\"padding_top_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/coffee-grilled-small.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"9\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/coffee-leaf-mobile.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"1\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"row_width\\":\\"fullwidth\\",\\"stick_at_position\\":\\"top\\",\\"breakpoint_tablet_landscape\\":{\\"background_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/coffee-grilled-powder-tablet.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"3aeb8f0\\",\\"cols\\":[{\\"element_id\\":\\"c952470\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"c75719c\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_family\\":\\"Playfair Display\\",\\"element_font_weight\\":\\"700\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#e9dac2\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"100\\",\\"font_style_regular\\":\\"normal\\",\\"p_margin_bottom\\":\\"69\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_family\\":\\"Playfair Display\\",\\"element_font_weight\\":\\"700\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"80\\",\\"font_style_regular\\":\\"normal\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_family\\":\\"Playfair Display\\",\\"element_font_weight\\":\\"700\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"60\\",\\"font_style_regular\\":\\"normal\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_family\\":\\"Playfair Display\\",\\"element_font_weight\\":\\"700\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"40\\",\\"font_style_regular\\":\\"normal\\",\\"p_margin_bottom\\":\\"20\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<p>Coffee<\\\\/p>\\",\\"stick_at_position\\":\\"top\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"09le476\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_family\\":\\"Playfair Display\\",\\"element_font_weight\\":\\"700\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#e9dac2\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"100\\",\\"text_align\\":\\"right\\",\\"font_style_regular\\":\\"normal\\",\\"p_margin_bottom\\":\\"17\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Traditional<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_family\\":\\"Playfair Display\\",\\"element_font_weight\\":\\"700\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"80\\",\\"text_align\\":\\"right\\",\\"font_style_regular\\":\\"normal\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_family\\":\\"Playfair Display\\",\\"element_font_weight\\":\\"700\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"60\\",\\"text_align\\":\\"right\\",\\"font_style_regular\\":\\"normal\\",\\"p_margin_bottom\\":\\"7\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_family\\":\\"Playfair Display\\",\\"element_font_weight\\":\\"700\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"40\\",\\"text_align\\":\\"right\\",\\"font_style_regular\\":\\"normal\\",\\"p_margin_bottom\\":\\"7\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}],\\"grid_width\\":\\"61\\"},{\\"element_id\\":\\"eeca8a3\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"eb4988e\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"},\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/ungrilled-coffee-bean.jpg\\",\\"width_image\\":\\"310\\",\\"param_image\\":\\"regular\\",\\"stick_at_position\\":\\"top\\",\\"custom_parallax_scroll_zindex\\":\\"-1\\"}}],\\"grid_width\\":\\"35.8\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"text_align\\":\\"right\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"column_alignment\\":\\"col_align_bottom\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\"}},{\\"element_id\\":\\"294c9aa\\",\\"cols\\":[{\\"element_id\\":\\"f2982a6\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"testimonial-slider\\",\\"element_id\\":\\"e220ede\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_p_container_apply_all\\":\\"1\\",\\"b_container-type\\":\\"top\\",\\"checkbox_content_padding_apply_all\\":\\"1\\",\\"content_border-type\\":\\"top\\",\\"layout_testimonial\\":\\"image-bottom\\",\\"tab_content_testimonial\\":[{\\"content_testimonial\\":\\"<p>We tried coffee roasters from all over the US, and nothing beat their coffee quality and taste. Their assistance with equipment choices, employee training, brew recipes and general coffee education gave us the foundation we needed to provide our community with delicious coffee that is responsibly and sustainably sourced. Ordering coffee is easy, roasted fresh and still manages to ship amazingly fast.<\\\\/p>\\",\\"person_picture_testimonial\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/michael.jpg\\",\\"person_name_testimonial\\":\\" Michael Reid\\",\\"person_position_testimonial\\":\\" CEO Zurisch Studio\\"},{\\"content_testimonial\\":\\"<p>This is my favourite coffee shop when I\\\\\\\\\\\'m in Toronto. Freshly roasted coffee with their in-house made coconut or almond milk if you want. All the staff members are lovely, compassionate, and genuine. Their non-caffeinated specialities are great too! <\\\\/p>\\",\\"person_picture_testimonial\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/joshua.jpg\\",\\"person_name_testimonial\\":\\"Joshua Bennet\\",\\"person_position_testimonial\\":\\"CEO Star Studio\\"},{\\"content_testimonial\\":\\"<p>This was the first coffee shop I visited in Manhattan and I had to keep going back. The staff are so welcoming and the quality is there. From the beverages, to the interior, and even the WiFi, it\\\\\\\\\\\'s a perfect little coffee shop. The coolest thing was the latte art that surprised me - it\\\\\\\\\\\'s not everyday you find a pirate in your cup of joe!<\\\\/p>\\",\\"person_picture_testimonial\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/micchele.jpg\\",\\"person_name_testimonial\\":\\"Michelle Lau\\",\\"person_position_testimonial\\":\\"CEO She Boutique\\"}],\\"img_w_slider\\":\\"125\\",\\"img_h_slider\\":\\"125\\",\\"visible_opt_slider\\":\\"1\\",\\"mob_visible_opt_slider\\":\\"0\\",\\"auto_scroll_opt_slider\\":\\"off\\",\\"scroll_opt_slider\\":\\"1\\",\\"speed_opt_slider\\":\\"normal\\",\\"effect_slider\\":\\"scroll\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"wrap_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"yes\\",\\"show_arrow_slider\\":\\"no\\",\\"height_slider\\":\\"variable\\",\\"stick_at_position\\":\\"top\\"}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/bg-testimonial-1600x734.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#000000_0.50\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#ffffff\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"100\\",\\"padding_bottom\\":\\"100\\",\\"border-type\\":\\"top\\"},\\"stick_at_position\\":\\"top\\"}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 5,
  'post_date' => '2019-02-11 06:18:44',
  'post_date_gmt' => '2019-02-11 06:18:44',
  'post_content' => '<p>[woocommerce_cart]</p>

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Cart',
  'post_excerpt' => '',
  'post_name' => 'cart',
  'post_modified' => '2019-05-09 00:41:30',
  'post_modified_gmt' => '2019-05-09 00:41:30',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-coffee/cart/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6,
  'post_date' => '2019-02-11 06:18:44',
  'post_date_gmt' => '2019-02-11 06:18:44',
  'post_content' => '<p>[woocommerce_checkout]</p>

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Checkout',
  'post_excerpt' => '',
  'post_name' => 'checkout',
  'post_modified' => '2019-05-09 00:41:47',
  'post_modified_gmt' => '2019-05-09 00:41:47',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-coffee/checkout/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 232,
  'post_date' => '2019-02-13 07:32:02',
  'post_date_gmt' => '2019-02-13 07:32:02',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h1>Contact Us<br/></h1>
<img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/coffee-bean-divider.png" alt="coffee bean divider" />
<h3>Office Locations<br/>Get in touch with us</h3>
<img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/coffee-bean-divider.png" alt="coffee bean divider" />
<img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/Manhattan-office-95x95.png" width="95" alt="Manhattan office" srcset="https://themify.me/demo/themes/ultra-coffee/files/2019/02/Manhattan-office-95x95.png 95w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/Manhattan-office-150x150.png 150w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/Manhattan-office-100x100.png 100w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/Manhattan-office.png 300w" sizes="(max-width: 95px) 100vw, 95px" />
Address
<p>Head Office<br />55 Adelaide St E, <br />Toronto, ON, M5C 1K6<br />Canada</p>
Help
<p>(416) 456 - 1989</p>
Social Media
<a href="https://facebook.com/themify"> </a> <a href="https://twitter.com/themify"> </a> <a href="https://www.instagram.com/themify/"> </a>
<img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/toronto-office-95x95.png" width="95" alt="toronto-office" srcset="https://themify.me/demo/themes/ultra-coffee/files/2019/02/toronto-office-95x95.png 95w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/toronto-office-150x150.png 150w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/toronto-office-100x100.png 100w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/toronto-office.png 300w" sizes="(max-width: 95px) 100vw, 95px" />
Address
<p>Manhattan Office<br />660 Rosewood Lane, New York, NY 10019, USA</p>
Help
<p>(212) 371 - 3430</p>
Social Media
<a href="https://facebook.com/themify"> </a> <a href="https://twitter.com/themify"> </a> <a href="https://www.instagram.com/themify/"> </a>
<img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/australia-office-cafe-95x95.png" width="95" alt="australia office cafe" srcset="https://themify.me/demo/themes/ultra-coffee/files/2019/02/australia-office-cafe-95x95.png 95w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/australia-office-cafe-150x150.png 150w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/australia-office-cafe-100x100.png 100w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/australia-office-cafe.png 300w" sizes="(max-width: 95px) 100vw, 95px" />
Address
<p>Australia Office<br />33 Surya Paloh Crescent, NSW 2114, Australia</p>
Help
<p>(02) 222 - 8900</p>
Social Media
<a href="https://facebook.com/themify"> </a> <a href="https://twitter.com/themify"> </a> <a href="https://www.instagram.com/themify/"> </a>
<h3>Write To Us<br/></h3>
<form action="https://themify.me/demo/themes/ultra-coffee/wp-admin/admin-ajax.php" id="contact-0--form" method="post"> <label for="contact-0--contact-name">Your Name </label> <input type="text" name="contact-name" placeholder="" id="contact-0--contact-name" value="" /> <label for="contact-0--contact-email">Your Email </label> <input type="text" name="contact-email" placeholder="" id="contact-0--contact-email" value="" /> <label for="contact-0--contact-subject">Subject *</label> <input type="text" name="contact-subject" placeholder="" id="contact-0--contact-subject" value="" required /> <label for="contact-0--contact-message">Message *</label> <textarea name="contact-message" placeholder="" id="contact-0--contact-message" rows="8" cols="45" required></textarea> <button type="submit"> Submit </button> </form>
Head Office Manhattan Office Australia Office<!--/themify_builder_static-->',
  'post_title' => 'Contact',
  'post_excerpt' => '',
  'post_name' => 'contact',
  'post_modified' => '2019-09-19 15:42:02',
  'post_modified_gmt' => '2019-09-19 15:42:02',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-coffee/?page_id=232',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"uefx332\\",\\"cols\\":[{\\"element_id\\":\\"121n335\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"pfmj221\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#ffffff\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"2\\",\\"font_size_unit\\":\\"em\\",\\"sub_margin_bottom\\":\\"40\\",\\"d_border-type\\":\\"all\\",\\"d_border_top_style\\":\\"none\\",\\"heading\\":\\"Contact Us\\",\\"heading_tag\\":\\"h1\\",\\"text_alignment\\":\\"themify-text-center\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"m4x40\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"40\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/coffee-bean-divider.png\\",\\"param_image\\":\\"regular\\"}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/bg-hero-banner-about.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#ffffff\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"12\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"3ott870\\",\\"cols\\":[{\\"element_id\\":\\"bz9w873\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"ytc612\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"20\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#c59d5f\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"2.6\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading\\":\\"1.3\\",\\"font_size_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"all\\",\\"d_border_top_style\\":\\"none\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"2\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading\\":\\"1\\",\\"font_size_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"all\\",\\"d_border_top_style\\":\\"none\\"},\\"heading\\":\\"Office Locations\\",\\"sub_heading\\":\\"Get in touch with us\\",\\"heading_tag\\":\\"h3\\",\\"text_alignment\\":\\"themify-text-center\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"2\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading\\":\\"1\\",\\"font_size_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"all\\",\\"d_border_top_style\\":\\"none\\"}}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"orn1995\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"40\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/coffee-bean-divider.png\\",\\"param_image\\":\\"regular\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"}}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/black-coffee-bean.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"9\\",\\"padding_top_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/black-coffee-bean-mobile.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"45\\",\\"padding_top_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/black-coffee-bean-mobile.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"14\\",\\"padding_top_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/black-coffee-bean-mobile.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"avmx604\\",\\"cols\\":[{\\"element_id\\":\\"hyy3608\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"element_id\\":\\"s0ia873\\",\\"cols\\":[{\\"element_id\\":\\"fefq875\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"o92a183\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"8\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/Manhattan-office-95x95.png\\",\\"width_image\\":\\"95\\",\\"param_image\\":\\"regular\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"}}}],\\"grid_width\\":\\"32.4\\"},{\\"element_id\\":\\"qxpl875\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"fmp8464\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#c59d5f\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"circle\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-location-pin\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"Address\\",\\"link_options\\":\\"regular\\"}]}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"6lul837\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_left\\":\\"39\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Head Office<br \\\\/>55 Adelaide St E, <br \\\\/>Toronto, ON, M5C 1K6<br \\\\/>Canada<\\\\/p>\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"40ia970\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#c59d5f\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"circle\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"fa-fax\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"Help\\",\\"link_options\\":\\"regular\\"}]}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"1wwj954\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_left\\":\\"40\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>(416) 456 - 1989<\\\\/p>\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"xe8g234\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#c59d5f\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"circle\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"fa-hashtag\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"Social Media\\",\\"link_options\\":\\"regular\\"}]}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"h7ef413\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_left\\":\\"39\\",\\"border-type\\":\\"top\\",\\"font_color_icon\\":\\"#363636\\",\\"font_color_icon_hover\\":\\"#c59d5f\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"circle\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"fa-facebook\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/facebook.com\\\\/themify\\",\\"link_options\\":\\"regular\\"},{\\"icon\\":\\"fa-twitter\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/twitter.com\\\\/themify\\",\\"link_options\\":\\"regular\\"},{\\"icon\\":\\"fa-instagram\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/www.instagram.com\\\\/themify\\\\/\\",\\"link_options\\":\\"regular\\"}]}}],\\"grid_width\\":\\"67.6\\"}],\\"gutter\\":\\"gutter-none\\",\\"col_tablet_landscape\\":\\"column-full\\",\\"col_tablet\\":\\"column4-2\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"3.2\\",\\"padding_right_unit\\":\\"em\\",\\"margin_bottom\\":\\"8\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"right\\",\\"border_right_color\\":\\"#dddddd\\",\\"border_right_width\\":\\"1\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"em\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"right\\",\\"border_right_color\\":\\"#dddddd\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"1\\"}}}]},{\\"element_id\\":\\"osja744\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"element_id\\":\\"0d3q442\\",\\"cols\\":[{\\"element_id\\":\\"dvcw444\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"u94b445\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"8\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/toronto-office-95x95.png\\",\\"width_image\\":\\"95\\",\\"param_image\\":\\"regular\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"}}}],\\"grid_width\\":\\"32.6\\"},{\\"element_id\\":\\"2w2o445\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"vllj445\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#c59d5f\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"circle\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-location-pin\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"Address\\",\\"link_options\\":\\"regular\\"}]}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"a5ts447\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_left\\":\\"39\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Manhattan Office<br \\\\/>660 Rosewood Lane, New York, NY 10019, USA<\\\\/p>\\\\n\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"tybm448\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#c59d5f\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"circle\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"fa-fax\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"Help\\",\\"link_options\\":\\"regular\\"}]}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"l17j448\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_left\\":\\"39\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>(212) 371 - 3430<\\\\/p>\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"dge3448\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#c59d5f\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"circle\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"fa-hashtag\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"Social Media\\",\\"link_options\\":\\"regular\\"}]}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"8wfz277\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_left\\":\\"39\\",\\"border-type\\":\\"top\\",\\"font_color_icon\\":\\"#363636\\",\\"font_color_icon_hover\\":\\"#c59d5f\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"circle\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"fa-facebook\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/facebook.com\\\\/themify\\",\\"link_options\\":\\"regular\\"},{\\"icon\\":\\"fa-twitter\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/twitter.com\\\\/themify\\",\\"link_options\\":\\"regular\\"},{\\"icon\\":\\"fa-instagram\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/www.instagram.com\\\\/themify\\\\/\\",\\"link_options\\":\\"regular\\"}]}}],\\"grid_width\\":\\"67.4\\"}],\\"gutter\\":\\"gutter-none\\",\\"col_tablet_landscape\\":\\"column-full\\",\\"col_tablet\\":\\"column4-2\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"3.2\\",\\"padding_right_unit\\":\\"em\\",\\"margin_bottom\\":\\"8\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"right\\",\\"border_right_color\\":\\"#dddddd\\",\\"border_right_width\\":\\"1\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"em\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"right\\",\\"border_right_color\\":\\"#dddddd\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"1\\"}}}]},{\\"element_id\\":\\"6b3k745\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"element_id\\":\\"op3l113\\",\\"cols\\":[{\\"element_id\\":\\"8tk5114\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"d11s116\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"8\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/australia-office-cafe-95x95.png\\",\\"width_image\\":\\"95\\",\\"param_image\\":\\"regular\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"}}}],\\"grid_width\\":\\"27.6\\"},{\\"element_id\\":\\"2v12116\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"fa8e116\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#c59d5f\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"circle\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-location-pin\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"Address\\",\\"link_options\\":\\"regular\\"}]}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"xak6117\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_left\\":\\"39\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Australia Office<br \\\\/>33 Surya Paloh Crescent, NSW 2114, Australia<\\\\/p>\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"4x69117\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#c59d5f\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"circle\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"fa-fax\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"Help\\",\\"link_options\\":\\"regular\\"}]}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"rjrh118\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_left\\":\\"39\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>(02) 222 - 8900<\\\\/p>\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"m0bi118\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#c59d5f\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"circle\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"fa-hashtag\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"Social Media\\",\\"link_options\\":\\"regular\\"}]}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"jbvw279\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_left\\":\\"39\\",\\"border-type\\":\\"top\\",\\"font_color_icon\\":\\"#363636\\",\\"font_color_icon_hover\\":\\"#c59d5f\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"circle\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"fa-facebook\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/facebook.com\\\\/themify\\",\\"link_options\\":\\"regular\\"},{\\"icon\\":\\"fa-twitter\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/twitter.com\\\\/themify\\",\\"link_options\\":\\"regular\\"},{\\"icon\\":\\"fa-instagram\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/www.instagram.com\\\\/themify\\\\/\\",\\"link_options\\":\\"regular\\"}]}}],\\"grid_width\\":\\"72.4\\"}],\\"gutter\\":\\"gutter-none\\",\\"col_tablet_landscape\\":\\"column-full\\",\\"col_tablet\\":\\"column4-2\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"margin_bottom\\":\\"8\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}]}],\\"col_tablet_landscape\\":\\"column3-1\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"xvok146\\",\\"cols\\":[{\\"element_id\\":\\"rhq0149\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"3gxu280\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"20\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#c59d5f\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"2.6\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"all\\",\\"d_border_top_style\\":\\"none\\",\\"heading\\":\\"Write To Us\\",\\"heading_tag\\":\\"h3\\",\\"text_alignment\\":\\"themify-text-center\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"0\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"2\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"all\\",\\"d_border_top_style\\":\\"none\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"0\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"all\\",\\"d_border_top_style\\":\\"none\\"}}},{\\"mod_name\\":\\"contact\\",\\"element_id\\":\\"53edf88\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"border_inputs-type\\":\\"top\\",\\"border_send-type\\":\\"top\\",\\"checkbox_padding_success_message_apply_all\\":\\"1\\",\\"checkbox_margin_success_message_apply_all\\":\\"1\\",\\"border_success_message-type\\":\\"top\\",\\"checkbox_padding_error_message_apply_all\\":\\"1\\",\\"checkbox_margin_error_message_apply_all\\":\\"1\\",\\"border_error_message-type\\":\\"top\\",\\"layout_contact\\":\\"animated-label\\",\\"gdpr_label\\":\\"I consent to my submitted data being collected and stored\\",\\"field_name_label\\":\\"Your Name\\",\\"field_email_label\\":\\"Your Email\\",\\"field_subject_label\\":\\"Subject\\",\\"field_subject_require\\":\\"yes\\",\\"field_subject_active\\":\\"yes\\",\\"field_message_label\\":\\"Message\\",\\"field_extra\\":\\"{ \\\\\\\\\\\\\\"fields\\\\\\\\\\\\\\": [] }\\",\\"field_sendcopy_label\\":\\"Send a copy to myself\\",\\"field_order\\":\\"{}\\",\\"field_send_label\\":\\"Submit\\",\\"field_send_align\\":\\"center\\",\\"field_email_active\\":\\"yes\\",\\"field_name_active\\":\\"yes\\",\\"field_message_active\\":\\"yes\\",\\"contact_sent_from\\":\\"enable\\",\\"field_sendcopy_active\\":\\"\\",\\"field_captcha_active\\":\\"\\",\\"field_email_require\\":\\"\\",\\"field_name_require\\":\\"\\",\\"post_author\\":\\"\\",\\"send_to_admins\\":\\"true\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#ffffff_0.90\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"15\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"15\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"10\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"10\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"10\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"10\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"10\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"10\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/touch-now.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#000000_0.59\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"vxcx437\\",\\"cols\\":[{\\"element_id\\":\\"d8wl441\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"maps-pro\\",\\"element_id\\":\\"i0jg880\\",\\"mod_settings\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"map_display_type\\":\\"dynamic\\",\\"w_map\\":\\"100\\",\\"w_map_unit\\":\\"%\\",\\"w_map_static\\":\\"500\\",\\"h_map\\":\\"695\\",\\"type_map\\":\\"ROADMAP\\",\\"style_map\\":\\"greyscale\\",\\"scrollwheel_map\\":\\"disable\\",\\"draggable_map\\":\\"enable\\",\\"disable_map_ui\\":\\"no\\",\\"zoom_map\\":\\"16\\",\\"map_polyline\\":\\"no\\",\\"map_polyline_geodesic\\":\\"yes\\",\\"map_polyline_stroke\\":\\"2\\",\\"map_polyline_color\\":\\"#ff0000\\",\\"map_center\\":\\"483 Queen St West, Toronto, ON M5V 2A9, Canada\\",\\"markers\\":[{\\"address\\":\\"483 Queen St West, Toronto, ON M5V 2A9, Canada\\",\\"latlng\\":\\"43.6482738,-79.3978242\\",\\"title\\":\\"Head Office\\",\\"image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/map-marker.png\\"},{\\"address\\":\\"660 Rosewood Lane, New York, NY 10019, USA\\",\\"latlng\\":\\"40.873022,-73.86874\\",\\"title\\":\\"Manhattan Office\\",\\"image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/map-marker.png\\"},{\\"address\\":\\"33 Surya Paloh Crescent, NSW 2114, Australia\\",\\"latlng\\":\\"-33.8089747,151.08498480000003\\",\\"title\\":\\"Australia Office\\",\\"image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/map-marker.png\\"}]}}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\"}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 10,
  'post_date' => '2019-02-11 06:24:26',
  'post_date_gmt' => '2019-02-11 06:24:26',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h1>Ultra Coffee<br/>The best conversations are found at the bottom of a cup of coffee</h1>
<img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/coffee-bean-divider-300x21.png" width="300" alt="coffee bean divider" />
<a href="https://themify.me/demo/themes/ultra-coffee/shop" > Explore Our Coffees </a>
<h3>Contact Us</h3> <p>(+416) 456 1989</p> <p><a href="mailto:info@themify.me">info@coffee-skin.com</a></p>
<h3>Hours of Operation</h3> <p>MON – FRI: 7AM – 7PM<br />SAT – SUN: 5PM – 2AM<br />Bar only open on weekends.</p>
<h3>Location</h3> <p>50 Yonge Street <br />Toronto, ON MIW ZH3</p>
<h3>Welcome<br/>This is our story</h3>
<img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/coffee-bean-divider-300x21.png" width="300" alt="coffee bean divider" />
<p>Coffee is a brewed beverage using roasted coffee beans, the seeds of cherries from various Coffea species. The genus Coffea is native to tropical Africa, Madagascar, the Comoros, Mauritius, and Réunion in the Indian Ocean, amoung others.</p> <p>We\'ve never been so excited to share with you our coffee knowledge and the story that every bean can tell. Come on in, take a sip, and explore with us!</p>
<a href="https://themify.me/demo/themes/ultra-coffee/about/" > READ MORE </a>
<img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/image-coffee-590x460.jpg" width="590" alt="image coffee" />
<h3>Our Commitment<br/>We promise the best quality</h3>
<img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/coffee-bean-divider-300x21.png" width="300" alt="coffee bean divider" />
<img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/coffee-bean-image-100x100.png" width="100" title="Ethically Sourced Arabica Beans" alt="All of our arabica beans come from farms we&#039;ve been to. We meet the team, inspect the quality of their coffee trees, and tour the facilities. We ensure our coffee growers are paid fair wages." /> <h3> Ethically Sourced Arabica Beans </h3> All of our arabica beans come from farms we\'ve been to. We meet the team, inspect the quality of their coffee trees, and tour the facilities. We ensure our coffee growers are paid fair wages.
<img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/coffee-roasting-icon-100x100.png" width="100" title="Locally Roasting Coffee" alt="Roasting green beans transform their properties into the light, medium, or dark coffee beans you know of. We&#039;re proud of our technique, which has passed down the generations in our family." /> <h3> Locally Roasting Coffee </h3> Roasting green beans transform their properties into the light, medium, or dark coffee beans you know of. We\'re proud of our technique, which has passed down the generations in our family.
<img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/coffee-cup-100x100.png" width="100" title="Quality In Each Cup" alt="The quality is in the details. A coffee is sour if the brewing temperature was low, or if the cherry over-ripened before harvesting. We love coffee and we&#039;re invested every step of the way." /> <h3> Quality In Each Cup </h3> The quality is in the details. A coffee is sour if the brewing temperature was low, or if the cherry over-ripened before harvesting. We love coffee and we\'re invested every step of the way.
<h3>Our Menu<br/>Our specialities and popular favourites</h3>
<img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/coffee-bean-divider-300x21.png" width="300" alt="coffee bean divider" />
<img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/coffee-bean-griled-173x500.jpg" width="173" alt="coffee bean griled" />
<h4>Coffee</h4> 
 Tall Grande Venti
<h4>Caffè Americano</h4> 
 $3.60 $4.60 $5.60
<h4>Caffe Latte</h4> 
 $4.00 $5.00 $6.00
<h4>Cappuccino</h4> 
 $4.00 $5.00 $6.00
<h4>Caffè Mocha</h4> 
 $5.10 $6.10 $7.10
<h4>Caramel Macchiato</h4> 
 $5.40 $6.40 $7.40
<h4>Raspberry White</h4> 
 $5.70 $6.70 $7.70
<h4>Dolce De Late</h4> 
 $5.90 $6.90 $7.90
<img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/hot-coffee-cup-600x443.jpg" width="600" alt="hot-coffee-cup" srcset="https://themify.me/demo/themes/ultra-coffee/files/2019/02/hot-coffee-cup.jpg 600w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/hot-coffee-cup-500x369.jpg 500w" sizes="(max-width: 600px) 100vw, 600px" />
<img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/coffee-bean-cup-600x566.jpg" width="600" alt="coffee bean cup" />
<h4>Espresso</h4> 
 Single Double
<h4>Espresso</h4> 
 $3.00 $4.00
<h4>Espresso Macchiato</h4> 
 $4.00 $5.00
<h4>Espresso Con Panna</h4> 
 $4.20 $5.20
<h4>Brewed Coffee</h4> 
 Tall Grande Venti
<h4>Caffè Tradizionale</h4> 
 $3.00 $4.00 $5.00
<h4>Shot In The Dark</h4> 
 $6.00 $7.00 $8.00
<h4>Breads & Yogurt</h4>
<h4>Croissant</h4> 
 $4.00
<h4>Pain au Chocolat</h4> 
 $5.00
<h4>Yogurt & Granola Parfait</h4> 
 $6.50
<img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/breads-768x590.jpg" width="768" alt="breads" srcset="https://themify.me/demo/themes/ultra-coffee/files/2019/02/breads.jpg 768w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/breads-600x461.jpg 600w" sizes="(max-width: 768px) 100vw, 768px" />
<h3>Signature Coffee<br/>The Best Blend in the City</h3>
<img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/coffee-bean-divider-300x21.png" width="300" alt="coffee bean divider" />
<p>It all started with this one little roast... <br />Roasty sweet, rich, deep, and smooth - our Signature Coffee blend became an overnight success - we couldn\'t roast enough to keep up with daily demands! We\'ve added 11 new roast friends to keep her company, and they\'re being loved far and wide.</p>
<a href="https://themify.me/demo/themes/ultra-coffee/about/" > Explore All Roasts </a>
<h3>Online Coffee Shop<br/>Yours to love and brew at home</h3>
<img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/coffee-bean-divider-300x21.png" width="300" alt="coffee bean divider" />
<figure> <a href="https://themify.me/demo/themes/ultra-coffee/product/duo-coffee-steeper/"><img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/duo-coffee-mixer-275x275.jpg" width="275" height="275" alt="duo-coffee-mixer" srcset="https://themify.me/demo/themes/ultra-coffee/files/2019/02/duo-coffee-mixer-275x275.jpg 275w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/duo-coffee-mixer-150x150.jpg 150w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/duo-coffee-mixer-300x300.jpg 300w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/duo-coffee-mixer-100x100.jpg 100w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/duo-coffee-mixer-47x48.jpg 47w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/duo-coffee-mixer.jpg 560w" sizes="(max-width: 275px) 100vw, 275px" /></a> </figure> 
 
 <h3><a href="https://themify.me/demo/themes/ultra-coffee/product/duo-coffee-steeper/" title="Duo Coffee Steeper">Duo Coffee Steeper</a></h3> 
 &#36;99.00 <p><a href="/demo/themes/ultra-coffee/wp-admin/admin-ajax.php?add-to-cart=421" data-quantity="1" data-product_id="421" data-product_sku="" aria-label="Add &ldquo;Duo Coffee Steeper&rdquo; to your cart" rel="nofollow">Add to cart</a></p> [<a href="https://themify.me/demo/themes/ultra-coffee/wp-admin/post.php?post=421&#038;action=edit">Edit</a>] 
 
 <figure> <a href="https://themify.me/demo/themes/ultra-coffee/product/dukune-rwanda-coffee/"><img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/original-rwanda-coffee-275x275.jpg" width="275" height="275" alt="original-rwanda-coffee" srcset="https://themify.me/demo/themes/ultra-coffee/files/2019/02/original-rwanda-coffee-275x275.jpg 275w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/original-rwanda-coffee-150x150.jpg 150w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/original-rwanda-coffee-300x300.jpg 300w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/original-rwanda-coffee-100x100.jpg 100w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/original-rwanda-coffee-47x48.jpg 47w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/original-rwanda-coffee.jpg 560w" sizes="(max-width: 275px) 100vw, 275px" /></a> </figure> 
 
 <h3><a href="https://themify.me/demo/themes/ultra-coffee/product/dukune-rwanda-coffee/" title="Dukune Rwanda Coffee">Dukune Rwanda Coffee</a></h3> 
 &#36;10.00 <p><a href="/demo/themes/ultra-coffee/wp-admin/admin-ajax.php?add-to-cart=413" data-quantity="1" data-product_id="413" data-product_sku="" aria-label="Add &ldquo;Dukune Rwanda Coffee&rdquo; to your cart" rel="nofollow">Add to cart</a></p> [<a href="https://themify.me/demo/themes/ultra-coffee/wp-admin/post.php?post=413&#038;action=edit">Edit</a>] 
 
 <figure> <a href="https://themify.me/demo/themes/ultra-coffee/product/premium-le-mans-coffee/"><img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/lemans-drive-coffee-275x275.jpg" width="275" height="275" alt="lemans-drive-coffee" srcset="https://themify.me/demo/themes/ultra-coffee/files/2019/02/lemans-drive-coffee-275x275.jpg 275w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/lemans-drive-coffee-150x150.jpg 150w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/lemans-drive-coffee-300x300.jpg 300w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/lemans-drive-coffee-100x100.jpg 100w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/lemans-drive-coffee-47x48.jpg 47w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/lemans-drive-coffee.jpg 560w" sizes="(max-width: 275px) 100vw, 275px" /></a> </figure> 
 
 <h3><a href="https://themify.me/demo/themes/ultra-coffee/product/premium-le-mans-coffee/" title="Premium Le Mans Coffee">Premium Le Mans Coffee</a></h3> 
 &#36;25.00 <p><a href="/demo/themes/ultra-coffee/wp-admin/admin-ajax.php?add-to-cart=415" data-quantity="1" data-product_id="415" data-product_sku="" aria-label="Add &ldquo;Premium Le Mans Coffee&rdquo; to your cart" rel="nofollow">Add to cart</a></p> [<a href="https://themify.me/demo/themes/ultra-coffee/wp-admin/post.php?post=415&#038;action=edit">Edit</a>] 
 
 <figure> <a href="https://themify.me/demo/themes/ultra-coffee/product/keto-french-vanilla/"><img src="https://themify.me/demo/themes/ultra-coffee/files/2019/02/ketp-french-vamila-275x275.jpg" width="275" height="275" alt="ketp-french-vamila" srcset="https://themify.me/demo/themes/ultra-coffee/files/2019/02/ketp-french-vamila-275x275.jpg 275w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/ketp-french-vamila-150x150.jpg 150w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/ketp-french-vamila-300x300.jpg 300w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/ketp-french-vamila-100x100.jpg 100w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/ketp-french-vamila-47x48.jpg 47w, https://themify.me/demo/themes/ultra-coffee/files/2019/02/ketp-french-vamila.jpg 560w" sizes="(max-width: 275px) 100vw, 275px" /></a> </figure> 
 
 <h3><a href="https://themify.me/demo/themes/ultra-coffee/product/keto-french-vanilla/" title="Keto French Vanilla">Keto French Vanilla</a></h3> 
 &#36;10.00 <p><a href="/demo/themes/ultra-coffee/wp-admin/admin-ajax.php?add-to-cart=418" data-quantity="1" data-product_id="418" data-product_sku="" aria-label="Add &ldquo;Keto French Vanilla&rdquo; to your cart" rel="nofollow">Add to cart</a></p> [<a href="https://themify.me/demo/themes/ultra-coffee/wp-admin/post.php?post=418&#038;action=edit">Edit</a>]
<a href="https://themify.me/demo/themes/ultra-coffee/shop/" > Explore Our Coffees </a><!--/themify_builder_static-->',
  'post_title' => 'Home',
  'post_excerpt' => '',
  'post_name' => 'home',
  'post_modified' => '2019-09-07 00:43:12',
  'post_modified_gmt' => '2019-09-07 00:43:12',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-coffee/?page_id=10',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"464eb49\\",\\"cols\\":[{\\"element_id\\":\\"3f289e4\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"01f96de\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"40\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#ffffff\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"2.5\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"font_family_subheading\\":\\"Playfair Display\\",\\"font_weight_subheading\\":\\"regular\\",\\"font_color_subheading\\":\\"#ffffff\\",\\"font_size_subheading\\":\\"0.8\\",\\"font_size_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"font_family_subheading\\":\\"Playfair Display\\",\\"font_weight_subheading\\":\\"regular\\",\\"font_size_subheading\\":\\"1\\",\\"font_size_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\"},\\"heading\\":\\"Ultra Coffee\\",\\"sub_heading\\":\\"The best conversations are found at the bottom of a cup of coffee\\",\\"heading_tag\\":\\"h1\\",\\"text_alignment\\":\\"themify-text-center\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"2\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"font_family_subheading\\":\\"Playfair Display\\",\\"font_weight_subheading\\":\\"regular\\",\\"font_size_subheading\\":\\"1\\",\\"font_size_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\"},\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"2.2\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"font_family_subheading\\":\\"Playfair Display\\",\\"font_weight_subheading\\":\\"regular\\",\\"font_size_subheading\\":\\"1\\",\\"font_size_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\"}}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"f0b96dd\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"40\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/coffee-bean-divider.png\\",\\"width_image\\":\\"300\\",\\"param_image\\":\\"regular\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"13e4e4c\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"font_weight\\":\\"bold\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"button_background_color\\":\\"#c59d5f\\",\\"button_hover_background_color\\":\\"#9c6e2e\\",\\"link_color\\":\\"#ffffff\\",\\"padding_link_top\\":\\"20\\",\\"padding_link_right\\":\\"40\\",\\"padding_link_bottom\\":\\"20\\",\\"padding_link_left\\":\\"40\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"font_weight\\":\\"bold\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"70\\",\\"border-type\\":\\"top\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\"},\\"buttons_size\\":\\"large\\",\\"buttons_shape\\":\\"squared\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Explore Our Coffees\\",\\"link\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/shop\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"}],\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"font_weight\\":\\"bold\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\"}}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/bg-hero-banner-home-1600x947.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#ffffff\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"16\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"d49039f\\",\\"cols\\":[{\\"element_id\\":\\"edf5dc2\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"1c21584\\",\\"cols\\":[{\\"element_id\\":\\"3f04099\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"2c51a2a\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<h3>Contact Us<\\\\/h3>\\\\n<p>(+416) 456 1989<\\\\/p>\\\\n<p><a href=\\\\\\\\\\\\\\"mailto:info@themify.me\\\\\\\\\\\\\\">info@coffee-skin.com<\\\\/a><\\\\/p>\\"}}]},{\\"element_id\\":\\"25b4c40\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"j7rp367\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<h3>Hours of Operation<\\\\/h3>\\\\n<p>MON – FRI: 7AM – 7PM<br \\\\/>SAT – SUN: 5PM – 2AM<br \\\\/>Bar only open on weekends.<\\\\/p>\\"}}]},{\\"element_id\\":\\"fc8b19f\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"f9ii368\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<h3>Location<\\\\/h3>\\\\n<p>50 Yonge Street <br \\\\/>Toronto, ON MIW ZH3<\\\\/p>\\"}}]}],\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column3-1\\"}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#ffffff\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"40\\",\\"padding_bottom\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_bottom\\":\\"0\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"},\\"b_sh_color\\":\\"#000000_0.09\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_blur\\":\\"24\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"2\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_hOffset\\":\\"0\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin-top\\":\\"-90\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"7f1f04c\\",\\"cols\\":[{\\"element_id\\":\\"7928ae4\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"d137649\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#c59d5f\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"2.6\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading\\":\\"1.3\\",\\"font_size_subheading_unit\\":\\"em\\",\\"line_height_subheading_unit\\":\\"em\\",\\"sub_margin_bottom\\":\\"40\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"36\\",\\"font_size_subheading\\":\\"20\\",\\"line_height_subheading\\":\\"1\\",\\"line_height_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\"},\\"heading\\":\\"Welcome\\",\\"sub_heading\\":\\"This is our story\\",\\"heading_tag\\":\\"h3\\",\\"text_alignment\\":\\"themify-text-center\\",\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"2\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading\\":\\"1\\",\\"font_size_subheading_unit\\":\\"em\\",\\"line_height_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\"}}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"giok368\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"40\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/coffee-bean-divider.png\\",\\"width_image\\":\\"300\\",\\"param_image\\":\\"regular\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"a59a4ac\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_right\\":\\"30\\",\\"padding_left\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Coffee is a brewed beverage using roasted coffee beans, the seeds of cherries from various Coffea species. The genus Coffea is native to tropical Africa, Madagascar, the Comoros, Mauritius, and Réunion in the Indian Ocean, amoung others.<\\\\/p>\\\\n<p>We\\\\\\\\\\\'ve never been so excited to share with you our coffee knowledge and the story that every bean can tell. Come on in, take a sip, and explore with us!<\\\\/p>\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"zw5h369\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"16\\",\\"font_weight\\":\\"bold\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"20\\",\\"margin_bottom\\":\\"20\\",\\"border-type\\":\\"top\\",\\"link_color\\":\\"#c59d5f\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\",\\"buttons_size\\":\\"large\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_style\\":\\"transparent\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"READ MORE\\",\\"link\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/about\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"}],\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_weight\\":\\"bold\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"0\\",\\"margin_bottom\\":\\"50\\",\\"border-type\\":\\"top\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\"}}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"4b18274\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"19c5790\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/image-coffee-590x460.jpg\\",\\"width_image\\":\\"590\\",\\"param_image\\":\\"regular\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"}}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"15\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"9\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"87ce21a\\",\\"cols\\":[{\\"element_id\\":\\"78f119c\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"vjpv369\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#c59d5f\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"2.6\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading\\":\\"1.3\\",\\"font_size_subheading_unit\\":\\"em\\",\\"line_height_subheading_unit\\":\\"em\\",\\"sub_margin_bottom\\":\\"40\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"2\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading\\":\\"1\\",\\"font_size_subheading_unit\\":\\"em\\",\\"line_height_subheading\\":\\"1\\",\\"line_height_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\"},\\"heading\\":\\"Our Commitment\\",\\"sub_heading\\":\\"We promise the best quality\\",\\"heading_tag\\":\\"h3\\",\\"text_alignment\\":\\"themify-text-center\\",\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"2\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading\\":\\"1\\",\\"font_size_subheading_unit\\":\\"em\\",\\"line_height_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\"}}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"yemm369\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"80\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/coffee-bean-divider.png\\",\\"width_image\\":\\"300\\",\\"param_image\\":\\"regular\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"50\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"}}},{\\"element_id\\":\\"d9c56c1\\",\\"cols\\":[{\\"element_id\\":\\"1e13a17\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"f7cb5ed\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_right\\":\\"20\\",\\"padding_left\\":\\"20\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"},\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/coffee-bean-image-100x100.png\\",\\"width_image\\":\\"100\\",\\"title_image\\":\\"Ethically Sourced Arabica Beans\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"All of our arabica beans come from farms we\\\\\\\\\\\'ve been to. We meet the team, inspect the quality of their coffee trees, and tour the facilities. We ensure our coffee growers are paid fair wages. \\"}}]},{\\"element_id\\":\\"d82c843\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"1d8a370\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_right\\":\\"20\\",\\"padding_left\\":\\"20\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"},\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/coffee-roasting-icon-100x100.png\\",\\"width_image\\":\\"100\\",\\"title_image\\":\\"Locally Roasting Coffee\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Roasting green beans transform their properties into the light, medium, or dark coffee beans you know of. We\\\\\\\\\\\'re proud of our technique, which has passed down the generations in our family.\\"}}]},{\\"element_id\\":\\"3e08bff\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"00zl370\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_right\\":\\"20\\",\\"padding_left\\":\\"20\\",\\"margin_bottom\\":\\"0\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"},\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/coffee-cup.png\\",\\"width_image\\":\\"100\\",\\"title_image\\":\\"Quality In Each Cup\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"The quality is in the details. A coffee is sour if the brewing temperature was low, or if the cherry over-ripened before harvesting. We love coffee and we\\\\\\\\\\\'re invested every step of the way.\\"}}]}],\\"col_tablet\\":\\"column-full\\"}],\\"styling\\":{\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_right\\":\\"3\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"3\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/bg-coffee-doodle-1600x863.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-bottom\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-bottom\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"13\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"row_width\\":\\"fullwidth\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-bottom\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"ee1c314\\",\\"cols\\":[{\\"element_id\\":\\"2ec22cf\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"c9df371\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#c59d5f\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"2.6\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading\\":\\"1.3\\",\\"font_size_subheading_unit\\":\\"em\\",\\"line_height_subheading_unit\\":\\"em\\",\\"sub_margin_bottom\\":\\"40\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"2\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading\\":\\"1\\",\\"font_size_subheading_unit\\":\\"em\\",\\"line_height_subheading\\":\\"1.5\\",\\"line_height_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\"},\\"heading\\":\\"Our Menu\\",\\"sub_heading\\":\\"Our specialities and popular favourites\\",\\"heading_tag\\":\\"h3\\",\\"text_alignment\\":\\"themify-text-center\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"2\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading\\":\\"1\\",\\"font_size_subheading_unit\\":\\"em\\",\\"line_height_subheading\\":\\"1.5\\",\\"line_height_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\"},\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"2\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading\\":\\"1\\",\\"font_size_subheading_unit\\":\\"em\\",\\"line_height_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\"}}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"2bjf371\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/coffee-bean-divider.png\\",\\"width_image\\":\\"300\\",\\"param_image\\":\\"regular\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"}}},{\\"element_id\\":\\"8be93b0\\",\\"cols\\":[{\\"element_id\\":\\"40eeb57\\",\\"grid_class\\":\\"col3-2\\"},{\\"element_id\\":\\"e2824e5\\",\\"grid_class\\":\\"col3-1\\"}]}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_bottom\\":\\"0\\",\\"border-type\\":\\"top\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_opp_left\\":\\"\\",\\"padding_opp_top\\":\\"\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"d6883b7\\",\\"cols\\":[{\\"element_id\\":\\"37c3a8c\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"element_id\\":\\"0f07877\\",\\"cols\\":[{\\"element_id\\":\\"bb61206\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"ba1fbb1\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/coffee-bean-griled.jpg\\",\\"width_image\\":\\"173\\",\\"param_image\\":\\"regular\\",\\"visibility_tablet\\":\\"hide\\",\\"visibility_mobile\\":\\"hide\\"}}]},{\\"element_id\\":\\"e675a8a\\",\\"grid_class\\":\\"col4-3\\",\\"modules\\":[{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"1ef8baf\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1.5\\",\\"font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"bottom\\",\\"border_bottom_color\\":\\"#c59d5f\\",\\"border_bottom_width\\":\\"2\\",\\"font_title_bold\\":\\"bold\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\",\\"style_service_menu\\":\\"image-horizontal\\",\\"title_service_menu\\":\\"Coffee\\",\\"price_service_menu\\":\\"$200\\",\\"add_price_check\\":\\"yes\\",\\"price_fields_holder\\":[{\\"label\\":\\"Tall\\"},{\\"label\\":\\"Grande\\"},{\\"label\\":\\"Venti\\"}],\\"width_service_menu\\":\\"100\\",\\"link_options\\":\\"regular\\",\\"breakpoint_mobile\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1.1\\",\\"font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"20\\",\\"border-type\\":\\"bottom\\",\\"border_bottom_color\\":\\"#c59d5f\\",\\"border_bottom_width\\":\\"2\\",\\"font_title_bold\\":\\"bold\\",\\"font_size_price\\":\\"0.8\\",\\"font_size_price_unit\\":\\"em\\",\\"t_price_margin_top\\":\\"5\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\"},\\"breakpoint_tablet\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"bottom\\",\\"border_bottom_color\\":\\"#c59d5f\\",\\"border_bottom_width\\":\\"2\\",\\"font_title_bold\\":\\"bold\\",\\"font_size_price\\":\\"0.8\\",\\"font_size_price_unit\\":\\"em\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\"},\\"breakpoint_tablet_landscape\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"bottom\\",\\"border_bottom_color\\":\\"#c59d5f\\",\\"border_bottom_width\\":\\"2\\",\\"font_title_bold\\":\\"bold\\",\\"font_size_price\\":\\"0.8\\",\\"font_size_price_unit\\":\\"em\\",\\"t_price_margin_top\\":\\"8\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\"}}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"b2d956a\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_family_price\\":\\"Playfair Display\\",\\"font_weight_price\\":\\"regular\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\",\\"style_service_menu\\":\\"image-horizontal\\",\\"title_service_menu\\":\\"Caffè Americano\\",\\"price_service_menu\\":\\"$200\\",\\"add_price_check\\":\\"yes\\",\\"price_fields_holder\\":[{\\"price\\":\\"$3.60\\"},{\\"price\\":\\"$4.60\\"},{\\"price\\":\\"$5.60\\"}],\\"width_service_menu\\":\\"100\\",\\"link_options\\":\\"regular\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"kh2i372\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_family_price\\":\\"Playfair Display\\",\\"font_weight_price\\":\\"regular\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\",\\"style_service_menu\\":\\"image-horizontal\\",\\"title_service_menu\\":\\"Caffe Latte\\",\\"price_service_menu\\":\\"$200\\",\\"add_price_check\\":\\"yes\\",\\"price_fields_holder\\":[{\\"price\\":\\"$4.00\\"},{\\"price\\":\\"$5.00\\"},{\\"price\\":\\"$6.00\\"}],\\"width_service_menu\\":\\"100\\",\\"link_options\\":\\"regular\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"7e1d373\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_family_price\\":\\"Playfair Display\\",\\"font_weight_price\\":\\"regular\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\",\\"style_service_menu\\":\\"image-horizontal\\",\\"title_service_menu\\":\\"Cappuccino\\",\\"price_service_menu\\":\\"$200\\",\\"add_price_check\\":\\"yes\\",\\"price_fields_holder\\":[{\\"price\\":\\"$4.00\\"},{\\"price\\":\\"$5.00\\"},{\\"price\\":\\"$6.00\\"}],\\"width_service_menu\\":\\"100\\",\\"link_options\\":\\"regular\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"0ai7373\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_family_price\\":\\"Playfair Display\\",\\"font_weight_price\\":\\"regular\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\",\\"style_service_menu\\":\\"image-horizontal\\",\\"title_service_menu\\":\\"Caffè Mocha\\",\\"price_service_menu\\":\\"$200\\",\\"add_price_check\\":\\"yes\\",\\"price_fields_holder\\":[{\\"price\\":\\"$5.10\\"},{\\"price\\":\\"$6.10\\"},{\\"price\\":\\"$7.10\\"}],\\"width_service_menu\\":\\"100\\",\\"link_options\\":\\"regular\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"scnl373\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_family_price\\":\\"Playfair Display\\",\\"font_weight_price\\":\\"regular\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\",\\"style_service_menu\\":\\"image-horizontal\\",\\"title_service_menu\\":\\"Caramel Macchiato\\",\\"price_service_menu\\":\\"$200\\",\\"add_price_check\\":\\"yes\\",\\"price_fields_holder\\":[{\\"price\\":\\"$5.40\\"},{\\"price\\":\\"$6.40\\"},{\\"price\\":\\"$7.40\\"}],\\"width_service_menu\\":\\"100\\",\\"link_options\\":\\"regular\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"ea6x373\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_family_price\\":\\"Playfair Display\\",\\"font_weight_price\\":\\"regular\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\",\\"style_service_menu\\":\\"image-horizontal\\",\\"title_service_menu\\":\\"Raspberry White\\",\\"price_service_menu\\":\\"$200\\",\\"add_price_check\\":\\"yes\\",\\"price_fields_holder\\":[{\\"price\\":\\"$5.70\\"},{\\"price\\":\\"$6.70\\"},{\\"price\\":\\"$7.70\\"}],\\"width_service_menu\\":\\"100\\",\\"link_options\\":\\"regular\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"xvlg373\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_family_price\\":\\"Playfair Display\\",\\"font_weight_price\\":\\"regular\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\",\\"style_service_menu\\":\\"image-horizontal\\",\\"title_service_menu\\":\\"Dolce De Late\\",\\"price_service_menu\\":\\"$200\\",\\"add_price_check\\":\\"yes\\",\\"price_fields_holder\\":[{\\"price\\":\\"$5.90\\"},{\\"price\\":\\"$6.90\\"},{\\"price\\":\\"$7.90\\"}],\\"width_service_menu\\":\\"100\\",\\"link_options\\":\\"regular\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"0\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}}],\\"mobile_dir\\":\\"rtl\\",\\"col_tablet\\":\\"column-full\\"}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"best-fit-image\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-bottom\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_right_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"best-fit-image\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-bottom\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"best-fit-image\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-bottom\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"0\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"best-fit-image\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-bottom\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"2eb563b\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"79499f0\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-right\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/hot-coffee-cup.jpg\\",\\"width_image\\":\\"600\\",\\"param_image\\":\\"regular\\"}}]}],\\"col_tablet_landscape\\":\\"column3-2-3-1\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"best-fit-image\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/coffee-grilled-powder-tablet.jpg\\",\\"background_repeat\\":\\"best-fit-image\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#ffffff\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"best-fit-image\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"row_width\\":\\"fullwidth-content\\"}},{\\"element_id\\":\\"e5c37a3\\",\\"cols\\":[{\\"element_id\\":\\"33f1e36\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"69139af\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"},\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/coffee-bean-cup-600x566.jpg\\",\\"width_image\\":\\"600\\",\\"param_image\\":\\"regular\\"}}]},{\\"element_id\\":\\"4dae386\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"element_id\\":\\"9640bc6\\",\\"cols\\":[{\\"element_id\\":\\"164e4a6\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"dko5374\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1.5\\",\\"font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"bottom\\",\\"border_bottom_color\\":\\"#c59d5f\\",\\"border_bottom_width\\":\\"2\\",\\"font_title_bold\\":\\"bold\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\",\\"style_service_menu\\":\\"image-horizontal\\",\\"title_service_menu\\":\\"Espresso\\",\\"price_service_menu\\":\\"$200\\",\\"add_price_check\\":\\"yes\\",\\"price_fields_holder\\":[{\\"label\\":\\"Single\\"},{\\"label\\":\\"Double\\"}],\\"width_service_menu\\":\\"100\\",\\"link_options\\":\\"regular\\",\\"breakpoint_mobile\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1.1\\",\\"font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"20\\",\\"border-type\\":\\"bottom\\",\\"border_bottom_color\\":\\"#c59d5f\\",\\"border_bottom_width\\":\\"2\\",\\"font_title_bold\\":\\"bold\\",\\"font_size_price\\":\\"0.8\\",\\"font_size_price_unit\\":\\"em\\",\\"t_price_margin_top\\":\\"8\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\"},\\"breakpoint_tablet\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"bottom\\",\\"border_bottom_color\\":\\"#c59d5f\\",\\"border_bottom_width\\":\\"2\\",\\"font_title_bold\\":\\"bold\\",\\"font_size_price\\":\\"0.8\\",\\"font_size_price_unit\\":\\"em\\",\\"t_price_margin_top\\":\\"8\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\"},\\"breakpoint_tablet_landscape\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"bottom\\",\\"border_bottom_color\\":\\"#c59d5f\\",\\"border_bottom_width\\":\\"2\\",\\"font_title_bold\\":\\"bold\\",\\"font_size_price\\":\\"0.8\\",\\"font_size_price_unit\\":\\"em\\",\\"t_price_margin_top\\":\\"10\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\"}}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"bf02394\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_family_price\\":\\"Playfair Display\\",\\"font_weight_price\\":\\"regular\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_family_price\\":\\"Playfair Display\\",\\"font_weight_price\\":\\"regular\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\"},\\"style_service_menu\\":\\"image-horizontal\\",\\"title_service_menu\\":\\"Espresso\\",\\"price_service_menu\\":\\"$200\\",\\"add_price_check\\":\\"yes\\",\\"price_fields_holder\\":[{\\"price\\":\\"$3.00\\"},{\\"price\\":\\"$4.00\\"}],\\"width_service_menu\\":\\"100\\",\\"link_options\\":\\"regular\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"0pq4374\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_family_price\\":\\"Playfair Display\\",\\"font_weight_price\\":\\"regular\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\",\\"style_service_menu\\":\\"image-horizontal\\",\\"title_service_menu\\":\\"Espresso Macchiato\\",\\"price_service_menu\\":\\"$200\\",\\"add_price_check\\":\\"yes\\",\\"price_fields_holder\\":[{\\"price\\":\\"$4.00\\"},{\\"price\\":\\"$5.00\\"}],\\"width_service_menu\\":\\"100\\",\\"link_options\\":\\"regular\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"1k6j374\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_family_price\\":\\"Playfair Display\\",\\"font_weight_price\\":\\"regular\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\",\\"style_service_menu\\":\\"image-horizontal\\",\\"title_service_menu\\":\\"Espresso Con Panna\\",\\"price_service_menu\\":\\"$200\\",\\"add_price_check\\":\\"yes\\",\\"price_fields_holder\\":[{\\"price\\":\\"$4.20\\"},{\\"price\\":\\"$5.20\\"}],\\"width_service_menu\\":\\"100\\",\\"link_options\\":\\"regular\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"mc7g375\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1.5\\",\\"font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"30\\",\\"border-type\\":\\"bottom\\",\\"border_bottom_color\\":\\"#c59d5f\\",\\"border_bottom_width\\":\\"2\\",\\"font_title_bold\\":\\"bold\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1.1\\",\\"font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"20\\",\\"border-type\\":\\"bottom\\",\\"border_bottom_color\\":\\"#c59d5f\\",\\"border_bottom_width\\":\\"2\\",\\"font_title_bold\\":\\"bold\\",\\"font_size_price\\":\\"0.8\\",\\"font_size_price_unit\\":\\"em\\",\\"t_price_margin_top\\":\\"15\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\"},\\"style_service_menu\\":\\"image-horizontal\\",\\"title_service_menu\\":\\"Brewed Coffee\\",\\"price_service_menu\\":\\"$200\\",\\"add_price_check\\":\\"yes\\",\\"price_fields_holder\\":[{\\"label\\":\\"Tall\\"},{\\"label\\":\\"Grande\\"},{\\"label\\":\\"Venti\\"}],\\"width_service_menu\\":\\"100\\",\\"link_options\\":\\"regular\\",\\"breakpoint_tablet\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"bottom\\",\\"border_bottom_color\\":\\"#c59d5f\\",\\"border_bottom_width\\":\\"2\\",\\"font_title_bold\\":\\"bold\\",\\"font_size_price\\":\\"0.8\\",\\"font_size_price_unit\\":\\"em\\",\\"t_price_margin_top\\":\\"10\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\"},\\"breakpoint_tablet_landscape\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"bottom\\",\\"border_bottom_color\\":\\"#c59d5f\\",\\"border_bottom_width\\":\\"2\\",\\"font_title_bold\\":\\"bold\\",\\"font_size_price\\":\\"0.8\\",\\"font_size_price_unit\\":\\"em\\",\\"t_price_margin_top\\":\\"8\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\"}}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"vt2e375\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_family_price\\":\\"Playfair Display\\",\\"font_weight_price\\":\\"regular\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\",\\"style_service_menu\\":\\"image-horizontal\\",\\"title_service_menu\\":\\"Caffè Tradizionale\\",\\"price_service_menu\\":\\"$200\\",\\"add_price_check\\":\\"yes\\",\\"price_fields_holder\\":[{\\"price\\":\\"$3.00\\"},{\\"price\\":\\"$4.00\\"},{\\"price\\":\\"$5.00\\"}],\\"width_service_menu\\":\\"100\\",\\"link_options\\":\\"regular\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"045k375\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_family_price\\":\\"Playfair Display\\",\\"font_weight_price\\":\\"regular\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\",\\"style_service_menu\\":\\"image-horizontal\\",\\"title_service_menu\\":\\"Shot In The Dark\\",\\"price_service_menu\\":\\"$200\\",\\"add_price_check\\":\\"yes\\",\\"price_fields_holder\\":[{\\"price\\":\\"$6.00\\"},{\\"price\\":\\"$7.00\\"},{\\"price\\":\\"$8.00\\"}],\\"width_service_menu\\":\\"100\\",\\"link_options\\":\\"regular\\"}}]},{\\"element_id\\":\\"5e81bbb\\",\\"grid_class\\":\\"col3-1\\"}],\\"col_tablet_landscape\\":\\"column4-3-4-1\\",\\"col_tablet\\":\\"column-full\\"}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}}],\\"column_alignment\\":\\"col_align_middle\\",\\"mobile_dir\\":\\"rtl\\",\\"col_tablet\\":\\"column-full\\",\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#ffffff\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#ffffff\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#ffffff\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"row_width\\":\\"fullwidth-content\\"}},{\\"element_id\\":\\"2f186ac\\",\\"cols\\":[{\\"element_id\\":\\"32fae0a\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"81faaf7\\",\\"cols\\":[{\\"element_id\\":\\"7243da1\\",\\"grid_class\\":\\"col4-1\\"},{\\"element_id\\":\\"117a217\\",\\"grid_class\\":\\"col4-3\\",\\"modules\\":[{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"doyy376\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1.5\\",\\"font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"bottom\\",\\"border_bottom_color\\":\\"#c59d5f\\",\\"border_bottom_width\\":\\"2\\",\\"font_title_bold\\":\\"bold\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1.1\\",\\"font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"20\\",\\"border-type\\":\\"bottom\\",\\"border_bottom_color\\":\\"#c59d5f\\",\\"border_bottom_width\\":\\"2\\",\\"font_title_bold\\":\\"bold\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\"},\\"style_service_menu\\":\\"image-horizontal\\",\\"title_service_menu\\":\\"Breads & Yogurt\\",\\"price_fields_holder\\":[{\\"label\\":\\"Tall\\"},{\\"label\\":\\"Grande\\"},{\\"label\\":\\"Venti\\"}],\\"width_service_menu\\":\\"100\\",\\"link_options\\":\\"regular\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"jpvi376\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_family_price\\":\\"Playfair Display\\",\\"font_weight_price\\":\\"regular\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\",\\"style_service_menu\\":\\"image-horizontal\\",\\"title_service_menu\\":\\"Croissant\\",\\"price_service_menu\\":\\"$4.00\\",\\"add_price_check\\":\\"yes\\",\\"price_fields_holder\\":[{\\"price\\":\\"$4.00\\"}],\\"width_service_menu\\":\\"100\\",\\"link_options\\":\\"regular\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"lmt7376\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_family_price\\":\\"Playfair Display\\",\\"font_weight_price\\":\\"regular\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\",\\"style_service_menu\\":\\"image-horizontal\\",\\"title_service_menu\\":\\"Pain au Chocolat\\",\\"price_service_menu\\":\\"$5.00\\",\\"add_price_check\\":\\"yes\\",\\"price_fields_holder\\":[{\\"price\\":\\"$5.00\\"}],\\"width_service_menu\\":\\"100\\",\\"link_options\\":\\"regular\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"adj2376\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_family_price\\":\\"Playfair Display\\",\\"font_weight_price\\":\\"regular\\",\\"checkbox_h_t_p_apply_all\\":\\"1\\",\\"checkbox_h_t_m_apply_all\\":\\"1\\",\\"style_service_menu\\":\\"image-horizontal\\",\\"title_service_menu\\":\\"Yogurt & Granola Parfait\\",\\"price_service_menu\\":\\"$4.00\\",\\"add_price_check\\":\\"yes\\",\\"price_fields_holder\\":[{\\"price\\":\\"$6.50\\"}],\\"width_service_menu\\":\\"100\\",\\"link_options\\":\\"regular\\"}}]}],\\"col_tablet\\":\\"column-full\\"}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"90fe811\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"c0f8be9\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-right\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/breads.jpg\\",\\"width_image\\":\\"768\\",\\"param_image\\":\\"regular\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#ffffff\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#ffffff\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#ffffff\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"row_width\\":\\"fullwidth-content\\"}},{\\"element_id\\":\\"7b00361\\",\\"cols\\":[{\\"element_id\\":\\"aokz377\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"m4v4377\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#c59d5f\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"2.6\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading\\":\\"1.3\\",\\"font_size_subheading_unit\\":\\"em\\",\\"line_height_subheading_unit\\":\\"em\\",\\"sub_margin_bottom\\":\\"40\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"2\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading\\":\\"1\\",\\"font_size_subheading_unit\\":\\"em\\",\\"line_height_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\"},\\"heading\\":\\"Signature Coffee\\",\\"sub_heading\\":\\"The Best Blend in the City\\",\\"heading_tag\\":\\"h3\\",\\"text_alignment\\":\\"themify-text-center\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"2\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading\\":\\"1\\",\\"font_size_subheading_unit\\":\\"em\\",\\"line_height_subheading\\":\\"1.5\\",\\"line_height_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\"},\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"2\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading\\":\\"1\\",\\"font_size_subheading_unit\\":\\"em\\",\\"line_height_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\"}}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"bb0e377\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"50\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/coffee-bean-divider.png\\",\\"width_image\\":\\"300\\",\\"param_image\\":\\"regular\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"xb7w377\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_right\\":\\"30\\",\\"padding_left\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>It all started with this one little roast... <br \\\\/>Roasty sweet, rich, deep, and smooth - our Signature Coffee blend became an overnight success - we couldn\\\\\\\\\\\'t roast enough to keep up with daily demands! We\\\\\\\\\\\'ve added 11 new roast friends to keep her company, and they\\\\\\\\\\\'re being loved far and wide.<\\\\/p>\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"fc19f3f\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"20\\",\\"border-type\\":\\"top\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\",\\"buttons_size\\":\\"xlarge\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_style\\":\\"outline\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Explore All Roasts\\",\\"link\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/about\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"}]}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"7dced11\\",\\"grid_class\\":\\"col4-2\\"}],\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/sugnature-bg-image-1600x815.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#000000_0.50\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#ffffff\\",\\"padding_top\\":\\"7\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"7\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"15\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"695ebc5\\",\\"cols\\":[{\\"element_id\\":\\"988fad9\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"uf2c377\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#c59d5f\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"2.6\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading\\":\\"1.3\\",\\"font_size_subheading_unit\\":\\"em\\",\\"line_height_subheading_unit\\":\\"em\\",\\"sub_margin_bottom\\":\\"40\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"2\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading\\":\\"1\\",\\"font_size_subheading_unit\\":\\"em\\",\\"line_height_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\"},\\"heading\\":\\"Online Coffee Shop\\",\\"sub_heading\\":\\"Yours to love and brew at home\\",\\"heading_tag\\":\\"h3\\",\\"text_alignment\\":\\"themify-text-center\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"2\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading\\":\\"1\\",\\"font_size_subheading_unit\\":\\"em\\",\\"line_height_subheading\\":\\"1.5\\",\\"line_height_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\"},\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"2\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading\\":\\"1\\",\\"font_size_subheading_unit\\":\\"em\\",\\"line_height_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\",\\"d_border_top_style\\":\\"none\\"}}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"qdbe378\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"80\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/files\\\\/2019\\\\/02\\\\/coffee-bean-divider.png\\",\\"width_image\\":\\"300\\",\\"param_image\\":\\"regular\\"}},{\\"mod_name\\":\\"products\\",\\"element_id\\":\\"c0b9855\\",\\"mod_settings\\":{\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"60\\",\\"border-type\\":\\"top\\",\\"checkbox_p_p_ctr_apply_all\\":\\"1\\",\\"checkbox_m_p_ctr_apply_all\\":\\"1\\",\\"b_p_ctr-type\\":\\"top\\",\\"checkbox_p_p_ct_apply_all\\":\\"1\\",\\"checkbox_m_p_ct_apply_all\\":\\"1\\",\\"b_p_ct-type\\":\\"top\\",\\"checkbox_p_p_t_apply_all\\":\\"1\\",\\"checkbox_m_p_t_apply_all\\":\\"1\\",\\"b_p_t-type\\":\\"top\\",\\"checkbox_p_p_p_apply_all\\":\\"1\\",\\"checkbox_m_p_p_apply_all\\":\\"1\\",\\"b_p_p-type\\":\\"top\\",\\"checkbox_p_p_b_apply_all\\":\\"1\\",\\"checkbox_m_p_b_apply_all\\":\\"1\\",\\"b_p_b-type\\":\\"top\\",\\"query_products\\":\\"all\\",\\"category_products\\":\\"0|multiple\\",\\"hide_child_products\\":\\"no\\",\\"hide_free_products\\":\\"no\\",\\"hide_outofstock_products\\":\\"no\\",\\"post_per_page_products\\":\\"4\\",\\"orderby_products\\":\\"date\\",\\"order_products\\":\\"desc\\",\\"template_products\\":\\"list\\",\\"layout_products\\":\\"grid4\\",\\"layout_slider\\":\\"slider-default\\",\\"visible_opt_slider\\":\\"1\\",\\"mob_visible_opt_slider\\":\\"0\\",\\"auto_scroll_opt_slider\\":\\"off\\",\\"scroll_opt_slider\\":\\"1\\",\\"speed_opt_slider\\":\\"normal\\",\\"effect_slider\\":\\"scroll\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"wrap_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"yes\\",\\"show_arrow_slider\\":\\"yes\\",\\"height_slider\\":\\"variable\\",\\"description_products\\":\\"none\\",\\"hide_feat_img_products\\":\\"no\\",\\"img_width_products\\":\\"275\\",\\"img_height_products\\":\\"275\\",\\"unlink_feat_img_products\\":\\"no\\",\\"hide_post_title_products\\":\\"no\\",\\"unlink_post_title_products\\":\\"no\\",\\"hide_price_products\\":\\"no\\",\\"hide_add_to_cart_products\\":\\"no\\",\\"hide_rating_products\\":\\"no\\",\\"hide_sales_badge\\":\\"no\\",\\"hide_page_nav_products\\":\\"yes\\",\\"breakpoint_mobile\\":{\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"checkbox_p_p_ctr_apply_all\\":\\"1\\",\\"checkbox_m_p_ctr_apply_all\\":\\"1\\",\\"b_p_ctr-type\\":\\"top\\",\\"checkbox_p_p_ct_apply_all\\":\\"1\\",\\"checkbox_m_p_ct_apply_all\\":\\"1\\",\\"b_p_ct-type\\":\\"top\\",\\"checkbox_p_p_t_apply_all\\":\\"1\\",\\"checkbox_m_p_t_apply_all\\":\\"1\\",\\"b_p_t-type\\":\\"top\\",\\"checkbox_p_p_p_apply_all\\":\\"1\\",\\"checkbox_m_p_p_apply_all\\":\\"1\\",\\"b_p_p-type\\":\\"top\\",\\"checkbox_p_p_b_apply_all\\":\\"1\\",\\"checkbox_m_p_b_apply_all\\":\\"1\\",\\"b_p_b-type\\":\\"top\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"rjjw378\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"font_weight\\":\\"bold\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"button_background_color\\":\\"#c59d5f\\",\\"button_hover_background_color\\":\\"#9c6e2e\\",\\"link_color\\":\\"#ffffff\\",\\"padding_link_top\\":\\"20\\",\\"padding_link_right\\":\\"40\\",\\"padding_link_bottom\\":\\"20\\",\\"padding_link_left\\":\\"40\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"font_weight\\":\\"bold\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"40\\",\\"border-type\\":\\"top\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\"},\\"buttons_size\\":\\"large\\",\\"buttons_shape\\":\\"squared\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Explore Our Coffees\\",\\"link\\":\\"https://themify.me/demo/themes/ultra-coffee\\\\/shop\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"}]}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"12\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 7,
  'post_date' => '2019-02-11 06:18:44',
  'post_date_gmt' => '2019-02-11 06:18:44',
  'post_content' => '<p>[woocommerce_my_account]</p>

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'My account',
  'post_excerpt' => '',
  'post_name' => 'my-account',
  'post_modified' => '2019-05-09 00:43:19',
  'post_modified_gmt' => '2019-05-09 00:43:19',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-coffee/my-account/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 4,
  'post_date' => '2019-02-11 06:18:44',
  'post_date_gmt' => '2019-02-11 06:18:44',
  'post_content' => '',
  'post_title' => 'Shop',
  'post_excerpt' => '',
  'post_name' => 'shop',
  'post_modified' => '2019-02-11 06:18:44',
  'post_modified_gmt' => '2019-02-11 06:18:44',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-coffee/shop/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 421,
  'post_date' => '2019-02-16 01:40:54',
  'post_date_gmt' => '2019-02-16 01:40:54',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam.',
  'post_title' => 'Duo Coffee Steeper',
  'post_excerpt' => 'Aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem',
  'post_name' => 'duo-coffee-steeper',
  'post_modified' => '2019-02-16 01:59:21',
  'post_modified_gmt' => '2019-02-16 01:59:21',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-coffee/?post_type=product&#038;p=421',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1550282332:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"5f9cb79\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"cbc7ae4\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '422',
    'post_image' => 'https://themify.me/demo/themes/ultra-coffee/files/2019/02/duo-coffee-mixer.jpg',
    '_regular_price' => '99',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.4',
    '_price' => '99',
    '_wcsquare_disable_sync' => 'no',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'equipment',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-coffee/files/2019/02/duo-coffee-mixer.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 413,
  'post_date' => '2019-02-15 15:34:43',
  'post_date_gmt' => '2019-02-15 15:34:43',
  'post_content' => 'Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.',
  'post_title' => 'Dukune Rwanda Coffee',
  'post_excerpt' => 'Neque porro quisquam. Voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt.',
  'post_name' => 'dukune-rwanda-coffee',
  'post_modified' => '2019-02-16 01:59:41',
  'post_modified_gmt' => '2019-02-16 01:59:41',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-coffee/?post_type=product&#038;p=413',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1550282333:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"dec0405\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"9c74855\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '414',
    'post_image' => 'https://themify.me/demo/themes/ultra-coffee/files/2019/02/original-rwanda-coffee.jpg',
    '_regular_price' => '10',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.4',
    '_price' => '10',
    '_wcsquare_disable_sync' => 'no',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'coffee',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-coffee/files/2019/02/original-rwanda-coffee.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 415,
  'post_date' => '2019-02-14 15:34:48',
  'post_date_gmt' => '2019-02-14 15:34:48',
  'post_content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum',
  'post_title' => 'Premium Le Mans Coffee',
  'post_excerpt' => 'Eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco.',
  'post_name' => 'premium-le-mans-coffee',
  'post_modified' => '2019-09-07 12:34:16',
  'post_modified_gmt' => '2019-09-07 12:34:16',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-coffee/?post_type=product&#038;p=415',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1550282333:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"210d163\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"88be33f\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '416',
    'post_image' => 'https://themify.me/demo/themes/ultra-coffee/files/2019/02/lemans-drive-coffee.jpg',
    '_wp_old_date' => '2019-02-15',
    '_regular_price' => '25',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.6.5',
    '_price' => '25',
    '_wcsquare_disable_sync' => 'no',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'coffee',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-coffee/files/2019/02/lemans-drive-coffee.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 418,
  'post_date' => '2019-02-13 15:36:31',
  'post_date_gmt' => '2019-02-13 15:36:31',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.',
  'post_title' => 'Keto French Vanilla',
  'post_excerpt' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.
',
  'post_name' => 'keto-french-vanilla',
  'post_modified' => '2019-02-16 02:00:17',
  'post_modified_gmt' => '2019-02-16 02:00:17',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-coffee/?post_type=product&#038;p=418',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1550282479:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"58ed42f\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"e419d2d\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '419',
    'post_image' => 'https://themify.me/demo/themes/ultra-coffee/files/2019/02/ketp-french-vamila.jpg',
    '_wp_old_date' => '2019-02-15',
    '_regular_price' => '10',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.4',
    '_price' => '10',
    '_wcsquare_disable_sync' => 'no',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'coffee',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-coffee/files/2019/02/ketp-french-vamila.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 477,
  'post_date' => '2019-02-12 01:42:31',
  'post_date_gmt' => '2019-02-12 01:42:31',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam.',
  'post_title' => 'Nossa Familia Black Coffee',
  'post_excerpt' => 'Aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem.',
  'post_name' => 'nossa-familia-black-coffee',
  'post_modified' => '2019-02-16 02:00:31',
  'post_modified_gmt' => '2019-02-16 02:00:31',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-coffee/?post_type=product&#038;p=477',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1550282334:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"86fa9cc\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"1f886e9\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '475',
    'post_image' => 'https://themify.me/demo/themes/ultra-coffee/files/2019/02/nossa-familia-coffee.jpg',
    '_wp_old_date' => '2019-02-16',
    '_regular_price' => '15',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.4',
    '_price' => '15',
    '_wcsquare_disable_sync' => 'no',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'coffee',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-coffee/files/2019/02/nossa-familia-coffee.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 478,
  'post_date' => '2019-02-11 01:52:02',
  'post_date_gmt' => '2019-02-11 01:52:02',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.',
  'post_title' => 'Portland Roasted Coffee',
  'post_excerpt' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.',
  'post_name' => 'portland-roasted-coffee',
  'post_modified' => '2019-02-16 02:00:49',
  'post_modified_gmt' => '2019-02-16 02:00:49',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-coffee/?post_type=product&#038;p=478',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1550282480:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"048187d\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"f4e559d\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '476',
    'post_image' => 'https://themify.me/demo/themes/ultra-coffee/files/2019/02/portland-roasting-coffee.jpg',
    '_regular_price' => '12',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.4',
    '_price' => '12',
    '_wcsquare_disable_sync' => 'no',
    '_wp_old_date' => '2019-02-16',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'coffee',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-coffee/files/2019/02/portland-roasting-coffee.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 479,
  'post_date' => '2019-02-10 01:53:25',
  'post_date_gmt' => '2019-02-10 01:53:25',
  'post_content' => 'Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.',
  'post_title' => 'KeepCup Coffee Glass 8oz',
  'post_excerpt' => 'Nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam.',
  'post_name' => 'keepcup-coffee-glass-8oz',
  'post_modified' => '2019-02-16 02:01:09',
  'post_modified_gmt' => '2019-02-16 02:01:09',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-coffee/?post_type=product&#038;p=479',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1550282335:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"b0946ad\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"b75d242\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '474',
    'post_image' => 'https://themify.me/demo/themes/ultra-coffee/files/2019/02/keepcup-small-glass-cup.jpg',
    '_wp_old_date' => '2019-02-16',
    '_regular_price' => '6',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.4',
    '_price' => '6',
    '_wcsquare_disable_sync' => 'no',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'equipment',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-coffee/files/2019/02/keepcup-small-glass-cup.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 480,
  'post_date' => '2019-02-09 01:55:58',
  'post_date_gmt' => '2019-02-09 01:55:58',
  'post_content' => 'Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.
',
  'post_title' => 'De Longhi Coffee Maker',
  'post_excerpt' => 'Nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam.
',
  'post_name' => 'de-longhi-coffee-maker',
  'post_modified' => '2019-02-16 02:01:13',
  'post_modified_gmt' => '2019-02-16 02:01:13',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-coffee/?post_type=product&#038;p=480',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1550282336:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"cc543c6\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"0054399\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '473',
    'post_image' => 'https://themify.me/demo/themes/ultra-coffee/files/2019/02/delonghi-coffee-maker.jpg',
    '_wp_old_date' => '2019-02-16',
    '_regular_price' => '250',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.4',
    '_price' => '250',
    '_wcsquare_disable_sync' => 'no',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'equipment',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-coffee/files/2019/02/delonghi-coffee-maker.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 485,
  'post_date' => '2019-02-07 02:02:17',
  'post_date_gmt' => '2019-02-07 02:02:17',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.',
  'post_title' => 'Casa Brazil Coffee',
  'post_excerpt' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.',
  'post_name' => 'casa-brazil-coffee',
  'post_modified' => '2019-02-16 02:04:39',
  'post_modified_gmt' => '2019-02-16 02:04:39',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-coffee/?post_type=product&#038;p=485',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1550282550:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"1491123\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"c4594b8\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '472',
    'post_image' => 'https://themify.me/demo/themes/ultra-coffee/files/2019/02/casa-brazil-coffee.jpg',
    '_wp_old_date' => '2019-02-16',
    '_regular_price' => '12',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.4',
    '_price' => '12',
    '_wcsquare_disable_sync' => 'no',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'coffee',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-coffee/files/2019/02/casa-brazil-coffee.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 486,
  'post_date' => '2019-02-05 02:04:54',
  'post_date_gmt' => '2019-02-05 02:04:54',
  'post_content' => 'Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.',
  'post_title' => 'Lion Black Coffee',
  'post_excerpt' => 'Neque porro quisquam. Voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt.',
  'post_name' => 'lion-black-coffee',
  'post_modified' => '2019-02-16 02:05:57',
  'post_modified_gmt' => '2019-02-16 02:05:57',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-coffee/?post_type=product&#038;p=486',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1550282647:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"2dbfa45\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"cbec3ff\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '471',
    'post_image' => 'https://themify.me/demo/themes/ultra-coffee/files/2019/02/black-lion-coffee.jpg',
    '_wp_old_date' => '2019-02-16',
    '_regular_price' => '13',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.4',
    '_price' => '13',
    '_wcsquare_disable_sync' => 'no',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'coffee',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-coffee/files/2019/02/black-lion-coffee.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 17,
  'post_date' => '2019-02-11 06:25:31',
  'post_date_gmt' => '2019-02-11 06:25:31',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '17',
  'post_modified' => '2019-02-19 07:29:34',
  'post_modified_gmt' => '2019-02-19 07:29:34',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-coffee/?p=17',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '10',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 220,
  'post_date' => '2019-02-13 02:48:03',
  'post_date_gmt' => '2019-02-13 02:48:03',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '220',
  'post_modified' => '2019-02-19 07:29:34',
  'post_modified_gmt' => '2019-02-19 07:29:34',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-coffee/?p=220',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '144',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 268,
  'post_date' => '2019-02-13 10:03:21',
  'post_date_gmt' => '2019-02-13 10:03:21',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '268',
  'post_modified' => '2019-02-19 07:29:34',
  'post_modified_gmt' => '2019-02-19 07:29:34',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-coffee/?p=268',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '4',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 267,
  'post_date' => '2019-02-13 10:03:21',
  'post_date_gmt' => '2019-02-13 10:03:21',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '267',
  'post_modified' => '2019-02-19 07:29:34',
  'post_modified_gmt' => '2019-02-19 07:29:34',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-coffee/?p=267',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '232',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );



function themify_import_get_term_id_from_slug( $slug ) {
	$menu = get_term_by( "slug", $slug, "nav_menu" );
	return is_wp_error( $menu ) ? 0 : (int) $menu->term_id;
}

	$widgets = get_option( "widget_text" );
$widgets[1002] = array (
  'title' => 'Coffee',
  'text' => 'We’re excited to share the story that every bean can tell. Come on in, take a sip, and explore with us!',
  'filter' => true,
  'visual' => true,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1003] = array (
  'title' => 'Hours',
  'text' => 'MON – FRI: 9AM – 11PM
SAT – SUN: 5PM – 2AM
Bar open only on weekends.',
  'filter' => true,
  'visual' => true,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1004] = array (
  'title' => 'Contact',
  'text' => '55 Adelaide St E, 
Toronto, ON, M5C 1K6
Canada
<a href="mailto:info@themify.me">info@coffee-skin.com</a>',
  'filter' => true,
  'visual' => true,
);
update_option( "widget_text", $widgets );



$sidebars_widgets = array (
  'footer-widget-1' => 
  array (
    0 => 'text-1002',
  ),
  'footer-widget-2' => 
  array (
    0 => 'text-1003',
  ),
  'footer-widget-3' => 
  array (
    0 => 'text-1004',
  ),
); 
update_option( "sidebars_widgets", $sidebars_widgets );

$menu_locations = array();
$menu = get_terms( "nav_menu", array( "slug" => "main-navigation" ) );
if( is_array( $menu ) && ! empty( $menu ) ) $menu_locations["main-nav"] = $menu[0]->term_id;
set_theme_mod( "nav_menu_locations", $menu_locations );


$homepage = get_posts( array( 'name' => 'home', 'post_type' => 'page' ) );
			if( is_array( $homepage ) && ! empty( $homepage ) ) {
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $homepage[0]->ID );
			}
			
	ob_start(); ?>a:109:{s:21:"setting-webfonts_list";s:11:"recommended";s:22:"setting-default_layout";s:8:"sidebar1";s:27:"setting-default_post_layout";s:9:"list-post";s:19:"setting-post_filter";s:2:"no";s:23:"setting-disable_masonry";s:3:"yes";s:19:"setting-post_gutter";s:6:"gutter";s:30:"setting-default_layout_display";s:7:"content";s:25:"setting-default_more_text";s:4:"More";s:21:"setting-index_orderby";s:4:"date";s:19:"setting-index_order";s:4:"DESC";s:30:"setting-default_media_position";s:5:"below";s:31:"setting-image_post_feature_size";s:5:"blank";s:32:"setting-default_page_post_layout";s:8:"sidebar1";s:37:"setting-default_page_post_layout_type";s:7:"classic";s:42:"setting-default_page_single_media_position";s:5:"above";s:38:"setting-image_post_single_feature_size";s:5:"blank";s:36:"setting-search-result_layout_display";s:7:"content";s:36:"setting-search-result_media_position";s:5:"above";s:27:"setting-default_page_layout";s:8:"sidebar1";s:40:"setting-custom_post_tglobal_style_single";s:8:"sidebar1";s:38:"setting-default_portfolio_index_layout";s:12:"sidebar-none";s:43:"setting-default_portfolio_index_post_layout";s:5:"grid3";s:29:"setting-portfolio_post_filter";s:3:"yes";s:33:"setting-portfolio_disable_masonry";s:3:"yes";s:24:"setting-portfolio_gutter";s:6:"gutter";s:39:"setting-default_portfolio_index_display";s:4:"none";s:50:"setting-default_portfolio_index_post_meta_category";s:3:"yes";s:49:"setting-default_portfolio_index_unlink_post_image";s:3:"yes";s:39:"setting-default_portfolio_single_layout";s:12:"sidebar-none";s:54:"setting-default_portfolio_single_portfolio_layout_type";s:9:"fullwidth";s:50:"setting-default_portfolio_single_unlink_post_image";s:3:"yes";s:22:"themify_portfolio_slug";s:7:"project";s:19:"setting-shop_layout";s:12:"sidebar-none";s:27:"setting-shop_archive_layout";s:12:"sidebar-none";s:23:"setting-products_layout";s:5:"grid4";s:31:"setting-product_disable_masonry";s:3:"yes";s:29:"setting-single_product_layout";s:12:"sidebar-none";s:30:"setting-related_products_limit";s:1:"3";s:53:"setting-customizer_responsive_design_tablet_landscape";s:4:"1280";s:43:"setting-customizer_responsive_design_tablet";s:3:"768";s:43:"setting-customizer_responsive_design_mobile";s:3:"680";s:33:"setting-mobile_menu_trigger_point";s:3:"900";s:24:"setting-gallery_lightbox";s:8:"lightbox";s:27:"setting-page_builder_expiry";s:1:"2";s:21:"setting-header_design";s:17:"header-horizontal";s:28:"setting-exclude_site_tagline";s:2:"on";s:19:"setting_search_form";s:11:"live_search";s:19:"setting-exclude_rss";s:2:"on";s:22:"setting-header_widgets";s:17:"headerwidget-3col";s:21:"setting-footer_design";s:22:"footer-horizontal-left";s:27:"setting-exclude_footer_back";s:2:"on";s:22:"setting-footer_widgets";s:17:"footerwidget-4col";s:30:"setting-footer_widget_position";s:3:"top";s:23:"setting-mega_menu_posts";s:1:"5";s:29:"setting-mega_menu_image_width";s:3:"180";s:30:"setting-mega_menu_image_height";s:3:"120";s:27:"setting-imagefilter_applyto";s:12:"featuredonly";s:29:"setting-color_animation_speed";s:1:"5";s:29:"setting-relationship_taxonomy";s:8:"category";s:37:"setting-relationship_taxonomy_entries";s:1:"3";s:45:"setting-relationship_taxonomy_display_content";s:4:"none";s:30:"setting-single_slider_autoplay";s:3:"off";s:27:"setting-single_slider_speed";s:6:"normal";s:28:"setting-single_slider_effect";s:5:"slide";s:28:"setting-single_slider_height";s:4:"auto";s:18:"setting-more_posts";s:10:"pagination";s:19:"setting-entries_nav";s:8:"numbered";s:25:"setting-img_php_base_size";s:5:"large";s:27:"setting-global_feature_size";s:5:"blank";s:22:"setting-link_icon_type";s:9:"font-icon";s:32:"setting-link_type_themify-link-0";s:10:"image-icon";s:33:"setting-link_title_themify-link-0";s:7:"Twitter";s:31:"setting-link_img_themify-link-0";s:106:"https://themify.me/demo/themes/ultra-coffee/wp-content/themes/themify-ultra/themify/img/social/twitter.png";s:32:"setting-link_type_themify-link-1";s:10:"image-icon";s:33:"setting-link_title_themify-link-1";s:8:"Facebook";s:31:"setting-link_img_themify-link-1";s:107:"https://themify.me/demo/themes/ultra-coffee/wp-content/themes/themify-ultra/themify/img/social/facebook.png";s:32:"setting-link_type_themify-link-2";s:10:"image-icon";s:33:"setting-link_title_themify-link-2";s:7:"Google+";s:31:"setting-link_img_themify-link-2";s:110:"https://themify.me/demo/themes/ultra-coffee/wp-content/themes/themify-ultra/themify/img/social/google-plus.png";s:32:"setting-link_type_themify-link-3";s:10:"image-icon";s:33:"setting-link_title_themify-link-3";s:7:"YouTube";s:31:"setting-link_img_themify-link-3";s:106:"https://themify.me/demo/themes/ultra-coffee/wp-content/themes/themify-ultra/themify/img/social/youtube.png";s:32:"setting-link_type_themify-link-4";s:10:"image-icon";s:33:"setting-link_title_themify-link-4";s:9:"Pinterest";s:31:"setting-link_img_themify-link-4";s:108:"https://themify.me/demo/themes/ultra-coffee/wp-content/themes/themify-ultra/themify/img/social/pinterest.png";s:32:"setting-link_type_themify-link-5";s:9:"font-icon";s:33:"setting-link_title_themify-link-5";s:7:"Twitter";s:33:"setting-link_ficon_themify-link-5";s:10:"fa-twitter";s:32:"setting-link_type_themify-link-6";s:9:"font-icon";s:33:"setting-link_title_themify-link-6";s:8:"Facebook";s:33:"setting-link_ficon_themify-link-6";s:11:"fa-facebook";s:32:"setting-link_type_themify-link-7";s:9:"font-icon";s:33:"setting-link_title_themify-link-7";s:7:"Google+";s:33:"setting-link_ficon_themify-link-7";s:14:"fa-google-plus";s:32:"setting-link_type_themify-link-8";s:9:"font-icon";s:33:"setting-link_title_themify-link-8";s:7:"YouTube";s:33:"setting-link_ficon_themify-link-8";s:10:"fa-youtube";s:32:"setting-link_type_themify-link-9";s:9:"font-icon";s:33:"setting-link_title_themify-link-9";s:9:"Pinterest";s:33:"setting-link_ficon_themify-link-9";s:12:"fa-pinterest";s:22:"setting-link_field_ids";s:341:"{"themify-link-0":"themify-link-0","themify-link-1":"themify-link-1","themify-link-2":"themify-link-2","themify-link-3":"themify-link-3","themify-link-4":"themify-link-4","themify-link-5":"themify-link-5","themify-link-6":"themify-link-6","themify-link-7":"themify-link-7","themify-link-8":"themify-link-8","themify-link-9":"themify-link-9"}";s:23:"setting-link_field_hash";s:2:"10";s:30:"setting-page_builder_is_active";s:6:"enable";s:41:"setting-page_builder_animation_appearance";s:4:"none";s:42:"setting-page_builder_animation_parallax_bg";s:4:"none";s:46:"setting-page_builder_animation_parallax_scroll";s:6:"mobile";s:44:"setting-page_builder_animation_sticky_scroll";s:4:"none";s:4:"skin";s:6:"coffee";s:13:"import_images";s:2:"on";}<?php $themify_data = unserialize( ob_get_clean() );

	// Fix how "skin" option used to save
	if( isset( $themify_data['skin'] ) ) {
		if ( filter_var( $themify_data['skin'], FILTER_VALIDATE_URL ) ) {
			$parsed_skin = parse_url( $value, PHP_URL_PATH );
			$themify_data['skin'] = basename( dirname( $parsed_skin ) );
		}
	}

	themify_set_data( $themify_data );
	
}
themify_do_demo_import();