<?php

defined( 'ABSPATH' ) or die;

$GLOBALS['processed_terms'] = array();
$GLOBALS['processed_posts'] = array();

require_once ABSPATH . 'wp-admin/includes/post.php';
require_once ABSPATH . 'wp-admin/includes/taxonomy.php';
require_once ABSPATH . 'wp-admin/includes/image.php';

/**
 * Add an Import Action, this data is stored for processing after import is done.
 *
 * Each action is sent as an Ajax request and is handled by themify-ajax.php file
 */ 
function themify_add_import_action( $action = '', $data = array() ) {
	global $import_actions;

	if ( ! isset( $import_actions[ $action ] ) ) {
		$import_actions[ $action ] = array();
	}

	$import_actions[ $action ][] = $data;
}

function themify_import_post( $post ) {
	global $processed_posts, $processed_terms;

	if ( ! post_type_exists( $post['post_type'] ) ) {
		return;
	}

	/* Menu items don't have reliable post_title, skip the post_exists check */
	if( $post['post_type'] !== 'nav_menu_item' ) {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
		if ( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
			$processed_posts[ intval( $post['ID'] ) ] = intval( $post_exists );
			return;
		}
	}

	if( $post['post_type'] == 'nav_menu_item' ) {
		if( ! isset( $post['tax_input']['nav_menu'] ) || ! term_exists( $post['tax_input']['nav_menu'], 'nav_menu' ) ) {
			return;
		}
		$_menu_item_type = $post['meta_input']['_menu_item_type'];
		$_menu_item_object_id = $post['meta_input']['_menu_item_object_id'];

		if ( 'taxonomy' == $_menu_item_type && isset( $processed_terms[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_terms[ intval( $_menu_item_object_id ) ];
		} else if ( 'post_type' == $_menu_item_type && isset( $processed_posts[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_posts[ intval( $_menu_item_object_id ) ];
		} else if ( 'custom' != $_menu_item_type ) {
			// associated object is missing or not imported yet, we'll retry later
			// $missing_menu_items[] = $item;
			return;
		}
	}

	$post_parent = ( $post['post_type'] == 'nav_menu_item' ) ? $post['meta_input']['_menu_item_menu_item_parent'] : (int) $post['post_parent'];
	$post['post_parent'] = 0;
	if ( $post_parent ) {
		// if we already know the parent, map it to the new local ID
		if ( isset( $processed_posts[ $post_parent ] ) ) {
			if( $post['post_type'] == 'nav_menu_item' ) {
				$post['meta_input']['_menu_item_menu_item_parent'] = $processed_posts[ $post_parent ];
			} else {
				$post['post_parent'] = $processed_posts[ $post_parent ];
			}
		}
	}

	/**
	 * for hierarchical taxonomies, IDs must be used so wp_set_post_terms can function properly
	 * convert term slugs to IDs for hierarchical taxonomies
	 */
	if( ! empty( $post['tax_input'] ) ) {
		foreach( $post['tax_input'] as $tax => $terms ) {
			if( is_taxonomy_hierarchical( $tax ) ) {
				$terms = explode( ', ', $terms );
				$post['tax_input'][ $tax ] = array_map( 'themify_get_term_id_by_slug', $terms, array_fill( 0, count( $terms ), $tax ) );
			}
		}
	}

	$post['post_author'] = (int) get_current_user_id();
	$post['post_status'] = 'publish';

	$old_id = $post['ID'];

	unset( $post['ID'] );
	$post_id = wp_insert_post( $post, true );
	if( is_wp_error( $post_id ) ) {
		return false;
	} else {
		$processed_posts[ $old_id ] = $post_id;

		return $post_id;
	}
}

function themify_get_placeholder_image() {
	static $placeholder_image = null;

	if( $placeholder_image == null ) {
		if ( ! function_exists( 'WP_Filesystem' ) ) {
			require_once ABSPATH . 'wp-admin/includes/file.php';
		}
		WP_Filesystem();
		global $wp_filesystem;
		$upload = wp_upload_bits( $post['post_name'] . '.jpg', null, $wp_filesystem->get_contents( THEMIFY_DIR . '/img/image-placeholder.jpg' ) );

		if ( $info = wp_check_filetype( $upload['file'] ) )
			$post['post_mime_type'] = $info['type'];
		else
			return new WP_Error( 'attachment_processing_error', __( 'Invalid file type', 'themify' ) );

		$post['guid'] = $upload['url'];
		$post_id = wp_insert_attachment( $post, $upload['file'] );
		wp_update_attachment_metadata( $post_id, wp_generate_attachment_metadata( $post_id, $upload['file'] ) );

		$placeholder_image = $post_id;
	}

	return $placeholder_image;
}

function themify_import_term( $term ) {
	global $processed_terms;

	if( $term_id = term_exists( $term['slug'], $term['taxonomy'] ) ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];
		if ( isset( $term['term_id'] ) )
			$processed_terms[ intval( $term['term_id'] ) ] = (int) $term_id;
		return (int) $term_id;
	}

	if ( empty( $term['parent'] ) ) {
		$parent = 0;
	} else {
		$parent = term_exists( $processed_terms[ intval( $term['parent'] ) ], $term['taxonomy'] );
		if ( is_array( $parent ) ) $parent = $parent['term_id'];
	}

	$id = wp_insert_term( $term['name'], $term['taxonomy'], array(
		'parent' => $parent,
		'slug' => $term['slug'],
		'description' => $term['description'],
	) );
	if ( ! is_wp_error( $id ) ) {
		if ( isset( $term['term_id'] ) ) {
			// success!
			$processed_terms[ intval($term['term_id']) ] = $id['term_id'];
			if ( isset( $term['thumbnail'] ) ) {
				themify_add_import_action( 'term_thumb', array(
					'id' => $id['term_id'],
					'thumb' => $term['thumbnail'],
				) );
			}
			return $term['term_id'];
		}
	}

	return false;
}

function themify_get_term_id_by_slug( $slug, $tax ) {
	$term = get_term_by( 'slug', $slug, $tax );
	if( $term ) {
		return $term->term_id;
	}

	return false;
}

function themify_undo_import_term( $term ) {
	$term_id = term_exists( $term['slug'], $term['taxonomy'] );
	if ( $term_id ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];

		if ( $term_thumbnail = get_term_meta( $term['term_id'], 'thumbnail_id', true ) ) {
			wp_delete_attachment( $term_thumbnail, true );
		}

		if ( isset( $term_id ) ) {
			wp_delete_term( $term_id, $term['taxonomy'] );
		}
	}
}

/**
 * Determine if a post exists based on title, content, and date
 *
 * @global wpdb $wpdb WordPress database abstraction object.
 *
 * @param array $args array of database parameters to check
 * @return int Post ID if post exists, 0 otherwise.
 */
function themify_post_exists( $args = array() ) {
	global $wpdb;

	$query = "SELECT ID FROM $wpdb->posts WHERE 1=1";
	$db_args = array();

	foreach ( $args as $key => $value ) {
		$value = wp_unslash( sanitize_post_field( $key, $value, 0, 'db' ) );
		if( ! empty( $value ) ) {
			$query .= ' AND ' . $key . ' = %s';
			$db_args[] = $value;
		}
	}

	if ( !empty ( $args ) )
		return (int) $wpdb->get_var( $wpdb->prepare($query, $args) );

	return 0;
}

function themify_undo_import_post( $post ) {
	if( $post['post_type'] == 'nav_menu_item' ) {
		$post_exists = themify_post_exists( array(
			'post_name' => $post['post_name'],
			'post_modified' => $post['post_date'],
			'post_type' => 'nav_menu_item',
		) );
	} else {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
	}
	if( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
		/**
		 * check if the post has been modified, if so leave it be
		 *
		 * NOTE: posts are imported using wp_insert_post() which modifies post_modified field
		 * to be the same as post_date, hence to check if the post has been modified,
		 * the post_modified field is compared against post_date in the original post.
		 */
		if( $post['post_date'] == get_post_field( 'post_modified', $post_exists ) ) {
			// find and remove all post attachments
			$attachments = get_posts( array(
				'post_type' => 'attachment',
				'posts_per_page' => -1,
				'post_parent' => $post_exists,
			) );
			if ( $attachments ) {
				foreach ( $attachments as $attachment ) {
					wp_delete_attachment( $attachment->ID, true );
				}
			}
			wp_delete_post( $post_exists, true ); // true: bypass trash
		}
	}
}

function themify_process_post_import( $post ) {
	if( ERASEDEMO ) {
		themify_undo_import_post( $post );
	} else {
		if ( $id = themify_import_post( $post ) ) {
			if ( defined( 'IMPORT_IMAGES' ) && ! IMPORT_IMAGES ) {
				/* if importing images is disabled and post is supposed to have a thumbnail, create a placeholder image instead */
				if ( isset( $post['thumb'] ) ) { // the post is supposed to have featured image
					$placeholder = themify_get_placeholder_image();
					if( ! is_wp_error( $placeholder ) ) {
						set_post_thumbnail( $id, $placeholder );
					}
				}
			} else {
				if ( isset( $post["thumb"] ) ) {
					themify_add_import_action( 'post_thumb', array(
						'id' => $id,
						'thumb' => $post["thumb"],
					) );
				}
				if ( isset( $post["gallery_shortcode"] ) ) {
					themify_add_import_action( 'gallery_field', array(
						'id' => $id,
						'fields' => $post["gallery_shortcode"],
					) );
				}
				if ( isset( $post["_product_image_gallery"] ) ) {
					themify_add_import_action( 'product_gallery', array(
						'id' => $id,
						'images' => $post["_product_image_gallery"],
					) );
				}
			}
		}
	}
}
$thumbs = array();
function themify_do_demo_import() {
global $import_actions;

	if ( isset( $GLOBALS["ThemifyBuilder_Data_Manager"] ) ) {
		remove_action( "save_post", array( $GLOBALS["ThemifyBuilder_Data_Manager"], "save_builder_text_only"), 10, 3 );
	}
$term = array (
  'term_id' => 7,
  'name' => 'Jacket',
  'slug' => 'jacket',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
  'thumbnail' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/jacket-category-image.jpg',
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 8,
  'name' => 'Tanks',
  'slug' => 'tanks',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
  'thumbnail' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/tank-category-image.jpg',
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 9,
  'name' => 'Gear',
  'slug' => 'gear',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
  'thumbnail' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/gear-category-image.jpg',
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 10,
  'name' => 'Pants',
  'slug' => 'pants',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
  'thumbnail' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/running-with-jogging-pants.jpg',
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 2,
  'name' => 'Main Navigation',
  'slug' => 'main-navigation',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$post = array (
  'ID' => 70,
  'post_date' => '2016-09-20 04:41:57',
  'post_date_gmt' => '2016-09-20 04:41:57',
  'post_content' => '<!--themify_builder_static--><h1>Amenities & Equipments<br/>Luxury amentities. New, high tech, and safe equipments.</h1>
<a href="https://themify.me/" ></a> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/shower-1-290x250.jpg" width="290" height="250" title="showers" alt="showers" /> 
 
 <h4>showers</h4>
<a href="https://themify.me/" ></a> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/pool-1318072-290x250.jpg" width="290" height="250" title="Pools" alt="Pools" /> 
 
 <h4>Pools</h4>
<a href="https://themify.me/" ></a> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1313880-1-290x250.jpg" width="290" height="250" title="Stream room" alt="Stream room" /> 
 
 <h4>Stream room</h4>
<a href="https://themify.me/" ></a> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/saunas-290x250.jpg" width="290" height="250" title="Saunas" alt="Saunas" /> 
 
 <h4>Saunas</h4>
<a href="https://themify.me/" ></a> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/towels-1197773_1920-1400x932-1-290x250.jpg" width="290" height="250" title="Towels" alt="Towels" /> 
 
 <h4>Towels</h4>
<a href="https://themify.me/" ></a> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1323122-2-290x250.jpg" width="290" height="250" title="Jacuzzis" alt="Jacuzzis" /> 
 
 <h4>Jacuzzis</h4>
<a href="https://themify.me/" ></a> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/lounge-area-290x250.jpg" width="290" height="250" title="Lounge Area" alt="Lounge Area" /> 
 
 <h4>Lounge Area</h4>
<a href="https://themify.me/" ></a> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID460027-290x250.jpg" width="290" height="250" title="Boxing Arena" alt="Boxing Arena" /> 
 
 <h4>Boxing Arena</h4>
<a href="https://themify.me/" ></a> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1349925-1-290x250.jpg" width="290" height="250" title="Lockers" alt="Lockers" /> 
 
 <h4>Lockers</h4>
<a href="https://themify.me/" ></a> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/running-1245640-290x250.jpg" width="290" height="250" title="Running Tracks" alt="Running Tracks" /> 
 
 <h4>Running Tracks</h4>
<a href="https://themify.me/" ></a> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/fitness-1327255-290x250.jpg" width="290" height="250" title="Yoga Studios" alt="Yoga Studios" /> 
 
 <h4>Yoga Studios</h4>
<a href="https://themify.me/" ></a> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1323959-2-290x250.jpg" width="290" height="250" title="130 Machines " alt="130 Machines " /> 
 
 <h4>130+ Machines & Equipments</h4>
<h2>Machines & Equipments<br/>More than 130+ equipments</h2>
<img src="https://themify.me/demo/themes/ultra-fitness/files/2016/09/dumbles-260x193.jpg" width="260" height="193" title="Dumbells From 5lbs-75lbs" alt="Dumbells From 5lbs-75lbs" /> <h3> Dumbells From 5lbs-75lbs </h3>
<img src="https://themify.me/demo/themes/ultra-fitness/files/2016/09/treadmills-260x193.jpg" width="260" height="193" title="Treadmills" alt="Treadmills" /> <h3> Treadmills </h3>
<img src="https://themify.me/demo/themes/ultra-fitness/files/2016/09/treadmills-260x193.jpg" width="260" height="193" title="Squat Station" alt="Squat Station" /> <h3> Squat Station </h3>
<img src="https://themify.me/demo/themes/ultra-fitness/files/2016/09/babrbels-260x193.jpg" width="260" height="193" title="Barbels" alt="Barbels" /> <h3> Barbels </h3>
<img src="https://themify.me/demo/themes/ultra-fitness/files/2016/09/strength-raining-260x193.jpg" width="260" height="193" title="Strength Training" alt="Strength Training" /> <h3> Strength Training </h3>
<img src="https://themify.me/demo/themes/ultra-fitness/files/2016/09/upright-bike-260x193.jpg" width="260" height="193" title="Upright Bike" alt="Upright Bike" /> <h3> Upright Bike </h3>
<img src="https://themify.me/demo/themes/ultra-fitness/files/2016/09/hammer-machine-260x193.jpg" width="260" height="193" title="Hammer Machine" alt="Hammer Machine" /> <h3> Hammer Machine </h3>
<img src="https://themify.me/demo/themes/ultra-fitness/files/2016/09/stopwatch-260x193.jpg" width="260" height="193" title="Stopwatch" alt="Stopwatch" /> <h3> Stopwatch </h3>
<h3>Note</h3><ul><li style="text-align: left;">Amenities &amp; equipments may vary in different locations.</li><li style="text-align: left;">Extra pos may apply to some service, maintenance agreements.</li><li style="text-align: left;">Contact us to confirm.</li></ul><!--/themify_builder_static-->',
  'post_title' => 'Amenities',
  'post_excerpt' => '',
  'post_name' => 'amenities',
  'post_modified' => '2019-07-19 17:23:42',
  'post_modified_gmt' => '2019-07-19 17:23:42',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/?page_id=70',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'header_wrap' => 'transparent',
    'footer_widget_position' => 'top',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"q8dn681\\",\\"cols\\":[{\\"element_id\\":\\"4q3a686\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"q23h688\\",\\"mod_settings\\":{\\"sub_heading\\":\\"Luxury amentities. New, high tech, and safe equipments.\\",\\"heading\\":\\"Amenities & Equipments\\",\\"heading_tag\\":\\"h1\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"text_alignment\\":\\"themify-text-center\\"}}]}],\\"styling\\":{\\"custom_css_row\\":\\"amenities-section\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1330148.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"000000_0.60\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"13\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"13\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"35\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"4g8p682\\",\\"cols\\":[{\\"element_id\\":\\"ktke692\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pro-image\\",\\"element_id\\":\\"k2h7693\\",\\"mod_settings\\":{\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/shower-1-290x250.jpg\\",\\"link_image_type\\":\\"image_external\\",\\"link_image_new_window\\":\\"no\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"width_image\\":\\"290\\",\\"height_image\\":\\"250\\",\\"image_filter\\":\\"grayscale\\",\\"image_effect\\":\\"none\\",\\"image_alignment\\":\\"image_alignment_left\\",\\"title_image\\":\\"showers\\",\\"color_button\\":\\"black\\",\\"link_type\\":\\"external\\",\\"link_new_window\\":\\"no\\",\\"overlay_color\\":\\"000000_0.51\\",\\"overlay_effect\\":\\"fadeIn\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"rgoh693\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pro-image\\",\\"element_id\\":\\"obws694\\",\\"mod_settings\\":{\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/pool-1318072-290x250.jpg\\",\\"link_image_type\\":\\"image_external\\",\\"link_image_new_window\\":\\"no\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"width_image\\":\\"290\\",\\"height_image\\":\\"250\\",\\"image_filter\\":\\"grayscale\\",\\"image_effect\\":\\"none\\",\\"image_alignment\\":\\"image_alignment_left\\",\\"title_image\\":\\"Pools\\",\\"color_button\\":\\"black\\",\\"link_type\\":\\"external\\",\\"link_new_window\\":\\"no\\",\\"overlay_color\\":\\"000000_0.54\\",\\"overlay_effect\\":\\"fadeIn\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"wn1u695\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pro-image\\",\\"element_id\\":\\"phiq695\\",\\"mod_settings\\":{\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1313880-1-290x250.jpg\\",\\"link_image_type\\":\\"image_external\\",\\"link_image_new_window\\":\\"no\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"width_image\\":\\"290\\",\\"height_image\\":\\"250\\",\\"image_filter\\":\\"grayscale\\",\\"image_effect\\":\\"none\\",\\"image_alignment\\":\\"image_alignment_left\\",\\"title_image\\":\\"Stream room\\",\\"color_button\\":\\"black\\",\\"link_type\\":\\"external\\",\\"link_new_window\\":\\"no\\",\\"overlay_color\\":\\"000000_0.53\\",\\"overlay_effect\\":\\"fadeIn\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"9uvp696\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pro-image\\",\\"element_id\\":\\"qfxd696\\",\\"mod_settings\\":{\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/saunas-290x250.jpg\\",\\"link_image_type\\":\\"image_external\\",\\"link_image_new_window\\":\\"no\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"width_image\\":\\"290\\",\\"height_image\\":\\"250\\",\\"image_filter\\":\\"grayscale\\",\\"image_effect\\":\\"none\\",\\"image_alignment\\":\\"image_alignment_left\\",\\"title_image\\":\\"Saunas\\",\\"color_button\\":\\"black\\",\\"link_type\\":\\"external\\",\\"link_new_window\\":\\"no\\",\\"overlay_color\\":\\"000000_0.51\\",\\"overlay_effect\\":\\"fadeIn\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_border_apply_all\\":\\"border\\"}}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"-250\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet_landscape\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"-212\\",\\"checkbox_border_apply_all\\":\\"1\\"},\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_tablet\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"-159\\",\\"checkbox_border_apply_all\\":\\"1\\"}}},{\\"element_id\\":\\"fal0682\\",\\"cols\\":[{\\"element_id\\":\\"yp20697\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pro-image\\",\\"element_id\\":\\"6mgr697\\",\\"mod_settings\\":{\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/towels-1197773_1920-1400x932-1-290x250.jpg\\",\\"link_image_type\\":\\"image_external\\",\\"link_image_new_window\\":\\"no\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"width_image\\":\\"290\\",\\"height_image\\":\\"250\\",\\"image_filter\\":\\"grayscale\\",\\"image_effect\\":\\"none\\",\\"image_alignment\\":\\"image_alignment_left\\",\\"title_image\\":\\"Towels\\",\\"color_button\\":\\"black\\",\\"link_type\\":\\"external\\",\\"link_new_window\\":\\"no\\",\\"overlay_color\\":\\"000000_0.51\\",\\"overlay_effect\\":\\"fadeIn\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"lkcq697\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pro-image\\",\\"element_id\\":\\"70uy698\\",\\"mod_settings\\":{\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1323122-2-290x250.jpg\\",\\"link_image_type\\":\\"image_external\\",\\"link_image_new_window\\":\\"no\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"width_image\\":\\"290\\",\\"height_image\\":\\"250\\",\\"image_filter\\":\\"grayscale\\",\\"image_effect\\":\\"none\\",\\"image_alignment\\":\\"image_alignment_left\\",\\"title_image\\":\\"Jacuzzis\\",\\"color_button\\":\\"black\\",\\"link_type\\":\\"external\\",\\"link_new_window\\":\\"no\\",\\"overlay_color\\":\\"000000_0.51\\",\\"overlay_effect\\":\\"fadeIn\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"jzmi698\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pro-image\\",\\"element_id\\":\\"8vio698\\",\\"mod_settings\\":{\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/lounge-area-290x250.jpg\\",\\"link_image_type\\":\\"image_external\\",\\"link_image_new_window\\":\\"no\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"width_image\\":\\"290\\",\\"height_image\\":\\"250\\",\\"image_filter\\":\\"grayscale\\",\\"image_effect\\":\\"none\\",\\"image_alignment\\":\\"image_alignment_left\\",\\"title_image\\":\\"Lounge Area\\",\\"color_button\\":\\"black\\",\\"link_type\\":\\"external\\",\\"link_new_window\\":\\"no\\",\\"overlay_color\\":\\"000000_0.51\\",\\"overlay_effect\\":\\"fadeIn\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"51al698\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pro-image\\",\\"element_id\\":\\"nsj0698\\",\\"mod_settings\\":{\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID460027-290x250.jpg\\",\\"link_image_type\\":\\"image_external\\",\\"link_image_new_window\\":\\"no\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"width_image\\":\\"290\\",\\"height_image\\":\\"250\\",\\"image_filter\\":\\"grayscale\\",\\"image_effect\\":\\"none\\",\\"image_alignment\\":\\"image_alignment_left\\",\\"title_image\\":\\"Boxing Arena\\",\\"color_button\\":\\"black\\",\\"link_type\\":\\"external\\",\\"link_new_window\\":\\"no\\",\\"overlay_color\\":\\"000000_0.51\\",\\"overlay_effect\\":\\"fadeIn\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_border_apply_all\\":\\"border\\"}}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"5vgk682\\",\\"cols\\":[{\\"element_id\\":\\"n6r0699\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pro-image\\",\\"element_id\\":\\"65cs699\\",\\"mod_settings\\":{\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1349925-1-290x250.jpg\\",\\"link_image_type\\":\\"image_external\\",\\"link_image_new_window\\":\\"no\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"width_image\\":\\"290\\",\\"height_image\\":\\"250\\",\\"image_filter\\":\\"grayscale\\",\\"image_effect\\":\\"none\\",\\"image_alignment\\":\\"image_alignment_left\\",\\"title_image\\":\\"Lockers\\",\\"color_button\\":\\"black\\",\\"link_type\\":\\"external\\",\\"link_new_window\\":\\"no\\",\\"overlay_color\\":\\"000000_0.51\\",\\"overlay_effect\\":\\"fadeIn\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"9n3o699\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pro-image\\",\\"element_id\\":\\"omqm699\\",\\"mod_settings\\":{\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/running-1245640-290x250.jpg\\",\\"link_image_type\\":\\"image_external\\",\\"link_image_new_window\\":\\"no\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"width_image\\":\\"290\\",\\"height_image\\":\\"250\\",\\"image_filter\\":\\"grayscale\\",\\"image_effect\\":\\"none\\",\\"image_alignment\\":\\"image_alignment_left\\",\\"title_image\\":\\"Running Tracks\\",\\"color_button\\":\\"black\\",\\"link_type\\":\\"external\\",\\"link_new_window\\":\\"no\\",\\"overlay_color\\":\\"000000_0.51\\",\\"overlay_effect\\":\\"fadeIn\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"8c59700\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pro-image\\",\\"element_id\\":\\"ldyq700\\",\\"mod_settings\\":{\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/fitness-1327255-290x250.jpg\\",\\"link_image_type\\":\\"image_external\\",\\"link_image_new_window\\":\\"no\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"width_image\\":\\"290\\",\\"height_image\\":\\"250\\",\\"image_filter\\":\\"grayscale\\",\\"image_effect\\":\\"none\\",\\"image_alignment\\":\\"image_alignment_left\\",\\"title_image\\":\\"Yoga Studios\\",\\"color_button\\":\\"black\\",\\"link_type\\":\\"external\\",\\"link_new_window\\":\\"no\\",\\"overlay_color\\":\\"000000_0.51\\",\\"overlay_effect\\":\\"fadeIn\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"q4nk700\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pro-image\\",\\"element_id\\":\\"btmz700\\",\\"mod_settings\\":{\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1323959-2-290x250.jpg\\",\\"link_image_type\\":\\"image_external\\",\\"link_image_new_window\\":\\"no\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"width_image\\":\\"290\\",\\"height_image\\":\\"250\\",\\"image_filter\\":\\"grayscale\\",\\"image_effect\\":\\"none\\",\\"image_alignment\\":\\"image_alignment_left\\",\\"title_image\\":\\"130+ Machines & Equipments\\",\\"color_button\\":\\"black\\",\\"link_type\\":\\"external\\",\\"link_new_window\\":\\"no\\",\\"overlay_color\\":\\"000000_0.51\\",\\"overlay_effect\\":\\"fadeIn\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_border_apply_all\\":\\"border\\"}}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"7mu4682\\",\\"cols\\":[{\\"element_id\\":\\"gedl701\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"9ncq701\\",\\"mod_settings\\":{\\"sub_heading\\":\\"More than 130+ equipments\\",\\"heading\\":\\"Machines & Equipments\\",\\"heading_tag\\":\\"h2\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"text_alignment\\":\\"themify-text-center\\"}},{\\"element_id\\":\\"lxe8702\\",\\"cols\\":[{\\"element_id\\":\\"3j8s703\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"zb8f703\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/09\\\\/dumbles-260x193.jpg\\",\\"width_image\\":\\"260\\",\\"height_image\\":\\"193\\",\\"title_image\\":\\"Dumbells  From 5lbs-75lbs\\",\\"param_image\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"4whn703\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"sgfj704\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/09\\\\/treadmills-260x193.jpg\\",\\"width_image\\":\\"260\\",\\"height_image\\":\\"193\\",\\"title_image\\":\\"Treadmills\\",\\"param_image\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"0tab704\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"7tp9705\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/09\\\\/treadmills-260x193.jpg\\",\\"width_image\\":\\"260\\",\\"height_image\\":\\"193\\",\\"title_image\\":\\"Squat Station\\",\\"param_image\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"d73b705\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"cvq8705\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/09\\\\/babrbels-260x193.jpg\\",\\"width_image\\":\\"260\\",\\"height_image\\":\\"193\\",\\"title_image\\":\\"Barbels\\",\\"param_image\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}]},{\\"element_id\\":\\"rb0t706\\",\\"cols\\":[{\\"element_id\\":\\"6o4g707\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"rmme707\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/09\\\\/strength-raining-260x193.jpg\\",\\"width_image\\":\\"260\\",\\"height_image\\":\\"193\\",\\"title_image\\":\\"Strength Training\\",\\"param_image\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"qx3e708\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"i446708\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/09\\\\/upright-bike-260x193.jpg\\",\\"width_image\\":\\"260\\",\\"height_image\\":\\"193\\",\\"title_image\\":\\"Upright Bike\\",\\"param_image\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"x10t709\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"ajjj709\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/09\\\\/hammer-machine-260x193.jpg\\",\\"width_image\\":\\"260\\",\\"height_image\\":\\"193\\",\\"title_image\\":\\"Hammer Machine\\",\\"param_image\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"qvj7709\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"z32u710\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/09\\\\/stopwatch-260x193.jpg\\",\\"width_image\\":\\"260\\",\\"height_image\\":\\"193\\",\\"title_image\\":\\"Stopwatch\\",\\"param_image\\":\\"regular\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}]}]}],\\"styling\\":{\\"custom_css_row\\":\\"machine-section\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"3.5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"0\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"c37n682\\",\\"cols\\":[{\\"element_id\\":\\"7ail711\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"box\\",\\"element_id\\":\\"indr712\\",\\"mod_settings\\":{\\"content_box\\":\\"<h3>Note<\\\\/h3><ul><li style=\\\\\\\\\\\\\\"text-align: left;\\\\\\\\\\\\\\">Amenities &amp; equipments may vary in different locations.<\\\\/li><li style=\\\\\\\\\\\\\\"text-align: left;\\\\\\\\\\\\\\">Extra pos may apply to some service, maintenance agreements.<\\\\/li><li style=\\\\\\\\\\\\\\"text-align: left;\\\\\\\\\\\\\\">Contact us to confirm.<\\\\/li><\\\\/ul>\\",\\"background_color\\":\\"f4f4f4\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_left_color\\":\\"0bcf6c\\",\\"border_left_width\\":\\"5\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 649,
  'post_date' => '2016-10-12 15:09:19',
  'post_date_gmt' => '2016-10-12 15:09:19',
  'post_content' => '<!--themify_builder_static--><h1>Collections<br/>Summer Collection of 2016</h1>
<ul> <li>
 <a href="https://themify.me/demo/themes/ultra-fitness/product-category/tanks/"> <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/tank-category-image.jpg" alt="Tanks" width="300" height="300" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/tank-category-image.jpg 300w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/tank-category-image-150x150.jpg 150w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/tank-category-image-180x180.jpg 180w" sizes="(max-width: 300px) 100vw, 300px" /> </a> <a href="https://themify.me/demo/themes/ultra-fitness/product/womens-tank-top/"> <img width="300" height="300" src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/womens-tank-with-text-300x300.jpg" alt="" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/womens-tank-with-text-300x300.jpg 300w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/womens-tank-with-text-150x150.jpg 150w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/womens-tank-with-text-180x180.jpg 180w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/womens-tank-with-text.jpg 400w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/womens-tank-with-text-100x100.jpg 100w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/womens-tank-with-text-47x48.jpg 47w" sizes="(max-width: 300px) 100vw, 300px" /> </a> <a href="https://themify.me/demo/themes/ultra-fitness/product/womens-dumbbell-tank/"> <img width="300" height="300" src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/dumbbells-tank-300x300.jpg" alt="" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/dumbbells-tank-300x300.jpg 300w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/dumbbells-tank-150x150.jpg 150w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/dumbbells-tank-768x768.jpg 768w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/dumbbells-tank-180x180.jpg 180w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/dumbbells-tank-600x600.jpg 600w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/dumbbells-tank-100x100.jpg 100w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/dumbbells-tank-47x48.jpg 47w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/dumbbells-tank.jpg 780w" sizes="(max-width: 300px) 100vw, 300px" /> </a> <a href="https://themify.me/demo/themes/ultra-fitness/product/grey-tank/"> <img width="300" height="300" src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-man-tank-300x300.jpg" alt="" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-man-tank-300x300.jpg 300w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-man-tank-150x150.jpg 150w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-man-tank-768x768.jpg 768w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-man-tank-180x180.jpg 180w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-man-tank-600x600.jpg 600w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-man-tank-400x400.jpg 400w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-man-tank-100x100.jpg 100w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-man-tank-47x48.jpg 47w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-man-tank.jpg 1000w" sizes="(max-width: 300px) 100vw, 300px" /> </a> <a href="https://themify.me/demo/themes/ultra-fitness/product-category/tanks/"> <h3> Tanks <mark>(3)</mark> </h3> </a> </li> <li>
 <a href="https://themify.me/demo/themes/ultra-fitness/product-category/pants/"> <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/running-with-jogging-pants-300x300.jpg" alt="Pants" width="300" height="300" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/running-with-jogging-pants-300x300.jpg 300w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/running-with-jogging-pants-150x150.jpg 150w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/running-with-jogging-pants-180x180.jpg 180w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/running-with-jogging-pants-600x600.jpg 600w" sizes="(max-width: 300px) 100vw, 300px" /> </a> <a href="https://themify.me/demo/themes/ultra-fitness/product/athletic-sweatpants/"> <img width="300" height="300" src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants-300x300.jpg" alt="" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants-300x300.jpg 300w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants-150x150.jpg 150w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants-768x768.jpg 768w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants-180x180.jpg 180w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants-600x600.jpg 600w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants-400x400.jpg 400w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants-47x48.jpg 47w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants.jpg 800w" sizes="(max-width: 300px) 100vw, 300px" /> </a> <a href="https://themify.me/demo/themes/ultra-fitness/product/grey-cargo/"> <img width="300" height="300" src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/cargo-sweat-jpants-300x300.jpg" alt="" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/cargo-sweat-jpants-300x300.jpg 300w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/cargo-sweat-jpants-150x150.jpg 150w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/cargo-sweat-jpants-180x180.jpg 180w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/cargo-sweat-jpants-400x400.jpg 400w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/cargo-sweat-jpants-47x48.jpg 47w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/cargo-sweat-jpants.jpg 500w" sizes="(max-width: 300px) 100vw, 300px" /> </a> <a href="https://themify.me/demo/themes/ultra-fitness/product/skinny-womens-pants/"> <img width="300" height="300" src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants-300x300.jpg" alt="" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants-300x300.jpg 300w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants-150x150.jpg 150w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants-768x768.jpg 768w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants-180x180.jpg 180w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants-600x600.jpg 600w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants-400x400.jpg 400w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants-47x48.jpg 47w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants.jpg 800w" sizes="(max-width: 300px) 100vw, 300px" /> </a> <a href="https://themify.me/demo/themes/ultra-fitness/product-category/pants/"> <h3> Pants <mark>(3)</mark> </h3> </a> </li> <li>
 <a href="https://themify.me/demo/themes/ultra-fitness/product-category/jacket/"> <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/jacket-category-image.jpg" alt="Jacket" width="300" height="300" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/jacket-category-image.jpg 300w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/jacket-category-image-150x150.jpg 150w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/jacket-category-image-180x180.jpg 180w" sizes="(max-width: 300px) 100vw, 300px" /> </a> <a href="https://themify.me/demo/themes/ultra-fitness/product/sweat-proof-hoodie/"> <img width="300" height="300" src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/black-sweet-300x300.jpg" alt="" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/black-sweet-300x300.jpg 300w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/black-sweet-150x150.jpg 150w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/black-sweet-180x180.jpg 180w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/black-sweet-100x100.jpg 100w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/black-sweet.jpg 400w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/black-sweet-47x48.jpg 47w" sizes="(max-width: 300px) 100vw, 300px" /> </a> <a href="https://themify.me/demo/themes/ultra-fitness/product/feather-weight-track-sweater/"> <img width="300" height="300" src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/featherweight-300x300.jpg" alt="" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/featherweight-300x300.jpg 300w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/featherweight-150x150.jpg 150w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/featherweight-180x180.jpg 180w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/featherweight-100x100.jpg 100w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/featherweight-47x48.jpg 47w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/featherweight.jpg 400w" sizes="(max-width: 300px) 100vw, 300px" /> </a> <a href="https://themify.me/demo/themes/ultra-fitness/product/climacool-jacket/"> <img width="236" height="236" src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/climacool.jpg" alt="" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/climacool.jpg 236w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/climacool-150x150.jpg 150w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/climacool-180x180.jpg 180w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/climacool-100x100.jpg 100w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/climacool-47x48.jpg 47w" sizes="(max-width: 236px) 100vw, 236px" /> </a> <a href="https://themify.me/demo/themes/ultra-fitness/product-category/jacket/"> <h3> Jacket <mark>(3)</mark> </h3> </a> </li> <li>
 <a href="https://themify.me/demo/themes/ultra-fitness/product-category/gear/"> <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/gear-category-image.jpg" alt="Gear" width="300" height="300" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/gear-category-image.jpg 300w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/gear-category-image-150x150.jpg 150w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/gear-category-image-180x180.jpg 180w" sizes="(max-width: 300px) 100vw, 300px" /> </a> <a href="https://themify.me/demo/themes/ultra-fitness/product/waist-pack-running-belt/"> <img width="300" height="300" src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/waist-pack-running-belt-300x300.jpg" alt="" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/waist-pack-running-belt-300x300.jpg 300w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/waist-pack-running-belt-150x150.jpg 150w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/waist-pack-running-belt-180x180.jpg 180w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/waist-pack-running-belt-400x400.jpg 400w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/waist-pack-running-belt-100x100.jpg 100w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/waist-pack-running-belt-47x48.jpg 47w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/waist-pack-running-belt.jpg 355w" sizes="(max-width: 300px) 100vw, 300px" /> </a> <a href="https://themify.me/demo/themes/ultra-fitness/product/womens-free-weight/"> <img width="300" height="300" src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/free-weight-300x300.jpg" alt="" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/free-weight-300x300.jpg 300w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/free-weight-150x150.jpg 150w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/free-weight-180x180.jpg 180w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/free-weight-100x100.jpg 100w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/free-weight-47x48.jpg 47w" sizes="(max-width: 300px) 100vw, 300px" /> </a> <a href="https://themify.me/demo/themes/ultra-fitness/product/fitbit-charge-2/"> <img width="300" height="300" src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/fitbit-image-300x300.png" alt="" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/fitbit-image-300x300.png 300w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/fitbit-image-150x150.png 150w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/fitbit-image-180x180.png 180w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/fitbit-image-600x600.png 600w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/fitbit-image-100x100.png 100w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/fitbit-image-400x400.png 400w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/fitbit-image-47x48.png 47w" sizes="(max-width: 300px) 100vw, 300px" /> </a> <a href="https://themify.me/demo/themes/ultra-fitness/product-category/gear/"> <h3> Gear <mark>(3)</mark> </h3> </a> </li> </ul>
<h3>Workout Wear</h3><p>Sed odio velit, aliquam sed venenatis eu, vulputate vestibulum leo. In vestibulum libero pretium, cursus eros ac, vestibulum nunc. Nullam finibus eu elit sed lacinia. Curabitur non lacus rutrum, lobortis tortor et.</p>
<a href="https://themify.me" > LEARN MORE </a>
<img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1348138-1-1400x933-600x400.jpg" width="600" height="400" alt="PeopleImages.com ID1348138 1" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1348138-1-1400x933-600x400.jpg 600w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1348138-1-300x200.jpg 300w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1348138-1-768x512.jpg 768w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1348138-1.jpg 1400w" sizes="(max-width: 600px) 100vw, 600px" />
<img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1323981-1400x935-600x400.jpg" width="600" height="400" alt="PeopleImages.com ID1323981" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1323981-1400x935-600x400.jpg 600w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1323981-300x200.jpg 300w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1323981-768x513.jpg 768w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1323981.jpg 1400w" sizes="(max-width: 600px) 100vw, 600px" />
<h3>Lifestyle Performance</h3><p>Nullam finibus eu elit sed lacinia. Curabitur non lacus rutrum, lobortis tortor et, hendrerit libero. Vivamus a elementum libero. Maecenas ornare nulla non placerat dictum.</p>
<a href="https://themify.me" > LEARN MORE </a>
<h1>Top Rated<br/></h1>
<figure> <a href="https://themify.me/demo/themes/ultra-fitness/product/athletic-sweatpants/"><img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants.jpg" alt="grey-multi-pants" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants.jpg 800w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants-150x150.jpg 150w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants-300x300.jpg 300w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants-768x768.jpg 768w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants-180x180.jpg 180w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants-600x600.jpg 600w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants-400x400.jpg 400w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants-47x48.jpg 47w" sizes="(max-width: 800px) 100vw, 800px" /></a> </figure> 
 
 <h3><a href="https://themify.me/demo/themes/ultra-fitness/product/athletic-sweatpants/" title="Athletic Sweatpants">Athletic Sweatpants</a></h3> 
 Rated <strong>4.00</strong> out of 5 &#36;49.00 <p><a href="/demo/themes/ultra-fitness/wp-admin/admin-ajax.php?add-to-cart=660" data-quantity="1" data-product_id="660" data-product_sku="" aria-label="Add &ldquo;Athletic Sweatpants&rdquo; to your cart" rel="nofollow">Add to cart</a></p> [<a href="https://themify.me/demo/themes/ultra-fitness/wp-admin/post.php?post=660&#038;action=edit">Edit</a>] 
 
 <figure> <a href="https://themify.me/demo/themes/ultra-fitness/product/grey-cargo/"><img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/cargo-sweat-jpants.jpg" alt="cargo-sweat-jpants" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/cargo-sweat-jpants.jpg 500w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/cargo-sweat-jpants-150x150.jpg 150w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/cargo-sweat-jpants-300x300.jpg 300w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/cargo-sweat-jpants-180x180.jpg 180w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/cargo-sweat-jpants-400x400.jpg 400w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/cargo-sweat-jpants-47x48.jpg 47w" sizes="(max-width: 500px) 100vw, 500px" /></a> </figure> 
 
 <h3><a href="https://themify.me/demo/themes/ultra-fitness/product/grey-cargo/" title="Grey Cargo">Grey Cargo</a></h3> 
 &#36;120.00 <p><a href="/demo/themes/ultra-fitness/wp-admin/admin-ajax.php?add-to-cart=659" data-quantity="1" data-product_id="659" data-product_sku="" aria-label="Add &ldquo;Grey Cargo&rdquo; to your cart" rel="nofollow">Add to cart</a></p> [<a href="https://themify.me/demo/themes/ultra-fitness/wp-admin/post.php?post=659&#038;action=edit">Edit</a>] 
 
 <figure> <a href="https://themify.me/demo/themes/ultra-fitness/product/skinny-womens-pants/"><img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants.jpg" alt="skinny-jpants" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants.jpg 800w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants-150x150.jpg 150w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants-300x300.jpg 300w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants-768x768.jpg 768w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants-180x180.jpg 180w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants-600x600.jpg 600w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants-400x400.jpg 400w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants-47x48.jpg 47w" sizes="(max-width: 800px) 100vw, 800px" /></a> </figure> 
 Sale! 
 <h3><a href="https://themify.me/demo/themes/ultra-fitness/product/skinny-womens-pants/" title="Skinny Womens Pants">Skinny Womens Pants</a></h3> 
 Rated <strong>5.00</strong> out of 5 <del>&#36;69.00</del> <ins>&#36;59.00</ins> <p><a href="/demo/themes/ultra-fitness/wp-admin/admin-ajax.php?add-to-cart=658" data-quantity="1" data-product_id="658" data-product_sku="" aria-label="Add &ldquo;Skinny Womens Pants&rdquo; to your cart" rel="nofollow">Add to cart</a></p> [<a href="https://themify.me/demo/themes/ultra-fitness/wp-admin/post.php?post=658&#038;action=edit">Edit</a>] 
 
 <figure> <a href="https://themify.me/demo/themes/ultra-fitness/product/waist-pack-running-belt/"><img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/waist-pack-running-belt.jpg" alt="waist-pack-running-belt" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/waist-pack-running-belt.jpg 355w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/waist-pack-running-belt-150x150.jpg 150w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/waist-pack-running-belt-300x300.jpg 300w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/waist-pack-running-belt-180x180.jpg 180w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/waist-pack-running-belt-400x400.jpg 400w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/waist-pack-running-belt-100x100.jpg 100w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/waist-pack-running-belt-47x48.jpg 47w" sizes="(max-width: 355px) 100vw, 355px" /></a> </figure> 
 Sale! 
 <h3><a href="https://themify.me/demo/themes/ultra-fitness/product/waist-pack-running-belt/" title="Waist Pack Running Belt">Waist Pack Running Belt</a></h3> 
 <del>&#36;21.99</del> <ins>&#36;15.00</ins> <p><a href="/demo/themes/ultra-fitness/wp-admin/admin-ajax.php?add-to-cart=631" data-quantity="1" data-product_id="631" data-product_sku="" aria-label="Add &ldquo;Waist Pack Running Belt&rdquo; to your cart" rel="nofollow">Add to cart</a></p> [<a href="https://themify.me/demo/themes/ultra-fitness/wp-admin/post.php?post=631&#038;action=edit">Edit</a>]
<h2>Free International Shipping</h2> <p>Free shipping on all order over $100 and up. Get what you want without adding any hidden shipping fee\'s. Get your apparel now!</p>
<a href="https://themify.me" > Buy Now </a>
<img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/world-map.png" alt="world-map" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/world-map.png 1425w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/world-map-300x156.png 300w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/world-map-768x400.png 768w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/world-map-1400x729.png 1400w" sizes="(max-width: 1425px) 100vw, 1425px" /><!--/themify_builder_static-->',
  'post_title' => 'Apparel',
  'post_excerpt' => '',
  'post_name' => 'apparel',
  'post_modified' => '2019-07-19 17:56:42',
  'post_modified_gmt' => '2019-07-19 17:56:42',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/?page_id=649',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"kd60516\\",\\"cols\\":[{\\"element_id\\":\\"ul16520\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"kzhr521\\",\\"mod_settings\\":{\\"sub_heading\\":\\"Summer Collection of 2016\\",\\"heading\\":\\"Collections\\",\\"heading_tag\\":\\"h1\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"text_alignment\\":\\"themify-text-center\\"}}]}],\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"d3n8516\\",\\"cols\\":[{\\"element_id\\":\\"c9go523\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"product-categories\\",\\"element_id\\":\\"ssho523\\",\\"mod_settings\\":{\\"columns\\":\\"4\\",\\"child_of\\":\\"0\\",\\"orderby\\":\\"name\\",\\"order\\":\\"desc\\",\\"hide_empty\\":\\"yes\\",\\"pad_counts\\":\\"yes\\",\\"latest_products\\":\\"3\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"agmj517\\",\\"cols\\":[{\\"element_id\\":\\"3p9p524\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"s0j9525\\",\\"cols\\":[{\\"element_id\\":\\"v7pf527\\",\\"grid_class\\":\\"col4-1\\"},{\\"element_id\\":\\"ah8g527\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"fial527\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Workout Wear<\\\\/h3><p>Sed odio velit, aliquam sed venenatis eu, vulputate vestibulum leo. In vestibulum libero pretium, cursus eros ac, vestibulum nunc. Nullam finibus eu elit sed lacinia. Curabitur non lacus rutrum, lobortis tortor et.<\\\\/p>\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"center\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"7i14528\\",\\"grid_class\\":\\"col4-1\\"}],\\"gutter\\":\\"gutter-none\\"},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"ywx9528\\",\\"mod_settings\\":{\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"squared\\",\\"content_button\\":[{\\"label\\":\\"LEARN MORE\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"red\\"}],\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"text_align\\":\\"center\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"checkbox_link_padding_apply_all\\":\\"padding\\",\\"checkbox_link_padding_apply_all_padding\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_margin_apply_all_margin\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\",\\"link_checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_css_column\\":\\"vertical-center-block\\"}},{\\"element_id\\":\\"ncln529\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"996s529\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1348138-1.jpg\\",\\"width_image\\":\\"600\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"400\\",\\"param_image\\":\\"regular\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_color\\":\\"222222_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_color\\":\\"ffffff_1.00\\",\\"link_color\\":\\"ffffff_1.00\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"1oet517\\",\\"cols\\":[{\\"element_id\\":\\"j9ys530\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"gsbc531\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1323981.jpg\\",\\"width_image\\":\\"600\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"400\\",\\"param_image\\":\\"regular\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"ol0c531\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"pud3531\\",\\"cols\\":[{\\"element_id\\":\\"i310531\\",\\"grid_class\\":\\"col4-1\\"},{\\"element_id\\":\\"uozl531\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"qp86532\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Lifestyle Performance<\\\\/h3><p>Nullam finibus eu elit sed lacinia. Curabitur non lacus rutrum, lobortis tortor et, hendrerit libero. Vivamus a elementum libero. Maecenas ornare nulla non placerat dictum.<\\\\/p>\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"center\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"p1rk533\\",\\"grid_class\\":\\"col4-1\\"}],\\"gutter\\":\\"gutter-none\\"},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"bkln533\\",\\"mod_settings\\":{\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"squared\\",\\"content_button\\":[{\\"label\\":\\"LEARN MORE\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"red\\"}],\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"text_align\\":\\"center\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"checkbox_link_padding_apply_all\\":\\"padding\\",\\"checkbox_link_padding_apply_all_padding\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_margin_apply_all_margin\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\",\\"link_checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_css_column\\":\\"vertical-center-block\\"}}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_color\\":\\"0bcf6c_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_color\\":\\"ffffff_1.00\\",\\"link_color\\":\\"ffffff_1.00\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"oxml517\\",\\"cols\\":[{\\"element_id\\":\\"mpws533\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"a79q534\\",\\"mod_settings\\":{\\"heading\\":\\"Top Rated\\",\\"heading_tag\\":\\"h1\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"text_alignment\\":\\"themify-text-center\\"}},{\\"mod_name\\":\\"products\\",\\"element_id\\":\\"qxwk534\\",\\"mod_settings\\":{\\"query_products\\":\\"toprated\\",\\"category_products\\":\\"0|multiple\\",\\"hide_child_products\\":\\"no\\",\\"hide_free_products\\":\\"no\\",\\"post_per_page_products\\":\\"4\\",\\"orderby_products\\":\\"date\\",\\"order_products\\":\\"desc\\",\\"template_products\\":\\"list\\",\\"layout_products\\":\\"grid4\\",\\"layout_slider\\":\\"slider-default\\",\\"visible_opt_slider\\":\\"1\\",\\"auto_scroll_opt_slider\\":\\"4\\",\\"scroll_opt_slider\\":\\"1\\",\\"speed_opt_slider\\":\\"normal\\",\\"effect_slider\\":\\"scroll\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"wrap_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"yes\\",\\"show_arrow_slider\\":\\"yes\\",\\"description_products\\":\\"none\\",\\"hide_feat_img_products\\":\\"no\\",\\"unlink_feat_img_products\\":\\"no\\",\\"hide_post_title_products\\":\\"no\\",\\"unlink_post_title_products\\":\\"no\\",\\"hide_price_products\\":\\"no\\",\\"hide_add_to_cart_products\\":\\"no\\",\\"hide_rating_products\\":\\"no\\",\\"hide_sales_badge\\":\\"no\\",\\"hide_page_nav_products\\":\\"yes\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"1icp517\\",\\"cols\\":[{\\"element_id\\":\\"x207534\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"z0aj535\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Free International Shipping<\\\\/h2>\\\\n<p>Free shipping on all order over $100 and up. Get what you want without adding any hidden shipping fee\\\\\\\\\\\'s. Get your apparel now!<\\\\/p>\\\\n\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"lcyk535\\",\\"mod_settings\\":{\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"squared\\",\\"content_button\\":[{\\"label\\":\\"Buy Now\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"red\\"}],\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"text_align\\":\\"left\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"checkbox_link_padding_apply_all\\":\\"padding\\",\\"checkbox_link_padding_apply_all_padding\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_margin_apply_all_margin\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\",\\"link_checkbox_border_apply_all_border\\":\\"border\\",\\"breakpoint_mobile\\":{\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_bottom\\":\\"30\\",\\"margin_bottom_unit\\":\\"px\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"checkbox_link_padding_apply_all\\":\\"padding\\",\\"checkbox_link_padding_apply_all_padding\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_margin_apply_all_margin\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\",\\"link_checkbox_border_apply_all_border\\":\\"border\\"}}}]},{\\"element_id\\":\\"10ow535\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"5nv7535\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/world-map.png\\",\\"param_image\\":\\"regular\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}],\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_color\\":\\"e3e3e3\\",\\"border_top_width\\":\\"2\\",\\"breakpoint_mobile\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 602,
  'post_date' => '2016-10-11 21:33:00',
  'post_date_gmt' => '2016-10-11 21:33:00',
  'post_content' => '[woocommerce_cart]',
  'post_title' => 'Cart',
  'post_excerpt' => '',
  'post_name' => 'cart',
  'post_modified' => '2016-10-11 21:33:00',
  'post_modified_gmt' => '2016-10-11 21:33:00',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/cart/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 603,
  'post_date' => '2016-10-11 21:33:00',
  'post_date_gmt' => '2016-10-11 21:33:00',
  'post_content' => '[woocommerce_checkout]',
  'post_title' => 'Checkout',
  'post_excerpt' => '',
  'post_name' => 'checkout',
  'post_modified' => '2016-10-11 21:33:00',
  'post_modified_gmt' => '2016-10-11 21:33:00',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/checkout/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 4,
  'post_date' => '2016-09-17 02:24:04',
  'post_date_gmt' => '2016-09-17 02:24:04',
  'post_content' => '<!--themify_builder_static--><h1>Ultra Fitness<br/>Your health, our mission</h1>
 <a href="https://www.youtube.com/watch?v=waM20ewLj34" > 
 
 </a> 
 <h3><a href="https://www.youtube.com/watch?v=waM20ewLj34">Watch Showreel</a></h3> 
 
 <h2>3 free visits on us</h2> <p>Submit the form below to get a free visit[mc4wp_form id="9"]</p> 
<h2>Membership<br/>Get unlimited access</h2>
 14 days $12/mo <p>14 days unlimited access to all locations</p> <p></p> <a href="https://themify.me/"> Sign up </a> 
 1 location $24/mo <p>Unlimited access to one location only</p> <p></p> <a href="https://themify.me/"> Sign up </a> 
 POPULAR all locations $48/mo <p>Unlimited access to all locations</p> <p></p> <a href="https://themify.me/"> Sign up </a> 
 2 Locations $32/mo <p>Unlimited access to 2 locations only</p> <p></p> <a href="https://themify.me/"> Sign up </a> 
 <a href="https://themify.me" > <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1323724-1-400x300.jpg" width="400" height="300" title="Cardio" alt="Cardio" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1323724-1.jpg 400w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1323724-1-300x225.jpg 300w" sizes="(max-width: 400px) 100vw, 400px" /> </a> <h3> <a href="https://themify.me" > Cardio </a> </h3> 
 <a href="https://themify.me" > <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1257150-1-400x300.jpg" width="400" height="300" title="Group Class" alt="Group Class" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1257150-1.jpg 400w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1257150-1-300x225.jpg 300w" sizes="(max-width: 400px) 100vw, 400px" /> </a> <h3> <a href="https://themify.me" > Group Class </a> </h3> 
 <a href="https://themify.me" > <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1308267-1-400x300.jpg" width="400" height="300" title="Strength Training" alt="Strength Training" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1308267-1.jpg 400w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1308267-1-300x225.jpg 300w" sizes="(max-width: 400px) 100vw, 400px" /> </a> <h3> <a href="https://themify.me" > Strength Training </a> </h3> 
 <a href="https://themify.me" > <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1347522-1-400x300.jpg" width="400" height="300" title="Yoga" alt="Yoga" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1347522-1.jpg 400w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1347522-1-300x225.jpg 300w" sizes="(max-width: 400px) 100vw, 400px" /> </a> <h3> <a href="https://themify.me" > Yoga </a> </h3> 
 <h2>Choose Training</h2><p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit.</p> 
 <a href="https://themify.me" >LEARN MORE</a> 
<h2>Featured Products<br/>Apparel Line-up</h2>
 
 
 
 <figure> <a href="https://themify.me/demo/themes/ultra-fitness/product/athletic-sweatpants/"><img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants.jpg" alt="grey-multi-pants" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants.jpg 800w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants-150x150.jpg 150w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants-300x300.jpg 300w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants-768x768.jpg 768w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants-180x180.jpg 180w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants-600x600.jpg 600w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants-400x400.jpg 400w" sizes="(max-width: 800px) 100vw, 800px" /></a> </figure> 
 <h3><a href="https://themify.me/demo/themes/ultra-fitness/product/athletic-sweatpants/" title="Athletic Sweatpants">Athletic Sweatpants</a></h3> 
 Rated <strong>4.00</strong> out of 5 &#36;49.00 <p><a href="/demo/themes/ultra-fitness/wp-admin/post.php?post=4&#038;action=edit&#038;meta-box-loader=1&#038;_wpnonce=84a802da59&#038;_locale=user&#038;add-to-cart=660" data-quantity="1" data-product_id="660" data-product_sku="" aria-label="Add &ldquo;Athletic Sweatpants&rdquo; to your cart" rel="nofollow">Add to cart</a></p> [<a href="https://themify.me/demo/themes/ultra-fitness/wp-admin/post.php?post=660&#038;action=edit">Edit</a>] 
 
 <figure> <a href="https://themify.me/demo/themes/ultra-fitness/product/grey-cargo/"><img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/cargo-sweat-jpants.jpg" alt="cargo-sweat-jpants" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/cargo-sweat-jpants.jpg 500w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/cargo-sweat-jpants-150x150.jpg 150w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/cargo-sweat-jpants-300x300.jpg 300w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/cargo-sweat-jpants-180x180.jpg 180w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/cargo-sweat-jpants-400x400.jpg 400w" sizes="(max-width: 500px) 100vw, 500px" /></a> </figure> 
 <h3><a href="https://themify.me/demo/themes/ultra-fitness/product/grey-cargo/" title="Grey Cargo">Grey Cargo</a></h3> 
 &#36;120.00 <p><a href="/demo/themes/ultra-fitness/wp-admin/post.php?post=4&#038;action=edit&#038;meta-box-loader=1&#038;_wpnonce=84a802da59&#038;_locale=user&#038;add-to-cart=659" data-quantity="1" data-product_id="659" data-product_sku="" aria-label="Add &ldquo;Grey Cargo&rdquo; to your cart" rel="nofollow">Add to cart</a></p> [<a href="https://themify.me/demo/themes/ultra-fitness/wp-admin/post.php?post=659&#038;action=edit">Edit</a>] 
 
 <figure> <a href="https://themify.me/demo/themes/ultra-fitness/product/skinny-womens-pants/"><img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants.jpg" alt="skinny-jpants" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants.jpg 800w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants-150x150.jpg 150w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants-300x300.jpg 300w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants-768x768.jpg 768w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants-180x180.jpg 180w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants-600x600.jpg 600w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants-400x400.jpg 400w" sizes="(max-width: 800px) 100vw, 800px" /></a> </figure> 
 Sale! <h3><a href="https://themify.me/demo/themes/ultra-fitness/product/skinny-womens-pants/" title="Skinny Womens Pants">Skinny Womens Pants</a></h3> 
 Rated <strong>5.00</strong> out of 5 <del>&#36;69.00</del> <ins>&#36;59.00</ins> <p><a href="/demo/themes/ultra-fitness/wp-admin/post.php?post=4&#038;action=edit&#038;meta-box-loader=1&#038;_wpnonce=84a802da59&#038;_locale=user&#038;add-to-cart=658" data-quantity="1" data-product_id="658" data-product_sku="" aria-label="Add &ldquo;Skinny Womens Pants&rdquo; to your cart" rel="nofollow">Add to cart</a></p> [<a href="https://themify.me/demo/themes/ultra-fitness/wp-admin/post.php?post=658&#038;action=edit">Edit</a>] 
 
 <figure> <a href="https://themify.me/demo/themes/ultra-fitness/product/waist-pack-running-belt/"><img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/waist-pack-running-belt.jpg" alt="waist-pack-running-belt" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/waist-pack-running-belt.jpg 355w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/waist-pack-running-belt-150x150.jpg 150w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/waist-pack-running-belt-300x300.jpg 300w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/waist-pack-running-belt-180x180.jpg 180w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/waist-pack-running-belt-400x400.jpg 400w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/waist-pack-running-belt-100x100.jpg 100w" sizes="(max-width: 355px) 100vw, 355px" /></a> </figure> 
 Sale! <h3><a href="https://themify.me/demo/themes/ultra-fitness/product/waist-pack-running-belt/" title="Waist Pack Running Belt">Waist Pack Running Belt</a></h3> 
 <del>&#36;21.99</del> <ins>&#36;15.00</ins> <p><a href="/demo/themes/ultra-fitness/wp-admin/post.php?post=4&#038;action=edit&#038;meta-box-loader=1&#038;_wpnonce=84a802da59&#038;_locale=user&#038;add-to-cart=631" data-quantity="1" data-product_id="631" data-product_sku="" aria-label="Add &ldquo;Waist Pack Running Belt&rdquo; to your cart" rel="nofollow">Add to cart</a></p> [<a href="https://themify.me/demo/themes/ultra-fitness/wp-admin/post.php?post=631&#038;action=edit">Edit</a>] 
 
 
 <a href="https://themify.me/demo/themes/ultra-fitness/apparel/" >VIEW MORE</a> 
<h2>Trainers<br/>Our expert trainers</h2>
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID481234-1-260x250.jpg" width="260" height="250" title="Rachel Adams" alt="Yoga instructor" /> <h3> Rachel Adams </h3> Yoga instructor 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1325338-1-260x250.jpg" width="260" height="250" title="Sofia Karim" alt="Gym Instructor" /> <h3> Sofia Karim </h3> Gym Instructor 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID460455-1-260x250.jpg" width="260" height="250" title="Gerald Situmorang" alt="Box Instructor" /> <h3> Gerald Situmorang </h3> Box Instructor 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID473652-1-260x250.jpg" width="260" height="250" title="Uliluwo Santiago" alt="Gym Instructor" /> <h3> Uliluwo Santiago </h3> Gym Instructor 
 <h2>Amenities &amp; Equipments</h2><p>Sed odio velit, aliquam sed venenatis eu, vulputate vestibulum leo. In vestibulum libero pretium, cursus eros ac, vestibulum nunc. Nullam finibus eu elit sed lacinia. Curabitur non lacus rutrum, lobortis tortor et, hendrerit libero. Vivamus a elementum libero. Maecenas ornare nulla non placerat dictum.</p> 
 <a href="https://themify.me" >LEARN MORE</a> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1313874-1-510x170.jpg" width="510" height="170" alt="PeopleImages.com ID1313874 1" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1313874-1-510x170.jpg 510w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1313874-1-600x200.jpg 600w" sizes="(max-width: 510px) 100vw, 510px" /> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1283005-1-300x200.jpg" width="300" height="200" alt="PeopleImages.com ID1283005 1" /> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1313918-1-300x200.jpg" width="300" height="200" alt="PeopleImages.com ID1313918 1" /> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1313875-1-510x170.jpg" width="510" height="170" alt="PeopleImages.com ID1313875 1" /> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1323761-1-510x170.jpg" width="510" height="170" alt="PeopleImages.com ID1323761 1" /> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID479503-1-300x200.jpg" width="300" height="200" alt="PeopleImages.com ID479503 1" /> 
<h2>8 locations<br/>Our workshop location</h2>
 <p>Donec malesuada, velit at eleifend pretium, tellus dolor congue odio, sed aliquet orci massa a purus. Nunc nec dapibus ligula. Sed accumsan, urna ut sodales aliquam.</p> 
 <h2>3 free visits on us</h2><p>Submit the form below to get a free visit<br />[mc4wp_form id="9"]</p> 
 
 
 Spring valley, San Diego, CA Andreen st, San Diego, CA Summerfield st, San Diego, CA Zabel st st, San Diego, CA James Cir, San Diego, CA Boyne st, San Diego, CA Switzer Dr, San Diego, CA Koonce Dr, San Diego, CA<!--/themify_builder_static-->',
  'post_title' => 'Home',
  'post_excerpt' => '',
  'post_name' => 'home',
  'post_modified' => '2019-07-19 17:17:26',
  'post_modified_gmt' => '2019-07-19 17:17:26',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/?page_id=4',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'mobile_menu_styles' => 'default',
    'header_wrap' => 'transparent',
    'footer_widget_position' => 'top',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"8ng5174\\",\\"cols\\":[{\\"element_id\\":\\"ys5p179\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"dfc9180\\",\\"mod_settings\\":{\\"sub_heading\\":\\"Your health, our mission\\",\\"heading\\":\\"Ultra Fitness\\",\\"heading_tag\\":\\"h1\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_size\\":\\"1.2\\",\\"font_size_unit\\":\\"em\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"text_alignment\\":\\"themify-text-center\\"}},{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"yx5c181\\",\\"mod_settings\\":{\\"title_feature\\":\\"Watch Showreel\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"5\\",\\"circle_color_feature\\":\\"ffffff_1.00\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-play\\",\\"icon_color_feature\\":\\"ffffff_1.00\\",\\"link_feature\\":\\"https:\\\\/\\\\/www.youtube.com\\\\/watch?v=waM20ewLj34\\",\\"link_options\\":\\"lightbox\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}}],\\"styling\\":{\\"custom_css_row\\":\\"main-banner\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1175239-1400x858.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_position\\":\\"right-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"000000_0.3\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"15\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"35\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"45\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"rmwn174\\",\\"cols\\":[{\\"element_id\\":\\"1u1x182\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"box\\",\\"element_id\\":\\"0xwe182\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"padding_top\\":\\"42\\",\\"padding_bottom\\":\\"10\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"-133\\",\\"margin_right\\":\\"13\\",\\"margin_right_unit\\":\\"%\\",\\"margin_bottom\\":\\"0\\",\\"margin_left\\":\\"13\\",\\"margin_left_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"margin_right\\":\\"0\\",\\"margin_left\\":\\"0\\"},\\"content_box\\":\\"<h2>3 free visits on us<\\\\/h2>\\\\n<p>Submit the form below to get a free visit[mc4wp_form id=\\\\\\\\\\\\\\"9\\\\\\\\\\\\\\"]<\\\\/p>\\",\\"color_box\\":\\"red\\",\\"add_css_box\\":\\"newsletter-box\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"center\\",\\"checkbox_border_apply_all\\":\\"border\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"t2st175\\",\\"cols\\":[{\\"element_id\\":\\"quoo183\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"m8a4183\\",\\"mod_settings\\":{\\"sub_heading\\":\\"Get unlimited access\\",\\"heading\\":\\"Membership\\",\\"heading_tag\\":\\"h2\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"text_alignment\\":\\"themify-text-center\\"}}]}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"mbx5175\\",\\"cols\\":[{\\"element_id\\":\\"bmty184\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pricing-table\\",\\"element_id\\":\\"2zhn184\\",\\"mod_settings\\":{\\"mod_color_pricing_table\\":\\"gray\\",\\"mod_title_pricing_table\\":\\"14 days\\",\\"mod_price_pricing_table\\":\\"$12\\\\/mo\\",\\"mod_feature_list_pricing_table\\":\\"14 days unlimited access to all locations\\",\\"mod_button_text_pricing_table\\":\\"Sign up\\",\\"mod_button_link_pricing_table\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"border_top_color\\":\\"dddddd\\",\\"border_top_width\\":\\"1\\",\\"border_right_color\\":\\"dddddd\\",\\"border_right_width\\":\\"1\\",\\"border_bottom_color\\":\\"dddddd\\",\\"border_bottom_width\\":\\"1\\",\\"border_left_color\\":\\"dddddd\\",\\"border_left_width\\":\\"1\\",\\"mod_title_font_color\\":\\"404040\\",\\"font_size_title\\":\\"12\\",\\"mod_text_align_title_left\\":\\"left\\",\\"mod_text_align_title_center\\":\\"center\\",\\"mod_text_align_title_right\\":\\"right\\",\\"mod_text_align_title_justify\\":\\"justify\\",\\"mod_title_background_color\\":\\"f4f4f4\\",\\"mod_text_align_content_left\\":\\"left\\",\\"mod_text_align_content_center\\":\\"center\\",\\"mod_text_align_content_right\\":\\"right\\",\\"mod_text_align_content_justify\\":\\"justify\\",\\"mod_text_align_button_left\\":\\"left\\",\\"mod_text_align_button_center\\":\\"center\\",\\"mod_text_align_button_right\\":\\"right\\",\\"mod_text_align_button_justify\\":\\"justify\\",\\"mod_button_bg_color\\":\\"e75d42\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"roxi184\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pricing-table\\",\\"element_id\\":\\"hg24184\\",\\"mod_settings\\":{\\"mod_color_pricing_table\\":\\"gray\\",\\"mod_title_pricing_table\\":\\"1 location\\",\\"mod_price_pricing_table\\":\\"$24\\\\/mo\\",\\"mod_feature_list_pricing_table\\":\\"Unlimited access to one location only\\",\\"mod_button_text_pricing_table\\":\\"Sign up\\",\\"mod_button_link_pricing_table\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"border_top_color\\":\\"dddddd\\",\\"border_top_width\\":\\"1\\",\\"border_right_color\\":\\"dddddd\\",\\"border_right_width\\":\\"1\\",\\"border_bottom_color\\":\\"dddddd\\",\\"border_bottom_width\\":\\"1\\",\\"border_left_color\\":\\"dddddd\\",\\"border_left_width\\":\\"1\\",\\"mod_title_font_color\\":\\"404040\\",\\"font_size_title\\":\\"12\\",\\"mod_text_align_title_left\\":\\"left\\",\\"mod_text_align_title_center\\":\\"center\\",\\"mod_text_align_title_right\\":\\"right\\",\\"mod_text_align_title_justify\\":\\"justify\\",\\"mod_title_background_color\\":\\"f4f4f4\\",\\"mod_text_align_content_left\\":\\"left\\",\\"mod_text_align_content_center\\":\\"center\\",\\"mod_text_align_content_right\\":\\"right\\",\\"mod_text_align_content_justify\\":\\"justify\\",\\"mod_text_align_button_left\\":\\"left\\",\\"mod_text_align_button_center\\":\\"center\\",\\"mod_text_align_button_right\\":\\"right\\",\\"mod_text_align_button_justify\\":\\"justify\\",\\"mod_button_bg_color\\":\\"e75d42\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"m58k184\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pricing-table\\",\\"element_id\\":\\"ntmd185\\",\\"mod_settings\\":{\\"mod_color_pricing_table\\":\\"black\\",\\"mod_title_pricing_table\\":\\"all locations\\",\\"mod_price_pricing_table\\":\\"$48\\\\/mo\\",\\"mod_feature_list_pricing_table\\":\\"Unlimited access to all locations\\",\\"mod_button_text_pricing_table\\":\\"Sign up\\",\\"mod_button_link_pricing_table\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"mod_pop_text_pricing_table\\":\\"POPULAR\\",\\"mod_enlarge_pricing_table\\":\\"enlarge\\",\\"background_image-gradient-angle\\":\\"0\\",\\"border_top_color\\":\\"dddddd_1.00\\",\\"border_top_width\\":\\"1\\",\\"border_right_color\\":\\"dddddd_1.00\\",\\"border_right_width\\":\\"1\\",\\"border_bottom_color\\":\\"dddddd_1.00\\",\\"border_bottom_width\\":\\"1\\",\\"border_left_color\\":\\"dddddd_1.00\\",\\"border_left_width\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"mod_title_font_color\\":\\"ffffff_1.00\\",\\"font_size_title\\":\\"12\\",\\"mod_text_align_title_left\\":\\"left\\",\\"mod_text_align_title_center\\":\\"center\\",\\"mod_text_align_title_right\\":\\"right\\",\\"mod_text_align_title_justify\\":\\"justify\\",\\"mod_title_background_color\\":\\"0bcf6c_1.00\\",\\"mod_feature_font_color\\":\\"575757_1.00\\",\\"mod_text_align_content_left\\":\\"left\\",\\"mod_text_align_content_center\\":\\"center\\",\\"mod_text_align_content_right\\":\\"right\\",\\"mod_text_align_content_justify\\":\\"justify\\",\\"mod_feature_bg_color\\":\\"f4f4f4_1.00\\",\\"mod_text_align_button_left\\":\\"left\\",\\"mod_text_align_button_center\\":\\"center\\",\\"mod_text_align_button_right\\":\\"right\\",\\"mod_text_align_button_justify\\":\\"justify\\",\\"mod_button_bg_color\\":\\"e75d42_1.00\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"77qv185\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pricing-table\\",\\"element_id\\":\\"ofl4185\\",\\"mod_settings\\":{\\"mod_color_pricing_table\\":\\"gray\\",\\"mod_title_pricing_table\\":\\"2 Locations\\",\\"mod_price_pricing_table\\":\\"$32\\\\/mo\\",\\"mod_feature_list_pricing_table\\":\\"Unlimited access to 2 locations only\\",\\"mod_button_text_pricing_table\\":\\"Sign up\\",\\"mod_button_link_pricing_table\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"border_top_color\\":\\"dddddd\\",\\"border_top_width\\":\\"1\\",\\"border_right_color\\":\\"dddddd\\",\\"border_right_width\\":\\"1\\",\\"border_bottom_color\\":\\"dddddd\\",\\"border_bottom_width\\":\\"1\\",\\"border_left_color\\":\\"dddddd\\",\\"border_left_width\\":\\"1\\",\\"mod_title_font_color\\":\\"404040\\",\\"font_size_title\\":\\"12\\",\\"mod_text_align_title_left\\":\\"left\\",\\"mod_text_align_title_center\\":\\"center\\",\\"mod_text_align_title_right\\":\\"right\\",\\"mod_text_align_title_justify\\":\\"justify\\",\\"mod_title_background_color\\":\\"f4f4f4\\",\\"mod_text_align_content_left\\":\\"left\\",\\"mod_text_align_content_center\\":\\"center\\",\\"mod_text_align_content_right\\":\\"right\\",\\"mod_text_align_content_justify\\":\\"justify\\",\\"mod_text_align_button_left\\":\\"left\\",\\"mod_text_align_button_center\\":\\"center\\",\\"mod_text_align_button_right\\":\\"right\\",\\"mod_text_align_button_justify\\":\\"justify\\",\\"mod_button_bg_color\\":\\"e75d42\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"gutter\\":\\"gutter-narrow\\",\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_bottom\\":\\"2\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"6xsx175\\",\\"cols\\":[{\\"element_id\\":\\"u3f2185\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"crv1186\\",\\"cols\\":[{\\"element_id\\":\\"c6ah187\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"m3so187\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1323724-1.jpg\\",\\"width_image\\":\\"400\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"300\\",\\"title_image\\":\\"Cardio\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\",\\"param_image\\":\\"regular\\",\\"css_image\\":\\"aqua-caption\\",\\"font_size\\":\\"1.5\\",\\"font_size_unit\\":\\"em\\",\\"text_align\\":\\"left\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"qnse187\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1257150-1.jpg\\",\\"width_image\\":\\"400\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"300\\",\\"title_image\\":\\"Group Class\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\",\\"param_image\\":\\"regular\\",\\"css_image\\":\\"sky-blue-caption\\",\\"font_size\\":\\"1.5\\",\\"font_size_unit\\":\\"em\\",\\"text_align\\":\\"left\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"1ajv187\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"uz0h187\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1308267-1.jpg\\",\\"width_image\\":\\"400\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"300\\",\\"title_image\\":\\"Strength Training\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\",\\"param_image\\":\\"regular\\",\\"css_image\\":\\"green-caption\\",\\"font_size\\":\\"1.5\\",\\"font_size_unit\\":\\"em\\",\\"text_align\\":\\"left\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"gcq4188\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1347522-1.jpg\\",\\"width_image\\":\\"400\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"300\\",\\"title_image\\":\\"Yoga\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\",\\"param_image\\":\\"regular\\",\\"css_image\\":\\"violet-caption\\",\\"font_size\\":\\"1.5\\",\\"font_size_unit\\":\\"em\\",\\"text_align\\":\\"left\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"gutter\\":\\"gutter-none\\"}]},{\\"element_id\\":\\"nce6188\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"agjf188\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Choose Training<\\\\/h2><p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit.<\\\\/p>\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"8ngb188\\",\\"mod_settings\\":{\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"squared\\",\\"content_button\\":[{\\"label\\":\\"LEARN MORE\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\",\\"button_color_bg\\":\\"red\\"}],\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_link_padding_apply_all\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"6\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"6\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_css_column\\":\\"vertical-center-block\\"}}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"background_color\\":\\"222222_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"link_color\\":\\"ffffff_1.00\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"4xo5175\\",\\"cols\\":[{\\"element_id\\":\\"c05d189\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"f5e7189\\",\\"mod_settings\\":{\\"sub_heading\\":\\"Apparel Line-up\\",\\"heading\\":\\"Featured Products\\",\\"heading_tag\\":\\"h2\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"text_alignment\\":\\"themify-text-center\\"}},{\\"mod_name\\":\\"products\\",\\"element_id\\":\\"refs189\\",\\"mod_settings\\":{\\"query_products\\":\\"featured\\",\\"category_products\\":\\"0|multiple\\",\\"hide_child_products\\":\\"no\\",\\"hide_free_products\\":\\"no\\",\\"post_per_page_products\\":\\"4\\",\\"orderby_products\\":\\"date\\",\\"order_products\\":\\"desc\\",\\"template_products\\":\\"list\\",\\"layout_products\\":\\"grid4\\",\\"layout_slider\\":\\"slider-default\\",\\"visible_opt_slider\\":\\"1\\",\\"auto_scroll_opt_slider\\":\\"4\\",\\"scroll_opt_slider\\":\\"1\\",\\"speed_opt_slider\\":\\"normal\\",\\"effect_slider\\":\\"scroll\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"wrap_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"yes\\",\\"show_arrow_slider\\":\\"yes\\",\\"description_products\\":\\"none\\",\\"hide_feat_img_products\\":\\"no\\",\\"unlink_feat_img_products\\":\\"no\\",\\"hide_post_title_products\\":\\"no\\",\\"unlink_post_title_products\\":\\"no\\",\\"hide_price_products\\":\\"no\\",\\"hide_add_to_cart_products\\":\\"no\\",\\"hide_rating_products\\":\\"no\\",\\"hide_sales_badge\\":\\"no\\",\\"hide_page_nav_products\\":\\"yes\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"8mht189\\",\\"mod_settings\\":{\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"squared\\",\\"content_button\\":[{\\"label\\":\\"VIEW MORE\\",\\"link\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/apparel\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"red\\"}],\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_link_padding_apply_all\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"3v33175\\",\\"cols\\":[{\\"element_id\\":\\"qxqs189\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"rej9189\\",\\"mod_settings\\":{\\"sub_heading\\":\\"Our expert trainers\\",\\"heading\\":\\"Trainers\\",\\"heading_tag\\":\\"h2\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"text_alignment\\":\\"themify-text-center\\"}},{\\"element_id\\":\\"usg1190\\",\\"cols\\":[{\\"element_id\\":\\"cdfs190\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"ifgs190\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID481234-1-260x250.jpg\\",\\"width_image\\":\\"260\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"250\\",\\"title_image\\":\\"Rachel Adams\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Yoga instructor\\",\\"css_image\\":\\"team-member\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_bottom\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"aj43190\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"8xfs190\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1325338-1-260x250.jpg\\",\\"width_image\\":\\"260\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"250\\",\\"title_image\\":\\"Sofia Karim\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Gym Instructor\\",\\"css_image\\":\\"team-member\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_bottom\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"tvsr191\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"un0f191\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID460455-1-260x250.jpg\\",\\"width_image\\":\\"260\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"250\\",\\"title_image\\":\\"Gerald Situmorang\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Box Instructor\\",\\"css_image\\":\\"team-member\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_bottom\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"w0bg191\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"c65i191\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID473652-1-260x250.jpg\\",\\"width_image\\":\\"260\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"250\\",\\"title_image\\":\\"Uliluwo Santiago\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Gym Instructor\\",\\"css_image\\":\\"team-member\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}]}]}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"1dz7175\\",\\"cols\\":[{\\"element_id\\":\\"jco9191\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"lke3192\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Amenities &amp; Equipments<\\\\/h2><p>Sed odio velit, aliquam sed venenatis eu, vulputate vestibulum leo. In vestibulum libero pretium, cursus eros ac, vestibulum nunc. Nullam finibus eu elit sed lacinia. Curabitur non lacus rutrum, lobortis tortor et, hendrerit libero. Vivamus a elementum libero. Maecenas ornare nulla non placerat dictum.<\\\\/p>\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"z82b192\\",\\"mod_settings\\":{\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"squared\\",\\"content_button\\":[{\\"label\\":\\"LEARN MORE\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\",\\"button_color_bg\\":\\"red\\"}],\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_link_padding_apply_all\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"6\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"6\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_css_column\\":\\"vertical-center-block\\"}},{\\"element_id\\":\\"1kyu192\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"rhdx192\\",\\"cols\\":[{\\"element_id\\":\\"9meg192\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"9z8c192\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1313874-1-510x170.jpg\\",\\"width_image\\":\\"510\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"170\\",\\"param_image\\":\\"regular\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"0que192\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"c5ug193\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1283005-1-300x200.jpg\\",\\"width_image\\":\\"300\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"200\\",\\"param_image\\":\\"regular\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_mobile\\":{\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\"}}}]}],\\"gutter\\":\\"gutter-none\\"},{\\"element_id\\":\\"o80b193\\",\\"cols\\":[{\\"element_id\\":\\"2m4p193\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"oat1193\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1313918-1-300x200.jpg\\",\\"width_image\\":\\"300\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"200\\",\\"param_image\\":\\"regular\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"6yw1193\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"m3fa193\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1313875-1-510x170.jpg\\",\\"width_image\\":\\"510\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"170\\",\\"param_image\\":\\"regular\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"gutter\\":\\"gutter-none\\"},{\\"element_id\\":\\"3ptc194\\",\\"cols\\":[{\\"element_id\\":\\"071d194\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"lwlm194\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1323761-1-510x170.jpg\\",\\"width_image\\":\\"510\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"170\\",\\"param_image\\":\\"regular\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"ivpi194\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"6s21194\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID479503-1-300x200.jpg\\",\\"width_image\\":\\"300\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"200\\",\\"param_image\\":\\"regular\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_mobile\\":{\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\"}}}]}],\\"gutter\\":\\"gutter-none\\"}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_border_apply_all\\":\\"border\\"}}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"background_color\\":\\"222222_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"link_color\\":\\"ffffff_1.00\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"tx6t175\\",\\"cols\\":[{\\"element_id\\":\\"s8h1195\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"sp30195\\",\\"mod_settings\\":{\\"sub_heading\\":\\"Our workshop location\\",\\"heading\\":\\"8 locations\\",\\"heading_tag\\":\\"h2\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"text_alignment\\":\\"themify-text-center\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"e68a195\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>Donec malesuada, velit at eleifend pretium, tellus dolor congue odio, sed aliquet orci massa a purus. Nunc nec dapibus ligula. Sed accumsan, urna ut sodales aliquam.<\\\\/p>\\",\\"text_align\\":\\"center\\",\\"padding_right\\":\\"14\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"14\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"2\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"s4gj175\\",\\"cols\\":[{\\"element_id\\":\\"jojl195\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"box\\",\\"element_id\\":\\"rmi2195\\",\\"mod_settings\\":{\\"content_box\\":\\"<h2>3 free visits on us<\\\\/h2><p>Submit the form below to get a free visit<br \\\\/>[mc4wp_form id=\\\\\\\\\\\\\\"9\\\\\\\\\\\\\\"]<\\\\/p>\\",\\"color_box\\":\\"red\\",\\"add_css_box\\":\\"newsletter-box\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"padding_top\\":\\"42\\",\\"padding_bottom\\":\\"10\\",\\"margin_right\\":\\"18\\",\\"margin_right_unit\\":\\"%\\",\\"margin_bottom\\":\\"-110\\",\\"margin_left\\":\\"18\\",\\"margin_left_unit\\":\\"%\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_right\\":\\"0\\",\\"margin_left\\":\\"0\\"}}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"center\\",\\"checkbox_border_apply_all\\":\\"border\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_zindex\\":\\"3\\"}},{\\"element_id\\":\\"280o175\\",\\"cols\\":[{\\"element_id\\":\\"hrq9196\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"maps-pro\\",\\"element_id\\":\\"im1o196\\",\\"mod_settings\\":{\\"map_display_type\\":\\"dynamic\\",\\"w_map\\":\\"100\\",\\"unit_w\\":\\"%\\",\\"w_map_static\\":\\"500\\",\\"h_map\\":\\"645\\",\\"type_map\\":\\"ROADMAP\\",\\"style_map\\":\\"greyscale\\",\\"scrollwheel_map\\":\\"disable\\",\\"draggable_map\\":\\"enable\\",\\"disable_map_ui\\":\\"no\\",\\"zoom_map\\":\\"17\\",\\"map_center\\":\\"Spring valley, San Diego, CA\\",\\"markers\\":[{\\"address\\":\\"Spring valley, San Diego, CA\\",\\"title\\":\\"Spring valley, San Diego, CA\\",\\"image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/09\\\\/gym-location-1.png\\"},{\\"address\\":\\"Andreen st, San Diego, CA\\",\\"title\\":\\"Andreen st, San Diego, CA\\",\\"image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/09\\\\/gym-location-1.png\\"},{\\"address\\":\\"Summerfield st, San Diego, CA\\",\\"title\\":\\"Summerfield st, San Diego, CA\\",\\"image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/09\\\\/gym-location-1.png\\"},{\\"address\\":\\"Zabel st st, San Diego, CA\\",\\"title\\":\\"Zabel st st, San Diego, CA\\",\\"image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/09\\\\/gym-location-1.png\\"},{\\"address\\":\\"James Cir, San Diego, CA\\",\\"title\\":\\"James Cir, San Diego, CA\\",\\"image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/09\\\\/gym-location-1.png\\"},{\\"address\\":\\"Boyne st, San Diego, CA\\",\\"title\\":\\"Boyne st, San Diego, CA\\",\\"image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/09\\\\/gym-location-1.png\\"},{\\"address\\":\\"Switzer Dr, San Diego, CA\\",\\"title\\":\\"Switzer Dr, San Diego, CA\\",\\"image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/09\\\\/gym-location-1.png\\"},{\\"address\\":\\"Koonce Dr, San Diego, CA\\",\\"title\\":\\"Koonce Dr, San Diego, CA\\",\\"image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/09\\\\/gym-location-1.png\\"}],\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"w_map_unit\\":\\"%\\"}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_width\\":\\"fullwidth-content\\"}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 72,
  'post_date' => '2016-09-20 04:42:22',
  'post_date_gmt' => '2016-09-20 04:42:22',
  'post_content' => '<!--themify_builder_static--><h1>Contact & Locations<br/>We have 8 locations throughout the city</h1>
Spring valley, San Diego, CA Andreen st, San Diego, CA Summerfield st, San Diego, CA Zabel st st, San Diego, CA James Cir, San Diego, CA Boyne st, San Diego, CA Switzer Dr, San Diego, CA Koonce Dr, San Diego, CA
<h4>Yorkdale</h4> <p>123 Main Street Ead Madison<br /> Toronto - Otario</p> <p>416-233-3666</p>
<p>[themify_list style="location-hours"]</p><ul><li><strong>Mon - Fri</strong> <em>5:00am - 10:00pm</em></li><li><strong>Sat</strong> <em>9:00am - 8:00pm</em></li><li><strong>Sun</strong> <em>closed</em></li></ul><p>[/themify_list]</p>
<h4>Yonge/King</h4> <p>103 Yonge Street Madison<br /> Toronto - Otario</p> <p>415-243-3777</p>
<p>[themify_list style="location-hours"]</p><ul><li><strong>Mon - Fri</strong> <em>5:00am - 10:00pm</em></li><li><strong>Sat</strong> <em>9:00am - 8:00pm</em></li><li><strong>Sun</strong> <em>closed</em></li></ul><p>[/themify_list]</p>
<h4>Downtown</h4> <p>102 Downtown Street Madison<br /> Toronto - Otario</p> <p>415-243-388</p>
<p>[themify_list style="location-hours"]</p><ul><li><strong>Mon - Fri</strong> <em>5:00am - 10:00pm</em></li><li><strong>Sat</strong> <em>9:00am - 8:00pm</em></li><li><strong>Sun</strong> <em>closed</em></li></ul><p>[/themify_list]</p>
<h4>Union</h4><p>123 Union Street Ead Madison<br />Toronto - Otario</p><p>516-273-4546</p>
<p>[themify_list style="location-hours"]</p><ul><li><strong>Mon - Fri</strong> <em>5:00am - 10:00pm</em></li><li><strong>Sat</strong> <em>9:00am - 8:00pm</em></li><li><strong>Sun</strong> <em>closed</em></li></ul><p>[/themify_list]</p>

<h4>Main Station</h4> <p>363 Main Station Street Ead Madison<br /> Toronto - Otario</p> <p>819-273-8576</p>
<p>[themify_list style="location-hours"]</p><ul><li><strong>Mon - Fri</strong> <em>5:00am - 10:00pm</em></li><li><strong>Sat</strong> <em>9:00am - 8:00pm</em></li><li><strong>Sun</strong> <em>closed</em></li></ul><p>[/themify_list]</p>
<h4>Queen</h4> <p>305 Queen Street Madison<br /> Toronto - Otario</p> <p>435-273-3789</p>
<p>[themify_list style="location-hours"]</p><ul><li><strong>Mon - Fri</strong> <em>5:00am - 10:00pm</em></li><li><strong>Sat</strong> <em>9:00am - 8:00pm</em></li><li><strong>Sun</strong> <em>closed</em></li></ul><p>[/themify_list]</p>
<h4>Finch</h4> <p>602 Finch Street Madison<br /> Toronto - Otario</p> <p>715-283-3809</p>
<p>[themify_list style="location-hours"]</p><ul><li><strong>Mon - Fri</strong> <em>5:00am - 10:00pm</em></li><li><strong>Sat</strong> <em>9:00am - 8:00pm</em></li><li><strong>Sun</strong> <em>closed</em></li></ul><p>[/themify_list]</p>
<h4>King</h4> <p>905 King Street Madison<br /> Toronto - Otario</p> <p>255-277-7781</p>
<p>[themify_list style="location-hours"]</p><ul><li><strong>Mon - Fri</strong> <em>5:00am - 10:00pm</em></li><li><strong>Sat</strong> <em>9:00am - 8:00pm</em></li><li><strong>Sun</strong> <em>closed</em></li></ul><p>[/themify_list]</p>
<h2>Contact</h2>
<form action="https://themify.me/demo/themes/ultra-fitness/wp-admin/admin-ajax.php" id="contact-0--form" method="post"> <label for="contact-0--contact-name">Name </label> <input type="text" name="contact-name" placeholder="" id="contact-0--contact-name" value="" /> <label for="contact-0--contact-email">Email </label> <input type="text" name="contact-email" placeholder="" id="contact-0--contact-email" value="" /> <label for="contact-0--contact-message">Message *</label> <textarea name="contact-message" placeholder="" id="contact-0--contact-message" rows="8" cols="45" required></textarea> <button type="submit"> Submit </button> </form>
<h2>Question<br/></h2>
<p>Donec nisl turpis, luctus ut ultrices ut, dapibus ut mauris. <br />Nunc sodales risus eu molestie laoreet.</p>
<h3><strong>T</strong> +91 44 4265 8098</h3>
<h3><strong>E</strong> info@gymtheme.com</h3><!--/themify_builder_static-->',
  'post_title' => 'Locations',
  'post_excerpt' => '',
  'post_name' => 'locations',
  'post_modified' => '2019-09-19 15:16:06',
  'post_modified_gmt' => '2019-09-19 15:16:06',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/?page_id=72',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'footer_widget_position' => 'top',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"kms9684\\",\\"cols\\":[{\\"element_id\\":\\"fof2695\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"ymgu699\\",\\"mod_settings\\":{\\"sub_heading\\":\\"We have 8 locations throughout the city\\",\\"heading\\":\\"Contact & Locations\\",\\"heading_tag\\":\\"h1\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"text_alignment\\":\\"themify-text-center\\"}}]}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"os84685\\",\\"cols\\":[{\\"element_id\\":\\"p6x4702\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"maps-pro\\",\\"element_id\\":\\"ii42702\\",\\"mod_settings\\":{\\"map_display_type\\":\\"dynamic\\",\\"w_map\\":\\"100\\",\\"unit_w\\":\\"%\\",\\"w_map_static\\":\\"500\\",\\"h_map\\":\\"645\\",\\"type_map\\":\\"ROADMAP\\",\\"style_map\\":\\"greyscale\\",\\"scrollwheel_map\\":\\"disable\\",\\"draggable_map\\":\\"enable\\",\\"disable_map_ui\\":\\"no\\",\\"zoom_map\\":\\"17\\",\\"map_center\\":\\"Spring valley, San Diego, CA\\",\\"markers\\":[{\\"address\\":\\"Spring valley, San Diego, CA\\",\\"title\\":\\"Spring valley, San Diego, CA\\",\\"image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/09\\\\/gym-location-1.png\\"},{\\"address\\":\\"Andreen st, San Diego, CA\\",\\"title\\":\\"Andreen st, San Diego, CA\\",\\"image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/09\\\\/gym-location-1.png\\"},{\\"address\\":\\"Summerfield st, San Diego, CA\\",\\"title\\":\\"Summerfield st, San Diego, CA\\",\\"image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/09\\\\/gym-location-1.png\\"},{\\"address\\":\\"Zabel st st, San Diego, CA\\",\\"title\\":\\"Zabel st st, San Diego, CA\\",\\"image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/09\\\\/gym-location-1.png\\"},{\\"address\\":\\"James Cir, San Diego, CA\\",\\"title\\":\\"James Cir, San Diego, CA\\",\\"image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/09\\\\/gym-location-1.png\\"},{\\"address\\":\\"Boyne st, San Diego, CA\\",\\"title\\":\\"Boyne st, San Diego, CA\\",\\"image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/09\\\\/gym-location-1.png\\"},{\\"address\\":\\"Switzer Dr, San Diego, CA\\",\\"title\\":\\"Switzer Dr, San Diego, CA\\",\\"image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/09\\\\/gym-location-1.png\\"},{\\"address\\":\\"Koonce Dr, San Diego, CA\\",\\"title\\":\\"Koonce Dr, San Diego, CA\\",\\"image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/09\\\\/gym-location-1.png\\"}],\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"w_map_unit\\":\\"%\\",\\"map_polyline\\":\\"no\\",\\"map_polyline_geodesic\\":\\"yes\\",\\"map_polyline_stroke\\":\\"2\\",\\"map_polyline_color\\":\\"#ff0000_1\\"}}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"e9d9685\\",\\"cols\\":[{\\"element_id\\":\\"u578703\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"am65703\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>Yorkdale<\\\\/h4>\\\\n<p>123 Main Street Ead Madison<br \\\\/>\\\\nToronto - Otario<\\\\/p>\\\\n<p>416-233-3666<\\\\/p>\\\\n\\",\\"add_css_text\\":\\"address-info\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"g55x703\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>[themify_list style=\\\\\\\\\\\\\\"location-hours\\\\\\\\\\\\\\"]<\\\\/p><ul><li><strong>Mon - Fri<\\\\/strong> <em>5:00am - 10:00pm<\\\\/em><\\\\/li><li><strong>Sat<\\\\/strong> <em>9:00am - 8:00pm<\\\\/em><\\\\/li><li><strong>Sun<\\\\/strong> <em>closed<\\\\/em><\\\\/li><\\\\/ul><p>[\\\\/themify_list]<\\\\/p>\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"center\\",\\"padding_bottom\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"x5wk704\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"h9nm704\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>Yonge\\\\/King<\\\\/h4>\\\\n<p>103 Yonge Street Madison<br \\\\/>\\\\nToronto - Otario<\\\\/p>\\\\n<p>415-243-3777<\\\\/p>\\\\n\\",\\"add_css_text\\":\\"address-info\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"nh16704\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>[themify_list style=\\\\\\\\\\\\\\"location-hours\\\\\\\\\\\\\\"]<\\\\/p><ul><li><strong>Mon - Fri<\\\\/strong> <em>5:00am - 10:00pm<\\\\/em><\\\\/li><li><strong>Sat<\\\\/strong> <em>9:00am - 8:00pm<\\\\/em><\\\\/li><li><strong>Sun<\\\\/strong> <em>closed<\\\\/em><\\\\/li><\\\\/ul><p>[\\\\/themify_list]<\\\\/p>\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"center\\",\\"padding_bottom\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"9o2v705\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"55pr705\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>Downtown<\\\\/h4>\\\\n<p>102 Downtown Street Madison<br \\\\/>\\\\nToronto - Otario<\\\\/p>\\\\n<p>415-243-388<\\\\/p>\\\\n\\",\\"add_css_text\\":\\"address-info\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"2uit706\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>[themify_list style=\\\\\\\\\\\\\\"location-hours\\\\\\\\\\\\\\"]<\\\\/p><ul><li><strong>Mon - Fri<\\\\/strong> <em>5:00am - 10:00pm<\\\\/em><\\\\/li><li><strong>Sat<\\\\/strong> <em>9:00am - 8:00pm<\\\\/em><\\\\/li><li><strong>Sun<\\\\/strong> <em>closed<\\\\/em><\\\\/li><\\\\/ul><p>[\\\\/themify_list]<\\\\/p>\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"center\\",\\"padding_bottom\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"gc3i706\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ipu1706\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>Union<\\\\/h4><p>123 Union Street Ead Madison<br \\\\/>Toronto - Otario<\\\\/p><p>516-273-4546<\\\\/p>\\",\\"add_css_text\\":\\"address-info\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\"}}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"gbay707\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>[themify_list style=\\\\\\\\\\\\\\"location-hours\\\\\\\\\\\\\\"]<\\\\/p><ul><li><strong>Mon - Fri<\\\\/strong> <em>5:00am - 10:00pm<\\\\/em><\\\\/li><li><strong>Sat<\\\\/strong> <em>9:00am - 8:00pm<\\\\/em><\\\\/li><li><strong>Sun<\\\\/strong> <em>closed<\\\\/em><\\\\/li><\\\\/ul><p>[\\\\/themify_list]<\\\\/p>\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\"}}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"2.5\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"9f8p686\\",\\"cols\\":[{\\"element_id\\":\\"nwse707\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"0vwx708\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"dddddd\\",\\"divider_type\\":\\"fullwidth\\",\\"divider_width\\":\\"200\\",\\"divider_align\\":\\"left\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}]},{\\"element_id\\":\\"cpbc686\\",\\"cols\\":[{\\"element_id\\":\\"qg05708\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"y4j4709\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>Main Station<\\\\/h4>\\\\n<p>363 Main Station Street Ead Madison<br \\\\/>\\\\nToronto - Otario<\\\\/p>\\\\n<p>819-273-8576<\\\\/p>\\\\n\\",\\"add_css_text\\":\\"address-info\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"8j60709\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>[themify_list style=\\\\\\\\\\\\\\"location-hours\\\\\\\\\\\\\\"]<\\\\/p><ul><li><strong>Mon - Fri<\\\\/strong> <em>5:00am - 10:00pm<\\\\/em><\\\\/li><li><strong>Sat<\\\\/strong> <em>9:00am - 8:00pm<\\\\/em><\\\\/li><li><strong>Sun<\\\\/strong> <em>closed<\\\\/em><\\\\/li><\\\\/ul><p>[\\\\/themify_list]<\\\\/p>\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"center\\",\\"padding_bottom\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"g4z4709\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"mera709\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>Queen<\\\\/h4>\\\\n<p>305 Queen Street Madison<br \\\\/>\\\\nToronto - Otario<\\\\/p>\\\\n<p>435-273-3789<\\\\/p>\\\\n\\",\\"add_css_text\\":\\"address-info\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"xm8r710\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>[themify_list style=\\\\\\\\\\\\\\"location-hours\\\\\\\\\\\\\\"]<\\\\/p><ul><li><strong>Mon - Fri<\\\\/strong> <em>5:00am - 10:00pm<\\\\/em><\\\\/li><li><strong>Sat<\\\\/strong> <em>9:00am - 8:00pm<\\\\/em><\\\\/li><li><strong>Sun<\\\\/strong> <em>closed<\\\\/em><\\\\/li><\\\\/ul><p>[\\\\/themify_list]<\\\\/p>\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"center\\",\\"padding_bottom\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"dg69710\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"qbr4710\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>Finch<\\\\/h4>\\\\n<p>602 Finch Street Madison<br \\\\/>\\\\nToronto - Otario<\\\\/p>\\\\n<p>715-283-3809<\\\\/p>\\\\n\\",\\"add_css_text\\":\\"address-info\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"vi43710\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>[themify_list style=\\\\\\\\\\\\\\"location-hours\\\\\\\\\\\\\\"]<\\\\/p><ul><li><strong>Mon - Fri<\\\\/strong> <em>5:00am - 10:00pm<\\\\/em><\\\\/li><li><strong>Sat<\\\\/strong> <em>9:00am - 8:00pm<\\\\/em><\\\\/li><li><strong>Sun<\\\\/strong> <em>closed<\\\\/em><\\\\/li><\\\\/ul><p>[\\\\/themify_list]<\\\\/p>\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"center\\",\\"padding_bottom\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"g4ev711\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"kd5a711\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>King<\\\\/h4>\\\\n<p>905 King Street Madison<br \\\\/>\\\\nToronto - Otario<\\\\/p>\\\\n<p>255-277-7781<\\\\/p>\\\\n\\",\\"add_css_text\\":\\"address-info\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"8sd3712\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>[themify_list style=\\\\\\\\\\\\\\"location-hours\\\\\\\\\\\\\\"]<\\\\/p><ul><li><strong>Mon - Fri<\\\\/strong> <em>5:00am - 10:00pm<\\\\/em><\\\\/li><li><strong>Sat<\\\\/strong> <em>9:00am - 8:00pm<\\\\/em><\\\\/li><li><strong>Sun<\\\\/strong> <em>closed<\\\\/em><\\\\/li><\\\\/ul><p>[\\\\/themify_list]<\\\\/p>\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\"}}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\"}},{\\"element_id\\":\\"3plb686\\",\\"cols\\":[{\\"element_id\\":\\"cdzp716\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"vipn717\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Contact<\\\\/h2>\\",\\"add_css_text\\":\\"style-heading\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"contact\\",\\"element_id\\":\\"w9vd718\\",\\"mod_settings\\":{\\"layout_contact\\":\\"style1\\",\\"field_send_label\\":\\"Submit\\",\\"css_class_contact\\":\\"contact-form\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"field_email_active\\":\\"yes\\",\\"field_name_active\\":\\"yes\\",\\"field_message_active\\":\\"yes\\",\\"field_send_align\\":\\"left\\",\\"contact_sent_from\\":\\"enable\\",\\"send_to_admins\\":\\"true\\",\\"field_sendcopy_active\\":\\"\\",\\"field_captcha_active\\":\\"\\",\\"field_subject_active\\":\\"\\",\\"field_subject_require\\":\\"\\",\\"field_email_require\\":\\"\\",\\"field_name_require\\":\\"\\",\\"post_author\\":\\"\\"}}],\\"styling\\":{\\"background_color\\":\\"e75d42\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"40\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"40\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_css_column\\":\\"contact-section\\"}},{\\"element_id\\":\\"9tfj718\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"y3az719\\",\\"mod_settings\\":{\\"heading\\":\\"Question\\",\\"heading_tag\\":\\"h2\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"text_alignment\\":\\"themify-text-left\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"vk8r719\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>Donec nisl turpis, luctus ut ultrices ut, dapibus ut mauris. <br \\\\/>Nunc sodales risus eu molestie laoreet.<\\\\/p>\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"10\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"text_align\\":\\"left\\",\\"font_color_type\\":\\"font_color_solid\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"nxey719\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3><span style=\\\\\\\\\\\\\\"color: #0bcf6c;\\\\\\\\\\\\\\"><strong>T<\\\\/strong><\\\\/span> +91 44 4265 8098<\\\\/h3>\\",\\"add_css_text\\":\\"green-text\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"text_align\\":\\"left\\",\\"font_color_type\\":\\"font_color_solid\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"rwql720\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3><span style=\\\\\\\\\\\\\\"color: #0bcf6c;\\\\\\\\\\\\\\"><strong>E<\\\\/strong><\\\\/span> info@gymtheme.com<\\\\/h3>\\",\\"add_css_text\\":\\"green-text\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"text_align\\":\\"left\\",\\"font_color_type\\":\\"font_color_solid\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"center\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_css_column\\":\\"contact-info\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":{\\"background_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1348138-1.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"222222_0.9\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"90\\",\\"margin_bottom\\":\\"9\\",\\"margin_bottom_unit\\":\\"em\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"15\\",\\"padding_bottom_unit\\":\\"%\\",\\"margin_bottom\\":\\"0\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 62,
  'post_date' => '2016-09-20 04:34:59',
  'post_date_gmt' => '2016-09-20 04:34:59',
  'post_content' => '<!--themify_builder_static--><h1>Memberships<br/>Join now and get fit</h1>
14 days $12/mo 14 days unlimited access to all locations <a href="https://themify.me/"> Sign up </a>
1 location $24/mo Unlimited access to one location only <a href="https://themify.me/"> Sign up </a>
POPULAR all locations $48/mo Unlimited access to all locations <a href="https://themify.me/"> Sign up </a>
2 Locations $32/mo Unlimited access to 2 locations only <a href="https://themify.me/"> Sign up </a>
<h2>3 free visits on us</h2> <p>Submit the form below to get a free visit.</p> <p>[mc4wp_form id="9"]</p>
<h2>A membership gives you access to all our<br />amenities &amp; equipments</h2>
<a href="https://themify.me/" ></a> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/shower-1-290x250.jpg" width="290" height="250" title="showers" alt="showers" /> 
 
 <h4>showers</h4>
<a href="https://themify.me/" ></a> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/pool-1318072-290x250.jpg" width="290" height="250" title="Pools" alt="Pools" /> 
 
 <h4>Pools</h4>
<a href="https://themify.me/" ></a> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1313880-1-290x250.jpg" width="290" height="250" title="Stream room" alt="Stream room" /> 
 
 <h4>Stream room</h4>
<a href="https://themify.me/" ></a> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/saunas-290x250.jpg" width="290" height="250" title="Saunas" alt="Saunas" /> 
 
 <h4>Saunas</h4>
<a href="https://themify.me/" ></a> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/towels-1197773_1920-1400x932-1-290x250.jpg" width="290" height="250" title="Towels" alt="Towels" /> 
 
 <h4>Towels</h4>
<a href="https://themify.me/" ></a> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1323122-2-290x250.jpg" width="290" height="250" title="Jacuzzis" alt="Jacuzzis" /> 
 
 <h4>Jacuzzis</h4>
<a href="https://themify.me/" ></a> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/lounge-area-290x250.jpg" width="290" height="250" title="Lounge Area" alt="Lounge Area" /> 
 
 <h4>Lounge Area</h4>
<a href="https://themify.me/" ></a> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID460027-290x250.jpg" width="290" height="250" title="Boxing Arena" alt="Boxing Arena" /> 
 
 <h4>Boxing Arena</h4>
<a href="https://themify.me/" ></a> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1349925-1-290x250.jpg" width="290" height="250" title="Lockers" alt="Lockers" /> 
 
 <h4>Lockers</h4>
<a href="https://themify.me/" ></a> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/running-1245640-290x250.jpg" width="290" height="250" title="Running Tracks" alt="Running Tracks" /> 
 
 <h4>Running Tracks</h4>
<a href="https://themify.me/" ></a> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/fitness-1327255-290x250.jpg" width="290" height="250" title="Yoga Studios" alt="Yoga Studios" /> 
 
 <h4>Yoga Studios</h4>
<a href="https://themify.me/" ></a> 
 <img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1323959-2-290x250.jpg" width="290" height="250" title="130 Machines " alt="130 Machines " /> 
 
 <h4>130+ Machines & Equipments</h4>
<h1>Faq’s<br/>Frequently asked questions</h1>
<p>1</p> <h4>How many location do you have?</h4> <p>Donec nisl turpis, luctus ut ultrices ut, dapibus ut mauris. Nunc sodales risus eu molestie laoreet.</p>
<p>2</p> <h4>What is your refund policy?</h4> <p>Donec ut est et tellus convallis convallis. Phasellus id nisi at nisi mollis elementum. Vestibulum a mollis.</p>

<p>3</p> <h4>Can I upgrade/downgrade membership?</h4> <p>Curabitur at convallis ante. Maecenas sodales gravida velit, a semper nisi ultricies in. Mauris ullamcorper ullamcorper lacus, ut lobortis neque vulputate sit amet.</p>
<p>4</p> <h4>Do you provide training?</h4> <p>Donec ut est et tellus convallis convallis. Phasellus id nisi at nisi mollis elementum. Vestibulum a mollis.</p>
<p>5</p> <h4>What payment method do you accept?</h4> <p>Curabitur at convallis ante. Maecenas sodales gravida velit, a semper nisi ultricies in. Mauris ullamcorper ullamcorper lacus, ut lobortis neque vulputate sit amet.</p> <p>&nbsp;</p>
<p>6</p> <h4>Can I have a tour?</h4> <p>Pellentesque tincidunt mi sit amet neque tempor facilisis. Aenean quis metus sollicitudin neque dictum rhoncus. Vivamus est massa, maximus vitae nulla quis.</p><!--/themify_builder_static-->',
  'post_title' => 'Membership',
  'post_excerpt' => '',
  'post_name' => 'membership',
  'post_modified' => '2019-09-18 23:00:37',
  'post_modified_gmt' => '2019-09-18 23:00:37',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/?page_id=62',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'footer_widget_position' => 'top',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"w7zq924\\",\\"cols\\":[{\\"element_id\\":\\"9c7m930\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"gcdu931\\",\\"mod_settings\\":{\\"sub_heading\\":\\"Join now and get fit\\",\\"heading\\":\\"Memberships\\",\\"heading_tag\\":\\"h1\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"text_alignment\\":\\"themify-text-center\\"}}]}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"9gmt925\\",\\"cols\\":[{\\"element_id\\":\\"xlmr934\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pricing-table\\",\\"element_id\\":\\"6m2y935\\",\\"mod_settings\\":{\\"mod_color_pricing_table\\":\\"gray\\",\\"mod_title_pricing_table\\":\\"14 days\\",\\"mod_price_pricing_table\\":\\"$12\\\\/mo\\",\\"mod_feature_list_pricing_table\\":\\"14 days unlimited access to all locations\\",\\"mod_button_text_pricing_table\\":\\"Sign up\\",\\"mod_button_link_pricing_table\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"border_top_color\\":\\"dddddd\\",\\"border_top_width\\":\\"1\\",\\"border_right_color\\":\\"dddddd\\",\\"border_right_width\\":\\"1\\",\\"border_bottom_color\\":\\"dddddd\\",\\"border_bottom_width\\":\\"1\\",\\"border_left_color\\":\\"dddddd\\",\\"border_left_width\\":\\"1\\",\\"mod_title_font_color\\":\\"404040\\",\\"font_size_title\\":\\"12\\",\\"mod_text_align_title_left\\":\\"left\\",\\"mod_text_align_title_center\\":\\"center\\",\\"mod_text_align_title_right\\":\\"right\\",\\"mod_text_align_title_justify\\":\\"justify\\",\\"mod_title_background_color\\":\\"f4f4f4\\",\\"mod_text_align_content_left\\":\\"left\\",\\"mod_text_align_content_center\\":\\"center\\",\\"mod_text_align_content_right\\":\\"right\\",\\"mod_text_align_content_justify\\":\\"justify\\",\\"mod_text_align_button_left\\":\\"left\\",\\"mod_text_align_button_center\\":\\"center\\",\\"mod_text_align_button_right\\":\\"right\\",\\"mod_text_align_button_justify\\":\\"justify\\",\\"mod_button_bg_color\\":\\"e75d42\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"krfr935\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pricing-table\\",\\"element_id\\":\\"o9tv936\\",\\"mod_settings\\":{\\"mod_color_pricing_table\\":\\"gray\\",\\"mod_title_pricing_table\\":\\"1 location\\",\\"mod_price_pricing_table\\":\\"$24\\\\/mo\\",\\"mod_feature_list_pricing_table\\":\\"Unlimited access to one location only\\",\\"mod_button_text_pricing_table\\":\\"Sign up\\",\\"mod_button_link_pricing_table\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"border_top_color\\":\\"dddddd\\",\\"border_top_width\\":\\"1\\",\\"border_right_color\\":\\"dddddd\\",\\"border_right_width\\":\\"1\\",\\"border_bottom_color\\":\\"dddddd\\",\\"border_bottom_width\\":\\"1\\",\\"border_left_color\\":\\"dddddd\\",\\"border_left_width\\":\\"1\\",\\"mod_title_font_color\\":\\"404040\\",\\"font_size_title\\":\\"12\\",\\"mod_text_align_title_left\\":\\"left\\",\\"mod_text_align_title_center\\":\\"center\\",\\"mod_text_align_title_right\\":\\"right\\",\\"mod_text_align_title_justify\\":\\"justify\\",\\"mod_title_background_color\\":\\"f4f4f4\\",\\"mod_text_align_content_left\\":\\"left\\",\\"mod_text_align_content_center\\":\\"center\\",\\"mod_text_align_content_right\\":\\"right\\",\\"mod_text_align_content_justify\\":\\"justify\\",\\"mod_text_align_button_left\\":\\"left\\",\\"mod_text_align_button_center\\":\\"center\\",\\"mod_text_align_button_right\\":\\"right\\",\\"mod_text_align_button_justify\\":\\"justify\\",\\"mod_button_bg_color\\":\\"e75d42\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"k2ry936\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pricing-table\\",\\"element_id\\":\\"vheq937\\",\\"mod_settings\\":{\\"mod_color_pricing_table\\":\\"black\\",\\"mod_title_pricing_table\\":\\"all locations\\",\\"mod_price_pricing_table\\":\\"$48\\\\/mo\\",\\"mod_feature_list_pricing_table\\":\\"Unlimited access to all locations\\",\\"mod_button_text_pricing_table\\":\\"Sign up\\",\\"mod_button_link_pricing_table\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"mod_pop_text_pricing_table\\":\\"POPULAR\\",\\"mod_enlarge_pricing_table\\":\\"enlarge\\",\\"background_image-gradient-angle\\":\\"0\\",\\"border_top_color\\":\\"dddddd_1.00\\",\\"border_top_width\\":\\"1\\",\\"border_right_color\\":\\"dddddd_1.00\\",\\"border_right_width\\":\\"1\\",\\"border_bottom_color\\":\\"dddddd_1.00\\",\\"border_bottom_width\\":\\"1\\",\\"border_left_color\\":\\"dddddd_1.00\\",\\"border_left_width\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"mod_title_font_color\\":\\"ffffff_1.00\\",\\"font_size_title\\":\\"12\\",\\"mod_text_align_title_left\\":\\"left\\",\\"mod_text_align_title_center\\":\\"center\\",\\"mod_text_align_title_right\\":\\"right\\",\\"mod_text_align_title_justify\\":\\"justify\\",\\"mod_title_background_color\\":\\"0bcf6c_1.00\\",\\"mod_feature_font_color\\":\\"525252_1.00\\",\\"mod_text_align_content_left\\":\\"left\\",\\"mod_text_align_content_center\\":\\"center\\",\\"mod_text_align_content_right\\":\\"right\\",\\"mod_text_align_content_justify\\":\\"justify\\",\\"mod_feature_bg_color\\":\\"f4f4f4_1.00\\",\\"mod_text_align_button_left\\":\\"left\\",\\"mod_text_align_button_center\\":\\"center\\",\\"mod_text_align_button_right\\":\\"right\\",\\"mod_text_align_button_justify\\":\\"justify\\",\\"mod_button_bg_color\\":\\"e75d42_1.00\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"uopt937\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pricing-table\\",\\"element_id\\":\\"jnpl937\\",\\"mod_settings\\":{\\"mod_color_pricing_table\\":\\"gray\\",\\"mod_title_pricing_table\\":\\"2 Locations\\",\\"mod_price_pricing_table\\":\\"$32\\\\/mo\\",\\"mod_feature_list_pricing_table\\":\\"Unlimited access to 2 locations only\\",\\"mod_button_text_pricing_table\\":\\"Sign up\\",\\"mod_button_link_pricing_table\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"border_top_color\\":\\"dddddd\\",\\"border_top_width\\":\\"1\\",\\"border_right_color\\":\\"dddddd\\",\\"border_right_width\\":\\"1\\",\\"border_bottom_color\\":\\"dddddd\\",\\"border_bottom_width\\":\\"1\\",\\"border_left_color\\":\\"dddddd\\",\\"border_left_width\\":\\"1\\",\\"mod_title_font_color\\":\\"404040\\",\\"font_size_title\\":\\"12\\",\\"mod_text_align_title_left\\":\\"left\\",\\"mod_text_align_title_center\\":\\"center\\",\\"mod_text_align_title_right\\":\\"right\\",\\"mod_text_align_title_justify\\":\\"justify\\",\\"mod_title_background_color\\":\\"f4f4f4\\",\\"mod_text_align_content_left\\":\\"left\\",\\"mod_text_align_content_center\\":\\"center\\",\\"mod_text_align_content_right\\":\\"right\\",\\"mod_text_align_content_justify\\":\\"justify\\",\\"mod_text_align_button_left\\":\\"left\\",\\"mod_text_align_button_center\\":\\"center\\",\\"mod_text_align_button_right\\":\\"right\\",\\"mod_text_align_button_justify\\":\\"justify\\",\\"mod_button_bg_color\\":\\"e75d42\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"gutter\\":\\"gutter-narrow\\",\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_bottom\\":\\"2\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"i85h925\\",\\"cols\\":[{\\"element_id\\":\\"p8ai938\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"box\\",\\"element_id\\":\\"dkhi938\\",\\"mod_settings\\":{\\"content_box\\":\\"<h2>3 free visits on us<\\\\/h2>\\\\n<p>Submit the form below to get a free visit.<\\\\/p>\\\\n<p>[mc4wp_form id=\\\\\\\\\\\\\\"9\\\\\\\\\\\\\\"]<\\\\/p>\\",\\"color_box\\":\\"red\\",\\"add_css_box\\":\\"newsletter-box\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"padding_top\\":\\"42\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_left_unit\\":\\"%\\",\\"margin_right\\":\\"18\\",\\"margin_right_unit\\":\\"%\\",\\"margin_bottom\\":\\"-150\\",\\"margin_left\\":\\"18\\",\\"margin_left_unit\\":\\"%\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_right\\":\\"0\\",\\"margin_bottom\\":\\"50\\",\\"margin_left\\":\\"0\\"},\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"repeat\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_right_unit\\":\\"%\\",\\"margin_bottom\\":\\"-80\\",\\"margin_left_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\"},\\"custom_parallax_scroll_zindex\\":\\"1\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"center\\",\\"checkbox_border_apply_all\\":\\"border\\"}}],\\"styling\\":{\\"custom_parallax_scroll_zindex\\":\\"3\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"0\\",\\"margin_bottom\\":\\"0\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"s2gy925\\",\\"cols\\":[{\\"element_id\\":\\"9e2w939\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"uhwh939\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>A membership gives you access to all our<br \\\\/>amenities &amp; equipments<\\\\/h2>\\",\\"add_css_text\\":\\"membership-section\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"6\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"background_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1323981-1400x935.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"000000_0.60\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"21\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"7\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"q4rq925\\",\\"cols\\":[{\\"element_id\\":\\"mwoj940\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pro-image\\",\\"element_id\\":\\"9d56940\\",\\"mod_settings\\":{\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/shower-1-290x250.jpg\\",\\"link_image_type\\":\\"image_external\\",\\"link_image_new_window\\":\\"no\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"width_image\\":\\"290\\",\\"height_image\\":\\"250\\",\\"image_filter\\":\\"grayscale\\",\\"image_effect\\":\\"none\\",\\"image_alignment\\":\\"image_alignment_left\\",\\"title_image\\":\\"showers\\",\\"color_button\\":\\"black\\",\\"link_type\\":\\"external\\",\\"link_new_window\\":\\"no\\",\\"overlay_color\\":\\"000000_0.51\\",\\"overlay_effect\\":\\"fadeIn\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"yufu940\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pro-image\\",\\"element_id\\":\\"dlhp941\\",\\"mod_settings\\":{\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/pool-1318072-290x250.jpg\\",\\"link_image_type\\":\\"image_external\\",\\"link_image_new_window\\":\\"no\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"width_image\\":\\"290\\",\\"height_image\\":\\"250\\",\\"image_filter\\":\\"grayscale\\",\\"image_effect\\":\\"none\\",\\"image_alignment\\":\\"image_alignment_left\\",\\"title_image\\":\\"Pools\\",\\"color_button\\":\\"black\\",\\"link_type\\":\\"external\\",\\"link_new_window\\":\\"no\\",\\"overlay_color\\":\\"000000_0.54\\",\\"overlay_effect\\":\\"fadeIn\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"7oqz941\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pro-image\\",\\"element_id\\":\\"k7lj941\\",\\"mod_settings\\":{\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1313880-1-290x250.jpg\\",\\"link_image_type\\":\\"image_external\\",\\"link_image_new_window\\":\\"no\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"width_image\\":\\"290\\",\\"height_image\\":\\"250\\",\\"image_filter\\":\\"grayscale\\",\\"image_effect\\":\\"none\\",\\"image_alignment\\":\\"image_alignment_left\\",\\"title_image\\":\\"Stream room\\",\\"color_button\\":\\"black\\",\\"link_type\\":\\"external\\",\\"link_new_window\\":\\"no\\",\\"overlay_color\\":\\"000000_0.53\\",\\"overlay_effect\\":\\"fadeIn\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"fo30941\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pro-image\\",\\"element_id\\":\\"jhcw945\\",\\"mod_settings\\":{\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/saunas-290x250.jpg\\",\\"link_image_type\\":\\"image_external\\",\\"link_image_new_window\\":\\"no\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"width_image\\":\\"290\\",\\"height_image\\":\\"250\\",\\"image_filter\\":\\"grayscale\\",\\"image_effect\\":\\"none\\",\\"image_alignment\\":\\"image_alignment_left\\",\\"title_image\\":\\"Saunas\\",\\"color_button\\":\\"black\\",\\"link_type\\":\\"external\\",\\"link_new_window\\":\\"no\\",\\"overlay_color\\":\\"000000_0.51\\",\\"overlay_effect\\":\\"fadeIn\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_border_apply_all\\":\\"border\\"}}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"-250\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet_landscape\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"-212\\",\\"checkbox_border_apply_all\\":\\"1\\"},\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_tablet\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"-159\\",\\"checkbox_border_apply_all\\":\\"1\\"}}},{\\"element_id\\":\\"10wu925\\",\\"cols\\":[{\\"element_id\\":\\"f0e0945\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pro-image\\",\\"element_id\\":\\"134r946\\",\\"mod_settings\\":{\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/towels-1197773_1920-1400x932-1-290x250.jpg\\",\\"link_image_type\\":\\"image_external\\",\\"link_image_new_window\\":\\"no\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"width_image\\":\\"290\\",\\"height_image\\":\\"250\\",\\"image_filter\\":\\"grayscale\\",\\"image_effect\\":\\"none\\",\\"image_alignment\\":\\"image_alignment_left\\",\\"title_image\\":\\"Towels\\",\\"color_button\\":\\"black\\",\\"link_type\\":\\"external\\",\\"link_new_window\\":\\"no\\",\\"overlay_color\\":\\"000000_0.51\\",\\"overlay_effect\\":\\"fadeIn\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"0d8k946\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pro-image\\",\\"element_id\\":\\"a3c9946\\",\\"mod_settings\\":{\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1323122-2-290x250.jpg\\",\\"link_image_type\\":\\"image_external\\",\\"link_image_new_window\\":\\"no\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"width_image\\":\\"290\\",\\"height_image\\":\\"250\\",\\"image_filter\\":\\"grayscale\\",\\"image_effect\\":\\"none\\",\\"image_alignment\\":\\"image_alignment_left\\",\\"title_image\\":\\"Jacuzzis\\",\\"color_button\\":\\"black\\",\\"link_type\\":\\"external\\",\\"link_new_window\\":\\"no\\",\\"overlay_color\\":\\"000000_0.51\\",\\"overlay_effect\\":\\"fadeIn\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"3jls946\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pro-image\\",\\"element_id\\":\\"xbyx946\\",\\"mod_settings\\":{\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/lounge-area-290x250.jpg\\",\\"link_image_type\\":\\"image_external\\",\\"link_image_new_window\\":\\"no\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"width_image\\":\\"290\\",\\"height_image\\":\\"250\\",\\"image_filter\\":\\"grayscale\\",\\"image_effect\\":\\"none\\",\\"image_alignment\\":\\"image_alignment_left\\",\\"title_image\\":\\"Lounge Area\\",\\"color_button\\":\\"black\\",\\"link_type\\":\\"external\\",\\"link_new_window\\":\\"no\\",\\"overlay_color\\":\\"000000_0.51\\",\\"overlay_effect\\":\\"fadeIn\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"czi9946\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pro-image\\",\\"element_id\\":\\"c7jb947\\",\\"mod_settings\\":{\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID460027-290x250.jpg\\",\\"link_image_type\\":\\"image_external\\",\\"link_image_new_window\\":\\"no\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"width_image\\":\\"290\\",\\"height_image\\":\\"250\\",\\"image_filter\\":\\"grayscale\\",\\"image_effect\\":\\"none\\",\\"image_alignment\\":\\"image_alignment_left\\",\\"title_image\\":\\"Boxing Arena\\",\\"color_button\\":\\"black\\",\\"link_type\\":\\"external\\",\\"link_new_window\\":\\"no\\",\\"overlay_color\\":\\"000000_0.51\\",\\"overlay_effect\\":\\"fadeIn\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_border_apply_all\\":\\"border\\"}}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"8ksw925\\",\\"cols\\":[{\\"element_id\\":\\"0381947\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pro-image\\",\\"element_id\\":\\"bomx947\\",\\"mod_settings\\":{\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1349925-1-290x250.jpg\\",\\"link_image_type\\":\\"image_external\\",\\"link_image_new_window\\":\\"no\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"width_image\\":\\"290\\",\\"height_image\\":\\"250\\",\\"image_filter\\":\\"grayscale\\",\\"image_effect\\":\\"none\\",\\"image_alignment\\":\\"image_alignment_left\\",\\"title_image\\":\\"Lockers\\",\\"color_button\\":\\"black\\",\\"link_type\\":\\"external\\",\\"link_new_window\\":\\"no\\",\\"overlay_color\\":\\"000000_0.51\\",\\"overlay_effect\\":\\"fadeIn\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"xsoo947\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pro-image\\",\\"element_id\\":\\"z4vi948\\",\\"mod_settings\\":{\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/running-1245640-290x250.jpg\\",\\"link_image_type\\":\\"image_external\\",\\"link_image_new_window\\":\\"no\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"width_image\\":\\"290\\",\\"height_image\\":\\"250\\",\\"image_filter\\":\\"grayscale\\",\\"image_effect\\":\\"none\\",\\"image_alignment\\":\\"image_alignment_left\\",\\"title_image\\":\\"Running Tracks\\",\\"color_button\\":\\"black\\",\\"link_type\\":\\"external\\",\\"link_new_window\\":\\"no\\",\\"overlay_color\\":\\"000000_0.51\\",\\"overlay_effect\\":\\"fadeIn\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"csu2948\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pro-image\\",\\"element_id\\":\\"gn5s948\\",\\"mod_settings\\":{\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/fitness-1327255-290x250.jpg\\",\\"link_image_type\\":\\"image_external\\",\\"link_image_new_window\\":\\"no\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"width_image\\":\\"290\\",\\"height_image\\":\\"250\\",\\"image_filter\\":\\"grayscale\\",\\"image_effect\\":\\"none\\",\\"image_alignment\\":\\"image_alignment_left\\",\\"title_image\\":\\"Yoga Studios\\",\\"color_button\\":\\"black\\",\\"link_type\\":\\"external\\",\\"link_new_window\\":\\"no\\",\\"overlay_color\\":\\"000000_0.51\\",\\"overlay_effect\\":\\"fadeIn\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"qlb4948\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"pro-image\\",\\"element_id\\":\\"hw4i948\\",\\"mod_settings\\":{\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1323959-2-290x250.jpg\\",\\"link_image_type\\":\\"image_external\\",\\"link_image_new_window\\":\\"no\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"width_image\\":\\"290\\",\\"height_image\\":\\"250\\",\\"image_filter\\":\\"grayscale\\",\\"image_effect\\":\\"none\\",\\"image_alignment\\":\\"image_alignment_left\\",\\"title_image\\":\\"130+ Machines & Equipments\\",\\"color_button\\":\\"black\\",\\"link_type\\":\\"external\\",\\"link_new_window\\":\\"no\\",\\"overlay_color\\":\\"000000_0.51\\",\\"overlay_effect\\":\\"fadeIn\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_border_apply_all\\":\\"border\\"}}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"or55926\\",\\"cols\\":[{\\"element_id\\":\\"fhly949\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"tmx9949\\",\\"mod_settings\\":{\\"sub_heading\\":\\"Frequently asked questions\\",\\"heading\\":\\"Faq’s\\",\\"heading_tag\\":\\"h1\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"12\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"text_alignment\\":\\"themify-text-center\\"}},{\\"element_id\\":\\"i4fe949\\",\\"cols\\":[{\\"element_id\\":\\"dafz951\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"8hrm951\\",\\"mod_settings\\":{\\"content_text\\":\\"<p><span class=\\\\\\\\\\\\\\"number\\\\\\\\\\\\\\">1<\\\\/span><\\\\/p>\\\\n<h4>How many location do you have?<\\\\/h4>\\\\n<p>Donec nisl turpis, luctus ut ultrices ut, dapibus ut mauris. Nunc sodales risus eu molestie laoreet.<\\\\/p>\\\\n\\",\\"add_css_text\\":\\"faq-row\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"x6yj952\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"8ukl953\\",\\"mod_settings\\":{\\"content_text\\":\\"<p><span class=\\\\\\\\\\\\\\"number\\\\\\\\\\\\\\">2<\\\\/span><\\\\/p>\\\\n<h4>What is your refund policy?<\\\\/h4>\\\\n<p>Donec ut est et tellus convallis convallis. Phasellus id nisi at nisi mollis elementum. Vestibulum a mollis.<\\\\/p>\\\\n\\",\\"add_css_text\\":\\"faq-row\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}]},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ouon954\\",\\"mod_settings\\":{\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"custom_css_row\\":\\"faq\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"4b4x926\\",\\"cols\\":[{\\"element_id\\":\\"d846955\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"p6q8955\\",\\"mod_settings\\":{\\"content_text\\":\\"<p><span class=\\\\\\\\\\\\\\"number\\\\\\\\\\\\\\">3<\\\\/span><\\\\/p>\\\\n<h4>Can I upgrade\\\\/downgrade membership?<\\\\/h4>\\\\n<p>Curabitur at convallis ante. Maecenas sodales gravida velit, a semper nisi ultricies in. Mauris ullamcorper ullamcorper lacus, ut lobortis neque vulputate sit amet.<\\\\/p>\\\\n\\",\\"add_css_text\\":\\"faq-row\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"z8iy955\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"d7y9955\\",\\"mod_settings\\":{\\"content_text\\":\\"<p><span class=\\\\\\\\\\\\\\"number\\\\\\\\\\\\\\">4<\\\\/span><\\\\/p>\\\\n<h4>Do you provide training?<\\\\/h4>\\\\n<p>Donec ut est et tellus convallis convallis. Phasellus id nisi at nisi mollis elementum. Vestibulum a mollis.<\\\\/p>\\\\n\\",\\"add_css_text\\":\\"faq-row\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}]},{\\"element_id\\":\\"kcj7926\\",\\"cols\\":[{\\"element_id\\":\\"vz44956\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"1vsv956\\",\\"mod_settings\\":{\\"content_text\\":\\"<p><span class=\\\\\\\\\\\\\\"number\\\\\\\\\\\\\\">5<\\\\/span><\\\\/p>\\\\n<h4>What payment method do you accept?<\\\\/h4>\\\\n<p>Curabitur at convallis ante. Maecenas sodales gravida velit, a semper nisi ultricies in. Mauris ullamcorper ullamcorper lacus, ut lobortis neque vulputate sit amet.<\\\\/p>\\\\n<p>&nbsp;<\\\\/p>\\\\n\\",\\"add_css_text\\":\\"faq-row\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"76en957\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"sbo6957\\",\\"mod_settings\\":{\\"content_text\\":\\"<p><span class=\\\\\\\\\\\\\\"number\\\\\\\\\\\\\\">6<\\\\/span><\\\\/p>\\\\n<h4>Can I have a tour?<\\\\/h4>\\\\n<p>Pellentesque tincidunt mi sit amet neque tempor facilisis. Aenean quis metus sollicitudin neque dictum rhoncus. Vivamus est massa, maximus vitae nulla quis.<\\\\/p>\\\\n\\",\\"add_css_text\\":\\"faq-row\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_bottom\\":\\"15\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 604,
  'post_date' => '2016-10-11 21:33:00',
  'post_date_gmt' => '2016-10-11 21:33:00',
  'post_content' => '[woocommerce_my_account]',
  'post_title' => 'My Account',
  'post_excerpt' => '',
  'post_name' => 'my-account',
  'post_modified' => '2016-10-11 21:33:00',
  'post_modified_gmt' => '2016-10-11 21:33:00',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/my-account/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 802,
  'post_date' => '2019-05-08 23:27:23',
  'post_date_gmt' => '2019-05-08 23:27:23',
  'post_content' => '<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Shop',
  'post_excerpt' => '',
  'post_name' => 'shop',
  'post_modified' => '2019-05-08 23:27:24',
  'post_modified_gmt' => '2019-05-08 23:27:24',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/?page_id=802',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'section_scrolling_mobile' => 'on',
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 64,
  'post_date' => '2016-09-20 04:36:54',
  'post_date_gmt' => '2016-09-20 04:36:54',
  'post_content' => '<!--themify_builder_static--><h1>Clasess & training<br/>Join a class, get fit.</h1>
<img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1283985-375x450.jpg" width="375" height="450" title="Cardio" alt="Cardio" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1283985.jpg 375w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1283985-250x300.jpg 250w" sizes="(max-width: 375px) 100vw, 375px" /> <h3> Cardio </h3>
<img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID473746-375x450.jpg" width="375" height="450" title="Strength Training" alt="Strength Training" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID473746.jpg 375w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID473746-250x300.jpg 250w" sizes="(max-width: 375px) 100vw, 375px" /> <h3> Strength Training </h3>
<img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1300975-375x450.jpg" width="375" height="450" title="Group Class" alt="Group Class" srcset="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1300975.jpg 375w, https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1300975-250x300.jpg 250w" sizes="(max-width: 375px) 100vw, 375px" /> <h3> Group Class </h3>
<img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1335824-946x1400.jpg" width="375" height="450" title="Yoga" alt="Yoga" /> <h3> Yoga </h3>
<h2>Get a free class</h2><p>Contact us to book a free class</p>
<a href="http://themify.me/" > Contact Us </a>
<p>Or Call  +91 44 4265 8098</p>
<h2>Trainers<br/>Meet our trainers</h2>
<img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID481234-1-260x250.jpg" width="260" height="250" title="Rachel Adams" alt="Yoga instructor" /> <h3> Rachel Adams </h3> Yoga instructor
<img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1325338-1-260x250.jpg" width="260" height="250" title="Sofia Karim" alt="Gym Instructor" /> <h3> Sofia Karim </h3> Gym Instructor
<img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID460455-1-260x250.jpg" width="260" height="250" title="Gerald Situmorang" alt="Box Instructor" /> <h3> Gerald Situmorang </h3> Box Instructor
<img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID473652-1-260x250.jpg" width="260" height="250" title="Uliluwo Santiago" alt="Gym Instructor" /> <h3> Uliluwo Santiago </h3> Gym Instructor
<img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1337074-260x250.jpg" width="260" height="250" title="Abias Mandra" alt="Yoga instructor" /> <h3> Abias Mandra </h3> Yoga instructor
<img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1323896-260x250.jpg" width="260" height="250" title="Irfan Andika" alt="Gym Instructor" /> <h3> Irfan Andika </h3> Gym Instructor
<img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1181234-260x250.jpg" width="260" height="250" title="Jonathan Lessi" alt="Box Instructor" /> <h3> Jonathan Lessi </h3> Box Instructor
<img src="https://themify.me/demo/themes/ultra-fitness/files/2016/10/PeopleImages.com-ID1304165-260x250.jpg" width="260" height="250" title="Fenita Roger" alt="Gym Instructor" /> <h3> Fenita Roger </h3> Gym Instructor<!--/themify_builder_static-->',
  'post_title' => 'Training',
  'post_excerpt' => '',
  'post_name' => 'training',
  'post_modified' => '2019-07-19 17:56:03',
  'post_modified_gmt' => '2019-07-19 17:56:03',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/?page_id=64',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'header_design' => 'header-horizontal',
    'footer_widget_position' => 'top',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"5byu316\\",\\"cols\\":[{\\"element_id\\":\\"g4ms320\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"366q321\\",\\"mod_settings\\":{\\"sub_heading\\":\\"Join a class, get fit.\\",\\"heading\\":\\"Clasess & training\\",\\"heading_tag\\":\\"h1\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"text_alignment\\":\\"themify-text-center\\"}}]}],\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"tmbw317\\",\\"cols\\":[{\\"element_id\\":\\"ppi0323\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"6mfg323\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1283985.jpg\\",\\"width_image\\":\\"375\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"450\\",\\"title_image\\":\\"Cardio\\",\\"param_image\\":\\"regular\\",\\"css_image\\":\\"aqua-caption\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_size\\":\\"1.5\\",\\"font_size_unit\\":\\"em\\",\\"text_align\\":\\"left\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"0gcb323\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"olts323\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID473746.jpg\\",\\"width_image\\":\\"375\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"450\\",\\"title_image\\":\\"Strength Training\\",\\"param_image\\":\\"regular\\",\\"css_image\\":\\"orange-caption\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_size\\":\\"1.5\\",\\"font_size_unit\\":\\"em\\",\\"text_align\\":\\"left\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"cbdn323\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"duyp324\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1300975.jpg\\",\\"width_image\\":\\"375\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"450\\",\\"title_image\\":\\"Group Class\\",\\"param_image\\":\\"regular\\",\\"css_image\\":\\"sky-blue-caption\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_size\\":\\"1.5\\",\\"font_size_unit\\":\\"em\\",\\"text_align\\":\\"left\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"2phr324\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"jakz324\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1335824-946x1400.jpg\\",\\"width_image\\":\\"375\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"450\\",\\"title_image\\":\\"Yoga\\",\\"param_image\\":\\"regular\\",\\"css_image\\":\\"violet-caption\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_size\\":\\"1.5\\",\\"font_size_unit\\":\\"em\\",\\"text_align\\":\\"left\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"sjk2317\\",\\"cols\\":[{\\"element_id\\":\\"p29m324\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"awwo325\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Get a free class<\\\\/h2><p>Contact us to book a free class<\\\\/p>\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"breakpoint_mobile\\":{\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"text_align\\":\\"center\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_bottom\\":\\"10\\",\\"margin_bottom_unit\\":\\"px\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all_border\\":\\"border\\"}}}],\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_color\\":\\"ffffff_1.00\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"ols6325\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"u9bf325\\",\\"mod_settings\\":{\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"squared\\",\\"content_button\\":[{\\"label\\":\\"Contact Us\\",\\"link\\":\\"http:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\"}],\\"css_button\\":\\"contact-btn\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"text_align\\":\\"center\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_bottom\\":\\"25\\",\\"margin_bottom_unit\\":\\"px\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"button_background_color\\":\\"ffffff_1.00\\",\\"link_color\\":\\"e75d42\\",\\"checkbox_link_padding_apply_all\\":\\"padding\\",\\"checkbox_link_padding_apply_all_padding\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_margin_apply_all_margin\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\",\\"link_checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"4d6v325\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>Or Call  +91 44 4265 8098<\\\\/p>\\",\\"add_css_text\\":\\"contact-text\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"text_align\\":\\"center\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_color\\":\\"ffffff_1.00\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":{\\"custom_css_row\\":\\"free-class-section\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_color\\":\\"e75d42\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"1\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"hde4317\\",\\"cols\\":[{\\"element_id\\":\\"d82q325\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"jmh7326\\",\\"mod_settings\\":{\\"sub_heading\\":\\"Meet our trainers\\",\\"heading\\":\\"Trainers\\",\\"heading_tag\\":\\"h2\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_bottom\\":\\"20\\",\\"margin_bottom_unit\\":\\"px\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"text_alignment\\":\\"themify-text-center\\"}},{\\"element_id\\":\\"zuob326\\",\\"cols\\":[{\\"element_id\\":\\"xtj9327\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"3fkb327\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID481234-1-260x250.jpg\\",\\"width_image\\":\\"260\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"250\\",\\"title_image\\":\\"Rachel Adams\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Yoga instructor\\",\\"css_image\\":\\"team-member\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_bottom\\":\\"30\\",\\"margin_bottom_unit\\":\\"px\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_mobile\\":{\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_bottom\\":\\"50\\",\\"margin_bottom_unit\\":\\"px\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all_border\\":\\"border\\"}}}]},{\\"element_id\\":\\"ry04327\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"i70f327\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1325338-1-260x250.jpg\\",\\"width_image\\":\\"260\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"250\\",\\"title_image\\":\\"Sofia Karim\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Gym Instructor\\",\\"css_image\\":\\"team-member\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_bottom\\":\\"30\\",\\"margin_bottom_unit\\":\\"px\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_mobile\\":{\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_bottom\\":\\"50\\",\\"margin_bottom_unit\\":\\"px\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all_border\\":\\"border\\"}}}]},{\\"element_id\\":\\"8d4y327\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"3q72327\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID460455-1-260x250.jpg\\",\\"width_image\\":\\"260\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"250\\",\\"title_image\\":\\"Gerald Situmorang\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Box Instructor\\",\\"css_image\\":\\"team-member\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_bottom\\":\\"30\\",\\"margin_bottom_unit\\":\\"px\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_mobile\\":{\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_bottom\\":\\"50\\",\\"margin_bottom_unit\\":\\"px\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all_border\\":\\"border\\"}}}]},{\\"element_id\\":\\"chgv328\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"79j9328\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID473652-1-260x250.jpg\\",\\"width_image\\":\\"260\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"250\\",\\"title_image\\":\\"Uliluwo Santiago\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Gym Instructor\\",\\"css_image\\":\\"team-member\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_bottom\\":\\"30\\",\\"margin_bottom_unit\\":\\"px\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}]},{\\"element_id\\":\\"k0tz328\\",\\"cols\\":[{\\"element_id\\":\\"m7y1328\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"gl51328\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1337074-260x250.jpg\\",\\"width_image\\":\\"260\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"250\\",\\"title_image\\":\\"Abias Mandra\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Yoga instructor\\",\\"css_image\\":\\"team-member\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_bottom\\":\\"30\\",\\"margin_bottom_unit\\":\\"px\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"scji329\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"mc9x329\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1323896-260x250.jpg\\",\\"width_image\\":\\"260\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"250\\",\\"title_image\\":\\"Irfan Andika\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Gym Instructor\\",\\"css_image\\":\\"team-member\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_bottom\\":\\"30\\",\\"margin_bottom_unit\\":\\"px\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"vlae329\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"g90t329\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1181234-260x250.jpg\\",\\"width_image\\":\\"260\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"250\\",\\"title_image\\":\\"Jonathan Lessi\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Box Instructor\\",\\"css_image\\":\\"team-member\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_bottom\\":\\"30\\",\\"margin_bottom_unit\\":\\"px\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"xnux329\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"o2r4329\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/PeopleImages.com-ID1304165-260x250.jpg\\",\\"width_image\\":\\"260\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"250\\",\\"title_image\\":\\"Fenita Roger\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Gym Instructor\\",\\"css_image\\":\\"team-member\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_bottom\\":\\"30\\",\\"margin_bottom_unit\\":\\"px\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}]}]}],\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"padding_top\\":\\"2\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 660,
  'post_date' => '2016-10-12 18:18:08',
  'post_date_gmt' => '2016-10-12 18:18:08',
  'post_content' => 'Nullam habitant interdum ligula rhoncus. Condimentum pharetra varius nisl mollis turpis suscipit eget, sollicitudin posuere senectus. Amet amet tortor nullam consectetur quam. Morbi sit quis justo varius cursus est luctus tempor at.',
  'post_title' => 'Athletic Sweatpants',
  'post_excerpt' => '',
  'post_name' => 'athletic-sweatpants',
  'post_modified' => '2017-06-29 20:17:02',
  'post_modified_gmt' => '2017-06-29 20:17:02',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/?post_type=product&#038;p=660',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1498767352:115',
    '_edit_last' => '115',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '662',
    'post_image' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants.jpg',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '49',
    '_price' => '49',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_stock' => NULL,
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '3.0.0',
    '_yoast_wpseo_primary_product_cat' => '10',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
      4 => '1',
    ),
    '_wc_review_count' => '1',
    '_wc_average_rating' => '4.00',
    '_tax_status' => 'taxable',
    '_default_attributes' => 
    array (
    ),
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_visibility' => 'featured, rated-5',
    'product_cat' => 'pants',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-multi-pants.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 659,
  'post_date' => '2016-10-12 18:17:02',
  'post_date_gmt' => '2016-10-12 18:17:02',
  'post_content' => 'Sit cubilia fermentum est montes platea. In elit nisl per nascetur praesent aenean tristique blandit adipiscing hac blandit. Fringilla ridiculus pulvinar iaculis nunc cubilia faucibus per suspendisse. Iaculis pharetra lectus tortor elit netus dolor mollis metus, habitant fusce cursus.',
  'post_title' => 'Grey Cargo',
  'post_excerpt' => '',
  'post_name' => 'grey-cargo',
  'post_modified' => '2016-10-12 18:17:02',
  'post_modified_gmt' => '2016-10-12 18:17:02',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/?post_type=product&#038;p=659',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1476296152:115',
    '_edit_last' => '115',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '663',
    'post_image' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/cargo-sweat-jpants.jpg',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '120',
    '_price' => '120',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '3.0.0',
    '_yoast_wpseo_primary_product_cat' => '10',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1476296152:115\\",\\"element_id\\":\\"fyuj404\\"},\\"_edit_last\\":{\\"0\\":\\"115\\",\\"element_id\\":\\"b4dn494\\"},\\"_visibility\\":{\\"0\\":\\"visible\\",\\"element_id\\":\\"v1nj066\\"},\\"_stock_status\\":{\\"0\\":\\"instock\\",\\"element_id\\":\\"cvge740\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"obz9404\\"},\\"_thumbnail_id\\":{\\"0\\":\\"663\\",\\"element_id\\":\\"g74k420\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/cargo-sweat-jpants.jpg\\",\\"element_id\\":\\"4om9021\\"},\\"total_sales\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"g5es114\\"},\\"_downloadable\\":{\\"0\\":\\"no\\",\\"element_id\\":\\"62g9204\\"},\\"_virtual\\":{\\"0\\":\\"no\\",\\"element_id\\":\\"g6ky410\\"},\\"_purchase_note\\":{\\"0\\":\\"\\",\\"element_id\\":\\"p6gy920\\"},\\"_featured\\":{\\"0\\":\\"no\\",\\"element_id\\":\\"hfd3297\\"},\\"_weight\\":{\\"0\\":\\"\\",\\"element_id\\":\\"1xhy218\\"},\\"_length\\":{\\"0\\":\\"\\",\\"element_id\\":\\"73vm009\\"},\\"_width\\":{\\"0\\":\\"\\",\\"element_id\\":\\"k88s111\\"},\\"_height\\":{\\"0\\":\\"\\",\\"element_id\\":\\"thub413\\"},\\"_sku\\":{\\"0\\":\\"\\",\\"element_id\\":\\"13ca133\\"},\\"_product_attributes\\":{\\"0\\":\\"a:0:{}\\",\\"element_id\\":\\"20uk300\\"},\\"_regular_price\\":{\\"0\\":\\"120\\",\\"element_id\\":\\"li3s430\\"},\\"_sale_price\\":{\\"0\\":\\"\\",\\"element_id\\":\\"0zry093\\"},\\"_sale_price_dates_from\\":{\\"0\\":\\"\\",\\"element_id\\":\\"3hmp490\\"},\\"_sale_price_dates_to\\":{\\"0\\":\\"\\",\\"element_id\\":\\"x7tr494\\"},\\"_price\\":{\\"0\\":\\"120\\",\\"element_id\\":\\"056w441\\"},\\"_sold_individually\\":{\\"0\\":\\"\\",\\"element_id\\":\\"yxlu011\\"},\\"_manage_stock\\":{\\"0\\":\\"no\\",\\"element_id\\":\\"8hhs010\\"},\\"_backorders\\":{\\"0\\":\\"no\\",\\"element_id\\":\\"gr9c409\\"},\\"_stock\\":{\\"0\\":\\"\\",\\"element_id\\":\\"tdvd144\\"},\\"_upsell_ids\\":{\\"0\\":\\"a:0:{}\\",\\"element_id\\":\\"pipp466\\"},\\"_crosssell_ids\\":{\\"0\\":\\"a:0:{}\\",\\"element_id\\":\\"64p8490\\"},\\"_product_version\\":{\\"0\\":\\"2.6.4\\",\\"element_id\\":\\"yup1914\\"},\\"_product_image_gallery\\":{\\"0\\":\\"\\",\\"element_id\\":\\"r2nw900\\"},\\"_yoast_wpseo_primary_product_cat\\":{\\"0\\":\\"10\\",\\"element_id\\":\\"5njl104\\"},\\"_yoast_wpseo_content_score\\":{\\"0\\":\\"30\\",\\"element_id\\":\\"egwl402\\"},\\"_wc_rating_count\\":{\\"0\\":\\"a:0:{}\\",\\"element_id\\":\\"met5030\\"},\\"_wc_average_rating\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"115f404\\"},\\"_wc_review_count\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"yirs055\\"}}',
    '_tax_status' => 'taxable',
    '_default_attributes' => 
    array (
    ),
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_visibility' => 'featured, rated-5',
    'product_cat' => 'pants',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/cargo-sweat-jpants.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 658,
  'post_date' => '2016-10-12 18:15:29',
  'post_date_gmt' => '2016-10-12 18:15:29',
  'post_content' => 'Pharetra nibh nulla nibh sed. Feugiat, at pretium praesent. Vivamus et cursus interdum tellus risus euismod. Sagittis cras nisi dis viverra praesent proin nulla scelerisque. Vehicula integer, cum lorem sollicitudin risus nunc odio.',
  'post_title' => 'Skinny Womens Pants',
  'post_excerpt' => '',
  'post_name' => 'skinny-womens-pants',
  'post_modified' => '2016-10-12 21:37:25',
  'post_modified_gmt' => '2016-10-12 21:37:25',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/?post_type=product&#038;p=658',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1476296153:115',
    '_edit_last' => '115',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '661',
    'post_image' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants.jpg',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'yes',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '69',
    '_sale_price' => '59',
    '_price' => '59',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '3.0.0',
    '_yoast_wpseo_primary_product_cat' => '10',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
      5 => 1,
    ),
    '_wc_review_count' => '1',
    '_wc_average_rating' => '5.00',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"element_id\\":\\"tv8a003\\"}],\\"element_id\\":\\"kz61862\\"}]',
    '_tax_status' => 'taxable',
    '_default_attributes' => 
    array (
    ),
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_visibility' => 'featured, rated-5',
    'product_cat' => 'pants',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/skinny-jpants.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 631,
  'post_date' => '2016-10-11 22:53:36',
  'post_date_gmt' => '2016-10-11 22:53:36',
  'post_content' => 'Placerat adipiscing erat aptent. Ridiculus neque commodo sapien, mattis aptent luctus. Velit dolor curabitur sit orci cubilia malesuada tempus porttitor. Magna semper lobortis aliquam eget primis hac mi ante lacus. Cursus felis venenatis massa sociis aptent maecenas!',
  'post_title' => 'Waist Pack Running Belt',
  'post_excerpt' => '',
  'post_name' => 'waist-pack-running-belt',
  'post_modified' => '2016-10-11 22:53:36',
  'post_modified_gmt' => '2016-10-11 22:53:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/?post_type=product&#038;p=631',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1476226285:115',
    '_edit_last' => '115',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '627',
    'post_image' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/waist-pack-running-belt.jpg',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'yes',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '21.99',
    '_sale_price' => '15',
    '_price' => '15',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '3.0.0',
    '_yoast_wpseo_primary_product_cat' => '9',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1476226285:115\\",\\"element_id\\":\\"7jru333\\"},\\"_edit_last\\":{\\"0\\":\\"115\\",\\"element_id\\":\\"5wl3301\\"},\\"_visibility\\":{\\"0\\":\\"visible\\",\\"element_id\\":\\"tsxm302\\"},\\"_stock_status\\":{\\"0\\":\\"instock\\",\\"element_id\\":\\"hz42841\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"1fns003\\"},\\"_thumbnail_id\\":{\\"0\\":\\"627\\",\\"element_id\\":\\"j7xm303\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/waist-pack-running-belt.jpg\\",\\"element_id\\":\\"c7oh433\\"},\\"total_sales\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"i9en300\\"},\\"_downloadable\\":{\\"0\\":\\"no\\",\\"element_id\\":\\"zp7p414\\"},\\"_virtual\\":{\\"0\\":\\"no\\",\\"element_id\\":\\"51mf404\\"},\\"_purchase_note\\":{\\"0\\":\\"\\",\\"element_id\\":\\"ebm6434\\"},\\"_featured\\":{\\"0\\":\\"no\\",\\"element_id\\":\\"fyq5013\\"},\\"_weight\\":{\\"0\\":\\"\\",\\"element_id\\":\\"kbh4333\\"},\\"_length\\":{\\"0\\":\\"\\",\\"element_id\\":\\"38js300\\"},\\"_width\\":{\\"0\\":\\"\\",\\"element_id\\":\\"mb13330\\"},\\"_height\\":{\\"0\\":\\"\\",\\"element_id\\":\\"m6d0303\\"},\\"_sku\\":{\\"0\\":\\"\\",\\"element_id\\":\\"kdbf333\\"},\\"_product_attributes\\":{\\"0\\":\\"a:0:{}\\",\\"element_id\\":\\"iz4l013\\"},\\"_regular_price\\":{\\"0\\":\\"21.99\\",\\"element_id\\":\\"noxa440\\"},\\"_sale_price\\":{\\"0\\":\\"15\\",\\"element_id\\":\\"3meo843\\"},\\"_sale_price_dates_from\\":{\\"0\\":\\"\\",\\"element_id\\":\\"7mrs194\\"},\\"_sale_price_dates_to\\":{\\"0\\":\\"\\",\\"element_id\\":\\"gm2u430\\"},\\"_price\\":{\\"0\\":\\"15\\",\\"element_id\\":\\"g3zd432\\"},\\"_sold_individually\\":{\\"0\\":\\"\\",\\"element_id\\":\\"vkd4551\\"},\\"_manage_stock\\":{\\"0\\":\\"no\\",\\"element_id\\":\\"07yk351\\"},\\"_backorders\\":{\\"0\\":\\"no\\",\\"element_id\\":\\"0lp1401\\"},\\"_stock\\":{\\"0\\":\\"\\",\\"element_id\\":\\"8hi5033\\"},\\"_upsell_ids\\":{\\"0\\":\\"a:0:{}\\",\\"element_id\\":\\"d1su800\\"},\\"_crosssell_ids\\":{\\"0\\":\\"a:0:{}\\",\\"element_id\\":\\"31gt099\\"},\\"_product_version\\":{\\"0\\":\\"2.6.4\\",\\"element_id\\":\\"16za030\\"},\\"_product_image_gallery\\":{\\"0\\":\\"\\",\\"element_id\\":\\"1cjr031\\"},\\"_yoast_wpseo_primary_product_cat\\":{\\"0\\":\\"9\\",\\"element_id\\":\\"7ntn303\\"},\\"_yoast_wpseo_content_score\\":{\\"0\\":\\"30\\",\\"element_id\\":\\"q8sf613\\"},\\"_wc_rating_count\\":{\\"0\\":\\"a:0:{}\\",\\"element_id\\":\\"tzja030\\"},\\"_wc_average_rating\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"1kor303\\"}}',
    '_wc_review_count' => '0',
    '_tax_status' => 'taxable',
    '_default_attributes' => 
    array (
    ),
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_visibility' => 'featured, rated-5',
    'product_cat' => 'gear',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/waist-pack-running-belt.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 630,
  'post_date' => '2016-10-11 22:52:58',
  'post_date_gmt' => '2016-10-11 22:52:58',
  'post_content' => 'Pulvinar consequat ridiculus posuere nam natoque dolor tincidunt nibh. Elementum curabitur fermentum congue pretium dis aliquet iaculis. Mauris penatibus sapien diam sodales laoreet est.',
  'post_title' => 'Women\'s Free Weight',
  'post_excerpt' => '',
  'post_name' => 'womens-free-weight',
  'post_modified' => '2016-10-11 22:52:58',
  'post_modified_gmt' => '2016-10-11 22:52:58',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/?post_type=product&#038;p=630',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1476226283:115',
    '_edit_last' => '115',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '628',
    'post_image' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/free-weight.jpg',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '8.50',
    '_price' => '8.50',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '2.6.4',
    '_yoast_wpseo_primary_product_cat' => '9',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1476226283:115\\",\\"element_id\\":\\"h2zx806\\"},\\"_edit_last\\":{\\"0\\":\\"115\\",\\"element_id\\":\\"6jqz300\\"},\\"_visibility\\":{\\"0\\":\\"visible\\",\\"element_id\\":\\"do2d808\\"},\\"_stock_status\\":{\\"0\\":\\"instock\\",\\"element_id\\":\\"w71h093\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"cvme508\\"},\\"_thumbnail_id\\":{\\"0\\":\\"628\\",\\"element_id\\":\\"lccx660\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/free-weight.jpg\\",\\"element_id\\":\\"48ht309\\"},\\"total_sales\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"rykg399\\"},\\"_downloadable\\":{\\"0\\":\\"no\\",\\"element_id\\":\\"67po083\\"},\\"_virtual\\":{\\"0\\":\\"no\\",\\"element_id\\":\\"femz080\\"},\\"_purchase_note\\":{\\"0\\":\\"\\",\\"element_id\\":\\"yiu1388\\"},\\"_featured\\":{\\"0\\":\\"no\\",\\"element_id\\":\\"lwjt800\\"},\\"_weight\\":{\\"0\\":\\"\\",\\"element_id\\":\\"xyq6835\\"},\\"_length\\":{\\"0\\":\\"\\",\\"element_id\\":\\"kpe2368\\"},\\"_width\\":{\\"0\\":\\"\\",\\"element_id\\":\\"dpub707\\"},\\"_height\\":{\\"0\\":\\"\\",\\"element_id\\":\\"yilf099\\"},\\"_sku\\":{\\"0\\":\\"\\",\\"element_id\\":\\"3g5u180\\"},\\"_product_attributes\\":{\\"0\\":\\"a:0:{}\\",\\"element_id\\":\\"0nal188\\"},\\"_regular_price\\":{\\"0\\":\\"8.50\\",\\"element_id\\":\\"o5yy702\\"},\\"_sale_price\\":{\\"0\\":\\"\\",\\"element_id\\":\\"txtk883\\"},\\"_sale_price_dates_from\\":{\\"0\\":\\"\\",\\"element_id\\":\\"sgsk588\\"},\\"_sale_price_dates_to\\":{\\"0\\":\\"\\",\\"element_id\\":\\"w0pk381\\"},\\"_price\\":{\\"0\\":\\"8.50\\",\\"element_id\\":\\"pbzj070\\"},\\"_sold_individually\\":{\\"0\\":\\"\\",\\"element_id\\":\\"5kqj803\\"},\\"_manage_stock\\":{\\"0\\":\\"no\\",\\"element_id\\":\\"as7h300\\"},\\"_backorders\\":{\\"0\\":\\"no\\",\\"element_id\\":\\"yqhb788\\"},\\"_stock\\":{\\"0\\":\\"\\",\\"element_id\\":\\"5pod822\\"},\\"_upsell_ids\\":{\\"0\\":\\"a:0:{}\\",\\"element_id\\":\\"bnhz888\\"},\\"_crosssell_ids\\":{\\"0\\":\\"a:0:{}\\",\\"element_id\\":\\"wvqv274\\"},\\"_product_version\\":{\\"0\\":\\"2.6.4\\",\\"element_id\\":\\"el3p887\\"},\\"_product_image_gallery\\":{\\"0\\":\\"\\",\\"element_id\\":\\"sfe1028\\"},\\"_yoast_wpseo_primary_product_cat\\":{\\"0\\":\\"9\\",\\"element_id\\":\\"tz88077\\"},\\"_yoast_wpseo_content_score\\":{\\"0\\":\\"30\\",\\"element_id\\":\\"v4xy200\\"},\\"_wc_rating_count\\":{\\"0\\":\\"a:0:{}\\",\\"element_id\\":\\"55n2030\\"},\\"_wc_average_rating\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"ui6z111\\"}}',
    '_wc_review_count' => '0',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'gear',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/free-weight.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 629,
  'post_date' => '2016-10-11 22:52:11',
  'post_date_gmt' => '2016-10-11 22:52:11',
  'post_content' => 'Platea augue aenean senectus sodales vestibulum id gravida bibendum pulvinar proin a lectus. Fermentum eros lectus blandit natoque. Ullamcorper, hac quis eget. Magnis felis potenti congue.',
  'post_title' => 'FitBit Charge 2',
  'post_excerpt' => '',
  'post_name' => 'fitbit-charge-2',
  'post_modified' => '2016-10-12 14:59:55',
  'post_modified_gmt' => '2016-10-12 14:59:55',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/?post_type=product&#038;p=629',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1476284262:115',
    '_edit_last' => '115',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    'post_image' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/fitbit-image.png',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '149',
    '_sale_price' => '139',
    '_price' => '139',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '2.6.4',
    '_yoast_wpseo_primary_product_cat' => '9',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"styling\\":[],\\"element_id\\":\\"9aj8835\\"}],\\"styling\\":[],\\"element_id\\":\\"tw8p308\\"}]',
    '_thumbnail_id' => '644',
    '_wc_review_count' => '0',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'gear',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/fitbit-image.png',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 625,
  'post_date' => '2016-10-11 22:46:11',
  'post_date_gmt' => '2016-10-11 22:46:11',
  'post_content' => 'Tempor vulputate inceptos mus pellentesque iaculis turpis purus. Feugiat leo interdum blandit venenatis eu. Eros torquent inceptos ullamcorper porta at, adipiscing dictumst. Lorem, congue maecenas dui consectetur blandit.',
  'post_title' => 'Womens Tank Top',
  'post_excerpt' => '',
  'post_name' => 'womens-tank-top',
  'post_modified' => '2016-10-12 21:37:25',
  'post_modified_gmt' => '2016-10-12 21:37:25',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/?post_type=product&#038;p=625',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1476294584:115',
    '_edit_last' => '115',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'yes',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '22.99',
    '_price' => '22.99',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '2.6.4',
    '_yoast_wpseo_primary_product_cat' => '8',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"element_id\\":\\"m6qf004\\"}],\\"element_id\\":\\"a0nj303\\"}]',
    '_thumbnail_id' => '639',
    '_wp_old_slug' => 'womens-ua-tank-top',
    '_wc_review_count' => '0',
    'post_image' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/womens-tank-with-text.jpg',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'tanks',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/womens-tank-with-text.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 624,
  'post_date' => '2016-10-11 22:44:55',
  'post_date_gmt' => '2016-10-11 22:44:55',
  'post_content' => 'Vel luctus cursus ultrices taciti ad feugiat egestas euismod quam, nibh facilisi donec. Tempus nulla ipsum ullamcorper. Phasellus litora posuere auctor facilisi condimentum fames id quam torquent suspendisse nisi. Tincidunt!',
  'post_title' => 'Womens Dumbbell Tank',
  'post_excerpt' => '',
  'post_name' => 'womens-dumbbell-tank',
  'post_modified' => '2016-10-12 15:03:27',
  'post_modified_gmt' => '2016-10-12 15:03:27',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/?post_type=product&#038;p=624',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1476284592:115',
    '_edit_last' => '115',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '29.99',
    '_price' => '29.99',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '2.6.4',
    '_yoast_wpseo_primary_product_cat' => '8',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"styling\\":[],\\"element_id\\":\\"rtca008\\"}],\\"styling\\":[],\\"element_id\\":\\"rqzu970\\"}]',
    '_wp_old_slug' => 'regular-tank-men',
    '_wc_review_count' => '0',
    '_thumbnail_id' => '647',
    'post_image' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/dumbbells-tank.jpg',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'tanks',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/dumbbells-tank.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 620,
  'post_date' => '2016-10-11 22:43:28',
  'post_date_gmt' => '2016-10-11 22:43:28',
  'post_content' => 'Nullam purus non fames placerat ipsum quam facilisis, vitae parturient nec platea velit! Tempor eleifend vel mattis lobortis donec lacinia penatibus sollicitudin dolor vel. Curae; nam posuere class dapibus ornare sociis orci volutpat augue risus? Ornare non nisi cum pellentesque montes.',
  'post_title' => 'Grey Tank',
  'post_excerpt' => '',
  'post_name' => 'grey-tank',
  'post_modified' => '2016-10-12 21:37:25',
  'post_modified_gmt' => '2016-10-12 21:37:25',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/?post_type=product&#038;p=620',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1476284096:115',
    '_edit_last' => '115',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'yes',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '39.99',
    '_price' => '39.99',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '2.6.4',
    '_yoast_wpseo_primary_product_cat' => '8',
    '_yoast_wpseo_content_score' => '30',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"element_id\\":\\"dncc300\\"}],\\"element_id\\":\\"c81f499\\"}]',
    '_wp_old_slug' => 'rock-ua-tank',
    '_thumbnail_id' => '641',
    'post_image' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-man-tank.jpg',
    '_wc_rating_count' => 
    array (
      3 => 1,
    ),
    '_wc_review_count' => '1',
    '_wc_average_rating' => '3.00',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'tanks',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/grey-man-tank.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 613,
  'post_date' => '2016-10-11 22:19:27',
  'post_date_gmt' => '2016-10-11 22:19:27',
  'post_content' => 'Aliquam elementum venenatis eros est varius. Scelerisque facilisi est non convallis laoreet sed quam. Velit neque nascetur dictum commodo vulputate aptent? Rhoncus risus id id sociis vel vestibulum mauris sapien lacus tellus pretium. Ridiculus faucibus phasellus dui ipsum rhoncus sapien.',
  'post_title' => 'Sweat Proof Hoodie',
  'post_excerpt' => '',
  'post_name' => 'sweat-proof-hoodie',
  'post_modified' => '2016-10-11 22:21:11',
  'post_modified_gmt' => '2016-10-11 22:21:11',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/?post_type=product&#038;p=613',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1476224737:115',
    '_edit_last' => '115',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'yes',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '219',
    '_sale_price' => '150',
    '_price' => '150',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '2.6.4',
    '_yoast_wpseo_primary_product_cat' => '7',
    '_yoast_wpseo_content_score' => '30',
    '_thumbnail_id' => '615',
    'post_image' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/black-sweet.jpg',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'jacket',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/black-sweet.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 610,
  'post_date' => '2016-10-11 21:41:57',
  'post_date_gmt' => '2016-10-11 21:41:57',
  'post_content' => 'Leo arcu eu massa imperdiet et fringilla lorem odio metus. Vulputate duis vitae consectetur quisque ac aenean hac in sollicitudin.',
  'post_title' => 'Feather Weight Track Sweater',
  'post_excerpt' => '',
  'post_name' => 'feather-weight-track-sweater',
  'post_modified' => '2016-10-11 21:41:57',
  'post_modified_gmt' => '2016-10-11 21:41:57',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/?post_type=product&#038;p=610',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1476222135:115',
    '_edit_last' => '115',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '611',
    'post_image' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/featherweight.jpg',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'no',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '150',
    '_price' => '150',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '2.6.4',
    '_yoast_wpseo_primary_product_cat' => '7',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_review_count' => '0',
    '_wc_average_rating' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1476222135:115\\",\\"element_id\\":\\"jp8z804\\"},\\"_edit_last\\":{\\"0\\":\\"115\\",\\"element_id\\":\\"vnis436\\"},\\"_visibility\\":{\\"0\\":\\"visible\\",\\"element_id\\":\\"kgrh400\\"},\\"_stock_status\\":{\\"0\\":\\"instock\\",\\"element_id\\":\\"4xta943\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"vp68006\\"},\\"_thumbnail_id\\":{\\"0\\":\\"611\\",\\"element_id\\":\\"dmpq404\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/featherweight.jpg\\",\\"element_id\\":\\"beh1020\\"},\\"total_sales\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"ty0q440\\"},\\"_downloadable\\":{\\"0\\":\\"no\\",\\"element_id\\":\\"tzr3466\\"},\\"_virtual\\":{\\"0\\":\\"no\\",\\"element_id\\":\\"6l66040\\"},\\"_purchase_note\\":{\\"0\\":\\"\\",\\"element_id\\":\\"si8m404\\"},\\"_featured\\":{\\"0\\":\\"no\\",\\"element_id\\":\\"e1cv409\\"},\\"_weight\\":{\\"0\\":\\"\\",\\"element_id\\":\\"ulqa605\\"},\\"_length\\":{\\"0\\":\\"\\",\\"element_id\\":\\"ipyb511\\"},\\"_width\\":{\\"0\\":\\"\\",\\"element_id\\":\\"jypf500\\"},\\"_height\\":{\\"0\\":\\"\\",\\"element_id\\":\\"q7e8404\\"},\\"_sku\\":{\\"0\\":\\"\\",\\"element_id\\":\\"sc0z046\\"},\\"_product_attributes\\":{\\"0\\":\\"a:0:{}\\",\\"element_id\\":\\"zofd465\\"},\\"_regular_price\\":{\\"0\\":\\"150\\",\\"element_id\\":\\"jjpt055\\"},\\"_sale_price\\":{\\"0\\":\\"\\",\\"element_id\\":\\"we68050\\"},\\"_sale_price_dates_from\\":{\\"0\\":\\"\\",\\"element_id\\":\\"e59e054\\"},\\"_sale_price_dates_to\\":{\\"0\\":\\"\\",\\"element_id\\":\\"5pso046\\"},\\"_price\\":{\\"0\\":\\"150\\",\\"element_id\\":\\"vtma641\\"},\\"_sold_individually\\":{\\"0\\":\\"\\",\\"element_id\\":\\"wo4e000\\"},\\"_manage_stock\\":{\\"0\\":\\"no\\",\\"element_id\\":\\"skr1636\\"},\\"_backorders\\":{\\"0\\":\\"no\\",\\"element_id\\":\\"fz22446\\"},\\"_stock\\":{\\"0\\":\\"\\",\\"element_id\\":\\"pe4v440\\"},\\"_upsell_ids\\":{\\"0\\":\\"a:0:{}\\",\\"element_id\\":\\"r3yj000\\"},\\"_crosssell_ids\\":{\\"0\\":\\"a:0:{}\\",\\"element_id\\":\\"a0bd840\\"},\\"_product_version\\":{\\"0\\":\\"2.6.4\\",\\"element_id\\":\\"4vgq466\\"},\\"_product_image_gallery\\":{\\"0\\":\\"\\",\\"element_id\\":\\"pbge040\\"},\\"_yoast_wpseo_primary_product_cat\\":{\\"0\\":\\"7\\",\\"element_id\\":\\"c50o416\\"},\\"_yoast_wpseo_content_score\\":{\\"0\\":\\"30\\",\\"element_id\\":\\"uq0f646\\"},\\"_wc_rating_count\\":{\\"0\\":\\"a:0:{}\\",\\"element_id\\":\\"pi3e464\\"},\\"_wc_review_count\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"9rkf000\\"},\\"_wc_average_rating\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"659b464\\"}}',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'jacket',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/featherweight.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 606,
  'post_date' => '2016-10-11 21:37:45',
  'post_date_gmt' => '2016-10-11 21:37:45',
  'post_content' => 'Per ultrices luctus curabitur urna, himenaeos metus? Litora feugiat scelerisque ultrices urna tempus enim. Donec ligula sit parturient pellentesque condimentum litora, nostra condimentum magna.',
  'post_title' => 'Climacool Jacket',
  'post_excerpt' => '',
  'post_name' => 'climacool-jacket',
  'post_modified' => '2016-10-11 21:39:55',
  'post_modified_gmt' => '2016-10-11 21:39:55',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/?post_type=product&#038;p=606',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1476221900:115',
    '_edit_last' => '115',
    '_visibility' => 'visible',
    '_stock_status' => 'instock',
    'builder_switch_frontend' => '0',
    '_thumbnail_id' => '607',
    'post_image' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/climacool.jpg',
    'total_sales' => '0',
    '_downloadable' => 'no',
    '_virtual' => 'no',
    '_featured' => 'yes',
    '_product_attributes' => 
    array (
    ),
    '_regular_price' => '89',
    '_sale_price' => '69',
    '_price' => '69',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_product_version' => '2.6.4',
    '_yoast_wpseo_primary_product_cat' => '7',
    '_yoast_wpseo_content_score' => '30',
    '_wc_rating_count' => 
    array (
      5 => '1',
    ),
    '_wc_review_count' => '1',
    '_wc_average_rating' => '5.00',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1476221900:115\\",\\"element_id\\":\\"wbm5919\\"},\\"_edit_last\\":{\\"0\\":\\"115\\",\\"element_id\\":\\"r5w8600\\"},\\"_visibility\\":{\\"0\\":\\"visible\\",\\"element_id\\":\\"koce900\\"},\\"_stock_status\\":{\\"0\\":\\"instock\\",\\"element_id\\":\\"yaxy100\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"d90h968\\"},\\"_thumbnail_id\\":{\\"0\\":\\"607\\",\\"element_id\\":\\"4jko090\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-fitness\\\\/files\\\\/2016\\\\/10\\\\/climacool.jpg\\",\\"element_id\\":\\"8peo030\\"},\\"total_sales\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"09ts890\\"},\\"_downloadable\\":{\\"0\\":\\"no\\",\\"element_id\\":\\"4ghu069\\"},\\"_virtual\\":{\\"0\\":\\"no\\",\\"element_id\\":\\"q1hd001\\"},\\"_purchase_note\\":{\\"0\\":\\"\\",\\"element_id\\":\\"y8zq080\\"},\\"_featured\\":{\\"0\\":\\"yes\\",\\"element_id\\":\\"1acx892\\"},\\"_weight\\":{\\"0\\":\\"\\",\\"element_id\\":\\"8o3q662\\"},\\"_length\\":{\\"0\\":\\"\\",\\"element_id\\":\\"ak8j100\\"},\\"_width\\":{\\"0\\":\\"\\",\\"element_id\\":\\"nq26009\\"},\\"_height\\":{\\"0\\":\\"\\",\\"element_id\\":\\"jhno049\\"},\\"_sku\\":{\\"0\\":\\"\\",\\"element_id\\":\\"0eia290\\"},\\"_product_attributes\\":{\\"0\\":\\"a:0:{}\\",\\"element_id\\":\\"73pc200\\"},\\"_regular_price\\":{\\"0\\":\\"89\\",\\"element_id\\":\\"a7o8007\\"},\\"_sale_price\\":{\\"0\\":\\"69\\",\\"element_id\\":\\"lj4z909\\"},\\"_sale_price_dates_from\\":{\\"0\\":\\"\\",\\"element_id\\":\\"zo00091\\"},\\"_sale_price_dates_to\\":{\\"0\\":\\"\\",\\"element_id\\":\\"op7y663\\"},\\"_price\\":{\\"0\\":\\"69\\",\\"element_id\\":\\"akbh316\\"},\\"_sold_individually\\":{\\"0\\":\\"\\",\\"element_id\\":\\"c4gi060\\"},\\"_manage_stock\\":{\\"0\\":\\"no\\",\\"element_id\\":\\"8d3z169\\"},\\"_backorders\\":{\\"0\\":\\"no\\",\\"element_id\\":\\"iy6e003\\"},\\"_stock\\":{\\"0\\":\\"\\",\\"element_id\\":\\"g6s2106\\"},\\"_upsell_ids\\":{\\"0\\":\\"a:0:{}\\",\\"element_id\\":\\"q81y770\\"},\\"_crosssell_ids\\":{\\"0\\":\\"a:0:{}\\",\\"element_id\\":\\"jrel980\\"},\\"_product_version\\":{\\"0\\":\\"2.6.4\\",\\"element_id\\":\\"faby990\\"},\\"_product_image_gallery\\":{\\"0\\":\\"\\",\\"element_id\\":\\"y9p7699\\"},\\"_yoast_wpseo_primary_product_cat\\":{\\"0\\":\\"7\\",\\"element_id\\":\\"s2ri309\\"},\\"_yoast_wpseo_content_score\\":{\\"0\\":\\"30\\",\\"element_id\\":\\"rfj8003\\"},\\"_wc_rating_count\\":{\\"0\\":\\"a:1:{i:5;s:1:\\\\\\\\\\\\\\"1\\\\\\\\\\\\\\";}\\",\\"element_id\\":\\"zjx7160\\"},\\"_wc_review_count\\":{\\"0\\":\\"1\\",\\"element_id\\":\\"qn44591\\"},\\"_wc_average_rating\\":{\\"0\\":\\"5.00\\",\\"element_id\\":\\"qbzj193\\"}}',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'jacket',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-fitness/files/2016/10/climacool.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 69,
  'post_date' => '2016-09-20 04:40:32',
  'post_date_gmt' => '2016-09-20 04:40:32',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '69',
  'post_modified' => '2016-10-12 17:46:10',
  'post_modified_gmt' => '2016-10-12 17:46:10',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/?p=69',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '4',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 68,
  'post_date' => '2016-09-20 04:40:32',
  'post_date_gmt' => '2016-09-20 04:40:32',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '68',
  'post_modified' => '2016-10-12 17:46:10',
  'post_modified_gmt' => '2016-10-12 17:46:10',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/?p=68',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '62',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 67,
  'post_date' => '2016-09-20 04:40:32',
  'post_date_gmt' => '2016-09-20 04:40:32',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '67',
  'post_modified' => '2016-10-12 17:46:10',
  'post_modified_gmt' => '2016-10-12 17:46:10',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/?p=67',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '64',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 75,
  'post_date' => '2016-09-20 04:42:51',
  'post_date_gmt' => '2016-09-20 04:42:51',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '75',
  'post_modified' => '2016-10-12 17:46:10',
  'post_modified_gmt' => '2016-10-12 17:46:10',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/?p=75',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '70',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 653,
  'post_date' => '2016-10-12 17:46:10',
  'post_date_gmt' => '2016-10-12 17:46:10',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '653',
  'post_modified' => '2016-10-12 17:46:10',
  'post_modified_gmt' => '2016-10-12 17:46:10',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/?p=653',
  'menu_order' => 5,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '649',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 74,
  'post_date' => '2016-09-20 04:42:51',
  'post_date_gmt' => '2016-09-20 04:42:51',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '74',
  'post_modified' => '2016-10-12 17:46:10',
  'post_modified_gmt' => '2016-10-12 17:46:10',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-fitness/?p=74',
  'menu_order' => 6,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '72',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );



function themify_import_get_term_id_from_slug( $slug ) {
	$menu = get_term_by( "slug", $slug, "nav_menu" );
	return is_wp_error( $menu ) ? 0 : (int) $menu->term_id;
}

	$widgets = get_option( "widget_woocommerce_product_categories" );
$widgets[1002] = array (
  'title' => 'Product Categories',
  'orderby' => 'name',
  'dropdown' => 0,
  'count' => 0,
  'hierarchical' => 1,
  'show_children_only' => 0,
  'hide_empty' => 0,
);
update_option( "widget_woocommerce_product_categories", $widgets );

$widgets = get_option( "widget_woocommerce_products" );
$widgets[1003] = array (
  'title' => 'Products',
  'number' => 5,
  'show' => '',
  'orderby' => 'date',
  'order' => 'desc',
  'hide_free' => 0,
  'show_hidden' => 0,
);
update_option( "widget_woocommerce_products", $widgets );

$widgets = get_option( "widget_themify-social-links" );
$widgets[1004] = array (
  'title' => '',
  'show_link_name' => NULL,
  'open_new_window' => NULL,
  'icon_size' => 'icon-large',
  'orientation' => 'horizontal',
);
update_option( "widget_themify-social-links", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1005] = array (
  'title' => 'YORKDALE',
  'text' => 'No: 58 A, East Madison St<br>
Baltimore, MD, USA<br>
+1 200 258 2145',
  'filter' => false,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1006] = array (
  'title' => 'MAIN STATION',
  'text' => 'No: 58 A, East Madison St<br>
Baltimore, MD, USA<br>
+1 200 258 2145',
  'filter' => false,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1007] = array (
  'title' => 'YONGE/KING',
  'text' => 'No: 58 A, East Madison St<br>
Baltimore, MD, USA<br>
+1 200 258 2145',
  'filter' => false,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1008] = array (
  'title' => 'UNION',
  'text' => 'No: 58 A, East Madison St<br>
Baltimore, MD, USA<br>
+1 200 258 2145',
  'filter' => false,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1009] = array (
  'title' => 'DOWNTOWN',
  'text' => 'No: 58 A, East Madison St<br>
Baltimore, MD, USA<br>
+1 200 258 2145',
  'filter' => false,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1010] = array (
  'title' => 'QUEEN',
  'text' => 'No: 58 A, East Madison St<br>
Baltimore, MD, USA<br>
+1 200 258 2145',
  'filter' => false,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1011] = array (
  'title' => 'UPTOWN',
  'text' => 'No: 58 A, East Madison St<br>
Baltimore, MD, USA<br>
+1 200 258 2145',
  'filter' => false,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1012] = array (
  'title' => 'FINCH',
  'text' => 'No: 58 A, East Madison St<br>
Baltimore, MD, USA<br>
+1 200 258 2145',
  'filter' => false,
);
update_option( "widget_text", $widgets );



$sidebars_widgets = array (
  'sidebar-main' => 
  array (
    0 => 'woocommerce_product_categories-1002',
    1 => 'woocommerce_products-1003',
  ),
  'footer-social-widget' => 
  array (
    0 => 'themify-social-links-1004',
  ),
  'footer-widget-1' => 
  array (
    0 => 'text-1005',
    1 => 'text-1006',
  ),
  'footer-widget-2' => 
  array (
    0 => 'text-1007',
    1 => 'text-1008',
  ),
  'footer-widget-3' => 
  array (
    0 => 'text-1009',
    1 => 'text-1010',
  ),
  'footer-widget-4' => 
  array (
    0 => 'text-1011',
    1 => 'text-1012',
  ),
); 
update_option( "sidebars_widgets", $sidebars_widgets );

$menu_locations = array();
$menu = get_terms( "nav_menu", array( "slug" => "main-navigation" ) );
if( is_array( $menu ) && ! empty( $menu ) ) $menu_locations["main-nav"] = $menu[0]->term_id;
$menu = get_terms( "nav_menu", array( "slug" => "main-navigation" ) );
if( is_array( $menu ) && ! empty( $menu ) ) $menu_locations["footer-nav"] = $menu[0]->term_id;
set_theme_mod( "nav_menu_locations", $menu_locations );


$homepage = get_posts( array( 'name' => 'home', 'post_type' => 'page' ) );
			if( is_array( $homepage ) && ! empty( $homepage ) ) {
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $homepage[0]->ID );
			}
			
	ob_start(); ?>a:118:{s:21:"setting-webfonts_list";s:11:"recommended";s:22:"setting-default_layout";s:8:"sidebar1";s:27:"setting-default_post_layout";s:9:"list-post";s:19:"setting-post_filter";s:3:"yes";s:23:"setting-disable_masonry";s:3:"yes";s:19:"setting-post_gutter";s:6:"gutter";s:30:"setting-default_layout_display";s:7:"content";s:25:"setting-default_more_text";s:4:"More";s:21:"setting-index_orderby";s:4:"date";s:19:"setting-index_order";s:4:"DESC";s:30:"setting-default_media_position";s:5:"above";s:31:"setting-image_post_feature_size";s:5:"blank";s:32:"setting-default_page_post_layout";s:8:"sidebar1";s:37:"setting-default_page_post_layout_type";s:7:"classic";s:42:"setting-default_page_single_media_position";s:5:"above";s:38:"setting-image_post_single_feature_size";s:5:"blank";s:36:"setting-search-result_layout_display";s:7:"content";s:36:"setting-search-result_media_position";s:5:"above";s:27:"setting-default_page_layout";s:8:"sidebar1";s:40:"setting-custom_post_tglobal_style_single";s:8:"sidebar1";s:38:"setting-default_portfolio_index_layout";s:12:"sidebar-none";s:43:"setting-default_portfolio_index_post_layout";s:5:"grid3";s:29:"setting-portfolio_post_filter";s:3:"yes";s:33:"setting-portfolio_disable_masonry";s:3:"yes";s:24:"setting-portfolio_gutter";s:6:"gutter";s:39:"setting-default_portfolio_index_display";s:4:"none";s:50:"setting-default_portfolio_index_post_meta_category";s:3:"yes";s:49:"setting-default_portfolio_index_unlink_post_image";s:3:"yes";s:39:"setting-default_portfolio_single_layout";s:12:"sidebar-none";s:54:"setting-default_portfolio_single_portfolio_layout_type";s:9:"fullwidth";s:50:"setting-default_portfolio_single_unlink_post_image";s:3:"yes";s:22:"themify_portfolio_slug";s:7:"project";s:31:"themify_portfolio_category_slug";s:18:"portfolio-category";s:19:"setting-shop_layout";s:8:"sidebar1";s:27:"setting-shop_archive_layout";s:12:"sidebar-none";s:23:"setting-products_layout";s:5:"grid4";s:31:"setting-product_disable_masonry";s:2:"no";s:29:"setting-single_product_layout";s:8:"sidebar1";s:30:"setting-related_products_limit";s:1:"3";s:32:"setting-product_description_type";s:4:"long";s:53:"setting-customizer_responsive_design_tablet_landscape";s:4:"1024";s:43:"setting-customizer_responsive_design_tablet";s:3:"768";s:43:"setting-customizer_responsive_design_mobile";s:3:"480";s:33:"setting-mobile_menu_trigger_point";s:4:"1200";s:24:"setting-gallery_lightbox";s:8:"lightbox";s:11:"setting-css";s:3:"top";s:26:"setting-page_builder_cache";s:2:"on";s:27:"setting-page_builder_expiry";s:1:"2";s:21:"setting-header_design";s:17:"header-horizontal";s:28:"setting-exclude_site_tagline";s:2:"on";s:27:"setting-exclude_search_form";s:2:"on";s:19:"setting_search_form";s:11:"live_search";s:19:"setting-exclude_rss";s:2:"on";s:22:"setting-header_widgets";s:4:"none";s:21:"setting-footer_design";s:12:"footer-block";s:32:"setting-exclude_footer_site_logo";s:2:"on";s:27:"setting-exclude_footer_back";s:2:"on";s:22:"setting-footer_widgets";s:17:"footerwidget-4col";s:30:"setting-footer_widget_position";s:3:"top";s:23:"setting-mega_menu_posts";s:1:"5";s:29:"setting-mega_menu_image_width";s:3:"180";s:30:"setting-mega_menu_image_height";s:3:"120";s:27:"setting-imagefilter_applyto";s:12:"featuredonly";s:29:"setting-color_animation_speed";s:1:"5";s:29:"setting-relationship_taxonomy";s:8:"category";s:37:"setting-relationship_taxonomy_entries";s:1:"3";s:45:"setting-relationship_taxonomy_display_content";s:4:"none";s:30:"setting-single_slider_autoplay";s:3:"off";s:27:"setting-single_slider_speed";s:6:"normal";s:28:"setting-single_slider_effect";s:5:"slide";s:28:"setting-single_slider_height";s:4:"auto";s:18:"setting-more_posts";s:8:"infinite";s:19:"setting-entries_nav";s:8:"numbered";s:25:"setting-img_php_base_size";s:5:"large";s:27:"setting-global_feature_size";s:5:"blank";s:22:"setting-link_icon_type";s:9:"font-icon";s:32:"setting-link_type_themify-link-0";s:10:"image-icon";s:33:"setting-link_title_themify-link-0";s:7:"Twitter";s:31:"setting-link_img_themify-link-0";s:107:"https://themify.me/demo/themes/ultra-fitness/wp-content/themes/themify-ultra/themify/img/social/twitter.png";s:32:"setting-link_type_themify-link-1";s:10:"image-icon";s:33:"setting-link_title_themify-link-1";s:8:"Facebook";s:31:"setting-link_img_themify-link-1";s:108:"https://themify.me/demo/themes/ultra-fitness/wp-content/themes/themify-ultra/themify/img/social/facebook.png";s:32:"setting-link_type_themify-link-2";s:10:"image-icon";s:33:"setting-link_title_themify-link-2";s:7:"Google+";s:31:"setting-link_img_themify-link-2";s:111:"https://themify.me/demo/themes/ultra-fitness/wp-content/themes/themify-ultra/themify/img/social/google-plus.png";s:32:"setting-link_type_themify-link-3";s:10:"image-icon";s:33:"setting-link_title_themify-link-3";s:7:"YouTube";s:31:"setting-link_img_themify-link-3";s:107:"https://themify.me/demo/themes/ultra-fitness/wp-content/themes/themify-ultra/themify/img/social/youtube.png";s:32:"setting-link_type_themify-link-4";s:10:"image-icon";s:33:"setting-link_title_themify-link-4";s:9:"Pinterest";s:31:"setting-link_img_themify-link-4";s:109:"https://themify.me/demo/themes/ultra-fitness/wp-content/themes/themify-ultra/themify/img/social/pinterest.png";s:32:"setting-link_type_themify-link-5";s:9:"font-icon";s:33:"setting-link_title_themify-link-5";s:7:"Twitter";s:32:"setting-link_link_themify-link-5";s:27:"https://twitter.com/themify";s:33:"setting-link_ficon_themify-link-5";s:10:"fa-twitter";s:32:"setting-link_type_themify-link-6";s:9:"font-icon";s:33:"setting-link_title_themify-link-6";s:8:"Facebook";s:32:"setting-link_link_themify-link-6";s:28:"https://facebook.com/themify";s:33:"setting-link_ficon_themify-link-6";s:11:"fa-facebook";s:32:"setting-link_type_themify-link-7";s:9:"font-icon";s:33:"setting-link_title_themify-link-7";s:7:"Google+";s:33:"setting-link_ficon_themify-link-7";s:14:"fa-google-plus";s:32:"setting-link_type_themify-link-8";s:9:"font-icon";s:33:"setting-link_title_themify-link-8";s:7:"YouTube";s:32:"setting-link_link_themify-link-8";s:32:"https://youtube.com/user/themify";s:33:"setting-link_ficon_themify-link-8";s:10:"fa-youtube";s:32:"setting-link_type_themify-link-9";s:9:"font-icon";s:33:"setting-link_title_themify-link-9";s:9:"Pinterest";s:33:"setting-link_ficon_themify-link-9";s:12:"fa-pinterest";s:22:"setting-link_field_ids";s:341:"{"themify-link-0":"themify-link-0","themify-link-1":"themify-link-1","themify-link-2":"themify-link-2","themify-link-3":"themify-link-3","themify-link-4":"themify-link-4","themify-link-5":"themify-link-5","themify-link-6":"themify-link-6","themify-link-7":"themify-link-7","themify-link-8":"themify-link-8","themify-link-9":"themify-link-9"}";s:23:"setting-link_field_hash";s:2:"10";s:30:"setting-page_builder_is_active";s:6:"enable";s:41:"setting-page_builder_animation_appearance";s:4:"none";s:42:"setting-page_builder_animation_parallax_bg";s:4:"none";s:46:"setting-page_builder_animation_parallax_scroll";s:6:"mobile";s:44:"setting-page_builder_animation_sticky_scroll";s:4:"none";s:4:"skin";s:7:"fitness";s:13:"import_images";s:2:"on";}<?php $themify_data = unserialize( ob_get_clean() );

	// Fix how "skin" option used to save
	if( isset( $themify_data['skin'] ) ) {
		if ( filter_var( $themify_data['skin'], FILTER_VALIDATE_URL ) ) {
			$parsed_skin = parse_url( $value, PHP_URL_PATH );
			$themify_data['skin'] = basename( dirname( $parsed_skin ) );
		}
	}

	themify_set_data( $themify_data );
	
}
themify_do_demo_import();