<?php

defined( 'ABSPATH' ) or die;

$GLOBALS['processed_terms'] = array();
$GLOBALS['processed_posts'] = array();

require_once ABSPATH . 'wp-admin/includes/post.php';
require_once ABSPATH . 'wp-admin/includes/taxonomy.php';
require_once ABSPATH . 'wp-admin/includes/image.php';

/**
 * Add an Import Action, this data is stored for processing after import is done.
 *
 * Each action is sent as an Ajax request and is handled by themify-ajax.php file
 */ 
function themify_add_import_action( $action = '', $data = array() ) {
	global $import_actions;

	if ( ! isset( $import_actions[ $action ] ) ) {
		$import_actions[ $action ] = array();
	}

	$import_actions[ $action ][] = $data;
}

function themify_import_post( $post ) {
	global $processed_posts, $processed_terms;

	if ( ! post_type_exists( $post['post_type'] ) ) {
		return;
	}

	/* Menu items don't have reliable post_title, skip the post_exists check */
	if( $post['post_type'] !== 'nav_menu_item' ) {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
		if ( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
			$processed_posts[ intval( $post['ID'] ) ] = intval( $post_exists );
			return;
		}
	}

	if( $post['post_type'] == 'nav_menu_item' ) {
		if( ! isset( $post['tax_input']['nav_menu'] ) || ! term_exists( $post['tax_input']['nav_menu'], 'nav_menu' ) ) {
			return;
		}
		$_menu_item_type = $post['meta_input']['_menu_item_type'];
		$_menu_item_object_id = $post['meta_input']['_menu_item_object_id'];

		if ( 'taxonomy' == $_menu_item_type && isset( $processed_terms[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_terms[ intval( $_menu_item_object_id ) ];
		} else if ( 'post_type' == $_menu_item_type && isset( $processed_posts[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_posts[ intval( $_menu_item_object_id ) ];
		} else if ( 'custom' != $_menu_item_type ) {
			// associated object is missing or not imported yet, we'll retry later
			// $missing_menu_items[] = $item;
			return;
		}
	}

	$post_parent = ( $post['post_type'] == 'nav_menu_item' ) ? $post['meta_input']['_menu_item_menu_item_parent'] : (int) $post['post_parent'];
	$post['post_parent'] = 0;
	if ( $post_parent ) {
		// if we already know the parent, map it to the new local ID
		if ( isset( $processed_posts[ $post_parent ] ) ) {
			if( $post['post_type'] == 'nav_menu_item' ) {
				$post['meta_input']['_menu_item_menu_item_parent'] = $processed_posts[ $post_parent ];
			} else {
				$post['post_parent'] = $processed_posts[ $post_parent ];
			}
		}
	}

	/**
	 * for hierarchical taxonomies, IDs must be used so wp_set_post_terms can function properly
	 * convert term slugs to IDs for hierarchical taxonomies
	 */
	if( ! empty( $post['tax_input'] ) ) {
		foreach( $post['tax_input'] as $tax => $terms ) {
			if( is_taxonomy_hierarchical( $tax ) ) {
				$terms = explode( ', ', $terms );
				$post['tax_input'][ $tax ] = array_map( 'themify_get_term_id_by_slug', $terms, array_fill( 0, count( $terms ), $tax ) );
			}
		}
	}

	$post['post_author'] = (int) get_current_user_id();
	$post['post_status'] = 'publish';

	$old_id = $post['ID'];

	unset( $post['ID'] );
	$post_id = wp_insert_post( $post, true );
	if( is_wp_error( $post_id ) ) {
		return false;
	} else {
		$processed_posts[ $old_id ] = $post_id;

		return $post_id;
	}
}

function themify_get_placeholder_image() {
	static $placeholder_image = null;

	if( $placeholder_image == null ) {
		if ( ! function_exists( 'WP_Filesystem' ) ) {
			require_once ABSPATH . 'wp-admin/includes/file.php';
		}
		WP_Filesystem();
		global $wp_filesystem;
		$upload = wp_upload_bits( $post['post_name'] . '.jpg', null, $wp_filesystem->get_contents( THEMIFY_DIR . '/img/image-placeholder.jpg' ) );

		if ( $info = wp_check_filetype( $upload['file'] ) )
			$post['post_mime_type'] = $info['type'];
		else
			return new WP_Error( 'attachment_processing_error', __( 'Invalid file type', 'themify' ) );

		$post['guid'] = $upload['url'];
		$post_id = wp_insert_attachment( $post, $upload['file'] );
		wp_update_attachment_metadata( $post_id, wp_generate_attachment_metadata( $post_id, $upload['file'] ) );

		$placeholder_image = $post_id;
	}

	return $placeholder_image;
}

function themify_import_term( $term ) {
	global $processed_terms;

	if( $term_id = term_exists( $term['slug'], $term['taxonomy'] ) ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];
		if ( isset( $term['term_id'] ) )
			$processed_terms[ intval( $term['term_id'] ) ] = (int) $term_id;
		return (int) $term_id;
	}

	if ( empty( $term['parent'] ) ) {
		$parent = 0;
	} else {
		$parent = term_exists( $processed_terms[ intval( $term['parent'] ) ], $term['taxonomy'] );
		if ( is_array( $parent ) ) $parent = $parent['term_id'];
	}

	$id = wp_insert_term( $term['name'], $term['taxonomy'], array(
		'parent' => $parent,
		'slug' => $term['slug'],
		'description' => $term['description'],
	) );
	if ( ! is_wp_error( $id ) ) {
		if ( isset( $term['term_id'] ) ) {
			// success!
			$processed_terms[ intval($term['term_id']) ] = $id['term_id'];
			if ( isset( $term['thumbnail'] ) ) {
				themify_add_import_action( 'term_thumb', array(
					'id' => $id['term_id'],
					'thumb' => $term['thumbnail'],
				) );
			}
			return $term['term_id'];
		}
	}

	return false;
}

function themify_get_term_id_by_slug( $slug, $tax ) {
	$term = get_term_by( 'slug', $slug, $tax );
	if( $term ) {
		return $term->term_id;
	}

	return false;
}

function themify_undo_import_term( $term ) {
	$term_id = term_exists( $term['slug'], $term['taxonomy'] );
	if ( $term_id ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];

		if ( $term_thumbnail = get_term_meta( $term['term_id'], 'thumbnail_id', true ) ) {
			wp_delete_attachment( $term_thumbnail, true );
		}

		if ( isset( $term_id ) ) {
			wp_delete_term( $term_id, $term['taxonomy'] );
		}
	}
}

/**
 * Determine if a post exists based on title, content, and date
 *
 * @global wpdb $wpdb WordPress database abstraction object.
 *
 * @param array $args array of database parameters to check
 * @return int Post ID if post exists, 0 otherwise.
 */
function themify_post_exists( $args = array() ) {
	global $wpdb;

	$query = "SELECT ID FROM $wpdb->posts WHERE 1=1";
	$db_args = array();

	foreach ( $args as $key => $value ) {
		$value = wp_unslash( sanitize_post_field( $key, $value, 0, 'db' ) );
		if( ! empty( $value ) ) {
			$query .= ' AND ' . $key . ' = %s';
			$db_args[] = $value;
		}
	}

	if ( !empty ( $args ) )
		return (int) $wpdb->get_var( $wpdb->prepare($query, $args) );

	return 0;
}

function themify_undo_import_post( $post ) {
	if( $post['post_type'] == 'nav_menu_item' ) {
		$post_exists = themify_post_exists( array(
			'post_name' => $post['post_name'],
			'post_modified' => $post['post_date'],
			'post_type' => 'nav_menu_item',
		) );
	} else {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
	}
	if( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
		/**
		 * check if the post has been modified, if so leave it be
		 *
		 * NOTE: posts are imported using wp_insert_post() which modifies post_modified field
		 * to be the same as post_date, hence to check if the post has been modified,
		 * the post_modified field is compared against post_date in the original post.
		 */
		if( $post['post_date'] == get_post_field( 'post_modified', $post_exists ) ) {
			// find and remove all post attachments
			$attachments = get_posts( array(
				'post_type' => 'attachment',
				'posts_per_page' => -1,
				'post_parent' => $post_exists,
			) );
			if ( $attachments ) {
				foreach ( $attachments as $attachment ) {
					wp_delete_attachment( $attachment->ID, true );
				}
			}
			wp_delete_post( $post_exists, true ); // true: bypass trash
		}
	}
}

function themify_process_post_import( $post ) {
	if( ERASEDEMO ) {
		themify_undo_import_post( $post );
	} else {
		if ( $id = themify_import_post( $post ) ) {
			if ( defined( 'IMPORT_IMAGES' ) && ! IMPORT_IMAGES ) {
				/* if importing images is disabled and post is supposed to have a thumbnail, create a placeholder image instead */
				if ( isset( $post['thumb'] ) ) { // the post is supposed to have featured image
					$placeholder = themify_get_placeholder_image();
					if( ! is_wp_error( $placeholder ) ) {
						set_post_thumbnail( $id, $placeholder );
					}
				}
			} else {
				if ( isset( $post["thumb"] ) ) {
					themify_add_import_action( 'post_thumb', array(
						'id' => $id,
						'thumb' => $post["thumb"],
					) );
				}
				if ( isset( $post["gallery_shortcode"] ) ) {
					themify_add_import_action( 'gallery_field', array(
						'id' => $id,
						'fields' => $post["gallery_shortcode"],
					) );
				}
				if ( isset( $post["_product_image_gallery"] ) ) {
					themify_add_import_action( 'product_gallery', array(
						'id' => $id,
						'images' => $post["_product_image_gallery"],
					) );
				}
			}
		}
	}
}
$thumbs = array();
function themify_do_demo_import() {
global $import_actions;

	if ( isset( $GLOBALS["ThemifyBuilder_Data_Manager"] ) ) {
		remove_action( "save_post", array( $GLOBALS["ThemifyBuilder_Data_Manager"], "save_builder_text_only"), 10, 3 );
	}
$term = array (
  'term_id' => 33,
  'name' => 'Blog',
  'slug' => 'blog',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 8,
  'name' => 'Travel',
  'slug' => 'travel',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 33,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 9,
  'name' => 'Photography',
  'slug' => 'photography',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 33,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 10,
  'name' => 'View',
  'slug' => 'view',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 33,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 11,
  'name' => 'Work',
  'slug' => 'work',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 33,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 7,
  'name' => 'View',
  'slug' => 'view',
  'term_group' => 0,
  'taxonomy' => 'post_tag',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 18,
  'name' => 'Shoes',
  'slug' => 'shoes',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
  'thumbnail' => false,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 19,
  'name' => 'Top',
  'slug' => 'top',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
  'thumbnail' => false,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 20,
  'name' => 'Bag',
  'slug' => 'bag',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
  'thumbnail' => 'https://themify.me/demo/themes/ultra/files/2015/04/ce04c26184c31cadb12e284326a40492-1.jpg',
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 29,
  'name' => 'Accessories',
  'slug' => 'accessories',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
  'thumbnail' => false,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 50,
  'name' => 'Pants',
  'slug' => 'pants',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
  'thumbnail' => 'https://themify.me/demo/themes/ultra/files/2015/04/133289399.jpg',
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 12,
  'name' => 'Cameras',
  'slug' => 'cameras',
  'term_group' => 0,
  'taxonomy' => 'portfolio-category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 13,
  'name' => 'Products',
  'slug' => 'products',
  'term_group' => 0,
  'taxonomy' => 'portfolio-category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 16,
  'name' => 'Photos',
  'slug' => 'photos',
  'term_group' => 0,
  'taxonomy' => 'portfolio-category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 17,
  'name' => 'Fashion',
  'slug' => 'fashion',
  'term_group' => 0,
  'taxonomy' => 'portfolio-category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 23,
  'name' => 'Personal Page Menu',
  'slug' => 'personal-page-menu',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 24,
  'name' => 'Event Page Menu',
  'slug' => 'event-page-menu',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 25,
  'name' => 'Wedding Page Menu',
  'slug' => 'wedding-page-menu',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 27,
  'name' => 'Footer Menu 2',
  'slug' => 'footer-menu-2',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 46,
  'name' => 'Main Nav',
  'slug' => 'main-nav',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 47,
  'name' => 'Right Pane',
  'slug' => 'right-pane',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 48,
  'name' => 'Header Overlay Menu',
  'slug' => 'header-overlay-menu',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$post = array (
  'ID' => 5088,
  'post_date' => '2016-06-07 22:48:24',
  'post_date_gmt' => '2016-06-07 22:48:24',
  'post_content' => '<p>Mauris sit natoque dolor condimentum himenaeos curabitur imperdiet fringilla, mollis platea consequat consectetur. Risus sapien hac tristique. Praesent magnis cursus proin etiam condimentum hac. Viverra praesent, ad proin lorem est class blandit id maecenas felis. Metus dictum interdum parturient viverra magnis curae; id potenti tellus. Tempor massa ullamcorper est turpis molestie penatibus dictumst dui nam. Bibendum suspendisse mauris condimentum auctor mollis integer sagittis nascetur ante rutrum molestie. Himenaeos sociosqu aliquam porta magnis sodales nulla in etiam duis faucibus.<!--more--></p>
<h3>Sub Heading</h3>
<p>Mauris sit natoque dolor condimentum himenaeos curabitur imperdiet fringilla, mollis platea consequat consectetur. Risus sapien hac tristique. Praesent magnis cursus proin etiam condimentum hac. Viverra praesent, ad proin lorem est class blandit id maecenas felis. Metus dictum interdum parturient viverra magnis curae; id potenti tellus. Tempor massa ullamcorper est turpis molestie penatibus dictumst dui nam.</p>

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Gallery Layout',
  'post_excerpt' => '',
  'post_name' => 'gallery-layout',
  'post_modified' => '2019-03-07 22:18:18',
  'post_modified_gmt' => '2019-03-07 22:18:18',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra/?p=5088',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'sidebar-none',
    'post_layout' => 'gallery',
    'post_layout_gallery' => '[gallery link="file" size="large" columns="5" ids="5089,4997,4760,4216,4212,4099,4149,3915,3907,3841"]',
    'mobile_menu_styles' => 'default',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
    'category' => 'blog',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra/files/2018/06/demoimage66.jpg',
  'gallery_shortcode' => 
  array (
    'post_layout_gallery' => 
    array (
      0 => 'https://themify.me/demo/themes/ultra/files/2016/06/animals-731213_1920.jpg',
      1 => 'https://themify.me/demo/themes/ultra/files/2016/04/96437909.jpg',
      2 => 'https://themify.me/demo/themes/ultra/files/2016/01/ultra-masonry-10-1.jpg',
      3 => 'https://themify.me/demo/themes/ultra/files/2015/06/140641234.jpg',
      4 => 'https://themify.me/demo/themes/ultra/files/2015/06/model-2.jpg',
      5 => 'https://themify.me/demo/themes/ultra/files/2015/05/RONyPwknRQOO3ag4xf3R_Kinsey.jpg',
      6 => 'https://themify.me/demo/themes/ultra/files/2015/04/43e390401.jpg',
      7 => 'https://themify.me/demo/themes/ultra/files/2015/05/88274311.jpg',
    ),
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 5080,
  'post_date' => '2016-06-06 22:39:22',
  'post_date_gmt' => '2016-06-06 22:39:22',
  'post_content' => '<p>Aenean dis mus arcu vel posuere porta tristique. Magnis maecenas cum maecenas suspendisse consectetur sed, scelerisque augue placerat ullamcorper. Augue torquent et dictumst lacinia at scelerisque turpis class pellentesque sodales cras lectus! Neque eu eget vitae suspendisse integer dapibus fermentum laoreet? Ullamcorper tristique facilisis ullamcorper phasellus nam semper scelerisque! Viverra ornare dignissim nam, molestie tortor scelerisque! Vehicula quam tempor imperdiet quisque. Quisque suscipit!</p>

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Slider Layout',
  'post_excerpt' => '',
  'post_name' => 'slider-layout',
  'post_modified' => '2019-03-08 07:36:59',
  'post_modified_gmt' => '2019-03-08 07:36:59',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra/?p=5080',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'sidebar-none',
    'post_layout' => 'slider',
    'post_layout_slider' => '[gallery size="full" link="file" ids="3308,3290,3287,3273"]',
    'image_width' => '1400',
    'image_height' => '700',
    'header_design' => 'header-horizontal',
    'mobile_menu_styles' => 'default',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
    'category' => 'photography',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra/files/2016/01/ultra-masonry-7-1.jpg',
  'gallery_shortcode' => 
  array (
    'post_layout_slider' => 
    array (
      0 => 'https://themify.me/demo/themes/ultra/files/2015/04/photo-1416339426675-1f96fd81b653.jpg',
      1 => 'https://themify.me/demo/themes/ultra/files/2015/04/photo-1416339134316-0e91dc9ded92.jpg',
      2 => 'https://themify.me/demo/themes/ultra/files/2015/04/r2Xmw0IESdeCCu4eBb6d_33F3F57EBEB3600F3B377F32425EE595_B1280_1280_1200_800.jpg',
    ),
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 5075,
  'post_date' => '2016-06-06 22:33:37',
  'post_date_gmt' => '2016-06-06 22:33:37',
  'post_content' => 'Officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat',
  'post_title' => 'Split Layout',
  'post_excerpt' => '',
  'post_name' => 'split-layout',
  'post_modified' => '2017-08-21 01:08:17',
  'post_modified_gmt' => '2017-08-21 01:08:17',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra/?p=5075',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'sidebar-none',
    'post_layout' => 'split',
    'image_width' => '800',
    'image_height' => '1000',
    'header_design' => 'header-top-bar',
    'footer_design' => 'none',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
    'category' => 'travel',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra/files/2015/05/99811742.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 5101,
  'post_date' => '2016-04-26 22:56:01',
  'post_date_gmt' => '2016-04-26 22:56:01',
  'post_content' => 'Lectus facilisi pulvinar natoque non molestie varius tincidunt class leo at varius non. Aliquam libero vulputate dui est varius tempor lectus nascetur tellus sit. Mus nascetur, elit malesuada posuere eleifend magnis mus donec congue fusce! Litora dictum purus auctor hac dapibus himenaeos. Sagittis nascetur per sociis per erat nascetur gravida. Ligula id, dictumst viverra imperdiet. Similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio.',
  'post_title' => 'Fullwidth Layout',
  'post_excerpt' => '',
  'post_name' => 'fullwidth-layout',
  'post_modified' => '2017-08-21 01:08:19',
  'post_modified_gmt' => '2017-08-21 01:08:19',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra/?p=5101',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'sidebar-none',
    'post_layout' => 'fullwidth',
    'header_design' => 'header-top-bar',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
    'category' => 'view',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra/files/2015/10/188185553.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3266,
  'post_date' => '2015-04-09 20:26:22',
  'post_date_gmt' => '2015-04-09 20:26:22',
  'post_content' => '<p>Aliquam arcu ante, sagittis eu rutrum a, efficitur eget nibh. In venenatis metus est, a sagittis turpis cursus quis. Fusce odio neque, placerat ut porttitor eget, congue vestibulum purus. In pretium posuere elit sed lobortis. Praesent finibus ultrices augue, eget blandit mauris. Duis pulvinar, quam ut tristique euismod, velit turpis dignissim massa, et venenatis leo justo id urna. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus.</p>

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Left Sidebar',
  'post_excerpt' => '',
  'post_name' => 'left-sidebar',
  'post_modified' => '2019-03-07 14:33:58',
  'post_modified_gmt' => '2019-03-07 14:33:58',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra/?p=3266',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'sidebar1 sidebar-left',
    'mobile_menu_styles' => 'default',
    'header_wrap' => 'video',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
    'category' => 'work',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra/files/2015/06/model-3.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3259,
  'post_date' => '2015-04-09 20:22:34',
  'post_date_gmt' => '2015-04-09 20:22:34',
  'post_content' => 'Fusce odio neque, placerat ut porttitor eget, congue vestibulum purus. In pretium posuere elit sed lobortis. Praesent finibus ultrices augue, eget blandit mauris. Duis pulvinar, quam ut tristique euismod, velit turpis dignissim massa, et venenatis leo justo id urna. Et harum quidem rerum facilis est et expedita distinctio.Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandaem.',
  'post_title' => 'Right Sidebar',
  'post_excerpt' => 'Fusce odio neque, placerat ut porttitor eget, congue vestibulum purus. In pretium posuere elit sed lobortis. Praesent finibus ultrices augue, eget blandit mauris.',
  'post_name' => 'right-sidebar',
  'post_modified' => '2017-08-21 01:08:27',
  'post_modified_gmt' => '2017-08-21 01:08:27',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra/?p=3259',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'sidebar1',
    'header_wrap' => 'video',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
    'category' => 'photography, travel',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra/files/2015/04/43e390401.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3269,
  'post_date' => '2015-04-09 20:13:21',
  'post_date_gmt' => '2015-04-09 20:13:21',
  'post_content' => '<p>Aliquam arcu ante, sagittis eu rutrum a, efficitur eget nibh. In venenatis metus est, a sagittis turpis cursus quis. Fusce odio neque, placerat ut porttitor eget, congue vestibulum purus. In pretium posuere elit sed lobortis. <a href="https://themify.me">Praesent</a> finibus ultrices augue, eget blandit mauris. Duis pulvinar, quam ut tristique euismod, velit turpis dignissim massa, et venenatis leo justo id urna. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem</p>

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Classic Fullwidth',
  'post_excerpt' => '',
  'post_name' => 'classic-fullwidth',
  'post_modified' => '2019-03-08 07:38:01',
  'post_modified_gmt' => '2019-03-08 07:38:01',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra/?p=3269',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'sidebar-none',
    'post_layout' => 'classic',
    'mobile_menu_styles' => 'default',
    'header_wrap' => 'video',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
    'category' => 'photography',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra/files/2015/04/2e9b0cb2.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3253,
  'post_date' => '2015-04-09 20:12:41',
  'post_date_gmt' => '2015-04-09 20:12:41',
  'post_content' => 'Donec eu mi vitae ex aliquam porttitor. Donec a mi in mauris finibus venenatis vitae at augue. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Maecenas non pulvinar purus. Vestibulum posuere faucibus libero, eu dapibus magna mollis quis. Etiam non ante urna. Curabitur tincidunt ultrices sagittis. Donec quis felis leo. Cras ullamcorper, est eget convallis dapibus, diam lacus viverra magna, volutpat maximus lorem urna ac purus. Nam felis metus, eleifend ut fringilla a, sagittis nec mauris. In id congue justo.',
  'post_title' => 'Fullwidth With Sidebar',
  'post_excerpt' => '',
  'post_name' => 'fullwidth-with-sidebar',
  'post_modified' => '2018-11-14 23:53:06',
  'post_modified_gmt' => '2018-11-14 23:53:06',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra/?p=3253',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'sidebar1',
    'post_layout' => 'fullwidth',
    'mobile_menu_styles' => 'default',
    'header_wrap' => 'video',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"5301efb\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"c09833b\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
    'category' => 'photography, work',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra/files/2015/05/88274311.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3250,
  'post_date' => '2015-04-09 20:11:44',
  'post_date_gmt' => '2015-04-09 20:11:44',
  'post_content' => 'Aliquam arcu ante, sagittis eu rutrum a, efficitur eget nibh. In venenatis metus est, a sagittis turpis cursus quis. Fusce odio neque, placerat ut porttitor eget, congue vestibulum purus. In pretium posuere elit sed lobortis. Praesent finibus ultrices augue, eget blandit mauris. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Duis pulvinar, quam ut tristique euismod, velit turpis dignissim massa, et venenatis leo justo id urna.

&nbsp;',
  'post_title' => 'Left & Right Sidebars',
  'post_excerpt' => '',
  'post_name' => 'left-right-sidebars',
  'post_modified' => '2017-08-21 01:08:32',
  'post_modified_gmt' => '2017-08-21 01:08:32',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra/?p=3250',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'sidebar2',
    'header_wrap' => 'video',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
    'category' => 'work',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra/files/2015/04/photo-1415226581130-91cb7f52f078.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3247,
  'post_date' => '2015-04-09 20:10:27',
  'post_date_gmt' => '2015-04-09 20:10:27',
  'post_content' => '<div id="lipsum">

Pellentesque orci lorem, accumsan sed aliquam sed, pretium sed nunc. Maecenas consequat, justo sed rutrum sollicitudin, velit ante ultricies ante, et euismod arcu purus et leo. Morbi pretium non ex ut volutpat. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Lorem ipsum dolor sit amet, consectetur adipiscing elit. In consequat rutrum nisl quis condimentum. Nulla tortor ex, sodales id mollis ac, feugiat sit amet leo. Suspendisse porttitor laoreet neque.

</div>
&nbsp;',
  'post_title' => '2 Right Sidebars',
  'post_excerpt' => '',
  'post_name' => '2-right-sidebars',
  'post_modified' => '2017-08-21 01:08:33',
  'post_modified_gmt' => '2017-08-21 01:08:33',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra/?p=3247',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'sidebar2 content-left',
    'header_wrap' => 'video',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
    'category' => 'photography, view',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra/files/2015/04/photo-1415033523948-6c31d010530d.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3244,
  'post_date' => '2015-04-09 20:08:17',
  'post_date_gmt' => '2015-04-09 20:08:17',
  'post_content' => '<div id="lipsum">

Nulla tortor ex, sodales id mollis ac, feugiat sit amet leo. Suspendisse porttitor laoreet neque, et bibendum lacus euismod id. In tincidunt, tortor vel fringilla elementum, magna purus lacinia ante, id egestas nisi justo vel eros. Pellentesque orci lorem, accumsan sed aliquam sed, pretium sed nunc. Maecenas consequat, justo sed rutrum sollicitudin, velit ante ultricies ante, et euismod arcu purus et leo. Morbi pretium non ex ut volutpat.

</div>
&nbsp;',
  'post_title' => '2 Left Sidebars',
  'post_excerpt' => 'Nulla tortor ex, sodales id mollis ac, feugiat sit amet leo. Suspendisse porttitor laoreet neque, et bibendum lacus euismod id.',
  'post_name' => '2-left-sidebars',
  'post_modified' => '2017-08-21 01:09:14',
  'post_modified_gmt' => '2017-08-21 01:09:14',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra/?p=3244',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'sidebar2 content-right',
    'body_background_repeat' => 'fullcover',
    'header_wrap' => 'video',
    'background_repeat' => 'fullcover',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
    'category' => 'travel',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra/files/2015/04/M1IHnsfYRz2ThTgzl6qz_canyousea.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3241,
  'post_date' => '2015-04-09 20:05:08',
  'post_date_gmt' => '2015-04-09 20:05:08',
  'post_content' => '<div id="lipsum">

In consequat rutrum nisl quis condimentum. Sed eget tincidunt nulla, posuere elementum ligula. Nulla facilisi. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatemPraesent luctus, neque dictum feugiat maximus, sem enim maximus ipsum, sed ullamcorper est urna suscipit massa. Cras commodo eros nec eleifend vehicula. Praesent auctor augue in massa porta gravida. Nullam et ex eget diam mollis hendrerit id dignissim sem. Suspendisse viverra nibh a fringilla viverra.

</div>
&nbsp;',
  'post_title' => 'New York Shot',
  'post_excerpt' => 'In consequat rutrum nisl quis condimentum. Sed eget tincidunt nulla, posuere elementum ligula. Nulla facilisi. Praesent luctus, neque dictum feugiat maximus.',
  'post_name' => 'new-york-shot',
  'post_modified' => '2017-08-21 01:09:18',
  'post_modified_gmt' => '2017-08-21 01:09:18',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra/?p=3241',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'header_wrap' => 'video',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
    'category' => 'photography, travel',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra/files/2015/04/iqlYdAAYQiaOCoKnT6jE_kabia.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3238,
  'post_date' => '2015-04-09 20:03:51',
  'post_date_gmt' => '2015-04-09 20:03:51',
  'post_content' => '<div id="lipsum">

Nulla tortor ex, sodales id mollis ac, feugiat sit amet leo. Suspendisse porttitor laoreet neque, et bibendum lacus euismod id. In tincidunt, tortor vel fringilla elementum, magna purus lacinia ante, id egestas nisi justo vel eros. Pellentesque orci lorem, accumsan sed aliquam sed, pretium sed nunc. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Maecenas consequat, justo sed rutrum sollicitudin, velit ante ultricies ante, et euismod arcu purus et leo. Morbi pretium non ex ut volutpat. Lorem ipsum dolor sit amet, consectetur adipiscing elit. In consequat rutrum nisl quis condimentum. Sed eget tincidunt nulla, posuere elementum ligula. Nulla facilisi. Praesent luctus, neque dictum feugiat maximus, sem enim maximus ipsum, sed ullamcorper est urna suscipit massa. Cras commodo eros nec eleifend vehicula. Praesent auctor augue in massa porta gravida. Nullam et ex eget diam mollis hendrerit id dignissim sem. Suspendisse viverra nibh a fringilla viverra.

</div>
&nbsp;',
  'post_title' => 'Night Life',
  'post_excerpt' => 'Nulla tortor ex, sodales id mollis ac, feugiat sit amet leo. Suspendisse porttitor laoreet neque, et bibendum lacus euismod id.',
  'post_name' => 'night-life',
  'post_modified' => '2017-08-21 01:09:19',
  'post_modified_gmt' => '2017-08-21 01:09:19',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra/?p=3238',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'header_wrap' => 'video',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
    'category' => 'photography, travel',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra/files/2015/04/hGibbjg0Rb2fUIoMtU5l__DSC8099.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3234,
  'post_date' => '2015-04-09 20:02:06',
  'post_date_gmt' => '2015-04-09 20:02:06',
  'post_content' => 'Donec vitae volutpat erat. Donec non molestie lacus. Integer euismod leo euismod, fermentum tellus sed, consequat leo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem Cras lobortis nisl non dapibus tempor. Donec a finibus tellus. Vivamus laoreet lacinia imperdiet. Fusce tincidunt metus ac sapien feugiat, sit amet laoreet lorem aliquam. Integer pharetra egestas mi vel aliquam.',
  'post_title' => 'Underwater Scuba Trip',
  'post_excerpt' => 'Donec vitae volutpat erat. Donec non molestie lacus. Integer euismod leo euismod, fermentum tellus sed, consequat leo. Cras lobortis.',
  'post_name' => 'underwater-scuba-trip',
  'post_modified' => '2017-08-21 01:09:20',
  'post_modified_gmt' => '2017-08-21 01:09:20',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra/?p=3234',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'header_wrap' => 'video',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
    'category' => 'travel',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra/files/2015/04/f9c22c58.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3228,
  'post_date' => '2015-04-09 20:00:21',
  'post_date_gmt' => '2015-04-09 20:00:21',
  'post_content' => 'Mauris pulvinar, massa eget semper imperdiet, sapien nisl vulputate mi, ut commodo mi erat et sapien. Interdum et malesuada fames ac ante ipsum primis in faucibus. Curabitur pellentesque augue nec nisl ultricies aliquet. Integer ipsum ante, interdum ac varius quis, ullamcorper vel ante.Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Donec eu mi vitae ex aliquam porttitor. Donec a mi in mauris finibus venenatis vitae at augue. Maecenas non pulvinar purus. Vestibulum posuere faucibus libero, eu dapibus magna mollis quis. Etiam non ante urna. Curabitur tincidunt ultrices sagittis. Donec quis felis leo. Cras ullamcorper, est eget convallis dapibus, diam lacus viverra magna, volutpat maximus lorem urna ac purus. Nam felis metus, eleifend ut fringilla a, sagittis nec mauris. In id congue justo.',
  'post_title' => 'Work/Life Balance',
  'post_excerpt' => '',
  'post_name' => 'worklife-balance',
  'post_modified' => '2017-08-21 01:09:22',
  'post_modified_gmt' => '2017-08-21 01:09:22',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra/?p=3228',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'header_wrap' => 'video',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
    'category' => 'work',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra/files/2015/04/desktop.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3229,
  'post_date' => '2015-04-09 19:56:54',
  'post_date_gmt' => '2015-04-09 19:56:54',
  'post_content' => 'Mauris pulvinar, massa eget semper imperdiet, sapien nisl vulputate mi, ut commodo mi erat et sapien. Interdum et malesuada fames ac ante ipsum primis in faucibus.Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Curabitur pellentesque augue nec nisl ultricies aliquet. Integer ipsum ante, interdum ac varius quis, ullamcorper vel ante. Donec eu mi vitae ex aliquam porttitor. Donec a mi in mauris finibus venenatis vitae at augue. Maecenas non pulvinar purus. Vestibulum posuere faucibus libero, eu dapibus magna mollis quis. Etiam non ante urna. Curabitur tincidunt ultrices sagittis. Donec quis felis leo. Cras ullamcorper, est eget convallis dapibus, diam lacus viverra magna, volutpat maximus lorem urna ac purus. Nam felis metus, eleifend ut fringilla a, sagittis nec mauris. In id congue justo.',
  'post_title' => 'Travel Shots',
  'post_excerpt' => 'Mauris pulvinar, massa eget semper imperdiet, sapien nisl vulputate mi, ut commodo mi erat et sapien. Interdum et malesuada fames ac ante ipsum primis in faucibus. ',
  'post_name' => 'travel-shots',
  'post_modified' => '2017-08-21 01:11:51',
  'post_modified_gmt' => '2017-08-21 01:11:51',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra/?p=3229',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'header_wrap' => 'video',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
    'category' => 'photography, travel, view',
    'post_tag' => 'view',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra/files/2015/04/bsrOzgDkQhGRKOVC7Era_9X6A3584.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3216,
  'post_date' => '2015-04-09 19:48:45',
  'post_date_gmt' => '2015-04-09 19:48:45',
  'post_content' => 'Nulla tortor ex, sodales id mollis ac, feugiat sit amet leo. Suspendisse porttitor laoreet neque, et bibendum lacus euismod id. In tincidunt, tortor vel fringilla elementum, magna purus lacinia ante, id egestas nisi justo vel eros. Pellentesque orci lorem, accumsan sed aliquam sed, pretium sed nunc. Maecenas consequat, justo sed rutrum sollicitudin, velit ante ultricies ante, et euismod arcu purus et leo. Morbi pretium non ex ut volutpat. Lorem ipsum dolor sit amet, consectetur adipiscing elit. In consequat rutrum nisl quis condimentum. Sed eget tincidunt nulla, posuere elementum ligula. Nulla facilisi. Praesent luctus, neque dictum feugiat maximus, sem enim maximus ipsum, sed ullamcorper est urna suscipit massa. Cras commodo eros nec eleifend vehicula. Praesent auctor augue in massa porta gravida. Nullam et ex eget diam mollis hendrerit id dignissim sem. Suspendisse viverra nibh a fringilla viverra.',
  'post_title' => 'Coffee Shop Office',
  'post_excerpt' => '',
  'post_name' => 'coffee-shop-office',
  'post_modified' => '2017-08-21 01:09:46',
  'post_modified_gmt' => '2017-08-21 01:09:46',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra/?p=3216',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'header_wrap' => 'video',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
    'category' => 'work',
    'post_tag' => 'view',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra/files/2015/04/apple-gear-looking-pretty.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3212,
  'post_date' => '2015-04-09 17:50:20',
  'post_date_gmt' => '2015-04-09 17:50:20',
  'post_content' => 'Mauris pulvinar, massa eget semper imperdiet, sapien nisl vulputate mi, ut commodo mi erat et sapien. Interdum et malesuada fames ac ante ipsum primis in faucibus. Curabitur pellentesque augue nec nisl ultricies aliquet. Integer ipsum ante, interdum ac varius quis, ullamcorper vel ante. Donec eu mi vitae ex aliquam porttitor. Donec a mi in mauris finibus venenatis vitae at augue. Maecenas non pulvinar purus. Vestibulum posuere faucibus libero, eu dapibus magna mollis quis. Etiam non ante urna. Curabitur tincidunt ultrices sagittis. Donec quis felis leo. Cras ullamcorper, est eget convallis dapibus, diam lacus viverra magna, volutpat maximus lorem urna ac purus. Nam felis metus, eleifend ut fringilla a, sagittis nec mauris. In id congue justo.

&nbsp;',
  'post_title' => 'In the Wild',
  'post_excerpt' => '',
  'post_name' => 'in-the-wild',
  'post_modified' => '2017-08-21 01:09:47',
  'post_modified_gmt' => '2017-08-21 01:09:47',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra/?p=3212',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'header_wrap' => 'video',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
    'category' => 'photography, view',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra/files/2015/04/5f468e98.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3208,
  'post_date' => '2015-04-09 17:48:26',
  'post_date_gmt' => '2015-04-09 17:48:26',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Mauris pulvinar, massa eget semper imperdiet, sapien nisl vulputate mi, ut commodo mi erat et sapien. Interdum et malesuada fames ac ante ipsum primis in faucibus. Curabitur pellentesque augue nec nisl ultricies aliquet. Integer ipsum ante, interdum ac varius quis, ullamcorper vel ante. Donec eu mi vitae ex aliquam porttitor. Donec a mi in mauris finibus venenatis vitae at augue. Maecenas non pulvinar purus. Vestibulum posuere faucibus libero, eu dapibus magna mollis quis. Etiam non ante urna. Curabitur tincidunt ultrices sagittis. Donec quis felis leo. Cras ullamcorper, est eget convallis dapibus, diam lacus viverra magna, volutpat maximus lorem urna ac purus. Nam felis metus, eleifend ut fringilla a, sagittis nec mauris. In id congue justo.

&nbsp;',
  'post_title' => 'City Sunrise',
  'post_excerpt' => '',
  'post_name' => 'city-sunrise',
  'post_modified' => '2017-08-21 01:09:47',
  'post_modified_gmt' => '2017-08-21 01:09:47',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra/?p=3208',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'header_wrap' => 'video',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
    'category' => 'view',
    'post_tag' => 'view',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra/files/2015/04/2EsHHwmRswlLYnaG07Ew_paris-motionbug.com_.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3205,
  'post_date' => '2015-04-09 17:47:44',
  'post_date_gmt' => '2015-04-09 17:47:44',
  'post_content' => 'Massa eget semper imperdiet, sapien nisl vulputate mi, ut commodo mi erat et sapien. Interdum et malesuada fames ac ante ipsum primis in faucibus. Curabitur pellentesque augue nec nisl ultricies aliquet. Integer ipsum ante, interdum ac varius quis, ullamcorper vel ante. Donec eu mi vitae ex aliquam porttitor. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Donec a mi in mauris finibus venenatis vitae at augue. Maecenas non pulvinar purus. Vestibulum posuere faucibus libero, eu dapibus magna mollis quis. Etiam non ante urna. Curabitur tincidunt ultrices sagittis. Donec quis felis leo. Cras ullamcorper, est eget convallis dapibus, diam lacus viverra magna, volutpat maximus lorem urna ac purus. Nam felis metus, eleifend ut fringilla a, sagittis nec mauris. In id congue justo.

&nbsp;',
  'post_title' => 'My Photography Post',
  'post_excerpt' => '',
  'post_name' => 'my-photography-post',
  'post_modified' => '2017-08-21 01:09:48',
  'post_modified_gmt' => '2017-08-21 01:09:48',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra/?p=3205',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'header_wrap' => 'video',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
    'category' => 'photography',
    'post_tag' => 'view',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra/files/2015/04/2e9b0cb2.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6167,
  'post_date' => '2017-01-13 04:45:46',
  'post_date_gmt' => '2017-01-13 04:45:46',
  'post_content' => '<!--themify_builder_static--><h2>Smart Layout Options</h2>
<p>Ultra gives you full control from header to footer, either site-wide or on a per-page basis. This means that you can make your entire site share the same look and feel or create a unique look for every page.</p>
<h4>15 Header/Page Styles</h4><p>Select a header/page design from 15 styles (the no header option is perfect for making landing pages where you don\'t want to have header navigation). And yes, there is a sticky header option and this design list is growing!</p>
<a href="https://themify.me/demo/themes/ultra/all-layouts/" > <img src="https://themify.me/demo/themes/ultra/files/2017/01/header-layout-1024x555-1158x628.png" width="1158" height="628" alt="header layout" srcset="https://themify.me/demo/themes/ultra/files/2017/01/header-layout.png 1158w, https://themify.me/demo/themes/ultra/files/2017/01/header-layout-150x81.png 150w, https://themify.me/demo/themes/ultra/files/2017/01/header-layout-300x163.png 300w, https://themify.me/demo/themes/ultra/files/2017/01/header-layout-1024x555.png 1024w, https://themify.me/demo/themes/ultra/files/2017/01/header-layout-370x201.png 370w, https://themify.me/demo/themes/ultra/files/2017/01/header-layout-600x325.png 600w" sizes="(max-width: 1158px) 100vw, 1158px" /> </a>
<h4>6 Header Background Options</h4><p>Header background allows you to: upload a background image, pick a solid color, insert a slider, upload a video, set animating colors, or have it transparent if you want.</p>
<a href="https://themify.me/demo/themes/ultra/all-layouts/" > <img src="https://themify.me/demo/themes/ultra/files/2017/01/header-background-1024x154-1158x174.png" width="1158" height="174" alt="header background" srcset="https://themify.me/demo/themes/ultra/files/2017/01/header-background.png 1158w, https://themify.me/demo/themes/ultra/files/2017/01/header-background-150x23.png 150w, https://themify.me/demo/themes/ultra/files/2017/01/header-background-300x45.png 300w, https://themify.me/demo/themes/ultra/files/2017/01/header-background-1024x154.png 1024w, https://themify.me/demo/themes/ultra/files/2017/01/header-background-370x56.png 370w, https://themify.me/demo/themes/ultra/files/2017/01/header-background-600x90.png 600w" sizes="(max-width: 1158px) 100vw, 1158px" /> </a>
<h4>6 Footer Layouts</h4><p>6 footer layout choices with options to toggle visibility of footer logo, menu, widget, and credit text.</p>
<a href="https://themify.me/demo/themes/ultra/all-layouts/" > <img src="https://themify.me/demo/themes/ultra/files/2017/01/footer-layout-1024x155-1157x175.png" width="1157" height="175" alt="footer layout" srcset="https://themify.me/demo/themes/ultra/files/2017/01/footer-layout.png 1157w, https://themify.me/demo/themes/ultra/files/2017/01/footer-layout-150x23.png 150w, https://themify.me/demo/themes/ultra/files/2017/01/footer-layout-300x45.png 300w, https://themify.me/demo/themes/ultra/files/2017/01/footer-layout-1024x155.png 1024w, https://themify.me/demo/themes/ultra/files/2017/01/footer-layout-370x56.png 370w, https://themify.me/demo/themes/ultra/files/2017/01/footer-layout-600x91.png 600w" sizes="(max-width: 1157px) 100vw, 1157px" /> </a>
<h4>5 Single Post Layouts</h4><p>In term of single post layout, there is a default layout plus 4 unique layouts.</p>
<a href="https://themify.me/demo/themes/ultra/all-layouts/" > <img src="https://themify.me/demo/themes/ultra/files/2017/01/single-post-layout-759x175.png" width="759" height="175" alt="single post layout" srcset="https://themify.me/demo/themes/ultra/files/2017/01/single-post-layout.png 759w, https://themify.me/demo/themes/ultra/files/2017/01/single-post-layout-150x35.png 150w, https://themify.me/demo/themes/ultra/files/2017/01/single-post-layout-300x69.png 300w, https://themify.me/demo/themes/ultra/files/2017/01/single-post-layout-370x85.png 370w, https://themify.me/demo/themes/ultra/files/2017/01/single-post-layout-600x138.png 600w" sizes="(max-width: 759px) 100vw, 759px" /> </a>
<h4>6 Archive Layouts</h4><p>For the archive layouts, we have 6 different styles that you can choose from: slider, fullwidth, masonry, grids, polaroid, and overlay. You may also toggle the visibility of the post elements such as post title, featured image, meta, content, etc.</p>
<a href="https://themify.me/demo/themes/ultra/all-layouts/" > <img src="https://themify.me/demo/themes/ultra/files/2017/01/archive-layouts-1024x154-1157x174.png" width="1157" height="174" alt="alt text" srcset="https://themify.me/demo/themes/ultra/files/2017/01/archive-layouts.png 1157w, https://themify.me/demo/themes/ultra/files/2017/01/archive-layouts-150x23.png 150w, https://themify.me/demo/themes/ultra/files/2017/01/archive-layouts-300x45.png 300w, https://themify.me/demo/themes/ultra/files/2017/01/archive-layouts-1024x154.png 1024w, https://themify.me/demo/themes/ultra/files/2017/01/archive-layouts-370x56.png 370w, https://themify.me/demo/themes/ultra/files/2017/01/archive-layouts-600x90.png 600w" sizes="(max-width: 1157px) 100vw, 1157px" /> </a>
<h4>Section Scrolling (*New)</h4> <p>Inspired by our <a href="https://themify.me/themes/fullpane">Fullpane</a> theme, full section scrolling feature allows viewers to scroll through your page design one row at a time like a presentation slideshow. Full section scrolling now comes with Horizontal and Vertical scrolling.</p>
<a href="https://themify.me/demo/themes/ultra/theme-appearance/section-scrolling/" > <img src="https://themify.me/demo/themes/ultra/files/2019/03/slide-out-scrolling-160x135.png" width="160" height="135" title="Horizontal " alt="Horizontal " srcset="https://themify.me/demo/themes/ultra/files/2019/03/slide-out-scrolling.png 160w, https://themify.me/demo/themes/ultra/files/2019/03/slide-out-scrolling-150x127.png 150w" sizes="(max-width: 160px) 100vw, 160px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra/theme-appearance/section-scrolling/" > Horizontal & Vertical Scrolling </a> </h3>
<a href="https://themify.me/demo/themes/ultra/theme-appearance/vertical-section-scrolling/" > <img src="https://themify.me/demo/themes/ultra/files/2018/04/minbar-header-160x135.png" width="160" height="135" title="Vertical Section Scrolling" alt="Vertical Section Scrolling" srcset="https://themify.me/demo/themes/ultra/files/2018/04/minbar-header-160x135.png 160w, https://themify.me/demo/themes/ultra/files/2018/04/minbar-header-150x127.png 150w, https://themify.me/demo/themes/ultra/files/2018/04/minbar-header.png 192w" sizes="(max-width: 160px) 100vw, 160px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra/theme-appearance/vertical-section-scrolling/" > Vertical Section Scrolling </a> </h3>
<a href="https://themify.me/demo/themes/ultra/theme-appearance/horizontal-section-scrolling/" > <img src="https://themify.me/demo/themes/ultra/files/2018/04/top-bar-header-160x135.png" width="160" height="135" title="Horizontal Section Scrolling" alt="Horizontal Section Scrolling" srcset="https://themify.me/demo/themes/ultra/files/2018/04/top-bar-header-160x135.png 160w, https://themify.me/demo/themes/ultra/files/2018/04/top-bar-header-150x127.png 150w, https://themify.me/demo/themes/ultra/files/2018/04/top-bar-header.png 192w" sizes="(max-width: 160px) 100vw, 160px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra/theme-appearance/horizontal-section-scrolling/" > Horizontal Section Scrolling </a> </h3><!--/themify_builder_static-->',
  'post_title' => 'All Layouts',
  'post_excerpt' => '',
  'post_name' => 'all-layouts',
  'post_modified' => '2019-11-06 21:57:37',
  'post_modified_gmt' => '2019-11-06 21:57:37',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=6167',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'hide_page_title' => 'yes',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"fb99ee9\\",\\"cols\\":[{\\"element_id\\":\\"f6bd5c4\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"a63b9ed\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>Smart Layout Options<\\\\/h2>\\",\\"animation_effect\\":\\"fadeInDown\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"g71s777\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1.2\\",\\"font_size_unit\\":\\"em\\",\\"line_height\\":\\"1.5\\",\\"line_height_unit\\":\\"em\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"margin_bottom\\":\\"10\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Ultra gives you full control from header to footer, either site-wide or on a per-page basis. This means that you can make your entire site share the same look and feel or create a unique look for every page.<\\\\/p>\\",\\"animation_effect\\":\\"fadeInDown\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"309d32f\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"margin_top_unit\\":\\"%\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h4>15 Header\\\\/Page Styles<\\\\/h4><p>Select a header\\\\/page design from 15 styles (the no header option is perfect for making landing pages where you don\\\'t want to have header navigation). And yes, there is a sticky header option and this design list is growing!<\\\\/p>\\",\\"animation_effect\\":\\"fadeInUp\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"e4d34fc\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"font_color_title\\":\\"000000\\",\\"font_size_title\\":\\"16\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra\\\\/files\\\\/2017\\\\/01\\\\/header-layout-1024x555.png\\",\\"width_image\\":\\"1158\\",\\"height_image\\":\\"628\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra\\\\/all-layouts\\\\/\\",\\"param_image\\":\\"regular\\",\\"animation_effect\\":\\"fadeInLeft\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"6a66b78\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>6 Header Background Options<\\\\/h4><p>Header background allows you to: upload a background image, pick a solid color, insert a slider, upload a video, set animating colors, or have it transparent if you want.<\\\\/p>\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"7\\",\\"margin_top_unit\\":\\"%\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeInDown\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"8188aa7\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra\\\\/files\\\\/2017\\\\/01\\\\/header-background-1024x154.png\\",\\"width_image\\":\\"1158\\",\\"height_image\\":\\"174\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra\\\\/all-layouts\\\\/\\",\\"param_image\\":\\"regular\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_color_title\\":\\"000000_1.00\\",\\"font_size_title\\":\\"16\\",\\"animation_effect\\":\\"fadeInRight\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"828f8d3\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>6 Footer Layouts<\\\\/h4><p>6 footer layout choices with options to toggle visibility of footer logo, menu, widget, and credit text.<\\\\/p>\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"7\\",\\"margin_top_unit\\":\\"%\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeInRight\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"0324a7f\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra\\\\/files\\\\/2017\\\\/01\\\\/footer-layout-1024x155.png\\",\\"width_image\\":\\"1157\\",\\"height_image\\":\\"175\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra\\\\/all-layouts\\\\/\\",\\"param_image\\":\\"regular\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_color_title\\":\\"000000_1.00\\",\\"font_size_title\\":\\"16\\",\\"animation_effect\\":\\"fadeInLeft\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ca6f516\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>5 Single Post Layouts<\\\\/h4><p>In term of single post layout, there is a default layout plus 4 unique layouts.<\\\\/p>\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"7\\",\\"margin_top_unit\\":\\"%\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeInDown\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"86f7977\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra\\\\/files\\\\/2017\\\\/01\\\\/single-post-layout.png\\",\\"width_image\\":\\"759\\",\\"height_image\\":\\"175\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra\\\\/all-layouts\\\\/\\",\\"param_image\\":\\"regular\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_color_title\\":\\"000000_1.00\\",\\"font_size_title\\":\\"16\\",\\"animation_effect\\":\\"fadeInUp\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\"}}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"b0864a1\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>6 Archive Layouts<\\\\/h4><p>For the archive layouts, we have 6 different styles that you can choose from: slider, fullwidth, masonry, grids, polaroid, and overlay. You may also toggle the visibility of the post elements such as post title, featured image, meta, content, etc.<\\\\/p>\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"7\\",\\"margin_top_unit\\":\\"%\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeInDown\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"e2a5f04\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra\\\\/files\\\\/2017\\\\/01\\\\/archive-layouts-1024x154.png\\",\\"width_image\\":\\"1157\\",\\"height_image\\":\\"174\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra\\\\/all-layouts\\\\/\\",\\"param_image\\":\\"regular\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_color_title\\":\\"000000_1.00\\",\\"font_size_title\\":\\"16\\",\\"animation_effect\\":\\"fadeInLeft\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"9a81f6a\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"7\\",\\"margin_top_unit\\":\\"%\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h4>Section Scrolling (*New)<\\\\/h4>\\\\n<p>Inspired by our <a href=\\\\\\"https:\\\\/\\\\/themify.me\\\\/themes\\\\/fullpane\\\\\\">Fullpane<\\\\/a> theme, full section scrolling feature allows viewers to scroll through your page design one row at a time like a presentation slideshow. Full section scrolling now comes with Horizontal and Vertical scrolling.<\\\\/p>\\",\\"animation_effect\\":\\"fadeInDown\\"}},{\\"element_id\\":\\"533c852\\",\\"cols\\":[{\\"element_id\\":\\"a2223fa\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"6a755c4\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_title\\":\\"000000\\",\\"font_size_title\\":\\"16\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra\\\\/files\\\\/2019\\\\/03\\\\/slide-out-scrolling.png\\",\\"width_image\\":\\"160\\",\\"height_image\\":\\"135\\",\\"title_image\\":\\"Horizontal & Vertical Scrolling\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra\\\\/theme-appearance\\\\/section-scrolling\\\\/\\",\\"param_image\\":\\"regular\\",\\"animation_effect\\":\\"fadeInUp\\"}}]},{\\"element_id\\":\\"5485e14\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"1e103d1\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_title\\":\\"000000\\",\\"font_size_title\\":\\"16\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra\\\\/files\\\\/2018\\\\/04\\\\/minbar-header.png\\",\\"width_image\\":\\"160\\",\\"height_image\\":\\"135\\",\\"title_image\\":\\"Vertical Section Scrolling\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra\\\\/theme-appearance\\\\/vertical-section-scrolling\\\\/\\",\\"param_image\\":\\"regular\\",\\"animation_effect\\":\\"fadeInUp\\"}}]},{\\"element_id\\":\\"8dcf89e\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"6917ce5\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_title\\":\\"000000\\",\\"font_size_title\\":\\"16\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra\\\\/files\\\\/2018\\\\/04\\\\/top-bar-header.png\\",\\"width_image\\":\\"160\\",\\"height_image\\":\\"135\\",\\"title_image\\":\\"Horizontal Section Scrolling\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra\\\\/theme-appearance\\\\/horizontal-section-scrolling\\\\/\\",\\"param_image\\":\\"regular\\",\\"animation_effect\\":\\"fadeInUp\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\"}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"2\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3420,
  'post_date' => '2015-04-16 21:16:36',
  'post_date_gmt' => '2015-04-16 21:16:36',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h2>Smart Layout Options</h2>
<p>Ultra gives you full control from header to footer, either site-wide or on a per-page basis. This means that you can make your entire site share the same look and feel or create a unique look for every page.</p>
<h4>15 Header/Page Styles</h4><p>Select a header/page design from 15 styles (the no header option is perfect for making landing pages where you don\'t want to have header navigation). And yes, there is a sticky header option and this design list is growing!</p>
<a href="https://themify.me/demo/themes/ultra/all-layouts/" > <img src="https://themify.me/demo/themes/ultra/files/2017/01/header-layout-1024x555-1158x628.png" width="1158" height="628" alt="header layout" srcset="https://themify.me/demo/themes/ultra/files/2017/01/header-layout.png 1158w, https://themify.me/demo/themes/ultra/files/2017/01/header-layout-150x81.png 150w, https://themify.me/demo/themes/ultra/files/2017/01/header-layout-300x163.png 300w, https://themify.me/demo/themes/ultra/files/2017/01/header-layout-1024x555.png 1024w, https://themify.me/demo/themes/ultra/files/2017/01/header-layout-370x201.png 370w, https://themify.me/demo/themes/ultra/files/2017/01/header-layout-600x325.png 600w" sizes="(max-width: 1158px) 100vw, 1158px" /> </a>
<h4>6 Header Background Options</h4><p>Header background allows you to: upload a background image, pick a solid color, insert a slider, upload a video, set animating colors, or have it transparent if you want.</p>
<a href="https://themify.me/demo/themes/ultra/all-layouts/" > <img src="https://themify.me/demo/themes/ultra/files/2017/01/header-background-1024x154-1158x174.png" width="1158" height="174" alt="header background" srcset="https://themify.me/demo/themes/ultra/files/2017/01/header-background.png 1158w, https://themify.me/demo/themes/ultra/files/2017/01/header-background-150x23.png 150w, https://themify.me/demo/themes/ultra/files/2017/01/header-background-300x45.png 300w, https://themify.me/demo/themes/ultra/files/2017/01/header-background-1024x154.png 1024w, https://themify.me/demo/themes/ultra/files/2017/01/header-background-370x56.png 370w, https://themify.me/demo/themes/ultra/files/2017/01/header-background-600x90.png 600w" sizes="(max-width: 1158px) 100vw, 1158px" /> </a>
<h4>6 Footer Layouts</h4><p>6 footer layout choices with options to toggle visibility of footer logo, menu, widget, and credit text.</p>
<a href="https://themify.me/demo/themes/ultra/all-layouts/" > <img src="https://themify.me/demo/themes/ultra/files/2017/01/footer-layout-1024x155-1157x175.png" width="1157" height="175" alt="footer layout" srcset="https://themify.me/demo/themes/ultra/files/2017/01/footer-layout.png 1157w, https://themify.me/demo/themes/ultra/files/2017/01/footer-layout-150x23.png 150w, https://themify.me/demo/themes/ultra/files/2017/01/footer-layout-300x45.png 300w, https://themify.me/demo/themes/ultra/files/2017/01/footer-layout-1024x155.png 1024w, https://themify.me/demo/themes/ultra/files/2017/01/footer-layout-370x56.png 370w, https://themify.me/demo/themes/ultra/files/2017/01/footer-layout-600x91.png 600w" sizes="(max-width: 1157px) 100vw, 1157px" /> </a>
<h4>5 Single Post Layouts</h4><p>In term of single post layout, there is a default layout plus 4 unique layouts.</p>
<a href="https://themify.me/demo/themes/ultra/all-layouts/" > <img src="https://themify.me/demo/themes/ultra/files/2017/01/single-post-layout-759x175.png" width="759" height="175" alt="single post layout" srcset="https://themify.me/demo/themes/ultra/files/2017/01/single-post-layout.png 759w, https://themify.me/demo/themes/ultra/files/2017/01/single-post-layout-150x35.png 150w, https://themify.me/demo/themes/ultra/files/2017/01/single-post-layout-300x69.png 300w, https://themify.me/demo/themes/ultra/files/2017/01/single-post-layout-370x85.png 370w, https://themify.me/demo/themes/ultra/files/2017/01/single-post-layout-600x138.png 600w" sizes="(max-width: 759px) 100vw, 759px" /> </a>
<h4>6 Archive Layouts</h4><p>For the archive layouts, we have 6 different styles that you can choose from: slider, fullwidth, masonry, grids, polaroid, and overlay. You may also toggle the visibility of the post elements such as post title, featured image, meta, content, etc.</p>
<a href="https://themify.me/demo/themes/ultra/all-layouts/" > <img src="https://themify.me/demo/themes/ultra/files/2017/01/archive-layouts-1024x154-1157x174.png" width="1157" height="174" alt="alt text" srcset="https://themify.me/demo/themes/ultra/files/2017/01/archive-layouts.png 1157w, https://themify.me/demo/themes/ultra/files/2017/01/archive-layouts-150x23.png 150w, https://themify.me/demo/themes/ultra/files/2017/01/archive-layouts-300x45.png 300w, https://themify.me/demo/themes/ultra/files/2017/01/archive-layouts-1024x154.png 1024w, https://themify.me/demo/themes/ultra/files/2017/01/archive-layouts-370x56.png 370w, https://themify.me/demo/themes/ultra/files/2017/01/archive-layouts-600x90.png 600w" sizes="(max-width: 1157px) 100vw, 1157px" /> </a>
<h4>Section Scrolling (*New)</h4> <p>Inspired by our <a href="https://themify.me/themes/fullpane">Fullpane</a> theme, full section scrolling feature allows viewers to scroll through your page design one row at a time like a presentation slideshow. Full section scrolling now comes with Horizontal and Vertical scrolling.</p>
<a href="https://themify.me/demo/themes/ultra/theme-appearance/section-scrolling/" > <img src="https://themify.me/demo/themes/ultra/files/2016/11/slide-out-scrolling.png" width="160" height="135" title="Horizontal " alt="Horizontal " /> </a> <h3> <a href="https://themify.me/demo/themes/ultra/theme-appearance/section-scrolling/" > Horizontal & Vertical Scrolling </a> </h3>
<a href="https://themify.me/demo/themes/ultra/theme-appearance/vertical-section-scrolling/" > <img src="https://themify.me/demo/themes/ultra/files/2018/04/minbar-header-160x135.png" width="160" height="135" title="Vertical Section Scrolling" alt="Vertical Section Scrolling" srcset="https://themify.me/demo/themes/ultra/files/2018/04/minbar-header-160x135.png 160w, https://themify.me/demo/themes/ultra/files/2018/04/minbar-header-150x127.png 150w, https://themify.me/demo/themes/ultra/files/2018/04/minbar-header.png 192w" sizes="(max-width: 160px) 100vw, 160px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra/theme-appearance/vertical-section-scrolling/" > Vertical Section Scrolling </a> </h3>
<a href="https://themify.me/demo/themes/ultra/theme-appearance/horizontal-section-scrolling/" > <img src="https://themify.me/demo/themes/ultra/files/2018/04/top-bar-header-160x135.png" width="160" height="135" title="Horizontal Section Scrolling" alt="Horizontal Section Scrolling" srcset="https://themify.me/demo/themes/ultra/files/2018/04/top-bar-header-160x135.png 160w, https://themify.me/demo/themes/ultra/files/2018/04/top-bar-header-150x127.png 150w, https://themify.me/demo/themes/ultra/files/2018/04/top-bar-header.png 192w" sizes="(max-width: 160px) 100vw, 160px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra/theme-appearance/horizontal-section-scrolling/" > Horizontal Section Scrolling </a> </h3><!--/themify_builder_static-->',
  'post_title' => 'Appearance',
  'post_excerpt' => '',
  'post_name' => 'theme-appearance',
  'post_modified' => '2019-07-31 21:31:10',
  'post_modified_gmt' => '2019-07-31 21:31:10',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=3420',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'hide_page_title' => 'yes',
    'custom_menu' => 'main-nav',
    'mobile_menu_styles' => 'default',
    'header_wrap' => 'video',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"fb99ee9\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"f6bd5c4\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"a63b9ed\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>Smart Layout Options<\\\\/h2>\\",\\"animation_effect\\":\\"fadeInDown\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"3752eb3\\",\\"unstick_when_el_mod_id\\":\\"21de73d\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"888h000\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1.2\\",\\"font_size_unit\\":\\"em\\",\\"line_height\\":\\"1.5\\",\\"line_height_unit\\":\\"em\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"margin_bottom\\":\\"10\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Ultra gives you full control from header to footer, either site-wide or on a per-page basis. This means that you can make your entire site share the same look and feel or create a unique look for every page.<\\\\/p>\\",\\"animation_effect\\":\\"fadeInDown\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"3752eb3\\",\\"unstick_when_el_mod_id\\":\\"21de73d\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"309d32f\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"margin_top_unit\\":\\"%\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h4>15 Header\\\\/Page Styles<\\\\/h4><p>Select a header\\\\/page design from 15 styles (the no header option is perfect for making landing pages where you don\\\\\\\\\\\'t want to have header navigation). And yes, there is a sticky header option and this design list is growing!<\\\\/p>\\",\\"animation_effect\\":\\"fadeInUp\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"3752eb3\\",\\"unstick_when_el_mod_id\\":\\"21de73d\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"e4d34fc\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"font_color_title\\":\\"000000\\",\\"font_size_title\\":\\"16\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra\\\\/files\\\\/2017\\\\/01\\\\/header-layout-1024x555.png\\",\\"width_image\\":\\"1158\\",\\"height_image\\":\\"628\\",\\"link_image\\":\\"https://themify.me/demo/themes/ultra\\\\/all-layouts\\\\/\\",\\"param_image\\":\\"regular\\",\\"animation_effect\\":\\"fadeInLeft\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"6a66b78\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>6 Header Background Options<\\\\/h4><p>Header background allows you to: upload a background image, pick a solid color, insert a slider, upload a video, set animating colors, or have it transparent if you want.<\\\\/p>\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"7\\",\\"margin_top_unit\\":\\"%\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeInDown\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"8188aa7\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra\\\\/files\\\\/2017\\\\/01\\\\/header-background-1024x154.png\\",\\"width_image\\":\\"1158\\",\\"height_image\\":\\"174\\",\\"link_image\\":\\"https://themify.me/demo/themes/ultra\\\\/all-layouts\\\\/\\",\\"param_image\\":\\"regular\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_color_title\\":\\"000000_1.00\\",\\"font_size_title\\":\\"16\\",\\"animation_effect\\":\\"fadeInRight\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"828f8d3\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>6 Footer Layouts<\\\\/h4><p>6 footer layout choices with options to toggle visibility of footer logo, menu, widget, and credit text.<\\\\/p>\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"7\\",\\"margin_top_unit\\":\\"%\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeInRight\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"0324a7f\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra\\\\/files\\\\/2017\\\\/01\\\\/footer-layout-1024x155.png\\",\\"width_image\\":\\"1157\\",\\"height_image\\":\\"175\\",\\"link_image\\":\\"https://themify.me/demo/themes/ultra\\\\/all-layouts\\\\/\\",\\"param_image\\":\\"regular\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_color_title\\":\\"000000_1.00\\",\\"font_size_title\\":\\"16\\",\\"animation_effect\\":\\"fadeInLeft\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ca6f516\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>5 Single Post Layouts<\\\\/h4><p>In term of single post layout, there is a default layout plus 4 unique layouts.<\\\\/p>\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"7\\",\\"margin_top_unit\\":\\"%\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeInDown\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"86f7977\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra\\\\/files\\\\/2017\\\\/01\\\\/single-post-layout.png\\",\\"width_image\\":\\"759\\",\\"height_image\\":\\"175\\",\\"link_image\\":\\"https://themify.me/demo/themes/ultra\\\\/all-layouts\\\\/\\",\\"param_image\\":\\"regular\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_color_title\\":\\"000000_1.00\\",\\"font_size_title\\":\\"16\\",\\"animation_effect\\":\\"fadeInUp\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\"}}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"b0864a1\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>6 Archive Layouts<\\\\/h4><p>For the archive layouts, we have 6 different styles that you can choose from: slider, fullwidth, masonry, grids, polaroid, and overlay. You may also toggle the visibility of the post elements such as post title, featured image, meta, content, etc.<\\\\/p>\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"7\\",\\"margin_top_unit\\":\\"%\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeInDown\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"e2a5f04\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra\\\\/files\\\\/2017\\\\/01\\\\/archive-layouts-1024x154.png\\",\\"width_image\\":\\"1157\\",\\"height_image\\":\\"174\\",\\"link_image\\":\\"https://themify.me/demo/themes/ultra\\\\/all-layouts\\\\/\\",\\"param_image\\":\\"regular\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_color_title\\":\\"000000_1.00\\",\\"font_size_title\\":\\"16\\",\\"animation_effect\\":\\"fadeInLeft\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"9a81f6a\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"7\\",\\"margin_top_unit\\":\\"%\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h4>Section Scrolling (*New)<\\\\/h4>\\\\n<p>Inspired by our <a href=\\\\\\\\\\\\\\"https:\\\\/\\\\/themify.me\\\\/themes\\\\/fullpane\\\\\\\\\\\\\\">Fullpane<\\\\/a> theme, full section scrolling feature allows viewers to scroll through your page design one row at a time like a presentation slideshow. Full section scrolling now comes with Horizontal and Vertical scrolling.<\\\\/p>\\",\\"animation_effect\\":\\"fadeInDown\\"}},{\\"element_id\\":\\"533c852\\",\\"row_order\\":\\"13\\",\\"cols\\":[{\\"element_id\\":\\"a2223fa\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"6a755c4\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_title\\":\\"000000\\",\\"font_size_title\\":\\"16\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra\\\\/files\\\\/2016\\\\/11\\\\/slide-out-scrolling.png\\",\\"width_image\\":\\"160\\",\\"height_image\\":\\"135\\",\\"title_image\\":\\"Horizontal & Vertical Scrolling\\",\\"link_image\\":\\"https://themify.me/demo/themes/ultra\\\\/theme-appearance\\\\/section-scrolling\\\\/\\",\\"param_image\\":\\"regular\\",\\"animation_effect\\":\\"fadeInUp\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"2cea4bb\\",\\"unstick_when_el_mod_id\\":\\"ed128ce\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]},{\\"element_id\\":\\"5485e14\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"1e103d1\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_title\\":\\"000000\\",\\"font_size_title\\":\\"16\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra\\\\/files\\\\/2018\\\\/04\\\\/minbar-header.png\\",\\"width_image\\":\\"160\\",\\"height_image\\":\\"135\\",\\"title_image\\":\\"Vertical Section Scrolling\\",\\"link_image\\":\\"https://themify.me/demo/themes/ultra\\\\/theme-appearance\\\\/vertical-section-scrolling\\\\/\\",\\"param_image\\":\\"regular\\",\\"animation_effect\\":\\"fadeInUp\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"2cea4bb\\",\\"unstick_when_el_mod_id\\":\\"ed128ce\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]},{\\"element_id\\":\\"8dcf89e\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"6917ce5\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_title\\":\\"000000\\",\\"font_size_title\\":\\"16\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra\\\\/files\\\\/2018\\\\/04\\\\/top-bar-header.png\\",\\"width_image\\":\\"160\\",\\"height_image\\":\\"135\\",\\"title_image\\":\\"Horizontal Section Scrolling\\",\\"link_image\\":\\"https://themify.me/demo/themes/ultra\\\\/theme-appearance\\\\/horizontal-section-scrolling\\\\/\\",\\"param_image\\":\\"regular\\",\\"animation_effect\\":\\"fadeInUp\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"2cea4bb\\",\\"unstick_when_el_mod_id\\":\\"ed128ce\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\"}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"2\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"b0a661e\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"2a73c38\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3990,
  'post_date' => '2015-05-08 23:22:25',
  'post_date_gmt' => '2015-05-08 23:22:25',
  'post_content' => '<!--themify_builder_static--><h2 style="text-align: center;">Our clients</h2><h3 style="text-align: center;">Below are some of our clients</h3> 
 <ul data-id="slider-0-" data-visible="3" data-mob-visible="" data-scroll="1" data-auto-scroll="4" data-speed="1" data-wrap="yes" data-arrow="no" data-pagination="no" data-effect="continuously" data-height="variable" data-pause-on-hover="resume" > 
 <li> <a href="https://twitter.com/themify" alt=""> <img src="https://themify.me/demo/themes/landing/files/2015/02/twitter1.png" alt="" /> </a> </li> <li> <a href="https://www.youtube.com/user/themifyme" alt=""> <img src="https://themify.me/demo/themes/landing/files/2015/02/2YouTube.png" alt="" /> </a> </li> <li> <a href="http://instagram.com/" alt=""> <img src="https://themify.me/demo/themes/landing/files/2015/02/1Instagram.png" alt="" /> </a> </li> <li> <a href="https://www.facebook.com/themify" alt=""> <img src="https://themify.me/demo/themes/landing/files/2015/02/1facebook.png" alt="" /> </a> </li> </ul> 
 
 <h4>Tablet App</h4> <p>I\'d imperdiet leo aliquet ut. Aenean rutrum lorem ac augue lobortis venenatis. Donec pulvinar bibendum magna id cursus. Integer vitae pulvinar tellus. Praesent a metus gravida, blandit mi ac, sagittis lectus. Etiam quis orci risus.</p> 
 <a href="https://themify.me/" >Our Work</a> 
 <img src="https://themify.me/demo/themes/landing/files/2015/03/n9-1.jpg" width="560" alt="" /> 
 <p style="text-align: center;"><em>"I love working with Interface Design Studio. Their friendly and hands-on!"</em></p> 
 <img src="https://themify.me/demo/themes/landing/files/2015/02/157472372.jpg" width="100" height="100" alt="Michael Porter CEO, X-Company www.companyx.com" /> <strong>Michael Porter</strong><br> CEO, X-Company<br> www.companyx.com 
 
 <img src="https://themify.me/demo/themes/landing/files/2015/03/BMW-i8-Konfigurator-Preise-Sonderausstattungen-Optionen-02.jpg" width="560" alt="" /> 
 <h4>Auto App</h4> <p>I\'d imperdiet leo aliquet ut. Aenean rutrum lorem ac augue lobortis venenatis. Donec pulvinar bibendum magna id cursus. Integer vitae pulvinar tellus. Praesent a metus gravida, blandit mi ac, sagittis lectus. Etiam quis orci risus.</p> 
 <a href="https://themify.me/" >Our Work</a> 
 <p style="text-align: center;"> <em>"Great people. Great service. These factors led to an amazing Interface."</em></p> 
 <img src="https://themify.me/demo/themes/landing/files/2015/02/164990474.jpg" width="100" height="100" alt="Stephanie Specialist, Auto-B www.autob.com" /> <strong>Stephanie</strong><br> Specialist, Auto-B<br> www.autob.com 
 
 <h4>Web App</h4> <p>I\'d imperdiet leo aliquet ut. Aenean rutrum lorem ac augue lobortis venenatis. Donec pulvinar bibendum magna id cursus. Integer vitae pulvinar tellus. </p> 
 <a href="https://themify.me/" >More</a> 
 <img src="https://themify.me/demo/themes/landing/files/2015/03/Leaderboard_Free.png" width="560" alt="" /> 
 <p style="text-align: center;"><em>"Enjoyed working with specialist who know exactly what they are doing!"</em></p> 
 <img src="https://themify.me/demo/themes/landing/files/2015/02/131227259.jpg" width="100" height="100" alt="Steve Baker CEO, WebApp www.webapp.com" /> <strong>Steve Baker</strong><br> CEO, WebApp<br> www.webapp.com 
 
 <img src="https://themify.me/demo/themes/landing/files/2015/03/overview_display_hero.jpg" width="560" alt="" /> 
 <h4>Mix Panel</h4> <p>LI\'d imperdiet leo aliquet ut. Aenean rutrum lorem ac augue lobortis venenatis. Donec pulvinar bibendum magna id cursus. Integer vitae pulvinar tellus. Praesent a metus gravida, blandit mi ac, sagittis lectus. Etiam quis orci risus.</p> 
 <a href="https://themify.me/" >More</a> 
 <p style="text-align: center;"><em>"These guys know how to get things done! Always on-time with high quality results."</em></p> 
 <img src="https://themify.me/demo/themes/ultra/files/2019/03/82152160-100x100.jpg" width="100" height="100" alt="Kristina Dealey Mix Panel www.mixpanel.com" srcset="https://themify.me/demo/themes/ultra/files/2019/03/82152160-100x100.jpg 100w, https://themify.me/demo/themes/ultra/files/2019/03/82152160-150x150.jpg 150w, https://themify.me/demo/themes/ultra/files/2019/03/82152160-300x300.jpg 300w, https://themify.me/demo/themes/ultra/files/2019/03/82152160.jpg 369w" sizes="(max-width: 100px) 100vw, 100px" /> <strong>Kristina Dealey</strong><br> Mix Panel<br> www.mixpanel.com 
 
 <h4 style="text-align: center;">Want to work with us?</h4> <p style="text-align: center;"><strong>Let\'s it happen now!</strong> Enroll to our 2 year university program in just 2-month. Why wait millions are asking for it. Click the following button to register now!</p> 
 <a href="https://themify.me/" >Register</a><!--/themify_builder_static-->',
  'post_title' => 'Animating Color',
  'post_excerpt' => '',
  'post_name' => 'animating-color',
  'post_modified' => '2019-03-20 07:52:12',
  'post_modified_gmt' => '2019-03-20 07:52:12',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=3990',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'header_design' => 'header-block',
    'header_wrap' => 'colors',
    'headerwrap_text_color' => '#ffffff',
    'headerwrap_link_color' => '#ffffff',
    'footer_design' => 'footer-left-col',
    'more_posts' => 'pagination',
    'posts_per_page' => '2',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"46fe77f\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"56292bc\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"db0334e\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Our clients<\\\\/h2><h3 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Below are some of our clients<\\\\/h3>\\"}},{\\"mod_name\\":\\"slider\\",\\"element_id\\":\\"5b68b5a\\",\\"mod_settings\\":{\\"layout_display_slider\\":\\"image\\",\\"blog_category_slider\\":\\"|single\\",\\"slider_category_slider\\":\\"|single\\",\\"portfolio_category_slider\\":\\"|single\\",\\"testimonial_category_slider\\":\\"|single\\",\\"order_slider\\":\\"desc\\",\\"orderby_slider\\":\\"date\\",\\"display_slider\\":\\"content\\",\\"img_content_slider\\":[{\\"img_url_slider\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/02\\\\/twitter1.png\\",\\"img_link_slider\\":\\"https:\\\\/\\\\/twitter.com\\\\/themify\\"},{\\"img_url_slider\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/02\\\\/2YouTube.png\\",\\"img_link_slider\\":\\"https:\\\\/\\\\/www.youtube.com\\\\/user\\\\/themifyme\\"},{\\"img_url_slider\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/02\\\\/1Instagram.png\\",\\"img_link_slider\\":\\"http:\\\\/\\\\/instagram.com\\\\/\\"},{\\"img_url_slider\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/02\\\\/1facebook.png\\",\\"img_link_slider\\":\\"https:\\\\/\\\\/www.facebook.com\\\\/themify\\"}],\\"layout_slider\\":\\"slider-default\\",\\"visible_opt_slider\\":\\"3\\",\\"auto_scroll_opt_slider\\":\\"4\\",\\"scroll_opt_slider\\":\\"1\\",\\"speed_opt_slider\\":\\"normal\\",\\"effect_slider\\":\\"continuously\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"wrap_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"no\\",\\"show_arrow_slider\\":\\"no\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"row_anchor\\":\\"clients\\"}},{\\"element_id\\":\\"0736247\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"ba05207\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"da4c5c7\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"bdbdbd_1.00\\",\\"divider_type\\":\\"fullwidth\\"}}]}]},{\\"element_id\\":\\"7baf287\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"adf5db9\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"cebb6f7\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"e91c331\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"b9998f3\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h4>Tablet App<\\\\/h4>\\\\n<p>I\\\\\\\\\\\'d imperdiet leo aliquet ut. Aenean rutrum lorem ac augue lobortis venenatis. Donec pulvinar bibendum magna id cursus. Integer vitae pulvinar tellus. Praesent a metus gravida, blandit mi ac, sagittis lectus. Etiam quis orci risus.<\\\\/p>\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"62e9826\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"link_color\\":\\"#ffffff\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"squared\\",\\"content_button\\":[{\\"label\\":\\"Our Work\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"green\\"}]}}]},{\\"element_id\\":\\"cd14b82\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"29ab950\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/03\\\\/n9-1.jpg\\",\\"width_image\\":\\"560\\"}}]}]},{\\"element_id\\":\\"945210e\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"36f7631\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-1\\"},{\\"element_id\\":\\"01a9534\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"f5f5f78\\",\\"mod_settings\\":{\\"content_text\\":\\"<p style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\"><em>\\\\\\\\\\\\\\"I love working with Interface Design Studio. Their friendly and hands-on!\\\\\\\\\\\\\\"<\\\\/em><\\\\/p>\\",\\"font_size\\":\\"1.4\\",\\"font_size_unit\\":\\"em\\",\\"padding_top\\":\\"60\\",\\"margin_top\\":\\"60\\",\\"border_top_color\\":\\"eee\\",\\"border_top_width\\":\\"1\\"}}]},{\\"element_id\\":\\"25e1f9a\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col4-1\\"}]},{\\"element_id\\":\\"70c6ab4\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"762f1c4\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\"},{\\"element_id\\":\\"8eae651\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"2f0b31a\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/02\\\\/157472372.jpg\\",\\"appearance_image\\":\\"circle\\",\\"width_image\\":\\"100\\",\\"height_image\\":\\"100\\",\\"caption_image\\":\\"<strong>Michael Porter<\\\\/strong><br> \\\\nCEO, X-Company<br>\\\\nwww.companyx.com\\"}}]},{\\"element_id\\":\\"a13bde0\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\"}]}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\"}},{\\"element_id\\":\\"ba7a598\\",\\"row_order\\":\\"3\\",\\"cols\\":[{\\"element_id\\":\\"99f41a2\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"2237e83\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"bdbdbd_1.00\\",\\"divider_type\\":\\"fullwidth\\"}}]}]},{\\"element_id\\":\\"057b258\\",\\"row_order\\":\\"4\\",\\"cols\\":[{\\"element_id\\":\\"d0da2cd\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"759e630\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"14a8d56\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"7198f62\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/03\\\\/BMW-i8-Konfigurator-Preise-Sonderausstattungen-Optionen-02.jpg\\",\\"width_image\\":\\"560\\"}}]},{\\"element_id\\":\\"5212066\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"eadae19\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h4>Auto App<\\\\/h4>\\\\n<p>I\\\\\\\\\\\'d imperdiet leo aliquet ut. Aenean rutrum lorem ac augue lobortis venenatis. Donec pulvinar bibendum magna id cursus. Integer vitae pulvinar tellus. Praesent a metus gravida, blandit mi ac, sagittis lectus. Etiam quis orci risus.<\\\\/p>\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"e37c58b\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"link_color\\":\\"#ffffff\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"squared\\",\\"content_button\\":[{\\"label\\":\\"Our Work\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"green\\"}]}}]}]},{\\"element_id\\":\\"2067e65\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"715c436\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-1\\"},{\\"element_id\\":\\"a399afe\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"9fbd7c9\\",\\"mod_settings\\":{\\"content_text\\":\\"<p style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\"> <em>\\\\\\\\\\\\\\"Great people. Great service. These factors led to an amazing Interface.\\\\\\\\\\\\\\"<\\\\/em><\\\\/p>\\",\\"font_size\\":\\"1.4\\",\\"font_size_unit\\":\\"em\\",\\"padding_top\\":\\"60\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top\\":\\"60\\",\\"border_top_color\\":\\"eee\\",\\"border_top_width\\":\\"1\\"}}]},{\\"element_id\\":\\"967f6b5\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col4-1\\"}]},{\\"element_id\\":\\"c437a39\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"851bb5a\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\"},{\\"element_id\\":\\"6a1cc45\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"f292203\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/02\\\\/164990474.jpg\\",\\"appearance_image\\":\\"circle\\",\\"width_image\\":\\"100\\",\\"height_image\\":\\"100\\",\\"caption_image\\":\\"<strong>Stephanie<\\\\/strong><br>\\\\nSpecialist, Auto-B<br>\\\\nwww.autob.com\\"}}]},{\\"element_id\\":\\"0048bd3\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\"}]}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\"}},{\\"element_id\\":\\"39a1f90\\",\\"row_order\\":\\"5\\",\\"cols\\":[{\\"element_id\\":\\"5401594\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"5b5b9e1\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"bdbdbd_1.00\\",\\"divider_type\\":\\"fullwidth\\"}}]}]},{\\"element_id\\":\\"2335aa3\\",\\"row_order\\":\\"6\\",\\"cols\\":[{\\"element_id\\":\\"22c7e45\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"7c102e0\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"ab49a5e\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"5996651\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h4>Web App<\\\\/h4>\\\\n<p>I\\\\\\\\\\\'d imperdiet leo aliquet ut. Aenean rutrum lorem ac augue lobortis venenatis. Donec pulvinar bibendum magna id cursus. Integer vitae pulvinar tellus. <\\\\/p>\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"5de9535\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"link_color\\":\\"#ffffff\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"squared\\",\\"content_button\\":[{\\"label\\":\\"More\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"green\\"}]}}]},{\\"element_id\\":\\"b3306b6\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"19186be\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/03\\\\/Leaderboard_Free.png\\",\\"width_image\\":\\"560\\"}}]}]},{\\"element_id\\":\\"83bf0d6\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"1931017\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-1\\"},{\\"element_id\\":\\"99c35a0\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"5f9641b\\",\\"mod_settings\\":{\\"content_text\\":\\"<p style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\"><em>\\\\\\\\\\\\\\"Enjoyed working with specialist who know exactly what they are doing!\\\\\\\\\\\\\\"<\\\\/em><\\\\/p>\\",\\"font_size\\":\\"1.3\\",\\"font_size_unit\\":\\"em\\",\\"padding_top\\":\\"60\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top\\":\\"60\\",\\"border_top_color\\":\\"eee\\",\\"border_top_width\\":\\"1\\"}}]},{\\"element_id\\":\\"dd2ed03\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col4-1\\"}]},{\\"element_id\\":\\"826fc00\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"47f9123\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\"},{\\"element_id\\":\\"6efb555\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"38218e2\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/02\\\\/131227259.jpg\\",\\"appearance_image\\":\\"circle\\",\\"width_image\\":\\"100\\",\\"height_image\\":\\"100\\",\\"caption_image\\":\\"<strong>Steve Baker<\\\\/strong><br>\\\\nCEO, WebApp<br>\\\\nwww.webapp.com\\"}}]},{\\"element_id\\":\\"7367fc4\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\"}]}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\"}},{\\"element_id\\":\\"a69ec57\\",\\"row_order\\":\\"7\\",\\"cols\\":[{\\"element_id\\":\\"7c964c6\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"beeed96\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"bdbdbd_1.00\\",\\"divider_type\\":\\"fullwidth\\"}}]}]},{\\"element_id\\":\\"98d7683\\",\\"row_order\\":\\"8\\",\\"cols\\":[{\\"element_id\\":\\"1ca45db\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"be81e63\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"8199a24\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"3bbbe00\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/03\\\\/overview_display_hero.jpg\\",\\"width_image\\":\\"560\\"}}]},{\\"element_id\\":\\"bb7f840\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"4104e58\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h4>Mix Panel<\\\\/h4>\\\\n<p>LI\\\\\\\\\\\'d imperdiet leo aliquet ut. Aenean rutrum lorem ac augue lobortis venenatis. Donec pulvinar bibendum magna id cursus. Integer vitae pulvinar tellus. Praesent a metus gravida, blandit mi ac, sagittis lectus. Etiam quis orci risus.<\\\\/p>\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"216871b\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"link_color\\":\\"#ffffff\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"squared\\",\\"content_button\\":[{\\"label\\":\\"More\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"green\\"}]}}]}]},{\\"element_id\\":\\"6400c40\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"7659c66\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-1\\"},{\\"element_id\\":\\"958c150\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"bda106b\\",\\"mod_settings\\":{\\"content_text\\":\\"<p style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\"><em>\\\\\\\\\\\\\\"These guys know how to get things done! Always on-time with high quality results.\\\\\\\\\\\\\\"<\\\\/em><\\\\/p>\\",\\"font_size\\":\\"1.3\\",\\"font_size_unit\\":\\"em\\",\\"padding_top\\":\\"60\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top\\":\\"60\\",\\"border_top_color\\":\\"eee\\",\\"border_top_width\\":\\"1\\"}}]},{\\"element_id\\":\\"f6e1ffb\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col4-1\\"}]},{\\"element_id\\":\\"7cca586\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"0b5c230\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\"},{\\"element_id\\":\\"008de8e\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"cce49b8\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra\\\\/files\\\\/2019\\\\/03\\\\/82152160.jpg\\",\\"appearance_image\\":\\"circle\\",\\"width_image\\":\\"100\\",\\"height_image\\":\\"100\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"<strong>Kristina Dealey<\\\\/strong><br>\\\\nMix Panel<br>\\\\nwww.mixpanel.com\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"46fe77f\\",\\"unstick_when_el_mod_id\\":\\"db0334e\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]},{\\"element_id\\":\\"da93222\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\"}]}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\"}},{\\"element_id\\":\\"d97b51c\\",\\"row_order\\":\\"9\\",\\"cols\\":[{\\"element_id\\":\\"df841f9\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"0b26e61\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"bdbdbd_1.00\\",\\"divider_type\\":\\"fullwidth\\"}}]}]},{\\"element_id\\":\\"497cd01\\",\\"row_order\\":\\"10\\",\\"cols\\":[{\\"element_id\\":\\"ca740c3\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"628aa34\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"a42a1e1\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-1\\"},{\\"element_id\\":\\"a7e358c\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"3aa0ca7\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Want to work with us?<\\\\/h4>\\\\n<p style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\"><strong>Let\\\\\\\\\\\'s it happen now!<\\\\/strong> Enroll to our 2 year university program in just 2-month. Why wait millions are asking for it. Click the following button to register now!<\\\\/p>\\\\n\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"170c491\\",\\"mod_settings\\":{\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"rounded\\",\\"content_button\\":[{\\"label\\":\\"Register\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"button_color_bg\\":\\"red\\"}],\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_link_padding_apply_all\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"e92d698\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col4-1\\"}],\\"gutter\\":\\"gutter-none\\"}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\"}},{\\"element_id\\":\\"fc57cad\\",\\"row_order\\":\\"11\\",\\"cols\\":[{\\"element_id\\":\\"c9a2b66\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3389,
  'post_date' => '2015-04-16 20:29:53',
  'post_date_gmt' => '2015-04-16 20:29:53',
  'post_content' => '<!--themify_builder_static--><ul data-id="slider-0-" data-visible="1" data-mob-visible="0" data-scroll="1" data-auto-scroll="off" data-speed="1" data-wrap="yes" data-arrow="yes" data-pagination="yes" data-effect="scroll" data-height="variable" data-pause-on-hover="resume" > 
 <li> <img src="https://themify.me/demo/themes/shoppe-elegant/files/2016/12/model-wearing-bracelet.jpg" width="1000" height="200" alt="New Collection" /> 
 <h3> New Collection </h3> This season most elegant collection has arrived. </li> <li> <img src="https://themify.me/demo/themes/shoppe-elegant/files/2016/12/model-wearing-necklace-1-1024x684.jpg" width="1000" height="200" alt="Super Sale" /> 
 <h3> Super Sale </h3> Take advantage of our sale up to 30% off! </li> <li> <img src="https://themify.me/demo/themes/shoppe-elegant/files/2016/12/model-wear-earring-1024x683.jpg" width="1000" height="200" alt="Best Quality" /> 
 <h3> Best Quality </h3> Check the beauties handcrafted by our masters. </li> </ul> 
 <a href="https://themify.me/demo/themes/shoppe-elegant/product-category/ring/" > <img src="https://themify.me/demo/themes/shoppe-elegant/files/2016/12/Green-Tourmaline-Ring.jpg" width="450" height="250" title="Rings" alt="Rings" /> </a> <h3> <a href="https://themify.me/demo/themes/shoppe-elegant/product-category/ring/" > Rings </a> </h3> 
 <a href="https://themify.me/demo/themes/shoppe-elegant/product-category/earring/" > <img src="https://themify.me/demo/themes/shoppe-elegant/files/2016/12/pearl-earrings.jpg" width="250" height="200" title="Ear Rings" alt="Ear Rings" /> </a> <h3> <a href="https://themify.me/demo/themes/shoppe-elegant/product-category/earring/" > Ear Rings </a> </h3> 
 <a href="https://themify.me/demo/themes/shoppe-elegant/product-category/necklace/" > <img src="https://themify.me/demo/themes/shoppe-elegant/files/2016/12/Love-Heart-Tag-Key.jpg" width="250" height="200" title="Necklets" alt="Necklets" /> </a> <h3> <a href="https://themify.me/demo/themes/shoppe-elegant/product-category/necklace/" > Necklets </a> </h3> 
 <a href="https://themify.me/demo/themes/shoppe-elegant/product-category/bracelet/" > <img src="https://themify.me/demo/themes/shoppe-elegant/files/2016/12/bracelet-3.jpg" width="600" height="575" title="Bracelets" alt="Bracelets" /> </a> <h3> <a href="https://themify.me/demo/themes/shoppe-elegant/product-category/bracelet/" > Bracelets </a> </h3><!--/themify_builder_static-->',
  'post_title' => 'Block',
  'post_excerpt' => '',
  'post_name' => 'block',
  'post_modified' => '2019-03-08 18:32:08',
  'post_modified_gmt' => '2019-03-08 18:32:08',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=3389',
  'menu_order' => 2,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'color_design' => 'theme-color-grey',
    'header_design' => 'header-block',
    'mobile_menu_styles' => 'default',
    'footer_design' => 'footer-horizontal-left',
    'more_posts' => 'pagination',
    'posts_per_page' => '2',
    'portfolio_more_posts' => 'pagination',
    'portfolio_posts_per_page' => '2',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"82c74c8\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"8ff586a\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"slider\\",\\"element_id\\":\\"4638dc4\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#000000\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"0\\",\\"border-type\\":\\"top\\",\\"checkbox_p_container_apply_all\\":\\"1\\",\\"checkbox_m_container_apply_all\\":\\"1\\",\\"b_container-type\\":\\"top\\",\\"font_color_title\\":\\"#ffffff\\",\\"font_color_title_hover\\":\\"#ffffff\\",\\"checkbox_m_title_apply_all\\":\\"1\\",\\"font_color_content\\":\\"#ffffff\\",\\"checkbox_p_content_apply_all\\":\\"1\\",\\"layout_display_slider\\":\\"image\\",\\"post_type\\":\\"post\\",\\"taxonomy\\":\\"category\\",\\"blog_category_slider\\":\\"0|multiple\\",\\"portfolio_category_slider\\":\\"0|multiple\\",\\"posts_per_page_slider\\":\\"4\\",\\"order_slider\\":\\"desc\\",\\"orderby_slider\\":\\"date\\",\\"display_slider\\":\\"none\\",\\"img_content_slider\\":[{\\"img_url_slider\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/shoppe-elegant\\\\/files\\\\/2016\\\\/12\\\\/model-wearing-bracelet.jpg\\",\\"img_title_slider\\":\\"New Collection\\",\\"img_caption_slider\\":\\"This season most elegant collection has arrived.\\"},{\\"img_url_slider\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/shoppe-elegant\\\\/files\\\\/2016\\\\/12\\\\/model-wearing-necklace-1-1024x684.jpg\\",\\"img_title_slider\\":\\"Super Sale\\",\\"img_caption_slider\\":\\"Take advantage of our sale up to 30% off!\\"},{\\"img_url_slider\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/shoppe-elegant\\\\/files\\\\/2016\\\\/12\\\\/model-wear-earring-1024x683.jpg\\",\\"img_title_slider\\":\\"Best Quality\\",\\"img_caption_slider\\":\\"Check the beauties handcrafted by our masters.\\"}],\\"layout_slider\\":\\"slider-overlay\\",\\"img_w_slider\\":\\"1000\\",\\"img_fullwidth_slider\\":\\"fullwidth\\",\\"img_h_slider\\":\\"200\\",\\"visible_opt_slider\\":\\"1\\",\\"mob_visible_opt_slider\\":\\"0\\",\\"auto_scroll_opt_slider\\":\\"off\\",\\"scroll_opt_slider\\":\\"1\\",\\"speed_opt_slider\\":\\"normal\\",\\"effect_slider\\":\\"scroll\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"wrap_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"yes\\",\\"show_arrow_slider\\":\\"yes\\",\\"show_arrow_buttons_vertical\\":\\"vertical\\",\\"height_slider\\":\\"variable\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82c74c8\\",\\"unstick_when_el_mod_id\\":\\"75fb7dd\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#000000\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth\\"}},{\\"element_id\\":\\"fda69e9\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"ba1af5f\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"75fb7dd\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"margin_bottom\\":\\"25\\",\\"border-type\\":\\"top\\",\\"border_top_color\\":\\"e6e6e6\\",\\"border_top_width\\":\\"1\\",\\"border_right_color\\":\\"e6e6e6\\",\\"border_right_width\\":\\"1\\",\\"border_bottom_color\\":\\"e6e6e6\\",\\"border_bottom_width\\":\\"1\\",\\"border_left_color\\":\\"e6e6e6\\",\\"border_left_width\\":\\"1\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"b_c_c\\":\\"#000000_0.30\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/shoppe-elegant\\\\/files\\\\/2016\\\\/12\\\\/Green-Tourmaline-Ring.jpg\\",\\"width_image\\":\\"450\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"250\\",\\"title_image\\":\\"Rings\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/shoppe-elegant\\\\/product-category\\\\/ring\\\\/\\",\\"param_image\\":\\"regular\\",\\"alt_image\\":\\"Rings\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82c74c8\\",\\"unstick_when_el_mod_id\\":\\"4638dc4\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"a7aea41\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"49e1f12\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"6538138\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/shoppe-elegant\\\\/files\\\\/2016\\\\/12\\\\/pearl-earrings.jpg\\",\\"width_image\\":\\"250\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"200\\",\\"title_image\\":\\"Ear Rings\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/shoppe-elegant\\\\/product-category\\\\/earring\\\\/\\",\\"param_image\\":\\"regular\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_color\\":\\"e6e6e6\\",\\"border_top_width\\":\\"1\\",\\"border_right_color\\":\\"e6e6e6\\",\\"border_right_width\\":\\"1\\",\\"border_bottom_color\\":\\"e6e6e6\\",\\"border_bottom_width\\":\\"1\\",\\"border_left_color\\":\\"e6e6e6\\",\\"border_left_width\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"margin_bottom\\":\\"25\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"b_c_c\\":\\"#000000_0.30\\"}}]},{\\"element_id\\":\\"b313073\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"0a46d77\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/shoppe-elegant\\\\/files\\\\/2016\\\\/12\\\\/Love-Heart-Tag-Key.jpg\\",\\"width_image\\":\\"250\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"200\\",\\"title_image\\":\\"Necklets\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/shoppe-elegant\\\\/product-category\\\\/necklace\\\\/\\",\\"param_image\\":\\"regular\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_color\\":\\"e6e6e6\\",\\"border_top_width\\":\\"1\\",\\"border_right_color\\":\\"e6e6e6\\",\\"border_right_width\\":\\"1\\",\\"border_bottom_color\\":\\"e6e6e6\\",\\"border_bottom_width\\":\\"1\\",\\"border_left_color\\":\\"e6e6e6\\",\\"border_left_width\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"margin_bottom\\":\\"25\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"b_c_c\\":\\"#000000_0.30\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"5e6d142\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"2a7f29c\\",\\"mod_settings\\":{\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/shoppe-elegant\\\\/files\\\\/2016\\\\/12\\\\/bracelet-3.jpg\\",\\"width_image\\":\\"600\\",\\"height_image\\":\\"575\\",\\"title_image\\":\\"Bracelets\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/shoppe-elegant\\\\/product-category\\\\/bracelet\\\\/\\",\\"param_image\\":\\"regular\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"margin_bottom\\":\\"25\\",\\"border-type\\":\\"top\\",\\"border_top_color\\":\\"e6e6e6\\",\\"border_top_width\\":\\"1\\",\\"border_right_color\\":\\"e6e6e6\\",\\"border_right_width\\":\\"1\\",\\"border_bottom_color\\":\\"e6e6e6\\",\\"border_bottom_width\\":\\"1\\",\\"border_left_color\\":\\"e6e6e6\\",\\"border_left_width\\":\\"1\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"b_c_c\\":\\"#000000_0.30\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"border_top_color\\":\\"e6e6e6_1.00\\",\\"border_top_width\\":\\"1\\",\\"border_right_color\\":\\"e6e6e6_1.00\\",\\"border_right_width\\":\\"1\\",\\"border_bottom_color\\":\\"e6e6e6_1.00\\",\\"border_bottom_width\\":\\"1\\",\\"border_left_color\\":\\"e6e6e6_1.00\\",\\"border_left_width\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"border\\"}}],\\"column_alignment\\":\\"col_align_bottom\\",\\"gutter\\":\\"gutter-narrow\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82c74c8\\",\\"unstick_when_el_mod_id\\":\\"4638dc4\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"21e780b\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"b89fa3d\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 4194,
  'post_date' => '2015-06-19 19:23:10',
  'post_date_gmt' => '2015-06-19 19:23:10',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h1>The Menu<br/>Great Food Starts Here</h1>
 <h2>Breakfast</h2> 
 Chef Selection <h4>Bacon and Cheddar Omelette</h4> $14.95 <br /> Ham, red peppers, green peppers, red onions and cheddar cheese in a three egg omelette 
 <h4>Ham and Swiss Omelette</h4> $14.95 <br /> Three egg omelette with ham and swiss cheese 
 <h4>Deluxe Omelette</h4> $14.95 <br /> Bacan, sausage, ham, red peppers, green peppers, red onions, and mushrooms in a three egg omelette 
 <h4>Eggs Benedict</h4> $14.95 <br /> Poached eggs served on a toasted English muffin, layered with peameal bacon and topped with Hollandaise sauce. Served with breakfast potatoes 
 <h4>Eggs Florentine</h4> $14.95 <br /> Poached eggs served on a toasted English muffin, layered with cooked spinach and topped with Hollandaise sauce. Served with breakfast potatoes 
 <h4>Ham and Beacon Omelette</h4> $14.95 <br /> Three egg omelette with ham and beacon cheese 
 <h2>Lunch</h2> 
 <h4>Old Fashioned Burger</h4> $14.95 <br /> Prime rib burger, double-smoked bacon, aged Cheddar cheese, mayo 
 <h4>Mayan Burger</h4> $14.95 <br /> Prime rib burger, house-made avocado salsa 
 Chef Selection <h4>Farmhouse Burger</h4> $14.95 <br /> Prime rib burger, fried egg, peameat bacon 
 <h4>Spicy Thai Basil Noodle</h4> $14.95 <br /> Prawns, chicken, coconut milk and basic infused chili sauce 
 <h4>Old Fashioned Burger</h4> $14.95 <br /> Prime rib burger, double-smoked bacon, aged Cheddar cheese, mayo 
 <h4>Mayan Burger</h4> $14.95 <br /> Prime rib burger, house-made avocado salsa 
 <h4>Farmhouse Burger</h4> $14.95 <br /> Prime rib burger, fried egg, peameat bacon 
 <h4>Spicy Thai Basil Noodle</h4> $14.95 <br /> Prawns, chicken, coconut milk and basic infused chili sauce 
 <h2>Dinner</h2> 
 <h4>Old Fashioned Burger</h4> $14.95 <br /> Prime rib burger, double-smoked bacon, aged Cheddar cheese, mayo 
 <h4>Mayan Burger</h4> $14.95 <br /> Prime rib burger, house-made avocado salsa 
 Chef Selection <h4>Farmhouse Burger</h4> $14.95 <br /> Prime rib burger, fried egg, peameat bacon 
 <h4>Spicy Thai Basil Noodle</h4> $14.95 <br /> Prawns, chicken, coconut milk and basic infused chili sauce 
 <h4>Old Fashioned Burger</h4> $14.95 <br /> Prime rib burger, double-smoked bacon, aged Cheddar cheese, mayo 
 <h4>Mayan Burger</h4> $14.95 <br /> Prime rib burger, house-made avocado salsa 
 <h4>Farmhouse Burger</h4> $14.95 <br /> Prime rib burger, fried egg, peameat bacon 
 <h4>Spicy Thai Basil Noodle</h4> $14.95 <br /> Prawns, chicken, coconut milk and basic infused chili sauce 
 <h2>Drinks</h2> 
 <h4>Chocolate</h4> $14.95 <br /> Three egg omelette with ham and swiss cheese 
 <h4>Lime</h4> $14.95 <br /> Three egg omelette with ham and swiss cheese 
 <h4>Strawberry Rhubarb Parfait</h4> $14.95 <br /> Three egg omelette with ham and swiss cheese 
 <h4>Artisanal Cheese</h4> $14.95 <br /> Three egg omelette with ham and swiss cheese 
 <h4>Fruit</h4> $14.95 <br /> Three egg omelette with ham and swiss cheese 
 <h4>Artisanal melon</h4> $14.95 <br /> Three egg omelette with ham and swiss cheese 
 <h2>Compagne on us</h2> 
 <p>Every Monday, Tuesday and Wednesday evening, we’re offering groups of 10 or more that book an area in our bar a complimentary bottle of Champagne.</p> 
 <p>Call our reservations team on <a href="tel:027-8338-145">(027) 8338 145</a> or simply hit the button below for more information.</p> 
 <a href="https://themify.me/demo/themes/ultra-restaurant/contact-us/" >Contact Us</a><!--/themify_builder_static-->',
  'post_title' => 'Boxed Compact',
  'post_excerpt' => '',
  'post_name' => 'boxed-compact',
  'post_modified' => '2019-01-16 22:47:02',
  'post_modified_gmt' => '2019-01-16 22:47:02',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=4194',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'body_background_image' => 'https://themify.me/demo/themes/ultra/files/2018/06/food-background.jpg',
    'body_background_repeat' => 'fullcover',
    'color_design' => 'theme-color-burgundy',
    'header_design' => 'boxed-compact',
    'mobile_menu_styles' => 'default',
    'footer_design' => 'footer-left-col',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"2f53447\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"c2e8be8\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"cdcf59a\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"heading\\":\\"The Menu\\",\\"sub_heading\\":\\"Great Food Starts Here\\",\\"heading_tag\\":\\"h1\\",\\"text_alignment\\":\\"themify-text-center\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-restaurant\\\\/files\\\\/2016\\\\/08\\\\/breakfast-690128_1280.jpg\\",\\"background_repeat\\":\\"builder-parallax-scrolling\\",\\"background_color\\":\\"b8b8b8_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"000000_0.37\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"14\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"35\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"25\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"ebccfa1\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"7d8028d\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"5462f0b\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"content_text\\":\\"<h2>Breakfast<\\\\/h2>\\"}},{\\"element_id\\":\\"c01562d\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"4542863\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"781c03d\\",\\"mod_settings\\":{\\"background_color\\":\\"#ffe552_0.23\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Bacon and Cheddar Omelette\\",\\"description_service_menu\\":\\"Ham, red peppers, green peppers, red onions and cheddar cheese in a three egg omelette\\",\\"price_service_menu\\":\\"$14.95\\",\\"link_options\\":\\"regular\\",\\"highlight_service_menu\\":\\"highlight\\",\\"highlight_text_service_menu\\":\\"Chef Selection\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"9700e70\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Ham and Swiss Omelette\\",\\"description_service_menu\\":\\"Three egg omelette with ham and swiss cheese\\",\\"price_service_menu\\":\\"$14.95\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"84dad28\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Deluxe Omelette\\",\\"description_service_menu\\":\\"Bacan, sausage, ham, red peppers, green peppers, red onions, and mushrooms in a three egg omelette\\",\\"price_service_menu\\":\\"$14.95\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"38d7890\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"ef89928\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Eggs Benedict\\",\\"description_service_menu\\":\\"Poached eggs served on a toasted English muffin, layered with peameal bacon and topped with Hollandaise sauce. Served with breakfast potatoes\\",\\"price_service_menu\\":\\"$14.95\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"8122e6b\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Eggs Florentine\\",\\"description_service_menu\\":\\"Poached eggs served on a toasted English muffin, layered with cooked spinach and topped with Hollandaise sauce. Served with breakfast potatoes\\",\\"price_service_menu\\":\\"$14.95\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"a77173c\\",\\"mod_settings\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Ham and Beacon Omelette\\",\\"description_service_menu\\":\\"Three egg omelette with ham and beacon cheese\\",\\"price_service_menu\\":\\"$14.95\\",\\"link_options\\":\\"regular\\"}}]}]}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#fffae3\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"15294b2\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"6ae8058\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"353844d\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Lunch<\\\\/h2>\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-restaurant\\\\/files\\\\/2016\\\\/08\\\\/lunch-min-2-1024x256.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"000000_0.27\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"11.5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"8.5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"29b9280\\",\\"row_order\\":\\"3\\",\\"cols\\":[{\\"element_id\\":\\"47773f0\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"999c491\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Old Fashioned Burger\\",\\"description_service_menu\\":\\"Prime rib burger, double-smoked bacon, aged Cheddar cheese, mayo\\",\\"price_service_menu\\":\\"$14.95\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"65723c1\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Mayan Burger\\",\\"description_service_menu\\":\\"Prime rib burger, house-made avocado salsa\\",\\"price_service_menu\\":\\"$14.95\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"04d0a39\\",\\"mod_settings\\":{\\"background_color\\":\\"#ffe552_0.23\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Farmhouse Burger\\",\\"description_service_menu\\":\\"Prime rib burger, fried egg, peameat bacon\\",\\"price_service_menu\\":\\"$14.95\\",\\"link_options\\":\\"regular\\",\\"highlight_service_menu\\":\\"highlight\\",\\"highlight_text_service_menu\\":\\"Chef Selection\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"c713d9a\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Spicy Thai Basil Noodle\\",\\"description_service_menu\\":\\"Prawns, chicken, coconut milk and basic infused chili sauce\\",\\"price_service_menu\\":\\"$14.95\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"6d34238\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"3a189b1\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Old Fashioned Burger\\",\\"description_service_menu\\":\\"Prime rib burger, double-smoked bacon, aged Cheddar cheese, mayo\\",\\"price_service_menu\\":\\"$14.95\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"0d28ba7\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Mayan Burger\\",\\"description_service_menu\\":\\"Prime rib burger, house-made avocado salsa\\",\\"price_service_menu\\":\\"$14.95\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"1d1e1d9\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Farmhouse Burger\\",\\"description_service_menu\\":\\"Prime rib burger, fried egg, peameat bacon\\",\\"price_service_menu\\":\\"$14.95\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"622721e\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Spicy Thai Basil Noodle\\",\\"description_service_menu\\":\\"Prawns, chicken, coconut milk and basic infused chili sauce\\",\\"price_service_menu\\":\\"$14.95\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"d522327\\",\\"row_order\\":\\"4\\",\\"cols\\":[{\\"element_id\\":\\"7196f2a\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"b9b3e8e\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Dinner<\\\\/h2>\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-restaurant\\\\/files\\\\/2016\\\\/08\\\\/dinner-min-1-1024x256.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"000000_0.27\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"11.5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"8.5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"8141871\\",\\"row_order\\":\\"5\\",\\"cols\\":[{\\"element_id\\":\\"90f4708\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"9be0a08\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Old Fashioned Burger\\",\\"description_service_menu\\":\\"Prime rib burger, double-smoked bacon, aged Cheddar cheese, mayo\\",\\"price_service_menu\\":\\"$14.95\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"49afff7\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Mayan Burger\\",\\"description_service_menu\\":\\"Prime rib burger, house-made avocado salsa\\",\\"price_service_menu\\":\\"$14.95\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"35feed1\\",\\"mod_settings\\":{\\"background_color\\":\\"#ffe552_0.23\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Farmhouse Burger\\",\\"description_service_menu\\":\\"Prime rib burger, fried egg, peameat bacon\\",\\"price_service_menu\\":\\"$14.95\\",\\"link_options\\":\\"regular\\",\\"highlight_service_menu\\":\\"highlight\\",\\"highlight_text_service_menu\\":\\"Chef Selection\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"00f48c2\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Spicy Thai Basil Noodle\\",\\"description_service_menu\\":\\"Prawns, chicken, coconut milk and basic infused chili sauce\\",\\"price_service_menu\\":\\"$14.95\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"ce70e1e\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"467f9ec\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Old Fashioned Burger\\",\\"description_service_menu\\":\\"Prime rib burger, double-smoked bacon, aged Cheddar cheese, mayo\\",\\"price_service_menu\\":\\"$14.95\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"b3c0cc6\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Mayan Burger\\",\\"description_service_menu\\":\\"Prime rib burger, house-made avocado salsa\\",\\"price_service_menu\\":\\"$14.95\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"c491ee8\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Farmhouse Burger\\",\\"description_service_menu\\":\\"Prime rib burger, fried egg, peameat bacon\\",\\"price_service_menu\\":\\"$14.95\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"6419c35\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Spicy Thai Basil Noodle\\",\\"description_service_menu\\":\\"Prawns, chicken, coconut milk and basic infused chili sauce\\",\\"price_service_menu\\":\\"$14.95\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"cfc68bb\\",\\"row_order\\":\\"6\\",\\"cols\\":[{\\"element_id\\":\\"42ddb34\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"6397790\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"content_text\\":\\"<h2>Drinks<\\\\/h2>\\"}},{\\"element_id\\":\\"7a2c52c\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"11ccc23\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"806ffbf\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Chocolate\\",\\"description_service_menu\\":\\"Three egg omelette with ham and swiss cheese\\",\\"price_service_menu\\":\\"$14.95\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"d397533\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"c7cabb9\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Lime\\",\\"description_service_menu\\":\\"Three egg omelette with ham and swiss cheese\\",\\"price_service_menu\\":\\"$14.95\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"60128ad\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"60626d7\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Strawberry Rhubarb Parfait\\",\\"description_service_menu\\":\\"Three egg omelette with ham and swiss cheese\\",\\"price_service_menu\\":\\"$14.95\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}]},{\\"element_id\\":\\"8eef4ee\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"c78fcaa\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"ad781c1\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Artisanal Cheese\\",\\"description_service_menu\\":\\"Three egg omelette with ham and swiss cheese\\",\\"price_service_menu\\":\\"$14.95\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"a21df66\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"5d507ba\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Fruit\\",\\"description_service_menu\\":\\"Three egg omelette with ham and swiss cheese\\",\\"price_service_menu\\":\\"$14.95\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"bfb0baa\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"service-menu\\",\\"element_id\\":\\"3675fe6\\",\\"mod_settings\\":{\\"style_service_menu\\":\\"image-center\\",\\"title_service_menu\\":\\"Artisanal melon\\",\\"description_service_menu\\":\\"Three egg omelette with ham and swiss cheese\\",\\"price_service_menu\\":\\"$14.95\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}]}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#fff5e0\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"2179759\\",\\"row_order\\":\\"7\\",\\"cols\\":[{\\"element_id\\":\\"0cc6459\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"527dfee\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h2>Compagne on us<\\\\/h2>\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"b61b94d\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"font_size\\":\\"1.2\\",\\"font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<p>Every Monday, Tuesday and Wednesday evening, we’re offering groups of 10 or more that book an area in our bar a complimentary bottle of Champagne.<\\\\/p>\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"7cfc6ea\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"20\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<p>Call our reservations team on <a href=\\\\\\\\\\\\\\"tel:027-8338-145\\\\\\\\\\\\\\">(027) 8338 145<\\\\/a> or simply hit the button below for more information.<\\\\/p>\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"81d9fa8\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"link_color\\":\\"#ffffff\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"large\\",\\"buttons_style\\":\\"outline\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Contact Us\\",\\"link\\":\\"https://themify.me/demo/themes/ultra-restaurant\\\\/contact-us\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"yellow\\",\\"icon_alignment\\":\\"left\\"}]}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_right\\":\\"7\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"7\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_right\\":\\"0\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"0\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\"}}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-restaurant\\\\/files\\\\/2016\\\\/08\\\\/bg-min-1.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"000000_0.63\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff\\",\\"text_align\\":\\"center\\",\\"link_color\\":\\"#ffd561\\",\\"padding_top\\":\\"3.75\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"6.5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"2364b6e\\",\\"row_order\\":\\"8\\",\\"cols\\":[{\\"element_id\\":\\"54cf0f5\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3391,
  'post_date' => '2015-04-16 20:30:26',
  'post_date_gmt' => '2015-04-16 20:30:26',
  'post_content' => '<!--themify_builder_static--><h1>Services</h1> 
 <p>Accounting is a premier accounting firm which provides taxation, accounting and bookkeeping services in the Greater Toronto Area.</p> 
<h2>Tax Compliance & Planning<br/></h2>
 <img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/computerized.png" title="Computerized Bookkeeping " alt="Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a." /> <h3> Computerized Bookkeeping & Accounting </h3> Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a. 
 <img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/incorporation.png" title="Business Registration / Incorporation" alt="Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a." /> <h3> Business Registration / Incorporation </h3> Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a. 
 <img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/tax.png" title="Tax Services " alt="Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a." /> <h3> Tax Services & Returns Rectification </h3> Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a. 
 <img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/cra-audit.png" title="Assistance with CRA audits " alt="Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a." /> <h3> Assistance with CRA audits & matters </h3> Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a. 
 <img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/business-registration.png" title="Business Registration / Incorporation" alt="Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a." /> <h3> Business Registration / Incorporation </h3> Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a. 
 <img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/pay-roll.png" title="Employee Payroll Services, GST/HST " alt="Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a." /> <h3> Employee Payroll Services, GST/HST & W.S.I.B </h3> Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a. 
<h2>Other Services<br/></h2>
 <img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/bookkeeping-icon.png" title="Bookkeeping" alt="Bookkeeping" /> <h3> Bookkeeping </h3> 
 <img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/purchase-icon.png" title="Purchase / Sale of a Business" alt="Purchase / Sale of a Business" /> <h3> Purchase / Sale of a Business </h3> 
 <img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/payroll-icon.png" title="Payroll Compliance" alt="Payroll Compliance" /> <h3> Payroll Compliance </h3> 
 <img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/business-plan-icon.png" title="Business Plans and Forecasts" alt="Business Plans and Forecasts" /> <h3> Business Plans and Forecasts </h3> 
 <img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/diligence-icon.png" title="Due Diligence Procedures" alt="Due Diligence Procedures" /> <h3> Due Diligence Procedures </h3> 
 <img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/task-provision-icon.png" title="Tax Provision Preparation " alt="Tax Provision Preparation " /> <h3> Tax Provision Preparation & Review </h3> 
 <img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/assistance-icon.png" title="Assistance with Obtaining Financing" alt="Assistance with Obtaining Financing" /> <h3> Assistance with Obtaining Financing </h3> 
 <img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/merger-icon.png" title="Mergers " alt="Mergers " /> <h3> Mergers & Acquisitions </h3> 
 <img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/strategic-icon.png" title="Strategic Tax Planning" alt="Strategic Tax Planning" /> <h3> Strategic Tax Planning </h3> 
 <ul data-id="testimonial-slider-0-" data-visible="1" data-mob-visible="" data-scroll="1" data-auto-scroll="off" data-speed="1" data-wrap="yes" data-arrow="yes" data-pagination="no" data-effect="cover-fade" data-height="variable" data-pause-on-hover="resume" > <li> 
 <h3>I am glad I switched over to Electro Accounting. In my very first year, I found I could claim expenses I never thought I could. Even better, I got a refund. Something I never got dealing with so called “Professionals”.</h3> <figure><img src="https://themify.me/demo/themes/ultra-accountant/files/2017/03/jonathan-doe.png" alt="I am glad I switched over to Electro Accounting. In my very first year, I found I could claim expenses I never thought I could. Even better, I got a refund. Something I never got dealing with so called “Professionals”." /></figure> Jonathan Doe Director of Technical Support at Shopify </li> <li> 
 <h3>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent dapibus sodales accumsan. Maecenas vulputate erat, sed varius ipsum velit sed odio.</h3> <figure><img src="https://themify.me/demo/themes/ultra-accountant/files/2017/03/person-1.png" alt="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent dapibus sodales accumsan. Maecenas vulputate erat, sed varius ipsum velit sed odio." /></figure> Dennise King CEO Landmark Corporation </li> <li> 
 <h3>Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Similique suscipit, id ducimus illum corporis pariatur.</h3> <figure><img src="https://themify.me/demo/themes/ultra-accountant/files/2017/03/person-2.png" alt="Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Similique suscipit, id ducimus illum corporis pariatur." /></figure> Robert Gill Vice President Wheel Spain Ltd </li> <li> 
 <h3>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae.</h3> <figure><img src="https://themify.me/demo/themes/ultra-accountant/files/2017/03/person-3.png" alt="Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae." /></figure> Juli Smith Manager County Road Association </li> </ul> 
 <h4>Contact Us Today</h4> <h2>Get free tax consultation</h2> 
 <a href="/contant-us" >Contact Us</a><!--/themify_builder_static-->',
  'post_title' => 'Boxed Content',
  'post_excerpt' => '',
  'post_name' => 'boxed-content',
  'post_modified' => '2019-03-07 08:48:21',
  'post_modified_gmt' => '2019-03-07 08:48:21',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=3391',
  'menu_order' => 3,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'body_background_repeat' => 'fullcover',
    'header_design' => 'boxed-content',
    'mobile_menu_styles' => 'default',
    'footer_design' => 'footer-left-col',
    'more_posts' => 'pagination',
    'posts_per_page' => '2',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"173dcb6\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"6de8087\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"b72b565\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"padding_right\\":\\"4\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"4\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"font_family_h1\\":\\"Abril Fatface\\",\\"content_text\\":\\"<h1>Services<\\\\/h1>\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"10142fb\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_repeat\\":\\"repeat\\",\\"font_size\\":\\"1.3\\",\\"font_size_unit\\":\\"em\\",\\"line_height\\":\\"1.7\\",\\"line_height_unit\\":\\"em\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"breakpoint_tablet_landscape\\":{\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_right\\":\\"20\\",\\"margin_left\\":\\"20\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_right\\":\\"30\\",\\"margin_left\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_right\\":\\"40\\",\\"margin_left\\":\\"40\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"content_text\\":\\"<p>Accounting is a premier accounting firm which provides taxation, accounting and bookkeeping services in the Greater Toronto Area.<\\\\/p>\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-accountant\\\\/files\\\\/2017\\\\/03\\\\/servicebg.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"21456b_0.78\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff\\",\\"text_align\\":\\"center\\",\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"12\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"12\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_width\\":\\"fullwidth\\",\\"custom_css_row\\":\\"vertical-divider\\"}},{\\"element_id\\":\\"10641c5\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"b68580c\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"8537d53\\",\\"mod_settings\\":{\\"heading\\":\\"Tax Compliance & Planning\\",\\"heading_tag\\":\\"h2\\",\\"text_alignment\\":\\"themify-text-center\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"20\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"86d50e9\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"daa5be3\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"8a09de0\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/computerized.png\\",\\"title_image\\":\\"Computerized Bookkeeping & Accounting\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a.\\",\\"animation_effect\\":\\"zoomIn\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"558a6ea\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"f1e64ec\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/incorporation.png\\",\\"title_image\\":\\"Business Registration \\\\/ Incorporation\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a.\\",\\"animation_effect\\":\\"zoomIn\\",\\"animation_effect_delay\\":\\".2\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"71b1aa8\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"d817478\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/tax.png\\",\\"title_image\\":\\"Tax Services & Returns Rectification\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a.\\",\\"animation_effect\\":\\"zoomIn\\",\\"animation_effect_delay\\":\\".4\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_css_column\\":\\"border-first\\"}},{\\"element_id\\":\\"29288f7\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"df6920d\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"d381944\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/cra-audit.png\\",\\"title_image\\":\\"Assistance with CRA audits & matters\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a.\\",\\"animation_effect\\":\\"zoomIn\\",\\"animation_effect_delay\\":\\".6\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"f8ebd80\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"6837775\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/business-registration.png\\",\\"title_image\\":\\"Business Registration \\\\/ Incorporation\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a.\\",\\"animation_effect\\":\\"zoomIn\\",\\"animation_effect_delay\\":\\".8\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"c5e803b\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"155b6f6\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/pay-roll.png\\",\\"title_image\\":\\"Employee Payroll Services, GST\\\\/HST & W.S.I.B\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a.\\",\\"animation_effect\\":\\"zoomIn\\",\\"animation_effect_delay\\":\\"1\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}}]}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"7.5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"4\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"9\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"4\\",\\"padding_left_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet_landscape\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"70\\",\\"padding_bottom\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"70\\",\\"padding_bottom\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"custom_css_row\\":\\"accounting-services compliance-planning\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"173dcb6\\",\\"unstick_when_el_mod_id\\":\\"b72b565\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"14f372a\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"b85fe16\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"8859673\\",\\"mod_settings\\":{\\"heading\\":\\"Other Services\\",\\"heading_tag\\":\\"h2\\",\\"text_alignment\\":\\"themify-text-center\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"element_id\\":\\"99193c9\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"fc6139e\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"476fa04\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/bookkeeping-icon.png\\",\\"title_image\\":\\"Bookkeeping\\",\\"param_image\\":\\"regular\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeIn\\"}}]},{\\"element_id\\":\\"6a1db4c\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"379f803\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/purchase-icon.png\\",\\"title_image\\":\\"Purchase \\\\/ Sale of a Business\\",\\"param_image\\":\\"regular\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeIn\\",\\"animation_effect_delay\\":\\".1\\"}}]},{\\"element_id\\":\\"b446da3\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"1c31ebb\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/payroll-icon.png\\",\\"title_image\\":\\"Payroll Compliance\\",\\"param_image\\":\\"regular\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeIn\\",\\"animation_effect_delay\\":\\".2\\"}}]}],\\"gutter\\":\\"gutter-narrow\\"},{\\"element_id\\":\\"f537372\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"8507a8c\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"7068cc3\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/business-plan-icon.png\\",\\"title_image\\":\\"Business Plans and Forecasts\\",\\"param_image\\":\\"regular\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeIn\\",\\"animation_effect_delay\\":\\".3\\"}}]},{\\"element_id\\":\\"614e74c\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"b7c49c7\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/diligence-icon.png\\",\\"title_image\\":\\"Due Diligence Procedures\\",\\"param_image\\":\\"regular\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeIn\\",\\"animation_effect_delay\\":\\".4\\"}}]},{\\"element_id\\":\\"33f6a44\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"949e66b\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/task-provision-icon.png\\",\\"title_image\\":\\"Tax Provision Preparation & Review\\",\\"param_image\\":\\"regular\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeIn\\",\\"animation_effect_delay\\":\\".5\\"}}]}],\\"gutter\\":\\"gutter-narrow\\"},{\\"element_id\\":\\"a17c427\\",\\"row_order\\":\\"3\\",\\"cols\\":[{\\"element_id\\":\\"f13c25a\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"6588771\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/assistance-icon.png\\",\\"title_image\\":\\"Assistance with Obtaining Financing\\",\\"param_image\\":\\"regular\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeIn\\",\\"animation_effect_delay\\":\\".6\\"}}]},{\\"element_id\\":\\"eabc6af\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"200d6f1\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/merger-icon.png\\",\\"title_image\\":\\"Mergers & Acquisitions\\",\\"param_image\\":\\"regular\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeIn\\",\\"animation_effect_delay\\":\\".7\\"}}]},{\\"element_id\\":\\"9dc458b\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"907ab3b\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/strategic-icon.png\\",\\"title_image\\":\\"Strategic Tax Planning\\",\\"param_image\\":\\"regular\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeIn\\",\\"animation_effect_delay\\":\\".8\\"}}]}],\\"gutter\\":\\"gutter-narrow\\"}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"4\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"9\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"4\\",\\"padding_left_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"70\\",\\"padding_bottom\\":\\"70\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"padding_bottom\\":\\"60\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"custom_css_row\\":\\"other-services\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"173dcb6\\",\\"unstick_when_el_mod_id\\":\\"b72b565\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"49da3c0\\",\\"row_order\\":\\"3\\",\\"cols\\":[{\\"element_id\\":\\"d74fd44\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"testimonial-slider\\",\\"element_id\\":\\"3e6c77b\\",\\"mod_settings\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"layout_testimonial\\":\\"image-bottom\\",\\"tab_content_testimonial\\":[{\\"title_testimonial\\":\\"I am glad I switched over to Electro Accounting. In my very first year, I found I could claim expenses I never thought I could. Even better, I got a refund. Something I never got dealing with so called “Professionals”.\\",\\"person_picture_testimonial\\":\\"https://themify.me/demo/themes/ultra-accountant\\\\/files\\\\/2017\\\\/03\\\\/jonathan-doe.png\\",\\"person_name_testimonial\\":\\"Jonathan Doe\\",\\"person_position_testimonial\\":\\"Director of Technical Support at Shopify\\"},{\\"title_testimonial\\":\\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent dapibus sodales accumsan. Maecenas vulputate erat, sed varius ipsum velit sed odio.\\",\\"person_picture_testimonial\\":\\"https://themify.me/demo/themes/ultra-accountant\\\\/files\\\\/2017\\\\/03\\\\/person-1.png\\",\\"person_name_testimonial\\":\\"Dennise King\\",\\"person_position_testimonial\\":\\"CEO\\",\\"company_testimonial\\":\\"Landmark Corporation\\"},{\\"title_testimonial\\":\\"Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Similique suscipit, id ducimus illum corporis pariatur.\\",\\"person_picture_testimonial\\":\\"https://themify.me/demo/themes/ultra-accountant\\\\/files\\\\/2017\\\\/03\\\\/person-2.png\\",\\"person_name_testimonial\\":\\"Robert Gill\\",\\"person_position_testimonial\\":\\"Vice President\\",\\"company_testimonial\\":\\"Wheel Spain Ltd\\"},{\\"title_testimonial\\":\\"Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae.\\",\\"person_picture_testimonial\\":\\"https://themify.me/demo/themes/ultra-accountant\\\\/files\\\\/2017\\\\/03\\\\/person-3.png\\",\\"person_name_testimonial\\":\\"Juli Smith\\",\\"person_position_testimonial\\":\\"Manager\\",\\"company_testimonial\\":\\"County Road Association\\"}],\\"visible_opt_slider\\":\\"1\\",\\"auto_scroll_opt_slider\\":\\"off\\",\\"scroll_opt_slider\\":\\"1\\",\\"speed_opt_slider\\":\\"normal\\",\\"effect_slider\\":\\"cover-fade\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"wrap_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"no\\",\\"show_arrow_slider\\":\\"yes\\",\\"show_arrow_buttons_vertical\\":\\"vertical\\",\\"height_slider\\":\\"variable\\",\\"css_testimonial\\":\\"testimonials\\",\\"animation_effect\\":\\"fadeInUp\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_right\\":\\"20\\",\\"padding_left\\":\\"20\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"background_type\\":\\"image\\",\\"background_color\\":\\"22436c_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"5.5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5.5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet_landscape\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"padding_bottom\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"e981bfb\\",\\"row_order\\":\\"4\\",\\"cols\\":[{\\"element_id\\":\\"ab93da7\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"a1cbe66\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"padding_right\\":\\"4\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"4\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h4>Contact Us Today<\\\\/h4>\\\\n<h2>Get free tax consultation<\\\\/h2>\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"5f46ccb\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"1.3\\",\\"margin_top_unit\\":\\"em\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"xlarge\\",\\"buttons_style\\":\\"rounded\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Contact Us\\",\\"link\\":\\"\\\\/contant-us\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"blue\\",\\"icon_alignment\\":\\"left\\"}]}}]}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"6.15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"6.85\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"padding_bottom\\":\\"60\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"50\\",\\"padding_bottom\\":\\"60\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"row_width\\":\\"fullwidth-content\\",\\"custom_css_row\\":\\"about-team\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"173dcb6\\",\\"unstick_when_el_mod_id\\":\\"b72b565\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"92e3ca2\\",\\"row_order\\":\\"5\\",\\"cols\\":[{\\"element_id\\":\\"59e2da4\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3393,
  'post_date' => '2015-04-16 20:31:49',
  'post_date_gmt' => '2015-04-16 20:31:49',
  'post_content' => '<!--themify_builder_static--><h1>We are a professional Web and Development solutions company.</h1> <h2>Together we\'ll achieve your company\'s dreams.</h2>
<a href="https://themify.me/demo/themes/ultra/" > View Demos </a> <a href="https://themify.me/themes" > Browse Themes </a>
<img src="https://themify.me/demo/themes/ultra-agency-2/files/2019/02/header-web-image.png" width="740" alt="" />
<h3>01.<br/></h3>
<h3>Our Purpose</h3>
<h3>Our goal is to inspire and unleash the collective genius of our people and our clients.</h3>
<a href="https://themify.me/demo/themes/ultra-agency-2/about/" > See More </a>
<img src="https://themify.me/demo/themes/ultra-agency-2/files/2019/02/about-us-home-img-880x626.jpg" width="880" alt="" />
<img src="https://themify.me/demo/themes/ultra-agency-2/files/2019/02/meubel-web-design-765x926.jpg" width="765" alt="" />
<h3>02.<br/></h3>
<h3>What We Do</h3>
<p>We create digital products and services, from branding, to web creation, and marketing.</p>
<h4>Services :</h4>
<ul> <li>Branding + Logo Design</li> <li>Web Design + Development</li> <li>Content Creation</li> <li>eCommerce Optimization</li> <li>Full Service Marketing </li> </ul>
<h3>03.<br/></h3>
<h3>Our Recent Works</h3>
<h3>We take on projects we love and are passionate about. See which clients we\'ve helped, boosting their digital and product capabilities.</h3>

<img src="https://themify.me/demo/themes/ultra-agency-2/files/2019/02/testimonial-home-image-550x736.jpg" width="550" alt="" />
<h3>04.<br/></h3>
<h3>Say Hi to Our Clients</h3>
<h3>We\'ve been honoured to create brands, devise products, and launch campaigns for many clients we now call friends. We like them, and they seem to like us back.</h3>
<ul data-id="testimonial-slider-0-" data-visible="1" data-mob-visible="0" data-scroll="1" data-auto-scroll="off" data-speed="1" data-wrap="yes" data-arrow="yes" data-pagination="yes" data-effect="scroll" data-height="variable" data-pause-on-hover="resume" > <li> 
 <p>I choose Ultra Agency II because they have a personal approach and warm attitude towards their clients big or small. They are flexible and easy to communicate with.</p> Mark Stevensson CEO Digimoto </li> <li> 
 <p>We have been working with Ultra Agency II for 10 Years. They have the rare ability to translate complex ideas into simple and elegant designs. They\'ve helped define our vision.</p> Alice Silverstein Product Manager Google </li> </ul><!--/themify_builder_static-->',
  'post_title' => 'Boxed Layout',
  'post_excerpt' => '',
  'post_name' => 'boxed-layout',
  'post_modified' => '2019-05-31 16:34:59',
  'post_modified_gmt' => '2019-05-31 16:34:59',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=3393',
  'menu_order' => 4,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'body_background_image' => 'https://themify.me/demo/themes/ultra/files/2018/06/demoimage56.jpg',
    'body_background_repeat' => 'fullcover',
    'color_design' => 'theme-color-black',
    'header_design' => 'boxed-layout',
    'mobile_menu_styles' => 'default',
    'footer_design' => 'footer-block',
    'more_posts' => 'pagination',
    'posts_per_page' => '2',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"08c1fab\\",\\"cols\\":[{\\"element_id\\":\\"91353a9\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"63f11c7\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_size_h1\\":\\"3.3\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"1.6\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_size_h1\\":\\"2.5\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"1.2\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_size_h1\\":\\"2\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"1.1\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_size_h1\\":\\"2.5\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"1.4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<h1>We are a professional Web and Development solutions company.<\\\\/h1>\\\\n<h2>Together we\\\\\\\\\\\'ll achieve your company\\\\\\\\\\\'s dreams.<\\\\/h2>\\",\\"stick_at_position\\":\\"top\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"4b22d6e\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\",\\"buttons_size\\":\\"large\\",\\"buttons_shape\\":\\"rounded\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"View Demos\\",\\"link\\":\\"https://themify.me/demo/themes/ultra\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"light-green\\",\\"icon_alignment\\":\\"left\\"},{\\"label\\":\\"Browse Themes\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/themes\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"light-green\\"}],\\"stick_at_position\\":\\"top\\"}},{\\"element_id\\":\\"4ceacae\\",\\"cols\\":[{\\"element_id\\":\\"b4748a9\\",\\"grid_class\\":\\"col3-1\\"},{\\"element_id\\":\\"a24f3cb\\",\\"grid_class\\":\\"col3-2\\"}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_left\\":\\"70\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_left\\":\\"6\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_left\\":\\"3\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"margin_bottom\\":\\"50\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"99f36a7\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"8c8be6a\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"-20\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-right\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-agency-2\\\\/files\\\\/2019\\\\/02\\\\/header-web-image.png\\",\\"width_image\\":\\"740\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"2\\",\\"stick_at_position\\":\\"top\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column4-2\\",\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-agency-2\\\\/files\\\\/2019\\\\/04\\\\/bg-hero-purple.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"background_color\\":\\"#7d50fc\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#ffffff\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth-content\\",\\"stick_at_position\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"100\\",\\"border-type\\":\\"top\\"},\\"background_zoom\\":\\"\\"}},{\\"element_id\\":\\"163ef4a\\",\\"cols\\":[{\\"element_id\\":\\"b19c918\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"7c9a325\\",\\"cols\\":[{\\"element_id\\":\\"dae00a7\\",\\"grid_class\\":\\"col3-1\\"},{\\"element_id\\":\\"f29d0ca\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"1f3b577\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1.4\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"font_size_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\",\\"d_width\\":\\"100\\",\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_left\\":\\"10\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1.2\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"font_size_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"font_size_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"font_size_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\"},\\"heading\\":\\"01.\\",\\"heading_tag\\":\\"h3\\",\\"text_alignment\\":\\"themify-text-left\\",\\"stick_at_position\\":\\"top\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"34b81c3\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"3\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"2.5\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"2.2\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"2.3\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<h3>Our Purpose<\\\\/h3>\\",\\"stick_at_position\\":\\"top\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"8n6d766\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"1.2\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"1.2\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<h3>Our goal is to inspire and unleash the collective genius of our people and our clients.<\\\\/h3>\\",\\"stick_at_position\\":\\"top\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"2974426\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\",\\"buttons_size\\":\\"normal\\",\\"buttons_shape\\":\\"rounded\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"See More\\",\\"link\\":\\"https://themify.me/demo/themes/ultra-agency-2\\\\/about\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"purple\\",\\"icon_alignment\\":\\"left\\"}],\\"stick_at_position\\":\\"top\\"}}]}],\\"col_tablet_landscape\\":\\"column4-1-4-3\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-agency-2\\\\/files\\\\/2019\\\\/02\\\\/bg-dots.jpg\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"80\\",\\"padding_right\\":\\"10\\",\\"padding_bottom\\":\\"80\\",\\"padding_left\\":\\"40\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_right\\":\\"30\\",\\"padding_bottom\\":\\"80\\",\\"padding_left\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"6b32a02\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"0182dc6\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-right\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-agency-2\\\\/files\\\\/2019\\\\/02\\\\/about-us-home-img-880x626.jpg\\",\\"width_image\\":\\"880\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"3\\",\\"stick_at_position\\":\\"top\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"column_alignment\\":\\"col_align_middle\\",\\"col_tablet_landscape\\":\\"column4-2\\",\\"col_tablet\\":\\"column4-2\\",\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"50\\",\\"padding_bottom\\":\\"0\\",\\"border-type\\":\\"top\\"},\\"row_width\\":\\"fullwidth-content\\",\\"stick_at_position\\":\\"top\\"}},{\\"element_id\\":\\"6418bbd\\",\\"cols\\":[{\\"element_id\\":\\"4ae7bc6\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"8b9735a\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-agency-2\\\\/files\\\\/2019\\\\/02\\\\/meubel-web-design-765x926.jpg\\",\\"width_image\\":\\"765\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"3\\",\\"stick_at_position\\":\\"top\\"}}]},{\\"element_id\\":\\"af717c0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"0035668\\",\\"cols\\":[{\\"element_id\\":\\"6e9e98c\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"tmyn768\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1.4\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"font_size_subheading\\":\\"1.2\\",\\"font_size_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\",\\"d_width\\":\\"100\\",\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_left\\":\\"-70\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1.2\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"font_size_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_left\\":\\"-80\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1\\",\\"font_size_unit\\":\\"em\\",\\"font_size_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_left\\":\\"0\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"font_size_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\"},\\"heading\\":\\"02.\\",\\"heading_tag\\":\\"h3\\",\\"text_alignment\\":\\"themify-text-left\\",\\"stick_at_position\\":\\"top\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"795e063\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"3\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"2.5\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"2.2\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"2.3\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<h3>What We Do<\\\\/h3>\\",\\"stick_at_position\\":\\"top\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"cop9769\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"1.2\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"1.2\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<p>We create digital products and services, from branding, to web creation, and marketing.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"8092880\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>Services :<\\\\/h4>\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"dropcap_border-type\\":\\"top\\"},\\"stick_at_position\\":\\"top\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"b67j769\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#01cab6\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_gradient_color_h4-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"h4_margin_bottom\\":\\"20\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<ul>\\\\n<li>Branding + Logo Design<\\\\/li>\\\\n<li>Web Design + Development<\\\\/li>\\\\n<li>Content Creation<\\\\/li>\\\\n<li>eCommerce Optimization<\\\\/li>\\\\n<li>Full Service Marketing <\\\\/li>\\\\n<\\\\/ul>\\",\\"stick_at_position\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}]},{\\"element_id\\":\\"b3e415b\\",\\"grid_class\\":\\"col3-1\\"}],\\"col_tablet_landscape\\":\\"column4-3-4-1\\",\\"col_tablet\\":\\"column-full\\"}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_right\\":\\"30\\",\\"padding_left\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_right\\":\\"30\\",\\"padding_left\\":\\"10\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}}],\\"column_alignment\\":\\"col_align_middle\\",\\"mobile_dir\\":\\"rtl\\",\\"col_tablet_landscape\\":\\"column4-2\\",\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"70\\",\\"padding_bottom\\":\\"20\\",\\"border-type\\":\\"top\\"},\\"row_width\\":\\"fullwidth-content\\",\\"stick_at_position\\":\\"top\\"}},{\\"element_id\\":\\"72nu747\\",\\"cols\\":[{\\"element_id\\":\\"2tjv769\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"q1j9770\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1.4\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"font_size_subheading\\":\\"1.2\\",\\"font_size_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\",\\"d_width\\":\\"100\\",\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_left\\":\\"10\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1.2\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"font_size_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1.1\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"font_size_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_left\\":\\"0\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"font_size_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\"},\\"heading\\":\\"03.\\",\\"heading_tag\\":\\"h3\\",\\"text_alignment\\":\\"themify-text-left\\",\\"stick_at_position\\":\\"top\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"d3c97df\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"3\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"2.5\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"2.3\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<h3>Our Recent Works<\\\\/h3>\\",\\"stick_at_position\\":\\"top\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"y81n770\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"60\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"1.3\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"50\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"1.2\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<h3>We take on projects we love and are passionate about. See which clients we\\\\\\\\\\\'ve helped, boosting their digital and product capabilities.<\\\\/h3>\\",\\"stick_at_position\\":\\"top\\"}},{\\"mod_name\\":\\"portfolio\\",\\"element_id\\":\\"e2595ce\\",\\"mod_settings\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"layout_portfolio\\":\\"grid3\\",\\"type_query_portfolio\\":\\"category\\",\\"category_portfolio\\":\\"0|multiple\\",\\"post_per_page_portfolio\\":\\"9\\",\\"order_portfolio\\":\\"desc\\",\\"orderby_portfolio\\":\\"date\\",\\"display_portfolio\\":\\"none\\",\\"img_width_portfolio\\":\\"360\\",\\"img_height_portfolio\\":\\"260\\",\\"hide_post_title_portfolio\\":\\"yes\\",\\"hide_post_date_portfolio\\":\\"yes\\",\\"hide_post_meta_portfolio\\":\\"yes\\",\\"stick_at_position\\":\\"top\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_right\\":\\"20\\",\\"padding_left\\":\\"20\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_right\\":\\"30\\",\\"padding_left\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-agency-2\\\\/files\\\\/2019\\\\/02\\\\/bg-abstract-lines-left.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"2\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"0\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"0\\",\\"border-type\\":\\"top\\"},\\"stick_at_position\\":\\"top\\",\\"row_width\\":\\"fullwidth\\"}},{\\"element_id\\":\\"8bb31d8\\",\\"cols\\":[{\\"element_id\\":\\"8c4fc04\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"6c96bd9\\",\\"cols\\":[{\\"element_id\\":\\"b5c5bac\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"13c4af6\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"50\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"50\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"},\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-agency-2\\\\/files\\\\/2019\\\\/02\\\\/testimonial-home-image-550x736.jpg\\",\\"width_image\\":\\"550\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"2\\",\\"custom_parallax_scroll_reverse\\":\\"reverse\\",\\"stick_at_position\\":\\"top\\",\\"custom_parallax_scroll_zindex\\":\\"3\\"}}]},{\\"element_id\\":\\"1022dd9\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"cqxp771\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1.4\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"font_size_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\",\\"d_width\\":\\"100\\",\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1.2\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"font_size_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"font_size_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_left\\":\\"0\\",\\"border-type\\":\\"top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"font_size_subheading_unit\\":\\"em\\",\\"d_border-type\\":\\"top\\"},\\"heading\\":\\"04.\\",\\"heading_tag\\":\\"h3\\",\\"text_alignment\\":\\"themify-text-left\\",\\"stick_at_position\\":\\"top\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"9105589\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"3\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"2.5\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_right\\":\\"30\\",\\"padding_left\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"2.3\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<h3>Say Hi to Our Clients<\\\\/h3>\\",\\"stick_at_position\\":\\"top\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"b1b733b\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"100\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"1.3\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"padding_right\\":\\"30\\",\\"padding_left\\":\\"30\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"1.2\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<h3>We\\\\\\\\\\\'ve been honoured to create brands, devise products, and launch campaigns for many clients we now call friends. We like them, and they seem to like us back.<\\\\/h3>\\",\\"stick_at_position\\":\\"top\\"}}],\\"styling\\":{\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_right\\":\\"30\\",\\"padding_left\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}}],\\"column_alignment\\":\\"col_align_middle\\",\\"col_tablet\\":\\"column-full\\",\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"-200\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"custom_parallax_scroll_zindex\\":\\"1\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"0\\",\\"border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"0\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"e6d98fe\\",\\"cols\\":[{\\"element_id\\":\\"68bc3a6\\",\\"grid_class\\":\\"col4-2\\"},{\\"element_id\\":\\"88a6de0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"testimonial-slider\\",\\"element_id\\":\\"d39ab83\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_p_container_apply_all\\":\\"1\\",\\"b_container-type\\":\\"top\\",\\"checkbox_content_padding_apply_all\\":\\"1\\",\\"content_border-type\\":\\"top\\",\\"layout_testimonial\\":\\"image-top\\",\\"tab_content_testimonial\\":[{\\"content_testimonial\\":\\"<p>I choose Ultra Agency II because they have a personal approach and warm attitude towards their clients big or small. They are flexible and easy to communicate with.<\\\\/p>\\",\\"person_name_testimonial\\":\\"Mark Stevensson\\",\\"person_position_testimonial\\":\\"CEO\\",\\"company_testimonial\\":\\"Digimoto\\"},{\\"content_testimonial\\":\\"<p>We have been working with Ultra Agency II for 10 Years. They have the rare ability to translate complex ideas into simple and elegant designs. They\\\\\\\\\\\'ve helped define our vision.<\\\\/p>\\",\\"person_name_testimonial\\":\\"Alice Silverstein\\",\\"person_position_testimonial\\":\\"Product Manager\\",\\"company_testimonial\\":\\"Google\\"}],\\"img_w_slider\\":\\"100\\",\\"img_h_slider\\":\\"100\\",\\"visible_opt_slider\\":\\"1\\",\\"mob_visible_opt_slider\\":\\"0\\",\\"auto_scroll_opt_slider\\":\\"off\\",\\"scroll_opt_slider\\":\\"1\\",\\"speed_opt_slider\\":\\"normal\\",\\"effect_slider\\":\\"scroll\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"wrap_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"yes\\",\\"show_arrow_slider\\":\\"yes\\",\\"height_slider\\":\\"variable\\",\\"stick_at_position\\":\\"top\\",\\"custom_parallax_scroll_zindex\\":\\"3\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"2\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"2\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"30\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}}],\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#eef1ff\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"col_tablet_landscape\\":\\"column-full\\",\\"col_tablet\\":\\"column-full\\",\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-agency-2\\\\/files\\\\/2019\\\\/02\\\\/bg-dots.jpg\\",\\"background_repeat\\":\\"repeat-y\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"7\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"7\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat-y\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat-y\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"15\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"row_width\\":\\"fullwidth-content\\",\\"stick_at_position\\":\\"top\\"}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6922,
  'post_date' => '2018-02-28 18:45:08',
  'post_date_gmt' => '2018-02-28 18:45:08',
  'post_content' => '<!--themify_builder_static--><h1 style="text-align: left;">Get Paid Faster</h1> <p style="text-align: left;">Sign up for our complete <strong>ePayment</strong> solutions to accept credit and debit payments in the world.</p> 
 <a href="http://themify.me/" >Get Started Today</a> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2016/09/paypal-logos.png" alt="Classic Header" /> 
 <h2>Get started with ePayment</h2> <p>Your clients can pay you faster. All invoice management tools included.</p> 
 <a href="https://www.youtube.com/watch?v=SENb0osYYXs" > 
 
 </a> 
 
 
 <h2>Jim can now focus on his work, not tracking invoices.</h2> <p>This could be your story.</p> 
 <a href="https://themify.me/" >Learn More</a> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2018/05/item-purchase.png" width="560" height="325" alt="Classic Header" /> 
 <h3>Add ePayment to your invoices.</h3> <p>Lorem ipsum dolor sit amet, nam ea dicit feugiat, te nec stet persecuti sadipscing. Ea graeco scripserit has, in qui equidem labores corrumpit. Quo ad aperiri delicata, latine intellegam mei te, nec tollit feugait ne. His dico intellegebat te, cum alterum docendi in. Deserunt erroribus mel no, vel aliquid graecis reformidans ad, ad quem purto pri.</p> 
 <a href="https://themify.me/" > Learn More</a> 
 
 
 
 
 
 <h2>No more invoice reminders. Boost productivity by 30%.</h2> <p>Now you can focus on your work, not your invoices.</p> 
 <a href="https://themify.me/" > Learn More</a> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2018/05/ipad-invoice-transparent.png" width="673" height="602" alt="Classic Header" /> 
 <h2>All of your invoices in one simple account.</h2> 
 <h3>Experience the 5-min speedy setup.</h3> 
 <a href="http://themify.me/" >Sign Up ePayment Now</a> 
 <ul data-id="testimonial-slider-0-" data-visible="1" data-mob-visible="" data-scroll="1" data-auto-scroll="off" data-speed="1" data-wrap="yes" data-arrow="yes" data-pagination="yes" data-effect="scroll" data-height="variable" data-pause-on-hover="resume" > <li> 
 <h3>“Since using ePayment, I no longer have to manually create invoices, send my clients follow up emails. And my clients like it. They can pay instantly and get payment receipts.”</h3> John Smith CEO, X-corporation </li> <li> 
 <h3>“Lorem ipsum dolor sit amet, nam ea dicit feugiat, te nec stet persecuti sadipscing. Ea graeco scripserit has, in qui equidem labores corrumpit. Quo ad aperiri delicata, latine intellegam mei.”</h3> Lauren Jolie Marketer, Impact Marketing </li> <li> 
 <h3>“Dolor sit amet, nam ea dicit feugiat, te nec stet persecuti sadipscing. Ea graeco scripserit has, in qui equidem labores corrumpit. His dico intellegebat te, cum alterum docendi in.”</h3> Peter Jameson Manager, Global Firm </li> </ul><!--/themify_builder_static-->',
  'post_title' => 'Classic Header',
  'post_excerpt' => '',
  'post_name' => 'classic-header',
  'post_modified' => '2018-07-03 07:12:01',
  'post_modified_gmt' => '2018-07-03 07:12:01',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=6922',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'color_design' => 'theme-color-purple',
    'header_design' => 'header-classic',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"h1_margin_top\\":\\"0\\",\\"h1_margin_bottom\\":\\"10\\",\\"content_text\\":\\"<h1 style=\\\\\\\\\\\\\\"text-align: left;\\\\\\\\\\\\\\">Get Paid Faster<\\\\/h1>\\\\n<p style=\\\\\\\\\\\\\\"text-align: left;\\\\\\\\\\\\\\">Sign up for our complete <strong>ePayment<\\\\/strong> solutions to accept credit and debit payments in the world.<\\\\/p>\\"},\\"element_id\\":\\"w7c8500\\"},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"padding_bottom\\":\\"30\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30px\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"large\\",\\"buttons_style\\":\\"circle\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Get Started Today\\",\\"link\\":\\"http:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"blue\\",\\"icon_alignment\\":\\"left\\"}]},\\"element_id\\":\\"bxcw000\\"},{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"20\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/09\\\\/paypal-logos.png\\",\\"param_image\\":\\"regular\\"},\\"element_id\\":\\"61hs656\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"941h560\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"element_id\\":\\"tgf7010\\"}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/09\\\\/woman-typing-1024x693.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-center\\",\\"cover_color-type\\":\\"cover_gradient\\",\\"cover_color\\":\\"#000000_0.40\\",\\"cover_gradient-gradient-angle\\":\\"90\\",\\"cover_gradient-gradient\\":\\"0% rgba(0, 0, 0, 0.68)|100% rgba(0, 0, 0, 0.32)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff\\",\\"link_color\\":\\"ffffff\\",\\"padding_top\\":\\"12\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\"},\\"element_id\\":\\"amt9095\\"},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h2>Get started with ePayment<\\\\/h2>\\\\n<p>Your clients can pay you faster. All invoice management tools included.<\\\\/p>\\"},\\"element_id\\":\\"3zaq005\\"},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"element_id\\":\\"m107050\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"element_id\\":\\"kspg900\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\",\\"element_id\\":\\"gl15065\\"}],\\"element_id\\":\\"h6bl050\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"uq5a060\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"15\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},\\"element_id\\":\\"lnae500\\"},{\\"row_order\\":\\"2\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"ffffff_1.00\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-play\\",\\"icon_color_feature\\":\\"ffffff_1.00\\",\\"link_feature\\":\\"https:\\\\/\\\\/www.youtube.com\\\\/watch?v=SENb0osYYXs\\",\\"link_options\\":\\"lightbox\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"85b1405\\"},{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"10\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h2>Jim can now focus on his work, not tracking invoices.<\\\\/h2>\\\\n<p>This could be your story.<\\\\/p>\\"},\\"element_id\\":\\"epv4220\\"},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"outline\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Learn More\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"}]},\\"element_id\\":\\"xfjh260\\"}],\\"element_id\\":\\"jc0i226\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/09\\\\/mechanic-646923-1024x597.jpg\\",\\"background_repeat\\":\\"builder-parallax-scrolling\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"000000_0.38\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_color_hover\\":\\"#000000_0.55\\",\\"font_color\\":\\"#ffffff\\",\\"link_color\\":\\"#ffffff\\",\\"padding_top\\":\\"12\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"12\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\"},\\"element_id\\":\\"fuj0600\\"},{\\"row_order\\":\\"3\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2018\\\\/05\\\\/item-purchase.png\\",\\"width_image\\":\\"560\\",\\"height_image\\":\\"325\\",\\"param_image\\":\\"regular\\",\\"animation_effect\\":\\"fadeInLeft\\"},\\"element_id\\":\\"78hv305\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"left\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\"},\\"element_id\\":\\"bfut060\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h3>Add ePayment to your invoices.<\\\\/h3>\\\\n<p>Lorem ipsum dolor sit amet, nam ea dicit feugiat, te nec stet persecuti sadipscing. Ea graeco scripserit has, in qui equidem labores corrumpit. Quo ad aperiri delicata, latine intellegam mei te, nec tollit feugait ne. His dico intellegebat te, cum alterum docendi in. Deserunt erroribus mel no, vel aliquid graecis reformidans ad, ad quem purto pri.<\\\\/p>\\",\\"animation_effect\\":\\"fadeInRight\\"},\\"element_id\\":\\"yav0000\\"},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"rounded\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Learn More\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"blue\\",\\"icon\\":\\"ti-angle-right\\",\\"icon_alignment\\":\\"left\\"}],\\"animation_effect\\":\\"fadeInRightBig\\"},\\"element_id\\":\\"vaek050\\"}],\\"element_id\\":\\"xk0h300\\"}],\\"column_alignment\\":\\"col_align_middle\\",\\"element_id\\":\\"u3j3005\\"}],\\"element_id\\":\\"rfhi990\\"}],\\"styling\\":{\\"row_anchor\\":\\"about\\",\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"7\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"7\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"15\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},\\"element_id\\":\\"hk84260\\"},{\\"row_order\\":\\"4\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"ffffff\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-diamond\\",\\"icon_color_feature\\":\\"ffffff\\",\\"link_options\\":\\"regular\\",\\"animation_effect\\":\\"pulse\\"},\\"element_id\\":\\"kqn4406\\"},{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h2>No more invoice reminders. Boost productivity by 30%.<\\\\/h2>\\\\n<p>Now you can focus on your work, not your invoices.<\\\\/p>\\"},\\"element_id\\":\\"0hgq555\\"},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"40\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"outline\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Learn More\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon\\":\\"ti-angle-right\\",\\"icon_alignment\\":\\"left\\"}]},\\"element_id\\":\\"9ug6550\\"},{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2018\\\\/05\\\\/ipad-invoice-transparent.png\\",\\"width_image\\":\\"673\\",\\"height_image\\":\\"602\\",\\"param_image\\":\\"regular\\",\\"animation_effect\\":\\"fadeInUp\\"},\\"element_id\\":\\"4run446\\"}],\\"element_id\\":\\"rhpg330\\"}],\\"styling\\":{\\"background_type\\":\\"gradient\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_gradient-gradient\\":\\"0% rgba(28, 191, 255, 0.99)|98% rgba(18, 88, 186, 0.99)\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\"},\\"element_id\\":\\"nrqj588\\"},{\\"row_order\\":\\"5\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"10\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h2>All of your invoices in one simple account.<\\\\/h2>\\"},\\"element_id\\":\\"mjgy400\\"},{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h3>Experience the 5-min speedy setup.<\\\\/h3>\\"},\\"element_id\\":\\"nnyg005\\"},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"padding_bottom\\":\\"30\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"xlarge\\",\\"buttons_style\\":\\"circle\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Sign Up ePayment Now\\",\\"link\\":\\"http:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"blue\\",\\"icon_alignment\\":\\"left\\"}],\\"animation_effect\\":\\"swing\\"},\\"element_id\\":\\"c4wa006\\"},{\\"mod_name\\":\\"testimonial-slider\\",\\"mod_settings\\":{\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"layout_testimonial\\":\\"image-top\\",\\"tab_content_testimonial\\":[{\\"content_testimonial\\":\\"<h3>“Since using ePayment, I no longer have to manually create invoices, send my clients follow up emails. And my clients like it. They can pay instantly and get payment receipts.”<\\\\/h3>\\",\\"person_name_testimonial\\":\\"John Smith\\",\\"person_position_testimonial\\":\\"CEO, X-corporation\\"},{\\"content_testimonial\\":\\"<h3>“Lorem ipsum dolor sit amet, nam ea dicit feugiat, te nec stet persecuti sadipscing. Ea graeco scripserit has, in qui equidem labores corrumpit. Quo ad aperiri delicata, latine intellegam mei.”<\\\\/h3>\\",\\"person_name_testimonial\\":\\"Lauren Jolie\\",\\"person_position_testimonial\\":\\"Marketer, Impact Marketing\\"},{\\"content_testimonial\\":\\"<h3>“Dolor sit amet, nam ea dicit feugiat, te nec stet persecuti sadipscing. Ea graeco scripserit has, in qui equidem labores corrumpit. His dico intellegebat te, cum alterum docendi in.”<\\\\/h3>\\",\\"person_name_testimonial\\":\\"Peter Jameson\\",\\"person_position_testimonial\\":\\"Manager, Global Firm\\"}],\\"visible_opt_slider\\":\\"1\\",\\"auto_scroll_opt_slider\\":\\"off\\",\\"scroll_opt_slider\\":\\"1\\",\\"speed_opt_slider\\":\\"normal\\",\\"effect_slider\\":\\"scroll\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"wrap_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"yes\\",\\"show_arrow_slider\\":\\"yes\\",\\"height_slider\\":\\"variable\\"},\\"element_id\\":\\"9uz7522\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"fsyj700\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"15\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},\\"element_id\\":\\"8rb9500\\"},{\\"row_order\\":\\"6\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"lg1p040\\"}],\\"element_id\\":\\"1rcp000\\"}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3584,
  'post_date' => '2015-04-20 22:26:13',
  'post_date_gmt' => '2015-04-20 22:26:13',
  'post_content' => '',
  'post_title' => 'Footer Block',
  'post_excerpt' => '',
  'post_name' => 'footer-block',
  'post_modified' => '2017-08-21 01:13:17',
  'post_modified_gmt' => '2017-08-21 01:13:17',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=3584',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'header_design' => 'none',
    'header_wrap' => 'transparent',
    'footer_design' => 'footer-block',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3590,
  'post_date' => '2015-04-20 22:32:27',
  'post_date_gmt' => '2015-04-20 22:32:27',
  'post_content' => '',
  'post_title' => 'Footer Horizontal Left',
  'post_excerpt' => '',
  'post_name' => 'footer-horizontal-left',
  'post_modified' => '2017-08-21 01:13:18',
  'post_modified_gmt' => '2017-08-21 01:13:18',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=3590',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'hide_page_title' => 'no',
    'header_design' => 'none',
    'header_wrap' => 'transparent',
    'footer_design' => 'footer-horizontal-left',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3592,
  'post_date' => '2015-04-20 22:32:46',
  'post_date_gmt' => '2015-04-20 22:32:46',
  'post_content' => '',
  'post_title' => 'Footer Horizontal Right',
  'post_excerpt' => '',
  'post_name' => 'footer-horizontal-right',
  'post_modified' => '2017-08-21 01:13:20',
  'post_modified_gmt' => '2017-08-21 01:13:20',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=3592',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'header_design' => 'none',
    'header_wrap' => 'transparent',
    'footer_design' => 'footer-horizontal-right',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3586,
  'post_date' => '2015-04-20 22:31:22',
  'post_date_gmt' => '2015-04-20 22:31:22',
  'post_content' => '',
  'post_title' => 'Footer Left Column',
  'post_excerpt' => '',
  'post_name' => 'footer-left-column',
  'post_modified' => '2017-08-21 01:13:21',
  'post_modified_gmt' => '2017-08-21 01:13:21',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=3586',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'header_design' => 'none',
    'header_wrap' => 'transparent',
    'footer_design' => 'footer-left-col',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3588,
  'post_date' => '2015-04-20 22:32:04',
  'post_date_gmt' => '2015-04-20 22:32:04',
  'post_content' => '',
  'post_title' => 'Footer Right Column',
  'post_excerpt' => '',
  'post_name' => 'footer-right-column',
  'post_modified' => '2017-08-21 01:14:44',
  'post_modified_gmt' => '2017-08-21 01:14:44',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=3588',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'header_design' => 'none',
    'header_wrap' => 'transparent',
    'footer_design' => 'footer-right-col',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3975,
  'post_date' => '2015-05-08 21:45:53',
  'post_date_gmt' => '2015-05-08 21:45:53',
  'post_content' => '<!--themify_builder_static--><h2 style="text-align: center;">Capture Moments</h2><h3 style="text-align: center;">Eye-Spy App</h3> 
 <a href="https://vimeo.com/29731100" > 
 
 </a> 
 
 
 <h2 style="text-align: center;">Download</h2><h3 style="text-align: center;">Available in App Store</h3> 
 <a href="http://store.apple.com/us" > <img src="https://themify.me/demo/themes/landing/files/2015/03/download.png" width="200" alt="" /> </a> 
 <h2 style="text-align: center;">Highlights</h2><h3 style="text-align: center;">I\'d imperdiet leo aliquet ut. Aenean rutrum lorem ac augue lobortis venenatis. Donec pulvinar bibendum magna id cursus. </h3> 
 <ul data-id="slider-0-" data-visible="1" data-mob-visible="" data-scroll="1" data-auto-scroll="4" data-speed="1" data-wrap="yes" data-arrow="yes" data-pagination="yes" data-effect="scroll" data-height="variable" data-pause-on-hover="resume" > 
 <li> <img src="https://themify.me/demo/themes/landing/files/2015/03/iphone6p-gold-select-2014.png" width="400" alt="Rose Gold" /> 
 <h3> Rose Gold </h3> <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce eu mattis augue. Suspendisse lobortis elementum nunc in volutpat. Morbi vestibulum ut erat vitae luctus. Integer finibus enim sit amet accumsan posuere. In at imperdiet quam, quis placerat ipsum. Nulla facilisi. Nulla ornare a erat eu faucibus. Vivamus vel purus libero. Ut facilisis ultrices nibh, in fringilla sem venenatis nec. Praesent a sagittis justo. Duis dignissim lorem in eros aliquam cursus. Donec et enim tincidunt neque laoreet consectetur. Aenean in venenatis orci. Donec malesuada erat eget ante dignissim blandit. Praesent a efficitur lacus, id placerat eros. Suspendisse a accumsan risus, eget mattis ante.</p>
[themify_button style="large blue rect flat" text="#ffffff" target="https://themify.me/demo/themes/landing/" ] Go to Demo [/themify_button] </li> <li> <img src="https://themify.me/demo/themes/landing/files/2015/03/iphone6p-silver-select-2014.png" width="400" alt="Silver " /> 
 <h3> Silver </h3> <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce eu mattis augue. Suspendisse lobortis elementum nunc in volutpat. Morbi vestibulum ut erat vitae luctus. Integer finibus enim sit amet accumsan posuere. In at imperdiet quam, quis placerat ipsum. Nulla facilisi. Nulla ornare a erat eu faucibus. Vivamus vel purus libero. Ut facilisis ultrices nibh, in fringilla sem venenatis nec. Praesent a sagittis justo. Duis dignissim lorem in eros aliquam cursus. Donec et enim tincidunt neque laoreet consectetur. Aenean in venenatis orci. Donec malesuada erat eget ante dignissim blandit. Praesent a efficitur lacus, id placerat eros. Suspendisse a accumsan risus, eget mattis ante.</p>
[themify_button style="large blue rect flat" text="#ffffff" target="https://themify.me/demo/themes/landing/" ] Go to Demo [/themify_button] </li> <li> <img src="https://themify.me/demo/themes/landing/files/2015/03/iphone6p-gray-select-2014.png" width="400" alt="Space Gray " /> 
 <h3> Space Gray </h3> <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce eu mattis augue. Suspendisse lobortis elementum nunc in volutpat. Morbi vestibulum ut erat vitae luctus. Integer finibus enim sit amet accumsan posuere. In at imperdiet quam, quis placerat ipsum. Nulla facilisi. Nulla ornare a erat eu faucibus. Vivamus vel purus libero. Ut facilisis ultrices nibh, in fringilla sem venenatis nec. Praesent a sagittis justo. Duis dignissim lorem in eros aliquam cursus. Donec et enim tincidunt neque laoreet consectetur. Aenean in venenatis orci. Donec malesuada erat eget ante dignissim blandit. Praesent a efficitur lacus, id placerat eros. Suspendisse a accumsan risus, eget mattis ante.</p>
[themify_button style="large blue rect flat" text="#ffffff" target="https://themify.me/demo/themes/landing/" ] Go to Demo [/themify_button] </li> </ul> 
 <h4 style="text-align: center;">Amazing Time Lapse</h4> 
 <h2 style="text-align: center;">FAQ</h2> 
 <h4>What is your refund policy?</h4><p>Sed sagittis, elit egestas rutrum vehicula, neque dolor fringilla lacus, ut rhoncus turpis augue vitae libero. Nam risus velit, rhoncus eget consectetur id, posuere at ligula. Vivamus imperdiet diam ac tortor tempus posuere. Curabitur at arcu id turpis posuere bibendum. Sed commodo mauris eget diam pretium cursus. In sagittis feugiat mauris, in ultrices mauris lacinia eu. Fusce augue velit, vulputate elementum semper congue, rhoncus adipiscing nisl. Curabitur vel risus eros, sed eleifend arcu.</p><h4 id="2">Can the app do this?</h4><p>Donec porttitor hendrerit diam et blandit. Curabitur vitae velit ligula, vitae lobortis massa. Mauris mattis est quis dolor venenatis vitae pharetra diam gravida. Vivamus dignissim, ligula vel ultricies varius, nibh velit pretium leo, vel placerat ipsum risus luctus purus.</p> 
 <h4 id="2">Do you guys provide this?</h4><p>Donec porttitor hendrerit diam et blandit. Curabitur vitae velit ligula, vitae lobortis massa. Mauris mattis est quis dolor venenatis vitae pharetra diam gravida. Vivamus dignissim, ligula vel ultricies varius, nibh velit pretium leo, vel placerat ipsum risus luctus purus.</p><h4>Does it work with?</h4><p>Sed sagittis, elit egestas rutrum vehicula, neque dolor fringilla lacus, ut rhoncus turpis augue vitae libero. Nam risus velit, rhoncus eget consectetur id, posuere at ligula. Vivamus imperdiet diam ac tortor tempus posuere. Curabitur at arcu id turpis posuere bibendum. Sed commodo mauris eget diam pretium cursus. In sagittis feugiat mauris, in ultrices mauris lacinia eu. Fusce augue velit, vulputate elementum semper congue, rhoncus adipiscing nisl. Curabitur vel risus eros, sed eleifend arcu.</p><!--/themify_builder_static-->',
  'post_title' => 'Fullheight / Image',
  'post_excerpt' => '',
  'post_name' => 'image',
  'post_modified' => '2019-03-20 01:34:00',
  'post_modified_gmt' => '2019-03-20 01:34:00',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=3975',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'header_design' => 'header-block',
    'fixed_header' => 'yes',
    'full_height_header' => 'yes',
    'background_color' => '#000000',
    'background_image' => 'https://themify.me/demo/themes/ultra/files/2015/04/Top_view.jpg',
    'background_repeat' => 'fullcover',
    'headerwrap_text_color' => '#ffffff',
    'headerwrap_link_color' => '#ffffff',
    'footer_design' => 'none',
    'more_posts' => 'pagination',
    'posts_per_page' => '2',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"47de468\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"9ff8b21\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"39b82bf\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Capture Moments<\\\\/h2><h3 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Eye-Spy App<\\\\/h3>\\"}},{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"cefa92d\\",\\"mod_settings\\":{\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"ffbb00\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-play\\",\\"icon_color_feature\\":\\"ffbb00\\",\\"link_feature\\":\\"https:\\\\/\\\\/vimeo.com\\\\/29731100\\",\\"param_feature\\":\\"lightbox\\",\\"link_options\\":\\"\\"}}]}],\\"styling\\":{\\"row_height\\":\\"fullheight\\",\\"background_type\\":\\"image\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/03\\\\/162596999.jpg\\",\\"background_repeat\\":\\"builder-parallax-scrolling\\",\\"cover_color\\":\\"000000_0.76\\",\\"cover_color_hover\\":\\"000000_0.72\\",\\"font_color\\":\\"ffe733_1.00\\",\\"link_color\\":\\"ffbb00_1.00\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\"}},{\\"element_id\\":\\"c440ce1\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"0737c9e\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"c6a1201\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Download<\\\\/h2><h3 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Available in App Store<\\\\/h3>\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"94d5b8a\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/03\\\\/download.png\\",\\"appearance_image\\":\\"rounded\\",\\"width_image\\":\\"200\\",\\"link_image\\":\\"http:\\\\/\\\\/store.apple.com\\\\/us\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_color\\":\\"ffe312_1.00\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\"}},{\\"element_id\\":\\"b02aac6\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"581fc21\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"28d755c\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Highlights<\\\\/h2><h3 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">I\\\\\\\\\\\'d imperdiet leo aliquet ut. Aenean rutrum lorem ac augue lobortis venenatis. Donec pulvinar bibendum magna id cursus. <\\\\/h3>\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\"}},{\\"mod_name\\":\\"slider\\",\\"element_id\\":\\"f980531\\",\\"mod_settings\\":{\\"layout_display_slider\\":\\"image\\",\\"blog_category_slider\\":\\"|single\\",\\"slider_category_slider\\":\\"|single\\",\\"portfolio_category_slider\\":\\"|single\\",\\"testimonial_category_slider\\":\\"|single\\",\\"order_slider\\":\\"desc\\",\\"orderby_slider\\":\\"date\\",\\"display_slider\\":\\"content\\",\\"img_content_slider\\":[{\\"img_url_slider\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/03\\\\/iphone6p-gold-select-2014.png\\",\\"img_title_slider\\":\\"Rose Gold\\",\\"img_caption_slider\\":\\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce eu mattis augue. Suspendisse lobortis elementum nunc in volutpat. Morbi vestibulum ut erat vitae luctus. Integer finibus enim sit amet accumsan posuere. In at imperdiet quam, quis placerat ipsum. Nulla facilisi. Nulla ornare a erat eu faucibus. Vivamus vel purus libero. Ut facilisis ultrices nibh, in fringilla sem venenatis nec. Praesent a sagittis justo. Duis dignissim lorem in eros aliquam cursus. Donec et enim tincidunt neque laoreet consectetur. Aenean in venenatis orci. Donec malesuada erat eget ante dignissim blandit. Praesent a efficitur lacus, id placerat eros. Suspendisse a accumsan risus, eget mattis ante.<\\\\/p>\\\\n\\\\n[themify_button style=\\\\\\\\\\\\\\"large blue rect flat\\\\\\\\\\\\\\" text=\\\\\\\\\\\\\\"#ffffff\\\\\\\\\\\\\\" target=\\\\\\\\\\\\\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/\\\\\\\\\\\\\\" ] Go to Demo [\\\\/themify_button]\\"},{\\"img_url_slider\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/03\\\\/iphone6p-silver-select-2014.png\\",\\"img_title_slider\\":\\"Silver \\",\\"img_caption_slider\\":\\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce eu mattis augue. Suspendisse lobortis elementum nunc in volutpat. Morbi vestibulum ut erat vitae luctus. Integer finibus enim sit amet accumsan posuere. In at imperdiet quam, quis placerat ipsum. Nulla facilisi. Nulla ornare a erat eu faucibus. Vivamus vel purus libero. Ut facilisis ultrices nibh, in fringilla sem venenatis nec. Praesent a sagittis justo. Duis dignissim lorem in eros aliquam cursus. Donec et enim tincidunt neque laoreet consectetur. Aenean in venenatis orci. Donec malesuada erat eget ante dignissim blandit. Praesent a efficitur lacus, id placerat eros. Suspendisse a accumsan risus, eget mattis ante.<\\\\/p>\\\\n\\\\n[themify_button style=\\\\\\\\\\\\\\"large blue rect flat\\\\\\\\\\\\\\" text=\\\\\\\\\\\\\\"#ffffff\\\\\\\\\\\\\\" target=\\\\\\\\\\\\\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/\\\\\\\\\\\\\\" ] Go to Demo [\\\\/themify_button]\\"},{\\"img_url_slider\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/03\\\\/iphone6p-gray-select-2014.png\\",\\"img_title_slider\\":\\"Space Gray \\",\\"img_caption_slider\\":\\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce eu mattis augue. Suspendisse lobortis elementum nunc in volutpat. Morbi vestibulum ut erat vitae luctus. Integer finibus enim sit amet accumsan posuere. In at imperdiet quam, quis placerat ipsum. Nulla facilisi. Nulla ornare a erat eu faucibus. Vivamus vel purus libero. Ut facilisis ultrices nibh, in fringilla sem venenatis nec. Praesent a sagittis justo. Duis dignissim lorem in eros aliquam cursus. Donec et enim tincidunt neque laoreet consectetur. Aenean in venenatis orci. Donec malesuada erat eget ante dignissim blandit. Praesent a efficitur lacus, id placerat eros. Suspendisse a accumsan risus, eget mattis ante.<\\\\/p>\\\\n\\\\n[themify_button style=\\\\\\\\\\\\\\"large blue rect flat\\\\\\\\\\\\\\" text=\\\\\\\\\\\\\\"#ffffff\\\\\\\\\\\\\\" target=\\\\\\\\\\\\\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/\\\\\\\\\\\\\\" ] Go to Demo [\\\\/themify_button]\\"}],\\"layout_slider\\":\\"slider-agency\\",\\"img_w_slider\\":\\"400\\",\\"visible_opt_slider\\":\\"1\\",\\"auto_scroll_opt_slider\\":\\"4\\",\\"scroll_opt_slider\\":\\"1\\",\\"speed_opt_slider\\":\\"normal\\",\\"effect_slider\\":\\"scroll\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"wrap_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"yes\\",\\"show_arrow_slider\\":\\"yes\\",\\"height_slider\\":\\"variable\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\"}},{\\"element_id\\":\\"68e0863\\",\\"row_order\\":\\"3\\",\\"cols\\":[{\\"element_id\\":\\"faf5425\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"26f0d84\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Amazing Time Lapse<\\\\/h4>\\"}}]}],\\"styling\\":{\\"row_height\\":\\"fullheight\\",\\"background_type\\":\\"video\\",\\"background_video\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/demo-videos\\\\/Timelapse_Flower.mp4\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/demo-videos\\\\/flower-1024x572.jpg\\",\\"font_color\\":\\"ffffff_1.00\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"e157814\\",\\"row_order\\":\\"4\\",\\"cols\\":[{\\"element_id\\":\\"a72df69\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"af2adc3\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">FAQ<\\\\/h2>\\"}},{\\"element_id\\":\\"80cea11\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"71a60cb\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"f52c7c0\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>What is your refund policy?<\\\\/h4><p>Sed sagittis, elit egestas rutrum vehicula, neque dolor fringilla lacus, ut rhoncus turpis augue vitae libero. Nam risus velit, rhoncus eget consectetur id, posuere at ligula. Vivamus imperdiet diam ac tortor tempus posuere. Curabitur at arcu id turpis posuere bibendum. Sed commodo mauris eget diam pretium cursus. In sagittis feugiat mauris, in ultrices mauris lacinia eu. Fusce augue velit, vulputate elementum semper congue, rhoncus adipiscing nisl. Curabitur vel risus eros, sed eleifend arcu.<\\\\/p><h4 id=\\\\\\\\\\\\\\"2\\\\\\\\\\\\\\">Can the app do this?<\\\\/h4><p>Donec porttitor hendrerit diam et blandit. Curabitur vitae velit ligula, vitae lobortis massa. Mauris mattis est quis dolor venenatis vitae pharetra diam gravida. Vivamus dignissim, ligula vel ultricies varius, nibh velit pretium leo, vel placerat ipsum risus luctus purus.<\\\\/p>\\",\\"font_size\\":\\".8\\",\\"font_size_unit\\":\\"em\\",\\"padding_top\\":\\"2\\",\\"padding_top_unit\\":\\"%\\"}}]},{\\"element_id\\":\\"0f54411\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"884a1ae\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4 id=\\\\\\\\\\\\\\"2\\\\\\\\\\\\\\">Do you guys provide this?<\\\\/h4><p>Donec porttitor hendrerit diam et blandit. Curabitur vitae velit ligula, vitae lobortis massa. Mauris mattis est quis dolor venenatis vitae pharetra diam gravida. Vivamus dignissim, ligula vel ultricies varius, nibh velit pretium leo, vel placerat ipsum risus luctus purus.<\\\\/p><h4>Does it work with?<\\\\/h4><p>Sed sagittis, elit egestas rutrum vehicula, neque dolor fringilla lacus, ut rhoncus turpis augue vitae libero. Nam risus velit, rhoncus eget consectetur id, posuere at ligula. Vivamus imperdiet diam ac tortor tempus posuere. Curabitur at arcu id turpis posuere bibendum. Sed commodo mauris eget diam pretium cursus. In sagittis feugiat mauris, in ultrices mauris lacinia eu. Fusce augue velit, vulputate elementum semper congue, rhoncus adipiscing nisl. Curabitur vel risus eros, sed eleifend arcu.<\\\\/p>\\",\\"font_size\\":\\".8\\",\\"font_size_unit\\":\\"em\\",\\"padding_top\\":\\"2\\",\\"padding_top_unit\\":\\"%\\"}}]}]},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"5147e5a\\",\\"mod_settings\\":{\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\"}},{\\"element_id\\":\\"5ef794e\\",\\"row_order\\":\\"5\\",\\"cols\\":[{\\"element_id\\":\\"0a673b8\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 7767,
  'post_date' => '2018-11-11 00:13:02',
  'post_date_gmt' => '2018-11-11 00:13:02',
  'post_content' => '<!--themify_builder_static--><h1>Ultra App</h1> <p>Speed up your mobile app development now. Simple 5-min installation. Available both on iOS and Android.</p>
<a href="https://themify.me/" > DOWNLOAD </a>
<a href="https://www.youtube.com/watch?v=P8Lte26BBN8" > <img src="https://themify.me/demo/themes/ultra-app/files/2018/05/ipad-app.png" width="689" alt="" /> </a>
<h2>Quick Prototypes</h2> <p>Perfect for presenting your apps, websites and prototypes. Mainstream your design and development process without hassle exports. Simply export it any time as you want. Available to view online or any mobile device.</p>
<a href="https://themify.me/" > WATCH IT </a>
<img src="https://themify.me/demo/themes/ultra-app/files/2018/05/app-interface.png" width="670" alt="" />
<h2>Testimonials</h2>
<ul data-id="tb_ba718ba" data-visible="3" data-mob-visible="1" data-scroll="1" data-auto-scroll="off" data-speed="1" data-wrap="yes" data-arrow="yes" data-pagination="yes" data-effect="scroll" data-height="variable" data-pause-on-hover="resume" data-horizontal="" > <li> 
 <figure> <img src="https://themify.me/demo/themes/ultra-app/files/2018/05/testimonial-client-1.jpg" width="100" height="100" alt="" /> </figure> <p>Thanks Plentific for helping us stay on top of a very stressful process! Finally exchanged and looking forward to complete.</p> Hendry Bradshaw Evernote </li> <li> 
 <figure> <img src="https://themify.me/demo/themes/ultra-app/files/2018/05/testimonial-client-2.jpg" width="100" height="100" alt="" /> </figure> <p>Great to stay on top of the process. Especially liked to play with the financial section when viewing properties. Highly recommended!</p> Andree Shorter Invision </li> <li> 
 <figure> <img src="https://themify.me/demo/themes/ultra-app/files/2018/05/testimonial-client-3.jpg" width="100" height="100" alt="" /> </figure> <p>Just started flat hunting. Your affordability calculator saved me some serious time to focus on what I can actually buy. Thanks so much.</p> Sofia Gerald AirBNB </li> <li> 
 <figure> <img src="https://themify.me/demo/themes/ultra-app/files/2018/05/testimonial-client-4.jpg" width="100" height="100" alt="" /> </figure> <p>Thumbs Up, their service is magnificent, quick solution for top enterprise. Totally recommended App for your business</p> Chintya Abee Total Solution </li> </ul>
<img src="https://themify.me/demo/themes/ultra-app/files/2018/05/client-1.png" width="156" alt="" />
<img src="https://themify.me/demo/themes/ultra-app/files/2018/05/client-2-143x37.png" width="143" alt="" />
<img src="https://themify.me/demo/themes/ultra-app/files/2018/05/client-3-51x36.png" width="51" alt="" />
<img src="https://themify.me/demo/themes/ultra-app/files/2018/05/client-4-126x37.png" width="126" alt="" />
<img src="https://themify.me/demo/themes/ultra-app/files/2018/05/client-5-163x37.png" width="163" alt="" />
<img src="https://themify.me/demo/themes/ultra-app/files/2018/05/client-6-116x35.png" width="116" alt="" />
<h2>Features</h2>
<p>Deserun mollit anim id est laborum.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod. Excepteur sint occaecat cupidatat.</p>
<img src="https://themify.me/demo/themes/ultra-app/files/2018/05/camera-app-icon-1.png" alt="Camera" /> 
 
 <h3> Camera </h3> <p>Sed ut perspiciatis unde omnis iste natus error.</p>
<img src="https://themify.me/demo/themes/ultra-app/files/2018/05/share-app-icon-1.png" alt="Share" /> 
 
 <h3> Share </h3> <p>Excepteur sint occaecat cupidatat non proident.</p>
<img src="https://themify.me/demo/themes/ultra-app/files/2018/05/sync-app-icon-1.png" alt="Sync" /> 
 
 <h3> Sync </h3> <p>At vero eos et accusamus et iusto odio dignissimos.</p>
<img src="https://themify.me/demo/themes/ultra-app/files/2018/11/iphone.png" width="345" alt="" />
<img src="https://themify.me/demo/themes/ultra-app/files/2018/05/filter-app-icon-1.png" alt="Filter" /> 
 
 <h3> Filter </h3> <p>Neque porro quisquam est, qui dolorem ipsum quiat.</p>
<img src="https://themify.me/demo/themes/ultra-app/files/2018/05/edit-app-icon-1.png" alt="Edit" /> 
 
 <h3> Edit </h3> <p>Nemo enim ipsam voluptatem quia voluptas.</p>
<img src="https://themify.me/demo/themes/ultra-app/files/2018/05/effect-app-icon-1.png" alt="Effects" /> 
 
 <h3> Effects </h3> <p>Nam libero tempore, cum soluta nobis est eligendi.</p>
<h2>Got Questions?</h2> <p>Don’t be shy. We are here to answer your questions 24/7.</p>
<form action="https://themify.me/demo/themes/ultra/wp-admin/admin-ajax.php" id="contact-0--form" method="post"> <label for="contact-0--contact-name">Your Name </label> <input type="text" name="contact-name" placeholder="" id="contact-0--contact-name" value="" /> <label for="contact-0--contact-email">Your Email </label> <input type="text" name="contact-email" placeholder="" id="contact-0--contact-email" value="" /> <label for="contact-0--contact-subject">Subject *</label> <input type="text" name="contact-subject" placeholder="" id="contact-0--contact-subject" value="" required /> <label for="contact-0--contact-message">Message *</label> <textarea name="contact-message" placeholder="" id="contact-0--contact-message" rows="8" cols="45" required></textarea> <button type="submit"> Send </button> </form><!--/themify_builder_static-->',
  'post_title' => 'Header Bottom',
  'post_excerpt' => '',
  'post_name' => 'header-bottom',
  'post_modified' => '2019-11-16 00:10:40',
  'post_modified_gmt' => '2019-11-16 00:10:40',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=7767',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'header_design' => 'header-bottom',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"cc9232f\\",\\"cols\\":[{\\"element_id\\":\\"8d3bc2f\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"e4b5b80\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"font_color\\":\\"#ffffff\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h1>Ultra App<\\\\/h1>\\\\n<p>Speed up your mobile app development now. Simple 5-min installation. Available both on iOS and Android.<\\\\/p>\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"1083050\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"normal\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"DOWNLOAD\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"blue\\",\\"icon_alignment\\":\\"left\\"}],\\"buttons_shape\\":\\"circle\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_bottom\\":\\"14\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\"}}},{\\"element_id\\":\\"2b4135c\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"ee50da5\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-app\\\\/files\\\\/2018\\\\/05\\\\/ipad-app.png\\",\\"width_image\\":\\"689\\",\\"link_image\\":\\"https:\\\\/\\\\/www.youtube.com\\\\/watch?v=P8Lte26BBN8\\",\\"param_image\\":\\"lightbox\\",\\"animation_effect\\":\\"fadeInUp\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-app\\\\/files\\\\/2018\\\\/05\\\\/bg-header.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"12\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"25\\",\\"padding_bottom_unit\\":\\"%\\",\\"margin_bottom\\":\\"-22\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_width\\":\\"fullwidth\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"22\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"margin_bottom\\":\\"0\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\"}}},{\\"element_id\\":\\"81156b6\\",\\"cols\\":[{\\"element_id\\":\\"768f1d1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"2682270\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"font_color_h2\\":\\"#405cc2\\",\\"content_text\\":\\"<h2>Quick Prototypes<\\\\/h2>\\\\n<p>Perfect for presenting your apps, websites and prototypes. Mainstream your design and development process without hassle exports. Simply export it any time as you want. Available to view online or any mobile device.<\\\\/p>\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"fd11bb6\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"circle\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"WATCH IT\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"purple\\",\\"icon_alignment\\":\\"left\\"}]}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"padding_bottom\\":\\"14\\"}}},{\\"element_id\\":\\"9ea1e08\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"68d30d6\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-app\\\\/files\\\\/2018\\\\/05\\\\/app-interface.png\\",\\"width_image\\":\\"670\\",\\"auto_fullwidth\\":\\"1\\",\\"param_image\\":\\"regular\\",\\"motion_effects\\":{\\"v\\":{\\"val\\":{\\"v_speed\\":\\"1\\",\\"v_dir\\":\\"up\\"}}}}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"0\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"padding_bottom\\":\\"12\\"},\\"row_width\\":\\"fullwidth-content\\",\\"row_anchor\\":\\"about\\"}},{\\"element_id\\":\\"b30b340\\",\\"cols\\":[{\\"element_id\\":\\"a0d9c99\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"8ea00aa\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"font_color_h2\\":\\"#405cc2\\",\\"content_text\\":\\"<h2>Testimonials<\\\\/h2>\\"}},{\\"mod_name\\":\\"testimonial-slider\\",\\"element_id\\":\\"ba718ba\\",\\"mod_settings\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_container_padding_apply_all\\":\\"1\\",\\"checkbox_container_border_apply_all\\":\\"1\\",\\"checkbox_content_padding_apply_all\\":\\"1\\",\\"checkbox_content_border_apply_all\\":\\"1\\",\\"layout_testimonial\\":\\"image-top\\",\\"tab_content_testimonial\\":[{\\"content_testimonial\\":\\"<p>Thanks Plentific for helping us stay on top of a very stressful process! Finally exchanged and looking forward to complete.<\\\\/p>\\",\\"person_picture_testimonial\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-app\\\\/files\\\\/2018\\\\/05\\\\/testimonial-client-1.jpg\\",\\"person_name_testimonial\\":\\"Hendry Bradshaw\\",\\"company_testimonial\\":\\"Evernote\\"},{\\"content_testimonial\\":\\"<p>Great to stay on top of the process. Especially liked to play with the financial section when viewing properties. Highly recommended!<\\\\/p>\\",\\"person_picture_testimonial\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-app\\\\/files\\\\/2018\\\\/05\\\\/testimonial-client-2.jpg\\",\\"person_name_testimonial\\":\\"Andree Shorter\\",\\"company_testimonial\\":\\"Invision\\"},{\\"content_testimonial\\":\\"<p>Just started flat hunting. Your affordability calculator saved me some serious time to focus on what I can actually buy. Thanks so much.<\\\\/p>\\",\\"person_picture_testimonial\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-app\\\\/files\\\\/2018\\\\/05\\\\/testimonial-client-3.jpg\\",\\"person_name_testimonial\\":\\"Sofia Gerald\\",\\"company_testimonial\\":\\"AirBNB\\"},{\\"content_testimonial\\":\\"<p>Thumbs Up, their service is magnificent, quick solution for top enterprise. Totally recommended App for your business<\\\\/p>\\",\\"person_picture_testimonial\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-app\\\\/files\\\\/2018\\\\/05\\\\/testimonial-client-4.jpg\\",\\"person_name_testimonial\\":\\"Chintya Abee\\",\\"company_testimonial\\":\\"Total Solution\\"}],\\"img_w_slider\\":\\"100\\",\\"img_h_slider\\":\\"100\\",\\"visible_opt_slider\\":\\"3\\",\\"mob_visible_opt_slider\\":\\"1\\",\\"auto_scroll_opt_slider\\":\\"off\\",\\"scroll_opt_slider\\":\\"1\\",\\"speed_opt_slider\\":\\"normal\\",\\"effect_slider\\":\\"scroll\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"wrap_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"yes\\",\\"show_arrow_slider\\":\\"yes\\",\\"height_slider\\":\\"variable\\",\\"animation_effect\\":\\"fadeIn\\"}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_anchor\\":\\"testimonials\\"}},{\\"element_id\\":\\"87393eb\\",\\"cols\\":[{\\"element_id\\":\\"d10857d\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"9147b11\\",\\"cols\\":[{\\"element_id\\":\\"c4a8762\\",\\"grid_class\\":\\"col6-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"e07e63d\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-app\\\\/files\\\\/2018\\\\/05\\\\/client-1.png\\",\\"width_image\\":\\"156\\",\\"param_image\\":\\"regular\\"}}]},{\\"element_id\\":\\"16abb5e\\",\\"grid_class\\":\\"col6-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"ddd3c30\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-app\\\\/files\\\\/2018\\\\/05\\\\/client-2-143x37.png\\",\\"width_image\\":\\"143\\",\\"param_image\\":\\"regular\\"}}]},{\\"element_id\\":\\"abed339\\",\\"grid_class\\":\\"col6-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"0202ee6\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-app\\\\/files\\\\/2018\\\\/05\\\\/client-3-51x36.png\\",\\"width_image\\":\\"51\\",\\"param_image\\":\\"regular\\"}}]},{\\"element_id\\":\\"325f924\\",\\"grid_class\\":\\"col6-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"f9e91fa\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-app\\\\/files\\\\/2018\\\\/05\\\\/client-4-126x37.png\\",\\"width_image\\":\\"126\\",\\"param_image\\":\\"regular\\"}}]},{\\"element_id\\":\\"c3cbca2\\",\\"grid_class\\":\\"col6-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"40a6550\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-app\\\\/files\\\\/2018\\\\/05\\\\/client-5-163x37.png\\",\\"width_image\\":\\"163\\",\\"param_image\\":\\"regular\\"}}]},{\\"element_id\\":\\"ea71902\\",\\"grid_class\\":\\"col6-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"becd842\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-app\\\\/files\\\\/2018\\\\/05\\\\/client-6-116x35.png\\",\\"width_image\\":\\"116\\",\\"param_image\\":\\"regular\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"col_mobile\\":\\"column3-1 tb_3col\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"60\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"80\\",\\"padding_bottom\\":\\"40\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\"}}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-app\\\\/files\\\\/2018\\\\/05\\\\/bg-section-brand.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"27\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"17\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_width\\":\\"fullwidth\\",\\"row_anchor\\":\\"clients\\",\\"breakpoint_mobile\\":{\\"padding_top\\":\\"28\\",\\"padding_top_unit\\":\\"%\\"}}},{\\"element_id\\":\\"a22d546\\",\\"cols\\":[{\\"element_id\\":\\"729e8ec\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"82dd18a\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"font_color_h2\\":\\"#405cc2\\",\\"content_text\\":\\"<h2>Features<\\\\/h2>\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"dc03087\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_size\\":\\"1.2\\",\\"font_size_unit\\":\\"em\\",\\"line_height\\":\\"1.9\\",\\"line_height_unit\\":\\"em\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"font_color_h2\\":\\"#405cc2\\",\\"content_text\\":\\"<p>Deserun mollit anim id est laborum.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod. Excepteur sint occaecat cupidatat.<\\\\/p>\\"}},{\\"element_id\\":\\"94d3bfa\\",\\"cols\\":[{\\"element_id\\":\\"3a4142f\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"c2348ab\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"40\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"title_feature\\":\\"Camera\\",\\"content_feature\\":\\"<p>Sed ut perspiciatis unde omnis iste natus error.<\\\\/p>\\",\\"layout_feature\\":\\"icon-right\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"#405cc2\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"image_icon\\",\\"image_feature\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-app\\\\/files\\\\/2018\\\\/05\\\\/camera-app-icon-1.png\\",\\"icon_color_feature\\":\\"#000\\",\\"link_options\\":\\"regular\\"}},{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"fb62852\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"40\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"title_feature\\":\\"Share\\",\\"content_feature\\":\\"<p>Excepteur sint occaecat cupidatat non proident.<\\\\/p>\\",\\"layout_feature\\":\\"icon-right\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"#405cc2\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"image_icon\\",\\"image_feature\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-app\\\\/files\\\\/2018\\\\/05\\\\/share-app-icon-1.png\\",\\"icon_color_feature\\":\\"#000\\",\\"link_options\\":\\"regular\\"}},{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"67baef9\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"40\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"title_feature\\":\\"Sync\\",\\"content_feature\\":\\"<p>At vero eos et accusamus et iusto odio dignissimos.<\\\\/p>\\",\\"layout_feature\\":\\"icon-right\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"#405cc2\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"image_icon\\",\\"image_feature\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-app\\\\/files\\\\/2018\\\\/05\\\\/sync-app-icon-1.png\\",\\"icon_feature\\":\\"fa-microchip\\",\\"icon_color_feature\\":\\"#405cc2\\",\\"link_options\\":\\"regular\\"}}]},{\\"element_id\\":\\"55721e4\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"330cefc\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-app\\\\/files\\\\/2018\\\\/11\\\\/iphone.png\\",\\"width_image\\":\\"345\\",\\"param_image\\":\\"regular\\",\\"animation_effect\\":\\"fadeInUp\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_bottom\\":\\"12\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\"}}},{\\"element_id\\":\\"49a9211\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"fbeb87f\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"40\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"title_feature\\":\\"Filter\\",\\"content_feature\\":\\"<p>Neque porro quisquam est, qui dolorem ipsum quiat.<\\\\/p>\\",\\"layout_feature\\":\\"icon-left\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"#405cc2\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"image_icon\\",\\"image_feature\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-app\\\\/files\\\\/2018\\\\/05\\\\/filter-app-icon-1.png\\",\\"icon_feature\\":\\"fa-microchip\\",\\"icon_color_feature\\":\\"#000\\",\\"link_options\\":\\"regular\\"}},{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"e18b9d9\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"40\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"title_feature\\":\\"Edit\\",\\"content_feature\\":\\"<p>Nemo enim ipsam voluptatem quia voluptas.<\\\\/p>\\",\\"layout_feature\\":\\"icon-left\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"#405cc2\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"image_icon\\",\\"image_feature\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-app\\\\/files\\\\/2018\\\\/05\\\\/edit-app-icon-1.png\\",\\"icon_feature\\":\\"fa-space-shuttle\\",\\"icon_color_feature\\":\\"#000\\",\\"link_options\\":\\"regular\\"}},{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"1725198\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"40\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"title_feature\\":\\"Effects\\",\\"content_feature\\":\\"<p>Nam libero tempore, cum soluta nobis est eligendi.<\\\\/p>\\",\\"layout_feature\\":\\"icon-left\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"#405cc2\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"image_icon\\",\\"image_feature\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-app\\\\/files\\\\/2018\\\\/05\\\\/effect-app-icon-1.png\\",\\"icon_feature\\":\\"fa-window-maximize\\",\\"icon_color_feature\\":\\"#823deb\\",\\"link_options\\":\\"regular\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_size\\":\\".9\\",\\"font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_left_unit\\":\\"em\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\"}}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_anchor\\":\\"features\\"}},{\\"element_id\\":\\"97e918f\\",\\"cols\\":[{\\"element_id\\":\\"0d8be3a\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"07758e1\\",\\"cols\\":[{\\"element_id\\":\\"37b7fa8\\",\\"grid_class\\":\\"col3-1\\"},{\\"element_id\\":\\"b0d6b7c\\",\\"grid_class\\":\\"col3-1\\"},{\\"element_id\\":\\"6c4c10f\\",\\"grid_class\\":\\"col3-1\\"}]}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-app\\\\/files\\\\/2018\\\\/05\\\\/bg-pricing.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"11\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"18\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\"},\\"row_width\\":\\"fullwidth\\",\\"row_anchor\\":\\"pricing\\"}},{\\"element_id\\":\\"a1404d5\\",\\"cols\\":[{\\"element_id\\":\\"e640881\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"0c826d0\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"font_color_h2\\":\\"#405cc2\\",\\"content_text\\":\\"<h2>Got Questions?<\\\\/h2>\\\\n<p>Don’t be shy. We are here to answer your questions 24\\\\/7.<\\\\/p>\\"}},{\\"element_id\\":\\"ead3a09\\",\\"cols\\":[{\\"element_id\\":\\"c09ce1f\\",\\"grid_class\\":\\"col4-1\\"},{\\"element_id\\":\\"08e1564\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"contact\\",\\"element_id\\":\\"f4e3db6\\",\\"mod_settings\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_border_inputs_apply_all\\":\\"1\\",\\"checkbox_border_send_apply_all\\":\\"1\\",\\"checkbox_padding_success_message_apply_all\\":\\"1\\",\\"checkbox_margin_success_message_apply_all\\":\\"1\\",\\"checkbox_border_success_message_apply_all\\":\\"1\\",\\"checkbox_padding_error_message_apply_all\\":\\"1\\",\\"checkbox_margin_error_message_apply_all\\":\\"1\\",\\"checkbox_border_error_message_apply_all\\":\\"1\\",\\"layout_contact\\":\\"animated-label\\",\\"field_name_label\\":\\"Your Name\\",\\"field_email_label\\":\\"Your Email\\",\\"field_subject_label\\":\\"Subject\\",\\"field_subject_require\\":\\"yes\\",\\"field_subject_active\\":\\"yes\\",\\"field_message_label\\":\\"Message\\",\\"field_extra\\":\\"{ \\\\\\"fields\\\\\\": [] }\\",\\"field_sendcopy_label\\":\\"Send a copy to myself\\",\\"field_order\\":\\"{}\\",\\"field_send_label\\":\\"Send\\",\\"field_send_align\\":\\"center\\",\\"field_email_active\\":\\"yes\\",\\"field_name_active\\":\\"yes\\",\\"field_message_active\\":\\"yes\\",\\"contact_sent_from\\":\\"enable\\",\\"send_to_admins\\":\\"true\\"}}]},{\\"element_id\\":\\"89b004c\\",\\"grid_class\\":\\"col4-1\\"}],\\"gutter\\":\\"gutter-none\\"}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_anchor\\":\\"contact\\"}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3385,
  'post_date' => '2015-04-16 20:19:17',
  'post_date_gmt' => '2015-04-16 20:19:17',
  'post_content' => '<!--themify_builder_static--><h1>Company</h1> <h3>Design your own company landing page with the Company Page 2 layout</h3> 
 <a href="https://themify.me/themes/" >Buy Now</a> 
 <img src="https://themify.me/demo/themes/landing/files/2015/03/Leaderboard_Free.png" width="500" alt="Horizontal" /> 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 <h3 style="text-align: left;"><em>Market Industry Expertise</em></h3><ul><li style="text-align: left;">Sales Revenue</li><li style="text-align: left;">Cost Associated Per Lead Acquisition</li><li style="text-align: left;">Online Marketing ROI</li><li style="text-align: left;">Site Traffic: Lead Ratio</li></ul> 
 <img src="https://themify.me/demo/themes/landing/files/2015/03/overview_display_hero.jpg" width="700" alt="Horizontal" /> 
 <h2 style="text-align: center;">OS Support</h2> 
 <p>[themify_icon icon="fa-quote-left" icon_color="#4A478F" ] It takes 20 years to build a reputation and five minutes to ruin it. If you think about that, you’ll do things differently.</p><p style="text-align: left;">– <em>Warren Buffett<br /></em>CEO of Berkshire Hathaway</p> 
 <h4>A Vision and Strategy for the Future</h4><p>Diversity and inclusion are integral to Microsoft’s vision, strategy and business success. We recognize that leadership in today’s global marketplace requires that we create a corporate culture and an inclusive business environment where the best and brightest diverse minds—employees with varied perspectives, skills, and experiences--work together to meet global consumer demands.  The collaboration of cultures, ideas, and different perspectives is an organizational asset and brings forth greater creativity and innovation.</p><p>Learn about our commitment to global diversity and inclusion, including our <a href="http://www.microsoft.com/about/en/xm/importedcontent/about/diversity/en/us/vision.aspx#Our Global Diversity &amp; Inclusion Vision Statement">vision</a>, <a href="http://www.microsoft.com/about/en/xm/importedcontent/about/diversity/en/us/vision.aspx#Key Growth Strategies">strategy</a>, and plans for the future.  <a href="http://www.microsoft.com/about/en/xm/importedcontent/about/diversity/en/us/vision.aspx">Read More...</a></p><p><a href="https://themify.me/demo/themes/landing/files/2015/03/microsoftlogov3.png"><img src="https://themify.me/demo/themes/landing/files/2015/03/microsoftlogov3.png" alt="microsoftlogov3" width="94" height="20" /></a></p> 
 <img src="https://themify.me/demo/themes/ultra/files/2015/06/model-2-1024x683-600x400.jpg" width="600" height="400" alt="model-2" srcset="https://themify.me/demo/themes/ultra/files/2015/06/model-2-1024x683-600x400.jpg 600w, https://themify.me/demo/themes/ultra/files/2015/06/model-2-300x200.jpg 300w, https://themify.me/demo/themes/ultra/files/2015/06/model-2-1024x683.jpg 1024w, https://themify.me/demo/themes/ultra/files/2015/06/model-2.jpg 1200w" sizes="(max-width: 600px) 100vw, 600px" /> 
 <img src="https://themify.me/demo/themes/ultra/files/2015/06/model-1-1024x614-1200x400.jpg" width="1200" height="400" alt="model-1" /> 
 <h4>Join Our Team</h4><ul><li><a href="#">Frontend Developer</a></li><li><a href="#">Designer</a></li><li><a href="#">Customer Support</a></li><li><a href="#">Social Media Strategist</a></li></ul> 
 <h4>Corporate Culture</h4><p><em><strong>Why work with US?</strong></em></p><p>Donec vehicula mi augue, eu vehicula lacus dapibus nec. Donec elementum tristique faucibus. Proin vitae turpis vel sem mattis egestas. Quisque vehicula, risus scelerisque porta malesuada, enim urna sodales lacus, laoreet venenatis nibh odio in metus. Donec pellentesque nisl sit amet dolor interdum, ac hendrerit elit ultricies. Vestibulum eget erat a dui porttitor blandit sed id leo. Duis commodo tincidunt dolor eu vulputate.</p><p><strong>Our Benefits:</strong></p><ul><li>Work from home flexibility</li><li>Competitive Salary </li><li>Health Care Benefits</li><li>Hardware of Choice at Work</li><li>Opportunities for Growth</li><li>Kitchen Snacks (Fruits, Chips, &amp; Pop)</li></ul><!--/themify_builder_static-->',
  'post_title' => 'Horizontal',
  'post_excerpt' => '',
  'post_name' => 'horizontal',
  'post_modified' => '2018-12-18 01:28:38',
  'post_modified_gmt' => '2018-12-18 01:28:38',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=3385',
  'menu_order' => 1,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'header_design' => 'header-horizontal',
    'mobile_menu_styles' => 'default',
    'footer_design' => 'footer-left-col',
    'more_posts' => 'pagination',
    'posts_per_page' => '2',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"font_color\\":\\"ffffff\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top_unit\\":\\"%\\",\\"margin_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h1>Company<\\\\/h1>\\\\n<h3>Design your own company landing page with the Company Page 2 layout<\\\\/h3>\\"},\\"element_id\\":\\"ljxt400\\"},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"font_weight\\":\\"bold\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"button_background_color\\":\\"#7933ac\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"large\\",\\"buttons_style\\":\\"squared\\",\\"content_button\\":[{\\"label\\":\\"Buy Now\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/themes\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"purple\\"}]},\\"element_id\\":\\"ily7554\\"}],\\"element_id\\":\\"31ft000\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/03\\\\/Leaderboard_Free.png\\",\\"width_image\\":\\"500\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"k3mq000\\"}],\\"element_id\\":\\"902g044\\"}],\\"element_id\\":\\"0wxx780\\"},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_stroke_feature\\":\\"0\\",\\"circle_color_feature\\":\\"#f59393_0.45\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-android\\",\\"icon_color_feature\\":\\"4A478F\\",\\"link_options\\":\\"regular\\"},\\"element_id\\":\\"wbjg940\\"}],\\"element_id\\":\\"4u52459\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_stroke_feature\\":\\"0\\",\\"circle_color_feature\\":\\"#f59393_0.46\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-linkedin-square\\",\\"icon_color_feature\\":\\"4A478F\\",\\"link_options\\":\\"regular\\"},\\"element_id\\":\\"qgth040\\"}],\\"element_id\\":\\"azbk440\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_stroke_feature\\":\\"0\\",\\"circle_color_feature\\":\\"#f59393_0.46\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-pinterest\\",\\"icon_color_feature\\":\\"4A478F\\",\\"link_options\\":\\"regular\\"},\\"element_id\\":\\"w1dm405\\"}],\\"element_id\\":\\"kghe005\\"},{\\"column_order\\":\\"3\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_stroke_feature\\":\\"0\\",\\"circle_color_feature\\":\\"#f59393_0.46\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-slideshare\\",\\"icon_color_feature\\":\\"4A478F\\",\\"link_options\\":\\"regular\\"},\\"element_id\\":\\"4u95490\\"}],\\"element_id\\":\\"6t38575\\"},{\\"column_order\\":\\"4\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_stroke_feature\\":\\"0\\",\\"circle_color_feature\\":\\"#e68a8a_0.45\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-reddit\\",\\"icon_color_feature\\":\\"4A478F\\",\\"link_options\\":\\"regular\\"},\\"element_id\\":\\"18vf000\\"}],\\"element_id\\":\\"st9c051\\"}],\\"element_id\\":\\"2ymx042\\"}],\\"element_id\\":\\"zsqa400\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"6D69C5\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff\\",\\"link_color\\":\\"ffffff\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\"},\\"element_id\\":\\"a1og606\\"},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3 style=\\\\\\\\\\\\\\"text-align: left;\\\\\\\\\\\\\\"><em>Market Industry Expertise<\\\\/em><\\\\/h3><ul><li style=\\\\\\\\\\\\\\"text-align: left;\\\\\\\\\\\\\\">Sales Revenue<\\\\/li><li style=\\\\\\\\\\\\\\"text-align: left;\\\\\\\\\\\\\\">Cost Associated Per Lead Acquisition<\\\\/li><li style=\\\\\\\\\\\\\\"text-align: left;\\\\\\\\\\\\\\">Online Marketing ROI<\\\\/li><li style=\\\\\\\\\\\\\\"text-align: left;\\\\\\\\\\\\\\">Site Traffic: Lead Ratio<\\\\/li><\\\\/ul>\\",\\"padding_top_unit\\":\\"%\\",\\"margin_top_unit\\":\\"%\\",\\"margin_left_unit\\":\\"%\\"},\\"element_id\\":\\"35ws455\\"}],\\"element_id\\":\\"omrt002\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-3\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/03\\\\/overview_display_hero.jpg\\",\\"width_image\\":\\"700\\"},\\"element_id\\":\\"aq89220\\"}],\\"element_id\\":\\"2u3o460\\"}],\\"element_id\\":\\"ddl1020\\"}],\\"element_id\\":\\"rz39000\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"6id1604\\"},{\\"row_order\\":\\"2\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">OS Support<\\\\/h2>\\"},\\"element_id\\":\\"mlwo040\\"}],\\"element_id\\":\\"m5wk053\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/03\\\\/os_x_yosemite_2-wallpaper-1366x768.jpg\\",\\"background_repeat\\":\\"builder-parallax-scrolling\\",\\"font_color\\":\\"ffffff_1.00\\",\\"link_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"22\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"22\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"ugjd300\\"},{\\"row_order\\":\\"3\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>[themify_icon icon=\\\\\\\\\\\\\\"fa-quote-left\\\\\\\\\\\\\\" icon_color=\\\\\\\\\\\\\\"#4A478F\\\\\\\\\\\\\\" ] It takes 20 years to build a reputation and five minutes to ruin it. If you think about that, you’ll do things differently.<\\\\/p><p style=\\\\\\\\\\\\\\"text-align: left;\\\\\\\\\\\\\\">– <em>Warren Buffett<br \\\\/><\\\\/em>CEO of Berkshire Hathaway<\\\\/p>\\",\\"font_color\\":\\"ffffff\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"15\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top_unit\\":\\"%\\",\\"margin_left_unit\\":\\"%\\"},\\"element_id\\":\\"7dzr544\\"}],\\"element_id\\":\\"5oj1380\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>A Vision and Strategy for the Future<\\\\/h4><p class=\\\\\\\\\\\\\\"alParagraph\\\\\\\\\\\\\\">Diversity and inclusion are integral to Microsoft’s vision, strategy and business success. We recognize that leadership in today’s global marketplace requires that we create a corporate culture and an inclusive business environment where the best and brightest diverse minds—employees with varied perspectives, skills, and experiences--work together to meet global consumer demands.  The collaboration of cultures, ideas, and different perspectives is an organizational asset and brings forth greater creativity and innovation.<\\\\/p><p class=\\\\\\\\\\\\\\"alParagraph\\\\\\\\\\\\\\">Learn about our commitment to global diversity and inclusion, including our <a href=\\\\\\\\\\\\\\"http:\\\\/\\\\/www.microsoft.com\\\\/about\\\\/en\\\\/xm\\\\/importedcontent\\\\/about\\\\/diversity\\\\/en\\\\/us\\\\/vision.aspx#Our Global Diversity &amp; Inclusion Vision Statement\\\\\\\\\\\\\\">vision<\\\\/a>, <a href=\\\\\\\\\\\\\\"http:\\\\/\\\\/www.microsoft.com\\\\/about\\\\/en\\\\/xm\\\\/importedcontent\\\\/about\\\\/diversity\\\\/en\\\\/us\\\\/vision.aspx#Key Growth Strategies\\\\\\\\\\\\\\">strategy<\\\\/a>, and plans for the future.  <a href=\\\\\\\\\\\\\\"http:\\\\/\\\\/www.microsoft.com\\\\/about\\\\/en\\\\/xm\\\\/importedcontent\\\\/about\\\\/diversity\\\\/en\\\\/us\\\\/vision.aspx\\\\\\\\\\\\\\">Read More...<\\\\/a><\\\\/p><p class=\\\\\\\\\\\\\\"alParagraph\\\\\\\\\\\\\\"><a href=\\\\\\\\\\\\\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/03\\\\/microsoftlogov3.png\\\\\\\\\\\\\\"><img class=\\\\\\\\\\\\\\"alignnone size-full wp-image-3142\\\\\\\\\\\\\\" src=\\\\\\\\\\\\\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/03\\\\/microsoftlogov3.png\\\\\\\\\\\\\\" alt=\\\\\\\\\\\\\\"microsoftlogov3\\\\\\\\\\\\\\" width=\\\\\\\\\\\\\\"94\\\\\\\\\\\\\\" height=\\\\\\\\\\\\\\"20\\\\\\\\\\\\\\" \\\\/><\\\\/a><\\\\/p>\\",\\"background_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\"},\\"element_id\\":\\"lgsv400\\"}],\\"element_id\\":\\"ayvj044\\"}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"background_type\\":\\"image\\",\\"background_color\\":\\"6d69c5_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"ifug604\\"},{\\"row_order\\":\\"4\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra\\\\/files\\\\/2015\\\\/06\\\\/model-2.jpg\\",\\"width_image\\":\\"600\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"400\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"tz3o055\\"}],\\"element_id\\":\\"32jk400\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra\\\\/files\\\\/2015\\\\/06\\\\/model-1.jpg\\",\\"width_image\\":\\"1200\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"400\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"h786055\\"}],\\"element_id\\":\\"ss16000\\"}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"m04l040\\"},{\\"row_order\\":\\"5\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>Join Our Team<\\\\/h4><ul><li><a href=\\\\\\\\\\\\\\"#\\\\\\\\\\\\\\">Frontend Developer<\\\\/a><\\\\/li><li><a href=\\\\\\\\\\\\\\"#\\\\\\\\\\\\\\">Designer<\\\\/a><\\\\/li><li><a href=\\\\\\\\\\\\\\"#\\\\\\\\\\\\\\">Customer Support<\\\\/a><\\\\/li><li><a href=\\\\\\\\\\\\\\"#\\\\\\\\\\\\\\">Social Media Strategist<\\\\/a><\\\\/li><\\\\/ul>\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"15\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top_unit\\":\\"%\\",\\"margin_left_unit\\":\\"%\\"},\\"element_id\\":\\"r6gj010\\"}],\\"element_id\\":\\"xzl2509\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>Corporate Culture<\\\\/h4><p><em><strong>Why work with US?<\\\\/strong><\\\\/em><\\\\/p><p>Donec vehicula mi augue, eu vehicula lacus dapibus nec. Donec elementum tristique faucibus. Proin vitae turpis vel sem mattis egestas. Quisque vehicula, risus scelerisque porta malesuada, enim urna sodales lacus, laoreet venenatis nibh odio in metus. Donec pellentesque nisl sit amet dolor interdum, ac hendrerit elit ultricies. Vestibulum eget erat a dui porttitor blandit sed id leo. Duis commodo tincidunt dolor eu vulputate.<\\\\/p><p class=\\\\\\\\\\\\\\"&quot;alParagraph&quot;\\\\\\\\\\\\\\"><strong>Our Benefits:<\\\\/strong><\\\\/p><ul><li class=\\\\\\\\\\\\\\"&quot;alParagraph&quot;\\\\\\\\\\\\\\">Work from home flexibility<\\\\/li><li class=\\\\\\\\\\\\\\"&quot;alParagraph&quot;\\\\\\\\\\\\\\">Competitive Salary <\\\\/li><li class=\\\\\\\\\\\\\\"&quot;alParagraph&quot;\\\\\\\\\\\\\\">Health Care Benefits<\\\\/li><li class=\\\\\\\\\\\\\\"&quot;alParagraph&quot;\\\\\\\\\\\\\\">Hardware of Choice at Work<\\\\/li><li class=\\\\\\\\\\\\\\"&quot;alParagraph&quot;\\\\\\\\\\\\\\">Opportunities for Growth<\\\\/li><li class=\\\\\\\\\\\\\\"&quot;alParagraph&quot;\\\\\\\\\\\\\\">Kitchen Snacks (Fruits, Chips, &amp; Pop)<\\\\/li><\\\\/ul>\\",\\"background_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\"},\\"element_id\\":\\"gh10004\\"}],\\"element_id\\":\\"ypzg036\\"}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"background_color\\":\\"f4f4f4_1.00\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"ox67575\\"},{\\"row_order\\":\\"6\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"xiv2060\\"}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"background_type\\":\\"image\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"rlij600\\"},{\\"row_order\\":\\"7\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"yafb040\\"}],\\"element_id\\":\\"lerl000\\"}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 7052,
  'post_date' => '2018-04-10 19:51:40',
  'post_date_gmt' => '2018-04-10 19:51:40',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h1>Beautiful Theme</h1>
<h2 style="text-align: center;">Great For Presentions</h2>
<h2 style="text-align: center;">Sexy Parallax Scrolling</h2>
<h2 style="text-align: center;">Start Your Own</h2>
<a href="https://themify.me/themes/ultra" > Get Ultra </a><!--/themify_builder_static-->',
  'post_title' => 'Horizontal Section Scrolling',
  'post_excerpt' => '',
  'post_name' => 'horizontal-section-scrolling',
  'post_modified' => '2019-09-24 01:34:01',
  'post_modified_gmt' => '2019-09-24 01:34:01',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=7052',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'section_full_scrolling' => 'yes',
    'section_scrolling_mobile' => 'on',
    'section_scrolling_direction' => 'horizontal',
    'section_scrolling_style' => 'single',
    'header_design' => 'header-top-bar',
    'mobile_menu_styles' => 'default',
    'header_wrap' => 'transparent',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"cb4eb66\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"b1edc2c\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"2a97dfb\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_repeat\\":\\"repeat\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h1>Beautiful Theme<\\\\/h1>\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/fullpane\\\\/files\\\\/2018\\\\/06\\\\/demoimage8.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"756f68\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"e8e8e8\\",\\"link_color\\":\\"f49ac1\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth\\",\\"row_height\\":\\"fullheight\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"a149aa1\\",\\"unstick_when_el_mod_id\\":\\"2a97dfb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"a149aa1\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"4ae5fc9\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"0aa1995\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Great For Presentions<\\\\/h2>\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/fullpane\\\\/files\\\\/2018\\\\/06\\\\/demoimage61.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"363338\\",\\"cover_color-type\\":\\"cover_gradient\\",\\"cover_gradient-gradient\\":\\"0% rgba(71, 114, 255, 0.65)|100% rgba(255, 195, 31, 0.7)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"ffffff\\",\\"link_color\\":\\"fff785\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth\\",\\"row_height\\":\\"fullheight\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"cb4eb66\\",\\"unstick_when_el_mod_id\\":\\"2a97dfb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"1c8dc7e\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"fe45e37\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"67fe6d1\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Sexy Parallax Scrolling<\\\\/h2>\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/fullpane\\\\/files\\\\/2018\\\\/06\\\\/demoimage16.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"363338\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"ffffff\\",\\"link_color\\":\\"fff785\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth\\",\\"row_height\\":\\"fullheight\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"cb4eb66\\",\\"unstick_when_el_mod_id\\":\\"2a97dfb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"82dc5a7\\",\\"row_order\\":\\"3\\",\\"cols\\":[{\\"element_id\\":\\"cc7a374\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"afbf06b\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Start Your Own<\\\\/h2>\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"09a03e7\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\",\\"buttons_size\\":\\"normal\\",\\"buttons_shape\\":\\"circle\\",\\"buttons_style\\":\\"outline\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Get Ultra\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/themes\\\\/ultra\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"cb4eb66\\",\\"unstick_when_el_mod_id\\":\\"2a97dfb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/fullpane\\\\/files\\\\/2018\\\\/06\\\\/demoimage12.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"363338\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"ffffff\\",\\"link_color\\":\\"fff785\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth\\",\\"row_height\\":\\"fullheight\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"cb4eb66\\",\\"unstick_when_el_mod_id\\":\\"2a97dfb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"e0ffd1f\\",\\"row_order\\":\\"4\\",\\"cols\\":[{\\"element_id\\":\\"aa9c1a9\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3397,
  'post_date' => '2015-04-16 20:36:46',
  'post_date_gmt' => '2015-04-16 20:36:46',
  'post_content' => '<!--themify_builder_static--><h2 style="text-align: center;">Welcome</h2><h3 style="text-align: center;">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat</h3> 
 <a href="https://themify.me/" >BUY THEME</a> 
 <h3><strong><a href="https://themify.me">Elegant Gothic</a></strong></h3> <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor [themify_icon icon="fa-chevron-right" link="https://themify.me" style="rounded small" icon_color="#fff" ]</p> 
 <h3><strong><a href="https://themify.me">Magnificent Retro</a></strong></h3><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor [themify_icon icon="fa-chevron-right" link="https://themify.me" style="rounded small" icon_color="#fff" ]</p> 
 <h3><strong><a href="https://themify.me">Beautiful Night</a><br /> </strong></h3> <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor [themify_icon icon="fa-chevron-right" link="https://themify.me" style="rounded small" icon_color="#fff" ]</p> 
 <h3><strong><a href="https://themify.me">Perfect Beach</a><br /> </strong></h3> <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor [themify_icon icon="fa-chevron-right" link="https://themify.me" style="rounded small" icon_color="#fff" ]</p> 
 <h3>I am English professional model and fashion designer. Check out my new collections</h3> 
 <a href="https://themify.me/" >READ MORE</a> 
 <ul data-id="slider-0-" data-visible="5" data-mob-visible="" data-scroll="1" data-auto-scroll="4" data-speed="1" data-wrap="yes" data-arrow="no" data-pagination="no" data-effect="continuously" data-height="variable" data-pause-on-hover="resume" > 
 <li> <a href="https://themify.me/" alt=""> <img src="https://themify.me/demo/themes/builder-layouts/files/2016/01/184724801-1-1024x775-475x320.jpg" width="475" height="320" alt="" /> </a> </li> <li> <a href="https://themify.me/" alt=""> <img src="https://themify.me/demo/themes/builder-layouts/files/2016/01/155256980-1024x683-475x320.jpg" width="475" height="320" alt="" /> </a> </li> <li> <a href="https://themify.me/" alt=""> <img src="https://themify.me/demo/themes/builder-layouts/files/2016/01/197408744-1024x684-475x320.jpg" width="475" height="320" alt="" /> </a> </li> <li> <a href="https://themify.me/" alt=""> <img src="https://themify.me/demo/themes/builder-layouts/files/2016/01/140830399-1-1024x686-475x320.jpg" width="475" height="320" alt="" /> </a> </li> <li> <a href="https://themify.me/" alt=""> <img src="https://themify.me/demo/themes/builder-layouts/files/2016/01/133815968-1024x683-475x320.jpg" width="475" height="320" alt="" /> </a> </li> </ul><!--/themify_builder_static-->',
  'post_title' => 'Left Pane',
  'post_excerpt' => '',
  'post_name' => 'left-pane',
  'post_modified' => '2018-07-17 17:46:25',
  'post_modified_gmt' => '2018-07-17 17:46:25',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=3397',
  'menu_order' => 5,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'color_design' => 'theme-color-purple',
    'header_design' => 'header-leftpane',
    'footer_design' => 'none',
    'more_posts' => 'pagination',
    'posts_per_page' => '2',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Welcome<\\\\/h2><h3 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat<\\\\/h3>\\",\\"font_color\\":\\"ffffff_1.00\\"},\\"element_id\\":\\"8eg2900\\"},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"font_size\\":\\"18\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"text_decoration\\":\\"none\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"outline\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"BUY THEME\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\"}]},\\"element_id\\":\\"pygl990\\"}],\\"element_id\\":\\"m0zi000\\"}],\\"styling\\":{\\"row_height\\":\\"fullheight\\",\\"custom_css_row\\":\\"full-height\\",\\"background_type\\":\\"video\\",\\"background_video\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/demo-videos\\\\/girl-street.mp4\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/demo-videos\\\\/girl-street.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_color\\":\\"ebe8b7\\",\\"cover_color\\":\\"000000_0.28\\",\\"font_color\\":\\"0a0a0a\\",\\"link_color\\":\\"000000\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"yjnq606\\"},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3><strong><a href=\\\\\\\\\\\\\\"https:\\\\/\\\\/themify.me\\\\\\\\\\\\\\">Elegant Gothic<\\\\/a><\\\\/strong><\\\\/h3>\\\\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor [themify_icon icon=\\\\\\\\\\\\\\"fa-chevron-right\\\\\\\\\\\\\\" link=\\\\\\\\\\\\\\"https:\\\\/\\\\/themify.me\\\\\\\\\\\\\\" style=\\\\\\\\\\\\\\"rounded small\\\\\\\\\\\\\\" icon_color=\\\\\\\\\\\\\\"#fff\\\\\\\\\\\\\\" ]<\\\\/p>\\\\n\\",\\"font_color\\":\\"ffffff_1.00\\",\\"link_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"35\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"20\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_left_unit\\":\\"%\\"},\\"element_id\\":\\"z30c500\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/90849914-4-1024x685.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"cover_color\\":\\"000000_0.42\\",\\"cover_color_hover\\":\\"421175_0.60\\"},\\"element_id\\":\\"stgh055\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3><strong><a href=\\\\\\\\\\\\\\"https:\\\\/\\\\/themify.me\\\\\\\\\\\\\\">Magnificent Retro<\\\\/a><\\\\/strong><\\\\/h3><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor [themify_icon icon=\\\\\\\\\\\\\\"fa-chevron-right\\\\\\\\\\\\\\" link=\\\\\\\\\\\\\\"https:\\\\/\\\\/themify.me\\\\\\\\\\\\\\" style=\\\\\\\\\\\\\\"rounded small\\\\\\\\\\\\\\" icon_color=\\\\\\\\\\\\\\"#fff\\\\\\\\\\\\\\" ]<\\\\/p>\\",\\"font_color\\":\\"ffffff_1.00\\",\\"link_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"35\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"20\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_left_unit\\":\\"%\\"},\\"element_id\\":\\"xzzw005\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/97591061-1024x683.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"cover_color\\":\\"030303_0.36\\",\\"cover_color_hover\\":\\"c49227_0.41\\"},\\"element_id\\":\\"49h8005\\"}],\\"gutter\\":\\"gutter-none\\",\\"element_id\\":\\"v4nq900\\"},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3><strong><a href=\\\\\\\\\\\\\\"https:\\\\/\\\\/themify.me\\\\\\\\\\\\\\">Beautiful Night<\\\\/a><br \\\\/>\\\\n<\\\\/strong><\\\\/h3>\\\\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor [themify_icon icon=\\\\\\\\\\\\\\"fa-chevron-right\\\\\\\\\\\\\\" link=\\\\\\\\\\\\\\"https:\\\\/\\\\/themify.me\\\\\\\\\\\\\\" style=\\\\\\\\\\\\\\"rounded small\\\\\\\\\\\\\\" icon_color=\\\\\\\\\\\\\\"#fff\\\\\\\\\\\\\\" ]<\\\\/p>\\\\n\\",\\"font_color\\":\\"ffffff_1.00\\",\\"link_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"35\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"20\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_left_unit\\":\\"%\\"},\\"element_id\\":\\"jl3o009\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/99449315-1024x724.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"cover_color\\":\\"000000_0.39\\",\\"cover_color_hover\\":\\"000000_0.73\\"},\\"element_id\\":\\"q9se005\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3><strong><a href=\\\\\\\\\\\\\\"https:\\\\/\\\\/themify.me\\\\\\\\\\\\\\">Perfect Beach<\\\\/a><br \\\\/>\\\\n<\\\\/strong><\\\\/h3>\\\\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor [themify_icon icon=\\\\\\\\\\\\\\"fa-chevron-right\\\\\\\\\\\\\\" link=\\\\\\\\\\\\\\"https:\\\\/\\\\/themify.me\\\\\\\\\\\\\\" style=\\\\\\\\\\\\\\"rounded small\\\\\\\\\\\\\\" icon_color=\\\\\\\\\\\\\\"#fff\\\\\\\\\\\\\\" ]<\\\\/p>\\\\n\\",\\"font_color\\":\\"ffffff_1.00\\",\\"link_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"35\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"20\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_left_unit\\":\\"%\\"},\\"element_id\\":\\"gafy990\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/194739149-1024x683.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"cover_color\\":\\"000000_0.48\\",\\"cover_color_hover\\":\\"3876bd_0.53\\"},\\"element_id\\":\\"4or4950\\"}],\\"gutter\\":\\"gutter-none\\",\\"element_id\\":\\"s1zp007\\"}],\\"element_id\\":\\"3imu705\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>I am English professional model and fashion designer. Check out my new collections<\\\\/h3>\\",\\"font_color\\":\\"000000_1.00\\",\\"link_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"40\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"30\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_left_unit\\":\\"%\\"},\\"element_id\\":\\"4uvf990\\"},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"squared\\",\\"content_button\\":[{\\"label\\":\\"READ MORE\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"button_color_bg\\":\\"black\\",\\"new_window\\":\\"0\\"}],\\"font_color\\":\\"ffffff_1.00\\",\\"font_size\\":\\"18\\",\\"link_color\\":\\"ffffff_1.00\\",\\"text_decoration\\":\\"none\\",\\"margin_left\\":\\"8\\",\\"margin_left_unit\\":\\"%\\"},\\"element_id\\":\\"dt5r095\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/96732010-2-1024x768.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"cover_color\\":\\"000000_0.20\\",\\"cover_color_hover\\":\\"000000_0.29\\"},\\"element_id\\":\\"kr45300\\"}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"fullcover\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"eoi3550\\"},{\\"row_order\\":\\"2\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"slider\\",\\"mod_settings\\":{\\"layout_display_slider\\":\\"image\\",\\"blog_category_slider\\":\\"|single\\",\\"slider_category_slider\\":\\"0|multiple\\",\\"portfolio_category_slider\\":\\"|single\\",\\"testimonial_category_slider\\":\\"|single\\",\\"posts_per_page_slider\\":\\"6\\",\\"offset_slider\\":\\"4\\",\\"order_slider\\":\\"desc\\",\\"orderby_slider\\":\\"date\\",\\"display_slider\\":\\"content\\",\\"img_content_slider\\":[{\\"img_url_slider\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/184724801-1-1024x775-475x320.jpg\\",\\"img_link_slider\\":\\"https:\\\\/\\\\/themify.me\\\\/\\"},{\\"img_url_slider\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/155256980-1024x683-475x320.jpg\\",\\"img_link_slider\\":\\"https:\\\\/\\\\/themify.me\\\\/\\"},{\\"img_url_slider\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/197408744-1024x684-475x320.jpg\\",\\"img_link_slider\\":\\"https:\\\\/\\\\/themify.me\\\\/\\"},{\\"img_url_slider\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/140830399-1-1024x686-475x320.jpg\\",\\"img_link_slider\\":\\"https:\\\\/\\\\/themify.me\\\\/\\"},{\\"img_url_slider\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/133815968-1024x683-475x320.jpg\\",\\"img_link_slider\\":\\"https:\\\\/\\\\/themify.me\\\\/\\"}],\\"layout_slider\\":\\"slider-default\\",\\"img_w_slider\\":\\"475\\",\\"img_h_slider\\":\\"320\\",\\"visible_opt_slider\\":\\"5\\",\\"auto_scroll_opt_slider\\":\\"4\\",\\"scroll_opt_slider\\":\\"1\\",\\"speed_opt_slider\\":\\"normal\\",\\"effect_slider\\":\\"continuously\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"wrap_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"no\\",\\"show_arrow_slider\\":\\"no\\",\\"height_slider\\":\\"variable\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"1nmq050\\"}],\\"element_id\\":\\"cxwb589\\"}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"custom_css_row\\":\\"fullwidth\\",\\"background_type\\":\\"image\\",\\"font_color\\":\\"7b0e35\\",\\"link_color\\":\\"7b0e35\\"},\\"element_id\\":\\"597a060\\"},{\\"row_order\\":\\"3\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"unhv501\\"}],\\"element_id\\":\\"zne1000\\"}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 5792,
  'post_date' => '2016-09-23 22:00:28',
  'post_date_gmt' => '2016-09-23 22:00:28',
  'post_content' => '<p><!--themify_builder_static-->
<ul><li><h4>Travel</h4><p>[list_posts category=\'travel\' style=\'grid3\' limit=\'3\' post_date=\'no\']</p></li><li><h4>Work</h4><p>[list_posts category=\'work\' style=\'grid3\' limit=\'3\' post_date=\'no\']</p></li><li><h4>Photography</h4><p>[list_posts category=\'photography\' style=\'grid3\' limit=\'3\' post_date=\'no\']</p></li></ul>
<h4>Photography</h4>

<h4>Work</h4>


<!--/themify_builder_static--></p>

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Magazine Header',
  'post_excerpt' => '',
  'post_name' => 'magazine-header',
  'post_modified' => '2019-04-30 18:13:06',
  'post_modified_gmt' => '2019-04-30 18:13:06',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=5792',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar1',
    'hide_page_title' => 'yes',
    'header_design' => 'header-magazine',
    'mobile_menu_styles' => 'default',
    'footer_design' => 'footer-left-col',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"slider\\",\\"mod_settings\\":{\\"layout_display_slider\\":\\"blog\\",\\"post_type\\":\\"post\\",\\"taxonomy\\":\\"category\\",\\"blog_category_slider\\":\\"work|multiple\\",\\"portfolio_category_slider\\":\\"|single\\",\\"posts_per_page_slider\\":\\"3\\",\\"order_slider\\":\\"desc\\",\\"orderby_slider\\":\\"date\\",\\"display_slider\\":\\"none\\",\\"hide_post_title_slider\\":\\"no\\",\\"unlink_post_title_slider\\":\\"no\\",\\"hide_feat_img_slider\\":\\"no\\",\\"unlink_feat_img_slider\\":\\"no\\",\\"layout_slider\\":\\"slider-overlay\\",\\"img_w_slider\\":\\"820\\",\\"img_h_slider\\":\\"480\\",\\"visible_opt_slider\\":\\"1\\",\\"auto_scroll_opt_slider\\":\\"4\\",\\"scroll_opt_slider\\":\\"1\\",\\"speed_opt_slider\\":\\"normal\\",\\"effect_slider\\":\\"scroll\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"wrap_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"yes\\",\\"show_arrow_slider\\":\\"yes\\",\\"height_slider\\":\\"variable\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"lopm338\\"}],\\"element_id\\":\\"drza820\\"}],\\"element_id\\":\\"5yyw288\\"},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"tab\\",\\"mod_settings\\":{\\"layout_tab\\":\\"minimal\\",\\"tab_content_tab\\":[{\\"title_tab\\":\\"Travel\\",\\"text_tab\\":\\"<p>[list_posts category=\\\\\\\\\\\'travel\\\\\\\\\\\' style=\\\\\\\\\\\'grid3\\\\\\\\\\\' limit=\\\\\\\\\\\'3\\\\\\\\\\\' post_date=\\\\\\\\\\\'no\\\\\\\\\\\']<\\\\/p>\\"},{\\"title_tab\\":\\"Work\\",\\"text_tab\\":\\"<p>[list_posts category=\\\\\\\\\\\'work\\\\\\\\\\\' style=\\\\\\\\\\\'grid3\\\\\\\\\\\' limit=\\\\\\\\\\\'3\\\\\\\\\\\' post_date=\\\\\\\\\\\'no\\\\\\\\\\\']<\\\\/p>\\"},{\\"title_tab\\":\\"Photography\\",\\"text_tab\\":\\"<p>[list_posts category=\\\\\\\\\\\'photography\\\\\\\\\\\' style=\\\\\\\\\\\'grid3\\\\\\\\\\\' limit=\\\\\\\\\\\'3\\\\\\\\\\\' post_date=\\\\\\\\\\\'no\\\\\\\\\\\']<\\\\/p>\\"}],\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"0\\",\\"title_text_align_left\\":\\"left\\",\\"title_text_align_center\\":\\"center\\",\\"title_text_align_right\\":\\"right\\",\\"title_text_align_justify\\":\\"justify\\",\\"title_checkbox_border_apply_all\\":\\"border\\",\\"content_checkbox_padding_apply_all\\":\\"padding\\",\\"content_checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"ktsc223\\"}],\\"element_id\\":\\"q0m1388\\"}],\\"element_id\\":\\"dta4230\\"},{\\"row_order\\":\\"2\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>Photography<\\\\/h4>\\",\\"background_image-type\\":\\"image\\",\\"padding_top\\":\\"5\\",\\"padding_bottom\\":\\"10\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_color\\":\\"dbdbdb\\",\\"border_top_width\\":\\"1\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"ck83803\\"},{\\"mod_name\\":\\"post\\",\\"mod_settings\\":{\\"layout_post\\":\\"list-post\\",\\"post_type_post\\":\\"post\\",\\"type_query_post\\":\\"category\\",\\"category_post\\":\\"photography|multiple\\",\\"post_tag_post\\":\\"|single\\",\\"product_cat_post\\":\\"|single\\",\\"product_tag_post\\":\\"|single\\",\\"product_shipping_class_post\\":\\"|single\\",\\"portfolio-category_post\\":\\"|single\\",\\"post_per_page_post\\":\\"1\\",\\"order_post\\":\\"desc\\",\\"orderby_post\\":\\"date\\",\\"display_post\\":\\"none\\",\\"img_width_post\\":\\"400\\",\\"img_height_post\\":\\"200\\",\\"hide_post_date_post\\":\\"yes\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_page_nav_post\\":\\"yes\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"jcbu338\\"}],\\"element_id\\":\\"2llf871\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"padding_top\\":\\"5\\",\\"padding_bottom\\":\\"10\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border_top_color\\":\\"dbdbdb\\",\\"border_top_width\\":\\"1\\",\\"content_text\\":\\"<h4>Work<\\\\/h4>\\"},\\"element_id\\":\\"op52288\\"},{\\"mod_name\\":\\"post\\",\\"mod_settings\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"layout_post\\":\\"list-post\\",\\"post_type_post\\":\\"post\\",\\"type_query_post\\":\\"category\\",\\"category_post\\":\\"work|multiple\\",\\"post_tag_post\\":\\"0|single\\",\\"product_cat_post\\":\\"0|single\\",\\"product_tag_post\\":\\"0|single\\",\\"product_shipping_class_post\\":\\"0|single\\",\\"post_filter\\":\\"no\\",\\"post_per_page_post\\":\\"1\\",\\"order_post\\":\\"desc\\",\\"orderby_post\\":\\"date\\",\\"display_post\\":\\"none\\",\\"img_width_post\\":\\"400\\",\\"img_height_post\\":\\"200\\",\\"hide_post_date_post\\":\\"yes\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_page_nav_post\\":\\"yes\\"},\\"element_id\\":\\"mo2w820\\"}],\\"element_id\\":\\"pn57072\\"}],\\"element_id\\":\\"z0nt770\\"},{\\"row_order\\":\\"3\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"post\\",\\"mod_settings\\":{\\"layout_post\\":\\"list-thumb-image\\",\\"post_type_post\\":\\"post\\",\\"type_query_post\\":\\"category\\",\\"category_post\\":\\"photography|multiple\\",\\"post_tag_post\\":\\"|single\\",\\"product_cat_post\\":\\"|single\\",\\"product_tag_post\\":\\"|single\\",\\"product_shipping_class_post\\":\\"|single\\",\\"portfolio-category_post\\":\\"|single\\",\\"post_per_page_post\\":\\"3\\",\\"offset_post\\":\\"1\\",\\"order_post\\":\\"desc\\",\\"orderby_post\\":\\"date\\",\\"display_post\\":\\"none\\",\\"img_width_post\\":\\"65\\",\\"img_height_post\\":\\"65\\",\\"hide_post_date_post\\":\\"yes\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_page_nav_post\\":\\"yes\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"un6q802\\"}],\\"element_id\\":\\"qcxb802\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"post\\",\\"mod_settings\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"layout_post\\":\\"list-thumb-image\\",\\"post_type_post\\":\\"post\\",\\"type_query_post\\":\\"category\\",\\"category_post\\":\\"work|multiple\\",\\"post_tag_post\\":\\"0|single\\",\\"product_cat_post\\":\\"0|single\\",\\"product_tag_post\\":\\"0|single\\",\\"product_shipping_class_post\\":\\"0|single\\",\\"post_filter\\":\\"no\\",\\"post_per_page_post\\":\\"3\\",\\"offset_post\\":\\"1\\",\\"order_post\\":\\"desc\\",\\"orderby_post\\":\\"date\\",\\"display_post\\":\\"none\\",\\"img_width_post\\":\\"65\\",\\"img_height_post\\":\\"65\\",\\"hide_post_date_post\\":\\"yes\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_page_nav_post\\":\\"yes\\"},\\"element_id\\":\\"sqww328\\"}],\\"element_id\\":\\"scjm828\\"}],\\"element_id\\":\\"xw3o808\\"},{\\"row_order\\":\\"4\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"6mcn088\\"}],\\"element_id\\":\\"mssf882\\"}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3400,
  'post_date' => '2015-04-16 20:38:35',
  'post_date_gmt' => '2015-04-16 20:38:35',
  'post_content' => '<!--themify_builder_static--><h1 style="text-align: right;">BMW i8</h1><h5 style="text-align: right;">Designed for Maximum Performance and Style</h5> 
 <a href="https://www.youtube.com/watch?v=XgxsUiY_n0w" > 
 
 </a> 
 <h4><br />To the Future</h4> 
 
 <h3>Performance</h3> 
 
 
 <h3>320 Nm Torque</h3> 
 
 <h3>Electric Driving</h3> 
 
 
 <h3>100% Electric</h3> 
 
 <h3>All-Wheel Drive</h3> 
 
 
 <h3>250 Km/h</h3> 
 
 <h1 style="text-align: center;">Impressive Design without Compromise</h1> 
 <ul data-id="slider-0-" data-visible="1" data-mob-visible="" data-scroll="1" data-auto-scroll="4" data-speed="1" data-wrap="yes" data-arrow="yes" data-pagination="yes" data-effect="scroll" data-height="variable" data-pause-on-hover="resume" > 
 <li> <img src="https://themify.me/demo/themes/landing/files/2015/03/4-wheel-01.jpg" width="800" alt="Efficiency &amp; Dyamics" /> 
 <h3> Efficiency & Dyamics </h3> <em>An Athlete in Top Form</em>
<ul> <li>Aerodynamic Design</li> <li>Aerodynamic Features</li> <li>Intelligent Lightweight Construction</li> </ul> </li> <li> <img src="https://themify.me/demo/themes/landing/files/2015/03/visions-01.jpg" width="800" alt="Design" /> 
 <h3> Design </h3> <em>Time for a new ideal</em>
<ul> <li>Ambient Light</li> <li>Sustainable Materials</li> <li>Exterior Colours</li> <li>Scissor Doors</li> </ul> </li> <li> <img src="https://themify.me/demo/themes/landing/files/2015/03/service-inclusive.jpg" width="800" alt="Safety" /> 
 <h3> Safety </h3> <em>Innovations that you can trust</em>
<ul> <li>Charging Assistant</li> <li>BMW TeleServices</li> <li>Mobility Assistance</li> <li>Maintenance and Repair Packages</li> </ul> </li> </ul> 
 <h3>Track Race Test</h3><p>The animation done on the right was through the use of the <a href="https://themify.me/addons/progress-bar">Progress Bar Addon</a>. Create your own progress bar now. See our demo page for the Progress Bar addon <a href="https://themify.me/demo/themes/addons/demo/progress-bar/">here</a>.</p> 
 <i>i8</i> <i>Test A</i> <i>Test B</i> <i>Test C</i><!--/themify_builder_static-->',
  'post_title' => 'Min Bar',
  'post_excerpt' => '',
  'post_name' => 'min-bar',
  'post_modified' => '2018-07-16 19:45:12',
  'post_modified_gmt' => '2018-07-16 19:45:12',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=3400',
  'menu_order' => 6,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'header_design' => 'header-minbar',
    'footer_design' => 'none',
    'more_posts' => 'pagination',
    'posts_per_page' => '2',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1 style=\\\\\\\\\\\\\\"text-align: right;\\\\\\\\\\\\\\">BMW i8<\\\\/h1><h5 style=\\\\\\\\\\\\\\"text-align: right;\\\\\\\\\\\\\\">Designed for Maximum Performance and Style<\\\\/h5>\\",\\"background_color\\":\\"000000_0.67\\",\\"padding_top\\":\\"10\\",\\"padding_right\\":\\"15\\",\\"padding_bottom\\":\\"10\\",\\"padding_left\\":\\"15\\",\\"margin_top_unit\\":\\"%\\",\\"margin_left_unit\\":\\"%\\"},\\"element_id\\":\\"aaok660\\"}],\\"element_id\\":\\"9wou644\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"content_feature\\":\\"<h4><br \\\\/>To the Future<\\\\/h4>\\",\\"layout_feature\\":\\"icon-left\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"3\\",\\"circle_color_feature\\":\\"ffffff_1.00\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-play\\",\\"icon_color_feature\\":\\"ffffff_1.00\\",\\"link_feature\\":\\"https:\\\\/\\\\/www.youtube.com\\\\/watch?v=XgxsUiY_n0w\\",\\"param_feature\\":\\"lightbox\\",\\"link_options\\":\\"\\"},\\"element_id\\":\\"l4k9969\\"}],\\"element_id\\":\\"td04767\\"}],\\"element_id\\":\\"ka51030\\"}],\\"element_id\\":\\"dajs124\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/03\\\\/bg-driving-pleasure-01.jpg\\",\\"background_repeat\\":\\"builder-parallax-scrolling\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"000000_0.69\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_color_hover\\":\\"000000_0.69\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"checkbox_border_inner_apply_all\\":\\"1\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"font_color\\":\\"ffffff\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_width\\":\\"fullwidth\\",\\"row_height\\":\\"fullheight\\"},\\"element_id\\":\\"m955430\\"},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"font_color_module_title\\":\\"#ffffff\\",\\"f_s_t_regular\\":\\"italic\\",\\"f_t_b\\":\\"bold\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"checkbox_c_m_apply_all\\":\\"1\\",\\"checkbox_c_b_apply_all\\":\\"1\\",\\"mod_title_feature\\":\\"Performance\\",\\"title_feature\\":\\"320 Nm Torque\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"3\\",\\"circle_color_feature\\":\\"ffffff\\",\\"circle_size_feature\\":\\"large\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-gears\\",\\"icon_color_feature\\":\\"ffffff\\",\\"link_options\\":\\"regular\\"},\\"element_id\\":\\"biao460\\"}],\\"element_id\\":\\"hqj7211\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"font_color_module_title\\":\\"#ffffff\\",\\"font_color_title\\":\\"#ffffff\\",\\"f_t_b\\":\\"bold\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"checkbox_c_m_apply_all\\":\\"1\\",\\"checkbox_c_b_apply_all\\":\\"1\\",\\"mod_title_feature\\":\\"Electric Driving\\",\\"title_feature\\":\\"100% Electric\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"3\\",\\"circle_color_feature\\":\\"ffffff\\",\\"circle_size_feature\\":\\"large\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-battery-full\\",\\"icon_color_feature\\":\\"ffffff\\",\\"link_options\\":\\"regular\\"},\\"element_id\\":\\"kce3654\\"}],\\"element_id\\":\\"komc066\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"font_color_module_title\\":\\"#ffffff\\",\\"f_t_b\\":\\"bold\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"checkbox_c_m_apply_all\\":\\"1\\",\\"checkbox_c_b_apply_all\\":\\"1\\",\\"mod_title_feature\\":\\"All-Wheel Drive\\",\\"title_feature\\":\\"250 Km\\\\/h\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"3\\",\\"circle_color_feature\\":\\"ffffff\\",\\"circle_size_feature\\":\\"large\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-car\\",\\"icon_color_feature\\":\\"ffffff\\",\\"link_options\\":\\"regular\\"},\\"element_id\\":\\"uz6i040\\"}],\\"element_id\\":\\"ajwb426\\"}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"background_color\\":\\"0069d2_1.00\\",\\"font_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"0yc3660\\"},{\\"row_order\\":\\"2\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Impressive Design without Compromise<\\\\/h1>\\",\\"background_color\\":\\"000000_0.45\\",\\"padding_top\\":\\"15\\",\\"padding_right\\":\\"15\\",\\"padding_bottom\\":\\"5\\",\\"padding_left\\":\\"15\\"},\\"element_id\\":\\"swmq066\\"}],\\"element_id\\":\\"87b8920\\"}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"row_height\\":\\"fullheight\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/03\\\\/exterior-fw-05.jpg\\",\\"background_repeat\\":\\"builder-parallax-scrolling\\",\\"font_color\\":\\"ffffff_1.00\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"h63x462\\"},{\\"row_order\\":\\"3\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"slider\\",\\"mod_settings\\":{\\"layout_display_slider\\":\\"image\\",\\"blog_category_slider\\":\\"|single\\",\\"slider_category_slider\\":\\"|single\\",\\"portfolio_category_slider\\":\\"|single\\",\\"testimonial_category_slider\\":\\"|single\\",\\"order_slider\\":\\"desc\\",\\"orderby_slider\\":\\"date\\",\\"display_slider\\":\\"content\\",\\"img_content_slider\\":[{\\"img_url_slider\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/03\\\\/4-wheel-01.jpg\\",\\"img_title_slider\\":\\"Efficiency & Dyamics\\",\\"img_caption_slider\\":\\"<em>An Athlete in Top Form<\\\\/em>\\\\n\\\\n<ul>\\\\n <li>Aerodynamic Design<\\\\/li>\\\\n <li>Aerodynamic Features<\\\\/li>\\\\n <li>Intelligent Lightweight Construction<\\\\/li>\\\\n<\\\\/ul>\\"},{\\"img_url_slider\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/03\\\\/visions-01.jpg\\",\\"img_title_slider\\":\\"Design\\",\\"img_caption_slider\\":\\"<em>Time for a new ideal<\\\\/em>\\\\n\\\\n<ul>\\\\n <li>Ambient Light<\\\\/li>\\\\n <li>Sustainable Materials<\\\\/li>\\\\n <li>Exterior Colours<\\\\/li>\\\\n <li>Scissor Doors<\\\\/li>\\\\n<\\\\/ul>\\"},{\\"img_url_slider\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/03\\\\/service-inclusive.jpg\\",\\"img_title_slider\\":\\"Safety\\",\\"img_caption_slider\\":\\"<em>Innovations that you can trust<\\\\/em>\\\\n\\\\n<ul>\\\\n <li>Charging Assistant<\\\\/li>\\\\n <li>BMW TeleServices<\\\\/li>\\\\n <li>Mobility Assistance<\\\\/li>\\\\n <li>Maintenance and Repair Packages<\\\\/li>\\\\n<\\\\/ul>\\"}],\\"layout_slider\\":\\"slider-agency\\",\\"img_w_slider\\":\\"800\\",\\"visible_opt_slider\\":\\"1\\",\\"auto_scroll_opt_slider\\":\\"4\\",\\"scroll_opt_slider\\":\\"1\\",\\"speed_opt_slider\\":\\"normal\\",\\"effect_slider\\":\\"scroll\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"wrap_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"yes\\",\\"show_arrow_slider\\":\\"yes\\",\\"height_slider\\":\\"variable\\",\\"padding_top_unit\\":\\"%\\"},\\"element_id\\":\\"pcis640\\"}],\\"element_id\\":\\"ckel650\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"eqc8565\\"},{\\"row_order\\":\\"4\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Track Race Test<\\\\/h3><p>The animation done on the right was through the use of the <a href=\\\\\\\\\\\\\\"https:\\\\/\\\\/themify.me\\\\/addons\\\\/progress-bar\\\\\\\\\\\\\\">Progress Bar Addon<\\\\/a>. Create your own progress bar now. See our demo page for the Progress Bar addon <a href=\\\\\\\\\\\\\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/addons\\\\/demo\\\\/progress-bar\\\\/\\\\\\\\\\\\\\">here<\\\\/a>.<\\\\/p>\\"},\\"element_id\\":\\"1hbe050\\"}],\\"element_id\\":\\"tsl8426\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"progressbar\\",\\"mod_settings\\":{\\"progress_bars\\":[{\\"bar_label\\":\\"i8\\",\\"bar_percentage\\":\\"100\\",\\"bar_color\\":\\"49d8f5\\"},{\\"bar_label\\":\\"Test A\\",\\"bar_percentage\\":\\"70\\",\\"bar_color\\":\\"ff0000\\"},{\\"bar_label\\":\\"Test B\\",\\"bar_percentage\\":\\"50\\",\\"bar_color\\":\\"b730ff\\"},{\\"bar_label\\":\\"Test C\\",\\"bar_percentage\\":\\"65\\",\\"bar_color\\":\\"ff5e00\\"}],\\"hide_percentage_text\\":\\"no\\"},\\"element_id\\":\\"ujr3660\\"}],\\"element_id\\":\\"7yd0699\\"}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"background_color\\":\\"edebf0_1.00\\",\\"font_color\\":\\"72747d_1.00\\",\\"link_color\\":\\"000000_1.00\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"bq7f245\\"},{\\"row_order\\":\\"5\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"5zh7666\\"}],\\"element_id\\":\\"kjpj042\\"}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3398,
  'post_date' => '2015-04-16 20:45:21',
  'post_date_gmt' => '2015-04-16 20:45:21',
  'post_content' => '<!--themify_builder_static--><h1 style="text-align: left;">Company Page</h1> <h3>Showoff Your Company Profile<br /> By importing this layout using the<br /> Builder Landing Theme</h3> <p style="text-align: left;"><i>Create your company landing page with this new layout with the Themify Landing Theme. Simply import using the Builder plugin, simple and easy. Get this layout now!</i></p> 
 <a href="https://themify.me/themes/landing/" >Buy Landing</a> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/mac.png" width="800" alt="" /> 
 <h1 style="text-align: center;">About Us</h1><p style="text-align: center;"><i>Phasellus scelerisque lacus imperdiet turpis iaculis tristique. Nam ornare, dui id faucibus tincidunt, ante lorem congue nibh, vitae auctor purus arcu et libero. Nullam semper, urna in efficitur consectetur, ipsum leo aliquam nisi, in ornare tellus lacus id velit. Pellentesque vulputate ipsum eu porta aliquam. Mauris pretium nunc sed metus vulputate interdum.</i></p> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/Leaderboard_Free1.png" width="600" alt="" /> 
 <h4 style="text-align: right;">Yay!</h4> 
 <h3 style="text-align: left;">Mission</h3><p style="text-align: left;">Phasellus scelerisque lacus imperdiet turpis iaculis tristique. Nam ornare, dui id faucibus tincidunt, ante lorem congue nibh, vitae auctor purus arcu et libero. </p> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/N9-cover-mint-16001.jpg" width="350" alt="" /> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/google-nexus-lime.jpg" width="350" alt="" /> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/3YNGIU4yRTO4DDifrEfA__MG_2885-1024x576-500x250.jpg" width="500" height="250" alt="" /> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/r2Xmw0IESdeCCu4eBb6d_33F3F57EBEB3600F3B377F32425EE595_B1280_1280_1200_800-1024x682-500x250.jpg" width="500" height="250" alt="" /> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/camera-man-1024x682-500x500.jpg" width="500" height="500" alt="" /> 
 <h3>Our Work</h3><p>Phasellus scelerisque lacus imperdiet turpis iaculis tristique. Nam ornare, dui id faucibus tincidunt, ante lorem congue nibh, vitae auctor purus arcu et libero. </p> 
 <h2 style="text-align: center;">Services</h2> 
 Newsletter 
 <p>Ut suscipit eget lacus id dictum. Praesent dapibus interdum lorem nec tempor. Maecenas finibus tristique neque, id placerat lorem venenatis vitae.</p> 
 Auto edit 
 <p>Ut suscipit eget lacus id dictum. Praesent dapibus interdum lorem nec tempor. Maecenas finibus tristique neque, id placerat lorem venenatis vitae.</p> 
 Images 
 <p>Ut suscipit eget lacus id dictum. Praesent dapibus interdum lorem nec tempor. Maecenas finibus tristique neque, id placerat lorem venenatis vitae.</p> 
 Live Chat Support 
 <p>Ut suscipit eget lacus id dictum. Praesent dapibus interdum lorem nec tempor. Maecenas finibus tristique neque, id placerat lorem venenatis vitae.</p> 
 Multi Layouts 
 <p>Ut suscipit eget lacus id dictum. Praesent dapibus interdum lorem nec tempor. Maecenas finibus tristique neque, id placerat lorem venenatis vitae.</p> 
 Color Pallete 
 <p>Ut suscipit eget lacus id dictum. Praesent dapibus interdum lorem nec tempor. Maecenas finibus tristique neque, id placerat lorem venenatis vitae.</p> 
 Easy Panel 
 <p>Ut suscipit eget lacus id dictum. Praesent dapibus interdum lorem nec tempor. Maecenas finibus tristique neque, id placerat lorem venenatis vitae.</p> 
 Unlimited Storages 
 <p>Ut suscipit eget lacus id dictum. Praesent dapibus interdum lorem nec tempor. Maecenas finibus tristique neque, id placerat lorem venenatis vitae.</p> 
 Shortcodes 
 <p>Ut suscipit eget lacus id dictum. Praesent dapibus interdum lorem nec tempor. Maecenas finibus tristique neque, id placerat lorem venenatis vitae.</p> 
 <h4>Subscribe to Themify Newsletter</h4><p>We\'ve got a lot of things in store for all of you. New system updates, themes, extendable Addons, and promotions! Be sure to stay connected by being a part of our mailing list. <br />[mc4wp_form]</p> 
 <h3 style="text-align: center;">Connect With Us</h3> 
 <a href="https://www.facebook.com/themify" > 
 
 </a> 
 
 
 <a href="https://twitter.com/themify" > 
 
 </a> 
 
 
 <a href="https://plus.google.com/u/0/b/109280316400365629341/109280316400365629341" > 
 
 </a> 
 
 
 <a href="https://www.rss.com/" > 
 
 </a> 
 
 
 <a href="https://www.linkedin.com/" > 
 
 </a><!--/themify_builder_static-->',
  'post_title' => 'No Header',
  'post_excerpt' => '',
  'post_name' => 'no-header',
  'post_modified' => '2018-08-27 19:16:07',
  'post_modified_gmt' => '2018-08-27 19:16:07',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=3398',
  'menu_order' => 7,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'header_design' => 'none',
    'header_wrap' => 'video',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h1 style=\\\\\\\\\\\\\\"text-align: left;\\\\\\\\\\\\\\">Company Page<\\\\/h1>\\\\n<h3>Showoff Your Company Profile<br \\\\/> By importing this layout using the<br \\\\/> Builder Landing Theme<\\\\/h3>\\\\n<p style=\\\\\\\\\\\\\\"text-align: left;\\\\\\\\\\\\\\"><i>Create your company landing page with this new layout with the Themify Landing Theme. Simply import using the Builder plugin, simple and easy. Get this layout now!<\\\\/i><\\\\/p>\\"},\\"element_id\\":\\"6as7711\\"},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"font_weight\\":\\"bold\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"link_color\\":\\"#ffffff\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"large\\",\\"buttons_style\\":\\"squared\\",\\"content_button\\":[{\\"label\\":\\"Buy Landing\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/themes\\\\/landing\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"light-green\\"}]},\\"element_id\\":\\"7qsp101\\"}],\\"element_id\\":\\"9xui501\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/mac.png\\",\\"width_image\\":\\"800\\",\\"margin_top\\":\\"10\\",\\"margin_top_unit\\":\\"%\\"},\\"element_id\\":\\"mvaz121\\"}],\\"element_id\\":\\"k23n012\\"}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-narrow\\",\\"styling\\":{\\"row_height\\":\\"fullheight\\",\\"background_type\\":\\"image\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/lady-beach-hat-1024x720.jpg\\",\\"background_repeat\\":\\"builder-parallax-scrolling\\",\\"cover_color\\":\\"000000_0.77\\",\\"cover_color_hover\\":\\"000000_0.79\\",\\"font_color\\":\\"ffffff_1.00\\",\\"link_color\\":\\"ffffff_1.00\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"kfla060\\"},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">About Us<\\\\/h1><p style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\"><i>Phasellus scelerisque lacus imperdiet turpis iaculis tristique. Nam ornare, dui id faucibus tincidunt, ante lorem congue nibh, vitae auctor purus arcu et libero. Nullam semper, urna in efficitur consectetur, ipsum leo aliquam nisi, in ornare tellus lacus id velit. Pellentesque vulputate ipsum eu porta aliquam. Mauris pretium nunc sed metus vulputate interdum.<\\\\/i><\\\\/p>\\"},\\"element_id\\":\\"3yzw012\\"},{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/Leaderboard_Free1.png\\",\\"width_image\\":\\"600\\",\\"margin_top\\":\\"30\\",\\"margin_bottom\\":\\"30\\"},\\"element_id\\":\\"ybyi780\\"}],\\"element_id\\":\\"4aof122\\"}],\\"styling\\":{\\"row_height\\":\\"fullheight\\",\\"background_type\\":\\"image\\",\\"background_color\\":\\"5e754f_1.00\\",\\"font_color\\":\\"ffffff_1.00\\",\\"link_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"2jmd120\\"},{\\"row_order\\":\\"2\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4 style=\\\\\\\\\\\\\\"text-align: right;\\\\\\\\\\\\\\">Yay!<\\\\/h4>\\"},\\"element_id\\":\\"0fus910\\"}],\\"element_id\\":\\"98hy022\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/google-nexus.jpg\\",\\"background_repeat\\":\\"builder-parallax-scrolling\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"87r2778\\"},{\\"row_order\\":\\"3\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3 style=\\\\\\\\\\\\\\"text-align: left;\\\\\\\\\\\\\\">Mission<\\\\/h3><p style=\\\\\\\\\\\\\\"text-align: left;\\\\\\\\\\\\\\">Phasellus scelerisque lacus imperdiet turpis iaculis tristique. Nam ornare, dui id faucibus tincidunt, ante lorem congue nibh, vitae auctor purus arcu et libero. <\\\\/p>\\",\\"font_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"margin_top_unit\\":\\"%\\",\\"margin_left_unit\\":\\"%\\"},\\"element_id\\":\\"kqjh221\\"}],\\"element_id\\":\\"q3sq221\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/N9-cover-mint-16001.jpg\\",\\"appearance_image\\":\\"rounded\\",\\"width_image\\":\\"350\\"},\\"element_id\\":\\"1r6y210\\"}],\\"element_id\\":\\"svd8000\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/google-nexus-lime.jpg\\",\\"appearance_image\\":\\"rounded\\",\\"width_image\\":\\"350\\"},\\"element_id\\":\\"jvzc100\\"}],\\"element_id\\":\\"jygf107\\"}],\\"element_id\\":\\"cr45002\\"}],\\"element_id\\":\\"45rc721\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_color\\":\\"729fa8_1.00\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"8y6k207\\"},{\\"row_order\\":\\"4\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"cxzm110\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/nexus-image.jpg\\",\\"background_repeat\\":\\"builder-parallax-scrolling\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"15\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"a4k5717\\"},{\\"row_order\\":\\"5\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/3YNGIU4yRTO4DDifrEfA__MG_2885-1024x576-500x250.jpg\\",\\"width_image\\":\\"500\\",\\"height_image\\":\\"250\\"},\\"element_id\\":\\"l84i210\\"},{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/r2Xmw0IESdeCCu4eBb6d_33F3F57EBEB3600F3B377F32425EE595_B1280_1280_1200_800-1024x682-500x250.jpg\\",\\"width_image\\":\\"500\\",\\"height_image\\":\\"250\\"},\\"element_id\\":\\"5le3222\\"}],\\"element_id\\":\\"552b200\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/camera-man-1024x682-500x500.jpg\\",\\"width_image\\":\\"500\\",\\"height_image\\":\\"500\\"},\\"element_id\\":\\"u1zq502\\"}],\\"element_id\\":\\"vgrv220\\"}],\\"gutter\\":\\"gutter-none\\",\\"element_id\\":\\"nls0299\\"}],\\"element_id\\":\\"kmuc110\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Our Work<\\\\/h3><p>Phasellus scelerisque lacus imperdiet turpis iaculis tristique. Nam ornare, dui id faucibus tincidunt, ante lorem congue nibh, vitae auctor purus arcu et libero. <\\\\/p>\\",\\"font_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"margin_top_unit\\":\\"%\\",\\"margin_left_unit\\":\\"%\\"},\\"element_id\\":\\"6kdh788\\"}],\\"element_id\\":\\"ld1g126\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_color\\":\\"7b5d80_1.00\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"9xw3727\\"},{\\"row_order\\":\\"6\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"2m45222\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/nexus-iggy.jpg\\",\\"background_repeat\\":\\"builder-parallax-scrolling\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"d70a129\\"},{\\"row_order\\":\\"7\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Services<\\\\/h2>\\",\\"font_color\\":\\"ffffff_1.00\\",\\"padding_top_unit\\":\\"%\\",\\"margin_top_unit\\":\\"%\\",\\"margin_left_unit\\":\\"%\\"},\\"element_id\\":\\"9aue230\\"},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"text_transform\\":\\"uppercase\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"20\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"icon_size\\":\\"large\\",\\"icon_style\\":\\"none\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"fa-newspaper-o\\",\\"label\\":\\"Newsletter\\",\\"link_options\\":\\"regular\\"}],\\"icon_position\\":\\"icon_position_left\\"},\\"element_id\\":\\"57ds773\\"},{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<p>Ut suscipit eget lacus id dictum. Praesent dapibus interdum lorem nec tempor. Maecenas finibus tristique neque, id placerat lorem venenatis vitae.<\\\\/p>\\"},\\"element_id\\":\\"tpwe139\\"}],\\"element_id\\":\\"ij8f772\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"text_transform\\":\\"uppercase\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"20\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"icon_size\\":\\"large\\",\\"icon_style\\":\\"none\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-pencil-alt\\",\\"label\\":\\"Auto edit\\",\\"link_options\\":\\"regular\\"}],\\"icon_position\\":\\"icon_position_left\\"},\\"element_id\\":\\"0kng021\\"},{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<p>Ut suscipit eget lacus id dictum. Praesent dapibus interdum lorem nec tempor. Maecenas finibus tristique neque, id placerat lorem venenatis vitae.<\\\\/p>\\"},\\"element_id\\":\\"5zam177\\"}],\\"element_id\\":\\"qwoy710\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"text_transform\\":\\"uppercase\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"20\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"icon_size\\":\\"large\\",\\"icon_style\\":\\"none\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-image\\",\\"label\\":\\"Images\\",\\"link_options\\":\\"regular\\"}],\\"icon_position\\":\\"icon_position_left\\"},\\"element_id\\":\\"gnxn770\\"},{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<p>Ut suscipit eget lacus id dictum. Praesent dapibus interdum lorem nec tempor. Maecenas finibus tristique neque, id placerat lorem venenatis vitae.<\\\\/p>\\"},\\"element_id\\":\\"nnbw457\\"}],\\"element_id\\":\\"lcua122\\"}],\\"element_id\\":\\"q0ue010\\"},{\\"row_order\\":\\"2\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"text_transform\\":\\"uppercase\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"20\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"icon_size\\":\\"large\\",\\"icon_style\\":\\"none\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-comment\\",\\"label\\":\\"Live Chat Support\\",\\"link_options\\":\\"regular\\"}],\\"icon_position\\":\\"icon_position_left\\"},\\"element_id\\":\\"94aq070\\"},{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<p>Ut suscipit eget lacus id dictum. Praesent dapibus interdum lorem nec tempor. Maecenas finibus tristique neque, id placerat lorem venenatis vitae.<\\\\/p>\\"},\\"element_id\\":\\"r1yj241\\"}],\\"element_id\\":\\"1cil072\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"text_transform\\":\\"uppercase\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"20\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"icon_size\\":\\"large\\",\\"icon_style\\":\\"none\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-layers-alt\\",\\"label\\":\\"Multi Layouts\\",\\"link_options\\":\\"regular\\"}],\\"icon_position\\":\\"icon_position_left\\"},\\"element_id\\":\\"sgsg271\\"},{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<p>Ut suscipit eget lacus id dictum. Praesent dapibus interdum lorem nec tempor. Maecenas finibus tristique neque, id placerat lorem venenatis vitae.<\\\\/p>\\"},\\"element_id\\":\\"o3hr020\\"}],\\"element_id\\":\\"dknk510\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"text_transform\\":\\"uppercase\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"20\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"icon_size\\":\\"large\\",\\"icon_style\\":\\"none\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-palette\\",\\"label\\":\\"Color Pallete\\",\\"link_options\\":\\"regular\\"}],\\"icon_position\\":\\"icon_position_left\\"},\\"element_id\\":\\"t1le027\\"},{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<p>Ut suscipit eget lacus id dictum. Praesent dapibus interdum lorem nec tempor. Maecenas finibus tristique neque, id placerat lorem venenatis vitae.<\\\\/p>\\"},\\"element_id\\":\\"ch5g052\\"}],\\"element_id\\":\\"fewb012\\"}],\\"element_id\\":\\"yqv2262\\"},{\\"row_order\\":\\"3\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"text_transform\\":\\"uppercase\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"20\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"icon_size\\":\\"large\\",\\"icon_style\\":\\"none\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-panel\\",\\"label\\":\\"Easy Panel\\",\\"link_options\\":\\"regular\\"}],\\"icon_position\\":\\"icon_position_left\\"},\\"element_id\\":\\"sw9n505\\"},{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<p>Ut suscipit eget lacus id dictum. Praesent dapibus interdum lorem nec tempor. Maecenas finibus tristique neque, id placerat lorem venenatis vitae.<\\\\/p>\\"},\\"element_id\\":\\"3c5s720\\"}],\\"element_id\\":\\"vbin025\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"text_transform\\":\\"uppercase\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"20\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"icon_size\\":\\"large\\",\\"icon_style\\":\\"none\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-harddrives\\",\\"label\\":\\"Unlimited Storages\\",\\"link_options\\":\\"regular\\"}],\\"icon_position\\":\\"icon_position_left\\"},\\"element_id\\":\\"ihoa212\\"},{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<p>Ut suscipit eget lacus id dictum. Praesent dapibus interdum lorem nec tempor. Maecenas finibus tristique neque, id placerat lorem venenatis vitae.<\\\\/p>\\"},\\"element_id\\":\\"0wkb102\\"}],\\"element_id\\":\\"xwfn221\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"text_transform\\":\\"uppercase\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"20\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"icon_size\\":\\"large\\",\\"icon_style\\":\\"none\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-shortcode\\",\\"label\\":\\"Shortcodes\\",\\"link_options\\":\\"regular\\"}],\\"icon_position\\":\\"icon_position_left\\"},\\"element_id\\":\\"6lz5002\\"},{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<p>Ut suscipit eget lacus id dictum. Praesent dapibus interdum lorem nec tempor. Maecenas finibus tristique neque, id placerat lorem venenatis vitae.<\\\\/p>\\"},\\"element_id\\":\\"dv8w601\\"}],\\"element_id\\":\\"wxli167\\"}],\\"element_id\\":\\"0lvq207\\"}],\\"element_id\\":\\"1447100\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_color\\":\\"666696_1.00\\",\\"font_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"tnis017\\"},{\\"row_order\\":\\"8\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-1\\",\\"element_id\\":\\"3l5i220\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>Subscribe to Themify Newsletter<\\\\/h4><p>We\\\\\\\\\\\'ve got a lot of things in store for all of you. New system updates, themes, extendable Addons, and promotions! Be sure to stay connected by being a part of our mailing list. <br \\\\/>[mc4wp_form]<\\\\/p>\\"},\\"element_id\\":\\"pu9h417\\"}],\\"element_id\\":\\"bvch107\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col4-1\\",\\"element_id\\":\\"v167112\\"}],\\"element_id\\":\\"t3g4072\\"}],\\"element_id\\":\\"rwdf027\\"}],\\"styling\\":{\\"background_type\\":\\"video\\",\\"background_color\\":\\"c9ab32_1.00\\",\\"font_color\\":\\"000000_1.00\\",\\"link_color\\":\\"000000_1.00\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"f4mc162\\"},{\\"row_order\\":\\"9\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Connect With Us<\\\\/h3>\\"},\\"element_id\\":\\"2n2v707\\"},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"link_color\\":\\"5A71BB\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_color_feature\\":\\"#de5d5d\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-facebook\\",\\"icon_color_feature\\":\\"7B7A7A\\",\\"icon_bg_feature\\":\\"ffffff\\",\\"link_feature\\":\\"https:\\\\/\\\\/www.facebook.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"circle_percentage_feature\\":\\"0\\"},\\"element_id\\":\\"jozq707\\"}],\\"element_id\\":\\"zhsc021\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"link_color\\":\\"5A71BB\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"checkbox_c_m_apply_all\\":\\"1\\",\\"checkbox_c_b_apply_all\\":\\"1\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_color_feature\\":\\"#de5d5d\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-twitter\\",\\"icon_color_feature\\":\\"7B7A7A\\",\\"icon_bg_feature\\":\\"ffffff\\",\\"link_feature\\":\\"https:\\\\/\\\\/twitter.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"circle_percentage_feature\\":\\"0\\"},\\"element_id\\":\\"gspn107\\"}],\\"element_id\\":\\"53l3138\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"link_color\\":\\"5A71BB\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"checkbox_c_m_apply_all\\":\\"1\\",\\"c_b-type\\":\\"top\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_color_feature\\":\\"#de5d5d\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-google-plus\\",\\"icon_color_feature\\":\\"7B7A7A\\",\\"icon_bg_feature\\":\\"ffffff\\",\\"link_feature\\":\\"https:\\\\/\\\\/plus.google.com\\\\/u\\\\/0\\\\/b\\\\/109280316400365629341\\\\/109280316400365629341\\",\\"link_options\\":\\"regular\\"},\\"element_id\\":\\"t72u722\\"}],\\"element_id\\":\\"mtxr200\\"},{\\"column_order\\":\\"3\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"link_color\\":\\"5A71BB\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_color_feature\\":\\"#de5d5d\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-rss\\",\\"icon_color_feature\\":\\"7B7A7A\\",\\"icon_bg_feature\\":\\"ffffff\\",\\"link_feature\\":\\"https:\\\\/\\\\/www.rss.com\\\\/\\",\\"link_options\\":\\"regular\\",\\"circle_percentage_feature\\":\\"0\\"},\\"element_id\\":\\"25xp720\\"}],\\"element_id\\":\\"8wsm002\\"},{\\"column_order\\":\\"4\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"link_color\\":\\"5A71BB\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_color_feature\\":\\"#de5d5d\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-linkedin\\",\\"icon_color_feature\\":\\"7B7A7A\\",\\"icon_bg_feature\\":\\"ffffff\\",\\"link_feature\\":\\"https:\\\\/\\\\/www.linkedin.com\\\\/\\",\\"link_options\\":\\"regular\\",\\"circle_percentage_feature\\":\\"0\\"},\\"element_id\\":\\"ua8m090\\"}],\\"element_id\\":\\"3j40000\\"}],\\"col_mobile\\":\\"column5-1\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"checkbox_border_inner_apply_all\\":\\"1\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top\\":\\"9\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"checkbox_border_inner_apply_all\\":\\"1\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\"},\\"breakpoint_tablet_landscape\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"checkbox_border_inner_apply_all\\":\\"1\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\"}},\\"element_id\\":\\"tnqc020\\"}],\\"element_id\\":\\"1in6277\\"}],\\"gutter\\":\\"gutter-none\\",\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#d46060\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff\\",\\"link_color\\":\\"ffffff\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_width\\":\\"fullwidth\\"},\\"element_id\\":\\"9w6p172\\"},{\\"row_order\\":\\"10\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"uvp8109\\"}],\\"element_id\\":\\"lo6d092\\"}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 4907,
  'post_date' => '2016-03-14 20:22:11',
  'post_date_gmt' => '2016-03-14 20:22:11',
  'post_content' => '<!--themify_builder_static--><img src="https://themify.me/demo/themes/builder-layouts/files/2016/01/Apple-Watch_MockUp_typeA-1-650x662.png" width="650" alt="Overlay" /> 
 <h1>Smart Watch</h1><h3>Change the way you see time</h3> 
 <h1>Why Smart Watch?</h1><h3>Sed sagittis, elit egestas rutrum vehicula, neque dolor fringilla lacus, ut rhoncus turpis augue vitae libero. Nam risus velit, rhoncus eget consectetur id, posuere eget diam pretium cursus at ligula.</h3> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2016/01/Apple_Watch_Mockup_juank85-3-550x536.png" width="550" alt="Overlay" /> 
 <h3>Phone Connect</h3> 
 <a href="https://themify.me/" >LEARN MORE</a> 
 <h3>Fitness Tracker</h3> 
 <a href="https://themify.me/" >LEARN MORE</a> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2016/01/apple-watch-moxtra-app-1024x537-550x288.png" width="550" alt="Overlay" /> 
 <h1>Colors</h1><h3>Sed sagittis, elit egestas rutrum vehicula, neque dolor fringilla lacus, ut rhoncus turpis augue vitae libero. Nam risus velit, rhoncus eget consectetur id, posuere at ligula.</h3> 
 <h1>Get Smart Watch</h1><h3>Buy from our store and get 30% off</h3> 
 <a href="http://themify.me/" >BUY NOW</a><!--/themify_builder_static-->',
  'post_title' => 'Overlay',
  'post_excerpt' => '',
  'post_name' => 'overlay',
  'post_modified' => '2018-12-18 02:42:12',
  'post_modified_gmt' => '2018-12-18 02:42:12',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=4907',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'custom_menu' => 'header-overlay-menu',
    'header_design' => 'header-overlay',
    'mobile_menu_styles' => 'default',
    'footer_design' => 'none',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/Apple-Watch_MockUp_typeA-1-650x662.png\\",\\"width_image\\":\\"650\\",\\"auto_fullwidth\\":\\"1\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"4tvo590\\"}],\\"element_id\\":\\"uycm700\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>Smart Watch<\\\\/h1><h3>Change the way you see time<\\\\/h3>\\",\\"font_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"35\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"13\\",\\"padding_left_unit\\":\\"%\\"},\\"element_id\\":\\"v5ly284\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/Apple_Watch_MockUp_typeB-4.png\\",\\"background_repeat\\":\\"fullcover\\"},\\"element_id\\":\\"k3ju608\\"}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_width\\":\\"fullwidth-content\\",\\"visibility_all\\":\\"hide_all\\"},\\"element_id\\":\\"ah5d050\\"},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>Why Smart Watch?<\\\\/h1><h3>Sed sagittis, elit egestas rutrum vehicula, neque dolor fringilla lacus, ut rhoncus turpis augue vitae libero. Nam risus velit, rhoncus eget consectetur id, posuere eget diam pretium cursus at ligula.<\\\\/h3>\\",\\"font_color\\":\\"000000_1.00\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"12\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\"},\\"element_id\\":\\"v6w2009\\"}],\\"element_id\\":\\"461f080\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-right\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/Apple_Watch_Mockup_juank85-3-550x536.png\\",\\"width_image\\":\\"550\\"},\\"element_id\\":\\"fzuh800\\"}],\\"element_id\\":\\"tjcr820\\"}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_color\\":\\"f2f2f2\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"6\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"6\\",\\"padding_left_unit\\":\\"%\\"},\\"element_id\\":\\"o88h080\\"},{\\"row_order\\":\\"2\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Phone Connect<\\\\/h3>\\",\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"wf2u500\\"},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"20\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"link_color\\":\\"ffffff\\",\\"link_color_hover\\":\\"000000\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"outline\\",\\"content_button\\":[{\\"label\\":\\"LEARN MORE\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\"}]},\\"element_id\\":\\"ehi6222\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/iphone-1021293_1920.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"cover_color\\":\\"000000_0.55\\",\\"cover_color_hover\\":\\"000000_0.89\\",\\"padding_top\\":\\"0\\"},\\"element_id\\":\\"zt99507\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Fitness Tracker<\\\\/h3>\\",\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"oezj000\\"},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"20\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"link_color\\":\\"ffffff\\",\\"link_color_hover\\":\\"000000\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"outline\\",\\"content_button\\":[{\\"label\\":\\"LEARN MORE\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\"}]},\\"element_id\\":\\"w5ne121\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/fitnessmockup-1.png\\",\\"background_repeat\\":\\"fullcover\\",\\"cover_color\\":\\"000000_0.51\\",\\"cover_color_hover\\":\\"000000_0.85\\"},\\"element_id\\":\\"dmky858\\"}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\"},\\"element_id\\":\\"wzh6828\\"},{\\"row_order\\":\\"3\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/apple-watch-moxtra-app-1024x537-550x288.png\\",\\"width_image\\":\\"550\\",\\"padding_top\\":\\"17\\",\\"padding_top_unit\\":\\"%\\"},\\"element_id\\":\\"agpf225\\"}],\\"element_id\\":\\"6l1k080\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>Colors<\\\\/h1><h3>Sed sagittis, elit egestas rutrum vehicula, neque dolor fringilla lacus, ut rhoncus turpis augue vitae libero. Nam risus velit, rhoncus eget consectetur id, posuere at ligula.<\\\\/h3>\\",\\"font_color\\":\\"000000_1.00\\",\\"padding_top\\":\\"7\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_left_unit\\":\\"%\\"},\\"element_id\\":\\"mp9h202\\"}],\\"element_id\\":\\"kp14285\\"}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat-none\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"6\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"6\\",\\"padding_left_unit\\":\\"%\\"},\\"element_id\\":\\"7l6g028\\"},{\\"row_order\\":\\"4\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>Get Smart Watch<\\\\/h1><h3>Buy from our store and get 30% off<\\\\/h3>\\",\\"text_align\\":\\"center\\",\\"margin_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"sgqc992\\"},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"circle\\",\\"content_button\\":[{\\"label\\":\\"BUY NOW\\",\\"link\\":\\"http:\\\\/\\\\/themify.me\\\\/\\",\\"button_color_bg\\":\\"blue\\",\\"new_window\\":\\"0\\"}],\\"font_color\\":\\"ffffff_1.00\\",\\"font_size\\":\\"20\\",\\"text_align\\":\\"center\\",\\"margin_bottom\\":\\"6\\",\\"margin_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"my12900\\"}],\\"element_id\\":\\"nxua802\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_color\\":\\"f2f2f2\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"6\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"6\\",\\"padding_left_unit\\":\\"%\\"},\\"element_id\\":\\"kjo8080\\"},{\\"row_order\\":\\"5\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"0o51925\\"}],\\"element_id\\":\\"piym252\\"}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 4919,
  'post_date' => '2016-03-14 21:17:33',
  'post_date_gmt' => '2016-03-14 21:17:33',
  'post_content' => '<!--themify_builder_static--><h1>Course Manager</h1><h3>Create and manage online courses</h3>
 
 <a href="https://themify.me/" > SIGN UP FOR FREE </a> 
 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2016/01/dashboard-2-800x436.png" width="800" alt="" /> 
 <h2 style="text-align: left;">What is Course Manager?</h2><p style="text-align: left;">Course Manager is application for creating online course and monitoring all courses you created in one single dashboard. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>
 
 <a href="https://themify.me/" > SIGN UP FOR FREE </a> 
 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2016/01/big8-1024x760-1024x760.png" width="1024" alt="" /> 
 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2016/01/big6-1024x760.png" width="1024" alt="" /> 
 <h2 style="text-align: left;">Course and Exam Monitoring</h2><p style="text-align: left;">Course Manager is application for creating online course and monitoring all courses you created in one single dashboard. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod.</p>
 
 <a href="https://themify.me/" > SIGN UP FOR FREE </a> 
 <h2 style="text-align: left;">Interactive interface</h2><p style="text-align: left;">Course Manager is application for creating online course and monitoring all courses you created in one single dashboard. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>
 
 <a href="https://themify.me/" > SIGN UP FOR FREE </a> 
 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2016/01/big9-1024x760.png" width="1024" alt="" /> 
 <h1>Share your online course</h1> <h3>Join with million users around the world</h3>
 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2016/01/report-illegal-and-harmful-content-gt-grey-world-map-free-31918-2-1024x492.png" width="1024" alt="" /> 
 <h1>Testimonials</h1><h3>What they say about Course Manager</h3>
 <ul data-id="slider-0-" data-visible="1" data-scroll="1" data-auto-scroll="4" data-speed="1" data-wrap="yes" data-arrow="yes" data-pagination="yes" data-effect="scroll" data-height="variable" data-pause-on-hover="resume" > <li> <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p><p><strong>Jane Doe</strong><br /> <em>founder of somewebsite</em></p> </li> <li> <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p><p><strong>John Doe</strong><br /> <em>founder of somewebsite</em></p> </li> <li> <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p><p><strong>Patrick Schurle</strong><br /> <em>founder of somewebsite</em></p> </li> <li> <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p><p><strong>Didier</strong><br /> <em>founder of somewebsite</em></p> </li> </ul> 
 <h1>Get Course Manager</h1><h3>Available for iOS and Android</h3>
 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2016/01/big-iphone-4-900x581.png" width="900" alt="" /> 
 <h3 style="text-align: left;">Download Now</h3> <p style="text-align: left;">Course Manager is powerful tool to create and manage online course. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.Ut enim ad minimveniam, Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu.</p> <p><a href="http://themify.me/"><img src="https://themify.me/demo/themes/builder-layouts/files/2016/01/badge_ios_english-en-4.png" alt="badge_ios_english-en" width="169" height="52" /></a>     <a href="http://themify.me/"><img src="https://themify.me/demo/themes/builder-layouts/files/2016/01/english_get-3.png" alt="english_get" width="150" height="52" /></a></p><!--/themify_builder_static-->',
  'post_title' => 'Right Pane',
  'post_excerpt' => '',
  'post_name' => 'right-pane',
  'post_modified' => '2017-12-12 21:40:42',
  'post_modified_gmt' => '2017-12-12 21:40:42',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=4919',
  'menu_order' => 5,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'custom_menu' => 'right-pane',
    'color_design' => 'theme-color-turquoise',
    'header_design' => 'header-rightpane',
    'footer_design' => 'none',
    'more_posts' => 'pagination',
    'posts_per_page' => '2',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>Course Manager<\\\\/h1><h3>Create and manage online courses<\\\\/h3>\\",\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"0t03645\\"},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"buttons_size\\":\\"large\\",\\"buttons_style\\":\\"rounded\\",\\"content_button\\":[{\\"label\\":\\"SIGN UP FOR FREE\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"button_color_bg\\":\\"blue\\",\\"new_window\\":\\"0\\"}],\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"center\\",\\"margin_bottom\\":\\"8\\",\\"margin_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"shal065\\"},{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/dashboard-2-800x436.png\\",\\"width_image\\":\\"800\\"},\\"element_id\\":\\"1us0300\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat-none\\"},\\"element_id\\":\\"z6mr352\\"}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"row_anchor\\":\\"course-manager\\",\\"background_type\\":\\"image\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/office-932926_1920-1024x683.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"cover_color\\":\\"000000_0.87\\"},\\"element_id\\":\\"n3dm304\\"},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: left;\\\\\\\\\\\\\\">What is Course Manager?<\\\\/h2><p style=\\\\\\\\\\\\\\"text-align: left;\\\\\\\\\\\\\\">Course Manager is application for creating online course and monitoring all courses you created in one single dashboard. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\\\/p>\\",\\"font_color\\":\\"000000\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"20\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"15\\",\\"padding_left_unit\\":\\"%\\",\\"animation_effect\\":\\"bounceInLeft\\"},\\"element_id\\":\\"7jsq365\\"},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"buttons_size\\":\\"large\\",\\"buttons_style\\":\\"rounded\\",\\"content_button\\":[{\\"label\\":\\"SIGN UP FOR FREE\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"button_color_bg\\":\\"blue\\",\\"new_window\\":\\"0\\"}],\\"font_color\\":\\"ffffff_1.00\\",\\"margin_bottom\\":\\"8\\",\\"margin_bottom_unit\\":\\"%\\",\\"margin_left\\":\\"15\\",\\"margin_left_unit\\":\\"%\\",\\"animation_effect\\":\\"bounceInLeft\\"},\\"element_id\\":\\"s5l6304\\"}],\\"element_id\\":\\"ec9o565\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/big8-1024x760-1024x760.png\\",\\"width_image\\":\\"1024\\",\\"animation_effect\\":\\"bounceInRight\\"},\\"element_id\\":\\"rhr4737\\"}],\\"styling\\":{\\"background_type\\":\\"image\\"},\\"element_id\\":\\"9iap606\\"}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"row_anchor\\":\\"what\\",\\"background_type\\":\\"image\\",\\"padding_top\\":\\"7\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"7\\",\\"padding_bottom_unit\\":\\"%\\",\\"border_top_color\\":\\"ebebeb_1.00\\",\\"border_top_width\\":\\"1\\"},\\"element_id\\":\\"sc3k060\\"},{\\"row_order\\":\\"2\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/big6-1024x760.png\\",\\"width_image\\":\\"1024\\",\\"auto_fullwidth\\":\\"1\\",\\"animation_effect\\":\\"bounceInUp\\"},\\"element_id\\":\\"vn1m735\\"}],\\"element_id\\":\\"sw7q073\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: left;\\\\\\\\\\\\\\">Course and Exam Monitoring<\\\\/h2><p style=\\\\\\\\\\\\\\"text-align: left;\\\\\\\\\\\\\\">Course Manager is application for creating online course and monitoring all courses you created in one single dashboard. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod.<\\\\/p>\\",\\"font_color\\":\\"000000\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"15\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"20\\",\\"padding_left_unit\\":\\"%\\",\\"animation_effect\\":\\"bounceInDown\\"},\\"element_id\\":\\"wre2675\\"},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"buttons_size\\":\\"large\\",\\"buttons_style\\":\\"rounded\\",\\"content_button\\":[{\\"label\\":\\"SIGN UP FOR FREE\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"button_color_bg\\":\\"blue\\",\\"new_window\\":\\"0\\"}],\\"font_color\\":\\"ffffff_1.00\\",\\"margin_bottom\\":\\"8\\",\\"margin_bottom_unit\\":\\"%\\",\\"margin_left\\":\\"20\\",\\"margin_left_unit\\":\\"%\\",\\"animation_effect\\":\\"bounceInDown\\"},\\"element_id\\":\\"e7n4075\\"}],\\"styling\\":{\\"background_type\\":\\"image\\"},\\"element_id\\":\\"cxgj263\\"}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"row_anchor\\":\\"course-exam\\",\\"background_type\\":\\"image\\",\\"background_color\\":\\"fafafa\\",\\"padding_top\\":\\"7\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"border_top_color\\":\\"ebebeb\\",\\"border_top_width\\":\\"1\\"},\\"element_id\\":\\"aloa363\\"},{\\"row_order\\":\\"3\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: left;\\\\\\\\\\\\\\">Interactive interface<\\\\/h2><p style=\\\\\\\\\\\\\\"text-align: left;\\\\\\\\\\\\\\">Course Manager is application for creating online course and monitoring all courses you created in one single dashboard. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\\\/p>\\",\\"font_color\\":\\"000000\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"15\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"20\\",\\"padding_left_unit\\":\\"%\\",\\"animation_effect\\":\\"bounceInDown\\"},\\"element_id\\":\\"wklp056\\"},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"buttons_size\\":\\"large\\",\\"buttons_style\\":\\"rounded\\",\\"content_button\\":[{\\"label\\":\\"SIGN UP FOR FREE\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"button_color_bg\\":\\"blue\\",\\"new_window\\":\\"0\\"}],\\"font_color\\":\\"ffffff_1.00\\",\\"margin_bottom\\":\\"8\\",\\"margin_bottom_unit\\":\\"%\\",\\"margin_left\\":\\"20\\",\\"margin_left_unit\\":\\"%\\",\\"animation_effect\\":\\"bounceInDown\\"},\\"element_id\\":\\"dq9x038\\"}],\\"element_id\\":\\"u3xd306\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/big9-1024x760.png\\",\\"width_image\\":\\"1024\\",\\"auto_fullwidth\\":\\"1\\",\\"animation_effect\\":\\"fadeInUp\\"},\\"element_id\\":\\"kzpq855\\"}],\\"styling\\":{\\"background_type\\":\\"image\\"},\\"element_id\\":\\"u5qw262\\"}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"row_anchor\\":\\"interactive-interface\\",\\"background_type\\":\\"image\\",\\"padding_top\\":\\"7\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"border_top_color\\":\\"ebebeb_1.00\\",\\"border_top_width\\":\\"1\\"},\\"element_id\\":\\"df9x060\\"},{\\"row_order\\":\\"4\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>Share your online course<\\\\/h1>\\\\n<h3>Join with million users around the world<\\\\/h3>\\\\n\\",\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"center\\",\\"animation_effect\\":\\"fadeInDownBig\\"},\\"element_id\\":\\"1qsy506\\"},{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/report-illegal-and-harmful-content-gt-grey-world-map-free-31918-2-1024x492.png\\",\\"width_image\\":\\"1024\\",\\"animation_effect\\":\\"fadeInUpBig\\"},\\"element_id\\":\\"zyaj038\\"}],\\"element_id\\":\\"6v5z355\\"}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"row_anchor\\":\\"share\\",\\"background_type\\":\\"image\\",\\"background_color\\":\\"252d32\\",\\"padding_top\\":\\"7\\",\\"padding_top_unit\\":\\"%\\"},\\"element_id\\":\\"y9n7634\\"},{\\"row_order\\":\\"5\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>Testimonials<\\\\/h1><h3>What they say about Course Manager<\\\\/h3>\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"animation_effect\\":\\"fadeIn\\"},\\"element_id\\":\\"3k8a305\\"},{\\"mod_name\\":\\"slider\\",\\"mod_settings\\":{\\"layout_display_slider\\":\\"text\\",\\"blog_category_slider\\":\\"|single\\",\\"slider_category_slider\\":\\"|single\\",\\"portfolio_category_slider\\":\\"|single\\",\\"testimonial_category_slider\\":\\"|single\\",\\"order_slider\\":\\"desc\\",\\"orderby_slider\\":\\"date\\",\\"display_slider\\":\\"content\\",\\"text_content_slider\\":[{\\"text_caption_slider\\":\\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<\\\\/p><p><strong>Jane Doe<\\\\/strong><br \\\\/> <em>founder of somewebsite<\\\\/em><\\\\/p>\\"},{\\"text_caption_slider\\":\\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<\\\\/p><p><strong>John Doe<\\\\/strong><br \\\\/> <em>founder of somewebsite<\\\\/em><\\\\/p>\\"},{\\"text_caption_slider\\":\\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<\\\\/p><p><strong>Patrick Schurle<\\\\/strong><br \\\\/> <em>founder of somewebsite<\\\\/em><\\\\/p>\\"},{\\"text_caption_slider\\":\\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<\\\\/p><p><strong>Didier<\\\\/strong><br \\\\/> <em>founder of somewebsite<\\\\/em><\\\\/p>\\"}],\\"layout_slider\\":\\"slider-default\\",\\"visible_opt_slider\\":\\"1\\",\\"auto_scroll_opt_slider\\":\\"4\\",\\"scroll_opt_slider\\":\\"1\\",\\"speed_opt_slider\\":\\"normal\\",\\"effect_slider\\":\\"scroll\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"wrap_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"yes\\",\\"show_arrow_slider\\":\\"yes\\",\\"height_slider\\":\\"variable\\"},\\"element_id\\":\\"wa2t036\\"}],\\"element_id\\":\\"tos0639\\"}],\\"styling\\":{\\"row_anchor\\":\\"testimonial\\",\\"background_type\\":\\"image\\",\\"text_align\\":\\"center\\"},\\"element_id\\":\\"6kqm000\\"},{\\"row_order\\":\\"6\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>Get Course Manager<\\\\/h1><h3>Available for iOS and Android<\\\\/h3>\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"jouj605\\"},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/big-iphone-4-900x581.png\\",\\"width_image\\":\\"900\\",\\"animation_effect\\":\\"bounceInLeft\\"},\\"element_id\\":\\"c6i3006\\"}],\\"element_id\\":\\"tx32004\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3 style=\\\\\\\\\\\\\\"text-align: left;\\\\\\\\\\\\\\">Download Now<\\\\/h3>\\\\n<p style=\\\\\\\\\\\\\\"text-align: left;\\\\\\\\\\\\\\">Course Manager is powerful tool to create and manage online course. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.Ut enim ad minimveniam, Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu.<\\\\/p>\\\\n<p><a href=\\\\\\\\\\\\\\"http:\\\\/\\\\/themify.me\\\\/\\\\\\\\\\\\\\"><img class=\\\\\\\\\\\\\\"alignnone size-full wp-image-4419\\\\\\\\\\\\\\" src=\\\\\\\\\\\\\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/badge_ios_english-en-4.png\\\\\\\\\\\\\\" alt=\\\\\\\\\\\\\\"badge_ios_english-en\\\\\\\\\\\\\\" width=\\\\\\\\\\\\\\"169\\\\\\\\\\\\\\" height=\\\\\\\\\\\\\\"52\\\\\\\\\\\\\\" \\\\/><\\\\/a>     <a href=\\\\\\\\\\\\\\"http:\\\\/\\\\/themify.me\\\\/\\\\\\\\\\\\\\"><img class=\\\\\\\\\\\\\\"alignnone size-full wp-image-4420\\\\\\\\\\\\\\" src=\\\\\\\\\\\\\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/english_get-3.png\\\\\\\\\\\\\\" alt=\\\\\\\\\\\\\\"english_get\\\\\\\\\\\\\\" width=\\\\\\\\\\\\\\"150\\\\\\\\\\\\\\" height=\\\\\\\\\\\\\\"52\\\\\\\\\\\\\\" \\\\/><\\\\/a><\\\\/p>\\\\n\\",\\"padding_top\\":\\"7\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"20\\",\\"padding_right_unit\\":\\"%\\",\\"animation_effect\\":\\"bounceInRight\\"},\\"element_id\\":\\"x394355\\"}],\\"element_id\\":\\"q0db405\\"}],\\"column_alignment\\":\\"col_align_middle\\",\\"element_id\\":\\"jhs6595\\"}],\\"element_id\\":\\"04cn966\\"}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"row_anchor\\":\\"get\\",\\"background_type\\":\\"image\\",\\"background_color\\":\\"fafafa\\",\\"border_top_color\\":\\"ebebeb\\",\\"border_top_width\\":\\"1\\",\\"border_bottom_color\\":\\"ebebeb\\",\\"border_bottom_width\\":\\"1\\"},\\"element_id\\":\\"0bzm663\\"},{\\"row_order\\":\\"7\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"6jmn056\\"}],\\"element_id\\":\\"5erx635\\"}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 5153,
  'post_date' => '2016-06-08 21:18:36',
  'post_date_gmt' => '2016-06-08 21:18:36',
  'post_content' => '<p></p>

<!-- wp:themify-builder/canvas /-->

<p></p><!--themify_builder_static--><h1>Section Scrolling</h1>
<p>A built-in feature in Ultra theme.</p>
<a href="https://themify.me/themes/ultra" > Learn More </a>
<h2 style="text-align: center;">Great For Presentations</h2>
<h2 style="text-align: center;">Sexy Parallax Scrolling</h2>
<h2>Horizontal Scrolling</h2>
<p>Can go horizontal or vertical</p>
<h2>Nice &amp; Easy</h2>
<p>Import a pre-designed layout or design your own.</p>
<h2>Build Anything With Ultra</h2>
<a href="https://themify.me/themes/ultra" > Get Ultra Now </a><!--/themify_builder_static-->',
  'post_title' => 'Section Scrolling',
  'post_excerpt' => '',
  'post_name' => 'section-scrolling',
  'post_modified' => '2019-09-29 22:19:15',
  'post_modified_gmt' => '2019-09-29 22:19:15',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=5153',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'section_full_scrolling' => 'yes',
    'section_scrolling_mobile' => 'on',
    'header_design' => 'header-slide-out',
    'mobile_menu_styles' => 'default',
    'header_wrap' => 'transparent',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"5cea159\\",\\"cols\\":[{\\"element_id\\":\\"0d8fda7\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"a2ea799\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h1>Section Scrolling<\\\\/h1>\\",\\"animation_effect\\":\\"fadeInLeft\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ff45d89\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"font_size\\":\\"1.2\\",\\"font_size_unit\\":\\"em\\",\\"line_height\\":\\"1.5\\",\\"line_height_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<p>A built-in feature in Ultra theme.<\\\\/p>\\",\\"animation_effect\\":\\"fadeInRight\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"09714ca\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"20\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"large\\",\\"buttons_style\\":\\"outline\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Learn More\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/themes\\\\/ultra\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"}],\\"animation_effect\\":\\"fadeInUp\\"}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra\\\\/files\\\\/2018\\\\/06\\\\/demoimage6.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"cover_gradient\\",\\"cover_color\\":\\"#000000_0.29\\",\\"cover_gradient-gradient\\":\\"0% rgba(255, 230, 161, 0.43)|98% rgba(0, 0, 0, 0.55)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"#ffffff\\",\\"text_align\\":\\"center\\",\\"link_color\\":\\"#a6fff2\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\"}},{\\"element_id\\":\\"d26d0b9\\",\\"cols\\":[{\\"element_id\\":\\"867e9f0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"11d1b92\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Great For Presentations<\\\\/h2>\\",\\"animation_effect\\":\\"fadeInUp\\"}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/fullpane\\\\/files\\\\/2018\\\\/06\\\\/demoimage12.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"363338\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff\\",\\"link_color\\":\\"fff785\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_width\\":\\"fullwidth\\"}},{\\"element_id\\":\\"8fda124\\",\\"cols\\":[{\\"element_id\\":\\"e18a255\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"2fc8d8c\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Sexy Parallax Scrolling<\\\\/h2>\\"}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/fullpane\\\\/files\\\\/2018\\\\/06\\\\/demoimage16.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"363338\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff\\",\\"link_color\\":\\"fff785\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_width\\":\\"fullwidth\\",\\"row_scroll_direction\\":\\"module_row_slide\\"}},{\\"element_id\\":\\"88eb1ea\\",\\"cols\\":[{\\"element_id\\":\\"d53e830\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"1848191\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h2>Horizontal Scrolling<\\\\/h2>\\",\\"animation_effect\\":\\"fadeInLeft\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"6074527\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"font_size\\":\\"1.2\\",\\"font_size_unit\\":\\"em\\",\\"line_height\\":\\"1.5\\",\\"line_height_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<p>Can go horizontal or vertical<\\\\/p>\\",\\"animation_effect\\":\\"fadeInRight\\"}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra\\\\/files\\\\/2018\\\\/06\\\\/demoimage66.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"#ffffff\\",\\"text_align\\":\\"center\\",\\"link_color\\":\\"#a6fff2\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_scroll_direction\\":\\"module_row_slide\\",\\"row_anchor\\":\\"horizontal-scroll\\"}},{\\"element_id\\":\\"6dfd22e\\",\\"cols\\":[{\\"element_id\\":\\"639a555\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"5b0c26d\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h2>Nice &amp; Easy<\\\\/h2>\\",\\"animation_effect\\":\\"fadeInLeft\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ccabb9e\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"font_size\\":\\"1.2\\",\\"font_size_unit\\":\\"em\\",\\"line_height\\":\\"1.5\\",\\"line_height_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<p>Import a pre-designed layout or design your own.<\\\\/p>\\",\\"animation_effect\\":\\"fadeInRight\\"}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra\\\\/files\\\\/2018\\\\/06\\\\/demoimage50.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"#ffffff\\",\\"text_align\\":\\"center\\",\\"link_color\\":\\"#a6fff2\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_scroll_direction\\":\\"module_row_slide\\"}},{\\"element_id\\":\\"34a4632\\",\\"cols\\":[{\\"element_id\\":\\"046b6b1\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"943b1b5\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h2>Build Anything With Ultra<\\\\/h2>\\",\\"animation_effect\\":\\"flipInX\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"70c3a44\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"20\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"xlarge\\",\\"buttons_style\\":\\"outline\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Get Ultra Now\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/themes\\\\/ultra\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"}],\\"animation_effect\\":\\"fadeInUpBig\\"}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra\\\\/files\\\\/2018\\\\/06\\\\/demoimage56.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"#ffffff\\",\\"text_align\\":\\"center\\",\\"link_color\\":\\"#a6fff2\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_scroll_direction\\":\\"module_row_section\\"}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 4911,
  'post_date' => '2016-03-14 20:27:21',
  'post_date_gmt' => '2016-03-14 20:27:21',
  'post_content' => '<!--themify_builder_static--><h1 style="text-align: center;">Super Comp</h1><h3 style="text-align: center;">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</h3>
 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2016/01/Mac-Pro-main-600x880.png" width="600" alt="" /> 
 <p style="text-align: center;">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>
 
 
 
 
 <h3> Futuristic </h3> <p style="text-align: right;">Lorem ipsum dolor sit amet, consectetur adipiscing elit sed.</p> 
 
 
 
 
 
 <h3> High quality </h3> <p style="text-align: right;">Lorem ipsum dolor sit amet, consectetur adipiscing elit sed.</p> 
 
 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2016/01/processor-382x565.jpg" width="382" alt="" /> 
 
 
 
 
 <h3> Go green </h3> <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit sed.</p> 
 
 
 
 
 
 <h3> Recycled </h3> <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit sed.</p> 
 
 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2016/01/comingsoon-500x330.jpg" width="500" height="330" alt="" /> 
 <h4><strong><a href="http://themify.me/">High Performance</a></strong></h4><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2016/01/core-500x330.jpg" width="500" height="330" alt="" /> 
 <h4><strong><a href="http://themify.me/">Thermal Core</a></strong></h4><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
 <h4><strong><a href="http://themify.me/">Strong Materials</a></strong></h4><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2016/01/cube-2-500x330.jpg" width="500" height="330" alt="" /> 
 <h4><strong><a href="http://themify.me/">Upgradable</a></strong></h4><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2016/01/upgradable-500x330.jpg" width="500" height="330" alt="" /> 
 <h2 style="text-align: center;">Coming 2016</h2><h3 style="text-align: center;">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</h3>
 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2016/01/memory-500x500.jpg" width="500" height="500" alt="" /> 
 
 
 
 
 <h3> Lifetime guarantee </h3> <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p> 
 
 
 
 
 
 <h3> Free shipping </h3> <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p> 
 
 
 
 
 
 <h3> 1-1 replacement </h3> <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p> 
 
 <h2 style="text-align: center;">Unlike Any We&#8217;ve Ever Built</h2><h3 style="text-align: center;">The Making of Super Comp</h3><p style="text-align: center;"> </p>
 
 <a href="https://www.youtube.com/watch?v=IbWOQWw1wkM" > 
 
 </a> 
 
 
 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2016/01/Mac-Pro-main-1-600x830.jpg" width="600" alt="" /> 
 <h1 style="text-align: center;">Super Comp</h1><h3 style="text-align: center;">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt</h3>
 
 <a href="https://themify.me/" > ORDER NOW </a><!--/themify_builder_static-->',
  'post_title' => 'Slide Out',
  'post_excerpt' => '',
  'post_name' => 'slide-out',
  'post_modified' => '2017-10-31 00:43:53',
  'post_modified_gmt' => '2017-10-31 00:43:53',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=4911',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'body_background_repeat' => 'fullcover',
    'header_design' => 'header-slide-out',
    'background_repeat' => 'fullcover',
    'footer_design' => 'none',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Super Comp<\\\\/h1><h3 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\\\/h3>\\",\\"font_color\\":\\"ffffff_1.00\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\"},\\"element_id\\":\\"ynz3331\\"},{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/Mac-Pro-main-600x880.png\\",\\"width_image\\":\\"600\\"},\\"element_id\\":\\"1lrc793\\"},{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<p style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<\\\\/p>\\",\\"font_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"10\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"10\\",\\"padding_left_unit\\":\\"%\\"},\\"element_id\\":\\"zk4o578\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat-none\\"},\\"element_id\\":\\"9ltl073\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"fullcover\\",\\"background_color\\":\\"000000_1.00\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"border_bottom_color\\":\\"36f5ff\\",\\"border_bottom_width\\":\\"1\\"},\\"element_id\\":\\"j2ep073\\"},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"title_feature\\":\\"Futuristic\\",\\"content_feature\\":\\"<p style=\\\\\\\\\\\\\\"text-align: right;\\\\\\\\\\\\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit sed.<\\\\/p>\\",\\"layout_feature\\":\\"icon-right\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"36f5ff\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-arrows-h\\",\\"icon_color_feature\\":\\"36f5ff\\",\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"right\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"2\\",\\"padding_left_unit\\":\\"%\\",\\"margin_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"lyye902\\"},{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"title_feature\\":\\"High quality\\",\\"content_feature\\":\\"<p style=\\\\\\\\\\\\\\"text-align: right;\\\\\\\\\\\\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit sed.<\\\\/p>\\",\\"layout_feature\\":\\"icon-right\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"36f5ff\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-trophy\\",\\"icon_color_feature\\":\\"36f5ff\\",\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"right\\",\\"padding_top\\":\\"7\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"2\\",\\"padding_left_unit\\":\\"%\\"},\\"element_id\\":\\"pda3703\\"}],\\"element_id\\":\\"28zg029\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/processor-382x565.jpg\\",\\"width_image\\":\\"382\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\"},\\"element_id\\":\\"pqzb944\\"}],\\"element_id\\":\\"ajwp009\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"title_feature\\":\\"Go green\\",\\"content_feature\\":\\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit sed.<\\\\/p>\\",\\"layout_feature\\":\\"icon-left\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"36f5ff\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-leaf\\",\\"icon_color_feature\\":\\"36f5ff\\",\\"font_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"2\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\"},\\"element_id\\":\\"ww9p779\\"},{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"title_feature\\":\\"Recycled\\",\\"content_feature\\":\\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit sed.<\\\\/p>\\",\\"layout_feature\\":\\"icon-left\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"36f5ff\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-recycle\\",\\"icon_color_feature\\":\\"36f5ff\\",\\"font_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"7\\",\\"padding_right\\":\\"2\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top_unit\\":\\"%\\",\\"margin_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"e7xn780\\"}],\\"element_id\\":\\"lsl4260\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_color\\":\\"000000_1.00\\",\\"font_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"9\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"7\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"xscw373\\"},{\\"row_order\\":\\"2\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/comingsoon-500x330.jpg\\",\\"width_image\\":\\"500\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"330\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"h5pc135\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"fullcover\\"},\\"element_id\\":\\"m1h5447\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4><strong><a href=\\\\\\\\\\\\\\"http:\\\\/\\\\/themify.me\\\\/\\\\\\\\\\\\\\">High Performance<\\\\/a><\\\\/strong><\\\\/h4><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.<\\\\/p>\\",\\"font_color\\":\\"ffffff_1.00\\",\\"link_color\\":\\"ffffff_1.00\\",\\"text_decoration\\":\\"none\\",\\"padding_top\\":\\"14\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"15\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"15\\",\\"padding_left_unit\\":\\"%\\"},\\"element_id\\":\\"y319790\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"fullcover\\",\\"background_color\\":\\"000000_1.00\\"},\\"element_id\\":\\"keq1271\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/core-500x330.jpg\\",\\"width_image\\":\\"500\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"330\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"u293070\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"fullcover\\"},\\"element_id\\":\\"pftr793\\"},{\\"column_order\\":\\"3\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4><strong><a href=\\\\\\\\\\\\\\"http:\\\\/\\\\/themify.me\\\\/\\\\\\\\\\\\\\">Thermal Core<\\\\/a><\\\\/strong><\\\\/h4><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.<\\\\/p>\\",\\"font_color\\":\\"ffffff_1.00\\",\\"link_color\\":\\"ffffff_1.00\\",\\"text_decoration\\":\\"none\\",\\"padding_top\\":\\"14\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"15\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"15\\",\\"padding_left_unit\\":\\"%\\"},\\"element_id\\":\\"t5ty922\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"fullcover\\",\\"background_color\\":\\"000000_1.00\\"},\\"element_id\\":\\"6uaa202\\"}],\\"gutter\\":\\"gutter-none\\",\\"element_id\\":\\"sl2y320\\"}],\\"element_id\\":\\"lyf3230\\"}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"background_type\\":\\"image\\",\\"background_color\\":\\"000000_1.00\\",\\"text_align\\":\\"center\\"},\\"element_id\\":\\"rsr8731\\"},{\\"row_order\\":\\"3\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4><strong><a href=\\\\\\\\\\\\\\"http:\\\\/\\\\/themify.me\\\\/\\\\\\\\\\\\\\">Strong Materials<\\\\/a><\\\\/strong><\\\\/h4><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.<\\\\/p>\\",\\"font_color\\":\\"ffffff_1.00\\",\\"link_color\\":\\"ffffff_1.00\\",\\"text_decoration\\":\\"none\\",\\"padding_top\\":\\"14\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"15\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"15\\",\\"padding_left_unit\\":\\"%\\"},\\"element_id\\":\\"bys5292\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"fullcover\\",\\"background_color\\":\\"000000_1.00\\"},\\"element_id\\":\\"tljs823\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/cube-2-500x330.jpg\\",\\"width_image\\":\\"500\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"330\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"ynxl397\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"fullcover\\"},\\"element_id\\":\\"k3o1077\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4><strong><a href=\\\\\\\\\\\\\\"http:\\\\/\\\\/themify.me\\\\/\\\\\\\\\\\\\\">Upgradable<\\\\/a><\\\\/strong><\\\\/h4><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.<\\\\/p>\\",\\"font_color\\":\\"ffffff_1.00\\",\\"link_color\\":\\"ffffff_1.00\\",\\"text_decoration\\":\\"none\\",\\"padding_top\\":\\"14\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"15\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"15\\",\\"padding_left_unit\\":\\"%\\"},\\"element_id\\":\\"u9gw972\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"fullcover\\",\\"background_color\\":\\"000000_1.00\\"},\\"element_id\\":\\"5u79440\\"},{\\"column_order\\":\\"3\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/upgradable-500x330.jpg\\",\\"width_image\\":\\"500\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"330\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"jjv5722\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"fullcover\\"},\\"element_id\\":\\"wrkm296\\"}],\\"gutter\\":\\"gutter-none\\",\\"element_id\\":\\"imzz722\\"}],\\"element_id\\":\\"w411992\\"}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"background_type\\":\\"image\\",\\"background_color\\":\\"000000_1.00\\",\\"text_align\\":\\"center\\"},\\"element_id\\":\\"qgsx222\\"},{\\"row_order\\":\\"4\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Coming 2016<\\\\/h2><h3 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\\\/h3>\\",\\"font_color\\":\\"ffffff_1.00\\"},\\"element_id\\":\\"5lr6343\\"},{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/memory-500x500.jpg\\",\\"width_image\\":\\"500\\",\\"height_image\\":\\"500\\",\\"padding_top\\":\\"9\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"9\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"to2p230\\"},{\\"row_order\\":\\"2\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"title_feature\\":\\"Lifetime guarantee\\",\\"content_feature\\":\\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.<\\\\/p>\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"36f5ff\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-heart\\",\\"icon_color_feature\\":\\"36f5ff\\",\\"font_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\"},\\"element_id\\":\\"cc0s626\\"}],\\"element_id\\":\\"8d6m595\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"title_feature\\":\\"Free shipping\\",\\"content_feature\\":\\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.<\\\\/p>\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"36f5ff\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-truck\\",\\"icon_color_feature\\":\\"36f5ff\\",\\"font_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\"},\\"element_id\\":\\"b1v2932\\"}],\\"element_id\\":\\"71fl797\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"title_feature\\":\\"1-1 replacement\\",\\"content_feature\\":\\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.<\\\\/p>\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"36f5ff\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-shield\\",\\"icon_color_feature\\":\\"36f5ff\\",\\"font_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\"},\\"element_id\\":\\"3j43093\\"}],\\"element_id\\":\\"hi7w003\\"}],\\"element_id\\":\\"xn0e990\\"}],\\"element_id\\":\\"x5ks427\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_color\\":\\"030303_1.00\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"0o6j093\\"},{\\"row_order\\":\\"5\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Unlike Any We\\\\\\\\\\\'ve Ever Built<\\\\/h2><h3 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">The Making of Super Comp<\\\\/h3><p style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\"> <\\\\/p>\\",\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"center\\"},\\"element_id\\":\\"90gt205\\"},{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"ffffff_1.00\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-play\\",\\"icon_color_feature\\":\\"ffffff_1.00\\",\\"link_feature\\":\\"https:\\\\/\\\\/www.youtube.com\\\\/watch?v=IbWOQWw1wkM\\",\\"link_options\\":\\"lightbox\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"xky7020\\"}],\\"element_id\\":\\"6nwh542\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/macpro_00090-2-1024x768-1024x768.jpg\\",\\"background_repeat\\":\\"builder-parallax-scrolling\\",\\"background_color\\":\\"000000\\",\\"cover_color_hover\\":\\"000000_0.77\\",\\"padding_top\\":\\"13\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"13\\",\\"padding_bottom_unit\\":\\"%\\",\\"border_top_color\\":\\"36f5ff\\",\\"border_top_width\\":\\"1\\",\\"border_bottom_color\\":\\"36f5ff\\",\\"border_bottom_width\\":\\"1\\"},\\"element_id\\":\\"zjvf937\\"},{\\"row_order\\":\\"6\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/Mac-Pro-main-1-600x830.jpg\\",\\"width_image\\":\\"600\\"},\\"element_id\\":\\"tf3a299\\"}],\\"element_id\\":\\"8g74170\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Super Comp<\\\\/h1><h3 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt<\\\\/h3>\\",\\"font_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"25\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\"},\\"element_id\\":\\"guqh050\\"},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"circle\\",\\"content_button\\":[{\\"label\\":\\"ORDER NOW\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"new_window\\":\\"0\\"}],\\"font_size\\":\\"18\\",\\"text_align\\":\\"center\\",\\"link_color\\":\\"000000_1.00\\",\\"text_decoration\\":\\"none\\"},\\"element_id\\":\\"qyni760\\"}],\\"element_id\\":\\"4cz4049\\"}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"element_id\\":\\"vf56007\\"}],\\"element_id\\":\\"0nlt530\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_color\\":\\"000000_1.00\\",\\"padding_top\\":\\"7\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"7\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"iwzy593\\"},{\\"row_order\\":\\"7\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"31c8372\\"}],\\"element_id\\":\\"zw12660\\"}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3985,
  'post_date' => '2015-05-08 23:08:38',
  'post_date_gmt' => '2015-05-08 23:08:38',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h2 style="text-align: center;">Our <br />Vision</h2> 
 <h3>We value...</h3><p>Pellentesque in purus posuere, luctus felis vel, sodales massa. Phasellus vehicula molestie pharetra. Donec aliquam nulla et erat blandit molestie. Maecenas porta mauris convallis ante dictum, ac imperdiet neque posuere. Phasellus accumsan est non nisi ultrices, et consequat lacus sollicitudin. Proin metus mi, sollicitudin eget odio et, aliquam convallis justo. Nullam porta augue nec fermentum tempor.</p><p>Donec risus leo, blandit eu commodo et, scelerisque quis eros. In posuere efficitur dui, in pellentesque massa aliquet vel. Phasellus et suscipit neque. Proin eget felis eu est laoreet ultricies mattis eget elit.</p><p>Vivamus feugiat tortor in ornare egestas. Phasellus malesuada arcu tempor neque pellentesque commodo. Proin molestie quam turpis, non congue ex interdum ac. </p> 
 <h2 style="text-align: center;">Our Team</h2> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/82152160.jpg" width="180" height="180" title="Michelle" alt="VP of Marketing" /> <h3> Michelle </h3> <em>VP of Marketing</em> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/141627649.jpg" width="180" height="180" title="Ralph" alt="CEO" /> <h3> Ralph </h3> <em>CEO</em> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/180680633.jpg" width="180" height="180" title="Bryan" alt="CFO" /> <h3> Bryan </h3> <em>CFO</em> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/user_miles-200x200.jpg" width="180" height="180" title="Mike" alt="Front-End Developer" /> <h3> Mike </h3> <em>Front-End Developer</em> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/112268515.jpg" width="180" height="180" title="Claire" alt="Photographer" /> <h3> Claire </h3> <em>Photographer</em> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/demo_paria.jpg" width="180" height="180" title="Annie" alt="Designer" /> <h3> Annie </h3> <em>Designer</em> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/demo_peter.jpg" width="180" height="180" title="Nick" alt="Development Specialist" /> <h3> Nick </h3> <em>Development Specialist</em> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/user_jolie.jpg" width="180" height="180" title="Lauren" alt="Social Media Specialist" /> <h3> Lauren </h3> <em>Social Media Specialist</em> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/86536909.jpg" width="180" height="180" title="Stephen" alt="Operations Manager" /> <h3> Stephen </h3> <em>Operations Manager</em> 
 <h2 style="text-align: center;">Our<br />Work</h2> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/96796114.jpg" width="1000" height="600" alt="Slider" /> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/196849997.jpg" width="1000" height="600" alt="Slider" /> 
 <h1>#01</h1><h4>Forward thinking</h4><p>Proin ut euismod erat. Praesent velit est, interdum ut nulla ac, ultrices maximus odio. Pellentesque nec arcu at eros euismod consectetur.</p> 
 <h1 style="text-align: right;">#02</h1><h4 style="text-align: right;">Best Services</h4><p style="text-align: right;">Proin ut euismod erat. Praesent velit est, intercom ut nulla ac, ultrices maximus odio. Pellentesque nec arcu at eros euismod consectetur.</p> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/134119568.jpg" width="1000" height="600" alt="Slider" /> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/90053719.jpg" width="1000" height="600" alt="Slider" /> 
 <h1>#03</h1><h4>Our works speak for us</h4><p>Proin ut euismod erat. Praesent velit est, interdum ut nulla ac, ultrices maximus odio. Pellentesque nec arcu at eros euismod consectetur.</p> 
 <h1 style="text-align: right;">#04</h1><h4 style="text-align: right;">Where our inspiration comes from</h4><p style="text-align: right;">Proin ut euismod erat. Praesent velit est, interdum ut nulla ac, ultrices maximus odio. Pellentesque nec arcu at eros euismod consectetur.</p> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/175819034.jpg" width="1000" height="600" alt="Slider" /> 
 <h2 style="text-align: center;">Our Clients</h2> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/Windows_logo-7.png" width="180" height="180" alt="Slider" /> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/Apple-Logo-splash.png" width="180" height="180" alt="Slider" /> 
 <img src="https://themify.me/demo/themes/landing/files/2015/02/543c477e9547e.jpg.jpg" width="180" height="180" alt="Slider" /> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/showposter.png" width="180" height="180" alt="Slider" /> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/Logitech-logo.jpg" width="180" height="180" alt="Slider" /> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/Facebook-logo-PSD.jpg" width="180" alt="Slider" /> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/Screen-Shot-2015-02-04-at-3.51.03-PM.png" width="180" alt="Slider" /> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/google-logo-e1423084165592.png" width="180" alt="Slider" /> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2015/07/asus_logo.jpg" width="180" alt="Slider" /> 
 <h2 style="text-align: center;">Cool <br />Awards</h2> 
 
 
 
 <p>1st FAR Champion</p> 
 
 
 
 
 <p>Facebook\'s Best</p> 
 
 
 
 
 <p>Medal of Honors</p> 
 
 
 
 
 <p>Ride for Cancer </p> 
 
 
 
 
 <p>Github Champs</p> 
 
 
 
 
 <p>Research Nominee</p> 
 
 
 
 
 <p>BitCoin Design Award</p> 
 
 
 
 
 <p>Linux Epic Code Award</p> 
 
 
 
 
 <p>WordPress Theme of the Year</p> 
 
 <h1 style="text-align: right;">Our HQ</h1><h4 style="text-align: right;">Maps Module here</h4><p style="text-align: right;">The Maps module allows you to insert your location with google map. </p><p style="text-align: right;"> </p> 
<h3></h3><iframe frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="https://maps.google.com/maps?q=381+Yonge+St%2C+Toronto%2C+ON+M5B+1S1%2C+Canada&amp;t=m&amp;z=8&amp;output=embed&amp;iwloc=near"></iframe><!--/themify_builder_static-->',
  'post_title' => 'Slider',
  'post_excerpt' => '',
  'post_name' => 'slider',
  'post_modified' => '2019-03-08 18:51:44',
  'post_modified_gmt' => '2019-03-08 18:51:44',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=3985',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'header_design' => 'header-block',
    'fixed_header' => 'yes',
    'full_height_header' => 'yes',
    'mobile_menu_styles' => 'default',
    'header_wrap' => 'slider',
    'background_gallery' => '[gallery ids="7462,7464,7465"]',
    'background_color' => '#000000',
    'background_image' => 'https://themify.me/demo/themes/ultra/files/2015/04/Top_view.jpg',
    'headerwrap_text_color' => '#ffffff',
    'headerwrap_link_color' => '#ffffff',
    'footer_design' => 'footer-horizontal-left',
    'more_posts' => 'pagination',
    'posts_per_page' => '2',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-1 first\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Our <br \\\\/>Vision<\\\\/h2>\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left\\":\\"8\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"picj007\\"}],\\"styling\\":[],\\"element_id\\":\\"cpo1205\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-3 last\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>We value...<\\\\/h3><p>Pellentesque in purus posuere, luctus felis vel, sodales massa. Phasellus vehicula molestie pharetra. Donec aliquam nulla et erat blandit molestie. Maecenas porta mauris convallis ante dictum, ac imperdiet neque posuere. Phasellus accumsan est non nisi ultrices, et consequat lacus sollicitudin. Proin metus mi, sollicitudin eget odio et, aliquam convallis justo. Nullam porta augue nec fermentum tempor.<\\\\/p><p>Donec risus leo, blandit eu commodo et, scelerisque quis eros. In posuere efficitur dui, in pellentesque massa aliquet vel. Phasellus et suscipit neque. Proin eget felis eu est laoreet ultricies mattis eget elit.<\\\\/p><p>Vivamus feugiat tortor in ornare egestas. Phasellus malesuada arcu tempor neque pellentesque commodo. Proin molestie quam turpis, non congue ex interdum ac. <\\\\/p>\\",\\"font_family\\":\\"default\\",\\"font_size\\":\\"1.3\\",\\"font_size_unit\\":\\"em\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"%\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"gbgy000\\"}],\\"styling\\":[],\\"element_id\\":\\"79ce210\\"}],\\"column_alignment\\":\\"\\",\\"styling\\":{\\"row_width\\":\\"\\",\\"row_height\\":\\"\\",\\"animation_effect\\":\\"\\",\\"background_type\\":\\"image\\",\\"background_slider\\":\\"\\",\\"background_slider_mode\\":\\"\\",\\"background_video\\":\\"\\",\\"background_image\\":\\"\\",\\"background_repeat\\":\\"\\",\\"background_color\\":\\"\\",\\"cover_color\\":\\"\\",\\"cover_color_hover\\":\\"\\",\\"font_family\\":\\"default\\",\\"font_color\\":\\"\\",\\"font_size\\":\\"\\",\\"font_size_unit\\":\\"\\",\\"line_height\\":\\"\\",\\"line_height_unit\\":\\"\\",\\"text_align\\":\\"\\",\\"link_color\\":\\"\\",\\"text_decoration\\":\\"\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top\\":\\"\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right\\":\\"\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom\\":\\"\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left\\":\\"\\",\\"margin_left_unit\\":\\"px\\",\\"border_top_color\\":\\"\\",\\"border_top_width\\":\\"\\",\\"border_top_style\\":\\"\\",\\"border_right_color\\":\\"\\",\\"border_right_width\\":\\"\\",\\"border_right_style\\":\\"\\",\\"border_bottom_color\\":\\"\\",\\"border_bottom_width\\":\\"\\",\\"border_bottom_style\\":\\"\\",\\"border_left_color\\":\\"\\",\\"border_left_width\\":\\"\\",\\"border_left_style\\":\\"\\",\\"custom_css_row\\":\\"\\",\\"row_anchor\\":\\"\\"},\\"element_id\\":\\"jc79007\\"},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-1 first\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Our Team<\\\\/h2>\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left\\":\\"8\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"r1yc525\\"}],\\"styling\\":[],\\"element_id\\":\\"pprg501\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-3 last\\",\\"modules\\":[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1 first\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/82152160.jpg\\",\\"appearance_image\\":\\"circle\\",\\"width_image\\":\\"180\\",\\"height_image\\":\\"180\\",\\"title_image\\":\\"Michelle\\",\\"param_image\\":\\"|\\",\\"caption_image\\":\\"<em>VP of Marketing<\\\\/em>\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"z2pl210\\"}],\\"styling\\":[],\\"element_id\\":\\"7g73199\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/141627649.jpg\\",\\"appearance_image\\":\\"circle\\",\\"width_image\\":\\"180\\",\\"height_image\\":\\"180\\",\\"title_image\\":\\"Ralph\\",\\"param_image\\":\\"|\\",\\"caption_image\\":\\"<em>CEO<\\\\/em>\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"9kcs213\\"}],\\"styling\\":[],\\"element_id\\":\\"5vfr002\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1 last\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/180680633.jpg\\",\\"appearance_image\\":\\"circle\\",\\"width_image\\":\\"180\\",\\"height_image\\":\\"180\\",\\"title_image\\":\\"Bryan\\",\\"param_image\\":\\"|\\",\\"caption_image\\":\\"<em>CFO<\\\\/em>\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"91pa100\\"}],\\"styling\\":[],\\"element_id\\":\\"qapf052\\"}],\\"column_alignment\\":\\"\\",\\"styling\\":[],\\"element_id\\":\\"96u5180\\"},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1 first\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/user_miles-200x200.jpg\\",\\"appearance_image\\":\\"circle\\",\\"width_image\\":\\"180\\",\\"height_image\\":\\"180\\",\\"title_image\\":\\"Mike\\",\\"param_image\\":\\"|\\",\\"caption_image\\":\\"<em>Front-End Developer<\\\\/em>\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"7smq100\\"}],\\"styling\\":[],\\"element_id\\":\\"n7et600\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/112268515.jpg\\",\\"appearance_image\\":\\"circle\\",\\"width_image\\":\\"180\\",\\"height_image\\":\\"180\\",\\"title_image\\":\\"Claire\\",\\"param_image\\":\\"|\\",\\"caption_image\\":\\"<em>Photographer<\\\\/em>\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"dxn2000\\"}],\\"styling\\":[],\\"element_id\\":\\"qe7d101\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1 last\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/demo_paria.jpg\\",\\"appearance_image\\":\\"circle\\",\\"width_image\\":\\"180\\",\\"height_image\\":\\"180\\",\\"title_image\\":\\"Annie\\",\\"param_image\\":\\"|\\",\\"caption_image\\":\\"<em>Designer<\\\\/em>\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"3exh172\\"}],\\"styling\\":[],\\"element_id\\":\\"u2zp711\\"}],\\"column_alignment\\":\\"\\",\\"styling\\":[],\\"element_id\\":\\"io25000\\"},{\\"row_order\\":\\"2\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1 first\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/demo_peter.jpg\\",\\"appearance_image\\":\\"circle\\",\\"width_image\\":\\"180\\",\\"height_image\\":\\"180\\",\\"title_image\\":\\"Nick\\",\\"param_image\\":\\"|\\",\\"caption_image\\":\\"<em>Development Specialist<\\\\/em>\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"jrxr221\\"}],\\"styling\\":[],\\"element_id\\":\\"m8oe100\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/user_jolie.jpg\\",\\"appearance_image\\":\\"circle\\",\\"width_image\\":\\"180\\",\\"height_image\\":\\"180\\",\\"title_image\\":\\"Lauren\\",\\"param_image\\":\\"|\\",\\"caption_image\\":\\"<em>Social Media Specialist<\\\\/em>\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"gmk7212\\"}],\\"styling\\":[],\\"element_id\\":\\"bout008\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1 last\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/86536909.jpg\\",\\"appearance_image\\":\\"circle\\",\\"width_image\\":\\"180\\",\\"height_image\\":\\"180\\",\\"title_image\\":\\"Stephen\\",\\"param_image\\":\\"|\\",\\"caption_image\\":\\"<em>Operations Manager<\\\\/em>\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"8tdn323\\"}],\\"styling\\":[],\\"element_id\\":\\"d77q221\\"}],\\"column_alignment\\":\\"\\",\\"styling\\":[],\\"element_id\\":\\"jdxe006\\"}],\\"styling\\":[],\\"element_id\\":\\"pv3a116\\"}],\\"column_alignment\\":\\"\\",\\"styling\\":{\\"row_width\\":\\"\\",\\"row_height\\":\\"\\",\\"animation_effect\\":\\"\\",\\"background_type\\":\\"image\\",\\"background_slider\\":\\"\\",\\"background_slider_mode\\":\\"\\",\\"background_video\\":\\"\\",\\"background_image\\":\\"\\",\\"background_repeat\\":\\"\\",\\"background_color\\":\\"\\",\\"cover_color\\":\\"\\",\\"cover_color_hover\\":\\"\\",\\"font_family\\":\\"default\\",\\"font_color\\":\\"\\",\\"font_size\\":\\"\\",\\"font_size_unit\\":\\"\\",\\"line_height\\":\\"\\",\\"line_height_unit\\":\\"\\",\\"text_align\\":\\"\\",\\"link_color\\":\\"\\",\\"text_decoration\\":\\"\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top\\":\\"\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right\\":\\"\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom\\":\\"\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left\\":\\"\\",\\"margin_left_unit\\":\\"px\\",\\"border_top_color\\":\\"\\",\\"border_top_width\\":\\"\\",\\"border_top_style\\":\\"\\",\\"border_right_color\\":\\"\\",\\"border_right_width\\":\\"\\",\\"border_right_style\\":\\"\\",\\"border_bottom_color\\":\\"\\",\\"border_bottom_width\\":\\"\\",\\"border_bottom_style\\":\\"\\",\\"border_left_color\\":\\"\\",\\"border_left_width\\":\\"\\",\\"border_left_style\\":\\"\\",\\"custom_css_row\\":\\"\\",\\"row_anchor\\":\\"\\"},\\"element_id\\":\\"b7rm100\\"},{\\"row_order\\":\\"2\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first\\",\\"modules\\":[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-1 first\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Our<br \\\\/>Work<\\\\/h2>\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"scug000\\"}],\\"styling\\":[],\\"element_id\\":\\"l9uo028\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-3 last\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/96796114.jpg\\",\\"appearance_image\\":\\"|\\",\\"width_image\\":\\"1000\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"600\\",\\"param_image\\":\\"|\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_title\\":\\"default\\",\\"font_family_caption\\":\\"default\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"rhzi990\\"}],\\"styling\\":[],\\"element_id\\":\\"zqpd111\\"}],\\"column_alignment\\":\\"\\",\\"styling\\":[],\\"element_id\\":\\"hpr7001\\"},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-2 first\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/196849997.jpg\\",\\"appearance_image\\":\\"|\\",\\"width_image\\":\\"1000\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"600\\",\\"param_image\\":\\"|\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_title\\":\\"default\\",\\"font_family_caption\\":\\"default\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"5ghm161\\"}],\\"styling\\":[],\\"element_id\\":\\"pj5s002\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1 last\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>#01<\\\\/h1><h4>Forward thinking<\\\\/h4><p>Proin ut euismod erat. Praesent velit est, interdum ut nulla ac, ultrices maximus odio. Pellentesque nec arcu at eros euismod consectetur.<\\\\/p>\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"12\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"d74h910\\"}],\\"styling\\":[],\\"element_id\\":\\"2tjj119\\"}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":[],\\"element_id\\":\\"uyjj012\\"},{\\"row_order\\":\\"2\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1 first\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1 style=\\\\\\\\\\\\\\"text-align: right;\\\\\\\\\\\\\\">#02<\\\\/h1><h4 style=\\\\\\\\\\\\\\"text-align: right;\\\\\\\\\\\\\\">Best Services<\\\\/h4><p style=\\\\\\\\\\\\\\"text-align: right;\\\\\\\\\\\\\\">Proin ut euismod erat. Praesent velit est, intercom ut nulla ac, ultrices maximus odio. Pellentesque nec arcu at eros euismod consectetur.<\\\\/p>\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"12\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"dwt5202\\"}],\\"styling\\":[],\\"element_id\\":\\"26s6101\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-2 last\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/134119568.jpg\\",\\"appearance_image\\":\\"|\\",\\"width_image\\":\\"1000\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"600\\",\\"param_image\\":\\"|\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_title\\":\\"default\\",\\"font_family_caption\\":\\"default\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"quzj210\\"}],\\"styling\\":[],\\"element_id\\":\\"22ym313\\"}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":[],\\"element_id\\":\\"yzul121\\"},{\\"row_order\\":\\"3\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-2 first\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/90053719.jpg\\",\\"appearance_image\\":\\"|\\",\\"width_image\\":\\"1000\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"600\\",\\"param_image\\":\\"|\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_title\\":\\"default\\",\\"font_family_caption\\":\\"default\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"74fz100\\"}],\\"styling\\":[],\\"element_id\\":\\"j02y011\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1 last\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>#03<\\\\/h1><h4>Our works speak for us<\\\\/h4><p>Proin ut euismod erat. Praesent velit est, interdum ut nulla ac, ultrices maximus odio. Pellentesque nec arcu at eros euismod consectetur.<\\\\/p>\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"12\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"ri6q102\\"}],\\"styling\\":[],\\"element_id\\":\\"tao7129\\"}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":[],\\"element_id\\":\\"ihnn102\\"},{\\"row_order\\":\\"4\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1 first\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1 style=\\\\\\\\\\\\\\"text-align: right;\\\\\\\\\\\\\\">#04<\\\\/h1><h4 style=\\\\\\\\\\\\\\"text-align: right;\\\\\\\\\\\\\\">Where our inspiration comes from<\\\\/h4><p style=\\\\\\\\\\\\\\"text-align: right;\\\\\\\\\\\\\\">Proin ut euismod erat. Praesent velit est, interdum ut nulla ac, ultrices maximus odio. Pellentesque nec arcu at eros euismod consectetur.<\\\\/p>\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"10\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"yq6m110\\"}],\\"styling\\":[],\\"element_id\\":\\"ypzt211\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-2 last\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/175819034.jpg\\",\\"appearance_image\\":\\"|\\",\\"width_image\\":\\"1000\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"600\\",\\"param_image\\":\\"|\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_title\\":\\"default\\",\\"font_family_caption\\":\\"default\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"a9fd116\\"}],\\"styling\\":[],\\"element_id\\":\\"o90y115\\"}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":[],\\"element_id\\":\\"joo2011\\"}],\\"styling\\":[],\\"element_id\\":\\"oi1e668\\"}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"hilf102\\"},{\\"row_order\\":\\"3\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-1 first\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Our Clients<\\\\/h2>\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"9umk002\\"}],\\"styling\\":[],\\"element_id\\":\\"ag6m001\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-3 last\\",\\"modules\\":[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1 first\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/Windows_logo-7.png\\",\\"appearance_image\\":\\"|\\",\\"width_image\\":\\"180\\",\\"height_image\\":\\"180\\",\\"param_image\\":\\"|\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"a380001\\"}],\\"styling\\":[],\\"element_id\\":\\"v9aw100\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/Apple-Logo-splash.png\\",\\"appearance_image\\":\\"|\\",\\"width_image\\":\\"180\\",\\"height_image\\":\\"180\\",\\"param_image\\":\\"|\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"6sks022\\"}],\\"styling\\":[],\\"element_id\\":\\"6sj1610\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1 last\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/02\\\\/543c477e9547e.jpg.jpg\\",\\"appearance_image\\":\\"|\\",\\"width_image\\":\\"180\\",\\"height_image\\":\\"180\\",\\"param_image\\":\\"|\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"fj7o012\\"}],\\"styling\\":[],\\"element_id\\":\\"cjel119\\"}],\\"column_alignment\\":\\"\\",\\"styling\\":[],\\"element_id\\":\\"5hoc121\\"},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1 first\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/showposter.png\\",\\"appearance_image\\":\\"rounded\\",\\"width_image\\":\\"180\\",\\"height_image\\":\\"180\\",\\"param_image\\":\\"|\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"wynq344\\"}],\\"styling\\":[],\\"element_id\\":\\"0vx3011\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/Logitech-logo.jpg\\",\\"appearance_image\\":\\"|\\",\\"width_image\\":\\"180\\",\\"height_image\\":\\"180\\",\\"param_image\\":\\"|\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"3pi9002\\"}],\\"styling\\":[],\\"element_id\\":\\"mjoa503\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1 last\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/Facebook-logo-PSD.jpg\\",\\"appearance_image\\":\\"|\\",\\"width_image\\":\\"180\\",\\"param_image\\":\\"|\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"h3l7131\\"}],\\"styling\\":[],\\"element_id\\":\\"ukr7220\\"}],\\"column_alignment\\":\\"\\",\\"styling\\":[],\\"element_id\\":\\"po1u031\\"},{\\"row_order\\":\\"2\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1 first\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/Screen-Shot-2015-02-04-at-3.51.03-PM.png\\",\\"appearance_image\\":\\"|\\",\\"width_image\\":\\"180\\",\\"param_image\\":\\"|\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"eij7110\\"}],\\"styling\\":[],\\"element_id\\":\\"myc3104\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/google-logo-e1423084165592.png\\",\\"appearance_image\\":\\"|\\",\\"width_image\\":\\"180\\",\\"param_image\\":\\"|\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"r6iu442\\"}],\\"styling\\":[],\\"element_id\\":\\"m1f5144\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1 last\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2015\\\\/07\\\\/asus_logo.jpg\\",\\"appearance_image\\":\\"|\\",\\"width_image\\":\\"180\\",\\"param_image\\":\\"|\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"pi86160\\"}],\\"styling\\":[],\\"element_id\\":\\"7pg6101\\"}],\\"column_alignment\\":\\"\\",\\"styling\\":[],\\"element_id\\":\\"5cdj311\\"}],\\"styling\\":[],\\"element_id\\":\\"935m121\\"}],\\"column_alignment\\":\\"\\",\\"styling\\":{\\"row_width\\":\\"\\",\\"row_height\\":\\"\\",\\"animation_effect\\":\\"\\",\\"background_type\\":\\"image\\",\\"background_slider\\":\\"\\",\\"background_slider_mode\\":\\"\\",\\"background_video\\":\\"\\",\\"background_image\\":\\"\\",\\"background_repeat\\":\\"\\",\\"background_color\\":\\"\\",\\"cover_color\\":\\"\\",\\"cover_color_hover\\":\\"\\",\\"font_family\\":\\"default\\",\\"font_color\\":\\"\\",\\"font_size\\":\\"\\",\\"font_size_unit\\":\\"\\",\\"line_height\\":\\"\\",\\"line_height_unit\\":\\"\\",\\"text_align\\":\\"\\",\\"link_color\\":\\"\\",\\"text_decoration\\":\\"\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top\\":\\"\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right\\":\\"\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom\\":\\"\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left\\":\\"\\",\\"margin_left_unit\\":\\"px\\",\\"border_top_color\\":\\"\\",\\"border_top_width\\":\\"\\",\\"border_top_style\\":\\"\\",\\"border_right_color\\":\\"\\",\\"border_right_width\\":\\"\\",\\"border_right_style\\":\\"\\",\\"border_bottom_color\\":\\"\\",\\"border_bottom_width\\":\\"\\",\\"border_bottom_style\\":\\"\\",\\"border_left_color\\":\\"\\",\\"border_left_width\\":\\"\\",\\"border_left_style\\":\\"\\",\\"custom_css_row\\":\\"\\",\\"row_anchor\\":\\"\\"},\\"element_id\\":\\"hs48117\\"},{\\"row_order\\":\\"4\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-1 first\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Cool <br \\\\/>Awards<\\\\/h2>\\",\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"em\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"3nhj501\\"}],\\"styling\\":[],\\"element_id\\":\\"jjpf121\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-3 last\\",\\"modules\\":[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1 first\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"content_feature\\":\\"<p>1st FAR Champion<\\\\/p>\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"919191\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-trophy\\",\\"icon_color_feature\\":\\"919191\\",\\"param_feature\\":\\"|\\",\\"font_family\\":\\"default\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"zl4o101\\"}],\\"styling\\":[],\\"element_id\\":\\"xs87152\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"content_feature\\":\\"<p>Facebook\\\\\\\\\\\'s Best<\\\\/p>\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"919191\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-thumbs-up\\",\\"icon_color_feature\\":\\"919191\\",\\"param_feature\\":\\"|\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"4qvb616\\"}],\\"styling\\":[],\\"element_id\\":\\"fcn5160\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1 last\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"content_feature\\":\\"<p>Medal of Honors<\\\\/p>\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"919191\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-sun-o\\",\\"icon_color_feature\\":\\"919191\\",\\"param_feature\\":\\"|\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"umqm120\\"}],\\"styling\\":[],\\"element_id\\":\\"ig0d616\\"}],\\"column_alignment\\":\\"\\",\\"styling\\":[],\\"element_id\\":\\"s1w6110\\"},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1 first\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"content_feature\\":\\"<p>Ride for Cancer <\\\\/p>\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"919191\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-bicycle\\",\\"icon_color_feature\\":\\"919191\\",\\"param_feature\\":\\"|\\",\\"font_family\\":\\"default\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"ouyr868\\"}],\\"styling\\":[],\\"element_id\\":\\"b4mb110\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"content_feature\\":\\"<p>Github Champs<\\\\/p>\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"919191\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-github\\",\\"icon_color_feature\\":\\"919191\\",\\"param_feature\\":\\"|\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"r1q2070\\"}],\\"styling\\":[],\\"element_id\\":\\"8or4199\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1 last\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"content_feature\\":\\"<p>Research Nominee<\\\\/p>\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"919191\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-html5\\",\\"icon_color_feature\\":\\"919191\\",\\"param_feature\\":\\"|\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"t610771\\"}],\\"styling\\":[],\\"element_id\\":\\"kngl111\\"}],\\"column_alignment\\":\\"\\",\\"styling\\":[],\\"element_id\\":\\"bjki112\\"},{\\"row_order\\":\\"2\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1 first\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"content_feature\\":\\"<p>BitCoin Design Award<\\\\/p>\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"919191\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-btc\\",\\"icon_color_feature\\":\\"919191\\",\\"param_feature\\":\\"|\\",\\"font_family\\":\\"default\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"zo3d106\\"}],\\"styling\\":[],\\"element_id\\":\\"grrn070\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"content_feature\\":\\"<p>Linux Epic Code Award<\\\\/p>\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"919191\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-linux\\",\\"icon_color_feature\\":\\"919191\\",\\"param_feature\\":\\"|\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"e8d7111\\"}],\\"styling\\":[],\\"element_id\\":\\"gh86017\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1 last\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"content_feature\\":\\"<p>WordPress Theme of the Year<\\\\/p>\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"919191\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-wordpress\\",\\"icon_color_feature\\":\\"919191\\",\\"param_feature\\":\\"|\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\"},\\"element_id\\":\\"82ee011\\"}],\\"styling\\":[],\\"element_id\\":\\"zir7000\\"}],\\"column_alignment\\":\\"\\",\\"styling\\":[],\\"element_id\\":\\"yuto144\\"}],\\"styling\\":[],\\"element_id\\":\\"635z110\\"}],\\"column_alignment\\":\\"\\",\\"styling\\":{\\"row_width\\":\\"\\",\\"row_height\\":\\"\\",\\"animation_effect\\":\\"\\",\\"background_type\\":\\"image\\",\\"background_slider\\":\\"\\",\\"background_slider_mode\\":\\"\\",\\"background_video\\":\\"\\",\\"background_image\\":\\"\\",\\"background_repeat\\":\\"\\",\\"background_color\\":\\"\\",\\"cover_color\\":\\"\\",\\"cover_color_hover\\":\\"\\",\\"font_family\\":\\"default\\",\\"font_color\\":\\"\\",\\"font_size\\":\\"\\",\\"font_size_unit\\":\\"\\",\\"line_height\\":\\"\\",\\"line_height_unit\\":\\"\\",\\"text_align\\":\\"\\",\\"link_color\\":\\"\\",\\"text_decoration\\":\\"\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top\\":\\"\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right\\":\\"\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom\\":\\"\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left\\":\\"\\",\\"margin_left_unit\\":\\"px\\",\\"border_top_color\\":\\"\\",\\"border_top_width\\":\\"\\",\\"border_top_style\\":\\"\\",\\"border_right_color\\":\\"\\",\\"border_right_width\\":\\"\\",\\"border_right_style\\":\\"\\",\\"border_bottom_color\\":\\"\\",\\"border_bottom_width\\":\\"\\",\\"border_bottom_style\\":\\"\\",\\"border_left_color\\":\\"\\",\\"border_left_width\\":\\"\\",\\"border_left_style\\":\\"\\",\\"custom_css_row\\":\\"\\",\\"row_anchor\\":\\"\\"},\\"element_id\\":\\"epex110\\"},{\\"row_order\\":\\"5\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first\\",\\"modules\\":[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1 first\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1 style=\\\\\\\\\\\\\\"text-align: right;\\\\\\\\\\\\\\">Our HQ<\\\\/h1><h4 style=\\\\\\\\\\\\\\"text-align: right;\\\\\\\\\\\\\\">Maps Module here<\\\\/h4><p style=\\\\\\\\\\\\\\"text-align: right;\\\\\\\\\\\\\\">The Maps module allows you to insert your location with google map. <\\\\/p><p style=\\\\\\\\\\\\\\"text-align: right;\\\\\\\\\\\\\\"> <\\\\/p>\\",\\"font_family\\":\\"default\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"10\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"|\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_h1\\":\\"default\\",\\"font_family_h2\\":\\"default\\",\\"font_family_h3\\":\\"default\\",\\"font_family_h4\\":\\"default\\",\\"font_family_h5\\":\\"default\\",\\"font_family_h6\\":\\"default\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"qb0r271\\"}],\\"styling\\":[],\\"element_id\\":\\"h3ph026\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-2 last\\",\\"modules\\":[{\\"mod_name\\":\\"map\\",\\"mod_settings\\":{\\"map_display_type\\":\\"dynamic\\",\\"address_map\\":\\" 381 Yonge St, Toronto, ON M5B 1S1, Canada \\",\\"zoom_map\\":\\"8\\",\\"w_map\\":\\"100\\",\\"unit_w\\":\\"%\\",\\"w_map_static\\":\\"500\\",\\"h_map\\":\\"500\\",\\"unit_h\\":\\"px\\",\\"b_style_map\\":\\"solid\\",\\"type_map\\":\\"ROADMAP\\",\\"scrollwheel_map\\":\\"disable\\",\\"draggable_map\\":\\"enable\\",\\"draggable_disable_mobile_map\\":\\"yes\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"1ubn909\\"}],\\"styling\\":[],\\"element_id\\":\\"lrrg091\\"}],\\"column_alignment\\":\\"\\",\\"styling\\":[],\\"element_id\\":\\"i160888\\"}],\\"styling\\":[],\\"element_id\\":\\"94v7331\\"}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"row_height\\":\\"\\",\\"animation_effect\\":\\"\\",\\"background_type\\":\\"image\\",\\"background_slider\\":\\"\\",\\"background_slider_mode\\":\\"\\",\\"background_video\\":\\"\\",\\"background_image\\":\\"\\",\\"background_repeat\\":\\"\\",\\"background_color\\":\\"\\",\\"cover_color\\":\\"\\",\\"cover_color_hover\\":\\"\\",\\"font_family\\":\\"default\\",\\"font_color\\":\\"\\",\\"font_size\\":\\"\\",\\"font_size_unit\\":\\"\\",\\"line_height\\":\\"\\",\\"line_height_unit\\":\\"\\",\\"text_align\\":\\"\\",\\"link_color\\":\\"\\",\\"text_decoration\\":\\"\\",\\"padding_top\\":\\"\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right\\":\\"\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top\\":\\"\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right\\":\\"\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom\\":\\"\\",\\"margin_bottom_unit\\":\\"%\\",\\"margin_left\\":\\"\\",\\"margin_left_unit\\":\\"px\\",\\"border_top_color\\":\\"\\",\\"border_top_width\\":\\"\\",\\"border_top_style\\":\\"\\",\\"border_right_color\\":\\"\\",\\"border_right_width\\":\\"\\",\\"border_right_style\\":\\"\\",\\"border_bottom_color\\":\\"\\",\\"border_bottom_width\\":\\"\\",\\"border_bottom_style\\":\\"\\",\\"border_left_color\\":\\"\\",\\"border_left_width\\":\\"\\",\\"border_left_style\\":\\"\\",\\"custom_css_row\\":\\"\\",\\"row_anchor\\":\\"\\"},\\"element_id\\":\\"quim211\\"},{\\"row_order\\":\\"6\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"modules\\":[],\\"styling\\":[],\\"element_id\\":\\"8zz8020\\"}],\\"styling\\":[],\\"element_id\\":\\"g4q2122\\"}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 5132,
  'post_date' => '2016-06-08 20:33:21',
  'post_date_gmt' => '2016-06-08 20:33:21',
  'post_content' => '<!--themify_builder_static--><img src="https://themify.me/demo/themes/builder-layouts/files/2016/01/personal-300x300.jpg" width="300" height="300" alt="" />
<h3 style="text-align: center;">Catherine Moon</h3> <p style="text-align: center;"><em>UI Designer</em></p>
<a href="https://www.facebook.com/themify"> </a> <a href="https://twitter.com/themify"> </a> <a href="https://plus.google.com/u/2/b/109280316400365629341/109280316400365629341"> </a>
<img src="https://themify.me/demo/themes/builder-layouts/files/2016/01/personal-2-1024x1024-400x400.jpg" width="400" alt="" />
<p>Hi! My names Stephanie Moon. Welcome to my personal page that I\'ve designed to showcase my skills and expertise that I\'ve accumulated over the year. I\'ve also placed a contact form below and all my social links on my header, feel free to connect with me. I\'d love to be given the opportunity to hear from you.</p><h4>A Little Bit About Me...</h4><p>I\'m a UI Designer with over 10 years experience in web design and content marketing. I\'m very fortunate to be given the opportunity to work for amazing companies that allowed me to grow with my skills as a UI designer. Aside from that experience, I\'ve also been a very passionate tech writer. Blogging content that focuses on increasing a site SEO. </p>
<h2 style="text-align: center;">My Skills</h2><p style="text-align: center;">Below is a breakdown of my skills in both design and programming. I\'ve created an animated bar graph that showcases the level of expertise I have for each of them. </p><p style="text-align: center;">**Purchase the <a href="https://themify.me/addons/progress-bar">Progress Bar Addon</a> to get the same looking progress bar to show off your skills**</p>
<h3>Design</h3> <i>Photoshop</i> <i>Illustrator</i> <i>Indesign</i> <i>Corel</i>
<h3>Programming</h3> <i>HTML</i> <i>CSS</i> <i>JS</i> <i>PHP</i>
<h2 style="text-align: center;">Work Experience</h2><p style="text-align: center;">**Purchase the <a href="https://themify.me/addons/timeline">Timeline Addon</a> to recreate this beautiful timeline resume layout**</p>
<h2 style="text-align: center;">Status</h2>
<h3> 4 Years Experience </h3>
<h3> 65 Completed Projects </h3>
<h3> 89 Happy Clients </h3>
<h2 style="text-align: center;">Portfolio</h2>
<p>[portfolio style="grid3" limit="3" image_w="366" image_h="260"]</p>
<a href="https://www.facebook.com/themify" > 
 
 </a> 
 <p style="text-align: center;">Facebook</p>
<a href="https://ca.linkedin.com/" > 
 
 </a> 
 <p style="text-align: center;">Linked In</p>
<a href="https://www.twitter.com/themify" > 
 
 </a> 
 <p style="text-align: center;">Twitter</p>
<a href="https://plus.google.com/u/0/b/109280316400365629341/109280316400365629341" > 
 
 </a> 
 <p style="text-align: center;">Google+</p>
<h2 style="text-align: center;">Contact</h2>
<h3></h3><iframe frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="https://maps.google.com/maps?q=Toronto%2C+ON&amp;t=m&amp;z=8&amp;output=embed&amp;iwloc=near"></iframe>
<p>[themify_icon icon="fa-map-marker" ] 250 King Str. West <br />[themify_icon icon="fa-phone" ] 647-992-4231</p>
<p>**Purchase the <a href="https://themify.me/addons/contact">Contact Addon </a>to recreate this contact form layout**</p>
<form action="https://themify.me/demo/themes/ultra/wp-admin/admin-ajax.php" id="contact-0--form" method="post"> <label for="contact-0--contact-name">Name </label> <input type="text" name="contact-name" placeholder="" id="contact-0--contact-name" value="" /> <label for="contact-0--contact-email">Email </label> <input type="text" name="contact-email" placeholder="" id="contact-0--contact-email" value="" /> <label for="contact-0--contact-message">Message *</label> <textarea name="contact-message" placeholder="" id="contact-0--contact-message" rows="8" cols="45" required></textarea> <button type="submit"> Send </button> </form><!--/themify_builder_static-->',
  'post_title' => 'Split Menu',
  'post_excerpt' => '',
  'post_name' => 'split-menu',
  'post_modified' => '2019-07-08 18:35:36',
  'post_modified_gmt' => '2019-07-08 18:35:36',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=5132',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'custom_menu' => 'personal-page-menu',
    'header_design' => 'header-menu-split',
    'mobile_menu_styles' => 'default',
    'header_wrap' => 'transparent',
    'footer_design' => 'none',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"imtu238\\",\\"cols\\":[{\\"element_id\\":\\"lmee245\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"84cs247\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/personal-300x300.jpg\\",\\"appearance_image\\":\\"rounded|circle\\",\\"width_image\\":\\"300\\",\\"height_image\\":\\"300\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"4hoo248\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Catherine Moon<\\\\/h3>\\\\n<p style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\"><em>UI Designer<\\\\/em><\\\\/p>\\\\n\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"az0h249\\",\\"mod_settings\\":{\\"icon_size\\":\\"xlarge\\",\\"icon_style\\":\\"none\\",\\"content_icon\\":[{\\"icon\\":\\"fa-facebook-f\\",\\"link\\":\\"https:\\\\/\\\\/www.facebook.com\\\\/themify\\"},{\\"icon\\":\\"fa-twitter\\",\\"link\\":\\"https:\\\\/\\\\/twitter.com\\\\/themify\\"},{\\"icon\\":\\"fa-google-plus\\",\\"link\\":\\"https:\\\\/\\\\/plus.google.com\\\\/u\\\\/2\\\\/b\\\\/109280316400365629341\\\\/109280316400365629341\\"}],\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"center\\",\\"text_decoration\\":\\"none\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_left\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"icon_position\\":\\"icon_position_left\\"}}]}],\\"styling\\":{\\"row_anchor\\":\\"welcome\\",\\"background_type\\":\\"video\\",\\"background_video\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/demo-videos\\\\/stockholm1.mp4\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/demo-videos\\\\/personal-page-fallback-1024x584.jpg\\",\\"background_repeat\\":\\"builder-parallax-scrolling\\",\\"background_color\\":\\"5d6366_1.00\\",\\"font_color\\":\\"ffffff_1.00\\",\\"link_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"bvd2239\\",\\"cols\\":[{\\"element_id\\":\\"k9dy250\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"kumm250\\",\\"cols\\":[{\\"element_id\\":\\"lrhu251\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"h6k7252\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/01\\\\/personal-2-1024x1024-400x400.jpg\\",\\"appearance_image\\":\\"rounded|circle\\",\\"width_image\\":\\"400\\",\\"height_image\\":\\"0\\"}}]},{\\"element_id\\":\\"5jza252\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"i54l252\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>Hi! My names Stephanie Moon. Welcome to my personal page that I\\\\\\\\\\\'ve designed to showcase my skills and expertise that I\\\\\\\\\\\'ve accumulated over the year. I\\\\\\\\\\\'ve also placed a contact form below and all my social links on my header, feel free to connect with me. I\\\\\\\\\\\'d love to be given the opportunity to hear from you.<\\\\/p><h4>A Little Bit About Me...<\\\\/h4><p>I\\\\\\\\\\\'m a UI Designer with over 10 years experience in web design and content marketing. I\\\\\\\\\\\'m very fortunate to be given the opportunity to work for amazing companies that allowed me to grow with my skills as a UI designer. Aside from that experience, I\\\\\\\\\\\'ve also been a very passionate tech writer. Blogging content that focuses on increasing a site SEO. <\\\\/p>\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\"}}]}]}]}],\\"styling\\":{\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"row_anchor\\":\\"about\\"}},{\\"element_id\\":\\"ukuu239\\",\\"cols\\":[{\\"element_id\\":\\"6oi7253\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"l77s253\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">My Skills<\\\\/h2><p style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Below is a breakdown of my skills in both design and programming. I\\\\\\\\\\\'ve created an animated bar graph that showcases the level of expertise I have for each of them. <\\\\/p><p style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">**Purchase the <a href=\\\\\\\\\\\\\\"https:\\\\/\\\\/themify.me\\\\/addons\\\\/progress-bar\\\\\\\\\\\\\\">Progress Bar Addon<\\\\/a> to get the same looking progress bar to show off your skills**<\\\\/p>\\",\\"link_color\\":\\"a23ab0_1.00\\",\\"text_decoration\\":\\"underline\\"}},{\\"element_id\\":\\"lruf253\\",\\"cols\\":[{\\"element_id\\":\\"sl9y253\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"progressbar\\",\\"element_id\\":\\"kdmy254\\",\\"mod_settings\\":{\\"mod_title_progressbar\\":\\"Design\\",\\"progress_bars\\":[{\\"bar_label\\":\\"Photoshop\\",\\"bar_percentage\\":\\"90\\",\\"bar_color\\":\\"e267eb_1.00\\"},{\\"bar_label\\":\\"Illustrator\\",\\"bar_percentage\\":\\"80\\",\\"bar_color\\":\\"e86464_1.00\\"},{\\"bar_label\\":\\"Indesign\\",\\"bar_percentage\\":\\"70\\",\\"bar_color\\":\\"ffcb5c_1.00\\"},{\\"bar_label\\":\\"Corel\\",\\"bar_percentage\\":\\"60\\",\\"bar_color\\":\\"949494_1.00\\"}],\\"hide_percentage_text\\":\\"yes\\"}}]},{\\"element_id\\":\\"o980254\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"progressbar\\",\\"element_id\\":\\"n2ww254\\",\\"mod_settings\\":{\\"mod_title_progressbar\\":\\"Programming\\",\\"progress_bars\\":[{\\"bar_label\\":\\"HTML\\",\\"bar_percentage\\":\\"80\\",\\"bar_color\\":\\"68d2ed_1.00\\"},{\\"bar_label\\":\\"CSS\\",\\"bar_percentage\\":\\"73\\",\\"bar_color\\":\\"eb659f_1.00\\"},{\\"bar_label\\":\\"JS\\",\\"bar_percentage\\":\\"65\\",\\"bar_color\\":\\"ff36de_1.00\\"},{\\"bar_label\\":\\"PHP\\",\\"bar_percentage\\":\\"30\\",\\"bar_color\\":\\"9ec737_1.00\\"}],\\"hide_percentage_text\\":\\"yes\\"}}]}]}]}],\\"styling\\":{\\"background_color\\":\\"edf6ff_1.00\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"row_anchor\\":\\"skills\\"}},{\\"element_id\\":\\"vc6p239\\",\\"cols\\":[{\\"element_id\\":\\"xvcw255\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"gndy255\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Work Experience<\\\\/h2><p style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">**Purchase the <a href=\\\\\\\\\\\\\\"https:\\\\/\\\\/themify.me\\\\/addons\\\\/timeline\\\\\\\\\\\\\\">Timeline Addon<\\\\/a> to recreate this beautiful timeline resume layout**<\\\\/p>\\",\\"link_color\\":\\"ffffff_1.00\\",\\"text_decoration\\":\\"underline\\"}}]}],\\"styling\\":{\\"row_anchor\\":\\"resume\\",\\"background_color\\":\\"96e0eb_1.00\\",\\"font_color\\":\\"000000_1.00\\",\\"link_color\\":\\"fffa70_1.00\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"y1pr239\\",\\"cols\\":[{\\"element_id\\":\\"e2jp255\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"w5ta256\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Status<\\\\/h2>\\",\\"link_color\\":\\"ffffff_1.00\\"}},{\\"element_id\\":\\"a854256\\",\\"cols\\":[{\\"element_id\\":\\"yz55256\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"z797256\\",\\"mod_settings\\":{\\"title_feature\\":\\"4 Years Experience\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"ffffff_1.00\\",\\"circle_size_feature\\":\\"large\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-calendar\\",\\"icon_color_feature\\":\\"ffffff_1.00\\"}}]},{\\"element_id\\":\\"l7w1257\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"3hp5257\\",\\"mod_settings\\":{\\"title_feature\\":\\"65 Completed Projects\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"ffffff_1.00\\",\\"circle_size_feature\\":\\"large\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-check-square\\",\\"icon_color_feature\\":\\"ffffff_1.00\\"}}]},{\\"element_id\\":\\"jr21257\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"ie7m258\\",\\"mod_settings\\":{\\"title_feature\\":\\"89 Happy Clients\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"ffffff_1.00\\",\\"circle_size_feature\\":\\"large\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-heart\\",\\"icon_color_feature\\":\\"ffffff_1.00\\"}}]}]}]}],\\"styling\\":{\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/02\\\\/173422046.png\\",\\"background_repeat\\":\\"builder-parallax-scrolling\\",\\"font_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"row_anchor\\":\\"status\\"}},{\\"element_id\\":\\"v055239\\",\\"cols\\":[{\\"element_id\\":\\"xj44258\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"a0zz258\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Portfolio<\\\\/h2>\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"pslf259\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>[portfolio style=\\\\\\\\\\\\\\"grid3\\\\\\\\\\\\\\" limit=\\\\\\\\\\\\\\"3\\\\\\\\\\\\\\" image_w=\\\\\\\\\\\\\\"366\\\\\\\\\\\\\\" image_h=\\\\\\\\\\\\\\"260\\\\\\\\\\\\\\"]<\\\\/p>\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"row_anchor\\":\\"portfolio\\"}},{\\"element_id\\":\\"ids2239\\",\\"cols\\":[{\\"element_id\\":\\"xv3j259\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"80d3259\\",\\"cols\\":[{\\"element_id\\":\\"sdcd260\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"u7gz260\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_feature\\":\\"<p style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Facebook<\\\\/p>\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-facebook\\",\\"icon_color_feature\\":\\"000000\\",\\"icon_bg_feature\\":\\"ffffff\\",\\"link_feature\\":\\"https:\\\\/\\\\/www.facebook.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"circle_percentage_feature\\":\\"0\\",\\"circle_color_feature\\":\\"#de5d5d\\"}}]},{\\"element_id\\":\\"ewlf260\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"chps260\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_feature\\":\\"<p style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Linked In<\\\\/p>\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-linkedin\\",\\"icon_color_feature\\":\\"000000\\",\\"icon_bg_feature\\":\\"ffffff\\",\\"link_feature\\":\\"https:\\\\/\\\\/ca.linkedin.com\\\\/\\",\\"link_options\\":\\"regular\\",\\"circle_percentage_feature\\":\\"0\\",\\"circle_color_feature\\":\\"#de5d5d\\"}}]},{\\"element_id\\":\\"c19i261\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"9xvr263\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_feature\\":\\"<p style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Twitter<\\\\/p>\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-twitter\\",\\"icon_color_feature\\":\\"000000\\",\\"icon_bg_feature\\":\\"ffffff\\",\\"link_feature\\":\\"https:\\\\/\\\\/www.twitter.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"circle_percentage_feature\\":\\"0\\",\\"circle_color_feature\\":\\"#de5d5d\\"}}]},{\\"element_id\\":\\"l24s264\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"oyeq264\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_feature\\":\\"<p style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Google+<\\\\/p>\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-google-plus\\",\\"icon_color_feature\\":\\"000000\\",\\"icon_bg_feature\\":\\"ffffff\\",\\"link_feature\\":\\"https:\\\\/\\\\/plus.google.com\\\\/u\\\\/0\\\\/b\\\\/109280316400365629341\\\\/109280316400365629341\\",\\"link_options\\":\\"regular\\",\\"circle_percentage_feature\\":\\"0\\",\\"circle_color_feature\\":\\"#de5d5d\\"}}]}]}]}],\\"styling\\":{\\"row_anchor\\":\\"connect\\",\\"background_color\\":\\"e6ae6a_1.00\\",\\"font_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"5ux2241\\",\\"cols\\":[{\\"element_id\\":\\"piz6264\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"91gn265\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Contact<\\\\/h2>\\",\\"link_color\\":\\"b751d6_1.00\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"element_id\\":\\"bqpq265\\",\\"cols\\":[{\\"element_id\\":\\"auso265\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"map\\",\\"element_id\\":\\"r1jp265\\",\\"mod_settings\\":{\\"address_map\\":\\"Toronto, ON\\",\\"zoom_map\\":\\"8\\",\\"w_map\\":\\"100\\",\\"unit_w\\":\\"%\\",\\"h_map\\":\\"200\\",\\"type_map\\":\\"TERRAIN\\",\\"scrollwheel_map\\":\\"disable\\",\\"draggable_map\\":\\"enable\\",\\"draggable_disable_mobile_map\\":\\"yes\\",\\"info_window_map\\":\\"Call me @ 647-992-4231\\",\\"w_map_static\\":\\"500\\",\\"map_display_type\\":\\"dynamic\\",\\"w_map_unit\\":\\"%\\",\\"unit_h\\":\\"-1\\",\\"map_control\\":\\"yes\\",\\"map_provider\\":\\"google\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ev93265\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>[themify_icon icon=\\\\\\\\\\\\\\"fa-map-marker\\\\\\\\\\\\\\" ] 250 King Str. West <br \\\\/>[themify_icon icon=\\\\\\\\\\\\\\"fa-phone\\\\\\\\\\\\\\" ] 647-992-4231<\\\\/p>\\",\\"padding_top\\":\\"2\\",\\"padding_top_unit\\":\\"%\\"}}]},{\\"element_id\\":\\"burk265\\",\\"grid_class\\":\\"col4-3\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ehzn266\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>**Purchase the <a href=\\\\\\\\\\\\\\"https:\\\\/\\\\/themify.me\\\\/addons\\\\/contact\\\\\\\\\\\\\\">Contact Addon <\\\\/a>to recreate this contact form layout**<\\\\/p>\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"contact\\",\\"element_id\\":\\"d0s2266\\",\\"mod_settings\\":{\\"layout_contact\\":\\"style1\\",\\"field_email_active\\":\\"yes\\",\\"field_name_active\\":\\"yes\\",\\"field_message_active\\":\\"yes\\",\\"field_send_align\\":\\"left\\",\\"field_sendcopy_active\\":\\"\\",\\"field_captcha_active\\":\\"\\",\\"field_subject_active\\":\\"\\",\\"field_subject_require\\":\\"\\",\\"field_email_require\\":\\"\\",\\"field_name_require\\":\\"\\",\\"contact_sent_from\\":\\"enable\\",\\"post_author\\":\\"\\",\\"send_to_admins\\":\\"true\\"}}]}]}]}],\\"styling\\":{\\"row_anchor\\":\\"contact\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 5617,
  'post_date' => '2016-08-29 14:25:42',
  'post_date_gmt' => '2016-08-29 14:25:42',
  'post_content' => '<!--themify_builder_static--><img src="https://themify.me/demo/themes/builder-layouts/files/2016/08/pen-pencil.png" width="329" height="471" alt="" />
<img src="https://themify.me/demo/themes/builder-layouts/files/2016/08/paper-clips-246x266.png" alt="" />
<img src="https://themify.me/demo/themes/builder-layouts/files/2016/08/john-1024x684-400x400.jpg" width="400" height="400" alt="" />

<h1>John Smith</h1><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</p>
<a href="https://www.facebook.com/themify"> </a> <a href="https://twitter.com/themify"> </a> <a href="https://www.youtube.com/user/themifyme"> </a>
<img src="https://themify.me/demo/themes/builder-layouts/files/2016/08/mac-keyboard.png" alt="" />

<h2>Skills</h2>
<img src="https://themify.me/demo/themes/builder-layouts/files/2016/08/macair-650x550.png" width="650" height="550" alt="" />
<h3>Web Design</h3> <p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores. Nam libero tempore, nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda sed do eiusmod tempor incididunt ut labore et nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit,  sed quia consequuntur magni dolores.</p>
<a href="https://themify.me/" > View Portfolio </a>
<img src="https://themify.me/demo/themes/builder-layouts/files/2016/08/ipad.png" width="400" height="786" alt="" />
<h3>Mobile App</h3> <p>Similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores.</p>
<a href="https://themify.me/" > Download Apps </a>
<img src="https://themify.me/demo/themes/builder-layouts/files/2016/08/iphone.png" width="350" height="579" alt="" />
<h3>Logo Design</h3> <p>Nam libero tempore, nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda sed do eiusmod tempor incididunt ut labore et nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit,  sed quia consequuntur magni dolores.</p>
<img src="https://themify.me/demo/themes/builder-layouts/files/2016/08/desk-931928_1280-1024x681-400x400.jpg" width="400" height="400" alt="" />

<h2>Profile</h2>
<h4>July 2016</h4><p> </p>
<h3> Received a Design Award </h3> <p>Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores  qui dolorem ipsum quia dolor sit amet, consectetur.</p>
<h3> Launched My First App </h3> <p>Quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda.</p>
<h4>March 2016</h4><p> </p>
<h4>March 2015</h4><p> </p>
<h3> 12 Sites Created </h3> <p>Aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus.</p>
<h3> Graduated From College </h3> <p>Consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commod.</p>
<h4>April 2014</h4><p> </p>

<h2>Contact</h2>
email@gmail.com 416-122-2882 123 Street Ave. Toronto, ON
<p>Use Builder Contact addon to add a contact form below.</p>
<form action="https://themify.me/demo/themes/ultra/wp-admin/admin-ajax.php" id="contact-0--form" method="post"> <label for="contact-0--contact-name">Name </label> <input type="text" name="contact-name" placeholder="" id="contact-0--contact-name" value="" /> <label for="contact-0--contact-email">Email </label> <input type="text" name="contact-email" placeholder="" id="contact-0--contact-email" value="" /> <label for="contact-0--contact-subject">Subject </label> <input type="text" name="contact-subject" placeholder="" id="contact-0--contact-subject" value="" /> <label for="contact-0--contact-message">Message *</label> <textarea name="contact-message" placeholder="" id="contact-0--contact-message" rows="8" cols="45" required></textarea> <button type="submit"> Send </button> </form><!--/themify_builder_static-->',
  'post_title' => 'Stripe',
  'post_excerpt' => '',
  'post_name' => 'stripe',
  'post_modified' => '2019-07-08 18:32:50',
  'post_modified_gmt' => '2019-07-08 18:32:50',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=5617',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'header_design' => 'header-stripe',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"a017696\\",\\"cols\\":[{\\"element_id\\":\\"325d12c\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"0266a39\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/08\\\\/pen-pencil.png\\",\\"width_image\\":\\"329\\",\\"height_image\\":\\"471\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeInLeft\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"685ff4c\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/08\\\\/paper-clips-246x266.png\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeInLeft\\",\\"custom_parallax_scroll_speed\\":\\"5\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"f9ff4ce\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"a169c22\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/08\\\\/john-1024x684-400x400.jpg\\",\\"appearance_image\\":\\"circle\\",\\"width_image\\":\\"400\\",\\"height_image\\":\\"400\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeInDown\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"f2e55f7\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"000\\",\\"bottom_margin_divider\\":\\"40\\",\\"divider_type\\":\\"custom\\",\\"divider_width\\":\\"100\\",\\"divider_align\\":\\"center\\",\\"animation_effect\\":\\"bounceInDown\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"3d4a303\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>John Smith<\\\\/h1><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.<\\\\/p>\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"40\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeInUp\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"2d536b3\\",\\"mod_settings\\":{\\"icon_size\\":\\"large\\",\\"icon_style\\":\\"circle\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"fa-facebook\\",\\"icon_color_bg\\":\\"blue\\",\\"link\\":\\"https:\\\\/\\\\/www.facebook.com\\\\/themify\\"},{\\"icon\\":\\"fa-twitter\\",\\"icon_color_bg\\":\\"light-blue\\",\\"link\\":\\"https:\\\\/\\\\/twitter.com\\\\/themify\\"},{\\"icon\\":\\"fa-youtube\\",\\"icon_color_bg\\":\\"red\\",\\"link\\":\\"https:\\\\/\\\\/www.youtube.com\\\\/user\\\\/themifyme\\"}],\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeInUp\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"icon_position\\":\\"icon_position_left\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_right\\":\\"10\\",\\"padding_left\\":\\"10\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"ec9af42\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"f6ea9aa\\",\\"mod_settings\\":{\\"style_image\\":\\"image-right\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/08\\\\/mac-keyboard.png\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeInRight\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"7\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"96a1038\\",\\"cols\\":[{\\"element_id\\":\\"d2a8c66\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"ac7a989\\",\\"cols\\":[{\\"element_id\\":\\"327d7f4\\",\\"grid_class\\":\\"col4-1\\"},{\\"element_id\\":\\"7a1a502\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"c7872d0\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"000\\",\\"bottom_margin_divider\\":\\"40\\",\\"divider_type\\":\\"custom\\",\\"divider_width\\":\\"100\\",\\"divider_align\\":\\"center\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"2b872c4\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"text_align\\":\\"center\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>Skills<\\\\/h2>\\",\\"stick_at_position\\":\\"top\\",\\"custom_parallax_scroll_zindex\\":\\"1\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"e833990\\",\\"grid_class\\":\\"col4-1\\"}]}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"b056177\\",\\"cols\\":[{\\"element_id\\":\\"44816d0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"6bdeded\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/08\\\\/macair-650x550.png\\",\\"width_image\\":\\"650\\",\\"height_image\\":\\"550\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_speed\\":\\"2\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_mobile\\":{\\"padding_bottom\\":\\"40\\",\\"checkbox_margin_apply_all\\":\\"margin\\"}}}]},{\\"element_id\\":\\"7a7d359\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"0e6dd00\\",\\"cols\\":[{\\"element_id\\":\\"a871bdd\\",\\"grid_class\\":\\"col4-3\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"08181ae\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"left\\",\\"margin_bottom\\":\\"20\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\"},\\"content_text\\":\\"<h3>Web Design<\\\\/h3>\\\\n<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores. Nam libero tempore, nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda sed do eiusmod tempor incididunt ut labore et nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit,  sed quia consequuntur magni dolores.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"custom_parallax_scroll_zindex\\":\\"1\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"2505bc8\\",\\"mod_settings\\":{\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"outline\\",\\"content_button\\":[{\\"label\\":\\"View Portfolio\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"button_color_bg\\":\\"blue\\"}],\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"text_align\\":\\"left\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_link_padding_apply_all\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"text_align\\":\\"center\\",\\"padding_bottom\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_link_padding_apply_all\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\"}}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_right\\":\\"15\\",\\"padding_left\\":\\"15\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"ccc9161\\",\\"grid_class\\":\\"col4-1\\"}]}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"b452adb\\",\\"cols\\":[{\\"element_id\\":\\"5e79e36\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"d53eeb7\\",\\"cols\\":[{\\"element_id\\":\\"1dc8484\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"4df9686\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/08\\\\/ipad.png\\",\\"width_image\\":\\"400\\",\\"height_image\\":\\"786\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_speed\\":\\"2\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"13b0f1c\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"70c5ef5\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"margin_bottom\\":\\"20\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Mobile App<\\\\/h3>\\\\n<p>Similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"custom_parallax_scroll_zindex\\":\\"1\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"770607c\\",\\"mod_settings\\":{\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"outline\\",\\"content_button\\":[{\\"label\\":\\"Download Apps\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"button_color_bg\\":\\"blue\\"}],\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_link_padding_apply_all\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"padding_bottom\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_link_padding_apply_all\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\"}}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_right\\":\\"15\\",\\"padding_left\\":\\"15\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"7d2aa71\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"b85b047\\",\\"mod_settings\\":{\\"style_image\\":\\"image-right\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/08\\\\/iphone.png\\",\\"width_image\\":\\"350\\",\\"height_image\\":\\"579\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_speed\\":\\"6\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_mobile\\":{\\"padding_bottom\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\"}}}]}],\\"column_alignment\\":\\"col_align_middle\\"}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"3f38e4a\\",\\"cols\\":[{\\"element_id\\":\\"65d0fa9\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"5078334\\",\\"cols\\":[{\\"element_id\\":\\"ac28abb\\",\\"grid_class\\":\\"col3-1\\"},{\\"element_id\\":\\"622a202\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"547e173\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"right\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\"},\\"content_text\\":\\"<h3>Logo Design<\\\\/h3>\\\\n<p>Nam libero tempore, nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda sed do eiusmod tempor incididunt ut labore et nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit,  sed quia consequuntur magni dolores.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"custom_parallax_scroll_zindex\\":\\"1\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_right\\":\\"15\\",\\"padding_left\\":\\"15\\",\\"checkbox_border_apply_all\\":\\"border\\"}}]}]},{\\"element_id\\":\\"2e40647\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"a518519\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/08\\\\/desk-931928_1280-1024x681-400x400.jpg\\",\\"appearance_image\\":\\"circle\\",\\"width_image\\":\\"400\\",\\"height_image\\":\\"400\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_speed\\":\\"2\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"33f973a\\",\\"cols\\":[{\\"element_id\\":\\"4c1965a\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"be8bd48\\",\\"cols\\":[{\\"element_id\\":\\"5194924\\",\\"grid_class\\":\\"col3-1\\"},{\\"element_id\\":\\"e6d59bd\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"6e80ec3\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"000\\",\\"bottom_margin_divider\\":\\"40\\",\\"divider_type\\":\\"custom\\",\\"divider_width\\":\\"100\\",\\"divider_align\\":\\"left\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"f2f190f\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"margin_bottom\\":\\"40\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>Profile<\\\\/h2>\\",\\"stick_at_position\\":\\"top\\",\\"custom_parallax_scroll_zindex\\":\\"1\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_right\\":\\"10\\",\\"padding_left\\":\\"10\\",\\"checkbox_border_apply_all\\":\\"border\\"}}],\\"column_alignment\\":\\"col_align_middle\\"}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"081672c\\",\\"cols\\":[{\\"element_id\\":\\"ce734f1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"587bd7f\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>July 2016<\\\\/h4><p> <\\\\/p>\\",\\"text_align\\":\\"right\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_zindex\\":\\"1\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_right\\":\\"15\\",\\"padding_left\\":\\"15\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"f715c00\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"element_id\\":\\"313efea\\",\\"cols\\":[{\\"element_id\\":\\"7ed7b48\\",\\"grid_class\\":\\"col4-3\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"3d5e742\\",\\"mod_settings\\":{\\"title_feature\\":\\"Received a Design Award\\",\\"content_feature\\":\\"<p>Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores  qui dolorem ipsum quia dolor sit amet, consectetur.<\\\\/p>\\",\\"layout_feature\\":\\"icon-left\\",\\"circle_size_feature\\":\\"large\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-trophy\\",\\"icon_color_feature\\":\\"ffffff_1.00\\",\\"icon_bg_feature\\":\\"91d1e6_1.00\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"circle_percentage_feature\\":\\"0\\",\\"circle_color_feature\\":\\"#de5d5d\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_right\\":\\"15\\",\\"padding_left\\":\\"15\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"7dbe517\\",\\"grid_class\\":\\"col4-1\\"}]}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"9fd9399\\",\\"cols\\":[{\\"element_id\\":\\"04e7948\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"element_id\\":\\"d3c7bb7\\",\\"cols\\":[{\\"element_id\\":\\"0f13d68\\",\\"grid_class\\":\\"col4-1\\"},{\\"element_id\\":\\"1da3e24\\",\\"grid_class\\":\\"col4-3\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"6673284\\",\\"mod_settings\\":{\\"title_feature\\":\\"Launched My First App\\",\\"content_feature\\":\\"<p>Quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda.<\\\\/p>\\",\\"layout_feature\\":\\"icon-right\\",\\"circle_size_feature\\":\\"large\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-rocket\\",\\"icon_color_feature\\":\\"ffffff_1.00\\",\\"icon_bg_feature\\":\\"e6b345_1.00\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"circle_percentage_feature\\":\\"0\\",\\"circle_color_feature\\":\\"#de5d5d\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_right\\":\\"15\\",\\"padding_left\\":\\"15\\",\\"checkbox_border_apply_all\\":\\"border\\"}}]}]},{\\"element_id\\":\\"ad46e69\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"19f423a\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>March 2016<\\\\/h4><p> <\\\\/p>\\",\\"text_align\\":\\"left\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_zindex\\":\\"1\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_right\\":\\"15\\",\\"padding_left\\":\\"15\\",\\"checkbox_border_apply_all\\":\\"border\\"}}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"9a90ebf\\",\\"cols\\":[{\\"element_id\\":\\"08ece34\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"887ead2\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>March 2015<\\\\/h4><p> <\\\\/p>\\",\\"text_align\\":\\"right\\",\\"padding_right\\":\\"15\\",\\"padding_left\\":\\"15\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_zindex\\":\\"1\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"b0fb165\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"element_id\\":\\"41464ac\\",\\"cols\\":[{\\"element_id\\":\\"c0f4f49\\",\\"grid_class\\":\\"col4-3\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"bd427c8\\",\\"mod_settings\\":{\\"title_feature\\":\\"12 Sites Created\\",\\"content_feature\\":\\"<p>Aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus.<\\\\/p>\\",\\"layout_feature\\":\\"icon-left\\",\\"circle_size_feature\\":\\"large\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-file-code-o\\",\\"icon_color_feature\\":\\"ffffff_1.00\\",\\"icon_bg_feature\\":\\"cd92e8_1.00\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"circle_percentage_feature\\":\\"0\\",\\"circle_color_feature\\":\\"#de5d5d\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_right\\":\\"15\\",\\"padding_left\\":\\"15\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"01f55bf\\",\\"grid_class\\":\\"col4-1\\"}]}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"dashed\\",\\"border_right_style\\":\\"dashed\\",\\"border_bottom_style\\":\\"dashed\\",\\"border_left_style\\":\\"dashed\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"451b0f1\\",\\"cols\\":[{\\"element_id\\":\\"fa5ec48\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"element_id\\":\\"5873dd4\\",\\"cols\\":[{\\"element_id\\":\\"70e0a22\\",\\"grid_class\\":\\"col4-1\\"},{\\"element_id\\":\\"a9248ea\\",\\"grid_class\\":\\"col4-3\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"515c3ea\\",\\"mod_settings\\":{\\"title_feature\\":\\"Graduated From College\\",\\"content_feature\\":\\"<p>Consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commod.<\\\\/p>\\",\\"layout_feature\\":\\"icon-right\\",\\"circle_size_feature\\":\\"large\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-graduation-cap\\",\\"icon_color_feature\\":\\"ffffff_1.00\\",\\"icon_bg_feature\\":\\"68d1b5_1.00\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"circle_percentage_feature\\":\\"0\\",\\"circle_color_feature\\":\\"#de5d5d\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_right\\":\\"15\\",\\"padding_left\\":\\"15\\",\\"checkbox_border_apply_all\\":\\"border\\"}}]}]},{\\"element_id\\":\\"18939ed\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"7d46097\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>April 2014<\\\\/h4><p> <\\\\/p>\\",\\"text_align\\":\\"left\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_zindex\\":\\"1\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_right\\":\\"15\\",\\"padding_left\\":\\"15\\",\\"checkbox_border_apply_all\\":\\"border\\"}}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"dashed\\",\\"border_right_style\\":\\"dashed\\",\\"border_bottom_style\\":\\"dashed\\",\\"border_left_style\\":\\"dashed\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"6cbd3f7\\",\\"cols\\":[{\\"element_id\\":\\"c4da1d3\\",\\"grid_class\\":\\"col4-1\\"},{\\"element_id\\":\\"1c00442\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"ac67acd\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"000\\",\\"bottom_margin_divider\\":\\"40\\",\\"divider_type\\":\\"custom\\",\\"divider_width\\":\\"100\\",\\"divider_align\\":\\"left\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"6df7f83\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"margin_bottom\\":\\"40\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>Contact<\\\\/h2>\\",\\"stick_at_position\\":\\"top\\",\\"custom_parallax_scroll_zindex\\":\\"1\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"a1eff63\\",\\"mod_settings\\":{\\"icon_size\\":\\"large\\",\\"icon_style\\":\\"none\\",\\"icon_arrangement\\":\\"icon_vertical\\",\\"content_icon\\":[{\\"icon\\":\\"fa-envelope\\",\\"label\\":\\"email@gmail.com\\"},{\\"icon\\":\\"fa-phone\\",\\"label\\":\\"416-122-2882\\"},{\\"icon\\":\\"fa-map-marker\\",\\"label\\":\\"123 Street Ave. Toronto, ON\\"}],\\"text_align\\":\\"left\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"icon_position\\":\\"icon_position_left\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"b1a76b0\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>Use Builder Contact addon to add a contact form below.<\\\\/p>\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"contact\\",\\"element_id\\":\\"549d187\\",\\"mod_settings\\":{\\"layout_contact\\":\\"style2\\",\\"field_subject_active\\":\\"yes\\",\\"background_color\\":\\"f5f5f5_1.00\\",\\"padding_top\\":\\"2\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"2\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"field_email_active\\":\\"yes\\",\\"field_name_active\\":\\"yes\\",\\"field_message_active\\":\\"yes\\",\\"field_send_align\\":\\"left\\",\\"field_sendcopy_active\\":\\"\\",\\"field_captcha_active\\":\\"\\",\\"field_subject_require\\":\\"\\",\\"field_email_require\\":\\"\\",\\"field_name_require\\":\\"\\",\\"contact_sent_from\\":\\"enable\\",\\"post_author\\":\\"\\",\\"send_to_admins\\":\\"true\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_right\\":\\"15\\",\\"padding_left\\":\\"15\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"fb35553\\",\\"grid_class\\":\\"col4-1\\"}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 4249,
  'post_date' => '2015-07-01 18:48:36',
  'post_date_gmt' => '2015-07-01 18:48:36',
  'post_content' => '<!--themify_builder_static--><h1>Understanding Your Customers</h1> <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip</p> 
 <a href="https://themify.me/" >Get Started</a> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2018/10/app-tablet-500x361.png" width="500" height="361" alt="" /> 
 <h2>What We Offer</h2> 
 
 
 
 <h3>Real Time Visitor Traffic</h3> <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. </p> 
 
 
 
 
 <h3>One Time Settings</h3> <p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam</p> 
 
 
 
 
 <h3>Live Chat </h3> <p>Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, laudantium, totam rem aperiam</p> 
 
 
 
 
 <h3>Custom User Interface</h3> <p>Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi</p> 
 
 
 
 
 <h3>Location Tracking</h3> <p>Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi</p> 
 
 <a href="https://themify.me"> See All Features </a> 
 
 <p>This App helped us optimize our marketplace</p> 
 <h3>Deep Inside App</h3> <p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas.</p> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2018/10/dashboard-users-1-550x404.png" width="550" height="404" alt="" /> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2018/10/files-400x404.png" width="400" height="404" alt="" /> 
 <h3>Research Prove Successful Marketing Sales</h3> <p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo</p> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2018/10/macbook-550x332.png" width="550" height="332" alt="" /> 
 <h3>Built For Marketing</h3> <p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas.</p> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2018/10/echo-solution.png" width="70" title="Echo Marketing" alt="Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. " /> <h3> Echo Marketing </h3> Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.  
 <img src="https://themify.me/demo/themes/builder-layouts/files/2018/10/sunlab-technology.png" width="70" title="SunLab" alt="Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. " /> <h3> SunLab </h3> Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.  
 <img src="https://themify.me/demo/themes/builder-layouts/files/2018/10/red.png" width="70" title="Red Square" alt="Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. " /> <h3> Red Square </h3> Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.  
 <img src="https://themify.me/demo/themes/builder-layouts/files/2018/11/firstrate.jpg" width="70" title="First Rate" alt="Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. " /> <h3> First Rate </h3> Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.  
 <a href="https://themify.me"> Read More </a> 
 <h3>Start Now</h3> <p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo</p> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2018/10/bar.png" width="100" height="100" title="Basic Tracking" alt="Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore" /> <h3> Basic Tracking </h3> Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore 
 <a href="https://themify.me/" >Go Basic</a> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2018/10/bar2.png" width="100" height="100" title="Pro Tracking" alt="Et harum quidem rerum facilis est et expedita distinctio.eligendi optio cumque nihil" /> <h3> Pro Tracking </h3> Et harum quidem rerum facilis est et expedita distinctio.eligendi optio cumque nihil 
 <a href="https://themify.me/" >Go Pro!</a><!--/themify_builder_static-->',
  'post_title' => 'Top Bar',
  'post_excerpt' => '',
  'post_name' => 'top-bar',
  'post_modified' => '2018-11-30 23:30:07',
  'post_modified_gmt' => '2018-11-30 23:30:07',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=4249',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'color_design' => 'theme-color-blue',
    'header_design' => 'header-top-bar',
    'mobile_menu_styles' => 'default',
    'footer_design' => 'footer-horizontal-left',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"658acd8\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"59c4e65\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"975e049\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h1>Understanding Your Customers<\\\\/h1>\\\\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"e7c9876\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"e7c9876\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\",\\"buttons_size\\":\\"xlarge\\",\\"buttons_shape\\":\\"circle\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Get Started\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"blue\\",\\"icon_alignment\\":\\"left\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"thumbnail\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"3500\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"background_color\\":\\"#ffffff_0.95\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"left-top\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"px\\",\\"top-frame_height_unit\\":\\"px\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"px\\",\\"bottom-frame_height_unit\\":\\"px\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"px\\",\\"left-frame_height_unit\\":\\"px\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"px\\",\\"right-frame_height_unit\\":\\"px\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"3\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"3\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"f865452\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"thumbnail\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"3500\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"left-top\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"px\\",\\"top-frame_height_unit\\":\\"px\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"px\\",\\"bottom-frame_height_unit\\":\\"px\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"px\\",\\"left-frame_height_unit\\":\\"px\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"px\\",\\"right-frame_height_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2018\\\\/10\\\\/girl-opening-store.jpg\\",\\"background_repeat\\":\\"best-fit-image\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"best-fit-image\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"48\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"6\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"6\\",\\"padding_left_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"d06d172\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"d06d172\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"176c2e4\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"aa29873\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2018\\\\/10\\\\/app-tablet-500x361.png\\",\\"width_image\\":\\"500\\",\\"height_image\\":\\"361\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"3\\",\\"stick_at_check\\":\\"stick_at_check\\",\\"stick_at_position\\":\\"top\\",\\"stick_at_pos_val\\":\\"100\\",\\"unstick_when_check\\":\\"unstick_when_check\\",\\"unstick_when_element\\":\\"row\\",\\"unstick_when_el_row_id\\":\\"fa7752a\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]},{\\"element_id\\":\\"4581237\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"971a3dc\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"10\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>What We Offer<\\\\/h2>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"da5cdbe\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"checkbox_c_m_apply_all\\":\\"1\\",\\"c_b-type\\":\\"top\\",\\"title_feature\\":\\"Real Time Visitor Traffic\\",\\"content_feature\\":\\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. <\\\\/p>\\",\\"layout_feature\\":\\"icon-left\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_color_feature\\":\\"#de5d5d\\",\\"circle_size_feature\\":\\"custom\\",\\"custom_circle_size_feature\\":\\"70\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"ti-stats-up\\",\\"icon_color_feature\\":\\"#ffffff\\",\\"icon_bg_feature\\":\\"#4d7de1\\",\\"link_options\\":\\"regular\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"3fd7036\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"checkbox_c_m_apply_all\\":\\"1\\",\\"c_b-type\\":\\"top\\",\\"title_feature\\":\\"One Time Settings\\",\\"content_feature\\":\\"<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam<\\\\/p>\\",\\"layout_feature\\":\\"icon-left\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_color_feature\\":\\"#de5d5d\\",\\"circle_size_feature\\":\\"custom\\",\\"custom_circle_size_feature\\":\\"70\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"ti-hummer\\",\\"icon_color_feature\\":\\"#ffffff\\",\\"icon_bg_feature\\":\\"#4d7de1\\",\\"link_options\\":\\"regular\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"gd8e663\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"checkbox_c_m_apply_all\\":\\"1\\",\\"c_b-type\\":\\"top\\",\\"title_feature\\":\\"Live Chat \\",\\"content_feature\\":\\"<p>Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, laudantium, totam rem aperiam<\\\\/p>\\",\\"layout_feature\\":\\"icon-left\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_color_feature\\":\\"#de5d5d\\",\\"circle_size_feature\\":\\"custom\\",\\"custom_circle_size_feature\\":\\"70\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"ti-comments\\",\\"icon_color_feature\\":\\"#ffffff\\",\\"icon_bg_feature\\":\\"#4d7de1\\",\\"link_options\\":\\"regular\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"3quh000\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"checkbox_c_m_apply_all\\":\\"1\\",\\"c_b-type\\":\\"top\\",\\"title_feature\\":\\"Custom User Interface\\",\\"content_feature\\":\\"<p>Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi<\\\\/p>\\",\\"layout_feature\\":\\"icon-left\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_color_feature\\":\\"#de5d5d\\",\\"circle_size_feature\\":\\"custom\\",\\"custom_circle_size_feature\\":\\"70\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"ti-user\\",\\"icon_color_feature\\":\\"#ffffff\\",\\"icon_bg_feature\\":\\"#4d7de1\\",\\"link_options\\":\\"regular\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"93x8063\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"checkbox_c_m_apply_all\\":\\"1\\",\\"c_b-type\\":\\"top\\",\\"title_feature\\":\\"Location Tracking\\",\\"content_feature\\":\\"<p>Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi<\\\\/p>\\",\\"layout_feature\\":\\"icon-left\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_color_feature\\":\\"#de5d5d\\",\\"circle_size_feature\\":\\"custom\\",\\"custom_circle_size_feature\\":\\"70\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"ti-location-arrow\\",\\"icon_color_feature\\":\\"#ffffff\\",\\"icon_bg_feature\\":\\"#4d7de1\\",\\"link_options\\":\\"regular\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"31e4dfe\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"right\\",\\"link_color\\":\\"#4d7de1\\",\\"padding_top\\":\\"20\\",\\"margin_top\\":\\"6\\",\\"border-type\\":\\"top\\",\\"border_top_color\\":\\"#f0f0f0\\",\\"border_top_width\\":\\"1\\",\\"font_color_icon\\":\\"#ffffff\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"circle\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-angle-right\\",\\"icon_color_bg\\":\\"blue\\",\\"label\\":\\"See All Features\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"9\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"fa7752a\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"f2450ac\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"6ec320c\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"4b63969\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\"},{\\"element_id\\":\\"116b2c9\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"4dc87be\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"40\\",\\"border-type\\":\\"top\\",\\"icon_size\\":\\"xlarge\\",\\"icon_style\\":\\"circle\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-quote-left\\",\\"icon_color_bg\\":\\"blue\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]},{\\"element_id\\":\\"f1e31bb\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\"}]},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"141e70c\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"2.2\\",\\"font_size_unit\\":\\"em\\",\\"line_height\\":\\"1.2\\",\\"line_height_unit\\":\\"em\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_weight_h3\\":\\"100\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>This App helped us optimize our marketplace<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"12\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"row_anchor\\":\\"testimonial\\",\\"custom_css_id\\":\\"testimonial\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"8d8e554\\",\\"row_order\\":\\"3\\",\\"cols\\":[{\\"element_id\\":\\"c6c0b5a\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"fvjc030\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Deep Inside App<\\\\/h3>\\\\n<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]},{\\"element_id\\":\\"f0d973a\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"041f24b\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2018\\\\/10\\\\/dashboard-users-1-550x404.png\\",\\"width_image\\":\\"550\\",\\"height_image\\":\\"404\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"custom_parallax_scroll_reverse\\":\\"reverse\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_check\\":\\"unstick_when_check\\",\\"unstick_when_element\\":\\"row\\",\\"unstick_when_el_row_id\\":\\"8d8e554\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"2\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"3e9bffa\\",\\"row_order\\":\\"4\\",\\"cols\\":[{\\"element_id\\":\\"fe14843\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"70c7150\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2018\\\\/10\\\\/files-400x404.png\\",\\"width_image\\":\\"400\\",\\"height_image\\":\\"404\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"custom_parallax_scroll_reverse\\":\\"reverse\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]},{\\"element_id\\":\\"55c31fc\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"1bku530\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Research Prove Successful Marketing Sales<\\\\/h3>\\\\n<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"9\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"9\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"custom_css_id\\":\\"increase\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"me4b600\\",\\"row_order\\":\\"5\\",\\"cols\\":[{\\"element_id\\":\\"eucn050\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"7331130\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2018\\\\/10\\\\/macbook-550x332.png\\",\\"width_image\\":\\"550\\",\\"height_image\\":\\"332\\",\\"param_image\\":\\"regular\\",\\"stick_at_check\\":\\"stick_at_check\\",\\"stick_at_position\\":\\"top\\",\\"stick_at_pos_val\\":\\"100\\",\\"unstick_when_check\\":\\"unstick_when_check\\",\\"unstick_when_element\\":\\"row\\",\\"unstick_when_el_row_id\\":\\"082dc5c\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]},{\\"element_id\\":\\"lcw3603\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"odsx606\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Built For Marketing<\\\\/h3>\\\\n<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"51945dd\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2018\\\\/10\\\\/echo-solution.png\\",\\"width_image\\":\\"70\\",\\"title_image\\":\\"Echo Marketing\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. \\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"4qpq033\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2018\\\\/10\\\\/sunlab-technology.png\\",\\"width_image\\":\\"70\\",\\"title_image\\":\\"SunLab\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. \\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"margin_bottom\\":\\"30\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"1f77000\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2018\\\\/10\\\\/red.png\\",\\"width_image\\":\\"70\\",\\"title_image\\":\\"Red Square\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. \\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"margin_bottom\\":\\"30\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"l67m603\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2018\\\\/11\\\\/firstrate.jpg\\",\\"width_image\\":\\"70\\",\\"title_image\\":\\"First Rate\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. \\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"margin_bottom\\":\\"30\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"ul63330\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"right\\",\\"link_color\\":\\"#4d7de1\\",\\"padding_top\\":\\"20\\",\\"margin_top\\":\\"6\\",\\"border-type\\":\\"top\\",\\"border_top_color\\":\\"#f0f0f0\\",\\"border_top_width\\":\\"1\\",\\"font_color_icon\\":\\"#ffffff\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"circle\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-angle-right\\",\\"icon_color_bg\\":\\"blue\\",\\"label\\":\\"Read More\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"gutter\\":\\"gutter-narrow\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"9\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"9\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"custom_css_id\\":\\"commpability\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"082dc5c\\",\\"row_order\\":\\"6\\",\\"cols\\":[{\\"element_id\\":\\"39c861b\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"iahk005\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Start Now<\\\\/h3>\\\\n<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]},{\\"element_id\\":\\"f82799e\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"element_id\\":\\"42de2c9\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"66f0124\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"407385e\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2018\\\\/10\\\\/bar.png\\",\\"width_image\\":\\"100\\",\\"height_image\\":\\"100\\",\\"title_image\\":\\"Basic Tracking\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"ajnf005\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\",\\"buttons_size\\":\\"normal\\",\\"buttons_shape\\":\\"circle\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Go Basic\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"blue\\",\\"icon_alignment\\":\\"left\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#c2f0ff\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"3\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"1\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"3\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"6a1fa79\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"331x600\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2018\\\\/10\\\\/bar2.png\\",\\"width_image\\":\\"100\\",\\"height_image\\":\\"100\\",\\"title_image\\":\\"Pro Tracking\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Et harum quidem rerum facilis est et expedita distinctio.eligendi optio cumque nihil\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"gilm108\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\",\\"buttons_size\\":\\"normal\\",\\"buttons_shape\\":\\"circle\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Go Pro!\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"red\\",\\"icon_alignment\\":\\"left\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#fff5ba\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"3\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"1\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"3\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}]}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"9\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"9\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"custom_css_id\\":\\"comparison\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"658acd8\\",\\"unstick_when_el_mod_id\\":\\"975e049\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"48873a6\\",\\"row_order\\":\\"7\\",\\"cols\\":[{\\"element_id\\":\\"54831ca\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6916,
  'post_date' => '2018-02-28 18:43:18',
  'post_date_gmt' => '2018-02-28 18:43:18',
  'post_content' => '<!--themify_builder_static--><h1>Product Branding &amp; marketing</h1> 
 <a href="https://themify.me/" > TELL ME MORE</a> 
 
 
 
 <h3>Inventions</h3> <p>Temporibus autem quibusdam et aut officiis debitis aut rerum necess saepe eveniet ut.</p> 
 
 
 
 
 <h3>Patents</h3> <p>Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis.</p> 
 
 
 
 
 <h3>Phenomenal</h3> <p>At vero eos et accusamus et iusto odio dignist simos ducimus qui blanditiis praesentium.</p> 
 
<h2>Research<br/></h2>
 <h3>We always believe in research. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod.</h3> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2017/02/research-1.jpg" alt="" /> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2016/06/logo-1.png" alt="" /> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2016/06/logo-2.png" alt="" /> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2016/06/logo-3.png" alt="" /> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2016/06/logo-4.png" alt="" /> 
 <img src="https://themify.me/demo/themes/builder-layouts/files/2016/06/logo-5.png" alt="" /> 
 <h2>Plan</h2> 
 <h2>Execute</h2> 
 <h2>Launch</h2> 
<h2>Thinking out of the box<br/></h2>
 <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip</p> 
 <a href="https://themify.me/" > JOIN US</a><!--/themify_builder_static-->',
  'post_title' => 'Top Widgets',
  'post_excerpt' => '',
  'post_name' => 'top-widgets',
  'post_modified' => '2018-07-17 16:55:01',
  'post_modified_gmt' => '2018-07-17 16:55:01',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=6916',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'color_design' => 'theme-color-turquoise',
    'header_design' => 'header-top-widgets',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>Product Branding &amp; marketing<\\\\/h1>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"bounceIn\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"j65m620\\"},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_repeat\\":\\"repeat\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"outline\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"TELL ME MORE\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"black\\",\\"icon\\":\\"fa-arrow-circle-right\\",\\"icon_alignment\\":\\"left\\"}],\\"animation_effect\\":\\"bounceIn\\"},\\"element_id\\":\\"l1rk670\\"}],\\"element_id\\":\\"rhog170\\"}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/06\\\\/header.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_position\\":\\"center-bottom\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"15\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"ykrq033\\"},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"checkbox_c_m_apply_all\\":\\"1\\",\\"checkbox_c_b_apply_all\\":\\"1\\",\\"title_feature\\":\\"Inventions\\",\\"content_feature\\":\\"<p>Temporibus autem quibusdam et aut officiis debitis aut rerum necess saepe eveniet ut.<\\\\/p>\\",\\"layout_feature\\":\\"icon-left\\",\\"circle_color_feature\\":\\"#de5d5d\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-cogs\\",\\"icon_color_feature\\":\\"525252\\",\\"link_options\\":\\"regular\\",\\"animation_effect\\":\\"slideInLeft\\"},\\"element_id\\":\\"ontl000\\"}],\\"element_id\\":\\"m037203\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"title_feature\\":\\"Patents\\",\\"content_feature\\":\\"<p>Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis.<\\\\/p>\\",\\"layout_feature\\":\\"icon-left\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-file-text-o\\",\\"icon_color_feature\\":\\"525252\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeInUp\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"circle_percentage_feature\\":\\"0\\",\\"circle_color_feature\\":\\"#de5d5d\\",\\"link_options\\":\\"\\"},\\"element_id\\":\\"ydqi723\\"}],\\"element_id\\":\\"9dmk213\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"title_feature\\":\\"Phenomenal\\",\\"content_feature\\":\\"<p>At vero eos et accusamus et iusto odio dignist simos ducimus qui blanditiis praesentium.<\\\\/p>\\",\\"layout_feature\\":\\"icon-left\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-lightbulb-o\\",\\"icon_color_feature\\":\\"525252\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"slideInRight\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"circle_percentage_feature\\":\\"0\\",\\"circle_color_feature\\":\\"#de5d5d\\",\\"link_options\\":\\"\\"},\\"element_id\\":\\"6gku025\\"}],\\"element_id\\":\\"wp07770\\"}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"background_color\\":\\"f5f5f5_1.00\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"8f4n330\\"},{\\"row_order\\":\\"2\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-1\\",\\"element_id\\":\\"ffej838\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"mod_settings\\":{\\"heading\\":\\"Research\\",\\"heading_tag\\":\\"h2\\",\\"text_alignment\\":\\"themify-text-center\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeInRight\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"knvg023\\"},{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>We always believe in research. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod.<\\\\/h3>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"text_align\\":\\"left\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeInRight\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"053b302\\"}],\\"element_id\\":\\"4jc3708\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col4-1\\",\\"element_id\\":\\"nl01780\\"}],\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"tablet-full\\",\\"element_id\\":\\"edel003\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"4\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"kcjb273\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2017\\\\/02\\\\/research-1.jpg\\",\\"auto_fullwidth\\":\\"1\\",\\"param_image\\":\\"regular\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"z7ra872\\"}],\\"element_id\\":\\"hoda287\\"}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"1460006\\"},{\\"row_order\\":\\"3\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/06\\\\/logo-1.png\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"u2oh320\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"1ja3027\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/06\\\\/logo-2.png\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"ccau933\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"rhmx303\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/06\\\\/logo-3.png\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"a5d7803\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"drad729\\"},{\\"column_order\\":\\"3\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/06\\\\/logo-4.png\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"gyxz020\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"nt9q332\\"},{\\"column_order\\":\\"4\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/06\\\\/logo-5.png\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"s1pr073\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"xlhq473\\"}],\\"element_id\\":\\"hcfh993\\"}],\\"element_id\\":\\"8kyi899\\"}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"background_color\\":\\"f5f5f5_1.00\\",\\"padding_top\\":\\"2\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"2\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"xw6u087\\"},{\\"row_order\\":\\"4\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Plan<\\\\/h2>\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"20\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"20\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"5\\",\\"margin_top_unit\\":\\"%\\",\\"margin_right\\":\\"5\\",\\"margin_right_unit\\":\\"%\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"margin_left\\":\\"5\\",\\"margin_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_color\\":\\"ffffff_1.00\\",\\"border_top_width\\":\\"2\\",\\"border_right_color\\":\\"ffffff_1.00\\",\\"border_right_width\\":\\"2\\",\\"border_bottom_color\\":\\"ffffff_1.00\\",\\"border_bottom_width\\":\\"2\\",\\"border_left_color\\":\\"ffffff_1.00\\",\\"border_left_width\\":\\"2\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"xdlv063\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/06\\\\/plan.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"cover_color\\":\\"000000_0.21\\",\\"cover_color_hover\\":\\"000000_0.48\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"y3ea450\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Execute<\\\\/h2>\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"20\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"20\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"5\\",\\"margin_top_unit\\":\\"%\\",\\"margin_right\\":\\"5\\",\\"margin_right_unit\\":\\"%\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"margin_left\\":\\"5\\",\\"margin_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_color\\":\\"ffffff_1.00\\",\\"border_top_width\\":\\"2\\",\\"border_right_color\\":\\"ffffff_1.00\\",\\"border_right_width\\":\\"2\\",\\"border_bottom_color\\":\\"ffffff_1.00\\",\\"border_bottom_width\\":\\"2\\",\\"border_left_color\\":\\"ffffff_1.00\\",\\"border_left_width\\":\\"2\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"kpip072\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/06\\\\/execute.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_position\\":\\"center-center\\",\\"cover_color\\":\\"000000_0.26\\",\\"cover_color_hover\\":\\"000000_0.48\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"y0vo304\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Launch<\\\\/h2>\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"20\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"20\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"5\\",\\"margin_top_unit\\":\\"%\\",\\"margin_right\\":\\"5\\",\\"margin_right_unit\\":\\"%\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"margin_left\\":\\"5\\",\\"margin_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_color\\":\\"ffffff_1.00\\",\\"border_top_width\\":\\"2\\",\\"border_right_color\\":\\"ffffff_1.00\\",\\"border_right_width\\":\\"2\\",\\"border_bottom_color\\":\\"ffffff_1.00\\",\\"border_bottom_width\\":\\"2\\",\\"border_left_color\\":\\"ffffff_1.00\\",\\"border_left_width\\":\\"2\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"1zo3403\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2017\\\\/02\\\\/launch-1.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_position\\":\\"center-center\\",\\"cover_color\\":\\"000000_0.15\\",\\"cover_color_hover\\":\\"000000_0.48\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"4mji777\\"}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"font_color\\":\\"ffffff_1.00\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"padding_top\\":\\"0\\",\\"padding_right\\":\\"0\\",\\"padding_bottom\\":\\"0\\",\\"padding_left\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"0\\",\\"margin_right\\":\\"0\\",\\"margin_bottom\\":\\"0\\",\\"margin_left\\":\\"0\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},\\"element_id\\":\\"y7kb474\\"},{\\"row_order\\":\\"5\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"mod_settings\\":{\\"heading\\":\\"Thinking out of the box\\",\\"heading_tag\\":\\"h2\\",\\"text_alignment\\":\\"themify-text-center\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"0i7t424\\"},{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip<\\\\/p>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"bounceIn\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"gzjk113\\"},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"outline\\",\\"content_button\\":[{\\"label\\":\\"JOIN US\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon\\":\\"fa-sign-in\\"}],\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_link_padding_apply_all\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"bounceIn\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"3fhu211\\"}],\\"element_id\\":\\"dfrm333\\"}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/06\\\\/pexels-photo-69040.png\\",\\"background_repeat\\":\\"builder-parallax-scrolling\\",\\"cover_color\\":\\"595959_0.85\\",\\"cover_color_hover\\":\\"545454_0.93\\",\\"font_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"element_id\\":\\"xq6a443\\"},{\\"row_order\\":\\"6\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"uc2n009\\"}],\\"element_id\\":\\"h2y4022\\"}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3983,
  'post_date' => '2015-05-08 22:58:34',
  'post_date_gmt' => '2015-05-08 22:58:34',
  'post_content' => '<!--themify_builder_static--><h1 style="text-align: center;">Red Agency</h1> <h3 style="text-align: center;">We focus on UX, Design, and Apps </h3> <p style="text-align: center;"> </p>
 
 <a href="#connect" > Contact Us </a> 
 <h2 style="text-align: center;">Demo Reel </h2>
 
 <iframe src="https://player.vimeo.com/video/71934862" width="1165" height="655" title="Anne lessmeister - business card production" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe> 
 
 <h2 style="text-align: center;">Services</h2>
 
 
 
 
 <h3> Writing </h3> <p>The Landing Theme is great as it comes pre-built with multiple layouts that can be loaded on any page using the <a href="https://themify.me/builder">Builder</a>. Check out this tutorial to see how the <a href="https://themify.me/docs/builder#builder-layout">Builder layouts </a>work.</p> 
 
 
 
 
 
 <h3> Apps </h3> <p>The theme is also built with various header styles. You have the option to make it transparent, hide, or place it on the left. There are also other styles that customizes the placement of your logo.</p> 
 
 
 
 
 
 <h3> Games </h3> <p>We&#8217;ve packed this theme with multiple extendable Addons. All of which, comes built into the theme allowing you have the most flexibility when managing your content!</p> 
 
 
 <h3 style="text-align: center;"><em>Landing pages is a great way for you to attract more business for your brand, or to connect with your community.</em></h3>
 <p style="text-align: center;">A blogger from <a href="http://www.inboundnow.com/">Inbound Now</a> wrote a very interesting article called &#8220;<a href="http://www.inboundnow.com/7-killer-ways-landing-pages-benefit-market-your-business/">7 Killer Ways Landing Pages Benefit &#038; Market your Business</a>&#8220;. It outlines various ways on how you can benefit from creating landing pages for your business.</p> <h3 style="text-align: center;">Get a theme that&#8217;ll enhance, market, and grow your business now!</h3>
 
 <a href="https://themify.me/themes/landing" > Buy Now </a> <a href="https://themify.me/docs/landing-documentation" > Documentation </a> 
 <h3><em> Create a testimonial section on your landing page. Simply insert an icon and an image on the row to copy the same look as this layout.</em></h3><p style="text-align: right;"> &#8211; <strong>John Purdue</strong>, <em>Themify Team</em></p>
 
 <img src="https://themify.me/demo/themes/landing/files/2015/02/157472372.jpg" width="400" height="400" alt="" /> 
 <h2 style="text-align: center;">Connect with us</h2>
 
 <a href="https://themify.me/contact" > 
 
 </a> 
 
 
 
 <a href="https://www.facebook.com/themify" > 
 
 </a> 
 
 
 
 <a href="https://www.twitter.com/themify" > 
 
 </a> 
 
 
 
 <a href="https://plus.google.com/u/0/b/109280316400365629341/109280316400365629341" > 
 
 </a><!--/themify_builder_static-->',
  'post_title' => 'Transparent',
  'post_excerpt' => '',
  'post_name' => 'transparent',
  'post_modified' => '2018-01-18 16:57:16',
  'post_modified_gmt' => '2018-01-18 16:57:16',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=3983',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'color_design' => 'theme-color-red',
    'header_design' => 'header-horizontal',
    'header_wrap' => 'transparent',
    'background_image' => 'https://themify.me/demo/themes/ultra/files/2015/04/Top_view.jpg',
    'footer_design' => 'none',
    'more_posts' => 'pagination',
    'posts_per_page' => '2',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h1 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Red Agency<\\\\/h1>\\\\n<h3 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">We focus on UX, Design, and Apps <\\\\/h3>\\\\n<p style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\"> <\\\\/p>\\"},\\"element_id\\":\\"qbso020\\"},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"text_align\\":\\"center\\",\\"font_weight\\":\\"bold\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"xlarge\\",\\"buttons_style\\":\\"circle\\",\\"content_button\\":[{\\"label\\":\\"Contact Us\\",\\"link\\":\\"#connect\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"red\\"}]},\\"element_id\\":\\"pupp100\\"}],\\"element_id\\":\\"n8hj417\\"}],\\"styling\\":{\\"row_height\\":\\"fullheight\\",\\"background_type\\":\\"image\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/02\\\\/54497056-b1-1024x685.jpg\\",\\"background_repeat\\":\\"builder-parallax-scrolling\\",\\"background_color\\":\\"b82c2c\\",\\"font_color\\":\\"ffffff_1.00\\",\\"link_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"jstr662\\"},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Demo Reel <\\\\/h2>\\",\\"font_color\\":\\"f03030\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\"},\\"element_id\\":\\"sgdg403\\"},{\\"mod_name\\":\\"video\\",\\"mod_settings\\":{\\"style_video\\":\\"video-top\\",\\"url_video\\":\\"http:\\\\/\\\\/vimeo.com\\\\/71934862\\",\\"text_align\\":\\"center\\",\\"margin_right\\":\\"10\\",\\"margin_right_unit\\":\\"%\\",\\"margin_left\\":\\"10\\",\\"margin_left_unit\\":\\"%\\"},\\"element_id\\":\\"27t2422\\"}],\\"element_id\\":\\"5lic044\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_color\\":\\"000000_1.00\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"qb78374\\"},{\\"row_order\\":\\"2\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Services<\\\\/h2>\\"},\\"element_id\\":\\"qvwy330\\"},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"title_feature\\":\\"Writing\\",\\"content_feature\\":\\"<p>The Landing Theme is great as it comes pre-built with multiple layouts that can be loaded on any page using the <a href=\\\\\\\\\\\\\\"https:\\\\/\\\\/themify.me\\\\/builder\\\\\\\\\\\\\\">Builder<\\\\/a>. Check out this tutorial to see how the <a href=\\\\\\\\\\\\\\"https:\\\\/\\\\/themify.me\\\\/docs\\\\/builder#builder-layout\\\\\\\\\\\\\\">Builder layouts <\\\\/a>work.<\\\\/p>\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"000000_1.00\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-newspaper-o\\",\\"icon_color_feature\\":\\"f03030\\"},\\"element_id\\":\\"1lxq230\\"}],\\"element_id\\":\\"s63u207\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"title_feature\\":\\"Apps\\",\\"content_feature\\":\\"<p>The theme is also built with various header styles. You have the option to make it transparent, hide, or place it on the left. There are also other styles that customizes the placement of your logo.<\\\\/p>\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"000000_1.00\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-flask\\",\\"icon_color_feature\\":\\"f03030\\"},\\"element_id\\":\\"ds41033\\"}],\\"element_id\\":\\"hui0344\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"title_feature\\":\\"Games\\",\\"content_feature\\":\\"<p>We\\\\\\\\\\\'ve packed this theme with multiple extendable Addons. All of which, comes built into the theme allowing you have the most flexibility when managing your content!<\\\\/p>\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"000000_1.00\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-gamepad\\",\\"icon_color_feature\\":\\"f03030\\"},\\"element_id\\":\\"qfno204\\"}],\\"element_id\\":\\"8pjj273\\"}],\\"element_id\\":\\"7f6y233\\"}],\\"element_id\\":\\"avhw070\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"builder-parallax-scrolling\\",\\"background_color\\":\\"fafafa_1.00\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"2\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"xdrm203\\"},{\\"row_order\\":\\"3\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-1\\",\\"element_id\\":\\"dlad307\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"divider\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"3\\",\\"color_divider\\":\\"000000_1.00\\",\\"top_margin_divider\\":\\"30\\",\\"bottom_margin_divider\\":\\"50\\"},\\"element_id\\":\\"f4ga004\\"},{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\"><em>Landing pages is a great way for you to attract more business for your brand, or to connect with your community.<\\\\/em><\\\\/h3>\\",\\"font_color\\":\\"f03030\\"},\\"element_id\\":\\"3mwh477\\"},{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<p style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">A blogger from <a href=\\\\\\\\\\\\\\"http:\\\\/\\\\/www.inboundnow.com\\\\/\\\\\\\\\\\\\\">Inbound Now<\\\\/a> wrote a very interesting article called \\\\\\\\\\\\\\"<a href=\\\\\\\\\\\\\\"http:\\\\/\\\\/www.inboundnow.com\\\\/7-killer-ways-landing-pages-benefit-market-your-business\\\\/\\\\\\\\\\\\\\">7 Killer Ways Landing Pages Benefit &amp; Market your Business<\\\\/a>\\\\\\\\\\\\\\". It outlines various ways on how you can benefit from creating landing pages for your business.<\\\\/p>\\\\n<h3 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Get a theme that\\\\\\\\\\\'ll enhance, market, and grow your business now!<\\\\/h3>\\"},\\"element_id\\":\\"wukt302\\"},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"text_align\\":\\"center\\",\\"font_weight\\":\\"bold\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"20\\",\\"margin_bottom\\":\\"20\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"large\\",\\"buttons_style\\":\\"squared\\",\\"content_button\\":[{\\"label\\":\\"Buy Now\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/themes\\\\/landing\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"red\\"},{\\"label\\":\\"Documentation\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/docs\\\\/landing-documentation\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"red\\"}]},\\"element_id\\":\\"y1oe032\\"}],\\"element_id\\":\\"ecux020\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col4-1\\",\\"element_id\\":\\"52as070\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"builder-parallax-scrolling\\",\\"background_color\\":\\"fafafa_1.00\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"c986744\\"},{\\"row_order\\":\\"4\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3><em>[themify_icon icon=\\\\\\\\\\\\\\"fa-quote-left\\\\\\\\\\\\\\" style=\\\\\\\\\\\\\\"large\\\\\\\\\\\\\\" icon_color=\\\\\\\\\\\\\\"#f03030\\\\\\\\\\\\\\" ] Create a testimonial section on your landing page. Simply insert an icon and an image on the row to copy the same look as this layout.<\\\\/em><\\\\/h3><p style=\\\\\\\\\\\\\\"text-align: right;\\\\\\\\\\\\\\"> - <strong>John Purdue<\\\\/strong>, <em>Themify Team<\\\\/em><\\\\/p>\\"},\\"element_id\\":\\"v5oi243\\"}],\\"element_id\\":\\"cazw424\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/landing\\\\/files\\\\/2015\\\\/02\\\\/157472372.jpg\\",\\"appearance_image\\":\\"rounded|circle\\",\\"width_image\\":\\"400\\",\\"height_image\\":\\"400\\"},\\"element_id\\":\\"aux5527\\"}],\\"element_id\\":\\"jka8346\\"}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_color\\":\\"000000_1.00\\",\\"font_color\\":\\"ffffff_1.00\\",\\"link_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\"},\\"element_id\\":\\"e24s577\\"},{\\"row_order\\":\\"5\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2 style=\\\\\\\\\\\\\\"text-align: center;\\\\\\\\\\\\\\">Connect with us<\\\\/h2>\\"},\\"element_id\\":\\"21gp662\\"},{\\"row_order\\":\\"1\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"layout_feature\\":\\"icon-top\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-envelope\\",\\"icon_color_feature\\":\\"ffffff_1.00\\",\\"icon_bg_feature\\":\\"f03030\\",\\"link_feature\\":\\"https:\\\\/\\\\/themify.me\\\\/contact\\",\\"param_feature\\":\\"newtab\\",\\"circle_color_feature\\":\\"#de5d5d\\",\\"circle_stroke_feature\\":\\"3\\"},\\"element_id\\":\\"bede020\\"}],\\"element_id\\":\\"h5c2020\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"layout_feature\\":\\"icon-top\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-facebook\\",\\"icon_color_feature\\":\\"ffffff_1.00\\",\\"icon_bg_feature\\":\\"f03030\\",\\"link_feature\\":\\"https:\\\\/\\\\/www.facebook.com\\\\/themify\\",\\"param_feature\\":\\"newtab\\",\\"margin_bottom\\":\\"40\\",\\"circle_color_feature\\":\\"#de5d5d\\",\\"circle_stroke_feature\\":\\"3\\"},\\"element_id\\":\\"ff9t340\\"}],\\"element_id\\":\\"bygr024\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"layout_feature\\":\\"icon-top\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-twitter\\",\\"icon_color_feature\\":\\"ffffff_1.00\\",\\"icon_bg_feature\\":\\"f03030\\",\\"link_feature\\":\\"https:\\\\/\\\\/www.twitter.com\\\\/themify\\",\\"param_feature\\":\\"newtab\\",\\"margin_bottom\\":\\"40\\",\\"circle_color_feature\\":\\"#de5d5d\\",\\"circle_stroke_feature\\":\\"3\\"},\\"element_id\\":\\"r89f014\\"}],\\"element_id\\":\\"7s0o340\\"},{\\"column_order\\":\\"3\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"layout_feature\\":\\"icon-top\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-google-plus\\",\\"icon_color_feature\\":\\"ffffff_1.00\\",\\"icon_bg_feature\\":\\"f03030\\",\\"link_feature\\":\\"https:\\\\/\\\\/plus.google.com\\\\/u\\\\/0\\\\/b\\\\/109280316400365629341\\\\/109280316400365629341\\",\\"param_feature\\":\\"newtab\\",\\"margin_bottom\\":\\"40\\",\\"circle_color_feature\\":\\"#de5d5d\\",\\"circle_stroke_feature\\":\\"3\\"},\\"element_id\\":\\"7rsu030\\"}],\\"element_id\\":\\"dwwq272\\"}],\\"element_id\\":\\"m04t672\\"}],\\"element_id\\":\\"72dm730\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"row_anchor\\":\\"connect\\"},\\"element_id\\":\\"zy0y299\\"},{\\"row_order\\":\\"6\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"83ou727\\"}],\\"element_id\\":\\"bcv4667\\"}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 7033,
  'post_date' => '2018-04-10 19:38:23',
  'post_date_gmt' => '2018-04-10 19:38:23',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<p></p><!--themify_builder_static--><h1>Fullpane Theme</h1> 
 <h4>by Themify</h4> 
 <a href="https://themify.me/demo/themes/fullpane/home/demo-2/" >Features</a> <a href="https://themify.me/themes/fullpane" >Learn More</a> 
 <h1>Horizontal Scrolling</h1> 
 <h4>Can scroll vertical &amp; horizontal.</h4> 
 <h1>Hand Crafted</h1> 
 <h4>With love.</h4> 
 <h1>Drag &amp; Drop Builder</h1> 
 <h4>The possibility is limitless with Themify Builder.</h4> 
 <h1>Features</h1> 
 <h4>Gallery, Portfolio, Testimonial, Team, Testimonial, and more.</h4> 
 <a href="https://themify.me/demo/themes/fullpane/demo-2" >View Features Page</a> 
 <h1>Explore More</h1> 
 <a href="https://themify.me/demo/themes/fullpane/home/demo-2/" >DEMO 2</a> <a href="https://themify.me/demo/themes/fullpane/home/demo-3/" >DEMO 3</a><!--/themify_builder_static-->',
  'post_title' => 'Vertical Section Scrolling',
  'post_excerpt' => '',
  'post_name' => 'vertical-section-scrolling',
  'post_modified' => '2019-03-22 00:45:59',
  'post_modified_gmt' => '2019-03-22 00:45:59',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=7033',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'section_full_scrolling' => 'yes',
    'section_scrolling_mobile' => 'on',
    'header_design' => 'header-minbar',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"e636ad1\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"f7ee3ae\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"1724043\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h1>Fullpane Theme<\\\\/h1>\\",\\"animation_effect\\":\\"fadeInLeft\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"0d52dfa\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h4>by Themify<\\\\/h4>\\",\\"animation_effect\\":\\"fadeInRight\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"9f114a7\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"20\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"outline\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Features\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/fullpane\\\\/home\\\\/demo-2\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"},{\\"label\\":\\"Learn More\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/themes\\\\/fullpane\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"}],\\"animation_effect\\":\\"fadeInUp\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/fullpane\\\\/files\\\\/2018\\\\/06\\\\/demoimage17-1024x651.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"#ffffff\\",\\"text_align\\":\\"center\\",\\"link_color\\":\\"#a6fff2\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\"}},{\\"element_id\\":\\"07e7192\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"fa5a9ca\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"444e984\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h1>Horizontal Scrolling<\\\\/h1>\\",\\"animation_effect\\":\\"fadeInLeft\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"6ffb44b\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h4>Can scroll vertical &amp; horizontal.<\\\\/h4>\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/fullpane\\\\/files\\\\/2018\\\\/06\\\\/demoimage30-1024x683.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#ffffff\\",\\"text_align\\":\\"center\\",\\"link_color\\":\\"#a6fff2\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"e636ad1\\",\\"unstick_when_el_mod_id\\":\\"1724043\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"edd554a\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"e4f51a9\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"5020da3\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h1>Hand Crafted<\\\\/h1>\\",\\"animation_effect\\":\\"fadeInLeft\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ff44c54\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h4>With love.<\\\\/h4>\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/fullpane\\\\/files\\\\/2018\\\\/06\\\\/demoimage36-1024x683.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#ffffff\\",\\"text_align\\":\\"center\\",\\"link_color\\":\\"#a6fff2\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"e636ad1\\",\\"unstick_when_el_mod_id\\":\\"1724043\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"18bc866\\",\\"row_order\\":\\"3\\",\\"cols\\":[{\\"element_id\\":\\"c232d5d\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"9c298b4\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h1>Drag &amp; Drop Builder<\\\\/h1>\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"27a7159\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h4>The possibility is limitless with Themify Builder.<\\\\/h4>\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/fullpane\\\\/files\\\\/2018\\\\/06\\\\/demoimage42.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#ffffff\\",\\"text_align\\":\\"center\\",\\"link_color\\":\\"#a6fff2\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"e636ad1\\",\\"unstick_when_el_mod_id\\":\\"1724043\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"aa93c90\\",\\"row_order\\":\\"4\\",\\"cols\\":[{\\"element_id\\":\\"352b534\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"2bd3a23\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_repeat\\":\\"repeat\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h1>Features<\\\\/h1>\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"b90be06\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h4>Gallery, Portfolio, Testimonial, Team, Testimonial, and more.<\\\\/h4>\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"0c3b3ef\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"20\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"outline\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"View Features Page\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/fullpane\\\\/demo-2\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"}]}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/fullpane\\\\/files\\\\/2018\\\\/06\\\\/demoimage66.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"756f68\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"e8e8e8\\",\\"text_align\\":\\"center\\",\\"link_color\\":\\"f49ac1\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\"}},{\\"element_id\\":\\"d4b8888\\",\\"row_order\\":\\"5\\",\\"cols\\":[{\\"element_id\\":\\"9bf17eb\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"4f974f8\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h1>Explore More<\\\\/h1>\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"43bcdfa\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"outline\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"DEMO 2\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/fullpane\\\\/home\\\\/demo-2\\\\/\\",\\"link_options\\":\\"regular\\"},{\\"label\\":\\"DEMO 3\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/fullpane\\\\/home\\\\/demo-3\\\\/\\",\\"link_options\\":\\"regular\\"}]}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/fullpane\\\\/files\\\\/2018\\\\/06\\\\/demoimage59.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#ffffff\\",\\"text_align\\":\\"center\\",\\"link_color\\":\\"#a6fff2\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"e636ad1\\",\\"unstick_when_el_mod_id\\":\\"1724043\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"bb5e792\\",\\"row_order\\":\\"6\\",\\"cols\\":[{\\"element_id\\":\\"8cb837d\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 5916,
  'post_date' => '2016-10-05 18:33:19',
  'post_date_gmt' => '2016-10-05 18:33:19',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h2>Our Story</h2> <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatu</p> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/our-story.jpg" width="672" height="446" alt="" /> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/awards.jpg" width="670" height="447" alt="" /> 
 <h2>Awards</h2> <p>Doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatu Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium.</p> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/mike-angel.jpg" width="560" height="570" title="Mike Angel" alt="Guitarist" /> <h3> Mike Angel </h3> Guitarist 
 <a href="https://www.facebook.com/themify"> </a> <a href="https://www.twitter.com/themify"> </a> <a href="https://www.instagram.com/themify/"> </a> <a href="https://www.youtube.com/user/themifyme"> </a> 
 <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.  Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/alex-sams.jpg" width="560" height="468" title="Alex Sams" alt="Pianist" /> <h3> Alex Sams </h3> Pianist 
 <a href="https://www.facebook.com/themify"> </a> <a href="https://www.twitter.com/themify"> </a> <a href="https://www.instagram.com/themify/"> </a> <a href="https://www.youtube.com/user/themifyme"> </a> 
 <p>Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.  Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. </p> 
 <h2>Artists</h2> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/mabelle-howell-big.jpg" width="500" height="570" title="Mabelle Howell" alt="Lead Vocals" /> <h3> Mabelle Howell </h3> Lead Vocals 
 <a href="https://www.facebook.com/themify"> </a> <a href="https://www.twitter.com/themify"> </a> <a href="https://www.instagram.com/themify/"> </a> <a href="https://www.youtube.com/user/themifyme"> </a> 
 <p>Velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.  Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate.</p> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/miguel.jpg" width="500" height="469" title="Michelle Leah" alt="Backing Vocals" /> <h3> Michelle Leah </h3> Backing Vocals 
 <a href="https://www.facebook.com/themify"> </a> <a href="https://www.twitter.com/themify"> </a> <a href="https://www.instagram.com/themify/"> </a> <a href="https://www.youtube.com/user/themifyme"> </a> 
 <p>Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. </p> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/timeline-2008.jpg" width="460" height="310" alt="" /> 
 <h2>2008</h2> <p> Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p> 
 <h2>2010</h2> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/timeline-2010.jpg" width="761" height="480" alt="" /> 
 <p>Nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam.</p> 
 <h2>2011</h2> <p>Incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor.</p> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/timeline-2011.jpg" width="660" height="400" alt="" /> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/timeline-2012.jpg" width="560" height="350" alt="" /> 
 <h2>2012</h2> <p>Dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure.</p> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/timeline-2014.jpg" width="560" height="350" alt="" /> 
 <h2>2014</h2> <p>Reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in.</p> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/timeline-2016.jpg" width="360" height="323" alt="" /> 
 <h2>2016</h2> <p>Laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco.</p> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/timeline-2018.jpg" width="360" height="323" alt="" /> 
 <h2>2018</h2> <p>Velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate.</p> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/timeline-2019.jpg" width="360" height="323" alt="" /> 
 <h2>2019</h2> <p>Nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</p><!--/themify_builder_static-->',
  'post_title' => 'Video',
  'post_excerpt' => '',
  'post_name' => 'video',
  'post_modified' => '2019-03-08 18:50:42',
  'post_modified_gmt' => '2019-03-08 18:50:42',
  'post_content_filtered' => '',
  'post_parent' => 3420,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=5916',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'header_design' => 'header-block',
    'full_height_header' => 'yes',
    'mobile_menu_styles' => 'default',
    'header_wrap' => 'video',
    'background_color' => 'rgba(0, 0, 0, 1)',
    'background_image' => 'https://themify.me/demo/themes/ultra/files/2019/03/guitar.jpg',
    'headerwrap_text_color' => '#ffffff',
    'headerwrap_link_color' => '#ffffff',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"82d1c83\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"a40614c\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"54290d1\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"d695962\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-1\\"},{\\"element_id\\":\\"eaa78ed\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-3\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ac97616\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"5\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>Our Story<\\\\/h2>\\\\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatu<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}]}],\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column-full\\"}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"f847760\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"8d568ca\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-right\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/our-story.jpg\\",\\"width_image\\":\\"672\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"446\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/dot-1-1.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"padding_left\\":\\"3\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"column_alignment\\":\\"col_align_middle\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"},\\"row_width\\":\\"fullwidth-content\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"911c5b7\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"3rjy000\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"ic6w406\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"qvb4646\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/awards.jpg\\",\\"width_image\\":\\"670\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"447\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/dot-6.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"3\\",\\"padding_right_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"bwfu226\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"215c7a7\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"10046ba\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-3\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"mhc6070\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"5\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>Awards<\\\\/h2>\\\\n<p>Doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatu Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}]},{\\"element_id\\":\\"f3bb1c0\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-1\\"}],\\"col_tablet\\":\\"column-full\\"}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"row_width\\":\\"fullwidth-content\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"911c5b7\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"911c5b7\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"71aa916\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"d045c5b\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"border-type\\":\\"top\\",\\"i_t_b-type\\":\\"top\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/mike-angel.jpg\\",\\"width_image\\":\\"560\\",\\"height_image\\":\\"570\\",\\"title_image\\":\\"Mike Angel\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Guitarist\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"ee32038\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_icon\\":\\"#05062a\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"none\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-facebook\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/www.facebook.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\"},{\\"icon\\":\\"ti-twitter-alt\\",\\"link\\":\\"https:\\\\/\\\\/www.twitter.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\",\\"icon_color_bg\\":\\"\\"},{\\"icon\\":\\"ti-instagram\\",\\"link\\":\\"https:\\\\/\\\\/www.instagram.com\\\\/themify\\\\/\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\",\\"icon_color_bg\\":\\"\\"},{\\"icon\\":\\"ti-youtube\\",\\"link\\":\\"https:\\\\/\\\\/www.youtube.com\\\\/user\\\\/themifyme\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\",\\"icon_color_bg\\":\\"\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"864cb92\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"10\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.  Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"q0mc220\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/alex-sams.jpg\\",\\"width_image\\":\\"560\\",\\"height_image\\":\\"468\\",\\"title_image\\":\\"Alex Sams\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Pianist\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"l76g000\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_icon\\":\\"#05062a\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"none\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-facebook\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/www.facebook.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\"},{\\"icon\\":\\"ti-twitter-alt\\",\\"link\\":\\"https:\\\\/\\\\/www.twitter.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\",\\"icon_color_bg\\":\\"\\"},{\\"icon\\":\\"ti-instagram\\",\\"link\\":\\"https:\\\\/\\\\/www.instagram.com\\\\/themify\\\\/\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\",\\"icon_color_bg\\":\\"\\"},{\\"icon\\":\\"ti-youtube\\",\\"link\\":\\"https:\\\\/\\\\/www.youtube.com\\\\/user\\\\/themifyme\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\",\\"icon_color_bg\\":\\"\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"69ri004\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"10\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.  Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. <\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]},{\\"element_id\\":\\"e61ef9d\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"a7c4e9b\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_left\\":\\"30\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"5\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>Artists<\\\\/h2>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"kvsv400\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/mabelle-howell-big.jpg\\",\\"width_image\\":\\"500\\",\\"height_image\\":\\"570\\",\\"title_image\\":\\"Mabelle Howell\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Lead Vocals\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"n1lg407\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_icon\\":\\"#05062a\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"none\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-facebook\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/www.facebook.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\"},{\\"icon\\":\\"ti-twitter-alt\\",\\"link\\":\\"https:\\\\/\\\\/www.twitter.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\",\\"icon_color_bg\\":\\"\\"},{\\"icon\\":\\"ti-instagram\\",\\"link\\":\\"https:\\\\/\\\\/www.instagram.com\\\\/themify\\\\/\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\",\\"icon_color_bg\\":\\"\\"},{\\"icon\\":\\"ti-youtube\\",\\"link\\":\\"https:\\\\/\\\\/www.youtube.com\\\\/user\\\\/themifyme\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\",\\"icon_color_bg\\":\\"\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"quc5727\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"10\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.  Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"o3ny040\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/miguel.jpg\\",\\"width_image\\":\\"500\\",\\"height_image\\":\\"469\\",\\"title_image\\":\\"Michelle Leah\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Backing Vocals\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"9ib8085\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_icon\\":\\"#05062a\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"none\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-facebook\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/www.facebook.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\"},{\\"icon\\":\\"ti-twitter-alt\\",\\"link\\":\\"https:\\\\/\\\\/www.twitter.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\",\\"icon_color_bg\\":\\"\\"},{\\"icon\\":\\"ti-instagram\\",\\"link\\":\\"https:\\\\/\\\\/www.instagram.com\\\\/themify\\\\/\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\",\\"icon_color_bg\\":\\"\\"},{\\"icon\\":\\"ti-youtube\\",\\"link\\":\\"https:\\\\/\\\\/www.youtube.com\\\\/user\\\\/themifyme\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\",\\"icon_color_bg\\":\\"\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"yozv074\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"10\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. <\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/dot-6.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"tablet_dir\\":\\"rtl\\",\\"mobile_dir\\":\\"rtl\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"},\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"e0b1afc\\",\\"row_order\\":\\"3\\",\\"cols\\":[{\\"element_id\\":\\"d3f9488\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"37dcd82\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/timeline-2008.jpg\\",\\"width_image\\":\\"460\\",\\"height_image\\":\\"310\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]},{\\"element_id\\":\\"3f7006c\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"s6wr470\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>2008<\\\\/h2>\\\\n<p> Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"jy31202\\",\\"row_order\\":\\"4\\",\\"cols\\":[{\\"element_id\\":\\"oto6072\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"w1wu090\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"right\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>2010<\\\\/h2>\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"custom_parallax_scroll_reverse\\":\\"reverse\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"right\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"right\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}]},{\\"element_id\\":\\"0q7f299\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-3\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"gh5c040\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/timeline-2010.jpg\\",\\"width_image\\":\\"761\\",\\"height_image\\":\\"480\\",\\"param_image\\":\\"regular\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"4js5009\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_right\\":\\"15\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"10\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"14022e7\\",\\"row_order\\":\\"5\\",\\"cols\\":[{\\"element_id\\":\\"1fb9022\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"9af4b11\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>2011<\\\\/h2>\\\\n<p>Incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}]},{\\"element_id\\":\\"a7b849f\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"8181728\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/timeline-2011.jpg\\",\\"width_image\\":\\"660\\",\\"height_image\\":\\"400\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"3\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"}}}]}],\\"tablet_dir\\":\\"rtl\\",\\"mobile_dir\\":\\"rtl\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"3f1i570\\",\\"row_order\\":\\"6\\",\\"cols\\":[{\\"element_id\\":\\"sli8004\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"raoi000\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"4\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/timeline-2012.jpg\\",\\"width_image\\":\\"560\\",\\"height_image\\":\\"350\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"rzlq007\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>2012<\\\\/h2>\\\\n<p>Dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}]},{\\"element_id\\":\\"uitv007\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"35o3020\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"4\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/timeline-2014.jpg\\",\\"width_image\\":\\"560\\",\\"height_image\\":\\"350\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"2\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"yvst577\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>2014<\\\\/h2>\\\\n<p>Reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"f3e699f\\",\\"row_order\\":\\"7\\",\\"cols\\":[{\\"element_id\\":\\"6e7db44\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"2oef503\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/timeline-2016.jpg\\",\\"width_image\\":\\"360\\",\\"height_image\\":\\"323\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"7jct520\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>2016<\\\\/h2>\\\\n<p>Laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}]},{\\"element_id\\":\\"a7a9457\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"2ow1012\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/timeline-2018.jpg\\",\\"width_image\\":\\"360\\",\\"height_image\\":\\"323\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"2\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ty5t521\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>2018<\\\\/h2>\\\\n<p>Velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}]},{\\"element_id\\":\\"a78c71a\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"nrgo002\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/timeline-2019.jpg\\",\\"width_image\\":\\"360\\",\\"height_image\\":\\"323\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"3\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"uc66522\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>2019<\\\\/h2>\\\\n<p>Nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}]}],\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"},\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"73eddcf\\",\\"row_order\\":\\"8\\",\\"cols\\":[{\\"element_id\\":\\"b328f04\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3899,
  'post_date' => '2015-05-07 21:04:14',
  'post_date_gmt' => '2015-05-07 21:04:14',
  'post_content' => '',
  'post_title' => 'Blog',
  'post_excerpt' => '',
  'post_name' => 'blog',
  'post_modified' => '2018-06-04 03:26:44',
  'post_modified_gmt' => '2018-06-04 03:26:44',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=3899',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'query_category' => 'blog',
    'more_posts' => 'pagination',
    'posts_per_page' => '5',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"mpu4919\\"}],\\"element_id\\":\\"cz0v221\\"}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 4025,
  'post_date' => '2015-05-09 23:15:15',
  'post_date_gmt' => '2015-05-09 23:15:15',
  'post_content' => '',
  'post_title' => 'Blog - Grid2 Polaroid',
  'post_excerpt' => '',
  'post_name' => 'blog-grid2',
  'post_modified' => '2017-08-21 01:16:35',
  'post_modified_gmt' => '2017-08-21 01:16:35',
  'post_content_filtered' => '',
  'post_parent' => 3899,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=4025',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'query_category' => '0',
    'layout' => 'grid2',
    'post_content_layout' => 'polaroid',
    'disable_masonry' => 'yes',
    'post_gutter' => 'no-gutter',
    'posts_per_page' => '8',
    'display_content' => 'none',
    'image_width' => '560',
    'image_height' => '330',
    'hide_date' => 'yes',
    'hide_meta_all' => 'yes',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 4023,
  'post_date' => '2015-05-09 23:13:26',
  'post_date_gmt' => '2015-05-09 23:13:26',
  'post_content' => '',
  'post_title' => 'Blog - Grid3 Masonry',
  'post_excerpt' => '',
  'post_name' => 'blog-grid3',
  'post_modified' => '2018-04-09 20:12:37',
  'post_modified_gmt' => '2018-04-09 20:12:37',
  'post_content_filtered' => '',
  'post_parent' => 3899,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=4023',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'query_category' => '0',
    'layout' => 'grid3',
    'post_content_layout' => 'polaroid',
    'disable_masonry' => 'yes',
    'more_posts' => 'infinite',
    'posts_per_page' => '8',
    'display_content' => 'none',
    'image_width' => '365',
    'image_height' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"7yzb481\\"}],\\"element_id\\":\\"zb7h031\\"}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 3896,
  'post_date' => '2015-05-07 20:59:58',
  'post_date_gmt' => '2015-05-07 20:59:58',
  'post_content' => '<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Blog - Grid4',
  'post_excerpt' => '',
  'post_name' => 'blog-grid4',
  'post_modified' => '2019-09-29 22:02:33',
  'post_modified_gmt' => '2019-09-29 22:02:33',
  'post_content_filtered' => '',
  'post_parent' => 3899,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=3896',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'mobile_menu_styles' => 'default',
    'query_category' => '0',
    'layout' => 'grid4',
    'disable_masonry' => 'no',
    'posts_per_page' => '8',
    'display_content' => 'none',
    'image_width' => '270',
    'image_height' => '180',
    'hide_meta_all' => 'yes',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"qo2s550\\"}],\\"element_id\\":\\"kmzk441\\"}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6279,
  'post_date' => '2017-02-18 16:56:14',
  'post_date_gmt' => '2017-02-18 16:56:14',
  'post_content' => '<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Blog - Tiles',
  'post_excerpt' => '',
  'post_name' => 'blog-tiles',
  'post_modified' => '2019-09-29 21:51:59',
  'post_modified_gmt' => '2019-09-29 21:51:59',
  'post_content_filtered' => '',
  'post_parent' => 3899,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=6279',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'mobile_menu_styles' => 'default',
    'query_category' => 'blog',
    'layout' => 'auto_tiles',
    'posts_per_page' => '7',
    'display_content' => 'none',
    'post_filter' => 'yes',
    'image_width' => '800',
    'image_height' => '600',
    'hide_meta_all' => 'yes',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"acg9770\\"}],\\"element_id\\":\\"5xlo045\\"}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6202,
  'post_date' => '2017-01-17 21:12:03',
  'post_date_gmt' => '2017-01-17 21:12:03',
  'post_content' => '',
  'post_title' => 'Boxed Post',
  'post_excerpt' => '',
  'post_name' => 'boxed-post',
  'post_modified' => '2017-08-21 01:18:14',
  'post_modified_gmt' => '2017-08-21 01:18:14',
  'post_content_filtered' => '',
  'post_parent' => 3899,
  'guid' => 'https://themify.me/demo/themes/ultra/?page_id=6202',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'query_category' => '0',
    'layout' => 'grid3',
    'post_content_layout' => 'boxed',
    'disable_masonry' => 'no',
    'posts_per_page' => '9',
    'image_width' => '370',
    'image_height' => '0',
    'hide_meta_all' => 'yes',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 2894,
  'post_date' => '2015-02-17 21:26:40',
  'post_date_gmt' => '2015-02-17 21:26:40',
  'post_content' => '<!--themify_builder_static--><h3>Auto Tiles</h3>

<h3>List Post</h3>

<h3>Flip Grid4</h3>

<h3>Overlay Grid4</h3>

<h3>Polaroid Grid3</h3>

<h3>Grid2 Grayscale</h3>

<h3>Masonry Grid4 Grayscale Boxed</h3>

<h3>Grid4 No-Gutter Overlay Sepia</h3>

<h3>Masonry Grid3 Grayscale Overlay No-gutter</h3>
<!--/themify_builder_static-->',
  'post_title' => 'Post Layouts',
  'post_excerpt' => '',
  'post_name' => 'all-layouts',
  'post_modified' => '2019-11-14 20:39:17',
  'post_modified_gmt' => '2019-11-14 20:39:17',
  'post_content_filtered' => '',
  'post_parent' => 3899,
  'guid' => 'https://themify.me/demo/themes/landing/?page_id=2894',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'layout' => 'slider',
    'posts_per_page' => '6',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"f93e8a1\\",\\"cols\\":[{\\"element_id\\":\\"4505a7a\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"2267455\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Auto Tiles<\\\\/h3>\\"}},{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"1420e73\\",\\"mod_settings\\":{\\"layout_post\\":\\"auto_tiles\\",\\"post_type_post\\":\\"post\\",\\"type_query_post\\":\\"category\\",\\"category_post\\":\\"0|multiple\\",\\"post_tag_post\\":\\"0|multiple\\",\\"product_cat_post\\":\\"0|multiple\\",\\"product_tag_post\\":\\"0|multiple\\",\\"product_shipping_class_post\\":\\"0|multiple\\",\\"portfolio-category_post\\":\\"0|multiple\\",\\"post_filter\\":\\"no\\",\\"post_per_page_post\\":\\"7\\",\\"order_post\\":\\"desc\\",\\"orderby_post\\":\\"date\\",\\"display_post\\":\\"none\\",\\"img_width_post\\":\\"800\\",\\"img_height_post\\":\\"600\\",\\"hide_post_date_post\\":\\"no\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_page_nav_post\\":\\"yes\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"6\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_anchor\\":\\"tiles\\"}},{\\"element_id\\":\\"70a9797\\",\\"cols\\":[{\\"element_id\\":\\"25c5937\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"a3d550f\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>List Post<\\\\/h3>\\"}},{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"f91e62a\\",\\"mod_settings\\":{\\"layout_post\\":\\"list-post\\",\\"post_type_post\\":\\"post\\",\\"type_query_post\\":\\"category\\",\\"category_post\\":\\"0|multiple\\",\\"post_tag_post\\":\\"0|multiple\\",\\"product_cat_post\\":\\"0|multiple\\",\\"product_tag_post\\":\\"0|multiple\\",\\"product_shipping_class_post\\":\\"0|multiple\\",\\"portfolio-category_post\\":\\"0|multiple\\",\\"post_filter\\":\\"no\\",\\"post_per_page_post\\":\\"1\\",\\"order_post\\":\\"desc\\",\\"orderby_post\\":\\"date\\",\\"display_post\\":\\"excerpt\\",\\"img_width_post\\":\\"1160\\",\\"img_height_post\\":\\"600\\",\\"hide_post_date_post\\":\\"no\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_page_nav_post\\":\\"yes\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"padding_top\\":49,\\"padding_top_unit\\":\\"px\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"6\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_anchor\\":\\"list-post\\"}},{\\"element_id\\":\\"52a0204\\",\\"cols\\":[{\\"element_id\\":\\"b88b60c\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"352af8e\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Flip Grid4<\\\\/h3>\\"}},{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"1617f32\\",\\"mod_settings\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"layout_post\\":\\"grid4\\",\\"post_type_post\\":\\"post\\",\\"type_query_post\\":\\"category\\",\\"category_post\\":\\"0|multiple\\",\\"post_tag_post\\":\\"0|multiple\\",\\"product_cat_post\\":\\"0|multiple\\",\\"product_tag_post\\":\\"0|multiple\\",\\"product_shipping_class_post\\":\\"0|multiple\\",\\"post_content_layout\\":\\"flip\\",\\"post_filter\\":\\"no\\",\\"post_gutter\\":\\"no-gutter\\",\\"post_per_page_post\\":\\"8\\",\\"order_post\\":\\"desc\\",\\"orderby_post\\":\\"date\\",\\"display_post\\":\\"none\\",\\"img_width_post\\":\\"290\\",\\"img_height_post\\":\\"290\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_page_nav_post\\":\\"yes\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":false,\\"margin_bottom\\":\\"6\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_anchor\\":\\"flip\\",\\"padding_top\\":30,\\"padding_top_unit\\":\\"px\\"}},{\\"element_id\\":\\"a310576\\",\\"cols\\":[{\\"element_id\\":\\"bb8a8c4\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"e3fe688\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Overlay Grid4<\\\\/h3>\\"}},{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"46b88fb\\",\\"mod_settings\\":{\\"layout_post\\":\\"grid4\\",\\"post_type_post\\":\\"post\\",\\"type_query_post\\":\\"category\\",\\"category_post\\":\\"0|multiple\\",\\"post_tag_post\\":\\"0|multiple\\",\\"product_cat_post\\":\\"0|multiple\\",\\"product_tag_post\\":\\"0|multiple\\",\\"product_shipping_class_post\\":\\"0|multiple\\",\\"portfolio-category_post\\":\\"0|multiple\\",\\"post_content_layout\\":\\"overlay\\",\\"post_filter\\":\\"no\\",\\"post_per_page_post\\":\\"8\\",\\"order_post\\":\\"desc\\",\\"orderby_post\\":\\"date\\",\\"display_post\\":\\"none\\",\\"img_width_post\\":\\"290\\",\\"img_height_post\\":\\"290\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_page_nav_post\\":\\"yes\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"6\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_anchor\\":\\"overlay\\"}},{\\"element_id\\":\\"8e8baf6\\",\\"cols\\":[{\\"element_id\\":\\"9cb1e86\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"84f33f9\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Polaroid Grid3<\\\\/h3>\\"}},{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"b1f7146\\",\\"mod_settings\\":{\\"layout_post\\":\\"grid3\\",\\"post_type_post\\":\\"post\\",\\"type_query_post\\":\\"category\\",\\"category_post\\":\\"0|multiple\\",\\"post_tag_post\\":\\"0|multiple\\",\\"product_cat_post\\":\\"0|multiple\\",\\"product_tag_post\\":\\"0|multiple\\",\\"product_shipping_class_post\\":\\"0|multiple\\",\\"portfolio-category_post\\":\\"0|multiple\\",\\"post_content_layout\\":\\"polaroid\\",\\"post_filter\\":\\"no\\",\\"post_per_page_post\\":\\"3\\",\\"order_post\\":\\"desc\\",\\"orderby_post\\":\\"date\\",\\"display_post\\":\\"none\\",\\"img_width_post\\":\\"365\\",\\"img_height_post\\":\\"250\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_page_nav_post\\":\\"yes\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"6\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_anchor\\":\\"polaroid\\"}},{\\"element_id\\":\\"14e4efa\\",\\"cols\\":[{\\"element_id\\":\\"af8e2cf\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"09893bf\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Grid2 Grayscale<\\\\/h3>\\"}},{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"b8a3b14\\",\\"mod_settings\\":{\\"layout_post\\":\\"grid2\\",\\"post_type_post\\":\\"post\\",\\"type_query_post\\":\\"category\\",\\"category_post\\":\\"0|multiple\\",\\"post_tag_post\\":\\"0|multiple\\",\\"product_cat_post\\":\\"0|multiple\\",\\"product_tag_post\\":\\"0|multiple\\",\\"product_shipping_class_post\\":\\"0|multiple\\",\\"portfolio-category_post\\":\\"0|multiple\\",\\"post_filter\\":\\"no\\",\\"post_per_page_post\\":\\"2\\",\\"order_post\\":\\"desc\\",\\"orderby_post\\":\\"date\\",\\"display_post\\":\\"none\\",\\"img_width_post\\":\\"560\\",\\"img_height_post\\":\\"380\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_page_nav_post\\":\\"yes\\",\\"css_post\\":\\"filter-grayscale filter-hover-none\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"6\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_anchor\\":\\"grayscale\\"}},{\\"element_id\\":\\"379c38c\\",\\"cols\\":[{\\"element_id\\":\\"08f8a4b\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"5ddd901\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Masonry Grid4 Grayscale Boxed<\\\\/h3>\\"}},{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"54b6d40\\",\\"mod_settings\\":{\\"layout_post\\":\\"grid4\\",\\"post_type_post\\":\\"post\\",\\"type_query_post\\":\\"category\\",\\"category_post\\":\\"0|single\\",\\"post_tag_post\\":\\"0|multiple\\",\\"product_cat_post\\":\\"0|multiple\\",\\"product_tag_post\\":\\"0|multiple\\",\\"product_shipping_class_post\\":\\"0|multiple\\",\\"portfolio-category_post\\":\\"0|multiple\\",\\"post_filter\\":\\"yes\\",\\"disable_masonry\\":\\"yes\\",\\"post_per_page_post\\":\\"8\\",\\"order_post\\":\\"desc\\",\\"orderby_post\\":\\"date\\",\\"display_post\\":\\"none\\",\\"img_width_post\\":\\"265\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_page_nav_post\\":\\"yes\\",\\"css_post\\":\\"filter-grayscale filter-hover-none\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"hide_post_date_post\\":\\"no\\",\\"unlink_post_title_post\\":\\"no\\",\\"hide_post_title_post\\":\\"no\\",\\"unlink_feat_img_post\\":\\"no\\",\\"auto_fullwidth_post\\":false,\\"hide_feat_img_post\\":\\"no\\",\\"post_content_layout\\":\\"boxed\\",\\"term_type\\":\\"category\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"6\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_anchor\\":\\"masonry\\"}},{\\"element_id\\":\\"b4c9c52\\",\\"cols\\":[{\\"element_id\\":\\"1798654\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"b2cca62\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Grid4 No-Gutter Overlay Sepia<\\\\/h3>\\"}},{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"d72d986\\",\\"mod_settings\\":{\\"layout_post\\":\\"grid4\\",\\"post_type_post\\":\\"post\\",\\"type_query_post\\":\\"category\\",\\"category_post\\":\\"0|multiple\\",\\"post_tag_post\\":\\"0|multiple\\",\\"product_cat_post\\":\\"0|multiple\\",\\"product_tag_post\\":\\"0|multiple\\",\\"product_shipping_class_post\\":\\"0|multiple\\",\\"portfolio-category_post\\":\\"0|multiple\\",\\"post_content_layout\\":\\"overlay\\",\\"post_filter\\":\\"no\\",\\"post_gutter\\":\\"no-gutter\\",\\"post_per_page_post\\":\\"8\\",\\"order_post\\":\\"desc\\",\\"orderby_post\\":\\"date\\",\\"display_post\\":\\"none\\",\\"img_width_post\\":\\"290\\",\\"img_height_post\\":\\"290\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_page_nav_post\\":\\"yes\\",\\"css_post\\":\\"filter-sepia filter-hover-none\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"6\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_anchor\\":\\"sepia\\"}},{\\"element_id\\":\\"130fed2\\",\\"cols\\":[{\\"element_id\\":\\"5a030c6\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"121edd6\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Masonry Grid3 Grayscale Overlay No-gutter<\\\\/h3>\\"}},{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"7f25eca\\",\\"mod_settings\\":{\\"layout_post\\":\\"grid3\\",\\"post_type_post\\":\\"post\\",\\"type_query_post\\":\\"category\\",\\"category_post\\":\\"0|multiple\\",\\"post_tag_post\\":\\"0|multiple\\",\\"product_cat_post\\":\\"0|multiple\\",\\"product_tag_post\\":\\"0|multiple\\",\\"product_shipping_class_post\\":\\"0|multiple\\",\\"portfolio-category_post\\":\\"0|multiple\\",\\"post_content_layout\\":\\"overlay\\",\\"post_filter\\":\\"no\\",\\"disable_masonry\\":\\"yes\\",\\"post_gutter\\":\\"no-gutter\\",\\"post_per_page_post\\":\\"10\\",\\"order_post\\":\\"desc\\",\\"orderby_post\\":\\"date\\",\\"display_post\\":\\"none\\",\\"img_width_post\\":\\"430\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_page_nav_post\\":\\"yes\\",\\"css_post\\":\\"filter-grayscale filter-hover-none\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"6\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_anchor\\":\\"masonry-no-gutter\\"}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 2694,
  'post_date' => '2015-02-06 19:02:02',
  'post_date_gmt' => '2015-02-06 19:02:02',
  'post_content' => '[woocommerce_cart]',
  'post_title' => 'Cart',
  'post_excerpt' => '',
  'post_name' => 'cart',
  'post_modified' => '2017-08-21 01:18:20',
  'post_modified_gmt' => '2017-08-21 01:18:20',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/landing/cart/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 2695,
  'post_date' => '2015-02-06 19:02:02',
  'post_date_gmt' => '2015-02-06 19:02:02',
  'post_content' => '[woocommerce_checkout]',
  'post_title' => 'Checkout',
  'post_excerpt' => '',
  'post_name' => 'checkout',
  'post_modified' => '2017-08-21 01:18:21',
  'post_modified_gmt' => '2017-08-21 01:18:21',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/landing/checkout/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 2512,
  'post_date' => '2016-01-10 00:32:45',
  'post_date_gmt' => '2016-01-10 00:32:45',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h1>Themify Ultra</h1>
<p>The most powerful &amp; flexible WordPress theme created by Themify, making it easy to create any site quickly and beautifully (and responsive, of course). Take full control of your theme design from header to footer. Loaded with many layout options and features, it is by far the most versatile theme by Themify.</p>

<h4>Drag &amp; Drop Builder</h4>
<a href="https://www.youtube.com/watch?v=waM20ewLj34" > <img src="https://themify.me/demo/themes/ultra/files/2016/02/themify-builder-1024x576-870x489.jpg" width="870" alt="themify builder" srcset="https://themify.me/demo/themes/ultra/files/2016/02/themify-builder-1024x576-870x489.jpg 870w, https://themify.me/demo/themes/ultra/files/2016/02/themify-builder-150x84.jpg 150w, https://themify.me/demo/themes/ultra/files/2016/02/themify-builder-300x169.jpg 300w, https://themify.me/demo/themes/ultra/files/2016/02/themify-builder-1024x576.jpg 1024w, https://themify.me/demo/themes/ultra/files/2016/02/themify-builder.jpg 1280w" sizes="(max-width: 870px) 100vw, 870px" /> </a>
<a href="https://themify.me/demo/themes/ultra/" > <img src="https://themify.me/demo/themes/ultra/files/2016/11/iphone-300x520.png" width="300" height="520" alt="iphone" /> </a>
<h2>Parallax Scrolling &amp; Responsive</h2>
<p>Design stunning parallax floating effects that works on all devices &amp; resolution with the Builder.</p>
<img src="https://themify.me/demo/themes/builder-layouts/files/2016/08/iphone6_silver_portrait.png" alt="" />
<h2>Pre-made Demos</h2>
<a href="https://www.youtube.com/watch?v=SENb0osYYXs" > 
 
 </a>
<p>With just a single click, you can import the demo setup that includes the theme settings, content, menus, widgets, etc., exactly like our theme demos. This is a time saver for creating client sites.</p>
<a href="https://themify.me/demo/themes/ultra-agency/" > <img src="https://themify.me/demo/themes/ultra/files/2016/11/agency-1-1024x708-360x248.jpg" width="360" title="Agency" alt="Agency" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-agency/" > Agency </a> </h3>
<a href="https://themify.me/demo/themes/ultra-restaurant/" > <img src="https://themify.me/demo/themes/ultra/files/2016/11/restaurant-1024x708-360x248.jpg" width="360" title="Restaurant" alt="Restaurant" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-restaurant/" > Restaurant </a> </h3>
<a href="https://themify.me/demo/themes/ultra-wedding/" > <img src="https://themify.me/demo/themes/ultra/files/2019/03/ultra-wedding-thumb-360x248.jpg" width="360" title="Wedding" alt="Wedding" srcset="https://themify.me/demo/themes/ultra/files/2019/03/ultra-wedding-thumb.jpg 360w, https://themify.me/demo/themes/ultra/files/2019/03/ultra-wedding-thumb-150x103.jpg 150w, https://themify.me/demo/themes/ultra/files/2019/03/ultra-wedding-thumb-300x207.jpg 300w" sizes="(max-width: 360px) 100vw, 360px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-wedding/" > Wedding </a> </h3>
<a href="https://themify.me/demo/themes/ultra-fitness/" > <img src="https://themify.me/demo/themes/ultra/files/2016/10/fitness-360x248.png" width="360" title="Fitness" alt="Fitness" srcset="https://themify.me/demo/themes/ultra/files/2016/10/fitness.png 360w, https://themify.me/demo/themes/ultra/files/2016/10/fitness-150x103.png 150w, https://themify.me/demo/themes/ultra/files/2016/10/fitness-300x207.png 300w" sizes="(max-width: 360px) 100vw, 360px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-fitness/" > Fitness </a> </h3>
<a href="https://themify.me/demo/themes/ultra-ecommerce/" > <img src="https://themify.me/demo/themes/ultra/files/2016/10/ecommerce-thumb-360x248.png" width="360" title="eCommerce" alt="eCommerce" srcset="https://themify.me/demo/themes/ultra/files/2016/10/ecommerce-thumb.png 360w, https://themify.me/demo/themes/ultra/files/2016/10/ecommerce-thumb-150x103.png 150w, https://themify.me/demo/themes/ultra/files/2016/10/ecommerce-thumb-300x207.png 300w" sizes="(max-width: 360px) 100vw, 360px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-ecommerce/" > eCommerce </a> </h3>
<a href="https://themify.me/demo/themes/ultra-lawyer/" > <img src="https://themify.me/wp-content/uploads/2017/01/lawyer-demo-site.png" width="360" title="Lawyer" alt="Lawyer" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-lawyer/" > Lawyer </a> </h3>
<a href="https://themify.me/demo/themes/ultra-spa/" > <img src="https://themify.me/demo/themes/ultra/files/2017/01/ultra-spa-360x250.png" width="360" title="Spa" alt="Spa" srcset="https://themify.me/demo/themes/ultra/files/2017/01/ultra-spa.png 360w, https://themify.me/demo/themes/ultra/files/2017/01/ultra-spa-150x104.png 150w, https://themify.me/demo/themes/ultra/files/2017/01/ultra-spa-300x208.png 300w, https://themify.me/demo/themes/ultra/files/2017/01/ultra-spa-1x1.png 1w, https://themify.me/demo/themes/ultra/files/2017/01/ultra-spa-11x8.png 11w" sizes="(max-width: 360px) 100vw, 360px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-spa/" > Spa </a> </h3>
<a href="https://themify.me/demo/themes/ultra-games/" > <img src="https://themify.me/demo/themes/ultra/files/2017/05/ultra-games-skin-360x250.jpg" width="360" title="Games" alt="Games" srcset="https://themify.me/demo/themes/ultra/files/2017/05/ultra-games-skin.jpg 360w, https://themify.me/demo/themes/ultra/files/2017/05/ultra-games-skin-150x104.jpg 150w, https://themify.me/demo/themes/ultra/files/2017/05/ultra-games-skin-300x208.jpg 300w" sizes="(max-width: 360px) 100vw, 360px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-games/" > Games </a> </h3>
<a href="https://themify.me/demo/themes/ultra-accountant/" > <img src="https://themify.me/demo/themes/ultra/files/2017/08/accountant-thumb-360x257.jpg" width="360" title="Accountant" alt="Accountant" srcset="https://themify.me/demo/themes/ultra/files/2017/08/accountant-thumb-360x257.jpg 360w, https://themify.me/demo/themes/ultra/files/2017/08/accountant-thumb-150x107.jpg 150w, https://themify.me/demo/themes/ultra/files/2017/08/accountant-thumb-300x214.jpg 300w, https://themify.me/demo/themes/ultra/files/2017/08/accountant-thumb.jpg 350w" sizes="(max-width: 360px) 100vw, 360px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-accountant/" > Accountant </a> </h3>
<a href="https://themify.me/demo/themes/ultra-photography/" > <img src="https://themify.me/wp-content/uploads/2018/05/ultra-photography-thumb-2.jpg" title="Photography" alt="Photography" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-photography/" > Photography </a> </h3>
<a href="https://themify.me/demo/themes/ultra-app/" > <img src="https://themify.me/demo/themes/ultra/files/2018/06/ultra-app-skin-thumb.jpg" title="App" alt="App" srcset="https://themify.me/demo/themes/ultra/files/2018/06/ultra-app-skin-thumb.jpg 300w, https://themify.me/demo/themes/ultra/files/2018/06/ultra-app-skin-thumb-150x112.jpg 150w" sizes="(max-width: 300px) 100vw, 300px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-app/" > App </a> </h3>
<a href="https://themify.me/demo/themes/ultra-education/" > <img src="https://themify.me/demo/themes/ultra/files/2018/08/education-thumb-360x267.jpg" width="360" title="Education" alt="Education" srcset="https://themify.me/demo/themes/ultra/files/2018/08/education-thumb-360x267.jpg 360w, https://themify.me/demo/themes/ultra/files/2018/08/education-thumb-150x112.jpg 150w, https://themify.me/demo/themes/ultra/files/2018/08/education-thumb.jpg 300w" sizes="(max-width: 360px) 100vw, 360px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-education/" > Education </a> </h3>
<a href="https://themify.me/demo/themes/ultra-portfolio/" > <img src="https://themify.me/demo/themes/ultra/files/2018/12/portfolio-skin-360x250.jpg" width="360" title="Portfolio" alt="Portfolio" srcset="https://themify.me/demo/themes/ultra/files/2018/12/portfolio-skin.jpg 360w, https://themify.me/demo/themes/ultra/files/2018/12/portfolio-skin-150x104.jpg 150w, https://themify.me/demo/themes/ultra/files/2018/12/portfolio-skin-300x208.jpg 300w" sizes="(max-width: 360px) 100vw, 360px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-portfolio/" > Portfolio </a> </h3>
<a href="https://themify.me/demo/themes/ultra-horizontal/" > <img src="https://themify.me/demo/themes/ultra/files/2019/01/ultra-horizontal-image-thumb-360x270.jpg" width="360" title="Horizontal" alt="Horizontal" srcset="https://themify.me/demo/themes/ultra/files/2019/01/ultra-horizontal-image-thumb-360x270.jpg 360w, https://themify.me/demo/themes/ultra/files/2019/01/ultra-horizontal-image-thumb-150x113.jpg 150w, https://themify.me/demo/themes/ultra/files/2019/01/ultra-horizontal-image-thumb.jpg 300w" sizes="(max-width: 360px) 100vw, 360px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-horizontal/" > Horizontal </a> </h3>
<a href="https://themify.me/demo/themes/ultra-software/" > <img src="https://themify.me/demo/themes/ultra/files/2019/04/ultra-software-skin-thumb-360x270.jpg" width="360" title="Software" alt="Software" srcset="https://themify.me/demo/themes/ultra/files/2019/04/ultra-software-skin-thumb.jpg 360w, https://themify.me/demo/themes/ultra/files/2019/04/ultra-software-skin-thumb-150x113.jpg 150w, https://themify.me/demo/themes/ultra/files/2019/04/ultra-software-skin-thumb-300x225.jpg 300w" sizes="(max-width: 360px) 100vw, 360px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-software/" > Software </a> </h3>
<a href="https://themify.me/demo/themes/ultra-trainers/" > <img src="https://themify.me/demo/themes/ultra/files/2019/08/trainer-thumb-360x270.jpg" width="360" title="Trainers" alt="Trainers" srcset="https://themify.me/demo/themes/ultra/files/2019/08/trainer-thumb.jpg 360w, https://themify.me/demo/themes/ultra/files/2019/08/trainer-thumb-150x113.jpg 150w, https://themify.me/demo/themes/ultra/files/2019/08/trainer-thumb-300x225.jpg 300w" sizes="(max-width: 360px) 100vw, 360px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-trainers/" > Trainers </a> </h3>
<img src="https://themify.me/demo/themes/ultra/files/2016/11/more-1-360x248.png" width="360" title="Coming soon" alt="Coming soon" srcset="https://themify.me/demo/themes/ultra/files/2016/11/more-1.png 360w, https://themify.me/demo/themes/ultra/files/2016/11/more-1-150x103.png 150w, https://themify.me/demo/themes/ultra/files/2016/11/more-1-300x207.png 300w, https://themify.me/demo/themes/ultra/files/2016/11/more-1-325x223.png 325w" sizes="(max-width: 360px) 100vw, 360px" /> <h3> Coming soon </h3>
<a href="https://themify.me/demo/themes/ultra-sushi/" > <img src="https://themify.me/demo/themes/ultra/files/2018/12/sushi-skin-1-360x250.jpg" width="360" title="Sushi" alt="Sushi" srcset="https://themify.me/demo/themes/ultra/files/2018/12/sushi-skin-1.jpg 360w, https://themify.me/demo/themes/ultra/files/2018/12/sushi-skin-1-150x104.jpg 150w, https://themify.me/demo/themes/ultra/files/2018/12/sushi-skin-1-300x208.jpg 300w" sizes="(max-width: 360px) 100vw, 360px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-sushi/" > Sushi </a> </h3>
<a href="https://themify.me/demo/themes/ultra-lifestyle/" > <img src="https://themify.me/demo/themes/ultra/files/2019/02/ultra-life-style-image-thumb-360x270.jpg" width="360" title="Lifestyle" alt="Lifestyle" srcset="https://themify.me/demo/themes/ultra/files/2019/02/ultra-life-style-image-thumb.jpg 360w, https://themify.me/demo/themes/ultra/files/2019/02/ultra-life-style-image-thumb-150x113.jpg 150w, https://themify.me/demo/themes/ultra/files/2019/02/ultra-life-style-image-thumb-300x225.jpg 300w" sizes="(max-width: 360px) 100vw, 360px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-lifestyle/" > Lifestyle </a> </h3>
<a href="https://themify.me/demo/themes/ultra-magazine/" > <img src="https://themify.me/demo/themes/ultra/files/2019/05/magazine-screenshot-360x270.jpg" width="360" title="Magazine" alt="Magazine" srcset="https://themify.me/demo/themes/ultra/files/2019/05/magazine-screenshot.jpg 360w, https://themify.me/demo/themes/ultra/files/2019/05/magazine-screenshot-150x113.jpg 150w, https://themify.me/demo/themes/ultra/files/2019/05/magazine-screenshot-300x225.jpg 300w" sizes="(max-width: 360px) 100vw, 360px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-magazine/" > Magazine </a> </h3>
<a href="https://themify.me/demo/themes/ultra-fashion/" > <img src="https://themify.me/demo/themes/ultra/files/2019/09/ultra-fashion-360x270.jpg" width="360" title="Fashion" alt="Fashion" srcset="https://themify.me/demo/themes/ultra/files/2019/09/ultra-fashion.jpg 360w, https://themify.me/demo/themes/ultra/files/2019/09/ultra-fashion-150x113.jpg 150w, https://themify.me/demo/themes/ultra/files/2019/09/ultra-fashion-300x225.jpg 300w" sizes="(max-width: 360px) 100vw, 360px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-fashion/" > Fashion </a> </h3>
<a href="https://themify.me/demo/themes/ultra-music/" > <img src="https://themify.me/demo/themes/ultra/files/2019/05/music-scr-360x250.jpg" width="360" height="250" title="Music" alt="Music" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-music/" > Music </a> </h3>
<a href="https://themify.me/demo/themes/ultra-coffee/" > <img src="https://themify.me/demo/themes/ultra/files/2019/03/ultra-coffee-thumb.jpg" title="Coffee" alt="Coffee" srcset="https://themify.me/demo/themes/ultra/files/2019/03/ultra-coffee-thumb.jpg 360w, https://themify.me/demo/themes/ultra/files/2019/03/ultra-coffee-thumb-150x113.jpg 150w, https://themify.me/demo/themes/ultra/files/2019/03/ultra-coffee-thumb-300x225.jpg 300w" sizes="(max-width: 360px) 100vw, 360px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-coffee/" > Coffee </a> </h3>
<a href="https://themify.me/demo/themes/ultra-church/" > <img src="https://themify.me/demo/themes/ultra/files/2019/05/church-scr-360x270.jpg" width="360" title="Church" alt="Church" srcset="https://themify.me/demo/themes/ultra/files/2019/05/church-scr.jpg 360w, https://themify.me/demo/themes/ultra/files/2019/05/church-scr-150x113.jpg 150w, https://themify.me/demo/themes/ultra/files/2019/05/church-scr-300x225.jpg 300w" sizes="(max-width: 360px) 100vw, 360px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-church/" > Church </a> </h3>
<a href="https://themify.me/demo/themes/ultra-ristorante/" > <img src="https://themify.me/demo/themes/ultra/files/2019/10/ristorante-scr-360x270.jpg" width="360" title="Ristorante" alt="Ristorante" srcset="https://themify.me/demo/themes/ultra/files/2019/10/ristorante-scr.jpg 360w, https://themify.me/demo/themes/ultra/files/2019/10/ristorante-scr-150x113.jpg 150w, https://themify.me/demo/themes/ultra/files/2019/10/ristorante-scr-300x225.jpg 300w" sizes="(max-width: 360px) 100vw, 360px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-ristorante/" > Ristorante </a> </h3>
<a href="https://themify.me/demo/themes/ultra-ebook/" > <img src="https://themify.me/demo/themes/ultra/files/2019/02/ultra-ebook-thumb-360x250.jpg" width="360" height="250" title="eBook" alt="eBook" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-ebook/" > eBook </a> </h3>
<a href="https://themify.me/demo/themes/ultra-agency-2/" > <img src="https://themify.me/demo/themes/ultra/files/2019/03/agency-2-thumb-360x270.jpg" width="360" title="Agency II" alt="Agency II" srcset="https://themify.me/demo/themes/ultra/files/2019/03/agency-2-thumb.jpg 360w, https://themify.me/demo/themes/ultra/files/2019/03/agency-2-thumb-150x113.jpg 150w, https://themify.me/demo/themes/ultra/files/2019/03/agency-2-thumb-300x225.jpg 300w" sizes="(max-width: 360px) 100vw, 360px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-agency-2/" > Agency II </a> </h3>
<a href="https://themify.me/demo/themes/ultra-agency3/" > <img src="https://themify.me/demo/themes/ultra/files/2019/07/agency-3-thumbnail-360x270.jpg" width="360" title="Agency 3" alt="Agency 3" srcset="https://themify.me/demo/themes/ultra/files/2019/07/agency-3-thumbnail.jpg 360w, https://themify.me/demo/themes/ultra/files/2019/07/agency-3-thumbnail-150x113.jpg 150w, https://themify.me/demo/themes/ultra/files/2019/07/agency-3-thumbnail-300x225.jpg 300w" sizes="(max-width: 360px) 100vw, 360px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-agency3/" > Agency 3 </a> </h3>
<a href="https://themify.me/demo/themes/ultra-construction/" > <img src="https://themify.me/demo/themes/ultra/files/2019/11/construction-scr-360x252.jpg" width="360" title="Construction" alt="Construction" srcset="https://themify.me/demo/themes/ultra/files/2019/11/construction-scr-360x252.jpg 360w, https://themify.me/demo/themes/ultra/files/2019/11/construction-scr-300x211.jpg 300w, https://themify.me/demo/themes/ultra/files/2019/11/construction-scr-150x105.jpg 150w, https://themify.me/demo/themes/ultra/files/2019/11/construction-scr.jpg 370w" sizes="(max-width: 360px) 100vw, 360px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-construction/" > Construction </a> </h3>
<h2>Smart Layout Options</h2>
<p>Ultra gives you full control from header to footer, either site-wide or on a per-page basis. This means that you can make your entire site share the same look and feel or create a unique look for every page.</p>
<h4>15 Header/Page Styles</h4><p>Select a header/page design from 15 styles (the no header option is perfect for making landing pages where you don\'t want to have header navigation). And yes, there is a sticky header option and this design list is growing!</p>
<a href="https://themify.me/demo/themes/ultra/all-layouts/" > <img src="https://themify.me/demo/themes/ultra/files/2017/01/header-layout-1024x555-1158x628.png" width="1158" height="628" alt="header layout" srcset="https://themify.me/demo/themes/ultra/files/2017/01/header-layout.png 1158w, https://themify.me/demo/themes/ultra/files/2017/01/header-layout-150x81.png 150w, https://themify.me/demo/themes/ultra/files/2017/01/header-layout-300x163.png 300w, https://themify.me/demo/themes/ultra/files/2017/01/header-layout-1024x555.png 1024w, https://themify.me/demo/themes/ultra/files/2017/01/header-layout-370x201.png 370w, https://themify.me/demo/themes/ultra/files/2017/01/header-layout-600x325.png 600w" sizes="(max-width: 1158px) 100vw, 1158px" /> </a>
<h4>6 Header Background Options</h4><p>Header background allows you to: upload a background image, pick a solid color, insert a slider, upload a video, set animating colors, or have it transparent if you want.</p>
<a href="https://themify.me/demo/themes/ultra/all-layouts/" > <img src="https://themify.me/demo/themes/ultra/files/2017/01/header-background-1024x154-1158x174.png" width="1158" height="174" alt="header background" srcset="https://themify.me/demo/themes/ultra/files/2017/01/header-background.png 1158w, https://themify.me/demo/themes/ultra/files/2017/01/header-background-150x23.png 150w, https://themify.me/demo/themes/ultra/files/2017/01/header-background-300x45.png 300w, https://themify.me/demo/themes/ultra/files/2017/01/header-background-1024x154.png 1024w, https://themify.me/demo/themes/ultra/files/2017/01/header-background-370x56.png 370w, https://themify.me/demo/themes/ultra/files/2017/01/header-background-600x90.png 600w" sizes="(max-width: 1158px) 100vw, 1158px" /> </a>
<h4>6 Footer Layouts</h4><p>6 footer layout choices with options to toggle visibility of footer logo, menu, widget, and credit text.</p>
<a href="https://themify.me/demo/themes/ultra/all-layouts/" > <img src="https://themify.me/demo/themes/ultra/files/2017/01/footer-layout-1024x155-1157x175.png" width="1157" height="175" alt="footer layout" srcset="https://themify.me/demo/themes/ultra/files/2017/01/footer-layout.png 1157w, https://themify.me/demo/themes/ultra/files/2017/01/footer-layout-150x23.png 150w, https://themify.me/demo/themes/ultra/files/2017/01/footer-layout-300x45.png 300w, https://themify.me/demo/themes/ultra/files/2017/01/footer-layout-1024x155.png 1024w, https://themify.me/demo/themes/ultra/files/2017/01/footer-layout-370x56.png 370w, https://themify.me/demo/themes/ultra/files/2017/01/footer-layout-600x91.png 600w" sizes="(max-width: 1157px) 100vw, 1157px" /> </a>
<h4>5 Single Post Layouts</h4><p>In term of single post layout, there is a default layout plus 4 unique layouts.</p>
<a href="https://themify.me/demo/themes/ultra/all-layouts/" > <img src="https://themify.me/demo/themes/ultra/files/2017/01/single-post-layout-759x175.png" width="759" height="175" alt="single post layout" srcset="https://themify.me/demo/themes/ultra/files/2017/01/single-post-layout.png 759w, https://themify.me/demo/themes/ultra/files/2017/01/single-post-layout-150x35.png 150w, https://themify.me/demo/themes/ultra/files/2017/01/single-post-layout-300x69.png 300w, https://themify.me/demo/themes/ultra/files/2017/01/single-post-layout-370x85.png 370w, https://themify.me/demo/themes/ultra/files/2017/01/single-post-layout-600x138.png 600w" sizes="(max-width: 759px) 100vw, 759px" /> </a>
<h4>6 Archive Layouts</h4><p>For the archive layouts, we have 6 different styles that you can choose from: slider, fullwidth, masonry, grids, polaroid, and overlay. You may also toggle the visibility of the post elements such as post title, featured image, meta, content, etc.</p>
<a href="https://themify.me/demo/themes/ultra/all-layouts/" > <img src="https://themify.me/demo/themes/ultra/files/2017/01/archive-layouts-1024x154-1157x174.png" width="1157" height="174" alt="alt text" srcset="https://themify.me/demo/themes/ultra/files/2017/01/archive-layouts.png 1157w, https://themify.me/demo/themes/ultra/files/2017/01/archive-layouts-150x23.png 150w, https://themify.me/demo/themes/ultra/files/2017/01/archive-layouts-300x45.png 300w, https://themify.me/demo/themes/ultra/files/2017/01/archive-layouts-1024x154.png 1024w, https://themify.me/demo/themes/ultra/files/2017/01/archive-layouts-370x56.png 370w, https://themify.me/demo/themes/ultra/files/2017/01/archive-layouts-600x90.png 600w" sizes="(max-width: 1157px) 100vw, 1157px" /> </a>
<h4>Section Scrolling (*New)</h4> <p>Inspired by our <a href="https://themify.me/themes/fullpane">Fullpane</a> theme, full section scrolling feature allows viewers to scroll through your page design one row at a time like a presentation slideshow. Full section scrolling now comes with Horizontal and Vertical scrolling.</p>
<a href="https://themify.me/demo/themes/ultra/theme-appearance/section-scrolling/" > <img src="https://themify.me/demo/themes/ultra/files/2019/03/slide-out-scrolling-160x135.png" width="160" height="135" title="Horizontal " alt="Horizontal " srcset="https://themify.me/demo/themes/ultra/files/2019/03/slide-out-scrolling.png 160w, https://themify.me/demo/themes/ultra/files/2019/03/slide-out-scrolling-150x127.png 150w" sizes="(max-width: 160px) 100vw, 160px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra/theme-appearance/section-scrolling/" > Horizontal & Vertical Scrolling </a> </h3>
<a href="https://themify.me/demo/themes/ultra/theme-appearance/vertical-section-scrolling/" > <img src="https://themify.me/demo/themes/ultra/files/2018/04/minbar-header-160x135.png" width="160" height="135" title="Vertical Section Scrolling" alt="Vertical Section Scrolling" srcset="https://themify.me/demo/themes/ultra/files/2018/04/minbar-header-160x135.png 160w, https://themify.me/demo/themes/ultra/files/2018/04/minbar-header-150x127.png 150w, https://themify.me/demo/themes/ultra/files/2018/04/minbar-header.png 192w" sizes="(max-width: 160px) 100vw, 160px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra/theme-appearance/vertical-section-scrolling/" > Vertical Section Scrolling </a> </h3>
<a href="https://themify.me/demo/themes/ultra/theme-appearance/horizontal-section-scrolling/" > <img src="https://themify.me/demo/themes/ultra/files/2018/04/top-bar-header-160x135.png" width="160" height="135" title="Horizontal Section Scrolling" alt="Horizontal Section Scrolling" srcset="https://themify.me/demo/themes/ultra/files/2018/04/top-bar-header-160x135.png 160w, https://themify.me/demo/themes/ultra/files/2018/04/top-bar-header-150x127.png 150w, https://themify.me/demo/themes/ultra/files/2018/04/top-bar-header.png 192w" sizes="(max-width: 160px) 100vw, 160px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra/theme-appearance/horizontal-section-scrolling/" > Horizontal Section Scrolling </a> </h3>
<h2>140+ Pre-designed Layouts</h2>
<p>The Builder includes a huge library of pre-made layouts designed by professional designers. Simply import a layout, replace the text and images, and you\'re done! You can get an awesome parallax landing page done in minutes.</p>
<a href="https://themify.me/demo/themes/builder-layouts" > View Demos </a>
<h2>12 Bonus Addons</h2>
<p>Get the exact same layouts as our pre-made sites with 12 free Builder addons. Valued at $120, purchasing the Ultra theme will give you access to all these bonus addons for free.</p>
<a href="https://themify.me/addons/progress-bar" > <img src="https://themify.me/wp-content/product-img/addons/progress-bar-thumb.jpg" width="40" title="Progress Bar" alt="Progress Bar" /> </a> <h3> <a href="https://themify.me/addons/progress-bar" > Progress Bar </a> </h3>
<a href="https://themify.me/addons/counter" > <img src="https://themify.me/wp-content/product-img/addons/counter-thumb.jpg" width="40" height="40" title="Counter" alt="Counter" /> </a> <h3> <a href="https://themify.me/addons/counter" > Counter </a> </h3>
<a href="https://themify.me/addons/timeline" > <img src="https://themify.me/wp-content/product-img/addons/timeline-thumb.jpg" width="40" height="40" title="Timeliine" alt="Timeliine" /> </a> <h3> <a href="https://themify.me/addons/timeline" > Timeliine </a> </h3>
<a href="https://themify.me/addons/contact" > <img src="https://themify.me/wp-content/product-img/addons/contact-thumb.jpg" width="40" height="40" title="Contact" alt="Contact" /> </a> <h3> <a href="https://themify.me/addons/contact" > Contact </a> </h3>
<a href="https://themify.me/addons/image-pro" > <img src="https://themify.me/wp-content/product-img/addons/image-pro-thumb.jpg" width="40" height="40" title="Image Pro" alt="Image Pro" /> </a> <h3> <a href="https://themify.me/addons/image-pro" > Image Pro </a> </h3>
<a href="https://themify.me/addons/typewriter" > <img src="https://themify.me/wp-content/product-img/addons/typewriter-thumb.jpg" width="40" height="40" title="Typewriter" alt="Typewriter" /> </a> <h3> <a href="https://themify.me/addons/typewriter" > Typewriter </a> </h3>
<a href="https://themify.me/addons/maps-pro" > <img src="https://themify.me/wp-content/product-img/addons/maps-pro-thumb.jpg" width="40" height="40" title="Maps Pro" alt="Maps Pro" /> </a> <h3> <a href="https://themify.me/addons/maps-pro" > Maps Pro </a> </h3>
<a href="https://themify.me/addons/woocommerce" > <img src="https://themify.me/wp-content/product-img/addons/woocommerce-thumb.jpg" width="40" height="40" title="Woocommerce" alt="Woocommerce" /> </a> <h3> <a href="https://themify.me/addons/woocommerce" > Woocommerce </a> </h3>
<a href="https://themify.me/addons/pricing-table" > <img src="https://themify.me/wp-content/product-img/addons/pricing-table-thumb.jpg" width="40" height="40" title="Pricing Table" alt="Pricing Table" /> </a> <h3> <a href="https://themify.me/addons/pricing-table" > Pricing Table </a> </h3>
<a href="https://themify.me/addons/countdown" > <img src="https://themify.me/wp-content/product-img/addons/countdown-thumb.jpg" width="40" height="40" title="Countdown" alt="Countdown" /> </a> <h3> <a href="https://themify.me/addons/countdown" > Countdown </a> </h3>
<h2 style="text-align: center;">Animating Colors</h2>
<h2 style="text-align: center;">Gradient</h2>
<h2 style="text-align: center;">Overlay</h2>
<img src="https://themify.me/demo/themes/ultra/files/2016/11/ultra-mega-menu-image-614x251.jpg" width="614" height="251" alt="ultra mega menu image" srcset="https://themify.me/demo/themes/ultra/files/2016/11/ultra-mega-menu-image.jpg 614w, https://themify.me/demo/themes/ultra/files/2016/11/ultra-mega-menu-image-150x61.jpg 150w, https://themify.me/demo/themes/ultra/files/2016/11/ultra-mega-menu-image-300x123.jpg 300w, https://themify.me/demo/themes/ultra/files/2016/11/ultra-mega-menu-image-370x151.jpg 370w, https://themify.me/demo/themes/ultra/files/2016/11/ultra-mega-menu-image-600x245.jpg 600w" sizes="(max-width: 614px) 100vw, 614px" />
<h2>Mega Menu</h2>
<p>Mega menu allows you to display recent posts, multi-column menus, and even the ability to add widgets into the menu.</p>
<h2>Image Filters</h2>
<p>Auto-apply Grayscale, Blur, and Sephia filters to your images without editing the original image source (no Photoshop needed). Image filter and hover filter can apply globally or individually as you want.</p>
<img src="https://themify.me/demo/themes/ultra/files/2016/11/love-260x210.jpg" width="260" height="210" title="Sepia" alt="Sepia" srcset="https://themify.me/demo/themes/ultra/files/2016/11/love.jpg 260w, https://themify.me/demo/themes/ultra/files/2016/11/love-150x121.jpg 150w, https://themify.me/demo/themes/ultra/files/2016/11/love-1x1.jpg 1w, https://themify.me/demo/themes/ultra/files/2016/11/love-11x9.jpg 11w" sizes="(max-width: 260px) 100vw, 260px" /> <h3> Sepia </h3>
<img src="https://themify.me/demo/themes/ultra/files/2016/11/cafe-260x210.jpg" width="260" height="210" title="Blur" alt="Blur" srcset="https://themify.me/demo/themes/ultra/files/2016/11/cafe.jpg 260w, https://themify.me/demo/themes/ultra/files/2016/11/cafe-150x121.jpg 150w, https://themify.me/demo/themes/ultra/files/2016/11/cafe-1x1.jpg 1w, https://themify.me/demo/themes/ultra/files/2016/11/cafe-11x9.jpg 11w" sizes="(max-width: 260px) 100vw, 260px" /> <h3> Blur </h3>
<img src="https://themify.me/demo/themes/ultra/files/2016/11/peoples-260x210.jpg" width="260" height="210" title="Grayscale" alt="Grayscale" srcset="https://themify.me/demo/themes/ultra/files/2016/11/peoples.jpg 260w, https://themify.me/demo/themes/ultra/files/2016/11/peoples-150x121.jpg 150w" sizes="(max-width: 260px) 100vw, 260px" /> <h3> Grayscale </h3>
<img src="https://themify.me/demo/themes/ultra/files/2016/09/portfolio-image.jpg" alt="portfolio-image" srcset="https://themify.me/demo/themes/ultra/files/2016/09/portfolio-image.jpg 800w, https://themify.me/demo/themes/ultra/files/2016/09/portfolio-image-150x115.jpg 150w, https://themify.me/demo/themes/ultra/files/2016/09/portfolio-image-300x230.jpg 300w, https://themify.me/demo/themes/ultra/files/2016/09/portfolio-image-370x284.jpg 370w, https://themify.me/demo/themes/ultra/files/2016/09/portfolio-image-600x460.jpg 600w" sizes="(max-width: 800px) 100vw, 800px" />
<h2>Portfolio</h2>
<p>Looking to showcase your work and services? Ultra includes an optional portfolio that works seamlessly with all of the post layouts available for the blog posts. We even throw in a post filter as a bonus.</p>
<h2>WooCommerce Shop</h2>
<p>Wanna sell something? Great, Ultra has WooCommerce integration which matches the shop with the overall theme appearance.</p>
<img src="https://themify.me/demo/themes/ultra/files/2016/11/shop-image-630x504.jpg" width="630" height="504" alt="shop image" srcset="https://themify.me/demo/themes/ultra/files/2016/11/shop-image.jpg 630w, https://themify.me/demo/themes/ultra/files/2016/11/shop-image-150x120.jpg 150w, https://themify.me/demo/themes/ultra/files/2016/11/shop-image-300x240.jpg 300w, https://themify.me/demo/themes/ultra/files/2016/11/shop-image-370x296.jpg 370w, https://themify.me/demo/themes/ultra/files/2016/11/shop-image-600x480.jpg 600w" sizes="(max-width: 630px) 100vw, 630px" />
<h2 style="text-align: center;">30 Day Money Back</h2><h3 style="text-align: center;">Buy it with confidence. If you don\'t like it, simply request a full refund within 30 days.</h3>
<a href="https://themify.me/themes/ultra" > Buy Now </a><!--/themify_builder_static-->',
  'post_title' => 'Home',
  'post_excerpt' => '',
  'post_name' => 'demo-pages',
  'post_modified' => '2019-11-19 05:18:32',
  'post_modified_gmt' => '2019-11-19 05:18:32',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/landing/?page_id=2512',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'header_design' => 'header-top-bar',
    'mobile_menu_styles' => 'default',
    'header_wrap' => 'transparent',
    'footer_design' => 'none',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"3752eb3\\",\\"cols\\":[{\\"element_id\\":\\"b630e31\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"21de73d\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h1>Themify Ultra<\\\\/h1>\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"rwxz426\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1.2\\",\\"font_size_unit\\":\\"em\\",\\"line_height\\":\\"1.5\\",\\"line_height_unit\\":\\"em\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>The most powerful &amp; flexible WordPress theme created by Themify, making it easy to create any site quickly and beautifully (and responsive, of course). Take full control of your theme design from header to footer. Loaded with many layout options and features, it is by far the most versatile theme by Themify.<\\\\/p>\\"}},{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"374d318\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"ffffff_1.00\\",\\"bottom_margin_divider\\":\\"50\\",\\"divider_type\\":\\"custom\\",\\"divider_width\\":\\"100\\",\\"divider_align\\":\\"center\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"style_divider\\":\\"solid\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"7142334\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"margin_bottom\\":\\"50\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h4>Drag &amp; Drop Builder<\\\\/h4>\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"a5ef80e\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra\\\\/files\\\\/2016\\\\/02\\\\/themify-builder-1024x576.jpg\\",\\"width_image\\":\\"870\\",\\"link_image\\":\\"https:\\\\/\\\\/www.youtube.com\\\\/watch?v=waM20ewLj34\\",\\"param_image\\":\\"lightbox\\",\\"image_zoom_icon\\":\\"zoom\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_right\\":\\"10\\",\\"margin_right_unit\\":\\"%\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"margin_left\\":\\"10\\",\\"margin_left_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeInRight\\",\\"custom_parallax_scroll_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"background_type\\":\\"gradient\\",\\"background_gradient-gradient\\":\\"0% rgb(110, 74, 255)|69% rgb(49, 245, 245)|98% rgb(255, 255, 255)\\",\\"cover_color\\":\\"_\\",\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"2\\",\\"padding_bottom_unit\\":\\"%\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"35\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"136a9d0\\",\\"cols\\":[{\\"element_id\\":\\"efb9797\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"c0cb1f4\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra\\\\/files\\\\/2016\\\\/11\\\\/iphone-325x520.png\\",\\"width_image\\":\\"300\\",\\"height_image\\":\\"520\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra\\\\/\\",\\"param_image\\":\\"lightbox\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"custom_parallax_scroll_reverse\\":\\"reverse\\",\\"custom_parallax_scroll_zindex\\":\\"1\\"}}]},{\\"element_id\\":\\"561a86e\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"4591236\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>Parallax Scrolling &amp; Responsive<\\\\/h2>\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"xcrz428\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1.2\\",\\"font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"50\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Design stunning parallax floating effects that works on all devices &amp; resolution with the Builder.<\\\\/p>\\"}}]},{\\"element_id\\":\\"a90f8bb\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"7c82adf\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-right\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/builder-layouts\\\\/files\\\\/2016\\\\/08\\\\/iphone6_silver_portrait.png\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"4\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"c76f425\\",\\"cols\\":[{\\"element_id\\":\\"d0cc39f\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"8fe5e67\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>Pre-made Demos<\\\\/h2>\\"}},{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"a205ce6\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"14\\",\\"border-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"checkbox_c_m_apply_all\\":\\"1\\",\\"c_b-type\\":\\"top\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"1\\",\\"circle_color_feature\\":\\"#000000\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-play\\",\\"icon_color_feature\\":\\"#000\\",\\"link_feature\\":\\"https:\\\\/\\\\/www.youtube.com\\\\/watch?v=SENb0osYYXs\\",\\"link_options\\":\\"lightbox\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"s2ml429\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1.2\\",\\"font_size_unit\\":\\"em\\",\\"line_height\\":\\"1.5\\",\\"line_height_unit\\":\\"em\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>With just a single click, you can import the demo setup that includes the theme settings, conten