<?php

defined( 'ABSPATH' ) or die;

$GLOBALS['processed_terms'] = array();
$GLOBALS['processed_posts'] = array();

require_once ABSPATH . 'wp-admin/includes/post.php';
require_once ABSPATH . 'wp-admin/includes/taxonomy.php';
require_once ABSPATH . 'wp-admin/includes/image.php';

/**
 * Add an Import Action, this data is stored for processing after import is done.
 *
 * Each action is sent as an Ajax request and is handled by themify-ajax.php file
 */ 
function themify_add_import_action( $action = '', $data = array() ) {
	global $import_actions;

	if ( ! isset( $import_actions[ $action ] ) ) {
		$import_actions[ $action ] = array();
	}

	$import_actions[ $action ][] = $data;
}

function themify_import_post( $post ) {
	global $processed_posts, $processed_terms;

	if ( ! post_type_exists( $post['post_type'] ) ) {
		return;
	}

	/* Menu items don't have reliable post_title, skip the post_exists check */
	if( $post['post_type'] !== 'nav_menu_item' ) {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
		if ( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
			$processed_posts[ intval( $post['ID'] ) ] = intval( $post_exists );
			return;
		}
	}

	if( $post['post_type'] == 'nav_menu_item' ) {
		if( ! isset( $post['tax_input']['nav_menu'] ) || ! term_exists( $post['tax_input']['nav_menu'], 'nav_menu' ) ) {
			return;
		}
		$_menu_item_type = $post['meta_input']['_menu_item_type'];
		$_menu_item_object_id = $post['meta_input']['_menu_item_object_id'];

		if ( 'taxonomy' == $_menu_item_type && isset( $processed_terms[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_terms[ intval( $_menu_item_object_id ) ];
		} else if ( 'post_type' == $_menu_item_type && isset( $processed_posts[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_posts[ intval( $_menu_item_object_id ) ];
		} else if ( 'custom' != $_menu_item_type ) {
			// associated object is missing or not imported yet, we'll retry later
			// $missing_menu_items[] = $item;
			return;
		}
	}

	$post_parent = ( $post['post_type'] == 'nav_menu_item' ) ? $post['meta_input']['_menu_item_menu_item_parent'] : (int) $post['post_parent'];
	$post['post_parent'] = 0;
	if ( $post_parent ) {
		// if we already know the parent, map it to the new local ID
		if ( isset( $processed_posts[ $post_parent ] ) ) {
			if( $post['post_type'] == 'nav_menu_item' ) {
				$post['meta_input']['_menu_item_menu_item_parent'] = $processed_posts[ $post_parent ];
			} else {
				$post['post_parent'] = $processed_posts[ $post_parent ];
			}
		}
	}

	/**
	 * for hierarchical taxonomies, IDs must be used so wp_set_post_terms can function properly
	 * convert term slugs to IDs for hierarchical taxonomies
	 */
	if( ! empty( $post['tax_input'] ) ) {
		foreach( $post['tax_input'] as $tax => $terms ) {
			if( is_taxonomy_hierarchical( $tax ) ) {
				$terms = explode( ', ', $terms );
				$post['tax_input'][ $tax ] = array_map( 'themify_get_term_id_by_slug', $terms, array_fill( 0, count( $terms ), $tax ) );
			}
		}
	}

	$post['post_author'] = (int) get_current_user_id();
	$post['post_status'] = 'publish';

	$old_id = $post['ID'];

	unset( $post['ID'] );
	$post_id = wp_insert_post( $post, true );
	if( is_wp_error( $post_id ) ) {
		return false;
	} else {
		$processed_posts[ $old_id ] = $post_id;

		return $post_id;
	}
}

function themify_get_placeholder_image() {
	static $placeholder_image = null;

	if( $placeholder_image == null ) {
		if ( ! function_exists( 'WP_Filesystem' ) ) {
			require_once ABSPATH . 'wp-admin/includes/file.php';
		}
		WP_Filesystem();
		global $wp_filesystem;
		$upload = wp_upload_bits( $post['post_name'] . '.jpg', null, $wp_filesystem->get_contents( THEMIFY_DIR . '/img/image-placeholder.jpg' ) );

		if ( $info = wp_check_filetype( $upload['file'] ) )
			$post['post_mime_type'] = $info['type'];
		else
			return new WP_Error( 'attachment_processing_error', __( 'Invalid file type', 'themify' ) );

		$post['guid'] = $upload['url'];
		$post_id = wp_insert_attachment( $post, $upload['file'] );
		wp_update_attachment_metadata( $post_id, wp_generate_attachment_metadata( $post_id, $upload['file'] ) );

		$placeholder_image = $post_id;
	}

	return $placeholder_image;
}

function themify_import_term( $term ) {
	global $processed_terms;

	if( $term_id = term_exists( $term['slug'], $term['taxonomy'] ) ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];
		if ( isset( $term['term_id'] ) )
			$processed_terms[ intval( $term['term_id'] ) ] = (int) $term_id;
		return (int) $term_id;
	}

	if ( empty( $term['parent'] ) ) {
		$parent = 0;
	} else {
		$parent = term_exists( $processed_terms[ intval( $term['parent'] ) ], $term['taxonomy'] );
		if ( is_array( $parent ) ) $parent = $parent['term_id'];
	}

	$id = wp_insert_term( $term['name'], $term['taxonomy'], array(
		'parent' => $parent,
		'slug' => $term['slug'],
		'description' => $term['description'],
	) );
	if ( ! is_wp_error( $id ) ) {
		if ( isset( $term['term_id'] ) ) {
			// success!
			$processed_terms[ intval($term['term_id']) ] = $id['term_id'];
			if ( isset( $term['thumbnail'] ) ) {
				themify_add_import_action( 'term_thumb', array(
					'id' => $id['term_id'],
					'thumb' => $term['thumbnail'],
				) );
			}
			return $term['term_id'];
		}
	}

	return false;
}

function themify_get_term_id_by_slug( $slug, $tax ) {
	$term = get_term_by( 'slug', $slug, $tax );
	if( $term ) {
		return $term->term_id;
	}

	return false;
}

function themify_undo_import_term( $term ) {
	$term_id = term_exists( $term['slug'], $term['taxonomy'] );
	if ( $term_id ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];

		if ( $term_thumbnail = get_term_meta( $term['term_id'], 'thumbnail_id', true ) ) {
			wp_delete_attachment( $term_thumbnail, true );
		}

		if ( isset( $term_id ) ) {
			wp_delete_term( $term_id, $term['taxonomy'] );
		}
	}
}

/**
 * Determine if a post exists based on title, content, and date
 *
 * @global wpdb $wpdb WordPress database abstraction object.
 *
 * @param array $args array of database parameters to check
 * @return int Post ID if post exists, 0 otherwise.
 */
function themify_post_exists( $args = array() ) {
	global $wpdb;

	$query = "SELECT ID FROM $wpdb->posts WHERE 1=1";
	$db_args = array();

	foreach ( $args as $key => $value ) {
		$value = wp_unslash( sanitize_post_field( $key, $value, 0, 'db' ) );
		if( ! empty( $value ) ) {
			$query .= ' AND ' . $key . ' = %s';
			$db_args[] = $value;
		}
	}

	if ( !empty ( $args ) )
		return (int) $wpdb->get_var( $wpdb->prepare($query, $args) );

	return 0;
}

function themify_undo_import_post( $post ) {
	if( $post['post_type'] == 'nav_menu_item' ) {
		$post_exists = themify_post_exists( array(
			'post_name' => $post['post_name'],
			'post_modified' => $post['post_date'],
			'post_type' => 'nav_menu_item',
		) );
	} else {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
	}
	if( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
		/**
		 * check if the post has been modified, if so leave it be
		 *
		 * NOTE: posts are imported using wp_insert_post() which modifies post_modified field
		 * to be the same as post_date, hence to check if the post has been modified,
		 * the post_modified field is compared against post_date in the original post.
		 */
		if( $post['post_date'] == get_post_field( 'post_modified', $post_exists ) ) {
			// find and remove all post attachments
			$attachments = get_posts( array(
				'post_type' => 'attachment',
				'posts_per_page' => -1,
				'post_parent' => $post_exists,
			) );
			if ( $attachments ) {
				foreach ( $attachments as $attachment ) {
					wp_delete_attachment( $attachment->ID, true );
				}
			}
			wp_delete_post( $post_exists, true ); // true: bypass trash
		}
	}
}

function themify_process_post_import( $post ) {
	if( ERASEDEMO ) {
		themify_undo_import_post( $post );
	} else {
		if ( $id = themify_import_post( $post ) ) {
			if ( defined( 'IMPORT_IMAGES' ) && ! IMPORT_IMAGES ) {
				/* if importing images is disabled and post is supposed to have a thumbnail, create a placeholder image instead */
				if ( isset( $post['thumb'] ) ) { // the post is supposed to have featured image
					$placeholder = themify_get_placeholder_image();
					if( ! is_wp_error( $placeholder ) ) {
						set_post_thumbnail( $id, $placeholder );
					}
				}
			} else {
				if ( isset( $post["thumb"] ) ) {
					themify_add_import_action( 'post_thumb', array(
						'id' => $id,
						'thumb' => $post["thumb"],
					) );
				}
				if ( isset( $post["gallery_shortcode"] ) ) {
					themify_add_import_action( 'gallery_field', array(
						'id' => $id,
						'fields' => $post["gallery_shortcode"],
					) );
				}
				if ( isset( $post["_product_image_gallery"] ) ) {
					themify_add_import_action( 'product_gallery', array(
						'id' => $id,
						'images' => $post["_product_image_gallery"],
					) );
				}
			}
		}
	}
}
$thumbs = array();
function themify_do_demo_import() {
global $import_actions;

	if ( isset( $GLOBALS["ThemifyBuilder_Data_Manager"] ) ) {
		remove_action( "save_post", array( $GLOBALS["ThemifyBuilder_Data_Manager"], "save_builder_text_only"), 10, 3 );
	}
$term = array (
  'term_id' => 3,
  'name' => 'Design',
  'slug' => 'design',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 4,
  'name' => 'Construction',
  'slug' => 'construction',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 6,
  'name' => 'Construction',
  'slug' => 'construction',
  'term_group' => 0,
  'taxonomy' => 'portfolio-category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 7,
  'name' => 'Mechanical',
  'slug' => 'mechanical',
  'term_group' => 0,
  'taxonomy' => 'portfolio-category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 8,
  'name' => 'Industrial',
  'slug' => 'industrial',
  'term_group' => 0,
  'taxonomy' => 'portfolio-category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 2,
  'name' => 'Main Navigation',
  'slug' => 'main-navigation',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 5,
  'name' => 'Service Sticky Menu',
  'slug' => 'service-sticky-menu',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$post = array (
  'ID' => 157,
  'post_date' => '2019-10-21 07:24:57',
  'post_date_gmt' => '2019-10-21 07:24:57',
  'post_content' => '<!-- wp:paragraph -->
<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.</p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Sed ut perspiciatis',
  'post_excerpt' => '',
  'post_name' => 'sed-ut-perspiciatis',
  'post_modified' => '2019-10-21 07:26:23',
  'post_modified_gmt' => '2019-10-21 07:26:23',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?p=157',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'design',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-construction/files/2019/10/glass-material-contrsuction.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 159,
  'post_date' => '2019-10-21 07:20:36',
  'post_date_gmt' => '2019-10-21 07:20:36',
  'post_content' => '<!-- wp:paragraph -->
<p>Ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit ess. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam.</p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Ratione voluptatem sequi',
  'post_excerpt' => '',
  'post_name' => 'ratione-voluptatem-sequi',
  'post_modified' => '2019-10-21 07:28:25',
  'post_modified_gmt' => '2019-10-21 07:28:25',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?p=159',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'construction',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-construction/files/2019/10/ship-dock-constrauction.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 121,
  'post_date' => '2019-10-21 07:20:28',
  'post_date_gmt' => '2019-10-21 07:20:28',
  'post_content' => '<!-- wp:paragraph -->
<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. In ornare imperdiet mi, at sollicitudin odio mollis in. Sed gravida libero ut arcu vehicula, in lacinia lorem condimentum. Aenean vulputate lacus a nibh euismod, ac ultrices massa accumsan. Maecenas et sapien scelerisque, aliquam metus nec, porttitor turpis. Nunc ut pretium ipsum. Curabitur nec orci imperdiet, porttitor purus viverra, ornare nisi. Suspendisse non aliquam quam, sed lobortis arcu. Proin vel porttitor orci. Proin eleifend lacus convallis metus rhoncus ullamcorper.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Phasellus sapien dolor, suscipit nec commodo in, hendrerit vitae lectus. Suspendisse tincidunt at quam sit amet ornare. Praesent velit nisi, laoreet quis mauris congue, tempus auctor metus. Etiam quis imperdiet enim, eget sagittis lacus. Phasellus vestibulum justo quis scelerisque blandit. Fusce nec augue nisl. Aenean laoreet felis eget ligula lobortis, et dapibus nulla scelerisque. Duis consequat porta turpis, sit amet porttitor augue molestie vel. Curabitur quis semper tellus, a malesuada nunc. Suspendisse a viverra dui. Sed tincidunt, justo eu tristique iaculis, odio arcu blandit velit, in sagittis metus massa at libero. In at faucibus metus. Maecenas volutpat vitae nunc id vulputate.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Aenean sit amet auctor enim. Sed id sapien vel libero bibendum interdum eu sed odio. Vestibulum suscipit enim pulvinar fringilla rhoncus. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Aenean nec turpis tortor. Phasellus vitae massa quis odio ullamcorper eleifend ac id mi. Ut molestie a sem in rutrum. Vestibulum sit amet pulvinar nibh, a luctus nibh. Praesent et facilisis erat. Phasellus nisi orci, ullamcorper eu metus cursus, dictum pharetra libero. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla convallis quam quis nulla sollicitudin, eu maximus felis blandit. Sed et pellentesque erat. Phasellus eleifend tellus sit amet magna molestie tincidunt.</p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Lorem ipsum',
  'post_excerpt' => '',
  'post_name' => 'lorem-ipsum',
  'post_modified' => '2019-10-21 07:25:33',
  'post_modified_gmt' => '2019-10-21 07:25:33',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?p=121',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'construction',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-construction/files/2019/10/stadium-construction.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 127,
  'post_date' => '2019-10-21 07:02:11',
  'post_date_gmt' => '2019-10-21 07:02:11',
  'post_content' => '<!-- wp:paragraph -->
<p>Aenean sit amet auctor enim. Sed id sapien vel libero bibendum interdum eu sed odio. Vestibulum suscipit enim pulvinar fringilla rhoncus. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Aenean nec turpis tortor. Phasellus vitae massa quis odio ullamcorper eleifend ac id mi. Ut molestie a sem in rutrum. Vestibulum sit amet pulvinar nibh, a luctus nibh. Praesent et facilisis erat. Phasellus nisi orci, ullamcorper eu metus cursus, dictum pharetra libero. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla convallis quam quis nulla sollicitudin, eu maximus felis blandit. Sed et pellentesque erat. Phasellus eleifend tellus sit amet magna molestie tincidunt.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Aenean bibendum mollis neque, ut dignissim odio fermentum ut. Sed rhoncus nec erat a laoreet. Donec placerat sapien nisl, nec dictum sem aliquet eu. Nam posuere sapien rhoncus, suscipit mauris in, imperdiet sem. Quisque at tincidunt augue, sed gravida urna. Quisque eget auctor dui. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. In sed dapibus orci. Pellentesque arcu ligula, feugiat pretium velit id, dignissim vulputate leo. Maecenas eget odio elit. Fusce quis risus tincidunt nulla auctor ornare nec sed velit. Sed vel neque at turpis consectetur auctor at ac nulla. Nam ut enim egestas, dictum nibh nec, pretium eros. Donec interdum eget risus vel lobortis. Vivamus eleifend turpis sollicitudin augue feugiat gravida. Etiam in elementum eros. Curabitur vitae consequat ante. Proin eget dui eget lorem dapibus convallis ac et sapien. Vivamus lacinia sagittis nunc vel suscipit.</p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Aenean nec turpis tortor',
  'post_excerpt' => '',
  'post_name' => 'aenean-nec-turpis-tortor',
  'post_modified' => '2019-10-21 07:28:17',
  'post_modified_gmt' => '2019-10-21 07:28:17',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?p=127',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'design',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-construction/files/2019/10/hotel-on-build.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 155,
  'post_date' => '2019-10-21 07:00:40',
  'post_date_gmt' => '2019-10-21 07:00:40',
  'post_content' => '<!-- wp:paragraph -->
<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias at vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus.</p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Lorem ipsum',
  'post_excerpt' => '',
  'post_name' => 'lorem-ipsum-2',
  'post_modified' => '2019-10-21 07:00:41',
  'post_modified_gmt' => '2019-10-21 07:00:41',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?p=155',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'construction',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-construction/files/2019/10/old-factory-construction.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 160,
  'post_date' => '2019-10-19 07:03:18',
  'post_date_gmt' => '2019-10-19 07:03:18',
  'post_content' => '<!-- wp:paragraph -->
<p>Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus. &nbsp;Ton provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?&nbsp;Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate.</p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Itaque earum',
  'post_excerpt' => '',
  'post_name' => 'itaque-earum',
  'post_modified' => '2019-10-21 07:19:21',
  'post_modified_gmt' => '2019-10-21 07:19:21',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?p=160',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'construction, design',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-construction/files/2019/10/roof-steel-contrsuction.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 161,
  'post_date' => '2019-10-18 07:04:00',
  'post_date_gmt' => '2019-10-18 07:04:00',
  'post_content' => '<!-- wp:paragraph -->
<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est. Laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.</p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Comodo consequat',
  'post_excerpt' => '',
  'post_name' => 'comodo-consequat',
  'post_modified' => '2019-10-21 07:19:27',
  'post_modified_gmt' => '2019-10-21 07:19:27',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?p=161',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'construction',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-construction/files/2019/10/bridge-construction.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 162,
  'post_date' => '2019-10-17 07:04:51',
  'post_date_gmt' => '2019-10-17 07:04:51',
  'post_content' => '<!-- wp:paragraph -->
<p>Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. Et quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus omnis.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.</p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Soluta nobis est eligendi',
  'post_excerpt' => '',
  'post_name' => 'soluta-nobis-est-eligendi',
  'post_modified' => '2019-10-21 07:19:34',
  'post_modified_gmt' => '2019-10-21 07:19:34',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?p=162',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'design',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-construction/files/2019/10/long-bridge-consturction.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 178,
  'post_date' => '2019-10-16 07:17:54',
  'post_date_gmt' => '2019-10-16 07:17:54',
  'post_content' => '<!-- wp:paragraph -->
<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt neque porro quisquam.</p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Voluptate velit esse cillum',
  'post_excerpt' => '',
  'post_name' => 'voluptate-velit-esse-cillum',
  'post_modified' => '2019-10-21 07:23:04',
  'post_modified_gmt' => '2019-10-21 07:23:04',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?p=178',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'construction',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-construction/files/2019/10/building-construction.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 163,
  'post_date' => '2019-10-16 07:05:26',
  'post_date_gmt' => '2019-10-16 07:05:26',
  'post_content' => '<!-- wp:paragraph -->
<p>Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur. Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae.</p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Voluptatem quia voluptas',
  'post_excerpt' => '',
  'post_name' => 'voluptatem-quia-voluptas',
  'post_modified' => '2019-10-21 07:19:39',
  'post_modified_gmt' => '2019-10-21 07:19:39',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?p=163',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'construction, design',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-construction/files/2019/10/modenr-cargo-bay-factory.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 129,
  'post_date' => '2019-10-15 14:24:54',
  'post_date_gmt' => '2019-10-15 14:24:54',
  'post_content' => '<!-- wp:paragraph -->
<p>Phasellus sapien dolor, suscipit nec commodo in, hendrerit vitae lectus. Suspendisse tincidunt at quam sit amet ornare. Praesent velit nisi, laoreet quis mauris congue, tempus auctor metus. Etiam quis imperdiet enim, eget sagittis lacus. Phasellus vestibulum justo quis scelerisque blandit. Fusce nec augue nisl. Aenean laoreet felis eget ligula lobortis, et dapibus nulla scelerisque. Duis consequat porta turpis, sit amet porttitor augue molestie vel. Curabitur quis semper tellus, a malesuada nunc. Suspendisse a viverra dui. Sed tincidunt, justo eu tristique iaculis, odio arcu blandit velit, in sagittis metus massa at libero. In at faucibus metus. Maecenas volutpat vitae nunc id vulputate.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Aenean sit amet auctor enim. Sed id sapien vel libero bibendum interdum eu sed odio. Vestibulum suscipit enim pulvinar fringilla rhoncus. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Aenean nec turpis tortor. Phasellus vitae massa quis odio ullamcorper eleifend ac id mi. Ut molestie a sem in rutrum. Vestibulum sit amet pulvinar nibh, a luctus nibh. Praesent et facilisis erat. Phasellus nisi orci, ullamcorper eu metus cursus, dictum pharetra libero. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla convallis quam quis nulla sollicitudin, eu maximus felis blandit. Sed et pellentesque erat. Phasellus eleifend tellus sit amet magna molestie tincidunt.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Aenean bibendum mollis neque, ut dignissim odio fermentum ut. Sed rhoncus nec erat a laoreet. Donec placerat sapien nisl, nec dictum sem aliquet eu. Nam posuere sapien rhoncus, suscipit mauris in, imperdiet sem. Quisque at tincidunt augue, sed gravida urna. Quisque eget auctor dui. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.</p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Phasellus vestibulum justo',
  'post_excerpt' => '',
  'post_name' => 'phasellus-vestibulum-justo',
  'post_modified' => '2019-10-15 14:24:57',
  'post_modified_gmt' => '2019-10-15 14:24:57',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?p=129',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'construction',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-construction/files/2019/10/skycrapper-build.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 164,
  'post_date' => '2019-10-15 07:07:14',
  'post_date_gmt' => '2019-10-15 07:07:14',
  'post_content' => '<!-- wp:paragraph -->
<p>Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?”&nbsp; repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis.</p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Et harum quidem rerum facilis',
  'post_excerpt' => '',
  'post_name' => 'et-harum-quidem-rerum-facilis',
  'post_modified' => '2019-10-21 07:19:45',
  'post_modified_gmt' => '2019-10-21 07:19:45',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?p=164',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'construction, design',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-construction/files/2019/10/man-using-torch.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 165,
  'post_date' => '2019-10-14 07:07:31',
  'post_date_gmt' => '2019-10-14 07:07:31',
  'post_content' => '<!-- wp:paragraph -->
<p>Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?” repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis.</p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Ut enim ad minima veniam',
  'post_excerpt' => '',
  'post_name' => 'ut-enim-ad-minima-veniam',
  'post_modified' => '2019-10-21 07:19:50',
  'post_modified_gmt' => '2019-10-21 07:19:50',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?p=165',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'construction',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-construction/files/2019/10/man-stand-on-crane.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 166,
  'post_date' => '2019-10-13 07:08:30',
  'post_date_gmt' => '2019-10-13 07:08:30',
  'post_content' => '<!-- wp:paragraph -->
<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.</p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Magnam aliquam quaerat',
  'post_excerpt' => '',
  'post_name' => 'magnam-aliquam-quaerat',
  'post_modified' => '2019-10-21 08:05:39',
  'post_modified_gmt' => '2019-10-21 08:05:39',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?p=166',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'design',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-construction/files/2019/10/atsrting-project-construction.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 175,
  'post_date' => '2019-10-08 07:11:37',
  'post_date_gmt' => '2019-10-08 07:11:37',
  'post_content' => '<!-- wp:paragraph -->
<p>Ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit ess. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam.</p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Quia consequuntur magni',
  'post_excerpt' => '',
  'post_name' => 'quia-consequuntur-magni',
  'post_modified' => '2019-10-21 07:22:16',
  'post_modified_gmt' => '2019-10-21 07:22:16',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?p=175',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'construction',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-construction/files/2019/10/skycrapper-construction.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 184,
  'post_date' => '2019-11-12 13:53:25',
  'post_date_gmt' => '2019-11-12 13:53:25',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h1>About Us</h1>
<a href="https://www.youtube.com/watch?v=VZC_Iqw6KT0" data-zoom-config="600px|px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/video-cover-835x400.jpg" width="835" height="400" alt="video-cover" srcset="https://themify.me/demo/themes/ultra-construction/files/2019/11/video-cover.jpg 835w, https://themify.me/demo/themes/ultra-construction/files/2019/11/video-cover-600x287.jpg 600w, https://themify.me/demo/themes/ultra-construction/files/2019/11/video-cover-768x368.jpg 768w" sizes="(max-width: 835px) 100vw, 835px" /> </a>
<h2>We are a leading company in our field, delivering exact promises to every customer.</h2>
<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>
<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>
<p><b>Allow our Award-Winning team help lead your next project from brainstorming to flawless execution. </b></p>
<img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/handshake-icon-74x74.png" width="74" height="74" title="120" alt="Finished Projects" /> <h3> 120 </h3> Finished Projects
<img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/expert-icon-74x74.png" width="74" height="74" title="165" alt="Team Members" /> <h3> 165 </h3> Team Members
<img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/badge-icon-74x74.png" width="74" height="74" title="14 " alt="Received Awards" /> <h3> 14+ </h3> Received Awards
<h3>Our Team<br/>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</h3>
<img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/jonathan-358x258.jpg" width="358" height="258" alt="jonathan" srcset="https://themify.me/demo/themes/ultra-construction/files/2019/11/jonathan-358x258.jpg 358w, https://themify.me/demo/themes/ultra-construction/files/2019/11/jonathan.jpg 357w" sizes="(max-width: 358px) 100vw, 358px" />
<h3>Jonathan Sykes</h3> <p>Construction Manager</p>
<img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/maria-358x258.jpg" width="358" height="258" alt="maria" srcset="https://themify.me/demo/themes/ultra-construction/files/2019/11/maria-358x258.jpg 358w, https://themify.me/demo/themes/ultra-construction/files/2019/11/maria.jpg 357w" sizes="(max-width: 358px) 100vw, 358px" />
<h3>Maria Renata</h3> <p>Lead Architect</p>
<img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/joseph-358x258.jpg" width="358" height="258" alt="joseph" srcset="https://themify.me/demo/themes/ultra-construction/files/2019/11/joseph-358x258.jpg 358w, https://themify.me/demo/themes/ultra-construction/files/2019/11/joseph.jpg 357w" sizes="(max-width: 358px) 100vw, 358px" />
<h3>Jose Moore</h3> <p>Executive Architect</p>
<img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/larry-358x258.jpg" width="358" height="258" alt="larry" />
<h3>Larry Bryn</h3> <p>Lead Contractor</p>
<img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/evan-robert-358x258.jpg" width="358" height="258" alt="evan-robert" />
<h3>Robert Evan</h3> <p>Finance Manager</p>
<img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/jerry-358x258.jpg" width="358" height="258" alt="jerry" />
<h3>Jerry Schultz</h3> <p>Project Manager</p>
<link id="themify-builder-208-generated" rel="stylesheet" href="https://themify.me/demo/themes/ultra-construction/files/themify-css/themify-builder-208-generated.css?ver=1576786750" type="text/css" /> <h3> Our Clients 
 </h3> <img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/repsol-263x96.jpg" width="263" height="96" alt="repsol" /> <img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/global-oil-263x96.jpg" width="263" height="96" alt="global-oil" /> <img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/victoria-263x96.jpg" width="263" height="96" alt="victoria" /> <img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/total-263x96.jpg" width="263" height="96" alt="total" /><!--/themify_builder_static-->',
  'post_title' => 'About',
  'post_excerpt' => '',
  'post_name' => 'about',
  'post_modified' => '2019-12-19 20:24:59',
  'post_modified_gmt' => '2019-12-19 20:24:59',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?page_id=184',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'section_scrolling_mobile' => 'on',
    'mobile_menu_styles' => 'default',
    'header_wrap' => 'transparent',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"0are602\\",\\"cols\\":[{\\"element_id\\":\\"g7y7603\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ka8q603\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>About Us<\\\\/h1>\\",\\"font_color\\":\\"#ffffff\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_size_h1\\":\\"3\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"text_transform_h1\\":\\"uppercase\\"}}]},{\\"element_id\\":\\"lzlm604\\",\\"grid_class\\":\\"col3-1\\"}],\\"styling\\":{\\"hide_anchor\\":false,\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"160\\",\\"padding_opp_top\\":false,\\"padding_top\\":\\"250\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"fullcover\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/about-header-bg-1.jpg\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"cover_color\\":\\"#000000_0.50\\",\\"cover_color-type\\":\\"color\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"100\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"135\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"130\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"180\\"},\\"breakpoint_tablet_landscape\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"170\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"190\\"}}},{\\"element_id\\":\\"8tv2756\\",\\"cols\\":[{\\"element_id\\":\\"6zb1758\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"z94h409\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"600\\",\\"param_image\\":\\"lightbox\\",\\"link_image\\":\\"https:\\\\/\\\\/www.youtube.com\\\\/watch?v=VZC_Iqw6KT0\\",\\"height_image\\":\\"400\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"835\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/video-cover.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"background_position\\":\\"50,50\\",\\"background_repeat\\":\\"repeat\\",\\"background_image-circle-radial\\":false,\\"background_image-type\\":\\"image\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"1cpn394\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>We are a leading company in our field, delivering exact promises to every customer.<\\\\/h2>\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"40\\",\\"margin_opp_top\\":\\"1\\",\\"margin_top\\":\\"40\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\",\\"line_height_h2_unit\\":\\"em\\",\\"line_height_h2\\":\\"1.4\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"text_transform\\":\\"uppercase\\",\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"30\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\",\\"margin_top\\":\\"40\\"}}},{\\"element_id\\":\\"2c7l361\\",\\"cols\\":[{\\"element_id\\":\\"k5z4362\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"uabu583\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<\\\\/p>\\"}}]},{\\"element_id\\":\\"khp3362\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"qdm9883\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<\\\\/p>\\"}}]}]},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"4jzk611\\",\\"mod_settings\\":{\\"content_text\\":\\"<p><b>Allow our Award-Winning team help lead your next project from brainstorming to flawless execution. <\\\\/b><\\\\/p>\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"30\\",\\"margin_opp_top\\":false,\\"margin_top\\":\\"30\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\",\\"line_height_h2_unit\\":\\"em\\",\\"line_height_h2\\":\\"1.4\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"line_height_unit\\":\\"em\\",\\"line_height\\":\\"1.5\\",\\"font_size_unit\\":\\"px\\",\\"font_size\\":\\"22\\",\\"font_color\\":\\"#000000\\",\\"background_position\\":\\"50,50\\",\\"background_repeat\\":\\"repeat\\",\\"background_image-circle-radial\\":false,\\"background_image-type\\":\\"image\\",\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"0\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\",\\"margin_top\\":\\"30\\"},\\"breakpoint_tablet\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"0\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\",\\"margin_top\\":\\"30\\"}}}]}],\\"styling\\":{\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"60\\",\\"padding_opp_top\\":false,\\"padding_top\\":\\"113\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"40\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"70\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"60\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"90\\"}}},{\\"element_id\\":\\"xdxa119\\",\\"cols\\":[{\\"element_id\\":\\"pebs121\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"zrry950\\",\\"mod_settings\\":{\\"i_t_m_bottom\\":25,\\"i_t_m_bottom_unit\\":\\"px\\",\\"caption_image\\":\\"Finished Projects\\",\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"title_image\\":\\"120\\",\\"height_image\\":\\"74\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"74\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/handshake-icon-74x74.png\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"font_size_caption_unit\\":\\"px\\",\\"font_size_caption\\":\\"25\\",\\"font_size_title_unit\\":\\"px\\",\\"font_size_title\\":\\"50\\",\\"font_color\\":\\"#ffffff\\",\\"font_color_type\\":\\"font_color_solid\\",\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"50\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"},\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_width_unit\\":\\"px\\"}}],\\"styling\\":{\\"font_color\\":\\"#ffffff\\"}},{\\"element_id\\":\\"wvkr965\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"h1zh967\\",\\"mod_settings\\":{\\"i_t_m_bottom\\":25,\\"i_t_m_bottom_unit\\":\\"px\\",\\"caption_image\\":\\"Team Members\\",\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"title_image\\":\\"165\\",\\"height_image\\":\\"74\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"74\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/expert-icon-74x74.png\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"font_size_caption_unit\\":\\"px\\",\\"font_size_caption\\":\\"25\\",\\"font_size_title_unit\\":\\"px\\",\\"font_size_title\\":\\"50\\",\\"font_color\\":\\"#ffffff\\",\\"font_color_type\\":\\"font_color_solid\\",\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"50\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"},\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_width_unit\\":\\"px\\"}}],\\"styling\\":{\\"font_color\\":\\"#ffffff\\"}},{\\"element_id\\":\\"orxi906\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"d1ob907\\",\\"mod_settings\\":{\\"i_t_m_bottom\\":25,\\"i_t_m_bottom_unit\\":\\"px\\",\\"caption_image\\":\\"Received Awards\\",\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"title_image\\":\\"14+\\",\\"height_image\\":\\"74\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"74\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/badge-icon-74x74.png\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"font_size_caption_unit\\":\\"px\\",\\"font_size_caption\\":\\"25\\",\\"font_size_title_unit\\":\\"px\\",\\"font_size_title\\":\\"50\\",\\"font_color\\":\\"#ffffff\\",\\"font_color_type\\":\\"font_color_solid\\"}}],\\"styling\\":{\\"font_color\\":\\"#ffffff\\"}}],\\"styling\\":{\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"113\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top\\":\\"113\\",\\"background_color\\":\\"#232323\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"70\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"70\\"}}},{\\"element_id\\":\\"2d6x172\\",\\"cols\\":[{\\"element_id\\":\\"l6rk173\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"71f0174\\",\\"mod_settings\\":{\\"heading\\":\\"Our Team\\",\\"divider\\":\\"yes\\",\\"text_alignment\\":\\"themify-text-center\\",\\"heading_tag\\":\\"h3\\",\\"padding_bottom\\":85,\\"padding_bottom_unit\\":\\"px\\",\\"sub_heading\\":\\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"45\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"65\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\"}}},{\\"element_id\\":\\"77g2174\\",\\"cols\\":[{\\"element_id\\":\\"8hys175\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"va74175\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"height_image\\":\\"258\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"358\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/jonathan-358x258.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"global_styles\\":\\"tb_gs2015dc\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"rz5n9\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Jonathan Sykes<\\\\/h3>\\\\n<p>Construction Manager<\\\\/p>\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"20\\",\\"background_repeat\\":\\"repeat\\",\\"background_color\\":\\"#ffffff\\",\\"background_image-circle-radial\\":false,\\"background_image-type\\":\\"image\\",\\"margin_left\\":\\"30\\",\\"margin_opp_left\\":false,\\"margin_right\\":\\"30\\",\\"margin_opp_top\\":false,\\"margin_top\\":\\"-50\\",\\"padding_left\\":\\"20\\",\\"padding_bottom\\":\\"20\\",\\"padding_right\\":\\"20\\",\\"global_styles\\":\\"tb_gs345da\\",\\"text_transform_h3\\":\\"uppercase\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}],\\"styling\\":{\\"text_align\\":\\"center\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"30\\",\\"margin-top_opp_top\\":false}},{\\"element_id\\":\\"n0x3177\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"90hs178\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"height_image\\":\\"258\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"358\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/maria-358x258.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"i_t_m_opp_left\\":false,\\"i_t_m_bottom\\":\\"20\\",\\"i_t_m_opp_top\\":false,\\"margin_opp_left\\":false,\\"margin_opp_top\\":false,\\"padding_bottom\\":10,\\"padding_bottom_unit\\":\\"px\\",\\"global_styles\\":\\"tb_gs2015dc\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"jccf177\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Maria Renata<\\\\/h3>\\\\n<p>Lead Architect<\\\\/p>\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"20\\",\\"background_repeat\\":\\"repeat\\",\\"background_color\\":\\"#ffffff\\",\\"background_image-circle-radial\\":false,\\"background_image-type\\":\\"image\\",\\"margin_left\\":\\"30\\",\\"margin_opp_left\\":false,\\"margin_right\\":\\"30\\",\\"margin_opp_top\\":false,\\"margin_top\\":\\"-50\\",\\"padding_left\\":\\"20\\",\\"padding_bottom\\":\\"20\\",\\"padding_right\\":\\"20\\",\\"global_styles\\":\\"tb_gs345da\\",\\"text_transform_h3\\":\\"uppercase\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}],\\"styling\\":{\\"text_align\\":\\"center\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"30\\",\\"margin-top_opp_top\\":false}},{\\"element_id\\":\\"lph2178\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"8n7t179\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"height_image\\":\\"258\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"358\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/joseph-358x258.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"i_t_m_opp_left\\":false,\\"i_t_m_bottom\\":\\"20\\",\\"i_t_m_opp_top\\":false,\\"margin_opp_left\\":false,\\"margin_opp_top\\":false,\\"global_styles\\":\\"tb_gs2015dc\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"hnid179\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Jose Moore<\\\\/h3>\\\\n<p>Executive Architect<\\\\/p>\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":20,\\"background_repeat\\":\\"repeat\\",\\"background_color\\":\\"#ffffff\\",\\"background_image-circle-radial\\":false,\\"background_image-type\\":\\"image\\",\\"margin_left\\":\\"30\\",\\"margin_opp_left\\":false,\\"margin_right\\":\\"30\\",\\"margin_opp_top\\":false,\\"margin_top\\":\\"-53\\",\\"padding_left\\":\\"20\\",\\"padding_bottom\\":\\"20\\",\\"padding_right\\":\\"20\\",\\"global_styles\\":\\"tb_gs345da\\",\\"padding_top_unit\\":\\"px\\",\\"text_transform_h3\\":\\"uppercase\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}],\\"styling\\":{\\"text_align\\":\\"center\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"30\\",\\"margin-top_opp_top\\":false}}],\\"col_tablet\\":\\"column3-1\\",\\"styling\\":{\\"margin_opp_left\\":false,\\"margin_opp_top\\":false}},{\\"element_id\\":\\"r460382\\",\\"cols\\":[{\\"element_id\\":\\"a0km384\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"961j385\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"height_image\\":\\"258\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"358\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/larry-358x258.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"global_styles\\":\\"tb_gs2015dc\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"hvjs386\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Larry Bryn<\\\\/h3>\\\\n<p>Lead Contractor<\\\\/p>\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"20\\",\\"background_repeat\\":\\"repeat\\",\\"background_color\\":\\"#ffffff\\",\\"background_image-circle-radial\\":false,\\"background_image-type\\":\\"image\\",\\"margin_left\\":\\"30\\",\\"margin_opp_left\\":false,\\"margin_right\\":\\"30\\",\\"margin_opp_top\\":false,\\"margin_top\\":\\"-50\\",\\"padding_left\\":\\"20\\",\\"padding_bottom\\":\\"20\\",\\"padding_right\\":\\"20\\",\\"global_styles\\":\\"tb_gs345da\\",\\"text_transform_h3\\":\\"uppercase\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}],\\"styling\\":{\\"text_align\\":\\"center\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"30\\",\\"margin-top_opp_top\\":false}},{\\"element_id\\":\\"o1gi386\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"3vh2386\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"height_image\\":\\"258\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"358\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/evan-robert-358x258.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"i_t_m_opp_left\\":false,\\"i_t_m_bottom\\":\\"20\\",\\"i_t_m_opp_top\\":false,\\"margin_opp_left\\":false,\\"margin_opp_top\\":false,\\"padding_bottom\\":10,\\"padding_bottom_unit\\":\\"px\\",\\"global_styles\\":\\"tb_gs2015dc\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"g891386\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Robert Evan<\\\\/h3>\\\\n<p>Finance Manager<\\\\/p>\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"20\\",\\"background_repeat\\":\\"repeat\\",\\"background_color\\":\\"#ffffff\\",\\"background_image-circle-radial\\":false,\\"background_image-type\\":\\"image\\",\\"margin_left\\":\\"30\\",\\"margin_opp_left\\":false,\\"margin_right\\":\\"30\\",\\"margin_opp_top\\":false,\\"margin_top\\":\\"-50\\",\\"padding_left\\":\\"20\\",\\"padding_bottom\\":\\"20\\",\\"padding_right\\":\\"20\\",\\"global_styles\\":\\"tb_gs345da\\",\\"text_transform_h3\\":\\"uppercase\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}],\\"styling\\":{\\"text_align\\":\\"center\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"30\\",\\"margin-top_opp_top\\":false}},{\\"element_id\\":\\"f7xw387\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"1cod387\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"height_image\\":\\"258\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"358\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/jerry-358x258.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"i_t_m_opp_left\\":false,\\"i_t_m_bottom\\":\\"20\\",\\"i_t_m_opp_top\\":false,\\"margin_opp_left\\":false,\\"margin_opp_top\\":false,\\"global_styles\\":\\"tb_gs2015dc\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"zj8y387\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Jerry Schultz<\\\\/h3>\\\\n<p>Project Manager<\\\\/p>\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":20,\\"background_repeat\\":\\"repeat\\",\\"background_color\\":\\"#ffffff\\",\\"background_image-circle-radial\\":false,\\"background_image-type\\":\\"image\\",\\"margin_left\\":\\"30\\",\\"margin_opp_left\\":false,\\"margin_right\\":\\"30\\",\\"margin_opp_top\\":false,\\"margin_top\\":-53,\\"padding_left\\":\\"20\\",\\"padding_bottom\\":\\"20\\",\\"padding_right\\":\\"20\\",\\"global_styles\\":\\"tb_gs345da\\",\\"padding_top_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"text_transform_h3\\":\\"uppercase\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}],\\"styling\\":{\\"text_align\\":\\"center\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"30\\",\\"margin-top_opp_top\\":false}}],\\"styling\\":{\\"margin_opp_left\\":false,\\"margin_opp_top\\":false}}]}],\\"styling\\":{\\"padding_top\\":\\"113\\",\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"0\\",\\"padding_opp_top\\":false,\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"70\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"90\\"}}},{\\"element_id\\":\\"pkml814\\",\\"cols\\":[{\\"element_id\\":\\"ojvp816\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"layout-part\\",\\"element_id\\":\\"x4p9586\\",\\"mod_settings\\":{\\"selected_layout_part\\":\\"clients\\"}}]}],\\"styling\\":{\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"180\\",\\"padding_opp_top\\":false,\\"padding_top\\":\\"80\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"180\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"70\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":200,\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"40\\"},\\"breakpoint_tablet_landscape\\":{\\"padding_bottom\\":\\"120\\",\\"padding_bottom_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"50\\"}}}]',
    'themify_used_global_styles' => 
    array (
      0 => 'tb_gs2015dc',
      1 => 'tb_gs345da',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 281,
  'post_date' => '2019-11-14 13:48:47',
  'post_date_gmt' => '2019-11-14 13:48:47',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h1>Contact</h1>
<h3>Address</h3>
<h3>Contact Information</h3>
<p>123 Main Street Toronto, Ontario M3T 4W3</p>
<h3>Phone</h3>
<p>Head Office: 413-344-8989<br />Toll-free: 1-800-344-8988</p>
<h3>Email</h3>
<a href="someemail@site.com"> info@ultratheme.construction </a>
<h3>Social Media</h3>
<a href="https://www.facebook.com/themify"> Facebook </a> <a href="https://www.facebook.com/themify"> Twitter </a> <a href="https://www.instagram.com/themify"> Instagram </a>
<img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/map-1160x428.jpg" width="1160" alt="map" srcset="https://themify.me/demo/themes/ultra-construction/files/2019/11/map.jpg 1160w, https://themify.me/demo/themes/ultra-construction/files/2019/11/map-600x221.jpg 600w, https://themify.me/demo/themes/ultra-construction/files/2019/11/map-768x283.jpg 768w" sizes="(max-width: 1160px) 100vw, 1160px" />
<h3>Contact us<br/>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</h3>
<form action="https://themify.me/demo/themes/ultra-construction/wp-admin/admin-ajax.php" id="contact-0--form" method="post"> <label for="contact-0--contact-name">Name *</label> <input type="text" name="contact-name" placeholder="" id="contact-0--contact-name" value="" required/> <label for="contact-0--contact-email">Email *</label> <input type="text" name="contact-email" placeholder="" id="contact-0--contact-email" value="" required /> <label for="contact-0--contact-subject">Subject *</label> <input type="text" name="contact-subject" placeholder="" id="contact-0--contact-subject" value="" required /> <label for="contact-0--contact-message">Message *</label> <textarea name="contact-message" placeholder="" id="contact-0--contact-message" rows="8" cols="45" required></textarea> <button type="submit"> Send </button> </form><!--/themify_builder_static-->',
  'post_title' => 'Contact',
  'post_excerpt' => '',
  'post_name' => 'contact',
  'post_modified' => '2019-11-20 06:57:17',
  'post_modified_gmt' => '2019-11-20 06:57:17',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?page_id=281',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'section_scrolling_mobile' => 'on',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"ikh0261\\",\\"cols\\":[{\\"element_id\\":\\"p3yk263\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"6dr1263\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>Contact<\\\\/h1>\\",\\"font_color\\":\\"#ffffff\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_size_h1\\":\\"3\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"text_transform_h1\\":\\"uppercase\\"}}]},{\\"element_id\\":\\"3psa264\\",\\"grid_class\\":\\"col3-1\\"}],\\"styling\\":{\\"hide_anchor\\":false,\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"170\\",\\"padding_opp_top\\":false,\\"padding_top\\":\\"190\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"fullcover\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/contact-page-header.jpg\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"cover_color\\":\\"#000000_0.50\\",\\"cover_color-type\\":\\"color\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"100\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"135\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"fullcover\\",\\"background_gradient-circle-radial\\":false,\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/contact-page-header.jpg\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"130\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"180\\"}}},{\\"element_id\\":\\"ig3q460\\",\\"cols\\":[{\\"element_id\\":\\"2u8l460\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"e5rh667\\",\\"cols\\":[{\\"element_id\\":\\"0by6669\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"zu8k332\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Address<\\\\/h3>\\",\\"text_transform\\":\\"uppercase\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_opp_left\\":false,\\"padding_right\\":\\"40\\",\\"padding_opp_top\\":false,\\"margin_opp_left\\":false,\\"margin_opp_top\\":false,\\"breakpoint_mobile\\":{\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"all\\"}}}],\\"styling\\":{\\"font_color\\":\\"#ffffff\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#4f4f4f\\",\\"border-type\\":\\"right\\",\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"4\\",\\"padding_opp_top\\":false,\\"text_align\\":\\"right\\",\\"breakpoint_mobile\\":{\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"text_align\\":\\"left\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_color\\":\\"#ffffff\\",\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#4f4f4f\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"right\\"}}},{\\"element_id\\":\\"xgaj669\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"z9tq778\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Contact Information<\\\\/h3>\\",\\"text_transform\\":\\"uppercase\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":52,\\"margin_opp_top\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"0\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\"}}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"7drq954\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>123 Main Street Toronto, Ontario M3T 4W3<\\\\/p>\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"px\\",\\"font_size\\":\\"18\\"}}],\\"styling\\":{\\"font_color\\":\\"#ffffff\\"}}],\\"column_alignment\\":\\"col_align_bottom\\",\\"col_tablet\\":\\"column3-1-3-2\\",\\"styling\\":{\\"breakpoint_mobile\\":{\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"left\\",\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"30\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"}}},{\\"element_id\\":\\"vuw5711\\",\\"cols\\":[{\\"element_id\\":\\"t9ky641\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"299s643\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Phone<\\\\/h3>\\",\\"text_transform\\":\\"uppercase\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_opp_left\\":false,\\"padding_right\\":\\"40\\",\\"padding_opp_top\\":false}}],\\"styling\\":{\\"font_color\\":\\"#ffffff\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#4f4f4f\\",\\"border-type\\":\\"right\\",\\"padding_opp_left\\":false,\\"padding_bottom\\":60,\\"padding_opp_top\\":false,\\"padding_top\\":56,\\"text_align\\":\\"right\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_top_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"text_align\\":\\"left\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_color\\":\\"#ffffff\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"0\\",\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#4f4f4f\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"right\\"}}},{\\"element_id\\":\\"7ng3714\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"i5za715\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>Head Office: 413-344-8989<br \\\\/>Toll-free: 1-800-344-8988<\\\\/p>\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top\\":47,\\"padding_top_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_size\\":\\"18\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"0\\"}}}],\\"styling\\":{\\"font_color\\":\\"#ffffff\\"}}],\\"col_tablet\\":\\"column3-1-3-2\\",\\"styling\\":{\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"30\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"}}},{\\"element_id\\":\\"pk0i61\\",\\"cols\\":[{\\"element_id\\":\\"2g6a62\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"yl3g63\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Email<\\\\/h3>\\",\\"text_transform\\":\\"uppercase\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_opp_left\\":false,\\"padding_right\\":\\"40\\",\\"padding_opp_top\\":false}}],\\"styling\\":{\\"font_color\\":\\"#ffffff\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#4f4f4f\\",\\"border-type\\":\\"right\\",\\"padding_opp_left\\":false,\\"padding_bottom\\":67,\\"padding_opp_top\\":false,\\"padding_top\\":0,\\"text_align\\":\\"right\\",\\"padding_bottom_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"0\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"text_align\\":\\"left\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_color\\":\\"#ffffff\\",\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#4f4f4f\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"right\\"}}},{\\"element_id\\":\\"kid263\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"b917376\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-email\\",\\"icon_color_bg\\":\\"orange\\",\\"label\\":\\"info@ultratheme.construction\\",\\"link\\":\\"someemail@site.com\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\"}],\\"icon_arrangement\\":\\"icon_horizontal\\",\\"icon_style\\":\\"none\\",\\"icon_size\\":\\"normal\\",\\"f_s_i_unit\\":\\"px\\",\\"f_s_i\\":\\"28\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_size\\":\\"20\\",\\"font_color\\":\\"#f69c32\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color_icon\\":\\"#f69c32\\"}}],\\"styling\\":{\\"font_color\\":\\"#ffffff\\"}}],\\"col_tablet\\":\\"column3-1-3-2\\",\\"styling\\":{\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"30\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"}}},{\\"element_id\\":\\"cvne90\\",\\"cols\\":[{\\"element_id\\":\\"m40c92\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"8x8793\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Social Media<\\\\/h3>\\",\\"text_transform\\":\\"uppercase\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_opp_left\\":false,\\"padding_right\\":\\"40\\",\\"padding_opp_top\\":false}}],\\"styling\\":{\\"font_color\\":\\"#ffffff\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#4f4f4f\\",\\"border-type\\":\\"right\\",\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"44\\",\\"padding_opp_top\\":false,\\"text_align\\":\\"right\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"text_align\\":\\"left\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_color\\":\\"#ffffff\\",\\"padding_top\\":\\"0\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"px\\",\\"margin-top\\":\\"20\\",\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#4f4f4f\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"right\\"}}},{\\"element_id\\":\\"1iur93\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"n99f94\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-facebook\\",\\"icon_color_bg\\":\\"orange\\",\\"label\\":\\"Facebook\\",\\"link\\":\\"https:\\\\/\\\\/www.facebook.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\"},{\\"icon\\":\\"ti-twitter-alt\\",\\"label\\":\\"Twitter\\",\\"link\\":\\"https:\\\\/\\\\/www.facebook.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\",\\"icon_color_bg\\":\\"tb_default_color\\"},{\\"icon\\":\\"ti-instagram\\",\\"label\\":\\"Instagram\\",\\"link\\":\\"https:\\\\/\\\\/www.instagram.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\",\\"icon_color_bg\\":\\"tb_default_color\\"}],\\"icon_arrangement\\":\\"icon_vertical\\",\\"icon_style\\":\\"none\\",\\"icon_size\\":\\"normal\\",\\"f_s_i_unit\\":\\"px\\",\\"f_s_i\\":\\"28\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_size\\":\\"20\\",\\"font_color\\":\\"#f69c32\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color_icon\\":\\"#f69c32\\"}}],\\"styling\\":{\\"font_color\\":\\"#ffffff\\"}}],\\"col_tablet\\":\\"column3-1-3-2\\"}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"right\\"}}}],\\"styling\\":{\\"hide_anchor\\":false,\\"padding_opp_left\\":false,\\"padding_bottom\\":172,\\"padding_opp_top\\":false,\\"padding_top\\":\\"113\\",\\"background_color\\":\\"#232323\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"padding_bottom_unit\\":\\"px\\",\\"margin-top_opp_top\\":false,\\"breakpoint_mobile\\":{\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"172\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"70\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"172\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"90\\"}}},{\\"element_id\\":\\"lppw201\\",\\"cols\\":[{\\"element_id\\":\\"mdi6203\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"lfng927\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"1160\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/map.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-top\\"}}]}],\\"styling\\":{\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"px\\",\\"margin-top\\":\\"-90\\",\\"padding_bottom\\":\\"113\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"70\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"90\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\"}}},{\\"element_id\\":\\"vz1v844\\",\\"cols\\":[{\\"element_id\\":\\"u3io845\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"ulhh160\\",\\"mod_settings\\":{\\"heading\\":\\"Contact us\\",\\"divider\\":\\"yes\\",\\"text_alignment\\":\\"themify-text-center\\",\\"heading_tag\\":\\"h3\\",\\"padding_bottom\\":85,\\"padding_bottom_unit\\":\\"px\\",\\"sub_heading\\":\\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"45\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\"}}},{\\"mod_name\\":\\"contact\\",\\"element_id\\":\\"a6u1452\\",\\"mod_settings\\":{\\"field_name_label\\":\\"Name\\",\\"field_email_label\\":\\"Email\\",\\"field_subject_label\\":\\"Subject\\",\\"field_message_label\\":\\"Message\\",\\"field_sendcopy_label\\":\\"Send a copy to myself\\",\\"field_send_label\\":\\"Send\\",\\"gdpr_label\\":\\"I consent to my submitted data being collected and stored\\",\\"field_name_require\\":\\"yes\\",\\"field_email_require\\":\\"yes\\",\\"field_name_active\\":\\"yes\\",\\"field_email_active\\":\\"yes\\",\\"field_subject_active\\":\\"yes\\",\\"field_subject_require\\":\\"yes\\",\\"field_message_active\\":\\"yes\\",\\"field_send_align\\":\\"center\\",\\"field_extra\\":\\"{ \\\\\\"fields\\\\\\": [] }\\",\\"field_order\\":\\"{}\\",\\"field_optin_label\\":\\"Subscribe to my newsletter.\\",\\"field_optin_active\\":false,\\"provider\\":\\"mailchimp\\",\\"field_sendcopy_active\\":false,\\"field_captcha_active\\":false,\\"contact_sent_from\\":\\"enable\\",\\"post_author\\":false,\\"user_role\\":\\"admin\\",\\"send_to_admins\\":\\"true\\",\\"layout_contact\\":\\"style2\\"}}]}],\\"styling\\":{\\"padding_bottom\\":\\"150\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false}}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 5,
  'post_date' => '2019-10-12 04:02:54',
  'post_date_gmt' => '2019-10-12 04:02:54',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h1>Ultra Construction</h1> <p>With over 20 years of contracting and construction experience, we\'ll bring our wealth of knowledge and insight to provide the most complete industrial solutions for your next development.  </p>
<a href="https://themify.me/demo/themes/ultra-construction/services-1/" > Our Services </a> <a href="https://themify.me/demo/themes/ultra-construction/contact/" > Get a Quote </a>
<h3>Why Choose Us?<br/></h3>
<a href="https://www.youtube.com/watch?v=VZC_Iqw6KT0" data-zoom-config="600px|px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/video-cover-550x350.jpg" width="550" height="350" alt="video-cover" /> </a>
<img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/sutainable-process-80x80.png" width="80" height="80" title="Complete Commercial Services Package" alt="Complete Commercial Services Package" /> <h3> Complete Commercial Services Package </h3>
<img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/sutainable-process-80x80.png" width="80" height="80" title="Complete Residential Services Package" alt="Complete Residential Services Package" /> <h3> Complete Residential Services Package </h3>
<img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/sutainable-process-80x80.png" width="80" height="80" title="Use of Sustainable Resources and Environmental Practices" alt="Use of Sustainable Resources and Environmental Practices" /> <h3> Use of Sustainable Resources and Environmental Practices </h3>
<h3>Cost of renovation</h3> <p>Has your home been overlooked or under-cared for?</p> <p>Update the look and feel of your whole home under budget!</p>
<a href="https://themify.me/demo/themes/ultra-construction/contact/" > Get a quote </a>
<h3>Our Services<br/>We specialize in complete service packages, from research, design, and development. </h3>
<img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/design-358x258.jpg" width="358" height="258" alt="design" />
<h3>Design</h3> <p>Our award-winning team of architects tackle each project with passionate and creativity.</p>
<img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/construction-358x258.jpg" width="358" height="258" alt="construction" />
<h3>Construction</h3> <p>Our contractors and construction team deliver results with precision and accuracy.</p>
<img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/project-management-358x258.jpg" width="358" height="258" alt="project-management" />
<h3>Project Management</h3> <p>Trust our project managers to work with you 1-on-1, each step of the way.</p>
<h3>Our Projects<br/>We\'re lucky to have worked with such great partners, both commercial and residential. </h3>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/10/apartment-construction.jpg" data-zoom-config="600px|px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/apartment-construction-600x360.jpg" width="600" height="360" alt="apartment-construction" /> </a>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/10/backhoe-loader.jpg" data-zoom-config="600px|px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/backhoe-loader-600x270.jpg" width="600" height="270" alt="backhoe-loader" /> </a>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/10/worker.jpg" data-zoom-config="600px|px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/worker-300x250.jpg" width="300" height="250" alt="worker" /> </a>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/10/cutting-woods.jpg" data-zoom-config="600px|px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/cutting-woods-300x250.jpg" width="300" height="250" alt="cutting-woods" /> </a>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/10/working-on-roof-top.jpg" data-zoom-config="600px|px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/working-on-roof-top-600x380.jpg" width="600" height="380" alt="working-on-roof-top" /> </a>
<a href="https://themify.me/" > See All </a>
<h3>Latest from the Blog<br/></h3>

<h3>Client Testimonials<br/></h3>
<ul data-id="tb_huep569" data-visible="1" data-mob-visible="0" data-scroll="1" data-auto-scroll="off" data-speed="1" data-wrap="yes" data-arrow="yes" data-pagination="yes" data-effect="scroll" data-height="variable" data-pause-on-hover="resume" data-horizontal="" > <li> 
 <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean eget leo ac nisi porta consectetur. Duis sit amet ligula turpis. Suspendisse eget hendrerit justo. Suspendisse elementum eleifend arcu in consequat. Nullam imperdiet, mauris a consequat pharetra, quam quam malesuada nisi, non scelerisque.</p> <figure><img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/face8-100x100.jpg" width="100" height="100" alt="face8" srcset="https://themify.me/demo/themes/ultra-construction/files/2019/10/face8-100x100.jpg 100w, https://themify.me/demo/themes/ultra-construction/files/2019/10/face8-150x150.jpg 150w, https://themify.me/demo/themes/ultra-construction/files/2019/10/face8.jpg 500w" sizes="(max-width: 100px) 100vw, 100px" /></figure> Daniel Sims Marketing Head Pentagon Elite </li> <li> 
 <p> Duis sit amet ligula turpis. Suspendisse eget hendrerit justo. Suspendisse elementum eleifend arcu in consequat. Nullam imperdiet, mauris a consequat pharetra, quam quam malesuada nisi, non scelerisque.</p> <figure><img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/face6-100x100.jpg" width="100" height="100" alt="face6" srcset="https://themify.me/demo/themes/ultra-construction/files/2019/10/face6-100x100.jpg 100w, https://themify.me/demo/themes/ultra-construction/files/2019/10/face6-150x150.jpg 150w, https://themify.me/demo/themes/ultra-construction/files/2019/10/face6.jpg 500w" sizes="(max-width: 100px) 100vw, 100px" /></figure> Margaret Singh CEO Sky Pacific </li> <li> 
 <p>Suspendisse eget hendrerit justo. Suspendisse elementum eleifend arcu in consequat. Nullam imperdiet, mauris a consequat pharetra, quam quam malesuada nisi, non scelerisque. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean eget leo ac nisi porta consectetur. Duis sit amet ligula turpis. </p> <figure><img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/face2-100x100.jpg" width="100" height="100" alt="face2" srcset="https://themify.me/demo/themes/ultra-construction/files/2019/10/face2-100x100.jpg 100w, https://themify.me/demo/themes/ultra-construction/files/2019/10/face2-150x150.jpg 150w, https://themify.me/demo/themes/ultra-construction/files/2019/10/face2.jpg 500w" sizes="(max-width: 100px) 100vw, 100px" /></figure> Michael Moore V.P. ABC Contractors </li> </ul>
<link id="themify-builder-208-generated" rel="stylesheet" href="https://themify.me/demo/themes/ultra-construction/files/themify-css/themify-builder-208-generated.css?ver=1574218932" type="text/css" /> <h3> Our Client 
 </h3> <img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/repsol-263x96.jpg" width="263" height="96" alt="repsol" /> <img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/global-oil-263x96.jpg" width="263" height="96" alt="global-oil" /> <img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/victoria-263x96.jpg" width="263" height="96" alt="victoria" /> <img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/total-263x96.jpg" width="263" height="96" alt="total" /><!--/themify_builder_static-->',
  'post_title' => 'Home',
  'post_excerpt' => '',
  'post_name' => 'home',
  'post_modified' => '2019-12-19 20:18:35',
  'post_modified_gmt' => '2019-12-19 20:18:35',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/construction/?page_id=5',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'section_scrolling_mobile' => 'on',
    'mobile_menu_styles' => 'default',
    'header_wrap' => 'transparent',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"qxyz83\\",\\"cols\\":[{\\"element_id\\":\\"x4za85\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"2qev289\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>Ultra Construction<\\\\/h1>\\\\n<p>With over 20 years of contracting and construction experience, we\\\'ll bring our wealth of knowledge and insight to provide the most complete industrial solutions for your next development.  <\\\\/p>\\",\\"font_color\\":\\"#ffffff\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_size_h1\\":\\"3\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"breakpoint_mobile\\":{\\"h1_margin_bottom_unit\\":\\"px\\",\\"h1_margin_top_unit\\":\\"px\\",\\"t_shh1_blur_unit\\":\\"px\\",\\"t_shh1_vShadow_unit\\":\\"px\\",\\"t_shh1_hShadow_unit\\":\\"px\\",\\"letter_spacing_h1_unit\\":\\"px\\",\\"line_height_h1_unit\\":\\"px\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_size_h1\\":\\"2.8\\",\\"font_gradient_color_h1-circle-radial\\":false,\\"font_gradient_color_h1-gradient-angle\\":\\"180\\",\\"font_gradient_color_h1-gradient-type\\":\\"linear\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"6jb0376\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"Our Services\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/services-1\\\\/\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\",\\"button_color_bg\\":\\"orange\\",\\"icon_alignment\\":\\"left\\"},{\\"label\\":\\"Get a Quote\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/contact\\\\/\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\",\\"icon_alignment\\":\\"left\\"}],\\"display\\":\\"buttons-horizontal\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"solid\\",\\"breakpoint_mobile\\":{\\"checkbox_m_i_bic_apply_all\\":false,\\"m_i_bic_left_unit\\":\\"px\\",\\"m_i_bic_left\\":\\"0\\",\\"m_i_bic_opp_left\\":false,\\"m_i_bic_bottom_unit\\":\\"px\\",\\"m_i_bic_right_unit\\":\\"px\\",\\"m_i_bic_right\\":\\"0\\",\\"m_i_bic_opp_top\\":false,\\"m_i_bic_top_unit\\":\\"px\\",\\"checkbox_link_margin_apply_all\\":false,\\"link_margin_left_unit\\":\\"px\\",\\"link_margin_left\\":\\"0\\",\\"link_margin_opp_left\\":false,\\"link_margin_bottom_unit\\":\\"px\\",\\"link_margin_right_unit\\":\\"px\\",\\"link_margin_right\\":\\"0\\",\\"link_margin_opp_top\\":false,\\"link_margin_top_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_left\\":\\"0\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_right\\":\\"0\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_size\\":\\"12\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\"}}}]},{\\"element_id\\":\\"25vk122\\",\\"grid_class\\":\\"col3-1\\"}],\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"hide_anchor\\":false,\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"317\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top\\":\\"317\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"fullcover\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/banner-hero.jpg\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_top_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"padding_bottom\\":117,\\"padding_bottom_unit\\":\\"px\\",\\"padding_top\\":117,\\"padding_top_unit\\":\\"px\\"},\\"breakpoint_tablet\\":{\\"padding_bottom\\":\\"150\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_top\\":\\"150\\",\\"padding_top_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\"},\\"breakpoint_tablet_landscape\\":{\\"padding_bottom\\":190,\\"padding_bottom_unit\\":\\"px\\",\\"padding_top\\":190,\\"padding_top_unit\\":\\"px\\"},\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\"}},{\\"element_id\\":\\"e4uo341\\",\\"cols\\":[{\\"element_id\\":\\"e1bs343\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"y1s7876\\",\\"mod_settings\\":{\\"heading\\":\\"Why Choose Us?\\",\\"divider\\":\\"yes\\",\\"text_alignment\\":\\"themify-text-center\\",\\"heading_tag\\":\\"h3\\",\\"padding_bottom\\":45,\\"padding_bottom_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"main_margin_bottom_unit\\":\\"px\\",\\"main_margin_top_unit\\":\\"px\\",\\"t_sh_h_blur_unit\\":\\"px\\",\\"t_sh_h_vShadow_unit\\":\\"px\\",\\"t_sh_h_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"em\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"45\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\"}}},{\\"element_id\\":\\"gpza911\\",\\"cols\\":[{\\"element_id\\":\\"p556914\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"8fm6569\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"600\\",\\"param_image\\":\\"lightbox\\",\\"link_image\\":\\"https:\\\\/\\\\/www.youtube.com\\\\/watch?v=VZC_Iqw6KT0\\",\\"height_image\\":\\"350\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"550\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/video-cover.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-top\\",\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"20\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"},\\"lightbox_height_unit\\":\\"px\\",\\"breakpoint_tablet\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"30\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"}}}],\\"styling\\":{\\"breakpoint_tablet\\":{\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"text_align\\":\\"center\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\"}}},{\\"element_id\\":\\"l9l2917\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"65ex789\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"title_image\\":\\"Complete Commercial Services Package\\",\\"height_image\\":\\"80\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"80\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/sutainable-process.png\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-left\\",\\"b_sh_inset\\":false,\\"border_top_width\\":\\"1\\",\\"border_top_color\\":\\"#eeeeee\\",\\"border-type\\":\\"all\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"20\\",\\"margin_opp_top\\":false,\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"25\\",\\"title_margin_left\\":\\"10\\",\\"title_margin_opp_left\\":false,\\"title_margin_opp_top\\":false,\\"title_margin_top\\":\\"25\\",\\"padding_left\\":\\"30\\",\\"padding_bottom\\":\\"14\\",\\"padding_right\\":\\"20\\",\\"global_styles\\":\\"tb_gs345da\\",\\"sh_h_inset\\":false}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"13mx627\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"title_image\\":\\"Complete Residential Services Package\\",\\"height_image\\":\\"80\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"80\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/sutainable-process.png\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-left\\",\\"b_sh_inset\\":false,\\"border_top_width\\":\\"1\\",\\"border_top_color\\":\\"#f7f7f7\\",\\"border-type\\":\\"all\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"20\\",\\"margin_opp_top\\":false,\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"25\\",\\"title_margin_left\\":\\"10\\",\\"title_margin_opp_left\\":false,\\"title_margin_opp_top\\":false,\\"title_margin_top\\":\\"25\\",\\"padding_left\\":\\"30\\",\\"padding_bottom\\":\\"14\\",\\"padding_right\\":\\"20\\",\\"global_styles\\":\\"tb_gs345da\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"wzgd666\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"title_image\\":\\"Use of Sustainable Resources and Environmental Practices\\",\\"height_image\\":\\"80\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"80\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/sutainable-process.png\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-left\\",\\"b_sh_inset\\":false,\\"border_top_width\\":\\"1\\",\\"border_top_color\\":\\"#f7f7f7\\",\\"border-type\\":\\"all\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"20\\",\\"margin_opp_top\\":false,\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"25\\",\\"title_margin_left\\":\\"10\\",\\"title_margin_opp_left\\":false,\\"title_margin_opp_top\\":false,\\"title_margin_top\\":\\"25\\",\\"padding_left\\":\\"30\\",\\"padding_bottom\\":\\"14\\",\\"padding_right\\":\\"20\\",\\"global_styles\\":\\"tb_gs345da\\"}}],\\"styling\\":{\\"breakpoint_tablet\\":{\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\"}}}],\\"column_alignment\\":\\"col_align_middle\\",\\"col_tablet\\":\\"column-full\\"}]}],\\"styling\\":{\\"padding_top\\":113,\\"padding_opp_left\\":false,\\"padding_bottom\\":113,\\"padding_opp_top\\":\\"1\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_top_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"padding_bottom\\":\\"70\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_top\\":\\"70\\",\\"padding_top_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"110\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"110\\"}}},{\\"element_id\\":\\"jwje49\\",\\"cols\\":[{\\"element_id\\":\\"pwqn51\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"sazo207\\",\\"cols\\":[{\\"element_id\\":\\"e838208\\",\\"grid_class\\":\\"col4-1\\"},{\\"element_id\\":\\"aexw209\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"pac4256\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Cost of renovation<\\\\/h3>\\\\n<p>Has your home been overlooked or under-cared for?<\\\\/p>\\\\n<p>Update the look and feel of your whole home under budget!<\\\\/p>\\",\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"29\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top\\":\\"29\\",\\"text_transform_h3\\":\\"uppercase\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"30\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}]},{\\"element_id\\":\\"83g9733\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"2nwp393\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"Get a quote\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/contact\\\\/\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\",\\"button_color_bg\\":\\"orange\\",\\"icon_alignment\\":\\"left\\"}],\\"display\\":\\"buttons-horizontal\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"normal\\",\\"alignment\\":\\"left\\",\\"buttons_style\\":\\"solid\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"col_tablet\\":\\"column4-1-4-2-4-1\\"}],\\"styling\\":{\\"background_position\\":\\"0,100\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/cost-of-renovation-icon.png\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"background_position\\":\\"100,100\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_gradient-circle-radial\\":false,\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/cost-of-renovation-icon.png\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"padding_bottom\\":\\"100\\"},\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"background_gradient-circle-radial\\":false,\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient-type\\":\\"linear\\"}}],\\"column_alignment\\":\\"col_align_bottom\\",\\"styling\\":{\\"padding_top\\":\\"55\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"background_color\\":\\"#232323\\",\\"background_position\\":\\"0,100\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"font_color\\":\\"#ffffff\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":0,\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":64}}},{\\"element_id\\":\\"j7d7724\\",\\"cols\\":[{\\"element_id\\":\\"5a4h725\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"u4vt445\\",\\"mod_settings\\":{\\"heading\\":\\"Our Services\\",\\"divider\\":\\"yes\\",\\"text_alignment\\":\\"themify-text-center\\",\\"heading_tag\\":\\"h3\\",\\"padding_bottom\\":85,\\"padding_bottom_unit\\":\\"px\\",\\"sub_heading\\":\\"We specialize in complete service packages, from research, design, and development. \\",\\"breakpoint_mobile\\":{\\"main_margin_bottom_unit\\":\\"px\\",\\"main_margin_top_unit\\":\\"px\\",\\"t_sh_h_blur_unit\\":\\"px\\",\\"t_sh_h_vShadow_unit\\":\\"px\\",\\"t_sh_h_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"em\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_bottom\\":\\"45\\",\\"padding_bottom_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"70\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\"}}},{\\"element_id\\":\\"l8nr748\\",\\"cols\\":[{\\"element_id\\":\\"zg8d748\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"0gjb402\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"height_image\\":\\"258\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"358\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/design-358x258.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"margin_opp_left\\":false,\\"margin_opp_top\\":false,\\"i_t_m_opp_left\\":false,\\"i_t_m_opp_top\\":false}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"mg2y464\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Design<\\\\/h3>\\\\n<p>Our award-winning team of architects tackle each project with passionate and creativity.<\\\\/p>\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"20\\",\\"background_repeat\\":\\"repeat\\",\\"background_color\\":\\"#ffffff\\",\\"background_image-circle-radial\\":false,\\"background_image-type\\":\\"image\\",\\"margin_left\\":\\"30\\",\\"margin_opp_left\\":false,\\"margin_right\\":\\"30\\",\\"margin_opp_top\\":false,\\"padding_left\\":\\"20\\",\\"padding_bottom\\":20,\\"padding_right\\":\\"20\\",\\"global_styles\\":\\"tb_gs345da\\",\\"text_transform_h3\\":\\"uppercase\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"margin_top\\":\\"-50\\",\\"breakpoint_tablet\\":{\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_left\\":\\"20\\",\\"padding_opp_left\\":false,\\"padding_right_unit\\":\\"px\\",\\"padding_right\\":\\"20\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"20\\"},\\"padding_bottom_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\"}}],\\"styling\\":{\\"text_align\\":\\"center\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"20\\",\\"margin-top_opp_top\\":false,\\"breakpoint_mobile\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"50\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"px\\"},\\"breakpoint_tablet\\":{\\"margin-bottom\\":45,\\"margin-bottom_unit\\":\\"px\\"}}},{\\"element_id\\":\\"hvo6378\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"7peb380\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"height_image\\":\\"258\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"358\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/construction-358x258.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"i_t_m_opp_left\\":false,\\"i_t_m_opp_top\\":false,\\"margin_opp_left\\":false,\\"margin_opp_top\\":false,\\"i_t_b-type\\":\\"top\\",\\"i_t_p_opp_left\\":false,\\"i_t_p_opp_top\\":false,\\"title_margin_opp_left\\":false,\\"title_margin_opp_top\\":false,\\"padding_opp_left\\":false,\\"padding_opp_top\\":false}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"7adc381\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Construction<\\\\/h3>\\\\n<p>Our contractors and construction team deliver results with precision and accuracy.<\\\\/p>\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"20\\",\\"background_repeat\\":\\"repeat\\",\\"background_color\\":\\"#ffffff\\",\\"background_image-circle-radial\\":false,\\"background_image-type\\":\\"image\\",\\"margin_left\\":\\"30\\",\\"margin_opp_left\\":false,\\"margin_right\\":\\"30\\",\\"margin_opp_top\\":false,\\"padding_left\\":\\"20\\",\\"padding_bottom\\":20,\\"padding_right\\":\\"20\\",\\"global_styles\\":\\"tb_gs345da\\",\\"text_transform_h3\\":\\"uppercase\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"margin_top\\":\\"-50\\",\\"breakpoint_tablet\\":{\\"padding_bottom\\":20,\\"padding_bottom_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_left\\":\\"20\\",\\"padding_opp_left\\":false,\\"padding_right_unit\\":\\"px\\",\\"padding_right\\":\\"20\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"20\\"},\\"padding_bottom_unit\\":\\"px\\"}}],\\"styling\\":{\\"text_align\\":\\"center\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"20\\",\\"margin-top_opp_top\\":false,\\"breakpoint_mobile\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"50\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"px\\"},\\"breakpoint_tablet\\":{\\"margin-bottom\\":45,\\"margin-bottom_unit\\":\\"px\\"}}},{\\"element_id\\":\\"w6dw376\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"rxya377\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"height_image\\":\\"258\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"358\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/project-management-358x258.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"i_t_m_opp_left\\":false,\\"i_t_m_opp_top\\":false,\\"margin_opp_left\\":false,\\"margin_opp_top\\":false}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"og4o377\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Project Management<\\\\/h3>\\\\n<p>Trust our project managers to work with you 1-on-1, each step of the way.<\\\\/p>\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":20,\\"background_repeat\\":\\"repeat\\",\\"background_color\\":\\"#ffffff\\",\\"background_image-circle-radial\\":false,\\"background_image-type\\":\\"image\\",\\"margin_left\\":\\"30\\",\\"margin_opp_left\\":false,\\"margin_right\\":\\"30\\",\\"margin_opp_top\\":false,\\"margin_top\\":-53,\\"padding_left\\":\\"20\\",\\"padding_bottom\\":\\"20\\",\\"padding_right\\":\\"20\\",\\"global_styles\\":\\"tb_gs345da\\",\\"padding_top_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"text_transform_h3\\":\\"uppercase\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}],\\"styling\\":{\\"text_align\\":\\"center\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"20\\",\\"margin-top_opp_top\\":false,\\"breakpoint_mobile\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"px\\"}}}],\\"col_tablet\\":\\"column-full\\"}]}],\\"styling\\":{\\"padding_top\\":113,\\"padding_opp_left\\":false,\\"padding_bottom\\":113,\\"padding_opp_top\\":\\"1\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_top_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"padding_bottom\\":\\"70\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_top\\":\\"70\\",\\"padding_top_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"100\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"100\\"}}},{\\"element_id\\":\\"nfmh624\\",\\"cols\\":[{\\"element_id\\":\\"has2625\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"tdzw805\\",\\"mod_settings\\":{\\"heading\\":\\"Our Projects\\",\\"divider\\":\\"yes\\",\\"text_alignment\\":\\"themify-text-center\\",\\"heading_tag\\":\\"h3\\",\\"padding_bottom\\":85,\\"padding_bottom_unit\\":\\"px\\",\\"sub_heading\\":\\"We\\\'re lucky to have worked with such great partners, both commercial and residential. \\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"45\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\"}}}]}],\\"styling\\":{\\"padding_bottom\\":300,\\"padding_bottom_unit\\":\\"px\\",\\"background_color\\":\\"#f4f4f4\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"padding_top\\":113,\\"padding_top_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"90\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"70\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"px\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"300\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"100\\"}}},{\\"element_id\\":\\"01m9972\\",\\"cols\\":[{\\"element_id\\":\\"nqgq974\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"0f5u616\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"param_image\\":\\"lightbox\\",\\"auto_fullwidth\\":\\"1\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/apartment-construction-600x360.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"height_image\\":\\"360\\",\\"width_image\\":\\"600\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"600\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/apartment-construction.jpg\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"n1xr337\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"param_image\\":\\"lightbox\\",\\"auto_fullwidth\\":\\"1\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/backhoe-loader-600x270.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"height_image\\":\\"270\\",\\"width_image\\":\\"600\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"600\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/backhoe-loader.jpg\\"}}]},{\\"element_id\\":\\"ey61550\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"vrt0754\\",\\"cols\\":[{\\"element_id\\":\\"ig8b757\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"br0w854\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"param_image\\":\\"lightbox\\",\\"auto_fullwidth\\":\\"1\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/worker-300x250.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"600\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/worker.jpg\\",\\"width_image\\":\\"300\\",\\"height_image\\":\\"250\\"}}]},{\\"element_id\\":\\"1hlm758\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"9tmb569\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"lightbox\\",\\"auto_fullwidth\\":\\"1\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/cutting-woods-300x250.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"600\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/cutting-woods.jpg\\",\\"width_image\\":\\"300\\",\\"height_image\\":\\"250\\"}}]}],\\"gutter\\":\\"gutter-none\\"},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"q65v665\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"param_image\\":\\"lightbox\\",\\"auto_fullwidth\\":\\"1\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/working-on-roof-top-600x380.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"height_image\\":\\"380\\",\\"width_image\\":\\"600\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"600\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/working-on-roof-top.jpg\\"}}]}],\\"gutter\\":\\"gutter-none\\",\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"padding_top\\":\\"0\\",\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"70\\",\\"padding_opp_top\\":false,\\"hide_anchor\\":false,\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"px\\",\\"margin-top\\":\\"-300\\",\\"breakpoint_mobile\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"px\\",\\"margin-top\\":\\"-100\\"},\\"margin-bottom_unit\\":\\"px\\"}},{\\"element_id\\":\\"0xxw901\\",\\"cols\\":[{\\"element_id\\":\\"xkm4903\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"i8vn505\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"See All\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"orange\\",\\"icon_alignment\\":\\"left\\"}],\\"alignment\\":\\"center\\",\\"display\\":\\"buttons-horizontal\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"normal\\"}}]}],\\"styling\\":{\\"padding_bottom\\":113,\\"padding_bottom_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"70\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"100\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\"}}},{\\"element_id\\":\\"vgmd88\\",\\"cols\\":[{\\"element_id\\":\\"dtch89\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"vf90672\\",\\"mod_settings\\":{\\"heading\\":\\"Latest from the Blog\\",\\"divider\\":\\"yes\\",\\"text_alignment\\":\\"themify-text-center\\",\\"heading_tag\\":\\"h3\\",\\"padding_bottom\\":85,\\"padding_bottom_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"45\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"70\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\"}}},{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"4fs4682\\",\\"mod_settings\\":{\\"layout_post\\":\\"grid3\\",\\"post_per_page_post\\":\\"3\\",\\"display_post\\":\\"excerpt\\",\\"hide_page_nav_post\\":\\"yes\\",\\"post_type_post\\":\\"post\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_post_date_post\\":\\"no\\",\\"unlink_post_title_post\\":\\"no\\",\\"hide_post_title_post\\":\\"no\\",\\"unlink_feat_img_post\\":\\"no\\",\\"auto_fullwidth_post\\":false,\\"hide_feat_img_post\\":\\"no\\",\\"orderby_post\\":\\"date\\",\\"order_post\\":\\"desc\\",\\"post_filter\\":\\"no\\",\\"category_post\\":\\"0|single\\",\\"term_type\\":\\"category\\",\\"type_query_post\\":\\"category\\",\\"img_height_post\\":\\"220\\",\\"img_width_post\\":\\"360\\",\\"post_content_layout\\":\\"boxed\\"}}]}],\\"styling\\":{\\"padding_bottom\\":113,\\"padding_bottom_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"70\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\"}}},{\\"element_id\\":\\"iz2e623\\",\\"cols\\":[{\\"element_id\\":\\"jc3v624\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"o9cc726\\",\\"mod_settings\\":{\\"heading\\":\\"Client Testimonials\\",\\"divider\\":\\"yes\\",\\"text_alignment\\":\\"themify-text-center\\",\\"heading_tag\\":\\"h3\\",\\"padding_bottom\\":44,\\"font_color_type_subheading\\":\\"font_color_subheading_solid\\",\\"font_color\\":\\"#ffffff\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_bottom_unit\\":\\"px\\"}},{\\"mod_name\\":\\"testimonial-slider\\",\\"element_id\\":\\"huep569\\",\\"mod_settings\\":{\\"layout_testimonial\\":\\"image-bubble\\",\\"img_h_slider\\":\\"100\\",\\"img_w_slider\\":\\"100\\",\\"visible_opt_slider\\":\\"1\\",\\"auto_scroll_opt_slider\\":\\"off\\",\\"tab_content_testimonial\\":[{\\"content_testimonial\\":\\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean eget leo ac nisi porta consectetur. Duis sit amet ligula turpis. Suspendisse eget hendrerit justo. Suspendisse elementum eleifend arcu in consequat. Nullam imperdiet, mauris a consequat pharetra, quam quam malesuada nisi, non scelerisque.<\\\\/p>\\",\\"person_picture_testimonial\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/face8.jpg\\",\\"person_name_testimonial\\":\\"Daniel Sims\\",\\"person_position_testimonial\\":\\"Marketing Head\\",\\"company_testimonial\\":\\"Pentagon Elite\\"},{\\"content_testimonial\\":\\"<p> Duis sit amet ligula turpis. Suspendisse eget hendrerit justo. Suspendisse elementum eleifend arcu in consequat. Nullam imperdiet, mauris a consequat pharetra, quam quam malesuada nisi, non scelerisque.<\\\\/p>\\",\\"person_picture_testimonial\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/face6.jpg\\",\\"person_name_testimonial\\":\\"Margaret Singh\\",\\"person_position_testimonial\\":\\"CEO\\",\\"company_testimonial\\":\\"Sky Pacific\\"},{\\"content_testimonial\\":\\"<p>Suspendisse eget hendrerit justo. Suspendisse elementum eleifend arcu in consequat. Nullam imperdiet, mauris a consequat pharetra, quam quam malesuada nisi, non scelerisque. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean eget leo ac nisi porta consectetur. Duis sit amet ligula turpis. <\\\\/p>\\",\\"person_picture_testimonial\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/face2.jpg\\",\\"person_name_testimonial\\":\\"Michael Moore\\",\\"person_position_testimonial\\":\\"V.P.\\",\\"company_testimonial\\":\\"ABC Contractors\\"}],\\"height_slider\\":\\"variable\\",\\"show_arrow_buttons_vertical\\":false,\\"show_arrow_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"yes\\",\\"wrap_slider\\":\\"yes\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"effect_slider\\":\\"scroll\\",\\"speed_opt_slider\\":\\"normal\\",\\"scroll_opt_slider\\":\\"1\\",\\"mob_visible_opt_slider\\":\\"0\\",\\"grid_layout_testimonial\\":\\"list-post\\",\\"type_testimonial\\":\\"slider\\"}}]}],\\"styling\\":{\\"padding_top\\":133,\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"cover_color\\":\\"#000000_0.69\\",\\"cover_color-type\\":\\"color\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"fullcover\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/bg-testimonial.jpg\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"padding_bottom\\":128,\\"padding_bottom_unit\\":\\"px\\",\\"padding_top_unit\\":\\"px\\",\\"hide_anchor\\":false,\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"100\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"90\\"}}},{\\"element_id\\":\\"hylg999\\",\\"cols\\":[{\\"element_id\\":\\"xkoj1\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"layout-part\\",\\"element_id\\":\\"7fiw374\\",\\"mod_settings\\":{\\"selected_layout_part\\":\\"clients\\",\\"breakpoint_mobile\\":{\\"checkbox_m_g_apply_all\\":false,\\"m_g_left_unit\\":\\"px\\",\\"m_g_opp_left\\":false,\\"m_g_bottom_unit\\":\\"px\\",\\"m_g_right_unit\\":\\"px\\",\\"m_g_opp_top\\":false,\\"m_g_top_unit\\":\\"px\\",\\"checkbox_p_g_apply_all\\":false,\\"p_g_left_unit\\":\\"px\\",\\"p_g_opp_left\\":false,\\"p_g_bottom_unit\\":\\"px\\",\\"p_g_right_unit\\":\\"px\\",\\"p_g_opp_top\\":false,\\"p_g_top_unit\\":\\"px\\"}}}]}],\\"styling\\":{\\"padding_top\\":\\"80\\",\\"hide_anchor\\":false,\\"padding_opp_left\\":false,\\"padding_bottom\\":213,\\"padding_opp_top\\":false,\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"120\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"80\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"px\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"70\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"80\\"},\\"breakpoint_tablet_landscape\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"100\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"80\\"},\\"padding_bottom_unit\\":\\"px\\"}}]',
    'themify_used_global_styles' => 
    array (
      0 => 'tb_gs345da',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 404,
  'post_date' => '2019-11-16 02:15:12',
  'post_date_gmt' => '2019-11-16 02:15:12',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h1>Projects</h1>
<h3>We\'ve been lucky to have been a part of some ground-breaking builds and we\'re proud of what we\'ve accomplished. See a few of the things we\'ve built.</h3>

<link id="themify-builder-208-generated" rel="stylesheet" href="https://themify.me/demo/themes/ultra-construction/files/themify-css/themify-builder-208-generated.css?ver=1576786750" type="text/css" /> <h3> Our Clients 
 </h3> <img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/repsol-263x96.jpg" width="263" height="96" alt="repsol" /> <img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/global-oil-263x96.jpg" width="263" height="96" alt="global-oil" /> <img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/victoria-263x96.jpg" width="263" height="96" alt="victoria" /> <img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/total-263x96.jpg" width="263" height="96" alt="total" /><!--/themify_builder_static-->',
  'post_title' => 'Projects',
  'post_excerpt' => '',
  'post_name' => 'projects',
  'post_modified' => '2019-12-19 20:37:03',
  'post_modified_gmt' => '2019-12-19 20:37:03',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?page_id=404',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'section_scrolling_mobile' => 'on',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"37x879\\",\\"cols\\":[{\\"element_id\\":\\"isg080\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"bkr181\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>Projects<\\\\/h1>\\",\\"font_color\\":\\"#ffffff\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_size_h1\\":\\"3\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"text_transform_h1\\":\\"uppercase\\"}}]},{\\"element_id\\":\\"pear81\\",\\"grid_class\\":\\"col3-1\\"}],\\"styling\\":{\\"hide_anchor\\":false,\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"170\\",\\"padding_opp_top\\":false,\\"padding_top\\":\\"190\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"fullcover\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/projects-header-bg.jpg\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"cover_color\\":\\"#000000_0.50\\",\\"cover_color-type\\":\\"color\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"100\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"135\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"130\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"180\\"}}},{\\"element_id\\":\\"dshh474\\",\\"cols\\":[{\\"element_id\\":\\"9ie7474\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"zf820\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>We\\\'ve been lucky to have been a part of some ground-breaking builds and we\\\'re proud of what we\\\'ve accomplished. See a few of the things we\\\'ve built.<\\\\/h3>\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_bottom\\":70,\\"padding_bottom_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"40\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"55\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\"}}},{\\"mod_name\\":\\"portfolio\\",\\"element_id\\":\\"o9ly419\\",\\"mod_settings\\":{\\"post_per_page_portfolio\\":\\"9\\",\\"hide_page_nav_portfolio\\":\\"yes\\",\\"display_portfolio\\":\\"none\\",\\"hide_post_meta_portfolio\\":\\"no\\",\\"hide_post_date_portfolio\\":\\"yes\\",\\"unlink_post_title_portfolio\\":\\"no\\",\\"hide_post_title_portfolio\\":\\"no\\",\\"unlink_feat_img_portfolio\\":\\"no\\",\\"auto_fullwidth_portfolio\\":false,\\"hide_feat_img_portfolio\\":\\"no\\",\\"orderby_portfolio\\":\\"date\\",\\"order_portfolio\\":\\"desc\\",\\"post_filter\\":\\"yes\\",\\"layout_portfolio\\":\\"grid3\\",\\"category_portfolio\\":\\"0|single\\",\\"term_type\\":\\"category\\",\\"img_height_portfolio\\":\\"300\\",\\"img_width_portfolio\\":\\"360\\",\\"portfolio_content_layout\\":\\"overlay\\",\\"breakpoint_tablet\\":{\\"t_sh_t_blur_unit\\":\\"px\\",\\"t_sh_t_vShadow_unit\\":\\"px\\",\\"t_sh_t_hShadow_unit\\":\\"px\\",\\"letter_spacing_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"font_size_title_unit\\":\\"px\\"}}}]}],\\"styling\\":{\\"padding_opp_left\\":false,\\"padding_bottom\\":0,\\"padding_opp_top\\":false,\\"padding_top\\":\\"113\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"70\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"90\\"}}},{\\"element_id\\":\\"1qzp203\\",\\"cols\\":[{\\"element_id\\":\\"gep9203\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"layout-part\\",\\"element_id\\":\\"6qof19\\",\\"mod_settings\\":{\\"selected_layout_part\\":\\"clients\\"}}]}],\\"styling\\":{\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"180\\",\\"padding_opp_top\\":false,\\"padding_top\\":\\"80\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"180\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"70\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"180\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"80\\"}}}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 317,
  'post_date' => '2019-11-15 01:34:06',
  'post_date_gmt' => '2019-11-15 01:34:06',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h1>Our SErvice Blueprints</h1>
<h3>Our Services</h3> <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. </p>
<a href="#design"> Design & Drawing </a> <a href="#roofing"> Roofing </a> <a href="#rebuild"> Complete Rebuild </a> <a href="#interior"> Interior Design </a> <a href="#windows"> Windows & Doors </a>
<a href="https://themify.me/" > Download PDF Button </a>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/11/building-design-5.jpg" data-zoom-config="700px|500px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/building-design-5-740x555.jpg" width="740" alt="building-design-5" srcset="https://themify.me/demo/themes/ultra-construction/files/2019/11/building-design-5-740x555.jpg 740w, https://themify.me/demo/themes/ultra-construction/files/2019/11/building-design-5-600x450.jpg 600w, https://themify.me/demo/themes/ultra-construction/files/2019/11/building-design-5-768x576.jpg 768w, https://themify.me/demo/themes/ultra-construction/files/2019/11/building-design-5.jpg 800w" sizes="(max-width: 740px) 100vw, 740px" /> </a>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/11/building-design-4.jpg" data-zoom-config="700px|500px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/building-design-4-300x200.jpg" width="300" height="200" alt="building-design-4" /> </a>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/11/building-design-3.jpg" data-zoom-config="700px|500px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/building-design-3-300x200.jpg" width="300" height="200" alt="building-design-3" /> </a>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/11/building-design-2.jpg" data-zoom-config="700px|500px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/building-design-2-300x200.jpg" width="300" height="200" alt="building-design-2" /> </a>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/11/building-design-1.jpg" data-zoom-config="700px|500px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/building-design-1-300x200.jpg" width="300" height="200" alt="building-design-1" /> </a>

<h3>Design &amp; Drawing</h3> <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.</p> <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.</p>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/11/roofing-top.jpg" data-zoom-config="700px|500px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/roofing-top-740x555.jpg" width="740" alt="roofing-top" srcset="https://themify.me/demo/themes/ultra-construction/files/2019/11/roofing-top-740x555.jpg 740w, https://themify.me/demo/themes/ultra-construction/files/2019/11/roofing-top-600x450.jpg 600w, https://themify.me/demo/themes/ultra-construction/files/2019/11/roofing-top-768x576.jpg 768w, https://themify.me/demo/themes/ultra-construction/files/2019/11/roofing-top.jpg 800w" sizes="(max-width: 740px) 100vw, 740px" /> </a>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/11/roofing-5.jpg" data-zoom-config="700px|500px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/roofing-5-300x200.jpg" width="300" height="200" alt="roofing-5" /> </a>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/11/roofing-4.jpg" data-zoom-config="700px|500px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/roofing-4-300x200.jpg" width="300" height="200" alt="roofing-4" /> </a>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/11/roofing-2.jpg" data-zoom-config="700px|500px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/roofing-2-300x200.jpg" width="300" height="200" alt="roofing-2" /> </a>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/11/roofing-1.jpg" data-zoom-config="700px|500px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/roofing-1-300x200.jpg" width="300" height="200" alt="roofing-1" /> </a>

<h3>Roofing</h3> <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.</p> <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.</p>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/11/complete-rebuild-1.jpg" data-zoom-config="700px|500px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/complete-rebuild-1-740x555.jpg" width="740" alt="complete-rebuild-1" srcset="https://themify.me/demo/themes/ultra-construction/files/2019/11/complete-rebuild-1-740x555.jpg 740w, https://themify.me/demo/themes/ultra-construction/files/2019/11/complete-rebuild-1-600x450.jpg 600w, https://themify.me/demo/themes/ultra-construction/files/2019/11/complete-rebuild-1-768x576.jpg 768w, https://themify.me/demo/themes/ultra-construction/files/2019/11/complete-rebuild-1.jpg 800w" sizes="(max-width: 740px) 100vw, 740px" /> </a>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/11/complete-rebuild-2.jpg" data-zoom-config="700px|500px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/complete-rebuild-2-300x200.jpg" width="300" height="200" alt="complete-rebuild-2" /> </a>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/11/complete-rebuild-3.jpg" data-zoom-config="700px|500px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/complete-rebuild-3-300x200.jpg" width="300" height="200" alt="complete-rebuild-3" /> </a>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/11/complete-rebuild-4.jpg" data-zoom-config="700px|500px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/complete-rebuild-4-300x200.jpg" width="300" height="200" alt="complete-rebuild-4" /> </a>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/11/complete-rebuild-5.jpg" data-zoom-config="700px|500px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/complete-rebuild-5-300x200.jpg" width="300" height="200" alt="complete-rebuild-5" /> </a>

<h3>Complete Rebuild</h3> <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.</p> <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.</p>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/11/design-interior-5.jpg" data-zoom-config="700px|500px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/design-interior-5-740x555.jpg" width="740" alt="design-interior-5" srcset="https://themify.me/demo/themes/ultra-construction/files/2019/11/design-interior-5-740x555.jpg 740w, https://themify.me/demo/themes/ultra-construction/files/2019/11/design-interior-5-600x450.jpg 600w, https://themify.me/demo/themes/ultra-construction/files/2019/11/design-interior-5-768x576.jpg 768w, https://themify.me/demo/themes/ultra-construction/files/2019/11/design-interior-5.jpg 800w" sizes="(max-width: 740px) 100vw, 740px" /> </a>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/11/design-interior-4.jpg" data-zoom-config="700px|500px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/design-interior-4-300x200.jpg" width="300" height="200" alt="design-interior-4" /> </a>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/11/design-interior-3.jpg" data-zoom-config="700px|500px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/design-interior-3-300x200.jpg" width="300" height="200" alt="design-interior-3" /> </a>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/11/design-interior-2-1.jpg" data-zoom-config="700px|500px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/design-interior-2-1-300x200.jpg" width="300" height="200" alt="design-interior-2" /> </a>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/11/design-interior-1.jpg" data-zoom-config="700px|500px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/design-interior-1-300x200.jpg" width="300" height="200" alt="design-interior-1" /> </a>

<h3>Interior Design</h3> <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.</p> <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.</p>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/11/windows-doors-1.jpg" data-zoom-config="700px|500px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/windows-doors-1-740x555.jpg" width="740" alt="windows-doors-1" srcset="https://themify.me/demo/themes/ultra-construction/files/2019/11/windows-doors-1-740x555.jpg 740w, https://themify.me/demo/themes/ultra-construction/files/2019/11/windows-doors-1-600x450.jpg 600w, https://themify.me/demo/themes/ultra-construction/files/2019/11/windows-doors-1-768x576.jpg 768w, https://themify.me/demo/themes/ultra-construction/files/2019/11/windows-doors-1.jpg 800w" sizes="(max-width: 740px) 100vw, 740px" /> </a>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/11/windows-doors-2.jpg" data-zoom-config="700px|500px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/windows-doors-2-300x200.jpg" width="300" height="200" alt="windows-doors-2" /> </a>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/11/windows-doors-3.jpg" data-zoom-config="700px|500px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/windows-doors-3-300x200.jpg" width="300" height="200" alt="windows-doors-3" /> </a>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/11/windows-doors-4.jpg" data-zoom-config="700px|500px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/windows-doors-4-300x200.jpg" width="300" height="200" alt="windows-doors-4" /> </a>
<a href="https://themify.me/demo/themes/ultra-construction/files/2019/11/windows-doors-5.jpg" data-zoom-config="700px|500px" > <img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/windows-doors-5-300x200.jpg" width="300" height="200" alt="windows-doors-5" /> </a>

<h3>Windows &amp; Doors</h3> <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.</p> <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.</p><!--/themify_builder_static-->',
  'post_title' => 'Service 2',
  'post_excerpt' => '',
  'post_name' => 'service-2',
  'post_modified' => '2019-12-19 20:35:47',
  'post_modified_gmt' => '2019-12-19 20:35:47',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?page_id=317',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'section_scrolling_mobile' => 'on',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"wf2b981\\",\\"cols\\":[{\\"element_id\\":\\"0h0d982\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ojt1982\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>Our SErvice Blueprints<\\\\/h1>\\",\\"font_color\\":\\"#ffffff\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_size_h1\\":\\"3\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"text_transform_h1\\":\\"uppercase\\"}}]},{\\"element_id\\":\\"2ef9983\\",\\"grid_class\\":\\"col3-1\\"}],\\"styling\\":{\\"hide_anchor\\":false,\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"170\\",\\"padding_opp_top\\":false,\\"padding_top\\":\\"190\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"fullcover\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/service-header-bg.jpg\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"cover_color\\":\\"#000000_0.52\\",\\"cover_color-type\\":\\"color\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"100\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"135\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"130\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"180\\"}}},{\\"element_id\\":\\"g6ca517\\",\\"cols\\":[{\\"element_id\\":\\"dkq7518\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"n2fb6\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Our Services<\\\\/h3>\\\\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. <\\\\/p>\\"}},{\\"element_id\\":\\"9z6g100\\",\\"cols\\":[{\\"element_id\\":\\"gyse100\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"myrt156\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-angle-right\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"Design & Drawing\\",\\"link\\":\\"#design\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\"},{\\"icon\\":\\"ti-angle-right\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"Roofing\\",\\"link\\":\\"#roofing\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\"},{\\"icon\\":\\"ti-angle-right\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"Complete Rebuild\\",\\"link\\":\\"#rebuild\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\"},{\\"icon\\":\\"ti-angle-right\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"Interior Design\\",\\"link\\":\\"#interior\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\"},{\\"icon\\":\\"ti-angle-right\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"Windows & Doors\\",\\"link\\":\\"#windows\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\"}],\\"icon_arrangement\\":\\"icon_vertical\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"normal\\",\\"b_ctn_left_style\\":\\"solid\\",\\"b_ctn_bottom_style\\":\\"solid\\",\\"b_ctn_bottom_width\\":\\"1\\",\\"b_ctn_bottom_color\\":\\"#dbdbdb\\",\\"b_ctn_right_style\\":\\"solid\\",\\"b_ctn_top_style\\":\\"solid\\",\\"b_ctn-type\\":\\"bottom\\",\\"checkbox_p_ctn_apply_all\\":false,\\"p_ctn_left_unit\\":\\"px\\",\\"p_ctn_opp_left\\":false,\\"p_ctn_bottom_unit\\":\\"px\\",\\"p_ctn_bottom\\":\\"10\\",\\"p_ctn_right_unit\\":\\"px\\",\\"p_ctn_opp_top\\":\\"1\\",\\"p_ctn_top_unit\\":\\"px\\",\\"p_ctn_top\\":\\"10\\",\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"none\\",\\"border_right_style\\":\\"solid\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"bottom\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"10\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"10\\",\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"10\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\",\\"f_s_i_unit\\":\\"px\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"52rf961\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"Download PDF Button\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\",\\"button_color_bg\\":\\"orange\\",\\"icon\\":\\"far fa-file-pdf\\",\\"icon_alignment\\":\\"left\\"}],\\"fullwidth_button\\":\\"buttons-fullwidth\\",\\"alignment\\":\\"center\\",\\"display\\":\\"buttons-horizontal\\",\\"buttons_style\\":\\"solid\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"normal\\",\\"f_s_bic_unit\\":\\"px\\",\\"f_s_bic\\":\\"22\\",\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"180\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"80\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"}}}]}],\\"styling\\":{\\"unstick_when_check\\":false,\\"stick_at_pos_val_unit\\":\\"%\\",\\"stick_at_pos_val\\":\\"20\\",\\"animation_effect_tab\\":\\"s_e_s\\",\\"margin_opp_left\\":false,\\"margin_opp_top\\":false,\\"padding_opp_left\\":false,\\"padding_opp_top\\":false}}]},{\\"element_id\\":\\"ip3r125\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"icbb236\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_height\\":\\"500\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"700\\",\\"param_image\\":\\"lightbox\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/building-design-5.jpg\\",\\"auto_fullwidth\\":\\"1\\",\\"width_image\\":\\"740\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/building-design-5-740x555.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"25\\",\\"margin_opp_top\\":false}},{\\"element_id\\":\\"87md508\\",\\"cols\\":[{\\"element_id\\":\\"07y3508\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"f26r509\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_height\\":\\"500\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"700\\",\\"param_image\\":\\"lightbox\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/building-design-4.jpg\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"300\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/building-design-4-300x200.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"height_image\\":\\"200\\",\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"25\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"}}}]},{\\"element_id\\":\\"tiin509\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"xup7509\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_height\\":\\"500\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"700\\",\\"param_image\\":\\"lightbox\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/building-design-3.jpg\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"300\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/building-design-3-300x200.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"height_image\\":\\"200\\",\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"25\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\"}}}]},{\\"element_id\\":\\"qvn9509\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"9emu510\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_height\\":\\"500\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"700\\",\\"param_image\\":\\"lightbox\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/building-design-2.jpg\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"300\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/building-design-2-300x200.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"height_image\\":\\"200\\",\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"25\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"}}}]},{\\"element_id\\":\\"e6ab510\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"cy5l510\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_height\\":\\"500\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"700\\",\\"param_image\\":\\"lightbox\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/building-design-1.jpg\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"300\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/building-design-1-300x200.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"height_image\\":\\"200\\"}}]}],\\"styling\\":{\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"40\\",\\"margin_opp_top\\":false}},{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"d4pu49\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"#d1d1d1\\",\\"divider_width\\":\\"150\\",\\"divider_type\\":\\"fullwidth\\",\\"bottom_margin_divider\\":\\"20\\",\\"top_margin_divider\\":\\"20\\",\\"style_divider\\":\\"solid\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"yvts633\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Design &amp; Drawing<\\\\/h3>\\\\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.<\\\\/p>\\\\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.<\\\\/p>\\",\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_bottom\\":\\"15\\",\\"line_height_h3_unit\\":\\"em\\",\\"line_height_h3\\":\\"2\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}]}],\\"styling\\":{\\"hide_anchor\\":false,\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"50\\",\\"padding_opp_top\\":false,\\"padding_top\\":\\"113\\",\\"row_anchor\\":\\"design\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"70\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"90\\"},\\"breakpoint_tablet_landscape\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"113\\"}}},{\\"element_id\\":\\"v54o231\\",\\"cols\\":[{\\"element_id\\":\\"hx15233\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"element_id\\":\\"acnd233\\",\\"cols\\":[{\\"element_id\\":\\"uoki234\\",\\"grid_class\\":\\"col-full\\"}]}]},{\\"element_id\\":\\"1yep899\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"yw6i901\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_height\\":\\"500\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"700\\",\\"param_image\\":\\"lightbox\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/roofing-top.jpg\\",\\"auto_fullwidth\\":\\"1\\",\\"width_image\\":\\"740\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/roofing-top-740x555.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"25\\",\\"margin_opp_top\\":false}},{\\"element_id\\":\\"9sfd901\\",\\"cols\\":[{\\"element_id\\":\\"4hwr903\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"2ec8903\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_height\\":\\"500\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"700\\",\\"param_image\\":\\"lightbox\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/roofing-5.jpg\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"300\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/roofing-5-300x200.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"height_image\\":\\"200\\",\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"25\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"}}}]},{\\"element_id\\":\\"5awv903\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"vv4s904\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_height\\":\\"500\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"700\\",\\"param_image\\":\\"lightbox\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/roofing-4.jpg\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"300\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/roofing-4-300x200.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"height_image\\":\\"200\\",\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"25\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"}}}]},{\\"element_id\\":\\"hioq904\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"ezgu904\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_height\\":\\"500\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"700\\",\\"param_image\\":\\"lightbox\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/roofing-2.jpg\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"300\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/roofing-2-300x200.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"height_image\\":\\"200\\",\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"25\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"}}}]},{\\"element_id\\":\\"9vrs904\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"o1v7905\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_height\\":\\"500\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"700\\",\\"param_image\\":\\"lightbox\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/roofing-1.jpg\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"300\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/roofing-1-300x200.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"height_image\\":\\"200\\"}}]}],\\"styling\\":{\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"40\\",\\"margin_opp_top\\":false}},{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"reva905\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"#d1d1d1\\",\\"divider_width\\":\\"150\\",\\"divider_type\\":\\"fullwidth\\",\\"bottom_margin_divider\\":\\"20\\",\\"top_margin_divider\\":\\"20\\",\\"style_divider\\":\\"solid\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"4qij906\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Roofing<\\\\/h3>\\\\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.<\\\\/p>\\\\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.<\\\\/p>\\",\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_bottom\\":\\"15\\",\\"line_height_h3_unit\\":\\"em\\",\\"line_height_h3\\":\\"2\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}]}],\\"styling\\":{\\"hide_anchor\\":false,\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"50\\",\\"padding_opp_top\\":false,\\"padding_top\\":\\"80\\",\\"row_anchor\\":\\"roofing\\",\\"cover_color-type\\":\\"color\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"50\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"60\\"},\\"breakpoint_tablet_landscape\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"60\\"}}},{\\"element_id\\":\\"o6cl794\\",\\"cols\\":[{\\"element_id\\":\\"rrhe795\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"element_id\\":\\"iy61796\\",\\"cols\\":[{\\"element_id\\":\\"nid0796\\",\\"grid_class\\":\\"col-full\\"}]}]},{\\"element_id\\":\\"oaco797\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"oqui798\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_height\\":\\"500\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"700\\",\\"param_image\\":\\"lightbox\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/complete-rebuild-1.jpg\\",\\"auto_fullwidth\\":\\"1\\",\\"width_image\\":\\"740\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/complete-rebuild-1-740x555.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"25\\",\\"margin_opp_top\\":false}},{\\"element_id\\":\\"4hnw798\\",\\"cols\\":[{\\"element_id\\":\\"8u1f799\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"zq75799\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_height\\":\\"500\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"700\\",\\"param_image\\":\\"lightbox\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/complete-rebuild-2.jpg\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"300\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/complete-rebuild-2-300x200.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"height_image\\":\\"200\\",\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"25\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"}}}]},{\\"element_id\\":\\"ka05799\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"9xzz799\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_height\\":\\"500\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"700\\",\\"param_image\\":\\"lightbox\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/complete-rebuild-3.jpg\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"300\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/complete-rebuild-3-300x200.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"height_image\\":\\"200\\",\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"25\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"}}}]},{\\"element_id\\":\\"rgnw800\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"bl8t800\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_height\\":\\"500\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"700\\",\\"param_image\\":\\"lightbox\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/complete-rebuild-4.jpg\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"300\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/complete-rebuild-4-300x200.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"height_image\\":\\"200\\",\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"25\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"}}}]},{\\"element_id\\":\\"86zx800\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"e1q0803\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_height\\":\\"500\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"700\\",\\"param_image\\":\\"lightbox\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/complete-rebuild-5.jpg\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"300\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/complete-rebuild-5-300x200.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"height_image\\":\\"200\\"}}]}],\\"styling\\":{\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"40\\",\\"margin_opp_top\\":false}},{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"lk78803\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"#d1d1d1\\",\\"divider_width\\":\\"150\\",\\"divider_type\\":\\"fullwidth\\",\\"bottom_margin_divider\\":\\"20\\",\\"top_margin_divider\\":\\"20\\",\\"style_divider\\":\\"solid\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"78cm803\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Complete Rebuild<\\\\/h3>\\\\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.<\\\\/p>\\\\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.<\\\\/p>\\",\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_bottom\\":\\"15\\",\\"line_height_h3_unit\\":\\"em\\",\\"line_height_h3\\":\\"2\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}]}],\\"styling\\":{\\"hide_anchor\\":false,\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"50\\",\\"padding_opp_top\\":false,\\"padding_top\\":\\"80\\",\\"row_anchor\\":\\"rebuild\\",\\"cover_color-type\\":\\"color\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"50\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"60\\"},\\"breakpoint_tablet_landscape\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"60\\"}}},{\\"element_id\\":\\"wp0w269\\",\\"cols\\":[{\\"element_id\\":\\"80u1271\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"element_id\\":\\"bq0g271\\",\\"cols\\":[{\\"element_id\\":\\"hdls272\\",\\"grid_class\\":\\"col-full\\"}]}]},{\\"element_id\\":\\"u639273\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"ja2f273\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_height\\":\\"500\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"700\\",\\"param_image\\":\\"lightbox\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/design-interior-5.jpg\\",\\"auto_fullwidth\\":\\"1\\",\\"width_image\\":\\"740\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/design-interior-5-740x555.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"25\\",\\"margin_opp_top\\":false}},{\\"element_id\\":\\"rlej274\\",\\"cols\\":[{\\"element_id\\":\\"0wzk275\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"2l43275\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_height\\":\\"500\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"700\\",\\"param_image\\":\\"lightbox\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/design-interior-4.jpg\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"300\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/design-interior-4-300x200.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"height_image\\":\\"200\\",\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"25\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"}}}]},{\\"element_id\\":\\"w0sl275\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"5h93275\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_height\\":\\"500\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"700\\",\\"param_image\\":\\"lightbox\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/design-interior-3.jpg\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"300\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/design-interior-3-300x200.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"height_image\\":\\"200\\",\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"25\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"}}}]},{\\"element_id\\":\\"57j2276\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"2x36276\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_height\\":\\"500\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"700\\",\\"param_image\\":\\"lightbox\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/design-interior-2-1.jpg\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"300\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/design-interior-2-1-300x200.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"height_image\\":\\"200\\",\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"25\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"}}}]},{\\"element_id\\":\\"ie7g276\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"4wcu277\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_height\\":\\"500\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"700\\",\\"param_image\\":\\"lightbox\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/design-interior-1.jpg\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"300\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/design-interior-1-300x200.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"height_image\\":\\"200\\"}}]}],\\"styling\\":{\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"40\\",\\"margin_opp_top\\":false}},{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"bpfq277\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"#d1d1d1\\",\\"divider_width\\":\\"150\\",\\"divider_type\\":\\"fullwidth\\",\\"bottom_margin_divider\\":\\"20\\",\\"top_margin_divider\\":\\"20\\",\\"style_divider\\":\\"solid\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"59s8278\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Interior Design<\\\\/h3>\\\\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.<\\\\/p>\\\\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.<\\\\/p>\\",\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_bottom\\":\\"15\\",\\"line_height_h3_unit\\":\\"em\\",\\"line_height_h3\\":\\"2\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}]}],\\"styling\\":{\\"hide_anchor\\":false,\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"50\\",\\"padding_opp_top\\":false,\\"padding_top\\":\\"80\\",\\"row_anchor\\":\\"interior\\",\\"cover_color-type\\":\\"color\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"50\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"60\\"},\\"breakpoint_tablet_landscape\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"60\\"}}},{\\"element_id\\":\\"5y31868\\",\\"cols\\":[{\\"element_id\\":\\"7q2v870\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"element_id\\":\\"7fn5870\\",\\"cols\\":[{\\"element_id\\":\\"yp57871\\",\\"grid_class\\":\\"col-full\\"}]}]},{\\"element_id\\":\\"sij9872\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"a30k873\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_height\\":\\"500\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"700\\",\\"param_image\\":\\"lightbox\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/windows-doors-1.jpg\\",\\"auto_fullwidth\\":\\"1\\",\\"width_image\\":\\"740\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/windows-doors-1-740x555.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"25\\",\\"margin_opp_top\\":false}},{\\"element_id\\":\\"ml3j873\\",\\"cols\\":[{\\"element_id\\":\\"20td874\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"l22c874\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_height\\":\\"500\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"700\\",\\"param_image\\":\\"lightbox\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/windows-doors-2.jpg\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"300\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/windows-doors-2-300x200.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"height_image\\":\\"200\\",\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"25\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"}}}]},{\\"element_id\\":\\"v9sy874\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"eutz875\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_height\\":\\"500\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"700\\",\\"param_image\\":\\"lightbox\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/windows-doors-3.jpg\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"300\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/windows-doors-3-300x200.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"height_image\\":\\"200\\",\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"25\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"}}}]},{\\"element_id\\":\\"8ivl875\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"qtsu875\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_height\\":\\"500\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"700\\",\\"param_image\\":\\"lightbox\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/windows-doors-4.jpg\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"300\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/windows-doors-4-300x200.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"height_image\\":\\"200\\",\\"breakpoint_mobile\\":{\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_opp_left\\":false,\\"margin_bottom_unit\\":\\"px\\",\\"margin_bottom\\":\\"25\\",\\"margin_right_unit\\":\\"px\\",\\"margin_opp_top\\":false,\\"margin_top_unit\\":\\"px\\"}}}]},{\\"element_id\\":\\"kvv9875\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"s7z8876\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"zoom\\",\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_height\\":\\"500\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_width\\":\\"700\\",\\"param_image\\":\\"lightbox\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/windows-doors-5.jpg\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"300\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/windows-doors-5-300x200.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"height_image\\":\\"200\\"}}]}],\\"styling\\":{\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"40\\",\\"margin_opp_top\\":false}},{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"htsf876\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"#d1d1d1\\",\\"divider_width\\":\\"150\\",\\"divider_type\\":\\"fullwidth\\",\\"bottom_margin_divider\\":\\"20\\",\\"top_margin_divider\\":\\"20\\",\\"style_divider\\":\\"solid\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ogfd876\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Windows &amp; Doors<\\\\/h3>\\\\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.<\\\\/p>\\\\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.<\\\\/p>\\",\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_bottom\\":\\"15\\",\\"line_height_h3_unit\\":\\"em\\",\\"line_height_h3\\":\\"2\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}]}],\\"styling\\":{\\"hide_anchor\\":false,\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"130\\",\\"padding_opp_top\\":false,\\"padding_top\\":\\"80\\",\\"row_anchor\\":\\"windows\\",\\"cover_color-type\\":\\"color\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"130\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"50\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"130\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"60\\"},\\"breakpoint_tablet_landscape\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"130\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"60\\"}}}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 239,
  'post_date' => '2019-11-13 03:23:22',
  'post_date_gmt' => '2019-11-13 03:23:22',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h1>Our Services</h1>
<h3>Dedicated to bringing your the finest designing minds and engineering talent on the market, see how we get the job done with accuracy and precision.</h3>
<img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/design-358x258.jpg" width="358" height="258" alt="design" />
<h3>Design</h3> <p>Our award-winning team of architects tackle each project with passionate and creativity.</p> <h4><a href="https://themify.me/demo/themes/ultra-construction/service-2/#design">Find Out More 〉</a></h4>
<img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/construction-358x258.jpg" width="358" height="258" alt="construction" />
<h3>Construction</h3> <p>Our contractors and construction team deliver results with precision and accuracy.</p> <h4><a href="https://themify.me/demo/themes/ultra-construction/service-2/#rebuild">Find Out More 〉</a></h4>
<img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/project-management-358x258.jpg" width="358" height="258" alt="project-management" />
<h3>Project Management</h3> <p>Trust our project managers to work with you 1-on-1, each step of the way.</p> <h4><a href="https://themify.me/demo/themes/ultra-construction/service-2/#interior">Find Out More 〉</a></h4>
<img src="https://themify.me/demo/themes/ultra-construction/files/2019/11/construction-planning-358x258.jpg" width="358" height="258" alt="construction-planning" />
<h3>Construction Planning</h3> <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p> <h4><a href="https://themify.me/demo/themes/ultra-construction/service-2/#roofing">Find Out More 〉</a></h4>
<img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/construction-358x258.jpg" width="358" height="258" alt="construction" />
<h3>Power and Energy</h3> <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p> <h4><a href="https://themify.me/demo/themes/ultra-construction/service-2/#windows">Find Out More 〉</a></h4>
<img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/project-management-358x258.jpg" width="358" height="258" alt="project-management" />
<h3>Office Renovation</h3> <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p> <h4><a href="https://themify.me/demo/themes/ultra-construction/service-2/#interior">Find Out More 〉</a></h4>
<h3>Key Points About Company </h3> <p>We\'re dedicated to excellence and precision - two things that have taken us far in the industry. We pride ourselves on our work, and we do whatever it takes to get the job done. </p>
<a href="https://themify.me/demo/themes/ultra-construction/contact/" > Get a Quote </a><!--/themify_builder_static-->',
  'post_title' => 'Services 1',
  'post_excerpt' => '',
  'post_name' => 'services-1',
  'post_modified' => '2019-12-19 20:34:27',
  'post_modified_gmt' => '2019-12-19 20:34:27',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?page_id=239',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'section_scrolling_mobile' => 'on',
    'mobile_menu_styles' => 'default',
    'header_wrap' => 'transparent',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"kybk555\\",\\"cols\\":[{\\"element_id\\":\\"x101555\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"y9e4254\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>Our Services<\\\\/h1>\\",\\"font_color\\":\\"#ffffff\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_size_h1\\":\\"3\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"text_transform_h1\\":\\"uppercase\\"}}]},{\\"element_id\\":\\"2g0h556\\",\\"grid_class\\":\\"col3-1\\"}],\\"styling\\":{\\"hide_anchor\\":false,\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"160\\",\\"padding_opp_top\\":false,\\"padding_top\\":\\"250\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"fullcover\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/service-header-bg.jpg\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"cover_color\\":\\"#000000_0.52\\",\\"cover_color-type\\":\\"color\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"100\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"135\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"130\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"180\\"}}},{\\"element_id\\":\\"chn8996\\",\\"cols\\":[{\\"element_id\\":\\"ebnr997\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"v9ci155\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Dedicated to bringing your the finest designing minds and engineering talent on the market, see how we get the job done with accuracy and precision.<\\\\/h3>\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"24\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"40\\",\\"margin_opp_top\\":false,\\"padding_opp_left\\":false,\\"padding_opp_top\\":false}},{\\"element_id\\":\\"cbde385\\",\\"cols\\":[{\\"element_id\\":\\"j0uv388\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"5pri389\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"height_image\\":\\"258\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"358\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/design-358x258.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"margin_opp_left\\":false,\\"margin_opp_top\\":false,\\"i_t_m_opp_left\\":false,\\"i_t_m_opp_top\\":false}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"vhcn390\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Design<\\\\/h3>\\\\n<p>Our award-winning team of architects tackle each project with passionate and creativity.<\\\\/p>\\\\n<h4><a href=\\\\\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/service-2\\\\/#design\\\\\\">Find Out More 〉<\\\\/a><\\\\/h4>\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"20\\",\\"background_repeat\\":\\"repeat\\",\\"background_color\\":\\"#ffffff\\",\\"background_image-circle-radial\\":false,\\"background_image-type\\":\\"image\\",\\"margin_left\\":\\"30\\",\\"margin_opp_left\\":false,\\"margin_right\\":\\"30\\",\\"margin_opp_top\\":false,\\"padding_left\\":\\"20\\",\\"padding_bottom\\":\\"20\\",\\"padding_right\\":\\"20\\",\\"global_styles\\":\\"tb_gs345da\\",\\"text_transform_h3\\":\\"uppercase\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"margin_top\\":\\"-50\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_size_h4\\":\\"14\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\"}}],\\"styling\\":{\\"text_align\\":\\"center\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"30\\",\\"margin-top_opp_top\\":false,\\"breakpoint_mobile\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"40\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"px\\"}}},{\\"element_id\\":\\"aobz390\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"yuml390\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"height_image\\":\\"258\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"358\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/construction-358x258.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"i_t_m_opp_left\\":false,\\"i_t_m_opp_top\\":false,\\"margin_opp_left\\":false,\\"margin_opp_top\\":false,\\"i_t_b-type\\":\\"top\\",\\"i_t_p_opp_left\\":false,\\"i_t_p_opp_top\\":false,\\"title_margin_opp_left\\":false,\\"title_margin_opp_top\\":false,\\"padding_opp_left\\":false,\\"padding_opp_top\\":false}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"y7qi391\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Construction<\\\\/h3>\\\\n<p>Our contractors and construction team deliver results with precision and accuracy.<\\\\/p>\\\\n<h4><a href=\\\\\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/service-2\\\\/#rebuild\\\\\\">Find Out More 〉<\\\\/a><\\\\/h4>\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"20\\",\\"background_repeat\\":\\"repeat\\",\\"background_color\\":\\"#ffffff\\",\\"background_image-circle-radial\\":false,\\"background_image-type\\":\\"image\\",\\"margin_left\\":\\"30\\",\\"margin_opp_left\\":false,\\"margin_right\\":\\"30\\",\\"margin_opp_top\\":false,\\"padding_left\\":\\"20\\",\\"padding_bottom\\":\\"20\\",\\"padding_right\\":\\"20\\",\\"global_styles\\":\\"tb_gs345da\\",\\"text_transform_h3\\":\\"uppercase\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"margin_top\\":\\"-50\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_size_h4\\":\\"14\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\"}}],\\"styling\\":{\\"text_align\\":\\"center\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"30\\",\\"margin-top_opp_top\\":false,\\"breakpoint_mobile\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"40\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"px\\"}}},{\\"element_id\\":\\"7n39391\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"62rd391\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"height_image\\":\\"258\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"358\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/project-management-358x258.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"i_t_m_opp_left\\":false,\\"i_t_m_opp_top\\":false,\\"margin_opp_left\\":false,\\"margin_opp_top\\":false}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"8l1t391\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Project Management<\\\\/h3>\\\\n<p>Trust our project managers to work with you 1-on-1, each step of the way.<\\\\/p>\\\\n<h4><a href=\\\\\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/service-2\\\\/#interior\\\\\\">Find Out More 〉<\\\\/a><\\\\/h4>\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":20,\\"background_repeat\\":\\"repeat\\",\\"background_color\\":\\"#ffffff\\",\\"background_image-circle-radial\\":false,\\"background_image-type\\":\\"image\\",\\"margin_left\\":\\"30\\",\\"margin_opp_left\\":false,\\"margin_right\\":\\"30\\",\\"margin_opp_top\\":false,\\"margin_top\\":-53,\\"padding_left\\":\\"20\\",\\"padding_bottom\\":\\"20\\",\\"padding_right\\":\\"20\\",\\"global_styles\\":\\"tb_gs345da\\",\\"padding_top_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"text_transform_h3\\":\\"uppercase\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_size_h4\\":\\"14\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\"}}],\\"styling\\":{\\"text_align\\":\\"center\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"30\\",\\"margin-top_opp_top\\":false,\\"breakpoint_mobile\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"40\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"px\\"}}}],\\"col_tablet\\":\\"column3-1\\",\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"margin_opp_left\\":false,\\"margin_opp_top\\":false}},{\\"element_id\\":\\"5eoh461\\",\\"cols\\":[{\\"element_id\\":\\"be1q463\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"375u463\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"height_image\\":\\"258\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"358\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/construction-planning-358x258.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"margin_opp_left\\":false,\\"margin_opp_top\\":false,\\"i_t_m_opp_left\\":false,\\"i_t_m_opp_top\\":false}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"jjd4464\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Construction Planning<\\\\/h3>\\\\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.<\\\\/p>\\\\n<h4><a href=\\\\\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/service-2\\\\/#roofing\\\\\\">Find Out More 〉<\\\\/a><\\\\/h4>\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"20\\",\\"background_repeat\\":\\"repeat\\",\\"background_color\\":\\"#ffffff\\",\\"background_image-circle-radial\\":false,\\"background_image-type\\":\\"image\\",\\"margin_left\\":\\"30\\",\\"margin_opp_left\\":false,\\"margin_right\\":\\"30\\",\\"margin_opp_top\\":false,\\"padding_left\\":\\"20\\",\\"padding_bottom\\":\\"20\\",\\"padding_right\\":\\"20\\",\\"global_styles\\":\\"tb_gs345da\\",\\"text_transform_h3\\":\\"uppercase\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"margin_top\\":\\"-50\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_size_h4\\":\\"14\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\"}}],\\"styling\\":{\\"text_align\\":\\"center\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"30\\",\\"margin-top_opp_top\\":false,\\"breakpoint_mobile\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"40\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"px\\"}}},{\\"element_id\\":\\"otug464\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"sczb464\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"height_image\\":\\"258\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"358\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/construction-358x258.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"i_t_m_opp_left\\":false,\\"i_t_m_opp_top\\":false,\\"margin_opp_left\\":false,\\"margin_opp_top\\":false,\\"i_t_b-type\\":\\"top\\",\\"i_t_p_opp_left\\":false,\\"i_t_p_opp_top\\":false,\\"title_margin_opp_left\\":false,\\"title_margin_opp_top\\":false,\\"padding_opp_left\\":false,\\"padding_opp_top\\":false}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"wmtz465\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Power and Energy<\\\\/h3>\\\\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.<\\\\/p>\\\\n<h4><a href=\\\\\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/service-2\\\\/#windows\\\\\\">Find Out More 〉<\\\\/a><\\\\/h4>\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"20\\",\\"background_repeat\\":\\"repeat\\",\\"background_color\\":\\"#ffffff\\",\\"background_image-circle-radial\\":false,\\"background_image-type\\":\\"image\\",\\"margin_left\\":\\"30\\",\\"margin_opp_left\\":false,\\"margin_right\\":\\"30\\",\\"margin_opp_top\\":false,\\"padding_left\\":\\"20\\",\\"padding_bottom\\":\\"20\\",\\"padding_right\\":\\"20\\",\\"global_styles\\":\\"tb_gs345da\\",\\"text_transform_h3\\":\\"uppercase\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"margin_top\\":\\"-50\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_size_h4\\":\\"14\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type\\":\\"font_color_solid\\"}}],\\"styling\\":{\\"text_align\\":\\"center\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"30\\",\\"margin-top_opp_top\\":false,\\"breakpoint_mobile\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"40\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"px\\"}}},{\\"element_id\\":\\"zy36465\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"k11r466\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"height_image\\":\\"258\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"358\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/project-management-358x258.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"i_t_m_opp_left\\":false,\\"i_t_m_opp_top\\":false,\\"margin_opp_left\\":false,\\"margin_opp_top\\":false}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"wiki466\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Office Renovation<\\\\/h3>\\\\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.<\\\\/p>\\\\n<h4><a href=\\\\\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/service-2\\\\/#interior\\\\\\">Find Out More 〉<\\\\/a><\\\\/h4>\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":20,\\"background_repeat\\":\\"repeat\\",\\"background_color\\":\\"#ffffff\\",\\"background_image-circle-radial\\":false,\\"background_image-type\\":\\"image\\",\\"margin_left\\":\\"30\\",\\"margin_opp_left\\":false,\\"margin_right\\":\\"30\\",\\"margin_opp_top\\":false,\\"margin_top\\":-53,\\"padding_left\\":\\"20\\",\\"padding_bottom\\":\\"20\\",\\"padding_right\\":\\"20\\",\\"global_styles\\":\\"tb_gs345da\\",\\"padding_top_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\",\\"text_transform_h3\\":\\"uppercase\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_size_h4\\":\\"14\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\"}}],\\"styling\\":{\\"text_align\\":\\"center\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"30\\",\\"margin-top_opp_top\\":false}}],\\"col_tablet\\":\\"column3-1\\",\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"margin_opp_left\\":false,\\"margin_opp_top\\":false}}],\\"styling\\":{\\"text_align\\":\\"center\\"}}],\\"styling\\":{\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"113\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top\\":\\"113\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"70\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"70\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"90\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"90\\"}}},{\\"element_id\\":\\"w759637\\",\\"cols\\":[{\\"element_id\\":\\"r2wg638\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"vod3556\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Key Points About Company <\\\\/h3>\\\\n<p>We\\\'re dedicated to excellence and precision - two things that have taken us far in the industry. We pride ourselves on our work, and we do whatever it takes to get the job done. <\\\\/p>\\",\\"font_color\\":\\"#ffffff\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_size_h1\\":\\"3\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"40\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"text_transform_h3\\":\\"uppercase\\",\\"font_size_unit\\":\\"px\\",\\"font_size\\":\\"20\\",\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_bottom\\":\\"20\\",\\"breakpoint_mobile\\":{\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_bottom\\":\\"20\\",\\"h3_margin_top_unit\\":\\"px\\",\\"t_shh3_blur_unit\\":\\"px\\",\\"t_shh3_vShadow_unit\\":\\"px\\",\\"t_shh3_hShadow_unit\\":\\"px\\",\\"text_transform_h3\\":\\"uppercase\\",\\"letter_spacing_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"36\\",\\"font_gradient_color_h3-circle-radial\\":false,\\"font_gradient_color_h3-gradient-angle\\":\\"180\\",\\"font_gradient_color_h3-gradient-type\\":\\"linear\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"hhlw272\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"Get a Quote\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/contact\\\\/\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\",\\"button_color_bg\\":\\"orange\\",\\"icon_alignment\\":\\"left\\"}],\\"display\\":\\"buttons-horizontal\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"solid\\"}}]},{\\"element_id\\":\\"7ai637\\",\\"grid_class\\":\\"col3-1\\"}],\\"styling\\":{\\"hide_anchor\\":false,\\"row_width\\":\\"fullwidth\\",\\"cover_color-type\\":\\"color\\",\\"background_position\\":\\"50,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"fullcover\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/11\\\\/bg-key-points.jpg\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"200\\",\\"padding_opp_top\\":false,\\"padding_top\\":\\"150\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"180\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"70\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"170\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"100\\"},\\"breakpoint_tablet_landscape\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"200\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"150\\"}}}]',
    'themify_used_global_styles' => 
    array (
      0 => 'tb_gs345da',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 227,
  'post_date' => '2019-11-12 15:09:12',
  'post_date_gmt' => '2019-11-12 15:09:12',
  'post_content' => '<!--themify_builder_static--><h4>Get in touch</h4> <p>111 George St<br />Toronto, ON</p>
<h4>Call Us</h4> <p>SUPPORT: 123 716 6879 <br />OFFICE: +61 (123) 716 6879</p>
<a href="https://themify.me/demo/themes/ultra-construction/contact/" > Get a quote </a><!--/themify_builder_static-->',
  'post_title' => 'Contact Info',
  'post_excerpt' => '',
  'post_name' => 'contact-info',
  'post_modified' => '2019-12-19 20:26:35',
  'post_modified_gmt' => '2019-12-19 20:26:35',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?post_type=tbuilder_layout_part&#038;p=227',
  'menu_order' => 0,
  'post_type' => 'tbuilder_layout_part',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"u2ok248\\",\\"cols\\":[{\\"element_id\\":\\"x3sw249\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"gjnr250\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>Get in touch<\\\\/h4>\\\\n<p>111 George St<br \\\\/>Toronto, ON<\\\\/p>\\",\\"breakpoint_tablet\\":{\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_top_unit\\":\\"px\\",\\"t_shh3_blur_unit\\":\\"px\\",\\"t_shh3_vShadow_unit\\":\\"px\\",\\"t_shh3_hShadow_unit\\":\\"px\\",\\"letter_spacing_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_gradient_color_h3-circle-radial\\":false,\\"font_gradient_color_h3-gradient-angle\\":\\"180\\",\\"font_gradient_color_h3-gradient-type\\":\\"linear\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"h2_margin_bottom_unit\\":\\"px\\",\\"h2_margin_top_unit\\":\\"px\\",\\"t_shh2_blur_unit\\":\\"px\\",\\"t_shh2_vShadow_unit\\":\\"px\\",\\"t_shh2_hShadow_unit\\":\\"px\\",\\"letter_spacing_h2_unit\\":\\"px\\",\\"line_height_h2_unit\\":\\"px\\",\\"font_size_h2_unit\\":\\"px\\",\\"font_gradient_color_h2-circle-radial\\":false,\\"font_gradient_color_h2-gradient-angle\\":\\"180\\",\\"font_gradient_color_h2-gradient-type\\":\\"linear\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"h1_margin_bottom_unit\\":\\"px\\",\\"h1_margin_top_unit\\":\\"px\\",\\"t_shh1_blur_unit\\":\\"px\\",\\"t_shh1_vShadow_unit\\":\\"px\\",\\"t_shh1_hShadow_unit\\":\\"px\\",\\"letter_spacing_h1_unit\\":\\"px\\",\\"line_height_h1_unit\\":\\"px\\",\\"font_size_h1_unit\\":\\"px\\",\\"font_gradient_color_h1-circle-radial\\":false,\\"font_gradient_color_h1-gradient-angle\\":\\"180\\",\\"font_gradient_color_h1-gradient-type\\":\\"linear\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"p_margin_bottom_unit\\":\\"px\\",\\"p_margin_top_unit\\":\\"px\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_size\\":\\"14\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\"}}}],\\"styling\\":{\\"background_color\\":\\"#f69c32\\",\\"background_position\\":\\"100,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"font_color\\":\\"#ffffff\\",\\"padding_right\\":\\"102\\",\\"padding_left\\":\\"30\\",\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"40\\",\\"padding_opp_top\\":false,\\"padding_top\\":60,\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/location.png\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#000000\\",\\"border-type\\":\\"right\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_left\\":\\"0\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"40\\",\\"padding_right_unit\\":\\"px\\",\\"padding_right\\":\\"0\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"60\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"px\\",\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#000000\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"right\\"},\\"padding_top_unit\\":\\"px\\",\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_left\\":\\"0\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"40\\",\\"padding_right_unit\\":\\"px\\",\\"padding_right\\":\\"0\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"60\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"text_align\\":\\"center\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_color\\":\\"#ffffff\\"},\\"breakpoint_tablet_landscape\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_left\\":\\"0\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"40\\",\\"padding_right_unit\\":\\"px\\",\\"padding_right\\":\\"0\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"60\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"text_align\\":\\"center\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_color\\":\\"#ffffff\\"}}},{\\"element_id\\":\\"czxc252\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"q2ru13\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>Call Us<\\\\/h4>\\\\n<p>SUPPORT: 123 716 6879 <br \\\\/>OFFICE: +61 (123) 716 6879<\\\\/p>\\",\\"background_position\\":\\"50,50\\",\\"background_repeat\\":\\"repeat\\",\\"background_image-circle-radial\\":false,\\"background_image-type\\":\\"image\\",\\"breakpoint_tablet\\":{\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_top_unit\\":\\"px\\",\\"t_shh3_blur_unit\\":\\"px\\",\\"t_shh3_vShadow_unit\\":\\"px\\",\\"t_shh3_hShadow_unit\\":\\"px\\",\\"letter_spacing_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_gradient_color_h3-circle-radial\\":false,\\"font_gradient_color_h3-gradient-angle\\":\\"180\\",\\"font_gradient_color_h3-gradient-type\\":\\"linear\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"h2_margin_bottom_unit\\":\\"px\\",\\"h2_margin_top_unit\\":\\"px\\",\\"t_shh2_blur_unit\\":\\"px\\",\\"t_shh2_vShadow_unit\\":\\"px\\",\\"t_shh2_hShadow_unit\\":\\"px\\",\\"letter_spacing_h2_unit\\":\\"px\\",\\"line_height_h2_unit\\":\\"px\\",\\"font_size_h2_unit\\":\\"px\\",\\"font_gradient_color_h2-circle-radial\\":false,\\"font_gradient_color_h2-gradient-angle\\":\\"180\\",\\"font_gradient_color_h2-gradient-type\\":\\"linear\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"h1_margin_bottom_unit\\":\\"px\\",\\"h1_margin_top_unit\\":\\"px\\",\\"t_shh1_blur_unit\\":\\"px\\",\\"t_shh1_vShadow_unit\\":\\"px\\",\\"t_shh1_hShadow_unit\\":\\"px\\",\\"letter_spacing_h1_unit\\":\\"px\\",\\"line_height_h1_unit\\":\\"px\\",\\"font_size_h1_unit\\":\\"px\\",\\"font_gradient_color_h1-circle-radial\\":false,\\"font_gradient_color_h1-gradient-angle\\":\\"180\\",\\"font_gradient_color_h1-gradient-type\\":\\"linear\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"p_margin_bottom_unit\\":\\"px\\",\\"p_margin_top_unit\\":\\"px\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_size\\":\\"14\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\"}}}],\\"styling\\":{\\"background_color\\":\\"#f69c32\\",\\"background_position\\":\\"100,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"font_color\\":\\"#ffffff\\",\\"padding_right\\":\\"102\\",\\"padding_left\\":\\"30\\",\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"40\\",\\"padding_opp_top\\":false,\\"padding_top\\":\\"40\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/phone.png\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#000000\\",\\"border-type\\":\\"right\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_left\\":\\"0\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"40\\",\\"padding_right_unit\\":\\"px\\",\\"padding_right\\":\\"0\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"40\\",\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#000000\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"right\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_left\\":\\"0\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"40\\",\\"padding_right_unit\\":\\"px\\",\\"padding_right\\":\\"0\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"40\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"text_align\\":\\"center\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_color\\":\\"#ffffff\\"},\\"breakpoint_tablet_landscape\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_left\\":\\"0\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"40\\",\\"padding_right_unit\\":\\"px\\",\\"padding_right\\":\\"0\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"40\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"text_align\\":\\"center\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_color\\":\\"#ffffff\\"}}},{\\"element_id\\":\\"p7ob253\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"2b63253\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"Get a quote\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/contact\\\\/\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\",\\"icon_alignment\\":\\"left\\"}],\\"alignment\\":\\"center\\",\\"display\\":\\"buttons-horizontal\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"solid\\"}}],\\"styling\\":{\\"background_color\\":\\"#f69c32\\",\\"background_position\\":\\"100,50\\",\\"background_zoom\\":false,\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"font_color\\":\\"#ffffff\\",\\"padding_right\\":\\"102\\",\\"padding_left\\":\\"30\\",\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"40\\",\\"padding_opp_top\\":false,\\"padding_top\\":\\"40\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/email.png\\",\\"border-type\\":\\"right\\",\\"border_right_style\\":\\"none\\",\\"breakpoint_mobile\\":{\\"padding_bottom\\":\\"60\\",\\"padding_bottom_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_left\\":\\"0\\",\\"padding_opp_left\\":false,\\"padding_right_unit\\":\\"px\\",\\"padding_right\\":\\"0\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"40\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_left\\":\\"0\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"40\\",\\"padding_right_unit\\":\\"px\\",\\"padding_right\\":\\"0\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"40\\"},\\"breakpoint_tablet_landscape\\":{\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_left\\":\\"0\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"px\\",\\"padding_bottom\\":\\"40\\",\\"padding_right_unit\\":\\"px\\",\\"padding_right\\":\\"0\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"px\\",\\"padding_top\\":\\"40\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"text_align\\":\\"center\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_color\\":\\"#ffffff\\"}}}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-top_opp_top\\":false,\\"border-type\\":\\"top\\",\\"margin-top_unit\\":\\"%\\",\\"margin-top\\":\\"-8\\",\\"hide_anchor\\":false,\\"margin-bottom\\":\\"80\\",\\"breakpoint_mobile\\":{\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"text_align\\":\\"center\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"80\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"%\\",\\"margin-top\\":\\"-40\\"},\\"breakpoint_tablet\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"80\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"%\\",\\"margin-top\\":\\"-20\\"},\\"breakpoint_tablet_landscape\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"80\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"%\\",\\"margin-top\\":\\"-15\\"}}}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 208,
  'post_date' => '2019-11-12 14:50:02',
  'post_date_gmt' => '2019-11-12 14:50:02',
  'post_content' => '<!--themify_builder_static--><h3>Our Clients<br/></h3>
<img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/repsol-263x96.jpg" width="263" height="96" alt="repsol" />
<img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/global-oil-263x96.jpg" width="263" height="96" alt="global-oil" />
<img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/victoria-263x96.jpg" width="263" height="96" alt="victoria" />
<img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/total-263x96.jpg" width="263" height="96" alt="total" /><!--/themify_builder_static-->',
  'post_title' => 'Our Clients',
  'post_excerpt' => '',
  'post_name' => 'clients',
  'post_modified' => '2019-12-19 20:19:11',
  'post_modified_gmt' => '2019-12-19 20:19:11',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?post_type=tbuilder_layout_part&#038;p=208',
  'menu_order' => 0,
  'post_type' => 'tbuilder_layout_part',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"0l7c330\\",\\"cols\\":[{\\"element_id\\":\\"bf9a331\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"kg96331\\",\\"mod_settings\\":{\\"heading\\":\\"Our Clients\\",\\"divider\\":\\"yes\\",\\"text_alignment\\":\\"themify-text-center\\",\\"heading_tag\\":\\"h3\\",\\"padding_bottom\\":\\"45\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false}},{\\"element_id\\":\\"wda5332\\",\\"cols\\":[{\\"element_id\\":\\"b3v9332\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"76f8333\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"height_image\\":\\"96\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"263\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/repsol.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"global_styles\\":\\"tb_gs345da\\",\\"b_sh_inset\\":false,\\"b_sh_color\\":\\"#000000_0.03\\",\\"b_sh_spread_unit\\":\\"px\\",\\"b_sh_spread\\":\\"10\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_blur\\":\\"10\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"0\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_hOffset\\":\\"0\\",\\"b_ra_opp_left\\":false,\\"b_ra_opp_bottom\\":false,\\"border_top_width\\":\\"1\\",\\"border_top_color\\":\\"#e3e3e3\\",\\"border-type\\":\\"all\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"0\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"20\\",\\"margin_opp_top\\":false}}]},{\\"element_id\\":\\"obuf333\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"jobp333\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"height_image\\":\\"96\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"263\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/global-oil.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"global_styles\\":\\"tb_gs345da\\",\\"b_sh_inset\\":false,\\"b_sh_color\\":\\"#000000_0.03\\",\\"b_sh_spread_unit\\":\\"px\\",\\"b_sh_spread\\":\\"10\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_blur\\":\\"10\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"0\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_hOffset\\":\\"0\\",\\"b_ra_opp_left\\":false,\\"b_ra_opp_bottom\\":false,\\"border_top_width\\":\\"1\\",\\"border_top_color\\":\\"#e3e3e3\\",\\"border-type\\":\\"all\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"0\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"20\\",\\"margin_opp_top\\":false}}]},{\\"element_id\\":\\"myfp334\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"inj1334\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"height_image\\":\\"96\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"263\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/victoria.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"global_styles\\":\\"tb_gs345da\\",\\"b_sh_inset\\":false,\\"b_sh_color\\":\\"#000000_0.03\\",\\"b_sh_spread_unit\\":\\"px\\",\\"b_sh_spread\\":\\"10\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_blur\\":\\"10\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"0\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_hOffset\\":\\"0\\",\\"b_ra_opp_left\\":false,\\"b_ra_opp_bottom\\":false,\\"border_top_width\\":\\"1\\",\\"border_top_color\\":\\"#e3e3e3\\",\\"border-type\\":\\"all\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"0\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"20\\",\\"margin_opp_top\\":false}}]},{\\"element_id\\":\\"z4jp334\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"sqix334\\",\\"mod_settings\\":{\\"image_zoom_icon\\":false,\\"param_image\\":\\"regular\\",\\"height_image\\":\\"96\\",\\"auto_fullwidth\\":false,\\"width_image\\":\\"263\\",\\"appearance_image\\":false,\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/total.jpg\\",\\"caption_on_overlay\\":false,\\"style_image\\":\\"image-center\\",\\"global_styles\\":\\"tb_gs345da\\",\\"b_sh_inset\\":false,\\"b_sh_color\\":\\"#000000_0.03\\",\\"b_sh_spread_unit\\":\\"px\\",\\"b_sh_spread\\":\\"10\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_blur\\":\\"10\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"0\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_hOffset\\":\\"0\\",\\"b_ra_opp_left\\":false,\\"b_ra_opp_bottom\\":false,\\"border_top_width\\":\\"1\\",\\"border_top_color\\":\\"#e3e3e3\\",\\"border-type\\":\\"all\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"0\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"20\\",\\"margin_opp_top\\":false}}]}],\\"col_tablet\\":\\"column4-2\\",\\"styling\\":{\\"padding_opp_left\\":false,\\"padding_opp_top\\":false}}]}],\\"styling\\":{\\"hide_anchor\\":false,\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"margin-top_opp_top\\":false}}]',
    'themify_used_global_styles' => 
    array (
      0 => 'tb_gs345da',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 201,
  'post_date' => '2019-11-12 14:44:49',
  'post_date_gmt' => '2019-11-12 14:44:49',
  'post_content' => '',
  'post_title' => 'Image With Title',
  'post_excerpt' => '',
  'post_name' => 'tb_gs2015dc',
  'post_modified' => '2019-11-12 14:44:49',
  'post_modified_gmt' => '2019-11-12 14:44:49',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/tglobal-style/image-with-title/',
  'menu_order' => 0,
  'post_type' => 'tglobal_style',
  'meta_input' => 
  array (
    'themify_global_style_type' => 'image',
    'hide_page_title' => 'yes',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"row5dcac561a532d\\",\\"styling\\":[],\\"cols\\":[{\\"element_id\\":\\"col5dcac561a532d\\",\\"grid_class\\":\\"col-full\\",\\"styling\\":[],\\"modules\\":[{\\"element_id\\":\\"mod5dcac561a532d\\",\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"false\\",\\"param_image\\":\\"regular\\",\\"height_image\\":\\"258\\",\\"auto_fullwidth\\":\\"false\\",\\"width_image\\":\\"358\\",\\"appearance_image\\":\\"false\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/design-358x258.jpg\\",\\"caption_on_overlay\\":\\"false\\",\\"style_image\\":\\"image-center\\",\\"i_t_m_opp_left\\":\\"false\\",\\"i_t_m_bottom\\":\\"20\\",\\"i_t_m_opp_top\\":\\"false\\",\\"margin_opp_left\\":\\"false\\",\\"margin_opp_top\\":\\"false\\"}}]}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    '_wp_old_slug' => 'image-with-title',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 34,
  'post_date' => '2019-10-12 06:50:26',
  'post_date_gmt' => '2019-10-12 06:50:26',
  'post_content' => '<!--themify_builder_static--><img src="https://themify.me/demo/themes/ultra-construction/files/2019/10/sutainable-process-80x80.png" width="80" height="80" title="Allow User to Sutainable Practices" alt="Allow User to Sutainable Practices" /> <h3> Allow User to Sutainable Practices </h3><!--/themify_builder_static-->',
  'post_title' => 'shadow',
  'post_excerpt' => '',
  'post_name' => 'tb_gs345da',
  'post_modified' => '2019-10-16 11:14:12',
  'post_modified_gmt' => '2019-10-16 11:14:12',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/tglobal-style/shadow/',
  'menu_order' => 0,
  'post_type' => 'tglobal_style',
  'meta_input' => 
  array (
    'themify_global_style_type' => 'image',
    'hide_page_title' => 'yes',
    '_wp_old_slug' => 'shadow',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"row5da177b2164b1\\",\\"cols\\":[{\\"element_id\\":\\"col5da177b2164b1\\",\\"modules\\":[{\\"element_id\\":\\"mod5da177b2164b1\\",\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"image_zoom_icon\\":\\"false\\",\\"param_image\\":\\"regular\\",\\"title_image\\":\\"Allow User to Sutainable  Practices\\",\\"height_image\\":\\"80\\",\\"auto_fullwidth\\":\\"false\\",\\"width_image\\":\\"80\\",\\"appearance_image\\":\\"false\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-construction\\\\/files\\\\/2019\\\\/10\\\\/sutainable-process.png\\",\\"caption_on_overlay\\":\\"false\\",\\"style_image\\":\\"image-left\\",\\"b_sh_inset\\":\\"false\\",\\"b_sh_color\\":\\"#000000_0.17\\",\\"b_sh_spread_unit\\":\\"px\\",\\"b_sh_spread\\":\\"0\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_blur\\":\\"10\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"3\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_hOffset\\":\\"0\\",\\"border_top_width\\":\\"1\\",\\"border_top_color\\":\\"#f7f7f7\\",\\"border-type\\":\\"all\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"margin_opp_left\\":\\"false\\",\\"margin_bottom\\":\\"20\\",\\"margin_opp_top\\":\\"false\\",\\"padding_opp_left\\":\\"false\\",\\"padding_opp_top\\":\\"false\\",\\"padding_top\\":\\"25\\",\\"title_margin_left\\":\\"10\\",\\"title_margin_opp_left\\":\\"false\\",\\"title_margin_opp_top\\":\\"false\\",\\"title_margin_top\\":\\"25\\",\\"padding_left\\":\\"30\\",\\"padding_bottom\\":\\"14\\",\\"padding_right\\":\\"20\\",\\"sh_h_inset\\":\\"false\\",\\"sh_h_color\\":\\"#000000_0.11\\",\\"sh_h_spread_unit\\":\\"px\\",\\"sh_h_spread\\":\\"0\\",\\"sh_h_blur_unit\\":\\"px\\",\\"sh_h_blur\\":\\"50\\",\\"sh_h_vOffset_unit\\":\\"px\\",\\"sh_h_vOffset\\":\\"3\\",\\"sh_h_hOffset_unit\\":\\"px\\",\\"sh_h_hOffset\\":\\"0\\"}}]}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 442,
  'post_date' => '2019-11-16 03:01:03',
  'post_date_gmt' => '2019-11-16 03:01:03',
  'post_content' => 'Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.<span id="more-825"></span>

Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.

Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur? voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus.',
  'post_title' => ' Nemo enim ipsam',
  'post_excerpt' => '',
  'post_name' => 'nemo-enim-ipsam',
  'post_modified' => '2019-11-16 03:01:03',
  'post_modified_gmt' => '2019-11-16 03:01:03',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?post_type=portfolio&#038;p=442',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"w0wb800\\",\\"cols\\":[{\\"element_id\\":\\"5xko802\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'mechanical',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-construction/files/2019/11/iron-cast-factory.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 441,
  'post_date' => '2019-11-16 02:58:54',
  'post_date_gmt' => '2019-11-16 02:58:54',
  'post_content' => 'Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus.  Ton provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.<span id="more-389"></span>

<span id="more-133"></span>Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur? Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate.',
  'post_title' => 'Sint occaecati cupiditate',
  'post_excerpt' => '',
  'post_name' => 'sint-occaecati-cupiditate',
  'post_modified' => '2019-11-16 02:58:54',
  'post_modified_gmt' => '2019-11-16 02:58:54',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?post_type=portfolio&#038;p=441',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"47l8996\\",\\"cols\\":[{\\"element_id\\":\\"gtuo997\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'construction',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-construction/files/2019/11/paris-bridge-construction.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 439,
  'post_date' => '2019-11-16 02:56:48',
  'post_date_gmt' => '2019-11-16 02:56:48',
  'post_content' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.<span id="more-412"></span>

Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur. Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae.',
  'post_title' => 'Totam rem aperiam',
  'post_excerpt' => '',
  'post_name' => '439',
  'post_modified' => '2019-11-16 02:56:57',
  'post_modified_gmt' => '2019-11-16 02:56:57',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?post_type=portfolio&#038;p=439',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"tigg412\\",\\"cols\\":[{\\"element_id\\":\\"1a9c413\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'industrial',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-construction/files/2019/11/clothing-industrial.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 438,
  'post_date' => '2019-11-16 02:56:04',
  'post_date_gmt' => '2019-11-16 02:56:04',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.<span id="more-406"></span>

inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.',
  'post_title' => 'Sed ut perspiciatis',
  'post_excerpt' => '',
  'post_name' => 'sed-ut-perspiciatis',
  'post_modified' => '2019-11-16 02:56:04',
  'post_modified_gmt' => '2019-11-16 02:56:04',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?post_type=portfolio&#038;p=438',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"bjhd414\\",\\"cols\\":[{\\"element_id\\":\\"mm31416\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'construction',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-construction/files/2019/11/bridge-construction.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 436,
  'post_date' => '2019-11-16 02:54:46',
  'post_date_gmt' => '2019-11-16 02:54:46',
  'post_content' => 'Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatu.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis.',
  'post_title' => 'Magni dolores eos',
  'post_excerpt' => '',
  'post_name' => 'magni-dolores-eos',
  'post_modified' => '2019-11-16 02:54:46',
  'post_modified_gmt' => '2019-11-16 02:54:46',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?post_type=portfolio&#038;p=436',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"0xi2417\\",\\"cols\\":[{\\"element_id\\":\\"vigk418\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'mechanical',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-construction/files/2019/11/big-machine-mechanical.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 435,
  'post_date' => '2019-11-16 02:54:18',
  'post_date_gmt' => '2019-11-16 02:54:18',
  'post_content' => 'Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.<span id="more-825"></span>

Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.

. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur? voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus.',
  'post_title' => 'Itaque earum rerum',
  'post_excerpt' => '',
  'post_name' => 'itaque-earum-rerum',
  'post_modified' => '2019-11-16 02:54:18',
  'post_modified_gmt' => '2019-11-16 02:54:18',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?post_type=portfolio&#038;p=435',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"kzjb288\\",\\"cols\\":[{\\"element_id\\":\\"vwps289\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'industrial',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-construction/files/2019/11/water-industrial.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 434,
  'post_date' => '2019-11-16 02:53:38',
  'post_date_gmt' => '2019-11-16 02:53:38',
  'post_content' => 'Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates.<span id="more-393"></span>

Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?”  repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis.',
  'post_title' => 'Facere possimus',
  'post_excerpt' => '',
  'post_name' => 'facere-possimus',
  'post_modified' => '2019-11-16 02:53:38',
  'post_modified_gmt' => '2019-11-16 02:53:38',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?post_type=portfolio&#038;p=434',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"xs7p513\\",\\"cols\\":[{\\"element_id\\":\\"cw0y515\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'construction',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-construction/files/2019/11/modern-construction.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 418,
  'post_date' => '2019-11-16 02:51:57',
  'post_date_gmt' => '2019-11-16 02:51:57',
  'post_content' => 'Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.recusandae. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.<span id="more-378"></span>

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores.',
  'post_title' => 'Et harum quidem',
  'post_excerpt' => '',
  'post_name' => 'et-harum-quidem',
  'post_modified' => '2019-11-16 02:51:57',
  'post_modified_gmt' => '2019-11-16 02:51:57',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?post_type=portfolio&#038;p=418',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"ynbj351\\",\\"cols\\":[{\\"element_id\\":\\"rt6f353\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'construction',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-construction/files/2019/11/emergency-roof.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 417,
  'post_date' => '2019-11-16 02:38:38',
  'post_date_gmt' => '2019-11-16 02:38:38',
  'post_content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<span id="more-397"></span>

Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.

Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt neque porro quisquam.',
  'post_title' => 'Lorem ipsum dolor',
  'post_excerpt' => '',
  'post_name' => 'lorem-ipsum-dolor',
  'post_modified' => '2019-11-16 02:52:30',
  'post_modified_gmt' => '2019-11-16 02:52:30',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?post_type=portfolio&#038;p=417',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"pj72912\\",\\"cols\\":[{\\"element_id\\":\\"kdqf914\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'industrial',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-construction/files/2019/11/oil-mechanical-mine.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 416,
  'post_date' => '2019-11-16 02:38:03',
  'post_date_gmt' => '2019-11-16 02:38:03',
  'post_content' => 'Labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.<span id="more-401"></span>

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.',
  'post_title' => 'Labore et dolore',
  'post_excerpt' => '',
  'post_name' => 'labore-et-dolore',
  'post_modified' => '2019-11-16 02:52:39',
  'post_modified_gmt' => '2019-11-16 02:52:39',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?post_type=portfolio&#038;p=416',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"6zyi617\\",\\"cols\\":[{\\"element_id\\":\\"c4xb623\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'mechanical',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-construction/files/2019/11/robotic-mechanical.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 410,
  'post_date' => '2019-11-16 02:32:27',
  'post_date_gmt' => '2019-11-16 02:32:27',
  'post_content' => 'Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates.<span id="more-821"></span>

Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?”  repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis.',
  'post_title' => 'Nam libero tempore',
  'post_excerpt' => '',
  'post_name' => 'nam-libero-tempore',
  'post_modified' => '2019-11-16 02:35:18',
  'post_modified_gmt' => '2019-11-16 02:35:18',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?post_type=portfolio&#038;p=410',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"5wgl716\\",\\"cols\\":[{\\"element_id\\":\\"4hvn721\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'construction',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-construction/files/2019/11/construction-crane.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 103,
  'post_date' => '2019-10-15 09:08:32',
  'post_date_gmt' => '2019-10-15 09:08:32',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '103',
  'post_modified' => '2019-11-19 04:32:19',
  'post_modified_gmt' => '2019-11-19 04:32:19',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?p=103',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '5',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 268,
  'post_date' => '2019-11-13 03:59:28',
  'post_date_gmt' => '2019-11-13 03:59:28',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '268',
  'post_modified' => '2019-11-19 04:32:19',
  'post_modified_gmt' => '2019-11-19 04:32:19',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?p=268',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '184',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 267,
  'post_date' => '2019-11-13 03:59:28',
  'post_date_gmt' => '2019-11-13 03:59:28',
  'post_content' => '',
  'post_title' => 'Services',
  'post_excerpt' => '',
  'post_name' => '267',
  'post_modified' => '2019-11-19 04:32:19',
  'post_modified_gmt' => '2019-11-19 04:32:19',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?p=267',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '239',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 394,
  'post_date' => '2019-11-15 13:48:52',
  'post_date_gmt' => '2019-11-15 13:48:52',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '394',
  'post_modified' => '2019-11-19 04:32:19',
  'post_modified_gmt' => '2019-11-19 04:32:19',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?p=394',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '267',
    '_menu_item_object_id' => '317',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 443,
  'post_date' => '2019-11-16 03:03:13',
  'post_date_gmt' => '2019-11-16 03:03:13',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '443',
  'post_modified' => '2019-11-19 04:32:19',
  'post_modified_gmt' => '2019-11-19 04:32:19',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?p=443',
  'menu_order' => 5,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '404',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 306,
  'post_date' => '2019-11-14 17:15:23',
  'post_date_gmt' => '2019-11-14 17:15:23',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '306',
  'post_modified' => '2019-11-19 04:32:19',
  'post_modified_gmt' => '2019-11-19 04:32:19',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?p=306',
  'menu_order' => 6,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '281',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 322,
  'post_date' => '2019-11-15 02:33:54',
  'post_date_gmt' => '2019-11-15 02:33:54',
  'post_content' => '',
  'post_title' => 'Design & Drawing',
  'post_excerpt' => '',
  'post_name' => 'design-drawing',
  'post_modified' => '2019-11-15 02:35:48',
  'post_modified_gmt' => '2019-11-15 02:35:48',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?p=322',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '322',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#design',
    '_menu_item_icon' => 'ti-angle-right',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'service-sticky-menu',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 323,
  'post_date' => '2019-11-15 02:34:25',
  'post_date_gmt' => '2019-11-15 02:34:25',
  'post_content' => '',
  'post_title' => 'Roofing',
  'post_excerpt' => '',
  'post_name' => 'roofing',
  'post_modified' => '2019-11-15 02:35:48',
  'post_modified_gmt' => '2019-11-15 02:35:48',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?p=323',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '323',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#roofing',
    '_menu_item_icon' => 'ti-angle-right',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'service-sticky-menu',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 324,
  'post_date' => '2019-11-15 02:34:52',
  'post_date_gmt' => '2019-11-15 02:34:52',
  'post_content' => '',
  'post_title' => 'Complete Rebuild',
  'post_excerpt' => '',
  'post_name' => 'complete-rebuild',
  'post_modified' => '2019-11-15 02:35:48',
  'post_modified_gmt' => '2019-11-15 02:35:48',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?p=324',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '324',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#rebuild',
    '_menu_item_icon' => 'ti-angle-right',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'service-sticky-menu',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 325,
  'post_date' => '2019-11-15 02:35:19',
  'post_date_gmt' => '2019-11-15 02:35:19',
  'post_content' => '',
  'post_title' => 'Interior Design',
  'post_excerpt' => '',
  'post_name' => 'interior-design',
  'post_modified' => '2019-11-15 02:35:48',
  'post_modified_gmt' => '2019-11-15 02:35:48',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?p=325',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '325',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#interior',
    '_menu_item_icon' => 'ti-angle-right',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'service-sticky-menu',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 326,
  'post_date' => '2019-11-15 02:35:48',
  'post_date_gmt' => '2019-11-15 02:35:48',
  'post_content' => '',
  'post_title' => 'Windows & Doors',
  'post_excerpt' => '',
  'post_name' => 'windows-doors',
  'post_modified' => '2019-11-15 02:35:48',
  'post_modified_gmt' => '2019-11-15 02:35:48',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-construction/?p=326',
  'menu_order' => 5,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '326',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#windows',
    '_menu_item_icon' => 'ti-angle-right',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'service-sticky-menu',
  ),
);
themify_process_post_import( $post );



function themify_import_get_term_id_from_slug( $slug ) {
	$menu = get_term_by( "slug", $slug, "nav_menu" );
	return is_wp_error( $menu ) ? 0 : (int) $menu->term_id;
}

	$widgets = get_option( "widget_text" );
$widgets[1002] = array (
  'title' => '',
  'text' => '<a href="#">Get a quote</a>',
  'filter' => true,
  'visual' => true,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_themify-social-links" );
$widgets[1003] = array (
  'title' => '',
  'show_link_name' => NULL,
  'open_new_window' => NULL,
  'icon_size' => 'icon-medium',
  'orientation' => 'horizontal',
);
update_option( "widget_themify-social-links", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1004] = array (
  'title' => '',
  'text' => 'Free Call: (+61) 123-716-6879',
  'filter' => true,
  'visual' => true,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1005] = array (
  'title' => '',
  'text' => '[themify_button bgcolor="orange" nofollow="no" link="https://themify.me" target="_blank"]Get a Quote[/themify_button]',
  'filter' => true,
  'visual' => true,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_nav_menu" );
$widgets[1006] = array (
  'title' => 'Company',
  'nav_menu' => themify_import_get_term_id_from_slug( "main-navigation" ),
);
update_option( "widget_nav_menu", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1007] = array (
  'title' => 'Contact Us',
  'text' => '111 George St
Toronto, ON Canada

(+1) 123- 716-6879

(+1) 6879- 123- 716

contact@ultra-construction.com

Mon-Fri 09:00 - 17:00',
  'filter' => true,
  'visual' => true,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_media_gallery" );
$widgets[1008] = array (
  'title' => 'Gallery',
  'ids' => 
  array (
    0 => 52,
    1 => 50,
    2 => 53,
    3 => 105,
  ),
  'columns' => 2,
  'size' => 'large',
  'link_type' => 'file',
  'orderby_random' => false,
);
update_option( "widget_media_gallery", $widgets );



$sidebars_widgets = array (
  'header-widget-3' => 
  array (
    0 => 'text-1002',
  ),
  'header-widget-1' => 
  array (
    0 => 'themify-social-links-1003',
  ),
  'header-widget-2' => 
  array (
    0 => 'text-1004',
    1 => 'text-1005',
  ),
  'footer-widget-1' => 
  array (
    0 => 'nav_menu-1006',
  ),
  'footer-widget-2' => 
  array (
    0 => 'text-1007',
  ),
  'footer-widget-3' => 
  array (
    0 => 'media_gallery-1008',
  ),
); 
update_option( "sidebars_widgets", $sidebars_widgets );

$menu_locations = array();
$menu = get_terms( "nav_menu", array( "slug" => "main-navigation" ) );
if( is_array( $menu ) && ! empty( $menu ) ) $menu_locations["main-nav"] = $menu[0]->term_id;
set_theme_mod( "nav_menu_locations", $menu_locations );


$homepage = get_posts( array( 'name' => 'home', 'post_type' => 'page' ) );
			if( is_array( $homepage ) && ! empty( $homepage ) ) {
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $homepage[0]->ID );
			}
			
	ob_start(); ?>a:112:{s:21:"setting-webfonts_list";s:11:"recommended";s:22:"setting-default_layout";s:8:"sidebar1";s:27:"setting-default_post_layout";s:9:"list-post";s:19:"setting-post_filter";s:2:"no";s:23:"setting-disable_masonry";s:3:"yes";s:19:"setting-post_gutter";s:6:"gutter";s:30:"setting-default_layout_display";s:7:"content";s:25:"setting-default_more_text";s:9:"Read More";s:20:"setting-excerpt_more";s:1:"1";s:21:"setting-index_orderby";s:4:"date";s:19:"setting-index_order";s:4:"DESC";s:30:"setting-default_media_position";s:5:"above";s:31:"setting-image_post_feature_size";s:5:"blank";s:32:"setting-default_page_post_layout";s:12:"sidebar-none";s:37:"setting-default_page_post_layout_type";s:9:"fullwidth";s:42:"setting-default_page_single_media_position";s:5:"above";s:38:"setting-image_post_single_feature_size";s:5:"blank";s:36:"setting-search-result_layout_display";s:7:"content";s:36:"setting-search-result_media_position";s:5:"above";s:27:"setting-default_page_layout";s:8:"sidebar1";s:40:"setting-custom_post_tglobal_style_single";s:8:"sidebar1";s:38:"setting-default_portfolio_index_layout";s:12:"sidebar-none";s:43:"setting-default_portfolio_index_post_layout";s:5:"grid3";s:29:"setting-portfolio_post_filter";s:3:"yes";s:33:"setting-portfolio_disable_masonry";s:3:"yes";s:24:"setting-portfolio_gutter";s:6:"gutter";s:39:"setting-default_portfolio_index_display";s:4:"none";s:37:"setting-default_portfolio_index_title";s:1:" ";s:49:"setting-default_portfolio_index_unlink_post_title";s:1:" ";s:46:"setting-default_portfolio_index_hide_post_date";s:1:" ";s:50:"setting-default_portfolio_index_post_meta_category";s:3:"yes";s:49:"setting-default_portfolio_index_unlink_post_image";s:3:"yes";s:39:"setting-default_portfolio_single_layout";s:12:"sidebar-none";s:54:"setting-default_portfolio_single_portfolio_layout_type";s:9:"fullwidth";s:38:"setting-default_portfolio_single_title";s:1:" ";s:50:"setting-default_portfolio_single_unlink_post_title";s:1:" ";s:47:"setting-default_portfolio_single_hide_post_date";s:1:" ";s:51:"setting-default_portfolio_single_post_meta_category";s:1:" ";s:50:"setting-default_portfolio_single_unlink_post_image";s:3:"yes";s:22:"themify_portfolio_slug";s:7:"project";s:31:"themify_portfolio_category_slug";s:18:"portfolio-category";s:53:"setting-customizer_responsive_design_tablet_landscape";s:4:"1280";s:43:"setting-customizer_responsive_design_tablet";s:3:"768";s:43:"setting-customizer_responsive_design_mobile";s:3:"680";s:33:"setting-mobile_menu_trigger_point";s:3:"900";s:24:"setting-gallery_lightbox";s:8:"lightbox";s:21:"setting-header_design";s:18:"header-top-widgets";s:27:"setting-exclude_search_form";s:2:"on";s:19:"setting_search_form";s:11:"live_search";s:19:"setting-exclude_rss";s:2:"on";s:22:"setting-header_widgets";s:17:"headerwidget-2col";s:21:"setting-footer_design";s:15:"footer-left-col";s:22:"setting-use_float_back";s:2:"on";s:22:"setting-footer_widgets";s:17:"footerwidget-3col";s:23:"setting-mega_menu_posts";s:1:"5";s:29:"setting-mega_menu_image_width";s:3:"180";s:30:"setting-mega_menu_image_height";s:3:"120";s:27:"setting-imagefilter_applyto";s:12:"featuredonly";s:29:"setting-color_animation_speed";s:1:"5";s:29:"setting-relationship_taxonomy";s:8:"category";s:37:"setting-relationship_taxonomy_entries";s:1:"3";s:45:"setting-relationship_taxonomy_display_content";s:4:"none";s:30:"setting-single_slider_autoplay";s:3:"off";s:27:"setting-single_slider_speed";s:6:"normal";s:28:"setting-single_slider_effect";s:5:"slide";s:28:"setting-single_slider_height";s:4:"auto";s:18:"setting-more_posts";s:8:"infinite";s:19:"setting-entries_nav";s:8:"numbered";s:24:"setting-footer_text_left";s:206:"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip";s:25:"setting-img_php_base_size";s:5:"large";s:27:"setting-global_feature_size";s:5:"blank";s:22:"setting-link_icon_type";s:9:"font-icon";s:32:"setting-link_type_themify-link-0";s:10:"image-icon";s:33:"setting-link_title_themify-link-0";s:7:"Twitter";s:31:"setting-link_img_themify-link-0";s:106:"https://themify.me/demo/themes/construction/wp-content/themes/themify-ultra/themify/img/social/twitter.png";s:32:"setting-link_type_themify-link-1";s:10:"image-icon";s:33:"setting-link_title_themify-link-1";s:8:"Facebook";s:31:"setting-link_img_themify-link-1";s:107:"https://themify.me/demo/themes/construction/wp-content/themes/themify-ultra/themify/img/social/facebook.png";s:32:"setting-link_type_themify-link-2";s:10:"image-icon";s:33:"setting-link_title_themify-link-2";s:7:"YouTube";s:31:"setting-link_img_themify-link-2";s:106:"https://themify.me/demo/themes/construction/wp-content/themes/themify-ultra/themify/img/social/youtube.png";s:32:"setting-link_type_themify-link-3";s:10:"image-icon";s:33:"setting-link_title_themify-link-3";s:9:"Pinterest";s:31:"setting-link_img_themify-link-3";s:108:"https://themify.me/demo/themes/construction/wp-content/themes/themify-ultra/themify/img/social/pinterest.png";s:32:"setting-link_type_themify-link-4";s:9:"font-icon";s:33:"setting-link_title_themify-link-4";s:7:"Twitter";s:32:"setting-link_link_themify-link-4";s:26:"http://twitter.com/themify";s:33:"setting-link_ficon_themify-link-4";s:14:"ti-twitter-alt";s:32:"setting-link_type_themify-link-5";s:9:"font-icon";s:33:"setting-link_title_themify-link-5";s:8:"Facebook";s:32:"setting-link_link_themify-link-5";s:27:"http://facebook.com/themify";s:33:"setting-link_ficon_themify-link-5";s:11:"ti-facebook";s:32:"setting-link_type_themify-link-6";s:9:"font-icon";s:33:"setting-link_title_themify-link-6";s:7:"YouTube";s:32:"setting-link_link_themify-link-6";s:38:"https://www.youtube.com/user/themifyme";s:33:"setting-link_ficon_themify-link-6";s:10:"ti-youtube";s:32:"setting-link_type_themify-link-8";s:9:"font-icon";s:32:"setting-link_link_themify-link-8";s:34:"https://www.instagram.com/themify/";s:33:"setting-link_ficon_themify-link-8";s:12:"ti-instagram";s:22:"setting-link_field_ids";s:273:"{"themify-link-0":"themify-link-0","themify-link-1":"themify-link-1","themify-link-2":"themify-link-2","themify-link-3":"themify-link-3","themify-link-4":"themify-link-4","themify-link-5":"themify-link-5","themify-link-6":"themify-link-6","themify-link-8":"themify-link-8"}";s:23:"setting-link_field_hash";s:1:"9";s:30:"setting-page_builder_is_active";s:6:"enable";s:41:"setting-page_builder_animation_appearance";s:4:"none";s:42:"setting-page_builder_animation_parallax_bg";s:4:"none";s:44:"setting-page_builder_animation_scroll_effect";s:4:"none";s:44:"setting-page_builder_animation_sticky_scroll";s:4:"none";s:27:"setting-page_builder_expiry";s:1:"2";s:24:"setting-hooks-1-location";s:21:"themify_footer_before";s:20:"setting-hooks-1-code";s:39:"[themify_layout_part slug=contact-info]";s:23:"setting-hooks_field_ids";s:3:"[1]";s:4:"skin";s:12:"construction";s:13:"import_images";s:2:"on";}<?php $themify_data = unserialize( ob_get_clean() );

	themify_set_data( $themify_data );
	
}
themify_do_demo_import();