<?php

defined( 'ABSPATH' ) or die;

$GLOBALS['processed_terms'] = array();
$GLOBALS['processed_posts'] = array();

require_once ABSPATH . 'wp-admin/includes/post.php';
require_once ABSPATH . 'wp-admin/includes/taxonomy.php';
require_once ABSPATH . 'wp-admin/includes/image.php';

/**
 * Add an Import Action, this data is stored for processing after import is done.
 *
 * Each action is sent as an Ajax request and is handled by themify-ajax.php file
 */ 
function themify_add_import_action( $action = '', $data = array() ) {
	global $import_actions;

	if ( ! isset( $import_actions[ $action ] ) ) {
		$import_actions[ $action ] = array();
	}

	$import_actions[ $action ][] = $data;
}

function themify_import_post( $post ) {
	global $processed_posts, $processed_terms;

	if ( ! post_type_exists( $post['post_type'] ) ) {
		return;
	}

	/* Menu items don't have reliable post_title, skip the post_exists check */
	if( $post['post_type'] !== 'nav_menu_item' ) {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
		if ( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
			$processed_posts[ intval( $post['ID'] ) ] = intval( $post_exists );
			return;
		}
	}

	if( $post['post_type'] == 'nav_menu_item' ) {
		if( ! isset( $post['tax_input']['nav_menu'] ) || ! term_exists( $post['tax_input']['nav_menu'], 'nav_menu' ) ) {
			return;
		}
		$_menu_item_type = $post['meta_input']['_menu_item_type'];
		$_menu_item_object_id = $post['meta_input']['_menu_item_object_id'];

		if ( 'taxonomy' == $_menu_item_type && isset( $processed_terms[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_terms[ intval( $_menu_item_object_id ) ];
		} else if ( 'post_type' == $_menu_item_type && isset( $processed_posts[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_posts[ intval( $_menu_item_object_id ) ];
		} else if ( 'custom' != $_menu_item_type ) {
			// associated object is missing or not imported yet, we'll retry later
			// $missing_menu_items[] = $item;
			return;
		}
	}

	$post_parent = ( $post['post_type'] == 'nav_menu_item' ) ? $post['meta_input']['_menu_item_menu_item_parent'] : (int) $post['post_parent'];
	$post['post_parent'] = 0;
	if ( $post_parent ) {
		// if we already know the parent, map it to the new local ID
		if ( isset( $processed_posts[ $post_parent ] ) ) {
			if( $post['post_type'] == 'nav_menu_item' ) {
				$post['meta_input']['_menu_item_menu_item_parent'] = $processed_posts[ $post_parent ];
			} else {
				$post['post_parent'] = $processed_posts[ $post_parent ];
			}
		}
	}

	/**
	 * for hierarchical taxonomies, IDs must be used so wp_set_post_terms can function properly
	 * convert term slugs to IDs for hierarchical taxonomies
	 */
	if( ! empty( $post['tax_input'] ) ) {
		foreach( $post['tax_input'] as $tax => $terms ) {
			if( is_taxonomy_hierarchical( $tax ) ) {
				$terms = explode( ', ', $terms );
				$post['tax_input'][ $tax ] = array_map( 'themify_get_term_id_by_slug', $terms, array_fill( 0, count( $terms ), $tax ) );
			}
		}
	}

	$post['post_author'] = (int) get_current_user_id();
	$post['post_status'] = 'publish';

	$old_id = $post['ID'];

	unset( $post['ID'] );
	$post_id = wp_insert_post( $post, true );
	if( is_wp_error( $post_id ) ) {
		return false;
	} else {
		$processed_posts[ $old_id ] = $post_id;

		return $post_id;
	}
}

function themify_get_placeholder_image() {
	static $placeholder_image = null;

	if( $placeholder_image == null ) {
		if ( ! function_exists( 'WP_Filesystem' ) ) {
			require_once ABSPATH . 'wp-admin/includes/file.php';
		}
		WP_Filesystem();
		global $wp_filesystem;
		$upload = wp_upload_bits( $post['post_name'] . '.jpg', null, $wp_filesystem->get_contents( THEMIFY_DIR . '/img/image-placeholder.jpg' ) );

		if ( $info = wp_check_filetype( $upload['file'] ) )
			$post['post_mime_type'] = $info['type'];
		else
			return new WP_Error( 'attachment_processing_error', __( 'Invalid file type', 'themify' ) );

		$post['guid'] = $upload['url'];
		$post_id = wp_insert_attachment( $post, $upload['file'] );
		wp_update_attachment_metadata( $post_id, wp_generate_attachment_metadata( $post_id, $upload['file'] ) );

		$placeholder_image = $post_id;
	}

	return $placeholder_image;
}

function themify_import_term( $term ) {
	global $processed_terms;

	if( $term_id = term_exists( $term['slug'], $term['taxonomy'] ) ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];
		if ( isset( $term['term_id'] ) )
			$processed_terms[ intval( $term['term_id'] ) ] = (int) $term_id;
		return (int) $term_id;
	}

	if ( empty( $term['parent'] ) ) {
		$parent = 0;
	} else {
		$parent = term_exists( $processed_terms[ intval( $term['parent'] ) ], $term['taxonomy'] );
		if ( is_array( $parent ) ) $parent = $parent['term_id'];
	}

	$id = wp_insert_term( $term['name'], $term['taxonomy'], array(
		'parent' => $parent,
		'slug' => $term['slug'],
		'description' => $term['description'],
	) );
	if ( ! is_wp_error( $id ) ) {
		if ( isset( $term['term_id'] ) ) {
			// success!
			$processed_terms[ intval($term['term_id']) ] = $id['term_id'];
			if ( isset( $term['thumbnail'] ) ) {
				themify_add_import_action( 'term_thumb', array(
					'id' => $id['term_id'],
					'thumb' => $term['thumbnail'],
				) );
			}
			return $term['term_id'];
		}
	}

	return false;
}

function themify_get_term_id_by_slug( $slug, $tax ) {
	$term = get_term_by( 'slug', $slug, $tax );
	if( $term ) {
		return $term->term_id;
	}

	return false;
}

function themify_undo_import_term( $term ) {
	$term_id = term_exists( $term['slug'], $term['taxonomy'] );
	if ( $term_id ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];

		if ( $term_thumbnail = get_term_meta( $term['term_id'], 'thumbnail_id', true ) ) {
			wp_delete_attachment( $term_thumbnail, true );
		}

		if ( isset( $term_id ) ) {
			wp_delete_term( $term_id, $term['taxonomy'] );
		}
	}
}

/**
 * Determine if a post exists based on title, content, and date
 *
 * @global wpdb $wpdb WordPress database abstraction object.
 *
 * @param array $args array of database parameters to check
 * @return int Post ID if post exists, 0 otherwise.
 */
function themify_post_exists( $args = array() ) {
	global $wpdb;

	$query = "SELECT ID FROM $wpdb->posts WHERE 1=1";
	$db_args = array();

	foreach ( $args as $key => $value ) {
		$value = wp_unslash( sanitize_post_field( $key, $value, 0, 'db' ) );
		if( ! empty( $value ) ) {
			$query .= ' AND ' . $key . ' = %s';
			$db_args[] = $value;
		}
	}

	if ( !empty ( $args ) )
		return (int) $wpdb->get_var( $wpdb->prepare($query, $args) );

	return 0;
}

function themify_undo_import_post( $post ) {
	if( $post['post_type'] == 'nav_menu_item' ) {
		$post_exists = themify_post_exists( array(
			'post_name' => $post['post_name'],
			'post_modified' => $post['post_date'],
			'post_type' => 'nav_menu_item',
		) );
	} else {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
	}
	if( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
		/**
		 * check if the post has been modified, if so leave it be
		 *
		 * NOTE: posts are imported using wp_insert_post() which modifies post_modified field
		 * to be the same as post_date, hence to check if the post has been modified,
		 * the post_modified field is compared against post_date in the original post.
		 */
		if( $post['post_date'] == get_post_field( 'post_modified', $post_exists ) ) {
			// find and remove all post attachments
			$attachments = get_posts( array(
				'post_type' => 'attachment',
				'posts_per_page' => -1,
				'post_parent' => $post_exists,
			) );
			if ( $attachments ) {
				foreach ( $attachments as $attachment ) {
					wp_delete_attachment( $attachment->ID, true );
				}
			}
			wp_delete_post( $post_exists, true ); // true: bypass trash
		}
	}
}

function themify_process_post_import( $post ) {
	if( ERASEDEMO ) {
		themify_undo_import_post( $post );
	} else {
		if ( $id = themify_import_post( $post ) ) {
			if ( defined( 'IMPORT_IMAGES' ) && ! IMPORT_IMAGES ) {
				/* if importing images is disabled and post is supposed to have a thumbnail, create a placeholder image instead */
				if ( isset( $post['thumb'] ) ) { // the post is supposed to have featured image
					$placeholder = themify_get_placeholder_image();
					if( ! is_wp_error( $placeholder ) ) {
						set_post_thumbnail( $id, $placeholder );
					}
				}
			} else {
				if ( isset( $post["thumb"] ) ) {
					themify_add_import_action( 'post_thumb', array(
						'id' => $id,
						'thumb' => $post["thumb"],
					) );
				}
				if ( isset( $post["gallery_shortcode"] ) ) {
					themify_add_import_action( 'gallery_field', array(
						'id' => $id,
						'fields' => $post["gallery_shortcode"],
					) );
				}
				if ( isset( $post["_product_image_gallery"] ) ) {
					themify_add_import_action( 'product_gallery', array(
						'id' => $id,
						'images' => $post["_product_image_gallery"],
					) );
				}
			}
		}
	}
}
$thumbs = array();
function themify_do_demo_import() {
global $import_actions;

	if ( isset( $GLOBALS["ThemifyBuilder_Data_Manager"] ) ) {
		remove_action( "save_post", array( $GLOBALS["ThemifyBuilder_Data_Manager"], "save_builder_text_only"), 10, 3 );
	}
$term = array (
  'term_id' => 3,
  'name' => 'Tips',
  'slug' => 'tips',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 4,
  'name' => 'News',
  'slug' => 'news',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 5,
  'name' => 'Journal',
  'slug' => 'journal',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 6,
  'name' => 'Courses',
  'slug' => 'courses',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 2,
  'name' => 'Main Navigation',
  'slug' => 'main-navigation',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 7,
  'name' => 'Support',
  'slug' => 'support',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 8,
  'name' => 'Links',
  'slug' => 'links',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 9,
  'name' => 'Company',
  'slug' => 'company',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$post = array (
  'ID' => 116,
  'post_date' => '2018-08-14 16:08:18',
  'post_date_gmt' => '2018-08-14 16:08:18',
  'post_content' => 'Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates.<span id="more-821"></span>

Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?”  repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis.',
  'post_title' => 'DNA Human Cloning Test',
  'post_excerpt' => '',
  'post_name' => 'dna-human-cloning-test',
  'post_modified' => '2018-08-16 23:50:17',
  'post_modified_gmt' => '2018-08-16 23:50:17',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=116',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"5uxd797\\"}],\\"element_id\\":\\"rbhg772\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'courses',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/scientist.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 93,
  'post_date' => '2018-08-09 02:51:45',
  'post_date_gmt' => '2018-08-09 02:51:45',
  'post_content' => 'Labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.<span id="more-401"></span>

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.',
  'post_title' => 'Student Counseling to Develop Interest',
  'post_excerpt' => '',
  'post_name' => 'student-counseling-to-develop-interest',
  'post_modified' => '2018-08-11 11:30:19',
  'post_modified_gmt' => '2018-08-11 11:30:19',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=93',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"tknq670\\"}],\\"element_id\\":\\"djox686\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'tips',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/student-counseling.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 89,
  'post_date' => '2018-08-07 15:46:23',
  'post_date_gmt' => '2018-08-07 15:46:23',
  'post_content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<span id="more-397"></span>

Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.

Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt neque porro quisquam.',
  'post_title' => 'Art Class : Time to Get Creative',
  'post_excerpt' => '',
  'post_name' => 'time-to-get-creative',
  'post_modified' => '2018-08-11 11:30:32',
  'post_modified_gmt' => '2018-08-11 11:30:32',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=89',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"vza0696\\"}],\\"element_id\\":\\"f6kl760\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'courses',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/girl-painting.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 79,
  'post_date' => '2018-08-06 13:52:00',
  'post_date_gmt' => '2018-08-06 13:52:00',
  'post_content' => 'Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.recusandae. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.<span id="more-378"></span>

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores.',
  'post_title' => 'The List of Class Discussion Strategies',
  'post_excerpt' => '',
  'post_name' => 'the-list-of-class-discussion-strategies',
  'post_modified' => '2018-08-11 11:30:41',
  'post_modified_gmt' => '2018-08-11 11:30:41',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=79',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"jp19903\\"}],\\"element_id\\":\\"7bg5033\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'journal',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/discussiom.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 86,
  'post_date' => '2018-08-03 15:40:26',
  'post_date_gmt' => '2018-08-03 15:40:26',
  'post_content' => 'Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates.<span id="more-393"></span>

Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?”  repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis.',
  'post_title' => 'Technology for Better Education',
  'post_excerpt' => '',
  'post_name' => 'technology-for-better-education',
  'post_modified' => '2018-08-11 11:30:55',
  'post_modified_gmt' => '2018-08-11 11:30:55',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=86',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"8m3n631\\"}],\\"element_id\\":\\"e3s0662\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'news',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/technology-on-college.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 146,
  'post_date' => '2018-08-03 07:39:52',
  'post_date_gmt' => '2018-08-03 07:39:52',
  'post_content' => 'Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.<span id="more-825"></span>

Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.

. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur? voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus.',
  'post_title' => 'Smart Technology For Active Students',
  'post_excerpt' => '',
  'post_name' => 'smart-technology-for-active-students',
  'post_modified' => '2018-08-11 11:31:01',
  'post_modified_gmt' => '2018-08-11 11:31:01',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=146',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"gfii000\\"}],\\"element_id\\":\\"80eu025\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'news',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/students-with-laptop.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 96,
  'post_date' => '2018-08-02 15:54:21',
  'post_date_gmt' => '2018-08-02 15:54:21',
  'post_content' => 'Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatu.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis.',
  'post_title' => 'Finding New Theory in Physics',
  'post_excerpt' => '',
  'post_name' => 'finding-new-theory-in-physics',
  'post_modified' => '2018-08-11 11:31:08',
  'post_modified_gmt' => '2018-08-11 11:31:08',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=96',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"dz1e200\\"}],\\"element_id\\":\\"qjog011\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'courses',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/discussion-about-physics.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 99,
  'post_date' => '2018-08-01 15:55:15',
  'post_date_gmt' => '2018-08-01 15:55:15',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.<span id="more-406"></span>

inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.',
  'post_title' => 'Effects of Social Media For Student',
  'post_excerpt' => '',
  'post_name' => 'effect-of-social-media-for-student',
  'post_modified' => '2018-08-11 11:31:14',
  'post_modified_gmt' => '2018-08-11 11:31:14',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=99',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"c102400\\"}],\\"element_id\\":\\"dluy105\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'news',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/technology-discussion.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 103,
  'post_date' => '2018-07-28 15:57:18',
  'post_date_gmt' => '2018-07-28 15:57:18',
  'post_content' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.<span id="more-412"></span>

Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur. Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae.',
  'post_title' => 'Choose The Right Passion',
  'post_excerpt' => '',
  'post_name' => 'choose-the-right-passion',
  'post_modified' => '2018-08-11 11:31:22',
  'post_modified_gmt' => '2018-08-11 11:31:22',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=103',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"30v9107\\"}],\\"element_id\\":\\"n843070\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'tips',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/girl-with-book.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 106,
  'post_date' => '2018-07-26 15:59:06',
  'post_date_gmt' => '2018-07-26 15:59:06',
  'post_content' => 'Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.

<span id="more-818"></span><span id="more-122"></span>
Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio.',
  'post_title' => 'Maintain Your Health for Final Exam is Important',
  'post_excerpt' => '',
  'post_name' => 'maintain-your-health-for-final-exam-is-important',
  'post_modified' => '2018-08-11 11:31:30',
  'post_modified_gmt' => '2018-08-11 11:31:30',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=106',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"as83627\\"}],\\"element_id\\":\\"hgnl000\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'news',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/late-study.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 112,
  'post_date' => '2018-07-25 16:06:37',
  'post_date_gmt' => '2018-07-25 16:06:37',
  'post_content' => 'Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus.  Ton provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.<span id="more-389"></span>

<span id="more-133"></span>Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur? Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate.',
  'post_title' => 'Case Study of US Foreign Policy',
  'post_excerpt' => '',
  'post_name' => 'case-study-of-us-foreign-policy',
  'post_modified' => '2018-08-11 11:31:36',
  'post_modified_gmt' => '2018-08-11 11:31:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=112',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"zc8f006\\"}],\\"element_id\\":\\"03nz781\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'journal',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/open-book.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 119,
  'post_date' => '2018-07-21 16:08:59',
  'post_date_gmt' => '2018-07-21 16:08:59',
  'post_content' => 'Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.<span id="more-825"></span>

Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.

. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur? voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus.',
  'post_title' => 'Tips to Understanding Your Lecturer',
  'post_excerpt' => '',
  'post_name' => 'tips-to-understanding-your-lecturer',
  'post_modified' => '2018-08-11 11:31:47',
  'post_modified_gmt' => '2018-08-11 11:31:47',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=119',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"zmc7377\\"}],\\"element_id\\":\\"9xi9740\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'tips',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/teacher.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 123,
  'post_date' => '2018-07-20 16:11:22',
  'post_date_gmt' => '2018-07-20 16:11:22',
  'post_content' => 'Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate.<span id="more-828"></span>

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.',
  'post_title' => 'United Against Racism',
  'post_excerpt' => '',
  'post_name' => 'united-against-racism',
  'post_modified' => '2018-08-11 11:31:53',
  'post_modified_gmt' => '2018-08-11 11:31:53',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=123',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"1t3n709\\"}],\\"element_id\\":\\"908z707\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'news',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/united-againts-racism.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 126,
  'post_date' => '2018-07-19 16:13:11',
  'post_date_gmt' => '2018-07-19 16:13:11',
  'post_content' => 'Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate.<span id="more-828"></span>

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.',
  'post_title' => 'Psychology : Social Gathering For Student',
  'post_excerpt' => '',
  'post_name' => 'psychology-social-gathering-for-student',
  'post_modified' => '2018-08-11 11:31:59',
  'post_modified_gmt' => '2018-08-11 11:31:59',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=126',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"7rda005\\"}],\\"element_id\\":\\"n06m007\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'journal',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/education-gathering.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 129,
  'post_date' => '2018-07-12 16:16:29',
  'post_date_gmt' => '2018-07-12 16:16:29',
  'post_content' => 'Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.recusandae. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.<span id="more-833"></span>

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores.',
  'post_title' => 'Interactions Among Students',
  'post_excerpt' => '',
  'post_name' => 'interactions-among-students',
  'post_modified' => '2018-08-11 11:32:04',
  'post_modified_gmt' => '2018-08-11 11:32:04',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=129',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"w7vm036\\"}],\\"element_id\\":\\"nqna049\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'news',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/college.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 133,
  'post_date' => '2018-07-11 16:17:31',
  'post_date_gmt' => '2018-07-11 16:17:31',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.<span id="more-1455"></span>
At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.',
  'post_title' => 'Extra Course For Student From Lecturer\'s Point of View',
  'post_excerpt' => '',
  'post_name' => 'extra-course-for-student-from-lecturers-point-of-view',
  'post_modified' => '2018-08-11 11:32:10',
  'post_modified_gmt' => '2018-08-11 11:32:10',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=133',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"n441460\\"}],\\"element_id\\":\\"25t0780\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'tips',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/confident-teacher.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 136,
  'post_date' => '2018-07-08 16:21:54',
  'post_date_gmt' => '2018-07-08 16:21:54',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.<span id="more-1460"></span>

labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_title' => 'Students Contribution for The Education Law',
  'post_excerpt' => '',
  'post_name' => 'students-contribution-for-the-education-law',
  'post_modified' => '2018-08-11 11:32:15',
  'post_modified_gmt' => '2018-08-11 11:32:15',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=136',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"ql9g100\\"}],\\"element_id\\":\\"0eig100\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'news',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/hand-writing.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 142,
  'post_date' => '2018-07-06 07:13:58',
  'post_date_gmt' => '2018-07-06 07:13:58',
  'post_content' => 'Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.<span id="more-382"></span>

<span id="more-117"></span>Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.

Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur? voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut',
  'post_title' => 'Stay Active as Library Student Assistants',
  'post_excerpt' => '',
  'post_name' => 'stay-active-as-library-student-assistants',
  'post_modified' => '2018-08-11 11:32:20',
  'post_modified_gmt' => '2018-08-11 11:32:20',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=142',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"ozdv021\\"}],\\"element_id\\":\\"6ast440\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'news',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/girl-at-library.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 75,
  'post_date' => '2018-03-05 13:50:54',
  'post_date_gmt' => '2018-03-05 13:50:54',
  'post_content' => 'Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate.<span id="more-371"></span>

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.',
  'post_title' => 'How to Enjoy Your Math Classes',
  'post_excerpt' => '',
  'post_name' => 'how-to-enjoy-your-math-classes',
  'post_modified' => '2018-08-16 23:50:37',
  'post_modified_gmt' => '2018-08-16 23:50:37',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=75',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'sidebar-none',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"ce5p005\\"}],\\"element_id\\":\\"cutj408\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'tips',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/teaching-maths.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 82,
  'post_date' => '2018-02-08 15:38:19',
  'post_date_gmt' => '2018-02-08 15:38:19',
  'post_content' => 'Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.<span id="more-382"></span>

<span id="more-117"></span>Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.

. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur? voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus.',
  'post_title' => 'Average Student Loan Debt For Graduate Students?',
  'post_excerpt' => '',
  'post_name' => 'average-student-loan-debt-for-graduate-students',
  'post_modified' => '2018-08-16 23:50:25',
  'post_modified_gmt' => '2018-08-16 23:50:25',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=82',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"0jr2022\\"}],\\"element_id\\":\\"ajmf255\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'news',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/graduation.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 24,
  'post_date' => '2018-08-08 11:28:20',
  'post_date_gmt' => '2018-08-08 11:28:20',
  'post_content' => '<!--themify_builder_static--><h1>About Us</h1>
<h2>Our Mission</h2>
<p>Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure.</p>
<img src="https://themify.me/demo/themes/ultra-education/files/2018/08/discussion-648x417.jpg" width="648" height="417" alt="discussion" srcset="https://themify.me/demo/themes/ultra-education/files/2018/08/discussion.jpg 648w, https://themify.me/demo/themes/ultra-education/files/2018/08/discussion-600x386.jpg 600w, https://themify.me/demo/themes/ultra-education/files/2018/08/discussion-300x193.jpg 300w" sizes="(max-width: 648px) 100vw, 648px" />
<h3>Who We Are</h3> <p>Content here, content here\', making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover many web sites still in their infancy. Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod empor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>
<h2>Your Career in Starts Here</h2> <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent ullamcorper pellentesque arcu, quis a sodales eros pharetra. Morbi congue urna id ligula laoreet varius ac id arcu. Vivamus sodales ligula in gravida lobortis. Nullam ac mauris elit.</p>
<a href="https://themify.me/" > Get it Now </a>
<h2>Our Team</h2>
<img src="https://themify.me/demo/themes/ultra-education/files/2018/08/face2-250x250.jpg" width="250" height="250" alt="David Bernard Manager" srcset="https://themify.me/demo/themes/ultra-education/files/2018/08/face2-250x250.jpg 250w, https://themify.me/demo/themes/ultra-education/files/2018/08/face2-150x150.jpg 150w, https://themify.me/demo/themes/ultra-education/files/2018/08/face2-300x300.jpg 300w, https://themify.me/demo/themes/ultra-education/files/2018/08/face2.jpg 500w" sizes="(max-width: 250px) 100vw, 250px" /> David Bernard<br> <i>Manager</i>
<img src="https://themify.me/demo/themes/ultra-education/files/2018/08/face9-250x250.jpg" width="250" height="250" alt="Jessica Brunne Music Director" srcset="https://themify.me/demo/themes/ultra-education/files/2018/08/face9-250x250.jpg 250w, https://themify.me/demo/themes/ultra-education/files/2018/08/face9-150x150.jpg 150w, https://themify.me/demo/themes/ultra-education/files/2018/08/face9-300x300.jpg 300w, https://themify.me/demo/themes/ultra-education/files/2018/08/face9.jpg 500w" sizes="(max-width: 250px) 100vw, 250px" /> Jessica Brunne<br> <i>Music Director</i>
<img src="https://themify.me/demo/themes/ultra-education/files/2018/08/face6-250x250.jpg" width="250" height="250" alt="Jennifer Dunn Counselor" srcset="https://themify.me/demo/themes/ultra-education/files/2018/08/face6-250x250.jpg 250w, https://themify.me/demo/themes/ultra-education/files/2018/08/face6-150x150.jpg 150w, https://themify.me/demo/themes/ultra-education/files/2018/08/face6-300x300.jpg 300w, https://themify.me/demo/themes/ultra-education/files/2018/08/face6.jpg 500w" sizes="(max-width: 250px) 100vw, 250px" /> Jennifer Dunn<br> <i>Counselor</i>
<img src="https://themify.me/demo/themes/ultra-education/files/2018/08/face4-250x250.jpg" width="250" height="250" alt="George Ibran Administration Staff" srcset="https://themify.me/demo/themes/ultra-education/files/2018/08/face4-250x250.jpg 250w, https://themify.me/demo/themes/ultra-education/files/2018/08/face4-150x150.jpg 150w, https://themify.me/demo/themes/ultra-education/files/2018/08/face4-300x300.jpg 300w, https://themify.me/demo/themes/ultra-education/files/2018/08/face4.jpg 500w" sizes="(max-width: 250px) 100vw, 250px" /> George Ibran<br> <i>Administration Staff </i>
<img src="https://themify.me/demo/themes/ultra-education/files/2018/08/face8-250x250.jpg" width="250" height="250" alt="John Smith
Counselor" srcset="https://themify.me/demo/themes/ultra-education/files/2018/08/face8-250x250.jpg 250w, https://themify.me/demo/themes/ultra-education/files/2018/08/face8-150x150.jpg 150w, https://themify.me/demo/themes/ultra-education/files/2018/08/face8-300x300.jpg 300w, https://themify.me/demo/themes/ultra-education/files/2018/08/face8.jpg 500w" sizes="(max-width: 250px) 100vw, 250px" /> John Smith <br> <i>Counselor</i>
<img src="https://themify.me/demo/themes/ultra-education/files/2018/08/face3-250x250.jpg" width="250" height="250" alt="Samantha Bryn Administration Staff" srcset="https://themify.me/demo/themes/ultra-education/files/2018/08/face3-250x250.jpg 250w, https://themify.me/demo/themes/ultra-education/files/2018/08/face3-150x150.jpg 150w, https://themify.me/demo/themes/ultra-education/files/2018/08/face3-300x300.jpg 300w, https://themify.me/demo/themes/ultra-education/files/2018/08/face3.jpg 500w" sizes="(max-width: 250px) 100vw, 250px" /> Samantha Bryn<br> <i>Administration Staff </i>
<img src="https://themify.me/demo/themes/ultra-education/files/2018/08/face5-250x250.jpg" width="250" height="250" alt="Alicia Stone Art Director" srcset="https://themify.me/demo/themes/ultra-education/files/2018/08/face5-250x250.jpg 250w, https://themify.me/demo/themes/ultra-education/files/2018/08/face5-150x150.jpg 150w, https://themify.me/demo/themes/ultra-education/files/2018/08/face5-300x300.jpg 300w, https://themify.me/demo/themes/ultra-education/files/2018/08/face5.jpg 500w" sizes="(max-width: 250px) 100vw, 250px" /> Alicia Stone<br> <i>Art Director</i>
<img src="https://themify.me/demo/themes/ultra-education/files/2018/08/face7-250x250.jpg" width="250" height="250" alt="Leznek Podolsky IT Staff" srcset="https://themify.me/demo/themes/ultra-education/files/2018/08/face7-250x250.jpg 250w, https://themify.me/demo/themes/ultra-education/files/2018/08/face7-150x150.jpg 150w, https://themify.me/demo/themes/ultra-education/files/2018/08/face7-300x300.jpg 300w, https://themify.me/demo/themes/ultra-education/files/2018/08/face7.jpg 500w" sizes="(max-width: 250px) 100vw, 250px" /> Leznek Podolsky<br> <i>IT Staff</i>
<h3>“Cras tristique turpis justo, eu consequat sem adipiscing ut. Donec posuere bibendum metus</h3><!--/themify_builder_static-->',
  'post_title' => 'About Us',
  'post_excerpt' => '',
  'post_name' => 'about-us',
  'post_modified' => '2019-05-08 16:21:20',
  'post_modified_gmt' => '2019-05-08 16:21:20',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?page_id=24',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"cbebdb2\\",\\"cols\\":[{\\"element_id\\":\\"96903e4\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"f11a781\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"content_text\\":\\"<h1>About Us<\\\\/h1>\\"}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-education\\\\/files\\\\/2019\\\\/03\\\\/education.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#000000_0.30\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#ffffff\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"12\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"12\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"row_width\\":\\"fullwidth\\"}},{\\"element_id\\":\\"916f37d\\",\\"cols\\":[{\\"element_id\\":\\"9dfc43f\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"1009e4f\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"checkbox_dropcap_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h2>Our Mission<\\\\/h2>\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"c9383e8\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_size\\":\\"1.2\\",\\"font_size_unit\\":\\"em\\",\\"line_height\\":\\"1.6\\",\\"line_height_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"checkbox_dropcap_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<p>Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure.<\\\\/p>\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"1d88f18\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_left\\":\\"-8\\",\\"margin_left_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-education\\\\/files\\\\/2018\\\\/08\\\\/discussion.jpg\\",\\"width_image\\":\\"648\\",\\"height_image\\":\\"417\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"2\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"4\\",\\"margin_bottom_unit\\":\\"%\\",\\"margin_left\\":\\"0\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"},\\"stick_at_position\\":\\"top\\"}}]},{\\"element_id\\":\\"8c03b4b\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"b90fda5\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"checkbox_dropcap_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h3>Who We Are<\\\\/h3>\\\\n<p>Content here, content here\\\\\\\\\\\', making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \\\\\\\\\\\'lorem ipsum\\\\\\\\\\\' will uncover many web sites still in their infancy. Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod empor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<\\\\/p>\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"custom_parallax_scroll_reverse\\":\\"reverse\\"}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"checkbox_border_inner_apply_all\\":\\"1\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\"}},{\\"element_id\\":\\"c158813\\",\\"cols\\":[{\\"element_id\\":\\"864e5b6\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"58e240c\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color\\":\\"#ffffff\\",\\"text_align\\":\\"center\\",\\"padding_right\\":\\"15\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"15\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"checkbox_dropcap_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h2>Your Career in Starts Here<\\\\/h2>\\\\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent ullamcorper pellentesque arcu, quis a sodales eros pharetra. Morbi congue urna id ligula laoreet varius ac id arcu. Vivamus sodales ligula in gravida lobortis. Nullam ac mauris elit.<\\\\/p>\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"padding_right\\":\\"0\\",\\"padding_left\\":\\"0\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"checkbox_dropcap_border_apply_all\\":\\"1\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"351a37d\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"button_background_color\\":\\"#fba700\\",\\"link_color\\":\\"#ffffff\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"normal\\",\\"buttons_shape\\":\\"circle\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Get it Now\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"orange\\",\\"icon_alignment\\":\\"left\\"}]}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-education\\\\/files\\\\/2018\\\\/08\\\\/course.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#000000_0.66\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"checkbox_border_inner_apply_all\\":\\"1\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"12\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"12\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_width\\":\\"fullwidth\\"}},{\\"element_id\\":\\"6f50887\\",\\"cols\\":[{\\"element_id\\":\\"6e1de00\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"0cb376a\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color\\":\\"#4b567d\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"checkbox_dropcap_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h2>Our Team<\\\\/h2>\\"}},{\\"element_id\\":\\"e900db1\\",\\"cols\\":[{\\"element_id\\":\\"8c5ee2d\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"4f5ac45\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"b_c_c_h\\":\\"#0abaff_0.60\\",\\"font_color_caption\\":\\"#ffffff\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-full-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-education\\\\/files\\\\/2018\\\\/08\\\\/face2-250x250.jpg\\",\\"appearance_image\\":\\"circle\\",\\"width_image\\":\\"250\\",\\"height_image\\":\\"250\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"David Bernard<br>\\\\n<i>Manager<\\\\/i>\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"83e2e88\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"b_c_c_h\\":\\"#0abaff_0.60\\",\\"font_color_caption\\":\\"#ffffff\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-full-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-education\\\\/files\\\\/2018\\\\/08\\\\/face9-250x250.jpg\\",\\"appearance_image\\":\\"circle\\",\\"width_image\\":\\"250\\",\\"height_image\\":\\"250\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Jessica Brunne<br>\\\\n<i>Music Director<\\\\/i>\\"}}]},{\\"element_id\\":\\"76b69d7\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"e901f43\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"b_c_c_h\\":\\"#0abaff_0.60\\",\\"font_color_caption\\":\\"#ffffff\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-full-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-education\\\\/files\\\\/2018\\\\/08\\\\/face6-250x250.jpg\\",\\"appearance_image\\":\\"circle\\",\\"width_image\\":\\"250\\",\\"height_image\\":\\"250\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Jennifer Dunn<br>\\\\n<i>Counselor<\\\\/i>\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"75cb9fd\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"b_c_c_h\\":\\"#0abaff_0.60\\",\\"font_color_caption\\":\\"#ffffff\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-full-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-education\\\\/files\\\\/2018\\\\/08\\\\/face4-250x250.jpg\\",\\"appearance_image\\":\\"circle\\",\\"width_image\\":\\"250\\",\\"height_image\\":\\"250\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"George Ibran<br>\\\\n<i>Administration Staff\\\\n<\\\\/i>\\"}}]},{\\"element_id\\":\\"2c6f716\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"2680daf\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"b_c_c_h\\":\\"#0abaff_0.60\\",\\"font_color_caption\\":\\"#ffffff\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-full-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-education\\\\/files\\\\/2018\\\\/08\\\\/face8-250x250.jpg\\",\\"appearance_image\\":\\"circle\\",\\"width_image\\":\\"250\\",\\"height_image\\":\\"250\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"John Smith\\\\n<br>\\\\n<i>Counselor<\\\\/i>\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"c8f6818\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"b_c_c_h\\":\\"#0abaff_0.60\\",\\"font_color_caption\\":\\"#ffffff\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-full-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-education\\\\/files\\\\/2018\\\\/08\\\\/face3-250x250.jpg\\",\\"appearance_image\\":\\"circle\\",\\"width_image\\":\\"250\\",\\"height_image\\":\\"250\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Samantha Bryn<br>\\\\n<i>Administration Staff\\\\n<\\\\/i>\\"}}]},{\\"element_id\\":\\"5e40576\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"1fc0291\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"b_c_c_h\\":\\"#0abaff_0.60\\",\\"font_color_caption\\":\\"#ffffff\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-full-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-education\\\\/files\\\\/2018\\\\/08\\\\/face5-250x250.jpg\\",\\"appearance_image\\":\\"circle\\",\\"width_image\\":\\"250\\",\\"height_image\\":\\"250\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Alicia Stone<br>\\\\n<i>Art Director<\\\\/i>\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"f570396\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"b_c_c_h\\":\\"#0abaff_0.60\\",\\"font_color_caption\\":\\"#ffffff\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-full-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-education\\\\/files\\\\/2018\\\\/08\\\\/face7-250x250.jpg\\",\\"appearance_image\\":\\"circle\\",\\"width_image\\":\\"250\\",\\"height_image\\":\\"250\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Leznek Podolsky<br>\\\\n<i>IT Staff<\\\\/i>\\"}}]}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"checkbox_border_inner_apply_all\\":\\"1\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\"}}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"checkbox_border_inner_apply_all\\":\\"1\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\"}},{\\"element_id\\":\\"db01cce\\",\\"cols\\":[{\\"element_id\\":\\"8c12b6c\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"560d5c5\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color\\":\\"#ffffff\\",\\"text_align\\":\\"center\\",\\"padding_right\\":\\"15\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"15\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"checkbox_dropcap_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h3>“Cras tristique turpis justo, eu consequat sem adipiscing ut. Donec posuere bibendum metus<\\\\/h3>\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"padding_right\\":\\"0\\",\\"padding_left\\":\\"0\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"checkbox_dropcap_border_apply_all\\":\\"1\\"}}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#00c6ff\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"checkbox_border_inner_apply_all\\":\\"1\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\"}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 31,
  'post_date' => '2018-08-08 11:29:35',
  'post_date_gmt' => '2018-08-08 11:29:35',
  'post_content' => '',
  'post_title' => 'Blog',
  'post_excerpt' => '',
  'post_name' => 'blog',
  'post_modified' => '2018-08-15 02:57:14',
  'post_modified_gmt' => '2018-08-15 02:57:14',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?page_id=31',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'hide_page_title' => 'yes',
    'query_category' => '0',
    'post_filter' => 'no',
    'image_width' => '1160',
    'image_height' => '560',
    'hide_meta_all' => 'yes',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"m6el382\\"}],\\"element_id\\":\\"ax5a823\\"}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 34,
  'post_date' => '2018-08-08 11:30:05',
  'post_date_gmt' => '2018-08-08 11:30:05',
  'post_content' => '<!--themify_builder_static--><h1>Contact Us</h1>
<h3>Contact Info</h3>
<p>A curated selection of best songs from duotone. Listen. consectetur adipisicing elit. Corporis debitis tempore, eos minus tempora voluptas exercitationem vero maiores mollitia. Voluptate facere aliquid maiores reiciendisbus?</p>
781 Hilll Junctions Apt. 411, Lake Macieberg, HI 05380
<a href="https://facebook.com/Education"> facebook.com/Education </a>
<a href="mailto:info@yourdomain.com"> info@yourdomain.com </a>
<a href="tel:6102490000201"> +61 (024) 90000201 </a>
<a href="https://twitter.com/@Education"> @Education </a>
<h3>Contact Form</h3>
<form action="https://themify.me/demo/themes/ultra-education/wp-admin/admin-ajax.php" id="contact-0--form" method="post"> <label for="contact-0--contact-name">Your Name </label> <input type="text" name="contact-name" placeholder="" id="contact-0--contact-name" value="" /> <label for="contact-0--contact-email">Your Email </label> <input type="text" name="contact-email" placeholder="" id="contact-0--contact-email" value="" /> <label for="contact-0--contact-subject">Subject *</label> <input type="text" name="contact-subject" placeholder="" id="contact-0--contact-subject" value="" required /> <label for="contact-0--contact-message">Message *</label> <textarea name="contact-message" placeholder="" id="contact-0--contact-message" rows="8" cols="45" required></textarea> <button type="submit"> Send </button> </form>
<h2>Subscribe to Our News</h2>
<p>Subscribe now and receive weekly newsletter with educational materials, new courses, interesting posts, popular books and much more!</p>
<form action="//themify.us2.list-manage.com/subscribe/post?u=03462cf158e86ea00590274ab&amp;id=0f2a95e5de" method="post" id="mc-embedded-subscribe-form" name="mc-embedded-subscribe-form" target="_blank" novalidate> <input type="email" value="" name="EMAIL" id="mce-EMAIL"> <input type="submit" value="Subscribe" name="subscribe" id="mc-embedded-subscribe"> <input type="text" name="b_03462cf158e86ea00590274ab_0f2a95e5de" tabindex="-1" value=""> </form>
Our location<!--/themify_builder_static-->',
  'post_title' => 'Contact',
  'post_excerpt' => '',
  'post_name' => 'contact',
  'post_modified' => '2019-09-19 15:32:08',
  'post_modified_gmt' => '2019-09-19 15:32:08',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?page_id=34',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"jtuz815\\",\\"cols\\":[{\\"element_id\\":\\"fyuv830\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"dhdm832\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"checkbox_dropcap_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h1>Contact Us<\\\\/h1>\\"}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-education\\\\/files\\\\/2018\\\\/08\\\\/class-small-discussion.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#000000_0.30\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"font_color\\":\\"#ffffff\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"12\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"12\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"j9br816\\",\\"cols\\":[{\\"element_id\\":\\"z1zo836\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"4ur5837\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color\\":\\"#ffffff\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Contact Info<\\\\/h3>\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"dmp4839\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color\\":\\"#ffffff\\",\\"font_size\\":\\"1.2\\",\\"font_size_unit\\":\\"em\\",\\"line_height\\":\\"1.6\\",\\"line_height_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>A curated selection of best songs from duotone. Listen. consectetur adipisicing elit. Corporis debitis tempore, eos minus tempora voluptas exercitationem vero maiores mollitia. Voluptate facere aliquid maiores reiciendisbus?<\\\\/p>\\"}},{\\"element_id\\":\\"a7uo842\\",\\"cols\\":[{\\"element_id\\":\\"04zz843\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"gtx5844\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color\\":\\"#ffffff\\",\\"padding_top\\":\\"1\\",\\"padding_top_unit\\":\\"em\\",\\"padding_bottom\\":\\"1\\",\\"padding_bottom_unit\\":\\"em\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border_bottom_color\\":\\"#ffffff_0.50\\",\\"border_bottom_width\\":\\"1\\",\\"font_color_icon\\":\\"#ffffff\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"circle\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"fa-map-marker\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"781 Hilll Junctions Apt. 411, Lake  Macieberg, HI 05380\\",\\"link_options\\":\\"regular\\"}]}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"yd7y844\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color\\":\\"#ffffff\\",\\"link_color\\":\\"#ffffff\\",\\"link_color_hover\\":\\"#fba700\\",\\"padding_top\\":\\"1\\",\\"padding_top_unit\\":\\"em\\",\\"padding_bottom\\":\\"1\\",\\"padding_bottom_unit\\":\\"em\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border_bottom_color\\":\\"#ffffff_0.50\\",\\"border_bottom_width\\":\\"1\\",\\"font_color_icon\\":\\"#ffffff\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"circle\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"fa-facebook\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"facebook.com\\\\/Education\\",\\"link\\":\\"https:\\\\/\\\\/facebook.com\\\\/Education\\",\\"link_options\\":\\"regular\\"}]}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"jajl845\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color\\":\\"#ffffff\\",\\"link_color\\":\\"#ffffff\\",\\"link_color_hover\\":\\"#fba700\\",\\"padding_top\\":\\"1\\",\\"padding_top_unit\\":\\"em\\",\\"padding_bottom\\":\\"1\\",\\"padding_bottom_unit\\":\\"em\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border_bottom_color\\":\\"#ffffff_0.50\\",\\"border_bottom_width\\":\\"1\\",\\"font_color_icon\\":\\"#ffffff\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"circle\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"fa-envelope\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"info@yourdomain.com\\",\\"link\\":\\"mailto:info@yourdomain.com\\",\\"link_options\\":\\"regular\\"}]}}]},{\\"element_id\\":\\"lyzm846\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"2afl847\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color\\":\\"#ffffff\\",\\"link_color\\":\\"#ffffff\\",\\"link_color_hover\\":\\"#fba700\\",\\"padding_top\\":\\"1\\",\\"padding_top_unit\\":\\"em\\",\\"padding_bottom\\":\\"1\\",\\"padding_bottom_unit\\":\\"em\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border_bottom_color\\":\\"#ffffff_0.50\\",\\"border_bottom_width\\":\\"1\\",\\"font_color_icon\\":\\"#ffffff\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"circle\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"fa-phone\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"+61 (024) 90000201\\",\\"link\\":\\"tel:6102490000201\\",\\"link_options\\":\\"regular\\"}]}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"n59g848\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color\\":\\"#ffffff\\",\\"link_color\\":\\"#ffffff\\",\\"link_color_hover\\":\\"#fba700\\",\\"padding_top\\":\\"1\\",\\"padding_top_unit\\":\\"em\\",\\"padding_bottom\\":\\"1\\",\\"padding_bottom_unit\\":\\"em\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border_bottom_color\\":\\"#ffffff_0.50\\",\\"border_bottom_width\\":\\"1\\",\\"font_color_icon\\":\\"#ffffff\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"circle\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"fa-twitter\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"@Education\\",\\"link\\":\\"https:\\\\/\\\\/twitter.com\\\\/@Education\\",\\"link_options\\":\\"regular\\"}]}}]}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#00c6ff\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"3e55850\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"407k851\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"50\\",\\"border-type\\":\\"top\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Contact Form<\\\\/h3>\\"}},{\\"mod_name\\":\\"contact\\",\\"element_id\\":\\"9411851\\",\\"mod_settings\\":{\\"border-type\\":\\"top\\",\\"border_inputs-type\\":\\"top\\",\\"border_send-type\\":\\"top\\",\\"border_success_message-type\\":\\"top\\",\\"border_error_message-type\\":\\"top\\",\\"layout_contact\\":\\"style1\\",\\"gdpr_label\\":\\"I consent to my submitted data being collected and stored\\",\\"field_name_label\\":\\"Your Name\\",\\"field_email_label\\":\\"Your Email\\",\\"field_subject_label\\":\\"Subject\\",\\"field_subject_require\\":\\"yes\\",\\"field_subject_active\\":\\"yes\\",\\"field_message_label\\":\\"Message\\",\\"field_extra\\":\\"{ \\\\\\\\\\\\\\"fields\\\\\\\\\\\\\\": [] }\\",\\"field_sendcopy_label\\":\\"Send a copy to myself\\",\\"field_order\\":\\"{}\\",\\"field_send_label\\":\\"Send\\",\\"field_send_align\\":\\"left\\",\\"field_email_active\\":\\"yes\\",\\"field_name_active\\":\\"yes\\",\\"field_message_active\\":\\"yes\\",\\"contact_sent_from\\":\\"enable\\",\\"field_sendcopy_active\\":\\"\\",\\"field_captcha_active\\":\\"\\",\\"field_email_require\\":\\"\\",\\"field_name_require\\":\\"\\",\\"post_author\\":\\"\\",\\"send_to_admins\\":\\"true\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"checkbox_border_inner_apply_all\\":\\"1\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_width\\":\\"fullwidth-content\\"}},{\\"element_id\\":\\"8yjt817\\",\\"cols\\":[{\\"element_id\\":\\"au76853\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"279b855\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color\\":\\"#ffffff\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"50\\",\\"border-type\\":\\"top\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>Subscribe to Our News<\\\\/h2>\\"}},{\\"element_id\\":\\"sjgs856\\",\\"cols\\":[{\\"element_id\\":\\"mkh4857\\",\\"grid_class\\":\\"col4-1\\"},{\\"element_id\\":\\"ax13859\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"lesq860\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_size\\":\\"1.2\\",\\"font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Subscribe now and receive weekly newsletter with educational materials, new courses, interesting posts, popular books and much more!<\\\\/p>\\"}},{\\"mod_name\\":\\"plain-text\\",\\"element_id\\":\\"6mf5860\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"border-type\\":\\"top\\",\\"plain_text\\":\\"<div id=\\\\\\\\\\\\\\"mc_embed_signup\\\\\\\\\\\\\\">\\\\n\\\\t<form action=\\\\\\\\\\\\\\"\\\\/\\\\/themify.us2.list-manage.com\\\\/subscribe\\\\/post?u=03462cf158e86ea00590274ab&amp;id=0f2a95e5de\\\\\\\\\\\\\\" method=\\\\\\\\\\\\\\"post\\\\\\\\\\\\\\" id=\\\\\\\\\\\\\\"mc-embedded-subscribe-form\\\\\\\\\\\\\\" name=\\\\\\\\\\\\\\"mc-embedded-subscribe-form\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\"validate\\\\\\\\\\\\\\" target=\\\\\\\\\\\\\\"_blank\\\\\\\\\\\\\\" novalidate>\\\\n\\\\t\\\\t<div id=\\\\\\\\\\\\\\"mc_embed_signup_scroll\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t<div class=\\\\\\\\\\\\\\"mc-field-group\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t\\\\t<input type=\\\\\\\\\\\\\\"email\\\\\\\\\\\\\\" value=\\\\\\\\\\\\\\"\\\\\\\\\\\\\\" name=\\\\\\\\\\\\\\"EMAIL\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\"required email\\\\\\\\\\\\\\" id=\\\\\\\\\\\\\\"mce-EMAIL\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t\\\\t<input type=\\\\\\\\\\\\\\"submit\\\\\\\\\\\\\\" value=\\\\\\\\\\\\\\"Subscribe\\\\\\\\\\\\\\" name=\\\\\\\\\\\\\\"subscribe\\\\\\\\\\\\\\" id=\\\\\\\\\\\\\\"mc-embedded-subscribe\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\"button\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t<\\\\/div>\\\\n\\\\t\\\\t\\\\t<div id=\\\\\\\\\\\\\\"mce-responses\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\"clear\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t\\\\t<div class=\\\\\\\\\\\\\\"response\\\\\\\\\\\\\\" id=\\\\\\\\\\\\\\"mce-error-response\\\\\\\\\\\\\\" style=\\\\\\\\\\\\\\"display:none\\\\\\\\\\\\\\"><\\\\/div>\\\\n\\\\t\\\\t\\\\t\\\\t<div class=\\\\\\\\\\\\\\"response\\\\\\\\\\\\\\" id=\\\\\\\\\\\\\\"mce-success-response\\\\\\\\\\\\\\" style=\\\\\\\\\\\\\\"display:none\\\\\\\\\\\\\\"><\\\\/div>\\\\n\\\\t\\\\t\\\\t<\\\\/div>\\\\n\\\\t\\\\t\\\\t<!-- real people should not fill this in and expect good things - do not remove this or risk form bot signups-->\\\\n\\\\t\\\\t\\\\t<div style=\\\\\\\\\\\\\\"position: absolute; left: -5000px;\\\\\\\\\\\\\\" aria-hidden=\\\\\\\\\\\\\\"true\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t\\\\t<input type=\\\\\\\\\\\\\\"text\\\\\\\\\\\\\\" name=\\\\\\\\\\\\\\"b_03462cf158e86ea00590274ab_0f2a95e5de\\\\\\\\\\\\\\" tabindex=\\\\\\\\\\\\\\"-1\\\\\\\\\\\\\\" value=\\\\\\\\\\\\\\"\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t<\\\\/div>\\\\n\\\\t\\\\t<\\\\/div>\\\\n\\\\t<\\\\/form>\\\\n<\\\\/div>\\\\n<script type=\\\\\\\\\\\'text\\\\/javascript\\\\\\\\\\\' src=\\\\\\\\\\\'\\\\/\\\\/s3.amazonaws.com\\\\/downloads.mailchimp.com\\\\/js\\\\/mc-validate.js\\\\\\\\\\\'><\\\\/script><script type=\\\\\\\\\\\'text\\\\/javascript\\\\\\\\\\\'>(function($) {window.fnames = new Array(); window.ftypes = new Array();fnames[0]=\\\\\\\\\\\'EMAIL\\\\\\\\\\\';ftypes[0]=\\\\\\\\\\\'email\\\\\\\\\\\';fnames[1]=\\\\\\\\\\\'FNAME\\\\\\\\\\\';ftypes[1]=\\\\\\\\\\\'text\\\\\\\\\\\';fnames[2]=\\\\\\\\\\\'LNAME\\\\\\\\\\\';ftypes[2]=\\\\\\\\\\\'text\\\\\\\\\\\';fnames[5]=\\\\\\\\\\\'HOMEPAGE\\\\\\\\\\\';ftypes[5]=\\\\\\\\\\\'text\\\\\\\\\\\';}(jQuery));var $mcj = jQuery.noConflict(true);<\\\\/script>\\\\n<style type=\\\\\\\\\\\\\\"text\\\\/css\\\\\\\\\\\\\\">\\\\n#mc_embed_signup .heading {\\\\n\\\\tfont:17px\\\\/25px \\\\\\\\\\\\\\"Open Sans\\\\\\\\\\\\\\", Helvetica, Arial, sans-serif;\\\\n\\\\tfont-weight:300;\\\\n\\\\tmargin: 0  0 35px 0;\\\\n}\\\\n#mc_embed_signup input[type=\\\\\\\\\\\\\\"email\\\\\\\\\\\\\\"] {\\\\n\\\\tfont:14px\\\\/1.2 \\\\\\\\\\\\\\"Open Sans\\\\\\\\\\\\\\", Helvetica, Arial, sans-serif;\\\\n\\\\tcolor: #333;\\\\n\\\\tpadding: 15px 12px;\\\\n\\\\tfont-weight:300;\\\\n\\\\tmargin: 0 -15px 20px 0;\\\\n\\\\twidth: 100%;\\\\n\\\\tborder: 1px solid #dddddd;\\\\nborder-right:none;\\\\n\\\\tbox-sizing: border-box;\\\\n        background:#fafafa;\\\\n}\\\\n#mc_embed_signup .button {\\\\n\\\\t-webkit-appearance: none;\\\\n\\\\tbackground:#e4971d;\\\\n\\\\tcolor: #fff;\\\\n\\\\tborder: none;\\\\n\\\\tpadding: 17px 20px;\\\\n\\\\tfont:14px\\\\/1 \\\\\\\\\\\\\\"Montserrat\\\\\\\\\\\\\\", Helvetica, Arial, sans-serif;\\\\n\\\\ttext-transform: uppercase;\\\\n\\\\tborder-radius: 0;\\\\nmargin:0;\\\\n}\\\\n#mc_embed_signup .button:hover {\\\\n\\\\tbackground:#d67015;\\\\n}\\\\n#mc_embed_signup div.mce_inline_error {\\\\n\\\\tmargin: -10px 0 10px 0;\\\\n\\\\tpadding: 0;\\\\n\\\\tbackground: none;\\\\n\\\\tfont-weight: normal;\\\\n\\\\tfont-size: .9em;\\\\n       color:#f82525;\\\\n}\\\\n#mc_embed_signup .response {\\\\n\\\\tfont-size: .85em;\\\\n\\\\tline-height: 1.3;\\\\n\\\\tmargin: 0 0 10px;\\\\n}\\\\n<\\\\/style>\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#ffffff\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"iz9v861\\",\\"grid_class\\":\\"col4-1\\"}]}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-education\\\\/files\\\\/2018\\\\/08\\\\/bg-subscribe-1024x481.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#000000_0.66\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"checkbox_border_inner_apply_all\\":\\"1\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"7\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\"}},{\\"element_id\\":\\"2hkx817\\",\\"cols\\":[{\\"element_id\\":\\"hejn863\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"maps-pro\\",\\"element_id\\":\\"agcu863\\",\\"mod_settings\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"map_display_type\\":\\"dynamic\\",\\"w_map\\":\\"100\\",\\"w_map_unit\\":\\"%\\",\\"w_map_static\\":\\"500\\",\\"h_map\\":\\"500\\",\\"type_map\\":\\"ROADMAP\\",\\"style_map\\":\\"greyscale\\",\\"scrollwheel_map\\":\\"disable\\",\\"draggable_map\\":\\"enable\\",\\"disable_map_ui\\":\\"no\\",\\"zoom_map\\":\\"16\\",\\"map_polyline\\":\\"no\\",\\"map_polyline_geodesic\\":\\"yes\\",\\"map_polyline_stroke\\":\\"2\\",\\"map_polyline_color\\":\\"ff0000\\",\\"map_center\\":\\"59 St George St, Toronto, ON M5S 2E6, Canada\\",\\"markers\\":[{\\"address\\":\\"59 St George St, Toronto, ON M5S 2E6, Canada\\",\\"latlng\\":\\"43.6611612,-79.39653899999996\\",\\"title\\":\\"Our location\\",\\"image\\":\\"https://themify.me/demo/themes/ultra-education\\\\/files\\\\/2018\\\\/08\\\\/university-icon-1.png\\"}]}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"checkbox_border_inner_apply_all\\":\\"1\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_width\\":\\"fullwidth-content\\"}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 21,
  'post_date' => '2018-08-08 11:26:35',
  'post_date_gmt' => '2018-08-08 11:26:35',
  'post_content' => '',
  'post_title' => 'Courses',
  'post_excerpt' => '',
  'post_name' => 'courses',
  'post_modified' => '2018-08-12 07:19:22',
  'post_modified_gmt' => '2018-08-12 07:19:22',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?page_id=21',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 27,
  'post_date' => '2018-08-08 11:28:46',
  'post_date_gmt' => '2018-08-08 11:28:46',
  'post_content' => '<!--themify_builder_static--><h1>Events</h1><!--/themify_builder_static-->',
  'post_title' => 'Events',
  'post_excerpt' => '',
  'post_name' => 'events',
  'post_modified' => '2018-12-27 01:08:09',
  'post_modified_gmt' => '2018-12-27 01:08:09',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?page_id=27',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"a0a62dd\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"2dd5fde\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"6cb81d3\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"checkbox_dropcap_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h1>Events<\\\\/h1>\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-education\\\\/files\\\\/2018\\\\/08\\\\/girl-painting.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#000000_0.30\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"checkbox_border_inner_apply_all\\":\\"1\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#ffffff\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"12\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"12\\",\\"padding_bottom_unit\\":\\"%\\",\\"margin-bottom\\":\\"60\\",\\"checkbox_border_apply_all\\":\\"1\\"}},{\\"element_id\\":\\"0752763\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"d397e32\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"event-posts\\",\\"element_id\\":\\"1f05bd4\\",\\"mod_settings\\":{\\"checkbox_general_padding_apply_all\\":\\"1\\",\\"checkbox_general_margin_apply_all\\":\\"1\\",\\"general_border-type\\":\\"top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_p_t_apply_all\\":\\"1\\",\\"checkbox_m_t_apply_all\\":\\"1\\",\\"b_t-type\\":\\"top\\",\\"checkbox_p_d_apply_all\\":\\"1\\",\\"checkbox_m_d_apply_all\\":\\"1\\",\\"b_d-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"checkbox_c_m_apply_all\\":\\"1\\",\\"c_b-type\\":\\"top\\",\\"checkbox_p_f_i_apply_all\\":\\"1\\",\\"checkbox_m_f_i_apply_all\\":\\"1\\",\\"b_f_i-type\\":\\"top\\",\\"show\\":\\"mix\\",\\"style\\":\\"grid2\\",\\"category\\":\\"0|multiple\\",\\"limit\\":\\"6\\",\\"order\\":\\"desc\\",\\"orderby\\":\\"event_date\\",\\"display\\":\\"excerpt\\",\\"image_w\\":\\"600\\",\\"image_h\\":\\"400\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"a0a62dd\\",\\"unstick_when_el_mod_id\\":\\"6cb81d3\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}]},{\\"element_id\\":\\"d81fb4f\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"b746baf\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6,
  'post_date' => '2018-08-06 06:25:24',
  'post_date_gmt' => '2018-08-06 06:25:24',
  'post_content' => '<!--themify_builder_static--><h1>eLearning theme for<br/>Ultra Education</h1>
 <a href="https://themify.me/" >Sign Up</a> 
 <h3>Best Industry Leaders</h3> <p> </p> 
 <a href="https://themify.me/"> View More </a> 
 <h3>Learn Courses Online</h3> <p> </p> 
 <a href="https://themify.me/"> View More </a> 
 <h3>Library & Book Store</h3> <p> </p> 
 <a href="https://themify.me/"> View More </a> 
<h1>Gets 100s of Online Courses for Free<br/>Register Now</h1>
 
 Years Days Hours Minutes Seconds 
 
 <h2>Events</h2> 
 <a href="https://themify.me/demo/themes/ultra-education/events/" >More Events</a> 
 <h2>Latest News</h2> 
 <h3>What people says about education</h3> 
 <ul data-id="testimonial-slider-0-" data-visible="2" data-mob-visible="1" data-scroll="1" data-auto-scroll="off" data-speed="1" data-wrap="yes" data-arrow="yes" data-pagination="no" data-effect="scroll" data-height="variable" data-pause-on-hover="resume" > <li> 
 <p>Stephen has a library of lessons that goes far beyond the surface, touching nearly every aspect of how to design and develop for the web and iOS."</p> <figure><img src="https://themify.me/demo/themes/ultra-education/files/2019/03/face8-80x80.jpg" width="80" height="80" alt="face8" srcset="https://themify.me/demo/themes/ultra-education/files/2019/03/face8-80x80.jpg 80w, https://themify.me/demo/themes/ultra-education/files/2019/03/face8-150x150.jpg 150w, https://themify.me/demo/themes/ultra-education/files/2019/03/face8.jpg 500w" sizes="(max-width: 80px) 100vw, 80px" /></figure> Shay Howe Designer & Developer </li> <li> 
 <p>LearnPress is a WordPress complete solution for creating a Learning Management System (LMS).</p> <figure><img src="https://themify.me/demo/themes/ultra-education/files/2019/03/face4-80x80.jpg" width="80" height="80" alt="face4" srcset="https://themify.me/demo/themes/ultra-education/files/2019/03/face4-80x80.jpg 80w, https://themify.me/demo/themes/ultra-education/files/2019/03/face4-150x150.jpg 150w, https://themify.me/demo/themes/ultra-education/files/2019/03/face4.jpg 500w" sizes="(max-width: 80px) 100vw, 80px" /></figure> Jonathan Doe Designer & Developer </li> <li> 
 <p>Stephen has a library of lessons that goes far beyond the surface, touching nearly every aspect of how to design and develop for the web and touching.</p> <figure><img src="https://themify.me/demo/themes/ultra-education/files/2019/03/face10-80x80.jpg" width="80" height="80" alt="face10" srcset="https://themify.me/demo/themes/ultra-education/files/2019/03/face10-80x80.jpg 80w, https://themify.me/demo/themes/ultra-education/files/2019/03/face10-150x150.jpg 150w, https://themify.me/demo/themes/ultra-education/files/2019/03/face10.jpg 500w" sizes="(max-width: 80px) 100vw, 80px" /></figure> Melissa Donovan Designer & Developer </li> </ul> 
 <h3>Subscribe</h3><p>Subscribe now and receive weekly newsletter with educational materials, new courses, interesting posts, popular books and much more!</p> 
 <form action="//themify.us2.list-manage.com/subscribe/post?u=03462cf158e86ea00590274ab&amp;id=0f2a95e5de" method="post" id="mc-embedded-subscribe-form" name="mc-embedded-subscribe-form" target="_blank" novalidate> <input type="email" value="" name="EMAIL" id="mce-EMAIL"> <input type="submit" value="Subscribe" name="subscribe" id="mc-embedded-subscribe"> <input type="text" name="b_03462cf158e86ea00590274ab_0f2a95e5de" tabindex="-1" value=""> </form><!--/themify_builder_static-->',
  'post_title' => 'Home',
  'post_excerpt' => '',
  'post_name' => 'home',
  'post_modified' => '2019-03-26 22:37:30',
  'post_modified_gmt' => '2019-03-26 22:37:30',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?page_id=6',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'mobile_menu_styles' => 'default',
    'header_wrap' => 'transparent',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"3e45014\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"243b3fa\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"73a6913\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"font_color\\":\\"#ffffff\\",\\"font_color_subheading\\":\\"#ffffff\\",\\"checkbox_d_border_apply_all\\":\\"1\\",\\"heading\\":\\"eLearning theme for\\",\\"sub_heading\\":\\"Ultra Education\\",\\"heading_tag\\":\\"h1\\",\\"text_alignment\\":\\"themify-text-center\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"790ace5\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"normal\\",\\"buttons_shape\\":\\"circle\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Sign Up\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"blue\\",\\"icon_alignment\\":\\"left\\"}]}},{\\"element_id\\":\\"d34d1fb\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"52e0d7f\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"callout\\",\\"element_id\\":\\"ecb364d\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_color\\":\\"#009434_0.85\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"layout_callout\\":\\"button-bottom\\",\\"heading_callout\\":\\"Best Industry Leaders\\",\\"color_callout\\":\\"green\\",\\"appearance_callout\\":\\"rounded\\",\\"action_btn_link_callout\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"open_link_new_tab_callout\\":\\"no\\",\\"action_btn_text_callout\\":\\"View More\\",\\"action_btn_color_callout\\":\\"transparent\\"}}]},{\\"element_id\\":\\"732cb19\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"callout\\",\\"element_id\\":\\"4bbf59a\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_color\\":\\"#f59b00_0.85\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"layout_callout\\":\\"button-bottom\\",\\"heading_callout\\":\\"Learn Courses Online\\",\\"color_callout\\":\\"orange\\",\\"appearance_callout\\":\\"rounded\\",\\"action_btn_link_callout\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"open_link_new_tab_callout\\":\\"no\\",\\"action_btn_text_callout\\":\\"View More\\",\\"action_btn_color_callout\\":\\"transparent\\"}}]},{\\"element_id\\":\\"eff09ba\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"callout\\",\\"element_id\\":\\"3be0693\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_color\\":\\"#00a9cf_0.85\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"layout_callout\\":\\"button-bottom\\",\\"heading_callout\\":\\"Library & Book Store\\",\\"color_callout\\":\\"blue\\",\\"appearance_callout\\":\\"rounded\\",\\"action_btn_link_callout\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"open_link_new_tab_callout\\":\\"no\\",\\"action_btn_text_callout\\":\\"View More\\",\\"action_btn_color_callout\\":\\"transparent\\"}}]}],\\"column_alignment\\":\\"col_align_bottom\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"checkbox_border_inner_apply_all\\":\\"1\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"5\\",\\"margin_top_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-education\\\\/files\\\\/2019\\\\/03\\\\/education.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-bottom\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#000000_0.30\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"14\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"22\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"row_width\\":\\"fullwidth\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"0cd00b7\\",\\"unstick_when_el_mod_id\\":\\"73a6913\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"0cd00b7\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"989c269\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"8de5925\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"3\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"font_color\\":\\"#ffffff\\",\\"font_color_subheading\\":\\"#ffffff\\",\\"checkbox_d_border_apply_all\\":\\"1\\",\\"heading\\":\\"Gets 100s of Online Courses for Free\\",\\"sub_heading\\":\\"Register Now\\",\\"heading_tag\\":\\"h1\\",\\"text_alignment\\":\\"themify-text-left\\"}},{\\"mod_name\\":\\"countdown\\",\\"element_id\\":\\"5a5de89\\",\\"mod_settings\\":{\\"font_color\\":\\"#ffffff\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"3\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"mod_date_countdown\\":\\"2030-12-31 16:00:00\\",\\"color_countdown\\":\\"transparent\\",\\"done_action_countdown\\":\\"nothing\\",\\"label_years\\":\\"Years\\",\\"label_days\\":\\"Days\\",\\"label_hours\\":\\"Hours\\",\\"label_minutes\\":\\"Minutes\\",\\"label_seconds\\":\\"Seconds\\",\\"breakpoint_mobile\\":{\\"font_size\\":\\"9\\",\\"padding_top\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}}]},{\\"element_id\\":\\"b56b74c\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\"}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-education\\\\/files\\\\/2018\\\\/08\\\\/technology-discussion.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#000000_0.50\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"3e45014\\",\\"unstick_when_el_mod_id\\":\\"73a6913\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"0e032c7\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"69668d0\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"c215f03\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"3\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"checkbox_dropcap_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h2>Events<\\\\/h2>\\"}},{\\"mod_name\\":\\"event-posts\\",\\"element_id\\":\\"403679d\\",\\"mod_settings\\":{\\"checkbox_general_padding_apply_all\\":\\"1\\",\\"checkbox_general_margin_apply_all\\":\\"1\\",\\"general_border-type\\":\\"top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_p_t_apply_all\\":\\"1\\",\\"checkbox_m_t_apply_all\\":\\"1\\",\\"b_t-type\\":\\"top\\",\\"checkbox_p_d_apply_all\\":\\"1\\",\\"checkbox_m_d_apply_all\\":\\"1\\",\\"b_d-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"checkbox_c_m_apply_all\\":\\"1\\",\\"c_b-type\\":\\"top\\",\\"checkbox_p_f_i_apply_all\\":\\"1\\",\\"checkbox_m_f_i_apply_all\\":\\"1\\",\\"b_f_i-type\\":\\"top\\",\\"show\\":\\"mix\\",\\"style\\":\\"grid3\\",\\"category\\":\\"0|multiple\\",\\"limit\\":\\"3\\",\\"order\\":\\"desc\\",\\"orderby\\":\\"event_date\\",\\"display\\":\\"none\\",\\"image_w\\":\\"364\\",\\"image_h\\":\\"220\\",\\"hide_page_nav\\":\\"yes\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"3e45014\\",\\"unstick_when_el_mod_id\\":\\"73a6913\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"43c5cb8\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"border-type\\":\\"top\\",\\"link_color\\":\\"#ffffff\\",\\"link_border-type\\":\\"top\\",\\"buttons_size\\":\\"normal\\",\\"buttons_shape\\":\\"circle\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"More Events\\",\\"link\\":\\"https://themify.me/demo/themes/ultra-education\\\\/events\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"blue\\",\\"icon_alignment\\":\\"left\\"}]}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"checkbox_border_inner_apply_all\\":\\"1\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\"}},{\\"element_id\\":\\"dc763bb\\",\\"row_order\\":\\"3\\",\\"cols\\":[{\\"element_id\\":\\"ebf377d\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"26c11d1\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"3\\",\\"margin_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"checkbox_dropcap_border_apply_all\\":\\"1\\",\\"content_text\\":\\"<h2>Latest News<\\\\/h2>\\"}},{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"18a309a\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_general_solid\\",\\"checkbox_general_padding_apply_all\\":\\"1\\",\\"checkbox_general_margin_apply_all\\":\\"1\\",\\"general_border-type\\":\\"top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_p_t_apply_all\\":\\"1\\",\\"checkbox_m_t_apply_all\\":\\"1\\",\\"b_t-type\\":\\"top\\",\\"checkbox_p_d_apply_all\\":\\"1\\",\\"checkbox_m_d_apply_all\\":\\"1\\",\\"b_d-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"checkbox_c_m_apply_all\\":\\"1\\",\\"c_b-type\\":\\"top\\",\\"checkbox_p_f_i_apply_all\\":\\"1\\",\\"checkbox_m_f_i_apply_all\\":\\"1\\",\\"b_f_i-type\\":\\"top\\",\\"layout_post\\":\\"grid4\\",\\"post_type_post\\":\\"post\\",\\"type_query_post\\":\\"category\\",\\"category_post\\":\\"0|multiple\\",\\"post_tag_post\\":\\"0|multiple\\",\\"course_category_post\\":\\"0|multiple\\",\\"course_tag_post\\":\\"0|multiple\\",\\"question_tag_post\\":\\"0|multiple\\",\\"event-category_post\\":\\"0|multiple\\",\\"event-tag_post\\":\\"0|multiple\\",\\"post_content_layout\\":\\"boxed\\",\\"post_filter\\":\\"no\\",\\"post_per_page_post\\":\\"4\\",\\"order_post\\":\\"desc\\",\\"orderby_post\\":\\"date\\",\\"display_post\\":\\"excerpt\\",\\"img_width_post\\":\\"360\\",\\"img_height_post\\":\\"360\\",\\"hide_post_meta_post\\":\\"yes\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"3e45014\\",\\"unstick_when_el_mod_id\\":\\"73a6913\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#f3f3f3\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"checkbox_border_inner_apply_all\\":\\"1\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\"}},{\\"element_id\\":\\"5f4c291\\",\\"row_order\\":\\"4\\",\\"cols\\":[{\\"element_id\\":\\"14d47a5\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"4018fe9\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color\\":\\"#ffffff\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>What people says about education<\\\\/h3>\\\\n\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-education-dev\\\\/files\\\\/2018\\\\/08\\\\/blog3-min.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#000000_0.49\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"checkbox_border_inner_apply_all\\":\\"1\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_layout\\":\\"slant2\\",\\"right-frame_color\\":\\"#00c6ff\\",\\"right-frame_width\\":\\"17\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\"}},{\\"element_id\\":\\"daabe51\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"testimonial-slider\\",\\"element_id\\":\\"a36f107\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_p_container_apply_all\\":\\"1\\",\\"b_container-type\\":\\"top\\",\\"checkbox_content_padding_apply_all\\":\\"1\\",\\"content_border-type\\":\\"top\\",\\"layout_testimonial\\":\\"image-bubble\\",\\"tab_content_testimonial\\":[{\\"content_testimonial\\":\\"<p>Stephen has a library of lessons that goes far beyond the surface, touching nearly every aspect of how to design and develop for the web and iOS.\\\\\\\\\\\\\\"<\\\\/p>\\",\\"person_picture_testimonial\\":\\"https://themify.me/demo/themes/ultra-education\\\\/files\\\\/2019\\\\/03\\\\/face8.jpg\\",\\"person_name_testimonial\\":\\"Shay Howe\\",\\"person_position_testimonial\\":\\"Designer & Developer\\"},{\\"content_testimonial\\":\\"<p>LearnPress is a WordPress complete solution for creating a Learning Management System (LMS).<\\\\/p>\\",\\"person_picture_testimonial\\":\\"https://themify.me/demo/themes/ultra-education\\\\/files\\\\/2019\\\\/03\\\\/face4.jpg\\",\\"person_name_testimonial\\":\\"Jonathan Doe\\",\\"person_position_testimonial\\":\\"Designer & Developer\\"},{\\"content_testimonial\\":\\"<p>Stephen has a library of lessons that goes far beyond the surface, touching nearly every aspect of how to design and develop for the web and touching.<\\\\/p>\\",\\"person_picture_testimonial\\":\\"https://themify.me/demo/themes/ultra-education\\\\/files\\\\/2019\\\\/03\\\\/face10.jpg\\",\\"person_name_testimonial\\":\\"Melissa Donovan\\",\\"person_position_testimonial\\":\\"Designer & Developer\\"}],\\"img_w_slider\\":\\"80\\",\\"img_h_slider\\":\\"80\\",\\"visible_opt_slider\\":\\"2\\",\\"mob_visible_opt_slider\\":\\"1\\",\\"auto_scroll_opt_slider\\":\\"off\\",\\"scroll_opt_slider\\":\\"1\\",\\"speed_opt_slider\\":\\"normal\\",\\"effect_slider\\":\\"scroll\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"wrap_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"no\\",\\"show_arrow_slider\\":\\"yes\\",\\"height_slider\\":\\"variable\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"3e45014\\",\\"unstick_when_el_mod_id\\":\\"73a6913\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"checkbox_border_inner_apply_all\\":\\"1\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\"}}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#00c6ff\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"checkbox_border_inner_apply_all\\":\\"1\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"row_width\\":\\"fullwidth-content\\"}},{\\"element_id\\":\\"3cc5977\\",\\"row_order\\":\\"5\\",\\"cols\\":[{\\"element_id\\":\\"8af80fe\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"9b56556\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"content_text\\":\\"<h3>Subscribe<\\\\/h3><p>Subscribe now and receive weekly newsletter with educational materials, new courses, interesting posts, popular books and much more!<\\\\/p>\\"}}]},{\\"element_id\\":\\"13625c0\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"plain-text\\",\\"element_id\\":\\"1cfd492\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"plain_text\\":\\"<div id=\\\\\\\\\\\\\\"mc_embed_signup\\\\\\\\\\\\\\">\\\\n\\\\t<form action=\\\\\\\\\\\\\\"\\\\/\\\\/themify.us2.list-manage.com\\\\/subscribe\\\\/post?u=03462cf158e86ea00590274ab&amp;id=0f2a95e5de\\\\\\\\\\\\\\" method=\\\\\\\\\\\\\\"post\\\\\\\\\\\\\\" id=\\\\\\\\\\\\\\"mc-embedded-subscribe-form\\\\\\\\\\\\\\" name=\\\\\\\\\\\\\\"mc-embedded-subscribe-form\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\"validate\\\\\\\\\\\\\\" target=\\\\\\\\\\\\\\"_blank\\\\\\\\\\\\\\" novalidate>\\\\n\\\\t\\\\t<div id=\\\\\\\\\\\\\\"mc_embed_signup_scroll\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t<div class=\\\\\\\\\\\\\\"mc-field-group\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t\\\\t<input type=\\\\\\\\\\\\\\"email\\\\\\\\\\\\\\" value=\\\\\\\\\\\\\\"\\\\\\\\\\\\\\" name=\\\\\\\\\\\\\\"EMAIL\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\"required email\\\\\\\\\\\\\\" id=\\\\\\\\\\\\\\"mce-EMAIL\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t\\\\t<input type=\\\\\\\\\\\\\\"submit\\\\\\\\\\\\\\" value=\\\\\\\\\\\\\\"Subscribe\\\\\\\\\\\\\\" name=\\\\\\\\\\\\\\"subscribe\\\\\\\\\\\\\\" id=\\\\\\\\\\\\\\"mc-embedded-subscribe\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\"button\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t<\\\\/div>\\\\n\\\\t\\\\t\\\\t<div id=\\\\\\\\\\\\\\"mce-responses\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\"clear\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t\\\\t<div class=\\\\\\\\\\\\\\"response\\\\\\\\\\\\\\" id=\\\\\\\\\\\\\\"mce-error-response\\\\\\\\\\\\\\" style=\\\\\\\\\\\\\\"display:none\\\\\\\\\\\\\\"><\\\\/div>\\\\n\\\\t\\\\t\\\\t\\\\t<div class=\\\\\\\\\\\\\\"response\\\\\\\\\\\\\\" id=\\\\\\\\\\\\\\"mce-success-response\\\\\\\\\\\\\\" style=\\\\\\\\\\\\\\"display:none\\\\\\\\\\\\\\"><\\\\/div>\\\\n\\\\t\\\\t\\\\t<\\\\/div>\\\\n\\\\t\\\\t\\\\t<!-- real people should not fill this in and expect good things - do not remove this or risk form bot signups-->\\\\n\\\\t\\\\t\\\\t<div style=\\\\\\\\\\\\\\"position: absolute; left: -5000px;\\\\\\\\\\\\\\" aria-hidden=\\\\\\\\\\\\\\"true\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t\\\\t<input type=\\\\\\\\\\\\\\"text\\\\\\\\\\\\\\" name=\\\\\\\\\\\\\\"b_03462cf158e86ea00590274ab_0f2a95e5de\\\\\\\\\\\\\\" tabindex=\\\\\\\\\\\\\\"-1\\\\\\\\\\\\\\" value=\\\\\\\\\\\\\\"\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t<\\\\/div>\\\\n\\\\t\\\\t<\\\\/div>\\\\n\\\\t<\\\\/form>\\\\n<\\\\/div>\\\\n\\\\n<script type=\\\\\\\\\\\'text\\\\/javascript\\\\\\\\\\\' src=\\\\\\\\\\\'\\\\/\\\\/s3.amazonaws.com\\\\/downloads.mailchimp.com\\\\/js\\\\/mc-validate.js\\\\\\\\\\\'><\\\\/script><script type=\\\\\\\\\\\'text\\\\/javascript\\\\\\\\\\\'>(function($) {window.fnames = new Array(); window.ftypes = new Array();fnames[0]=\\\\\\\\\\\'EMAIL\\\\\\\\\\\';ftypes[0]=\\\\\\\\\\\'email\\\\\\\\\\\';fnames[1]=\\\\\\\\\\\'FNAME\\\\\\\\\\\';ftypes[1]=\\\\\\\\\\\'text\\\\\\\\\\\';fnames[2]=\\\\\\\\\\\'LNAME\\\\\\\\\\\';ftypes[2]=\\\\\\\\\\\'text\\\\\\\\\\\';fnames[5]=\\\\\\\\\\\'HOMEPAGE\\\\\\\\\\\';ftypes[5]=\\\\\\\\\\\'text\\\\\\\\\\\';}(jQuery));var $mcj = jQuery.noConflict(true);<\\\\/script>\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"checkbox_border_inner_apply_all\\":\\"1\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"1\\"}},{\\"element_id\\":\\"ccfcc55\\",\\"row_order\\":\\"6\\",\\"cols\\":[{\\"element_id\\":\\"68aa08c\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 408,
  'post_date' => '2018-08-15 02:20:06',
  'post_date_gmt' => '2018-08-15 02:20:06',
  'post_content' => '<h3>Introduction</h3>
Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.
<ul>
 	<li>Veritatis et quasi architecto beatae.</li>
 	<li>Vitae dicta sunt explicabo.</li>
 	<li>Nemo enim ipsam voluptatem.</li>
</ul>
quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem',
  'post_title' => 'Graphic Design - Visual and Graphic Design',
  'post_excerpt' => '',
  'post_name' => 'graphic-design-visual-and-graphic-design',
  'post_modified' => '2018-08-15 21:02:42',
  'post_modified_gmt' => '2018-08-15 21:02:42',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=lp_course&#038;p=408',
  'menu_order' => 0,
  'post_type' => 'lp_course',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"wb17329\\"}],\\"element_id\\":\\"5ud4882\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/designer-graphic.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 419,
  'post_date' => '2018-08-13 07:25:51',
  'post_date_gmt' => '2018-08-13 07:25:51',
  'post_content' => '<h3><strong>Introduction</strong></h3>
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_title' => 'Introduction to Digital Photography: Learning Outcomes',
  'post_excerpt' => '',
  'post_name' => 'introduction-to-digital-photography-learning-outcomes',
  'post_modified' => '2019-08-01 00:31:00',
  'post_modified_gmt' => '2019-08-01 00:31:00',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=lp_course&#038;p=419',
  'menu_order' => 0,
  'post_type' => 'lp_course',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"grh7815\\",\\"cols\\":[{\\"element_id\\":\\"v3mr816\\",\\"grid_class\\":\\"col-full\\"}]},{\\"element_id\\":\\"qxes905\\",\\"cols\\":[{\\"element_id\\":\\"zmok905\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"box\\",\\"element_id\\":\\"82tm911\\",\\"mod_settings\\":{\\"content_box\\":\\"<p>Box content<\\\\/p>\\",\\"appearance_box\\":\\"\\"}}]}]}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/fotographer-course.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 391,
  'post_date' => '2018-08-12 07:12:35',
  'post_date_gmt' => '2018-08-12 07:12:35',
  'post_content' => '<h3><strong>Introduction</strong></h3>
Ed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem',
  'post_title' => 'Introduction to Spanish',
  'post_excerpt' => '',
  'post_name' => 'introduction-to-spanish',
  'post_modified' => '2018-08-15 21:07:03',
  'post_modified_gmt' => '2018-08-15 21:07:03',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=lp_course&#038;p=391',
  'menu_order' => 0,
  'post_type' => 'lp_course',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"qjxm004\\"}],\\"element_id\\":\\"yw7a005\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/07/taking-courses.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 330,
  'post_date' => '2018-08-11 03:16:41',
  'post_date_gmt' => '2018-08-11 03:16:41',
  'post_content' => '<strong>Introduction</strong>

Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.

Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_title' => 'Advanced Biology 1',
  'post_excerpt' => '',
  'post_name' => 'advanced-biology-1',
  'post_modified' => '2018-08-15 21:08:06',
  'post_modified_gmt' => '2018-08-15 21:08:06',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=lp_course&#038;p=330',
  'menu_order' => 0,
  'post_type' => 'lp_course',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"mkw6742\\"}],\\"element_id\\":\\"cknc074\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/biology-scientist.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 277,
  'post_date' => '2018-08-09 02:45:28',
  'post_date_gmt' => '2018-08-09 02:45:28',
  'post_content' => '<strong>Introduction</strong>

In the beginning, the owners are often the best at making or delivering the product or service. Since they have the most at stake, they often assume a wide variety of roles, including sales, accounting, and much more.

Through a combination of skill, planning, talent, and perhaps luck, some businesses manage to grow. This growth leads to new and changing roles in the business for everyone, including the owner.

Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.

Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_title' => 'Business Analytics',
  'post_excerpt' => '',
  'post_name' => 'business-analytics',
  'post_modified' => '2018-08-15 12:07:22',
  'post_modified_gmt' => '2018-08-15 12:07:22',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=lp_course&#038;p=277',
  'menu_order' => 0,
  'post_type' => 'lp_course',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"3dg6060\\"}],\\"element_id\\":\\"jbjt007\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/finance.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 286,
  'post_date' => '2018-08-08 02:53:59',
  'post_date_gmt' => '2018-08-08 02:53:59',
  'post_content' => '<h3><strong>Introduction</strong></h3>
Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium

totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.

Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur',
  'post_title' => 'Leadership in Business',
  'post_excerpt' => '',
  'post_name' => 'leadership-in-business',
  'post_modified' => '2018-08-15 13:28:48',
  'post_modified_gmt' => '2018-08-15 13:28:48',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=lp_course&#038;p=286',
  'menu_order' => 0,
  'post_type' => 'lp_course',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"detk060\\"}],\\"element_id\\":\\"he6n006\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/leader-talks.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 294,
  'post_date' => '2018-08-07 02:57:11',
  'post_date_gmt' => '2018-08-07 02:57:11',
  'post_content' => '<strong>Introduction</strong>
At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis.
Praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati.

Cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.

Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat',
  'post_title' => 'Social media strategy for small businesses',
  'post_excerpt' => '',
  'post_name' => 'social-media-strategy-for-small-businesses',
  'post_modified' => '2018-08-15 13:18:13',
  'post_modified_gmt' => '2018-08-15 13:18:13',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=lp_course&#038;p=294',
  'menu_order' => 0,
  'post_type' => 'lp_course',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"ieow006\\"}],\\"element_id\\":\\"cyk7074\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/checking-social-media.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 302,
  'post_date' => '2018-08-06 03:04:11',
  'post_date_gmt' => '2018-08-06 03:04:11',
  'post_content' => 'Understanding Dementia

Learning Outcomes

After studying this module you will be able to do the following

Accurately define various forms of definition, describe their symptoms and differentiate them.

Determine the symptoms of early, mild and late stages of Alzheimer’s disease.

Discuss a range of problem behaviors that are associated with Alzheimer’s disease and describe how to treat them.

Discuss the philosophy and values of dementia care.

Develop skills to help families when a loved one has been diagnosed with dementia.',
  'post_title' => 'Caregiving skills dementia care',
  'post_excerpt' => '',
  'post_name' => '302',
  'post_modified' => '2018-08-15 13:28:46',
  'post_modified_gmt' => '2018-08-15 13:28:46',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=lp_course&#038;p=302',
  'menu_order' => 0,
  'post_type' => 'lp_course',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"g19y060\\"}],\\"element_id\\":\\"93f3060\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/dementia-problem.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 310,
  'post_date' => '2018-08-05 03:08:28',
  'post_date_gmt' => '2018-08-05 03:08:28',
  'post_content' => '<h3><strong>Introduction</strong></h3>
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.

Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse

cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_title' => 'Fundamentals of chemistry',
  'post_excerpt' => '',
  'post_name' => 'fundamentals-of-chemistry',
  'post_modified' => '2018-08-15 13:28:44',
  'post_modified_gmt' => '2018-08-15 13:28:44',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=lp_course&#038;p=310',
  'menu_order' => 0,
  'post_type' => 'lp_course',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"vmgx495\\"}],\\"element_id\\":\\"rdz4580\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/understanding-chemistry.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 320,
  'post_date' => '2018-08-04 03:12:51',
  'post_date_gmt' => '2018-08-04 03:12:51',
  'post_content' => '<h3><strong>Introduction</strong></h3>
Identify why there is a need for a muscular system in the human body.
Identify the differences between smooth, striated and cardiac muscles.
Describe the different contractions of striated muscles.

Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt.',
  'post_title' => 'Introduction to the human muscular system',
  'post_excerpt' => '',
  'post_name' => '320',
  'post_modified' => '2018-08-15 13:28:42',
  'post_modified_gmt' => '2018-08-15 13:28:42',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=lp_course&#038;p=320',
  'menu_order' => 0,
  'post_type' => 'lp_course',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"2il3988\\"}],\\"element_id\\":\\"7m4n908\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/human-system.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 340,
  'post_date' => '2018-08-02 03:27:39',
  'post_date_gmt' => '2018-08-02 03:27:39',
  'post_content' => '<h3><strong>Introduction</strong></h3>
Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.

Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt.

Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?',
  'post_title' => 'Psychology perceiving the world around you',
  'post_excerpt' => '',
  'post_name' => 'psychology-perceiving-the-world-around-you',
  'post_modified' => '2018-08-15 13:57:54',
  'post_modified_gmt' => '2018-08-15 13:57:54',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=lp_course&#038;p=340',
  'menu_order' => 0,
  'post_type' => 'lp_course',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"wacm942\\"}],\\"element_id\\":\\"3rql021\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/psycology-gathering.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 347,
  'post_date' => '2018-08-01 03:39:31',
  'post_date_gmt' => '2018-08-01 03:39:31',
  'post_content' => '<h3><strong>Introduction</strong></h3>
This course Renewable Energy Sources is intended to introduce students to the whole area of energy sustainability, climate change and renewable energy technologies. Many greenhouse gases, such as carbon dioxide, nitrous oxide, and methane, occur naturally. However, during the past two centuries, human activities have also added significantly to the level of these naturally occurring gases. In particular, large amounts of carbon dioxide, nitrous oxide, and methane are produced by the use of non-renewable energy sources such as oil, natural gas and coal. For a sustainable future these fossil fuels will have to be replaced by renewable energy sources such as wind and solar energy, and biomass fuels.',
  'post_title' => 'Renewable Energy Sources',
  'post_excerpt' => '',
  'post_name' => 'renewable-energy-sources',
  'post_modified' => '2018-08-15 13:57:51',
  'post_modified_gmt' => '2018-08-15 13:57:51',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=lp_course&#038;p=347',
  'menu_order' => 0,
  'post_type' => 'lp_course',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"8dz7885\\"}],\\"element_id\\":\\"yp4h330\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/renewable-energy.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 373,
  'post_date' => '2018-07-28 04:04:57',
  'post_date_gmt' => '2018-07-28 04:04:57',
  'post_content' => '<h3><strong>Introduction</strong></h3>
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.

Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum',
  'post_title' => 'Fundamentals of childhood and youth studies',
  'post_excerpt' => '',
  'post_name' => 'fundamentals-of-childhood-and-youth-studies',
  'post_modified' => '2018-08-15 13:57:49',
  'post_modified_gmt' => '2018-08-15 13:57:49',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=lp_course&#038;p=373',
  'menu_order' => 0,
  'post_type' => 'lp_course',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"fknf933\\"}],\\"element_id\\":\\"w0el111\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/happy-childhood.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 384,
  'post_date' => '2018-07-27 07:09:29',
  'post_date_gmt' => '2018-07-27 07:09:29',
  'post_content' => 'The Diploma in Web Design course is ideal if you’ve always wanted to create your own website but lacked the skills or knowledge to do so. Aimed at both the novice and intermediate web-designer, this comprehensive, easy-to-understand course will enhance your understanding of web development tools and techniques.

Topics covered include the essential tools for web page development including HTML, Cascading Style Sheets (CSS), and Adobe Dreamweaver. It also examines the practical steps needed to build a website such as registering a domain name and choosing a hosting account.',
  'post_title' => 'Diploma in web design',
  'post_excerpt' => '',
  'post_name' => 'diploma-in-web-design',
  'post_modified' => '2018-08-15 13:58:36',
  'post_modified_gmt' => '2018-08-15 13:58:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=lp_course&#038;p=384',
  'menu_order' => 0,
  'post_type' => 'lp_course',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"w9s9929\\"}],\\"element_id\\":\\"qa78088\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/07/web-designer.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 397,
  'post_date' => '2018-07-25 07:14:50',
  'post_date_gmt' => '2018-07-25 07:14:50',
  'post_content' => '<h3>Introduction</h3>
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum',
  'post_title' => 'Pre algebra mathematics',
  'post_excerpt' => '',
  'post_name' => 'pre-algebra-mathematics',
  'post_modified' => '2018-08-15 13:57:42',
  'post_modified_gmt' => '2018-08-15 13:57:42',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=lp_course&#038;p=397',
  'menu_order' => 0,
  'post_type' => 'lp_course',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"tq95900\\"}],\\"element_id\\":\\"b4ui700\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/07/working-on-algebra.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 226,
  'post_date' => '2018-07-24 14:33:23',
  'post_date_gmt' => '2018-07-24 14:33:23',
  'post_content' => 'Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga',
  'post_title' => 'Natural Science',
  'post_excerpt' => '',
  'post_name' => 'natural-science',
  'post_modified' => '2018-08-15 21:09:03',
  'post_modified_gmt' => '2018-08-15 21:09:03',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=lp_course&#038;p=226',
  'menu_order' => 0,
  'post_type' => 'lp_course',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"wp2u722\\"}],\\"element_id\\":\\"4rd8097\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/07/natural-science.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 252,
  'post_date' => '2018-07-11 15:17:05',
  'post_date_gmt' => '2018-07-11 15:17:05',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.',
  'post_title' => 'Understanding Law',
  'post_excerpt' => '',
  'post_name' => '252',
  'post_modified' => '2018-08-15 21:08:49',
  'post_modified_gmt' => '2018-08-15 21:08:49',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=lp_course&#038;p=252',
  'menu_order' => 0,
  'post_type' => 'lp_course',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"7pta605\\"}],\\"element_id\\":\\"2zmh640\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/law.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 262,
  'post_date' => '2018-07-10 15:26:47',
  'post_date_gmt' => '2018-07-10 15:26:47',
  'post_content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.',
  'post_title' => 'Economic History Academy',
  'post_excerpt' => '',
  'post_name' => 'economic-history-academy',
  'post_modified' => '2018-08-15 21:09:13',
  'post_modified_gmt' => '2018-08-15 21:09:13',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=lp_course&#038;p=262',
  'menu_order' => 0,
  'post_type' => 'lp_course',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"5frd033\\"}],\\"element_id\\":\\"7tzd003\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/economic-markets.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 426,
  'post_date' => '2018-07-10 07:30:16',
  'post_date_gmt' => '2018-07-10 07:30:16',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.',
  'post_title' => 'Introduction to Music Theory',
  'post_excerpt' => '',
  'post_name' => 'introduction-to-music-theory',
  'post_modified' => '2018-08-15 13:57:39',
  'post_modified_gmt' => '2018-08-15 13:57:39',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=lp_course&#038;p=426',
  'menu_order' => 0,
  'post_type' => 'lp_course',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"s7m3000\\"}],\\"element_id\\":\\"066g065\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/music-tutor.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 363,
  'post_date' => '2018-07-06 04:00:48',
  'post_date_gmt' => '2018-07-06 04:00:48',
  'post_content' => '<h3><strong>Introduction</strong></h3>
Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur',
  'post_title' => 'Legal studies laws and the judicial system',
  'post_excerpt' => '',
  'post_name' => 'legal-studies-laws-and-the-judicial-system',
  'post_modified' => '2018-08-15 13:57:36',
  'post_modified_gmt' => '2018-08-15 13:57:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=lp_course&#038;p=363',
  'menu_order' => 0,
  'post_type' => 'lp_course',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"tjkn075\\"}],\\"element_id\\":\\"6hdz777\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/judicial-law.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 281,
  'post_date' => '2018-08-13 02:47:45',
  'post_date_gmt' => '2018-08-13 02:47:45',
  'post_content' => '',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => 'four-stages-of-business-growth',
  'post_modified' => '2018-08-13 02:48:59',
  'post_modified_gmt' => '2018-08-13 02:48:59',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'http://four-stages-of-business-growth',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 405,
  'post_date' => '2018-08-13 07:16:32',
  'post_date_gmt' => '2018-08-13 07:16:32',
  'post_content' => '',
  'post_title' => 'Absolute value',
  'post_excerpt' => '',
  'post_name' => 'absolute-value',
  'post_modified' => '2018-08-13 07:16:32',
  'post_modified_gmt' => '2018-08-13 07:16:32',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'absolute-value',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 406,
  'post_date' => '2018-08-13 07:16:38',
  'post_date_gmt' => '2018-08-13 07:16:38',
  'post_content' => '',
  'post_title' => 'Adding and subtracting integers',
  'post_excerpt' => '',
  'post_name' => 'adding-and-subtracting-integers',
  'post_modified' => '2018-08-13 07:16:38',
  'post_modified_gmt' => '2018-08-13 07:16:38',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'adding-and-subtracting-integers',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 388,
  'post_date' => '2018-08-13 07:09:10',
  'post_date_gmt' => '2018-08-13 07:09:10',
  'post_content' => '',
  'post_title' => 'Adobe Dreamweaver CS3 - Create Web Pages and Web Sites',
  'post_excerpt' => '',
  'post_name' => 'adobe-dreamweaver-cs3-create-web-pages-and-web-sites',
  'post_modified' => '2018-08-13 07:09:10',
  'post_modified_gmt' => '2018-08-13 07:09:10',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'adobe-dreamweaver-cs3-create-web-pages-and-web-sites',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 232,
  'post_date' => '2018-08-12 14:42:52',
  'post_date_gmt' => '2018-08-12 14:42:52',
  'post_content' => '',
  'post_title' => 'Aspects of Special Relativity',
  'post_excerpt' => '',
  'post_name' => 'sed-ut-perspiciatis-unde-omnis-iste-natus-error-sit-voluptatem-accusantium-doloremque-laudantium-totam-rem-aperiam-eaque-ipsa-quae-ab-illo-inventore-veritatis-et-quasi-architecto-beatae-vitae-dicta-2',
  'post_modified' => '2018-08-12 14:53:57',
  'post_modified_gmt' => '2018-08-12 14:53:57',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'http://sed-ut-perspiciatis-unde-omnis-iste-natus-error-sit-voluptatem-accusantium-doloremque-laudantium-totam-rem-aperiam-eaque-ipsa-quae-ab-illo-inventore-veritatis-et-quasi-architecto-beatae-vitae-dicta-2',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 370,
  'post_date' => '2018-08-13 04:00:12',
  'post_date_gmt' => '2018-08-13 04:00:12',
  'post_content' => '',
  'post_title' => 'Assessment',
  'post_excerpt' => '',
  'post_name' => 'assessment',
  'post_modified' => '2018-08-13 04:00:12',
  'post_modified_gmt' => '2018-08-13 04:00:12',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'assessment',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 432,
  'post_date' => '2018-08-13 07:30:08',
  'post_date_gmt' => '2018-08-13 07:30:08',
  'post_content' => '',
  'post_title' => 'Assessment',
  'post_excerpt' => '',
  'post_name' => 'assessment-2',
  'post_modified' => '2018-08-13 07:30:08',
  'post_modified_gmt' => '2018-08-13 07:30:08',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'assessment-2',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 315,
  'post_date' => '2018-08-13 03:08:06',
  'post_date_gmt' => '2018-08-13 03:08:06',
  'post_content' => '',
  'post_title' => 'Atoms',
  'post_excerpt' => '',
  'post_name' => 'atoms',
  'post_modified' => '2018-08-13 03:08:06',
  'post_modified_gmt' => '2018-08-13 03:08:06',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'atoms',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 428,
  'post_date' => '2018-08-13 07:29:34',
  'post_date_gmt' => '2018-08-13 07:29:34',
  'post_content' => '',
  'post_title' => 'Augmented and Diminished Intervals',
  'post_excerpt' => '',
  'post_name' => 'augmented-and-diminished-intervals',
  'post_modified' => '2018-08-13 07:29:34',
  'post_modified_gmt' => '2018-08-13 07:29:34',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'augmented-and-diminished-intervals',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 394,
  'post_date' => '2018-08-13 07:11:10',
  'post_date_gmt' => '2018-08-13 07:11:10',
  'post_content' => '',
  'post_title' => 'Basic Spanish Assessment',
  'post_excerpt' => '',
  'post_name' => 'basic-spanish-assessment',
  'post_modified' => '2018-08-13 07:11:10',
  'post_modified_gmt' => '2018-08-13 07:11:10',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'basic-spanish-assessment',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 231,
  'post_date' => '2018-08-12 14:42:49',
  'post_date_gmt' => '2018-08-12 14:42:49',
  'post_content' => '',
  'post_title' => 'Biochemistry, Physiology and Genetics of Microorganisms.',
  'post_excerpt' => '',
  'post_name' => 'sed-ut-perspiciatis-unde-omnis-iste-natus-error-sit-voluptatem-accusantium-doloremque-laudantium-totam-rem-aperiam-eaque-ipsa-quae-ab-illo-inventore-veritatis-et-quasi-architecto-beatae-vitae-dicta',
  'post_modified' => '2018-08-12 14:54:13',
  'post_modified_gmt' => '2018-08-12 14:54:13',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'http://sed-ut-perspiciatis-unde-omnis-iste-natus-error-sit-voluptatem-accusantium-doloremque-laudantium-totam-rem-aperiam-eaque-ipsa-quae-ab-illo-inventore-veritatis-et-quasi-architecto-beatae-vitae-dicta',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 241,
  'post_date' => '2018-08-12 14:50:54',
  'post_date_gmt' => '2018-08-12 14:50:54',
  'post_content' => '',
  'post_title' => 'Biological Oceanography',
  'post_excerpt' => '',
  'post_name' => 'biological-oceanography',
  'post_modified' => '2018-08-12 14:54:21',
  'post_modified_gmt' => '2018-08-12 14:54:21',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'http://biological-oceanography',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 275,
  'post_date' => '2018-08-12 16:41:42',
  'post_date_gmt' => '2018-08-12 16:41:42',
  'post_content' => '',
  'post_title' => 'Black Gold Effects',
  'post_excerpt' => '',
  'post_name' => 'black-gold-effects',
  'post_modified' => '2018-08-12 16:41:42',
  'post_modified_gmt' => '2018-08-12 16:41:42',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'black-gold-effects',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 431,
  'post_date' => '2018-08-13 07:29:52',
  'post_date_gmt' => '2018-08-13 07:29:52',
  'post_content' => '',
  'post_title' => 'Cadence',
  'post_excerpt' => '',
  'post_name' => 'cadence',
  'post_modified' => '2018-08-13 07:29:52',
  'post_modified_gmt' => '2018-08-13 07:29:52',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'cadence',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 306,
  'post_date' => '2018-08-13 03:04:08',
  'post_date_gmt' => '2018-08-13 03:04:08',
  'post_content' => '',
  'post_title' => 'Caregiving Skills - Dementia Care',
  'post_excerpt' => '',
  'post_name' => 'caregiving-skills-dementia-care',
  'post_modified' => '2018-08-13 03:04:08',
  'post_modified_gmt' => '2018-08-13 03:04:08',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'caregiving-skills-dementia-care',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 387,
  'post_date' => '2018-08-13 07:09:01',
  'post_date_gmt' => '2018-08-13 07:09:01',
  'post_content' => '',
  'post_title' => 'Cascading Style Sheets - Style Web Pages',
  'post_excerpt' => '',
  'post_name' => 'cascading-style-sheets-style-web-pages',
  'post_modified' => '2018-08-13 07:09:01',
  'post_modified_gmt' => '2018-08-13 07:09:01',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'cascading-style-sheets-style-web-pages',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 332,
  'post_date' => '2018-08-13 03:15:58',
  'post_date_gmt' => '2018-08-13 03:15:58',
  'post_content' => '',
  'post_title' => 'Cell theory',
  'post_excerpt' => '',
  'post_name' => 'cell-theory',
  'post_modified' => '2018-08-13 03:15:58',
  'post_modified_gmt' => '2018-08-13 03:15:58',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'cell-theory',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 335,
  'post_date' => '2018-08-13 03:16:20',
  'post_date_gmt' => '2018-08-13 03:16:20',
  'post_content' => '',
  'post_title' => 'Cellular Respiration',
  'post_excerpt' => '',
  'post_name' => 'cellular-respiration',
  'post_modified' => '2018-08-13 03:16:20',
  'post_modified_gmt' => '2018-08-13 03:16:20',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'cellular-respiration',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 365,
  'post_date' => '2018-08-13 03:59:39',
  'post_date_gmt' => '2018-08-13 03:59:39',
  'post_content' => '',
  'post_title' => 'Characteristics of effective laws',
  'post_excerpt' => '',
  'post_name' => 'characteristics-of-effective-laws',
  'post_modified' => '2018-08-13 03:59:39',
  'post_modified_gmt' => '2018-08-13 03:59:39',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'characteristics-of-effective-laws',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 316,
  'post_date' => '2018-08-13 03:08:16',
  'post_date_gmt' => '2018-08-13 03:08:16',
  'post_content' => '',
  'post_title' => 'Chemical bonds',
  'post_excerpt' => '',
  'post_name' => 'chemical-bonds',
  'post_modified' => '2018-08-13 03:08:16',
  'post_modified_gmt' => '2018-08-13 03:08:16',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'chemical-bonds',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 240,
  'post_date' => '2018-08-12 14:50:39',
  'post_date_gmt' => '2018-08-12 14:50:39',
  'post_content' => '',
  'post_title' => 'Chemical Oceanography Theory',
  'post_excerpt' => '',
  'post_name' => 'chemical-oceanography-theory',
  'post_modified' => '2018-08-12 14:54:18',
  'post_modified_gmt' => '2018-08-12 14:54:18',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'http://chemical-oceanography-theory',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 317,
  'post_date' => '2018-08-13 03:08:23',
  'post_date_gmt' => '2018-08-13 03:08:23',
  'post_content' => '',
  'post_title' => 'Chemical reactions',
  'post_excerpt' => '',
  'post_name' => 'chemical-reactions',
  'post_modified' => '2018-08-13 03:08:23',
  'post_modified_gmt' => '2018-08-13 03:08:23',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'chemical-reactions',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 379,
  'post_date' => '2018-08-13 04:04:19',
  'post_date_gmt' => '2018-08-13 04:04:19',
  'post_content' => '',
  'post_title' => 'Children\'s Rights and Participation',
  'post_excerpt' => '',
  'post_name' => 'childrens-rights-and-participation',
  'post_modified' => '2018-08-13 04:04:19',
  'post_modified_gmt' => '2018-08-13 04:04:19',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'childrens-rights-and-participation',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 366,
  'post_date' => '2018-08-13 03:59:49',
  'post_date_gmt' => '2018-08-13 03:59:49',
  'post_content' => '',
  'post_title' => 'Civil and criminal law',
  'post_excerpt' => '',
  'post_name' => 'civil-and-criminal-law',
  'post_modified' => '2018-08-13 03:59:49',
  'post_modified_gmt' => '2018-08-13 03:59:49',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'civil-and-criminal-law',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 352,
  'post_date' => '2018-08-13 03:38:05',
  'post_date_gmt' => '2018-08-13 03:38:05',
  'post_content' => '',
  'post_title' => 'Concentrating Storing and Transporting Energy',
  'post_excerpt' => '',
  'post_name' => 'start-topic-2',
  'post_modified' => '2018-08-13 03:39:20',
  'post_modified_gmt' => '2018-08-13 03:39:20',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'http://start-topic-2',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 404,
  'post_date' => '2018-08-13 07:16:22',
  'post_date_gmt' => '2018-08-13 07:16:22',
  'post_content' => '',
  'post_title' => 'Coordinate system and ordered pairs',
  'post_excerpt' => '',
  'post_name' => 'coordinate-system-and-ordered-pairs',
  'post_modified' => '2018-08-13 07:16:22',
  'post_modified_gmt' => '2018-08-13 07:16:22',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'coordinate-system-and-ordered-pairs',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 423,
  'post_date' => '2018-08-13 07:25:01',
  'post_date_gmt' => '2018-08-13 07:25:01',
  'post_content' => '',
  'post_title' => 'Course assessment',
  'post_excerpt' => '',
  'post_name' => 'course-assessment',
  'post_modified' => '2018-08-13 07:25:01',
  'post_modified_gmt' => '2018-08-13 07:25:01',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'course-assessment',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 297,
  'post_date' => '2018-08-13 02:56:39',
  'post_date_gmt' => '2018-08-13 02:56:39',
  'post_content' => '',
  'post_title' => 'Creating a Dynamic Web Presence',
  'post_excerpt' => '',
  'post_name' => 'creating-a-dynamic-web-presence',
  'post_modified' => '2018-08-13 02:56:39',
  'post_modified_gmt' => '2018-08-13 02:56:39',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'creating-a-dynamic-web-presence',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 256,
  'post_date' => '2018-08-12 15:16:37',
  'post_date_gmt' => '2018-08-12 15:16:37',
  'post_content' => '',
  'post_title' => 'Criminal And Civil Law',
  'post_excerpt' => '',
  'post_name' => 'criminal-and-civil-law',
  'post_modified' => '2018-08-12 15:16:37',
  'post_modified_gmt' => '2018-08-12 15:16:37',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'criminal-and-civil-law',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 353,
  'post_date' => '2018-08-13 03:38:12',
  'post_date_gmt' => '2018-08-13 03:38:12',
  'post_content' => '',
  'post_title' => 'Currently Available Energy Sources',
  'post_excerpt' => '',
  'post_name' => 'currently-available-energy-sources',
  'post_modified' => '2018-08-13 03:38:12',
  'post_modified_gmt' => '2018-08-13 03:38:12',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'currently-available-energy-sources',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 233,
  'post_date' => '2018-08-12 14:43:13',
  'post_date_gmt' => '2018-08-12 14:43:13',
  'post_content' => '',
  'post_title' => 'Differential Geometry',
  'post_excerpt' => '',
  'post_name' => 'at-vero-eos-et-accusamus-et-iusto-odio-dignissimos-ducimus-qui-blanditiis-praesentium-voluptatum',
  'post_modified' => '2018-08-12 14:54:02',
  'post_modified_gmt' => '2018-08-12 14:54:02',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'http://at-vero-eos-et-accusamus-et-iusto-odio-dignissimos-ducimus-qui-blanditiis-praesentium-voluptatum',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 429,
  'post_date' => '2018-08-13 07:29:42',
  'post_date_gmt' => '2018-08-13 07:29:42',
  'post_content' => '',
  'post_title' => 'Ear Training',
  'post_excerpt' => '',
  'post_name' => 'ear-training',
  'post_modified' => '2018-08-13 07:29:42',
  'post_modified_gmt' => '2018-08-13 07:29:42',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'ear-training',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 274,
  'post_date' => '2018-08-12 16:41:34',
  'post_date_gmt' => '2018-08-12 16:41:34',
  'post_content' => '',
  'post_title' => 'Economic Foreign Policy During War',
  'post_excerpt' => '',
  'post_name' => 'economic-foreign-policy-during-war',
  'post_modified' => '2018-08-12 16:41:34',
  'post_modified_gmt' => '2018-08-12 16:41:34',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'economic-foreign-policy-during-war',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 270,
  'post_date' => '2018-08-12 16:40:51',
  'post_date_gmt' => '2018-08-12 16:40:51',
  'post_content' => '',
  'post_title' => 'Economic Tools and Banking',
  'post_excerpt' => '',
  'post_name' => 'economic-tools-and-banking',
  'post_modified' => '2018-08-12 16:40:51',
  'post_modified_gmt' => '2018-08-12 16:40:51',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'economic-tools-and-banking',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 265,
  'post_date' => '2018-08-12 16:39:44',
  'post_date_gmt' => '2018-08-12 16:39:44',
  'post_content' => '',
  'post_title' => 'Economy After Civil War',
  'post_excerpt' => '',
  'post_name' => 'economy-after-civil-war',
  'post_modified' => '2018-08-12 16:39:44',
  'post_modified_gmt' => '2018-08-12 16:39:44',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'economy-after-civil-war',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 271,
  'post_date' => '2018-08-12 16:41:01',
  'post_date_gmt' => '2018-08-12 16:41:01',
  'post_content' => '',
  'post_title' => 'Economy During World War II',
  'post_excerpt' => '',
  'post_name' => 'economy-during-world-war-ii',
  'post_modified' => '2018-08-12 16:41:01',
  'post_modified_gmt' => '2018-08-12 16:41:01',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'economy-during-world-war-ii',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 351,
  'post_date' => '2018-08-13 03:37:57',
  'post_date_gmt' => '2018-08-13 03:37:57',
  'post_content' => '',
  'post_title' => 'Energy Consumption',
  'post_excerpt' => '',
  'post_name' => 'energy-consumption',
  'post_modified' => '2018-08-13 03:37:57',
  'post_modified_gmt' => '2018-08-13 03:37:57',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'energy-consumption',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 355,
  'post_date' => '2018-08-13 03:38:34',
  'post_date_gmt' => '2018-08-13 03:38:34',
  'post_content' => '',
  'post_title' => 'Energy Flows within the Atmosphere',
  'post_excerpt' => '',
  'post_name' => 'start-topic-3',
  'post_modified' => '2018-08-13 03:38:58',
  'post_modified_gmt' => '2018-08-13 03:38:58',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'http://start-topic-3',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 403,
  'post_date' => '2018-08-13 07:16:17',
  'post_date_gmt' => '2018-08-13 07:16:17',
  'post_content' => '',
  'post_title' => 'Equations with variables',
  'post_excerpt' => '',
  'post_name' => 'equations-with-variables',
  'post_modified' => '2018-08-13 07:16:17',
  'post_modified_gmt' => '2018-08-13 07:16:17',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'equations-with-variables',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 401,
  'post_date' => '2018-08-13 07:16:01',
  'post_date_gmt' => '2018-08-13 07:16:01',
  'post_content' => '',
  'post_title' => 'Evaluate expressions',
  'post_excerpt' => '',
  'post_name' => 'evaluate-expressions',
  'post_modified' => '2018-08-13 07:16:01',
  'post_modified_gmt' => '2018-08-13 07:16:01',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'evaluate-expressions',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 377,
  'post_date' => '2018-08-13 04:03:38',
  'post_date_gmt' => '2018-08-13 04:03:38',
  'post_content' => '',
  'post_title' => 'Extra Reading Materials',
  'post_excerpt' => '',
  'post_name' => 'extra-reading-materials-2',
  'post_modified' => '2018-08-13 04:03:38',
  'post_modified_gmt' => '2018-08-13 04:03:38',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'extra-reading-materials-2',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 412,
  'post_date' => '2018-08-13 07:21:32',
  'post_date_gmt' => '2018-08-13 07:21:32',
  'post_content' => '',
  'post_title' => 'Form',
  'post_excerpt' => '',
  'post_name' => 'form',
  'post_modified' => '2018-08-13 07:21:32',
  'post_modified_gmt' => '2018-08-13 07:21:32',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'form',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 283,
  'post_date' => '2018-08-13 02:48:54',
  'post_date_gmt' => '2018-08-13 02:48:54',
  'post_content' => '',
  'post_title' => 'Four stages of organizational growth',
  'post_excerpt' => '',
  'post_name' => 'four-stages-of-organizational-growth',
  'post_modified' => '2018-08-13 02:48:54',
  'post_modified_gmt' => '2018-08-13 02:48:54',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'four-stages-of-organizational-growth',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 273,
  'post_date' => '2018-08-12 16:41:23',
  'post_date_gmt' => '2018-08-12 16:41:23',
  'post_content' => '',
  'post_title' => 'Global Economic Crisis',
  'post_excerpt' => '',
  'post_name' => 'global-economic-crisis',
  'post_modified' => '2018-08-12 16:41:23',
  'post_modified_gmt' => '2018-08-12 16:41:23',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'global-economic-crisis',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 350,
  'post_date' => '2018-08-13 03:37:49',
  'post_date_gmt' => '2018-08-13 03:37:49',
  'post_content' => '',
  'post_title' => 'Government Energy Statistics',
  'post_excerpt' => '',
  'post_name' => 'start-topic',
  'post_modified' => '2018-08-13 03:39:29',
  'post_modified_gmt' => '2018-08-13 03:39:29',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'http://start-topic',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 367,
  'post_date' => '2018-08-13 03:59:54',
  'post_date_gmt' => '2018-08-13 03:59:54',
  'post_content' => '',
  'post_title' => 'How and why the law changes',
  'post_excerpt' => '',
  'post_name' => 'how-and-why-the-law-changes',
  'post_modified' => '2018-08-13 03:59:54',
  'post_modified_gmt' => '2018-08-13 03:59:54',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'how-and-why-the-law-changes',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 368,
  'post_date' => '2018-08-13 04:00:01',
  'post_date_gmt' => '2018-08-13 04:00:01',
  'post_content' => '',
  'post_title' => 'How do judges make laws?',
  'post_excerpt' => '',
  'post_name' => 'how-do-judges-make-laws',
  'post_modified' => '2018-08-13 04:00:01',
  'post_modified_gmt' => '2018-08-13 04:00:01',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'how-do-judges-make-laws',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 386,
  'post_date' => '2018-08-13 07:08:49',
  'post_date_gmt' => '2018-08-13 07:08:49',
  'post_content' => '',
  'post_title' => 'HTML Coding - Create Web pages',
  'post_excerpt' => '',
  'post_name' => 'html-coding-create-web-pages',
  'post_modified' => '2018-08-13 07:08:49',
  'post_modified_gmt' => '2018-08-13 07:08:49',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'html-coding-create-web-pages',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 326,
  'post_date' => '2018-08-13 03:12:46',
  'post_date_gmt' => '2018-08-13 03:12:46',
  'post_content' => '',
  'post_title' => 'Human Muscular System Assessment',
  'post_excerpt' => '',
  'post_name' => 'human-muscular-system-assessment',
  'post_modified' => '2018-08-13 03:12:46',
  'post_modified_gmt' => '2018-08-13 03:12:46',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'human-muscular-system-assessment',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 402,
  'post_date' => '2018-08-13 07:16:08',
  'post_date_gmt' => '2018-08-13 07:16:08',
  'post_content' => '',
  'post_title' => 'Identify properties',
  'post_excerpt' => '',
  'post_name' => 'identify-properties',
  'post_modified' => '2018-08-13 07:16:08',
  'post_modified_gmt' => '2018-08-13 07:16:08',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'identify-properties',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 358,
  'post_date' => '2018-08-13 03:39:06',
  'post_date_gmt' => '2018-08-13 03:39:06',
  'post_content' => '',
  'post_title' => 'Impact of the Industrial Age',
  'post_excerpt' => '',
  'post_name' => 'impact-of-the-industrial-age',
  'post_modified' => '2018-08-13 03:39:06',
  'post_modified_gmt' => '2018-08-13 03:39:06',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'impact-of-the-industrial-age',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 337,
  'post_date' => '2018-08-13 03:16:35',
  'post_date_gmt' => '2018-08-13 03:16:35',
  'post_content' => '',
  'post_title' => 'Inorganic material',
  'post_excerpt' => '',
  'post_name' => 'inorganic-material',
  'post_modified' => '2018-08-13 03:16:35',
  'post_modified_gmt' => '2018-08-13 03:16:35',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'inorganic-material',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 257,
  'post_date' => '2018-08-12 15:16:46',
  'post_date_gmt' => '2018-08-12 15:16:46',
  'post_content' => '',
  'post_title' => 'International Water Law',
  'post_excerpt' => '',
  'post_name' => 'international-water-law',
  'post_modified' => '2018-08-12 15:16:46',
  'post_modified_gmt' => '2018-08-12 15:16:46',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'international-water-law',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 255,
  'post_date' => '2018-08-12 15:16:00',
  'post_date_gmt' => '2018-08-12 15:16:00',
  'post_content' => '',
  'post_title' => 'Interpretation of Legal Law Systems and Codes',
  'post_excerpt' => '',
  'post_name' => 'interpretation-of-legal-law-systems-and-codes',
  'post_modified' => '2018-08-12 15:16:00',
  'post_modified_gmt' => '2018-08-12 15:16:00',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'interpretation-of-legal-law-systems-and-codes',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 393,
  'post_date' => '2018-08-13 07:10:53',
  'post_date_gmt' => '2018-08-13 07:10:53',
  'post_content' => '',
  'post_title' => 'Introduction to Basic Spanish',
  'post_excerpt' => '',
  'post_name' => 'introduction-to-basic-spanish',
  'post_modified' => '2018-08-13 07:10:53',
  'post_modified_gmt' => '2018-08-13 07:10:53',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'introduction-to-basic-spanish',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 422,
  'post_date' => '2018-08-13 07:24:46',
  'post_date_gmt' => '2018-08-13 07:24:46',
  'post_content' => '',
  'post_title' => 'Introduction to Digital Photography',
  'post_excerpt' => '',
  'post_name' => 'introduction-to-digital-photography',
  'post_modified' => '2018-08-13 07:24:46',
  'post_modified_gmt' => '2018-08-13 07:24:46',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'introduction-to-digital-photography',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 322,
  'post_date' => '2018-08-13 03:11:58',
  'post_date_gmt' => '2018-08-13 03:11:58',
  'post_content' => '',
  'post_title' => 'Introduction to Muscle Tissues',
  'post_excerpt' => '',
  'post_name' => 'introduction-to-muscle-tissues',
  'post_modified' => '2018-08-13 03:11:58',
  'post_modified_gmt' => '2018-08-13 03:11:58',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'introduction-to-muscle-tissues',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 323,
  'post_date' => '2018-08-13 03:12:10',
  'post_date_gmt' => '2018-08-13 03:12:10',
  'post_content' => '',
  'post_title' => 'Introduction to Skeletal Muscles',
  'post_excerpt' => '',
  'post_name' => 'introduction-to-skeletal-muscles',
  'post_modified' => '2018-08-13 03:12:10',
  'post_modified_gmt' => '2018-08-13 03:12:10',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'introduction-to-skeletal-muscles',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 324,
  'post_date' => '2018-08-13 03:12:23',
  'post_date_gmt' => '2018-08-13 03:12:23',
  'post_content' => '',
  'post_title' => 'Introduction to Skeletomuscular Mechanics',
  'post_excerpt' => '',
  'post_name' => 'introduction-to-skeletomuscular-mechanics',
  'post_modified' => '2018-08-13 03:12:23',
  'post_modified_gmt' => '2018-08-13 03:12:23',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'introduction-to-skeletomuscular-mechanics',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 298,
  'post_date' => '2018-08-13 02:56:45',
  'post_date_gmt' => '2018-08-13 02:56:45',
  'post_content' => '',
  'post_title' => 'Introduction to Social Media and Business',
  'post_excerpt' => '',
  'post_name' => 'introduction-to-social-media-and-business',
  'post_modified' => '2018-08-13 02:56:45',
  'post_modified_gmt' => '2018-08-13 02:56:45',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'introduction-to-social-media-and-business',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 325,
  'post_date' => '2018-08-13 03:12:32',
  'post_date_gmt' => '2018-08-13 03:12:32',
  'post_content' => '',
  'post_title' => 'Introduction to the Nervous Control of Skeletal Muscles',
  'post_excerpt' => '',
  'post_name' => 'introduction-to-the-nervous-control-of-skeletal-muscles',
  'post_modified' => '2018-08-13 03:12:32',
  'post_modified_gmt' => '2018-08-13 03:12:32',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'introduction-to-the-nervous-control-of-skeletal-muscles',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 416,
  'post_date' => '2018-08-13 07:22:36',
  'post_date_gmt' => '2018-08-13 07:22:36',
  'post_content' => '',
  'post_title' => 'Isometric',
  'post_excerpt' => '',
  'post_name' => 'isometric',
  'post_modified' => '2018-08-13 07:22:36',
  'post_modified_gmt' => '2018-08-13 07:22:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'isometric',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 285,
  'post_date' => '2018-08-13 02:49:43',
  'post_date_gmt' => '2018-08-13 02:49:43',
  'post_content' => '',
  'post_title' => 'Leadership in Business Assessment',
  'post_excerpt' => '',
  'post_name' => 'leadership-in-business-assessment',
  'post_modified' => '2018-08-13 02:49:43',
  'post_modified_gmt' => '2018-08-13 02:49:43',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'leadership-in-business-assessment',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 291,
  'post_date' => '2018-08-13 02:53:55',
  'post_date_gmt' => '2018-08-13 02:53:55',
  'post_content' => '',
  'post_title' => 'Leadership in Business Assessment',
  'post_excerpt' => '',
  'post_name' => 'leadership-in-business-assessment-2',
  'post_modified' => '2018-08-13 02:53:55',
  'post_modified_gmt' => '2018-08-13 02:53:55',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'leadership-in-business-assessment-2',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 288,
  'post_date' => '2018-08-13 02:52:13',
  'post_date_gmt' => '2018-08-13 02:52:13',
  'post_content' => '',
  'post_title' => 'Leading an Entrepreneurial Venture',
  'post_excerpt' => '',
  'post_name' => 'leading-an-entrepreneurial-venture',
  'post_modified' => '2018-08-13 02:52:13',
  'post_modified_gmt' => '2018-08-13 02:52:13',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'leading-an-entrepreneurial-venture',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 410,
  'post_date' => '2018-08-13 07:21:20',
  'post_date_gmt' => '2018-08-13 07:21:20',
  'post_content' => '',
  'post_title' => 'Line',
  'post_excerpt' => '',
  'post_name' => 'line',
  'post_modified' => '2018-08-13 07:21:20',
  'post_modified_gmt' => '2018-08-13 07:21:20',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'line',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 333,
  'post_date' => '2018-08-13 03:16:05',
  'post_date_gmt' => '2018-08-13 03:16:05',
  'post_content' => '',
  'post_title' => 'Main activities and principles of cells',
  'post_excerpt' => '',
  'post_name' => 'main-activities-and-principles-of-cells',
  'post_modified' => '2018-08-13 03:16:05',
  'post_modified_gmt' => '2018-08-13 03:16:05',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'main-activities-and-principles-of-cells',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 290,
  'post_date' => '2018-08-13 02:53:45',
  'post_date_gmt' => '2018-08-13 02:53:45',
  'post_content' => '',
  'post_title' => 'Managing Your Team - Staff Training and Appraisal',
  'post_excerpt' => '',
  'post_name' => 'managing-your-team-staff-training-and-appraisal',
  'post_modified' => '2018-08-13 02:53:45',
  'post_modified_gmt' => '2018-08-13 02:53:45',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'managing-your-team-staff-training-and-appraisal',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 254,
  'post_date' => '2018-08-12 15:15:47',
  'post_date_gmt' => '2018-08-12 15:15:47',
  'post_content' => '',
  'post_title' => 'Modern Law',
  'post_excerpt' => '',
  'post_name' => 'modern-law',
  'post_modified' => '2018-08-12 15:15:47',
  'post_modified_gmt' => '2018-08-12 15:15:47',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'modern-law',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 314,
  'post_date' => '2018-08-13 03:07:48',
  'post_date_gmt' => '2018-08-13 03:07:48',
  'post_content' => '',
  'post_title' => 'Molecules',
  'post_excerpt' => '',
  'post_name' => 'molecules',
  'post_modified' => '2018-08-13 03:07:48',
  'post_modified_gmt' => '2018-08-13 03:07:48',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'molecules',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 336,
  'post_date' => '2018-08-13 03:16:27',
  'post_date_gmt' => '2018-08-13 03:16:27',
  'post_content' => '',
  'post_title' => 'Molecules found in cells',
  'post_excerpt' => '',
  'post_name' => 'molecules-found-in-cells',
  'post_modified' => '2018-08-13 03:16:27',
  'post_modified_gmt' => '2018-08-13 03:16:27',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'molecules-found-in-cells',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 407,
  'post_date' => '2018-08-13 07:16:45',
  'post_date_gmt' => '2018-08-13 07:16:45',
  'post_content' => '',
  'post_title' => 'Multiplication and division with integers',
  'post_excerpt' => '',
  'post_name' => 'multiplication-and-division-with-integers',
  'post_modified' => '2018-08-13 07:16:45',
  'post_modified_gmt' => '2018-08-13 07:16:45',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'multiplication-and-division-with-integers',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 356,
  'post_date' => '2018-08-13 03:38:42',
  'post_date_gmt' => '2018-08-13 03:38:42',
  'post_content' => '',
  'post_title' => 'Natural Greenhouse Gases',
  'post_excerpt' => '',
  'post_name' => 'natural-greenhouse-gases',
  'post_modified' => '2018-08-13 03:38:42',
  'post_modified_gmt' => '2018-08-13 03:38:42',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'natural-greenhouse-gases',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 266,
  'post_date' => '2018-08-12 16:39:58',
  'post_date_gmt' => '2018-08-12 16:39:58',
  'post_content' => '',
  'post_title' => 'New Era of Modern Economy',
  'post_excerpt' => '',
  'post_name' => 'new-era-of-modern-economy',
  'post_modified' => '2018-08-12 16:39:58',
  'post_modified_gmt' => '2018-08-12 16:39:58',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'new-era-of-modern-economy',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 417,
  'post_date' => '2018-08-13 07:22:43',
  'post_date_gmt' => '2018-08-13 07:22:43',
  'post_content' => '',
  'post_title' => 'Oblique',
  'post_excerpt' => '',
  'post_name' => 'oblique',
  'post_modified' => '2018-08-13 07:22:43',
  'post_modified_gmt' => '2018-08-13 07:22:43',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'oblique',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 400,
  'post_date' => '2018-08-13 07:15:53',
  'post_date_gmt' => '2018-08-13 07:15:53',
  'post_content' => '',
  'post_title' => 'Operations in the right order',
  'post_excerpt' => '',
  'post_name' => 'operations-in-the-right-order',
  'post_modified' => '2018-08-13 07:15:53',
  'post_modified_gmt' => '2018-08-13 07:15:53',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'operations-in-the-right-order',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 415,
  'post_date' => '2018-08-13 07:22:26',
  'post_date_gmt' => '2018-08-13 07:22:26',
  'post_content' => '',
  'post_title' => 'Orthogonal',
  'post_excerpt' => '',
  'post_name' => 'orthogonal',
  'post_modified' => '2018-08-13 07:22:26',
  'post_modified_gmt' => '2018-08-13 07:22:26',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'orthogonal',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 414,
  'post_date' => '2018-08-13 07:22:20',
  'post_date_gmt' => '2018-08-13 07:22:20',
  'post_content' => '',
  'post_title' => 'Paraline',
  'post_excerpt' => '',
  'post_name' => 'paraline',
  'post_modified' => '2018-08-13 07:22:20',
  'post_modified_gmt' => '2018-08-13 07:22:20',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'paraline',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 378,
  'post_date' => '2018-08-13 04:04:13',
  'post_date_gmt' => '2018-08-13 04:04:13',
  'post_content' => '',
  'post_title' => 'Parenting and Toddlers - Teaching and Learning at Home',
  'post_excerpt' => '',
  'post_name' => 'parenting-and-toddlers-teaching-and-learning-at-home',
  'post_modified' => '2018-08-13 04:04:13',
  'post_modified_gmt' => '2018-08-13 04:04:13',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'parenting-and-toddlers-teaching-and-learning-at-home',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 230,
  'post_date' => '2018-08-12 14:42:24',
  'post_date_gmt' => '2018-08-12 14:42:24',
  'post_content' => '',
  'post_title' => 'Pathogenic Organisms',
  'post_excerpt' => '',
  'post_name' => 'excepteur-sint-occaecat-cupidatat-non-proident-sunt-in-culpa-qui-officia-deserunt-mollit-anim-id-est-laborum',
  'post_modified' => '2018-08-12 14:54:09',
  'post_modified_gmt' => '2018-08-12 14:54:09',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'http://excepteur-sint-occaecat-cupidatat-non-proident-sunt-in-culpa-qui-officia-deserunt-mollit-anim-id-est-laborum',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 344,
  'post_date' => '2018-08-13 03:25:51',
  'post_date_gmt' => '2018-08-13 03:25:51',
  'post_content' => '',
  'post_title' => 'Perception - Gestalt Principles, Form Perception and Role of Culture',
  'post_excerpt' => '',
  'post_name' => 'perception-gestalt-principles-form-perception-and-role-of-culture',
  'post_modified' => '2018-08-13 03:25:51',
  'post_modified_gmt' => '2018-08-13 03:25:51',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'perception-gestalt-principles-form-perception-and-role-of-culture',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 343,
  'post_date' => '2018-08-13 03:25:44',
  'post_date_gmt' => '2018-08-13 03:25:44',
  'post_content' => '',
  'post_title' => 'Perception - Sensations, External Factors and Signal Detection',
  'post_excerpt' => '',
  'post_name' => 'perception-sensations-external-factors-and-signal-detection',
  'post_modified' => '2018-08-13 03:25:44',
  'post_modified_gmt' => '2018-08-13 03:25:44',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'perception-sensations-external-factors-and-signal-detection',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 418,
  'post_date' => '2018-08-13 07:22:50',
  'post_date_gmt' => '2018-08-13 07:22:50',
  'post_content' => '',
  'post_title' => 'Planometric',
  'post_excerpt' => '',
  'post_name' => 'planometric',
  'post_modified' => '2018-08-13 07:22:50',
  'post_modified_gmt' => '2018-08-13 07:22:50',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'planometric',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 349,
  'post_date' => '2018-08-13 03:37:43',
  'post_date_gmt' => '2018-08-13 03:37:43',
  'post_content' => '',
  'post_title' => 'Present-day energy use',
  'post_excerpt' => '',
  'post_name' => 'present-day-energy-use',
  'post_modified' => '2018-08-13 03:37:43',
  'post_modified_gmt' => '2018-08-13 03:37:43',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'present-day-energy-use',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 342,
  'post_date' => '2018-08-13 03:25:29',
  'post_date_gmt' => '2018-08-13 03:25:29',
  'post_content' => '',
  'post_title' => 'Psychology – Perceiving the World Around You Assessment',
  'post_excerpt' => '',
  'post_name' => 'psychology-perceiving-the-world-around-you-assessment',
  'post_modified' => '2018-08-13 03:25:29',
  'post_modified_gmt' => '2018-08-13 03:25:29',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'psychology-perceiving-the-world-around-you-assessment',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 268,
  'post_date' => '2018-08-12 16:40:19',
  'post_date_gmt' => '2018-08-12 16:40:19',
  'post_content' => '',
  'post_title' => 'Quiz 1',
  'post_excerpt' => '',
  'post_name' => 'quiz-1',
  'post_modified' => '2018-08-12 16:40:19',
  'post_modified_gmt' => '2018-08-12 16:40:19',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'quiz-1',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 237,
  'post_date' => '2018-08-12 14:48:58',
  'post_date_gmt' => '2018-08-12 14:48:58',
  'post_content' => '',
  'post_title' => 'Quiz 2',
  'post_excerpt' => '',
  'post_name' => 'quiz-2',
  'post_modified' => '2018-08-12 14:54:16',
  'post_modified_gmt' => '2018-08-12 14:54:16',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'http://quiz-2',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 276,
  'post_date' => '2018-08-12 16:41:53',
  'post_date_gmt' => '2018-08-12 16:41:53',
  'post_content' => '',
  'post_title' => 'Quiz 3',
  'post_excerpt' => '',
  'post_name' => 'quiz-3',
  'post_modified' => '2018-08-12 16:41:53',
  'post_modified_gmt' => '2018-08-12 16:41:53',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'quiz-3',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 369,
  'post_date' => '2018-08-13 04:00:08',
  'post_date_gmt' => '2018-08-13 04:00:08',
  'post_content' => '',
  'post_title' => 'Relationships between law-making bodies',
  'post_excerpt' => '',
  'post_name' => 'relationships-between-law-making-bodies',
  'post_modified' => '2018-08-13 04:00:08',
  'post_modified_gmt' => '2018-08-13 04:00:08',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'relationships-between-law-making-bodies',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 421,
  'post_date' => '2018-08-13 07:24:40',
  'post_date_gmt' => '2018-08-13 07:24:40',
  'post_content' => '',
  'post_title' => 'Resources for Introduction to Digital Photography',
  'post_excerpt' => '',
  'post_name' => 'resources-for-introduction-to-digital-photography',
  'post_modified' => '2018-08-13 07:24:40',
  'post_modified_gmt' => '2018-08-13 07:24:40',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'resources-for-introduction-to-digital-photography',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 289,
  'post_date' => '2018-08-13 02:53:07',
  'post_date_gmt' => '2018-08-13 02:53:07',
  'post_content' => '',
  'post_title' => 'Selecting Your Team',
  'post_excerpt' => '',
  'post_name' => 'selecting-your-team',
  'post_modified' => '2018-08-13 02:53:07',
  'post_modified_gmt' => '2018-08-13 02:53:07',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'selecting-your-team',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 411,
  'post_date' => '2018-08-13 07:21:27',
  'post_date_gmt' => '2018-08-13 07:21:27',
  'post_content' => '',
  'post_title' => 'Shape',
  'post_excerpt' => '',
  'post_name' => 'shape',
  'post_modified' => '2018-08-13 07:21:27',
  'post_modified_gmt' => '2018-08-13 07:21:27',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'shape',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 299,
  'post_date' => '2018-08-13 02:56:55',
  'post_date_gmt' => '2018-08-13 02:56:55',
  'post_content' => '',
  'post_title' => 'Social Media Platforms',
  'post_excerpt' => '',
  'post_name' => 'social-media-platforms',
  'post_modified' => '2018-08-13 02:56:55',
  'post_modified_gmt' => '2018-08-13 02:56:55',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'social-media-platforms',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 267,
  'post_date' => '2018-08-12 16:40:09',
  'post_date_gmt' => '2018-08-12 16:40:09',
  'post_content' => '',
  'post_title' => 'The Fall of Economy in 1960',
  'post_excerpt' => '',
  'post_name' => 'the-fall-of-economy-in-1960',
  'post_modified' => '2018-08-12 16:40:09',
  'post_modified_gmt' => '2018-08-12 16:40:09',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'the-fall-of-economy-in-1960',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 354,
  'post_date' => '2018-08-13 03:38:29',
  'post_date_gmt' => '2018-08-13 03:38:29',
  'post_content' => '',
  'post_title' => 'The Importance of the Sun',
  'post_excerpt' => '',
  'post_name' => 'the-importance-of-the-sun',
  'post_modified' => '2018-08-13 03:38:29',
  'post_modified_gmt' => '2018-08-13 03:38:29',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'the-importance-of-the-sun',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 312,
  'post_date' => '2018-08-13 03:07:35',
  'post_date_gmt' => '2018-08-13 03:07:35',
  'post_content' => '',
  'post_title' => 'The periodic table',
  'post_excerpt' => '',
  'post_name' => 'the-periodic-table',
  'post_modified' => '2018-08-13 03:07:35',
  'post_modified_gmt' => '2018-08-13 03:07:35',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'the-periodic-table',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 269,
  'post_date' => '2018-08-12 16:40:39',
  'post_date_gmt' => '2018-08-12 16:40:39',
  'post_content' => '',
  'post_title' => 'The Rise of Trading System',
  'post_excerpt' => '',
  'post_name' => 'the-rise-of-trading-system',
  'post_modified' => '2018-08-12 16:40:39',
  'post_modified_gmt' => '2018-08-12 16:40:39',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'the-rise-of-trading-system',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 376,
  'post_date' => '2018-08-13 04:03:31',
  'post_date_gmt' => '2018-08-13 04:03:31',
  'post_content' => '',
  'post_title' => 'The Role of Play in Children\'s Learning',
  'post_excerpt' => '',
  'post_name' => 'the-role-of-play-in-childrens-learning',
  'post_modified' => '2018-08-13 04:03:31',
  'post_modified_gmt' => '2018-08-13 04:03:31',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'the-role-of-play-in-childrens-learning',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 279,
  'post_date' => '2018-08-13 02:47:19',
  'post_date_gmt' => '2018-08-13 02:47:19',
  'post_content' => '',
  'post_title' => 'Three critical duties of business owners',
  'post_excerpt' => '',
  'post_name' => 'three-critical-duties-of-business-owners',
  'post_modified' => '2018-08-13 02:47:19',
  'post_modified_gmt' => '2018-08-13 02:47:19',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'three-critical-duties-of-business-owners',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 413,
  'post_date' => '2018-08-13 07:21:38',
  'post_date_gmt' => '2018-08-13 07:21:38',
  'post_content' => '',
  'post_title' => 'Tone',
  'post_excerpt' => '',
  'post_name' => 'tone',
  'post_modified' => '2018-08-13 07:21:38',
  'post_modified_gmt' => '2018-08-13 07:21:38',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'tone',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 430,
  'post_date' => '2018-08-13 07:29:47',
  'post_date_gmt' => '2018-08-13 07:29:47',
  'post_content' => '',
  'post_title' => 'Triads',
  'post_excerpt' => '',
  'post_name' => 'triads',
  'post_modified' => '2018-08-13 07:29:47',
  'post_modified_gmt' => '2018-08-13 07:29:47',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'triads',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 280,
  'post_date' => '2018-08-13 02:47:27',
  'post_date_gmt' => '2018-08-13 02:47:27',
  'post_content' => '',
  'post_title' => 'Types of business',
  'post_excerpt' => '',
  'post_name' => 'types-of-organizations',
  'post_modified' => '2018-08-13 02:47:49',
  'post_modified_gmt' => '2018-08-13 02:47:49',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'http://types-of-organizations',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 334,
  'post_date' => '2018-08-13 03:16:12',
  'post_date_gmt' => '2018-08-13 03:16:12',
  'post_content' => '',
  'post_title' => 'Types of Cells',
  'post_excerpt' => '',
  'post_name' => 'types-of-cells',
  'post_modified' => '2018-08-13 03:16:12',
  'post_modified_gmt' => '2018-08-13 03:16:12',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'types-of-cells',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 304,
  'post_date' => '2018-08-13 03:03:44',
  'post_date_gmt' => '2018-08-13 03:03:44',
  'post_content' => '',
  'post_title' => 'Understanding the Signs of Dementia',
  'post_excerpt' => '',
  'post_name' => 'understanding-the-signs-of-dementia',
  'post_modified' => '2018-08-13 03:03:44',
  'post_modified_gmt' => '2018-08-13 03:03:44',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'understanding-the-signs-of-dementia',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 296,
  'post_date' => '2018-08-13 02:56:29',
  'post_date_gmt' => '2018-08-13 02:56:29',
  'post_content' => '',
  'post_title' => 'Using Social Media in E-Commerce Assessment',
  'post_excerpt' => '',
  'post_name' => 'using-social-media-in-e-commerce-assessment',
  'post_modified' => '2018-08-13 02:56:29',
  'post_modified_gmt' => '2018-08-13 02:56:29',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'using-social-media-in-e-commerce-assessment',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 313,
  'post_date' => '2018-08-13 03:07:42',
  'post_date_gmt' => '2018-08-13 03:07:42',
  'post_content' => '',
  'post_title' => 'Using symbols',
  'post_excerpt' => '',
  'post_name' => 'using-symbols',
  'post_modified' => '2018-08-13 03:07:42',
  'post_modified_gmt' => '2018-08-13 03:07:42',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'using-symbols',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 375,
  'post_date' => '2018-08-13 04:03:25',
  'post_date_gmt' => '2018-08-13 04:03:25',
  'post_content' => '',
  'post_title' => 'What Do We Mean By Family?',
  'post_excerpt' => '',
  'post_name' => 'extra-reading-materials',
  'post_modified' => '2018-08-13 04:04:38',
  'post_modified_gmt' => '2018-08-13 04:04:38',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'http://extra-reading-materials',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 305,
  'post_date' => '2018-08-13 03:03:54',
  'post_date_gmt' => '2018-08-13 03:03:54',
  'post_content' => '',
  'post_title' => 'Working with Clients with Different Types of Dementia',
  'post_excerpt' => '',
  'post_name' => 'working-with-clients-with-different-types-of-dementia',
  'post_modified' => '2018-08-13 03:03:54',
  'post_modified_gmt' => '2018-08-13 03:03:54',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'working-with-clients-with-different-types-of-dementia',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 380,
  'post_date' => '2018-08-13 04:04:25',
  'post_date_gmt' => '2018-08-13 04:04:25',
  'post_content' => '',
  'post_title' => 'Young People\'s Wellbeing - Working with Young People',
  'post_excerpt' => '',
  'post_name' => 'young-peoples-wellbeing-working-with-young-people',
  'post_modified' => '2018-08-13 04:04:25',
  'post_modified_gmt' => '2018-08-13 04:04:25',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'young-peoples-wellbeing-working-with-young-people',
  'menu_order' => 0,
  'post_type' => 'lp_lesson',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 242,
  'post_date' => '2018-08-12 14:51:12',
  'post_date_gmt' => '2018-08-12 14:51:12',
  'post_content' => '',
  'post_title' => 'Final Quiz',
  'post_excerpt' => '',
  'post_name' => 'final-quiz',
  'post_modified' => '2018-08-12 14:54:24',
  'post_modified_gmt' => '2018-08-12 14:54:24',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'http://final-quiz',
  'menu_order' => 0,
  'post_type' => 'lp_quiz',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 258,
  'post_date' => '2018-08-12 15:16:56',
  'post_date_gmt' => '2018-08-12 15:16:56',
  'post_content' => '',
  'post_title' => 'Final Quiz',
  'post_excerpt' => '',
  'post_name' => 'final-quiz-2',
  'post_modified' => '2018-08-12 15:16:56',
  'post_modified_gmt' => '2018-08-12 15:16:56',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'final-quiz-2',
  'menu_order' => 0,
  'post_type' => 'lp_quiz',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 236,
  'post_date' => '2018-08-12 14:47:15',
  'post_date_gmt' => '2018-08-12 14:47:15',
  'post_content' => '',
  'post_title' => 'Quiz 1',
  'post_excerpt' => '',
  'post_name' => 'quiz-1',
  'post_modified' => '2018-08-12 14:54:05',
  'post_modified_gmt' => '2018-08-12 14:54:05',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'http://quiz-1',
  'menu_order' => 0,
  'post_type' => 'lp_quiz',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 272,
  'post_date' => '2018-08-12 16:41:12',
  'post_date_gmt' => '2018-08-12 16:41:12',
  'post_content' => '',
  'post_title' => 'Quiz 2',
  'post_excerpt' => '',
  'post_name' => 'quiz-2',
  'post_modified' => '2018-08-12 16:41:12',
  'post_modified_gmt' => '2018-08-12 16:41:12',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'quiz-2',
  'menu_order' => 0,
  'post_type' => 'lp_quiz',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 457,
  'post_date' => '2018-08-13 15:30:11',
  'post_date_gmt' => '2018-08-13 15:30:11',
  'post_content' => 'Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.',
  'post_title' => 'Communities Education Conference',
  'post_excerpt' => '',
  'post_name' => 'communities-education-conference',
  'post_modified' => '2018-08-16 23:48:54',
  'post_modified_gmt' => '2018-08-16 23:48:54',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=event&#038;p=457',
  'menu_order' => 0,
  'post_type' => 'event',
  'meta_input' => 
  array (
    'start_date' => '2018-10-17 10:00',
    'end_date' => '2018-10-17 15:00',
    'location' => 'Berklee College of Music',
    'map_address' => 'Boston, MA 02215, USA',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"uw8v500\\"}],\\"element_id\\":\\"61ds550\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/event-educating-people.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 455,
  'post_date' => '2018-08-13 15:26:17',
  'post_date_gmt' => '2018-08-13 15:26:17',
  'post_content' => 'Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?”  repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis.',
  'post_title' => 'ISTE – International Society for Technology in Education',
  'post_excerpt' => '',
  'post_name' => 'iste-international-society-for-technology-in-education',
  'post_modified' => '2019-03-22 22:04:01',
  'post_modified_gmt' => '2019-03-22 22:04:01',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=event&#038;p=455',
  'menu_order' => 0,
  'post_type' => 'event',
  'meta_input' => 
  array (
    'start_date' => '2018-10-15 12:00',
    'end_date' => '2018-10-15 16:00',
    'repeat' => 'week',
    'location' => 'Online',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"cd2e23c\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"fcd399f\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/girl-technology.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 454,
  'post_date' => '2018-08-13 15:24:50',
  'post_date_gmt' => '2018-08-13 15:24:50',
  'post_content' => 'Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates.',
  'post_title' => '2018 Conference on Teaching Excellence',
  'post_excerpt' => '',
  'post_name' => '2018-conference-on-teaching-excellence',
  'post_modified' => '2019-03-22 22:05:07',
  'post_modified_gmt' => '2019-03-22 22:05:07',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=event&#038;p=454',
  'menu_order' => 0,
  'post_type' => 'event',
  'meta_input' => 
  array (
    'start_date' => '2018-10-12 09:00',
    'end_date' => '2026-01-31 14:00',
    'repeat' => 'week',
    'location' => 'University of Dallas',
    'map_address' => '1845 E Northgate Dr, Irving, TX 75062, USA',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"1c820d8\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"52d2453\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/lecturer.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 453,
  'post_date' => '2018-08-13 15:20:22',
  'post_date_gmt' => '2018-08-13 15:20:22',
  'post_content' => 'Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate.<span id="more-371"></span>

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.
<div id="themify_builder_content-75" class="themify_builder_content themify_builder_content-75 themify_builder"></div>',
  'post_title' => 'At-Risk and Struggling Students Conference',
  'post_excerpt' => '',
  'post_name' => 'at-risk-struggling-students-conference',
  'post_modified' => '2018-08-15 15:33:37',
  'post_modified_gmt' => '2018-08-15 15:33:37',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=event&#038;p=453',
  'menu_order' => 0,
  'post_type' => 'event',
  'meta_input' => 
  array (
    'start_date' => '2018-10-05 13:00',
    'end_date' => '2018-10-05 17:00',
    'location' => 'Sheraton Atlanta Hotel',
    'map_address' => '165 Courtland St NE, Atlanta, GA 30303, USA',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"rj98888\\"}],\\"element_id\\":\\"bmpi002\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/discussion-project.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 452,
  'post_date' => '2018-08-13 15:18:22',
  'post_date_gmt' => '2018-08-13 15:18:22',
  'post_content' => 'At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores.

Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.recusandae. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.',
  'post_title' => 'National Charter Schools Conference',
  'post_excerpt' => '',
  'post_name' => 'national-charter-schools-conference',
  'post_modified' => '2018-08-15 15:33:34',
  'post_modified_gmt' => '2018-08-15 15:33:34',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=event&#038;p=452',
  'menu_order' => 0,
  'post_type' => 'event',
  'meta_input' => 
  array (
    'start_date' => '2018-09-12 12:00',
    'end_date' => '2018-09-12 13:00',
    'location' => 'AT&T Executive Education and Conference Center',
    'map_address' => '1900 University Ave, Austin, TX 78705, USA',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"scms715\\"}],\\"element_id\\":\\"khx7024\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/on-conference.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 451,
  'post_date' => '2018-08-13 15:16:34',
  'post_date_gmt' => '2018-08-13 15:16:34',
  'post_content' => 'Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.recusandae. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.<span id="more-378"></span>

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores.',
  'post_title' => 'Canada International Conference on Education (CICE)',
  'post_excerpt' => '',
  'post_name' => 'canada-international-conference-on-education-cice',
  'post_modified' => '2018-08-15 15:11:49',
  'post_modified_gmt' => '2018-08-15 15:11:49',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=event&#038;p=451',
  'menu_order' => 0,
  'post_type' => 'event',
  'meta_input' => 
  array (
    'start_date' => '2018-09-10 09:00',
    'end_date' => '2018-09-10 15:00',
    'location' => 'Toronto Don Valley Hotel & Suites',
    'map_address' => '175 Wynford Dr, North York, ON M3C 1J3, Canada',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"4hpc736\\"}],\\"element_id\\":\\"9t4j903\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/education-event.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 450,
  'post_date' => '2018-08-13 15:13:49',
  'post_date_gmt' => '2018-08-13 15:13:49',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt neque porro quisquam.

Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.',
  'post_title' => 'PBL World',
  'post_excerpt' => '',
  'post_name' => 'pbl-world',
  'post_modified' => '2018-08-15 15:37:13',
  'post_modified_gmt' => '2018-08-15 15:37:13',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=event&#038;p=450',
  'menu_order' => 0,
  'post_type' => 'event',
  'meta_input' => 
  array (
    'start_date' => '2018-09-11 09:00',
    'end_date' => '2018-09-11 13:00',
    'location' => 'Napa Valley Expo RV Park',
    'map_address' => '606 CA-121, Napa, CA 94559, USA',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"6ye4460\\"}],\\"element_id\\":\\"gose890\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/girl-on-test.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 449,
  'post_date' => '2018-08-13 15:11:08',
  'post_date_gmt' => '2018-08-13 15:11:08',
  'post_content' => 'Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.',
  'post_title' => 'EDuTech 2018',
  'post_excerpt' => '',
  'post_name' => 'edutech-2018',
  'post_modified' => '2018-08-15 08:26:07',
  'post_modified_gmt' => '2018-08-15 08:26:07',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=event&#038;p=449',
  'menu_order' => 0,
  'post_type' => 'event',
  'meta_input' => 
  array (
    'start_date' => '2018-09-06 09:00',
    'end_date' => '2018-09-06 13:00',
    'location' => 'Western Sydney University, Bankstown',
    'map_address' => 'Horsley Rd & Bullecourt Road, Milperra NSW 2214, Australia',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"5nlz550\\"}],\\"element_id\\":\\"hfsf000\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/PeopleImages.com-ID1329951.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 448,
  'post_date' => '2018-08-13 15:06:22',
  'post_date_gmt' => '2018-08-13 15:06:22',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur? voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus.',
  'post_title' => 'Studyportals Academy',
  'post_excerpt' => '',
  'post_name' => 'studyportals-academy',
  'post_modified' => '2018-08-15 15:11:50',
  'post_modified_gmt' => '2018-08-15 15:11:50',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=event&#038;p=448',
  'menu_order' => 0,
  'post_type' => 'event',
  'meta_input' => 
  array (
    'start_date' => '2018-09-05 08:00',
    'end_date' => '2018-09-05 14:00',
    'location' => 'Burlingame ',
    'map_address' => '1 Mangini Way, Burlingame, CA 94010, USA

',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"3hz0200\\"}],\\"element_id\\":\\"nea3545\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/attending-event.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 447,
  'post_date' => '2018-08-13 15:03:58',
  'post_date_gmt' => '2018-08-13 15:03:58',
  'post_content' => 'Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.<span id="more-382"></span>

<span id="more-117"></span>Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias.',
  'post_title' => 'National Conference on Diversity, Race and Learning',
  'post_excerpt' => '',
  'post_name' => 'national-conference-on-diversity-race-and-learning',
  'post_modified' => '2018-08-15 15:00:04',
  'post_modified_gmt' => '2018-08-15 15:00:04',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=event&#038;p=447',
  'menu_order' => 0,
  'post_type' => 'event',
  'meta_input' => 
  array (
    'start_date' => '2018-09-04 10:00',
    'end_date' => '2018-09-04 14:00',
    'location' => 'The Ohio State University',
    'map_address' => 'Columbus, OH 43210, USA',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"l4bz233\\"}],\\"element_id\\":\\"1ve2030\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/diversity.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 446,
  'post_date' => '2018-08-13 15:00:57',
  'post_date_gmt' => '2018-08-13 15:00:57',
  'post_content' => 'At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.',
  'post_title' => 'OLC Innovate 2018',
  'post_excerpt' => '',
  'post_name' => 'olc-innovate-2018',
  'post_modified' => '2018-08-15 15:11:55',
  'post_modified_gmt' => '2018-08-15 15:11:55',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=event&#038;p=446',
  'menu_order' => 0,
  'post_type' => 'event',
  'meta_input' => 
  array (
    'start_date' => '2018-09-01 11:00',
    'end_date' => '2018-08-02 16:00',
    'location' => 'Nashville Public Library',
    'map_address' => '615 Church St, Nashville, TN 37219, USA',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"pl4q000\\"}],\\"element_id\\":\\"abri905\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/conference.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 445,
  'post_date' => '2018-08-13 14:59:42',
  'post_date_gmt' => '2018-08-13 14:59:42',
  'post_content' => 'Labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.',
  'post_title' => 'EUA 2018 Annual Conference',
  'post_excerpt' => '',
  'post_name' => 'eua-2018-annual-conference',
  'post_modified' => '2018-08-15 15:10:45',
  'post_modified_gmt' => '2018-08-15 15:10:45',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=event&#038;p=445',
  'menu_order' => 0,
  'post_type' => 'event',
  'meta_input' => 
  array (
    'start_date' => '2018-08-31 09:00',
    'end_date' => '2018-08-31 17:00',
    'location' => 'Newman Center for the Performing Arts',
    'map_address' => '2344 E Iliff Ave, Denver, CO 80210, USA',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"cyc3500\\"}],\\"element_id\\":\\"6mr2657\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/edu-seminars.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 444,
  'post_date' => '2018-08-13 14:56:20',
  'post_date_gmt' => '2018-08-13 14:56:20',
  'post_content' => 'ed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur',
  'post_title' => 'Diversity in Education Conference',
  'post_excerpt' => '',
  'post_name' => 'diversity-in-education-conference',
  'post_modified' => '2018-08-15 08:26:09',
  'post_modified_gmt' => '2018-08-15 08:26:09',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=event&#038;p=444',
  'menu_order' => 0,
  'post_type' => 'event',
  'meta_input' => 
  array (
    'start_date' => '2018-08-29 13:00',
    'end_date' => '2018-08-29 17:00',
    'location' => 'University of Denver',
    'map_address' => '2199 S University Blvd, Denver, CO 80208, USA',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"h9fj336\\"}],\\"element_id\\":\\"w3rm078\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/PeopleImages.com-ID1299652.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 443,
  'post_date' => '2018-08-13 14:48:24',
  'post_date_gmt' => '2018-08-13 14:48:24',
  'post_content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_title' => 'Global Leadership Week',
  'post_excerpt' => '',
  'post_name' => 'global-leadership-week',
  'post_modified' => '2018-08-15 07:45:12',
  'post_modified_gmt' => '2018-08-15 07:45:12',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=event&#038;p=443',
  'menu_order' => 0,
  'post_type' => 'event',
  'meta_input' => 
  array (
    'start_date' => '2018-08-27 07:00',
    'end_date' => '2018-08-30 14:00',
    'location' => 'Online',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"o2sy050\\"}],\\"element_id\\":\\"oknf525\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/meeting.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 442,
  'post_date' => '2018-08-13 14:42:59',
  'post_date_gmt' => '2018-08-13 14:42:59',
  'post_content' => 'At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.',
  'post_title' => 'The Global Education Conference',
  'post_excerpt' => '',
  'post_name' => 'the-global-education-conference',
  'post_modified' => '2018-08-15 07:45:11',
  'post_modified_gmt' => '2018-08-15 07:45:11',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=event&#038;p=442',
  'menu_order' => 0,
  'post_type' => 'event',
  'meta_input' => 
  array (
    'start_date' => '2018-08-25 11:00',
    'end_date' => '2018-08-25 17:00',
    'location' => 'Residence Inn by Marriott Denver Cherry Creek',
    'map_address' => 'Residence Inn by Marriott Denver Cherry Creek
',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"jobh690\\"}],\\"element_id\\":\\"hg4l060\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/office.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 441,
  'post_date' => '2018-08-13 14:38:05',
  'post_date_gmt' => '2018-08-13 14:38:05',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis
<ul>
 	<li>Quasi architecto beatae vitae dicta sunt explicabo.</li>
 	<li>Nemo enim ipsam voluptatem quia voluptas sit.</li>
 	<li>Aspernatur aut odit aut fugit, sed quia consequuntur magni.</li>
</ul>
Dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.',
  'post_title' => 'Students and Social Media',
  'post_excerpt' => '',
  'post_name' => 'students-and-social-media',
  'post_modified' => '2018-12-13 03:12:51',
  'post_modified_gmt' => '2018-12-13 03:12:51',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=event&#038;p=441',
  'menu_order' => 0,
  'post_type' => 'event',
  'meta_input' => 
  array (
    'start_date' => '2018-08-24 10:00',
    'end_date' => '2018-08-24 15:30',
    'location' => 'Louis Armstrong House Museum, Corona, NY',
    'map_address' => '34-56 107th St, Corona, NY 11368, USA',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"krv3627\\"}],\\"element_id\\":\\"tcy3001\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/power-social-media.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 438,
  'post_date' => '2018-08-13 14:24:55',
  'post_date_gmt' => '2018-08-13 14:24:55',
  'post_content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.

Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.
<ul>
 	<li>Cillum dolore eu fugiat</li>
 	<li>Excepteur sint occaecat cupidatat</li>
 	<li>Sunt in culpa qui officia deserunt mollit</li>
</ul>
Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_title' => 'World Academic Summit 2018',
  'post_excerpt' => '',
  'post_name' => 'world-academic-summit-2018',
  'post_modified' => '2019-04-01 01:49:11',
  'post_modified_gmt' => '2019-04-01 01:49:11',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=event&#038;p=438',
  'menu_order' => 0,
  'post_type' => 'event',
  'meta_input' => 
  array (
    'start_date' => '2019-03-29 18:00',
    'end_date' => '2019-03-30 20:00',
    'repeat' => 'week',
    'location' => 'Parsons School of Design New York',
    'map_address' => '66 5th Ave, New York, NY 10011, USA',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"2644cc6\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"df0c173\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/building.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 171,
  'post_date' => '2018-08-10 23:07:09',
  'post_date_gmt' => '2018-08-10 23:07:09',
  'post_content' => 'At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.',
  'post_title' => 'Pre-class Orientation',
  'post_excerpt' => '',
  'post_name' => 'pre-class-orientation',
  'post_modified' => '2018-08-15 15:23:27',
  'post_modified_gmt' => '2018-08-15 15:23:27',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=event&#038;p=171',
  'menu_order' => 0,
  'post_type' => 'event',
  'meta_input' => 
  array (
    'start_date' => '2018-09-07 15:45',
    'end_date' => '2018-09-07 16:30',
    'location' => 'Online',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"uurh203\\"}],\\"element_id\\":\\"1mjx714\\"}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/pre-class-event.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 168,
  'post_date' => '2018-08-10 22:50:33',
  'post_date_gmt' => '2018-08-10 22:50:33',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam,',
  'post_title' => 'Online Eduma Autumn 2018, Canada',
  'post_excerpt' => '',
  'post_name' => 'online-eduma-autumn-2017-canada',
  'post_modified' => '2019-03-07 22:42:18',
  'post_modified_gmt' => '2019-03-07 22:42:18',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=event&#038;p=168',
  'menu_order' => 0,
  'post_type' => 'event',
  'meta_input' => 
  array (
    'start_date' => '2018-11-23 12:30',
    'end_date' => '2018-11-23 14:45',
    'location' => 'Toronto',
    'map_address' => '1 Yonge St
Toronto, ON 
M5E 1W7',
    'buy_tickets' => 'https://themify.me',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"5d63bce\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"0b6008f\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/girl-at-library.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 456,
  'post_date' => '2018-07-13 15:28:17',
  'post_date_gmt' => '2018-07-13 15:28:17',
  'post_content' => 'Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.<span id="more-825"></span>',
  'post_title' => 'New Tech Network Conference',
  'post_excerpt' => '',
  'post_name' => 'new-tech-network-conference',
  'post_modified' => '2019-03-26 22:36:40',
  'post_modified_gmt' => '2019-03-26 22:36:40',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?post_type=event&#038;p=456',
  'menu_order' => 0,
  'post_type' => 'event',
  'meta_input' => 
  array (
    'start_date' => '2018-11-30 10:00',
    'end_date' => '2018-11-30 16:00',
    'location' => 'St. Louis College Prep',
    'map_address' => '1224 Grattan St, St. Louis, MO 63104, USA',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"z51f115\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"lpty256\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-education/files/2018/08/alogarithm.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 218,
  'post_date' => '2018-08-12 07:04:48',
  'post_date_gmt' => '2018-08-12 07:04:48',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '218',
  'post_modified' => '2018-08-12 07:04:48',
  'post_modified_gmt' => '2018-08-12 07:04:48',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=218',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '24',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'company',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 217,
  'post_date' => '2018-08-12 07:04:48',
  'post_date_gmt' => '2018-08-12 07:04:48',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '217',
  'post_modified' => '2018-08-12 07:04:48',
  'post_modified_gmt' => '2018-08-12 07:04:48',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=217',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '31',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'company',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 216,
  'post_date' => '2018-08-12 07:04:48',
  'post_date_gmt' => '2018-08-12 07:04:48',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '216',
  'post_modified' => '2018-08-12 07:04:48',
  'post_modified_gmt' => '2018-08-12 07:04:48',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=216',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '34',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'company',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 214,
  'post_date' => '2018-08-12 07:02:54',
  'post_date_gmt' => '2018-08-12 07:02:54',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '214',
  'post_modified' => '2018-08-12 07:02:54',
  'post_modified_gmt' => '2018-08-12 07:02:54',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=214',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '27',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'links',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 215,
  'post_date' => '2018-08-12 07:02:54',
  'post_date_gmt' => '2018-08-12 07:02:54',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '215',
  'post_modified' => '2018-08-12 07:02:54',
  'post_modified_gmt' => '2018-08-12 07:02:54',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=215',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '21',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'links',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 558,
  'post_date' => '2018-08-17 00:07:25',
  'post_date_gmt' => '2018-08-17 00:07:25',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '558',
  'post_modified' => '2018-08-17 00:07:25',
  'post_modified_gmt' => '2018-08-17 00:07:25',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=558',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '6',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 41,
  'post_date' => '2018-08-08 11:31:34',
  'post_date_gmt' => '2018-08-08 11:31:34',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '41',
  'post_modified' => '2018-08-17 00:07:25',
  'post_modified_gmt' => '2018-08-17 00:07:25',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=41',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '24',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 42,
  'post_date' => '2018-08-08 11:31:34',
  'post_date_gmt' => '2018-08-08 11:31:34',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '42',
  'post_modified' => '2018-08-17 00:07:26',
  'post_modified_gmt' => '2018-08-17 00:07:26',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=42',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '21',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 40,
  'post_date' => '2018-08-08 11:31:34',
  'post_date_gmt' => '2018-08-08 11:31:34',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '40',
  'post_modified' => '2018-08-17 00:07:26',
  'post_modified_gmt' => '2018-08-17 00:07:26',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=40',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '27',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 38,
  'post_date' => '2018-08-08 11:31:34',
  'post_date_gmt' => '2018-08-08 11:31:34',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '38',
  'post_modified' => '2018-08-17 00:07:26',
  'post_modified_gmt' => '2018-08-17 00:07:26',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=38',
  'menu_order' => 5,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '31',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 37,
  'post_date' => '2018-08-08 11:31:34',
  'post_date_gmt' => '2018-08-08 11:31:34',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '37',
  'post_modified' => '2018-08-17 00:07:26',
  'post_modified_gmt' => '2018-08-17 00:07:26',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=37',
  'menu_order' => 6,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '34',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 209,
  'post_date' => '2018-08-12 07:00:16',
  'post_date_gmt' => '2018-08-12 07:00:16',
  'post_content' => '',
  'post_title' => 'Documentation',
  'post_excerpt' => '',
  'post_name' => 'documentation',
  'post_modified' => '2018-08-12 07:02:16',
  'post_modified_gmt' => '2018-08-12 07:02:16',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=209',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '209',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'support',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 210,
  'post_date' => '2018-08-12 07:01:40',
  'post_date_gmt' => '2018-08-12 07:01:40',
  'post_content' => '',
  'post_title' => 'Forums',
  'post_excerpt' => '',
  'post_name' => 'forums',
  'post_modified' => '2018-08-12 07:02:16',
  'post_modified_gmt' => '2018-08-12 07:02:16',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=210',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '210',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'support',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 211,
  'post_date' => '2018-08-12 07:01:40',
  'post_date_gmt' => '2018-08-12 07:01:40',
  'post_content' => '',
  'post_title' => 'Language Packs',
  'post_excerpt' => '',
  'post_name' => 'language-packs',
  'post_modified' => '2018-08-12 07:02:16',
  'post_modified_gmt' => '2018-08-12 07:02:16',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=211',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '211',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'support',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 212,
  'post_date' => '2018-08-12 07:01:40',
  'post_date_gmt' => '2018-08-12 07:01:40',
  'post_content' => '',
  'post_title' => 'Release Status',
  'post_excerpt' => '',
  'post_name' => 'release-status',
  'post_modified' => '2018-08-12 07:02:16',
  'post_modified_gmt' => '2018-08-12 07:02:16',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-education/?p=212',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '212',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'support',
  ),
);
themify_process_post_import( $post );



function themify_import_get_term_id_from_slug( $slug ) {
	$menu = get_term_by( "slug", $slug, "nav_menu" );
	return is_wp_error( $menu ) ? 0 : (int) $menu->term_id;
}

	$widgets = get_option( "widget_themify-social-links" );
$widgets[1002] = array (
  'title' => '',
  'show_link_name' => NULL,
  'open_new_window' => NULL,
  'icon_size' => 'icon-large',
  'orientation' => 'horizontal',
);
update_option( "widget_themify-social-links", $widgets );

$widgets = get_option( "widget_recent-posts" );
$widgets[1003] = array (
  'title' => 'Recent News',
  'number' => 5,
  'show_date' => false,
);
update_option( "widget_recent-posts", $widgets );

$widgets = get_option( "widget_themify-event-post" );
$widgets[1004] = array (
  'title' => 'Events',
  'category' => '0',
  'show_count' => '5',
  'show' => 'upcoming',
);
update_option( "widget_themify-event-post", $widgets );

$widgets = get_option( "widget_themify-twitter" );
$widgets[1005] = array (
  'title' => 'Latest Tweets',
  'username' => 'themify',
  'type' => '0',
  'timeline_height' => '400',
  'timeline_width' => '300',
  'show_count' => '2',
  'hide_timestamp' => NULL,
  'grid_embed_code' => '',
  'hide_footer' => NULL,
  'show_follow' => NULL,
  'follow_text' => '→ Follow me',
  'include_retweets' => NULL,
  'exclude_replies' => NULL,
);
update_option( "widget_themify-twitter", $widgets );

$widgets = get_option( "widget_nav_menu" );
$widgets[1006] = array (
  'title' => 'Company',
  'nav_menu' => themify_import_get_term_id_from_slug( "company" ),
);
update_option( "widget_nav_menu", $widgets );

$widgets = get_option( "widget_nav_menu" );
$widgets[1007] = array (
  'title' => 'Links',
  'nav_menu' => themify_import_get_term_id_from_slug( "links" ),
);
update_option( "widget_nav_menu", $widgets );

$widgets = get_option( "widget_nav_menu" );
$widgets[1008] = array (
  'title' => 'Support',
  'nav_menu' => themify_import_get_term_id_from_slug( "support" ),
);
update_option( "widget_nav_menu", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1009] = array (
  'title' => 'Contact Us',
  'text' => '<i class="ti-mobile"></i> <a href="tel:1200098123487">1 200 098.1234.87</a>
<i class="ti-email"></i> <a href="mailto:support@education.com">support@education.com</a>',
  'filter' => true,
  'visual' => true,
);
update_option( "widget_text", $widgets );



$sidebars_widgets = array (
  'sidebar-main' => 
  array (
    0 => 'themify-social-links-1002',
    1 => 'recent-posts-1003',
    2 => 'themify-event-post-1004',
    3 => 'themify-twitter-1005',
  ),
  'footer-widget-1' => 
  array (
    0 => 'nav_menu-1006',
  ),
  'footer-widget-2' => 
  array (
    0 => 'nav_menu-1007',
  ),
  'footer-widget-3' => 
  array (
    0 => 'nav_menu-1008',
  ),
  'footer-widget-4' => 
  array (
    0 => 'text-1009',
  ),
); 
update_option( "sidebars_widgets", $sidebars_widgets );

$menu_locations = array();
$menu = get_terms( "nav_menu", array( "slug" => "main-navigation" ) );
if( is_array( $menu ) && ! empty( $menu ) ) $menu_locations["main-nav"] = $menu[0]->term_id;
set_theme_mod( "nav_menu_locations", $menu_locations );


$homepage = get_posts( array( 'name' => 'home', 'post_type' => 'page' ) );
			if( is_array( $homepage ) && ! empty( $homepage ) ) {
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $homepage[0]->ID );
			}
			
	ob_start(); ?>a:121:{s:21:"setting-webfonts_list";s:11:"recommended";s:22:"setting-default_layout";s:8:"sidebar1";s:27:"setting-default_post_layout";s:9:"list-post";s:19:"setting-post_filter";s:2:"no";s:23:"setting-disable_masonry";s:3:"yes";s:19:"setting-post_gutter";s:6:"gutter";s:30:"setting-default_layout_display";s:7:"content";s:25:"setting-default_more_text";s:4:"More";s:21:"setting-index_orderby";s:4:"date";s:19:"setting-index_order";s:4:"DESC";s:30:"setting-default_media_position";s:5:"above";s:31:"setting-image_post_feature_size";s:5:"blank";s:24:"setting-image_post_width";s:4:"1160";s:25:"setting-image_post_height";s:3:"560";s:32:"setting-default_page_post_layout";s:12:"sidebar-none";s:37:"setting-default_page_post_layout_type";s:7:"classic";s:42:"setting-default_page_single_media_position";s:5:"above";s:38:"setting-image_post_single_feature_size";s:5:"blank";s:31:"setting-image_post_single_width";s:4:"1160";s:32:"setting-image_post_single_height";s:3:"560";s:36:"setting-search-result_layout_display";s:7:"content";s:36:"setting-search-result_media_position";s:5:"above";s:27:"setting-default_page_layout";s:8:"sidebar1";s:40:"setting-custom_post_tglobal_style_single";s:8:"sidebar1";s:37:"setting-custom_post_lp_course_archive";s:12:"sidebar-none";s:36:"setting-custom_post_lp_course_single";s:8:"sidebar1";s:36:"setting-custom_post_lp_lesson_single";s:8:"sidebar1";s:34:"setting-custom_post_lp_quiz_single";s:8:"sidebar1";s:32:"setting-custom_post_event_single";s:8:"sidebar1";s:38:"setting-default_portfolio_index_layout";s:12:"sidebar-none";s:43:"setting-default_portfolio_index_post_layout";s:5:"grid3";s:29:"setting-portfolio_post_filter";s:3:"yes";s:33:"setting-portfolio_disable_masonry";s:3:"yes";s:24:"setting-portfolio_gutter";s:6:"gutter";s:39:"setting-default_portfolio_index_display";s:4:"none";s:50:"setting-default_portfolio_index_post_meta_category";s:3:"yes";s:49:"setting-default_portfolio_index_unlink_post_image";s:3:"yes";s:39:"setting-default_portfolio_single_layout";s:12:"sidebar-none";s:54:"setting-default_portfolio_single_portfolio_layout_type";s:9:"fullwidth";s:50:"setting-default_portfolio_single_unlink_post_image";s:3:"yes";s:22:"themify_portfolio_slug";s:7:"project";s:53:"setting-customizer_responsive_design_tablet_landscape";s:4:"1280";s:43:"setting-customizer_responsive_design_tablet";s:3:"768";s:43:"setting-customizer_responsive_design_mobile";s:3:"680";s:33:"setting-mobile_menu_trigger_point";s:3:"900";s:24:"setting-gallery_lightbox";s:8:"lightbox";s:27:"setting-page_builder_expiry";s:1:"2";s:21:"setting-header_design";s:17:"header-horizontal";s:28:"setting-exclude_site_tagline";s:2:"on";s:27:"setting-exclude_search_form";s:2:"on";s:19:"setting_search_form";s:11:"live_search";s:19:"setting-exclude_rss";s:2:"on";s:30:"setting-exclude_header_widgets";s:2:"on";s:29:"setting-exclude_social_widget";s:2:"on";s:22:"setting-header_widgets";s:17:"headerwidget-3col";s:21:"setting-footer_design";s:15:"footer-left-col";s:22:"setting-use_float_back";s:2:"on";s:22:"setting-footer_widgets";s:17:"footerwidget-4col";s:30:"setting-footer_widget_position";s:3:"top";s:23:"setting-mega_menu_posts";s:1:"5";s:29:"setting-mega_menu_image_width";s:3:"180";s:30:"setting-mega_menu_image_height";s:3:"120";s:27:"setting-imagefilter_applyto";s:12:"featuredonly";s:29:"setting-color_animation_speed";s:1:"5";s:29:"setting-relationship_taxonomy";s:8:"category";s:37:"setting-relationship_taxonomy_entries";s:1:"3";s:41:"setting-relationship_taxonomy_image_width";s:3:"374";s:42:"setting-relationship_taxonomy_image_height";s:3:"210";s:45:"setting-relationship_taxonomy_display_content";s:4:"none";s:30:"setting-single_slider_autoplay";s:3:"off";s:27:"setting-single_slider_speed";s:6:"normal";s:28:"setting-single_slider_effect";s:5:"slide";s:28:"setting-single_slider_height";s:4:"auto";s:18:"setting-more_posts";s:8:"infinite";s:19:"setting-entries_nav";s:8:"numbered";s:25:"setting-img_php_base_size";s:4:"full";s:27:"setting-global_feature_size";s:5:"blank";s:22:"setting-link_icon_type";s:9:"font-icon";s:32:"setting-link_type_themify-link-0";s:10:"image-icon";s:33:"setting-link_title_themify-link-0";s:7:"Twitter";s:31:"setting-link_img_themify-link-0";s:109:"https://themify.me/demo/themes/ultra-education/wp-content/themes/themify-ultra/themify/img/social/twitter.png";s:32:"setting-link_type_themify-link-1";s:10:"image-icon";s:33:"setting-link_title_themify-link-1";s:8:"Facebook";s:31:"setting-link_img_themify-link-1";s:110:"https://themify.me/demo/themes/ultra-education/wp-content/themes/themify-ultra/themify/img/social/facebook.png";s:32:"setting-link_type_themify-link-2";s:10:"image-icon";s:33:"setting-link_title_themify-link-2";s:7:"Google+";s:31:"setting-link_img_themify-link-2";s:113:"https://themify.me/demo/themes/ultra-education/wp-content/themes/themify-ultra/themify/img/social/google-plus.png";s:32:"setting-link_type_themify-link-3";s:10:"image-icon";s:33:"setting-link_title_themify-link-3";s:7:"YouTube";s:31:"setting-link_img_themify-link-3";s:109:"https://themify.me/demo/themes/ultra-education/wp-content/themes/themify-ultra/themify/img/social/youtube.png";s:32:"setting-link_type_themify-link-4";s:10:"image-icon";s:33:"setting-link_title_themify-link-4";s:9:"Pinterest";s:31:"setting-link_img_themify-link-4";s:111:"https://themify.me/demo/themes/ultra-education/wp-content/themes/themify-ultra/themify/img/social/pinterest.png";s:32:"setting-link_type_themify-link-5";s:9:"font-icon";s:33:"setting-link_title_themify-link-5";s:7:"Twitter";s:32:"setting-link_link_themify-link-5";s:26:"http://twitter.com/themify";s:33:"setting-link_ficon_themify-link-5";s:10:"fa-twitter";s:32:"setting-link_type_themify-link-6";s:9:"font-icon";s:33:"setting-link_title_themify-link-6";s:8:"Facebook";s:32:"setting-link_link_themify-link-6";s:27:"http://facebook.com/themify";s:33:"setting-link_ficon_themify-link-6";s:11:"fa-facebook";s:32:"setting-link_type_themify-link-7";s:9:"font-icon";s:33:"setting-link_title_themify-link-7";s:7:"Google+";s:32:"setting-link_link_themify-link-7";s:45:"https://plus.google.com/109280316400365629341";s:33:"setting-link_ficon_themify-link-7";s:14:"fa-google-plus";s:32:"setting-link_type_themify-link-8";s:9:"font-icon";s:33:"setting-link_title_themify-link-8";s:7:"YouTube";s:32:"setting-link_link_themify-link-8";s:38:"https://www.youtube.com/user/themifyme";s:33:"setting-link_ficon_themify-link-8";s:10:"fa-youtube";s:32:"setting-link_type_themify-link-9";s:9:"font-icon";s:33:"setting-link_title_themify-link-9";s:9:"Pinterest";s:33:"setting-link_ficon_themify-link-9";s:12:"fa-pinterest";s:22:"setting-link_field_ids";s:341:"{"themify-link-0":"themify-link-0","themify-link-1":"themify-link-1","themify-link-2":"themify-link-2","themify-link-3":"themify-link-3","themify-link-4":"themify-link-4","themify-link-5":"themify-link-5","themify-link-6":"themify-link-6","themify-link-7":"themify-link-7","themify-link-8":"themify-link-8","themify-link-9":"themify-link-9"}";s:23:"setting-link_field_hash";s:2:"10";s:30:"setting-page_builder_is_active";s:6:"enable";s:41:"setting-page_builder_animation_appearance";s:4:"none";s:42:"setting-page_builder_animation_parallax_bg";s:4:"none";s:46:"setting-page_builder_animation_parallax_scroll";s:6:"mobile";s:44:"setting-page_builder_animation_sticky_scroll";s:4:"none";s:4:"skin";s:9:"education";s:13:"import_images";s:2:"on";}<?php $themify_data = unserialize( ob_get_clean() );

	// Fix how "skin" option used to save
	if( isset( $themify_data['skin'] ) ) {
		if ( filter_var( $themify_data['skin'], FILTER_VALIDATE_URL ) ) {
			$parsed_skin = parse_url( $value, PHP_URL_PATH );
			$themify_data['skin'] = basename( dirname( $parsed_skin ) );
		}
	}

	themify_set_data( $themify_data );
	
}
themify_do_demo_import();