<?php

defined( 'ABSPATH' ) or die;

$GLOBALS['processed_terms'] = array();
$GLOBALS['processed_posts'] = array();

require_once ABSPATH . 'wp-admin/includes/post.php';
require_once ABSPATH . 'wp-admin/includes/taxonomy.php';
require_once ABSPATH . 'wp-admin/includes/image.php';

/**
 * Add an Import Action, this data is stored for processing after import is done.
 *
 * Each action is sent as an Ajax request and is handled by themify-ajax.php file
 */ 
function themify_add_import_action( $action = '', $data = array() ) {
	global $import_actions;

	if ( ! isset( $import_actions[ $action ] ) ) {
		$import_actions[ $action ] = array();
	}

	$import_actions[ $action ][] = $data;
}

function themify_import_post( $post ) {
	global $processed_posts, $processed_terms;

	if ( ! post_type_exists( $post['post_type'] ) ) {
		return;
	}

	/* Menu items don't have reliable post_title, skip the post_exists check */
	if( $post['post_type'] !== 'nav_menu_item' ) {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
		if ( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
			$processed_posts[ intval( $post['ID'] ) ] = intval( $post_exists );
			return;
		}
	}

	if( $post['post_type'] == 'nav_menu_item' ) {
		if( ! isset( $post['tax_input']['nav_menu'] ) || ! term_exists( $post['tax_input']['nav_menu'], 'nav_menu' ) ) {
			return;
		}
		$_menu_item_type = $post['meta_input']['_menu_item_type'];
		$_menu_item_object_id = $post['meta_input']['_menu_item_object_id'];

		if ( 'taxonomy' == $_menu_item_type && isset( $processed_terms[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_terms[ intval( $_menu_item_object_id ) ];
		} else if ( 'post_type' == $_menu_item_type && isset( $processed_posts[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_posts[ intval( $_menu_item_object_id ) ];
		} else if ( 'custom' != $_menu_item_type ) {
			// associated object is missing or not imported yet, we'll retry later
			// $missing_menu_items[] = $item;
			return;
		}
	}

	$post_parent = ( $post['post_type'] == 'nav_menu_item' ) ? $post['meta_input']['_menu_item_menu_item_parent'] : (int) $post['post_parent'];
	$post['post_parent'] = 0;
	if ( $post_parent ) {
		// if we already know the parent, map it to the new local ID
		if ( isset( $processed_posts[ $post_parent ] ) ) {
			if( $post['post_type'] == 'nav_menu_item' ) {
				$post['meta_input']['_menu_item_menu_item_parent'] = $processed_posts[ $post_parent ];
			} else {
				$post['post_parent'] = $processed_posts[ $post_parent ];
			}
		}
	}

	/**
	 * for hierarchical taxonomies, IDs must be used so wp_set_post_terms can function properly
	 * convert term slugs to IDs for hierarchical taxonomies
	 */
	if( ! empty( $post['tax_input'] ) ) {
		foreach( $post['tax_input'] as $tax => $terms ) {
			if( is_taxonomy_hierarchical( $tax ) ) {
				$terms = explode( ', ', $terms );
				$post['tax_input'][ $tax ] = array_map( 'themify_get_term_id_by_slug', $terms, array_fill( 0, count( $terms ), $tax ) );
			}
		}
	}

	$post['post_author'] = (int) get_current_user_id();
	$post['post_status'] = 'publish';

	$old_id = $post['ID'];

	unset( $post['ID'] );
	$post_id = wp_insert_post( $post, true );
	if( is_wp_error( $post_id ) ) {
		return false;
	} else {
		$processed_posts[ $old_id ] = $post_id;

		return $post_id;
	}
}

function themify_get_placeholder_image() {
	static $placeholder_image = null;

	if( $placeholder_image == null ) {
		if ( ! function_exists( 'WP_Filesystem' ) ) {
			require_once ABSPATH . 'wp-admin/includes/file.php';
		}
		WP_Filesystem();
		global $wp_filesystem;
		$upload = wp_upload_bits( $post['post_name'] . '.jpg', null, $wp_filesystem->get_contents( THEMIFY_DIR . '/img/image-placeholder.jpg' ) );

		if ( $info = wp_check_filetype( $upload['file'] ) )
			$post['post_mime_type'] = $info['type'];
		else
			return new WP_Error( 'attachment_processing_error', __( 'Invalid file type', 'themify' ) );

		$post['guid'] = $upload['url'];
		$post_id = wp_insert_attachment( $post, $upload['file'] );
		wp_update_attachment_metadata( $post_id, wp_generate_attachment_metadata( $post_id, $upload['file'] ) );

		$placeholder_image = $post_id;
	}

	return $placeholder_image;
}

function themify_import_term( $term ) {
	global $processed_terms;

	if( $term_id = term_exists( $term['slug'], $term['taxonomy'] ) ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];
		if ( isset( $term['term_id'] ) )
			$processed_terms[ intval( $term['term_id'] ) ] = (int) $term_id;
		return (int) $term_id;
	}

	if ( empty( $term['parent'] ) ) {
		$parent = 0;
	} else {
		$parent = term_exists( $processed_terms[ intval( $term['parent'] ) ], $term['taxonomy'] );
		if ( is_array( $parent ) ) $parent = $parent['term_id'];
	}

	$id = wp_insert_term( $term['name'], $term['taxonomy'], array(
		'parent' => $parent,
		'slug' => $term['slug'],
		'description' => $term['description'],
	) );
	if ( ! is_wp_error( $id ) ) {
		if ( isset( $term['term_id'] ) ) {
			// success!
			$processed_terms[ intval($term['term_id']) ] = $id['term_id'];
			if ( isset( $term['thumbnail'] ) ) {
				themify_add_import_action( 'term_thumb', array(
					'id' => $id['term_id'],
					'thumb' => $term['thumbnail'],
				) );
			}
			return $term['term_id'];
		}
	}

	return false;
}

function themify_get_term_id_by_slug( $slug, $tax ) {
	$term = get_term_by( 'slug', $slug, $tax );
	if( $term ) {
		return $term->term_id;
	}

	return false;
}

function themify_undo_import_term( $term ) {
	$term_id = term_exists( $term['slug'], $term['taxonomy'] );
	if ( $term_id ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];

		if ( $term_thumbnail = get_term_meta( $term['term_id'], 'thumbnail_id', true ) ) {
			wp_delete_attachment( $term_thumbnail, true );
		}

		if ( isset( $term_id ) ) {
			wp_delete_term( $term_id, $term['taxonomy'] );
		}
	}
}

/**
 * Determine if a post exists based on title, content, and date
 *
 * @global wpdb $wpdb WordPress database abstraction object.
 *
 * @param array $args array of database parameters to check
 * @return int Post ID if post exists, 0 otherwise.
 */
function themify_post_exists( $args = array() ) {
	global $wpdb;

	$query = "SELECT ID FROM $wpdb->posts WHERE 1=1";
	$db_args = array();

	foreach ( $args as $key => $value ) {
		$value = wp_unslash( sanitize_post_field( $key, $value, 0, 'db' ) );
		if( ! empty( $value ) ) {
			$query .= ' AND ' . $key . ' = %s';
			$db_args[] = $value;
		}
	}

	if ( !empty ( $args ) )
		return (int) $wpdb->get_var( $wpdb->prepare($query, $args) );

	return 0;
}

function themify_undo_import_post( $post ) {
	if( $post['post_type'] == 'nav_menu_item' ) {
		$post_exists = themify_post_exists( array(
			'post_name' => $post['post_name'],
			'post_modified' => $post['post_date'],
			'post_type' => 'nav_menu_item',
		) );
	} else {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
	}
	if( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
		/**
		 * check if the post has been modified, if so leave it be
		 *
		 * NOTE: posts are imported using wp_insert_post() which modifies post_modified field
		 * to be the same as post_date, hence to check if the post has been modified,
		 * the post_modified field is compared against post_date in the original post.
		 */
		if( $post['post_date'] == get_post_field( 'post_modified', $post_exists ) ) {
			// find and remove all post attachments
			$attachments = get_posts( array(
				'post_type' => 'attachment',
				'posts_per_page' => -1,
				'post_parent' => $post_exists,
			) );
			if ( $attachments ) {
				foreach ( $attachments as $attachment ) {
					wp_delete_attachment( $attachment->ID, true );
				}
			}
			wp_delete_post( $post_exists, true ); // true: bypass trash
		}
	}
}

function themify_process_post_import( $post ) {
	if( ERASEDEMO ) {
		themify_undo_import_post( $post );
	} else {
		if ( $id = themify_import_post( $post ) ) {
			if ( defined( 'IMPORT_IMAGES' ) && ! IMPORT_IMAGES ) {
				/* if importing images is disabled and post is supposed to have a thumbnail, create a placeholder image instead */
				if ( isset( $post['thumb'] ) ) { // the post is supposed to have featured image
					$placeholder = themify_get_placeholder_image();
					if( ! is_wp_error( $placeholder ) ) {
						set_post_thumbnail( $id, $placeholder );
					}
				}
			} else {
				if ( isset( $post["thumb"] ) ) {
					themify_add_import_action( 'post_thumb', array(
						'id' => $id,
						'thumb' => $post["thumb"],
					) );
				}
				if ( isset( $post["gallery_shortcode"] ) ) {
					themify_add_import_action( 'gallery_field', array(
						'id' => $id,
						'fields' => $post["gallery_shortcode"],
					) );
				}
				if ( isset( $post["_product_image_gallery"] ) ) {
					themify_add_import_action( 'product_gallery', array(
						'id' => $id,
						'images' => $post["_product_image_gallery"],
					) );
				}
			}
		}
	}
}
$thumbs = array();
function themify_do_demo_import() {
global $import_actions;

	if ( isset( $GLOBALS["ThemifyBuilder_Data_Manager"] ) ) {
		remove_action( "save_post", array( $GLOBALS["ThemifyBuilder_Data_Manager"], "save_builder_text_only"), 10, 3 );
	}
$term = array (
  'term_id' => 22,
  'name' => 'News',
  'slug' => 'news',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 23,
  'name' => 'Tips',
  'slug' => 'tips',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 24,
  'name' => 'Lifestyle',
  'slug' => 'lifestyle',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 25,
  'name' => 'Accessories',
  'slug' => 'accessories',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 26,
  'name' => 'Bag',
  'slug' => 'bag',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 27,
  'name' => 'Shoes',
  'slug' => 'shoes',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 28,
  'name' => 'Gadget',
  'slug' => 'gadget',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 19,
  'name' => 'Photography',
  'slug' => 'photography',
  'term_group' => 0,
  'taxonomy' => 'portfolio-category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 20,
  'name' => 'Nature',
  'slug' => 'nature',
  'term_group' => 0,
  'taxonomy' => 'portfolio-category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 21,
  'name' => 'Adventure',
  'slug' => 'adventure',
  'term_group' => 0,
  'taxonomy' => 'portfolio-category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 2,
  'name' => 'Main Navigation',
  'slug' => 'main-navigation',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 18,
  'name' => 'Custom Menu',
  'slug' => 'custom-menu',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$post = array (
  'ID' => 186,
  'post_date' => '2019-01-10 03:50:50',
  'post_date_gmt' => '2019-01-10 03:50:50',
  'post_content' => '<!-- wp:paragraph -->
<p>Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?”&nbsp; repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis.</p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Stardust Sessions',
  'post_excerpt' => '',
  'post_name' => 'fallen-star',
  'post_modified' => '2019-01-21 22:32:33',
  'post_modified_gmt' => '2019-01-21 22:32:33',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?p=186',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'news',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/adventurer.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 182,
  'post_date' => '2019-01-09 03:46:58',
  'post_date_gmt' => '2019-01-09 03:46:58',
  'post_content' => '<!-- wp:paragraph -->
<p>Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.recusandae. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores.</p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'After Work Rituals',
  'post_excerpt' => '',
  'post_name' => 'after-work',
  'post_modified' => '2019-01-21 22:30:21',
  'post_modified_gmt' => '2019-01-21 22:30:21',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?p=182',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'news',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/man-going-to-work.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 178,
  'post_date' => '2019-01-08 03:42:22',
  'post_date_gmt' => '2019-01-08 03:42:22',
  'post_content' => '<!-- wp:paragraph -->
<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt neque porro quisquam.</p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'New York Sunsets',
  'post_excerpt' => '',
  'post_name' => 'new-york-sunset',
  'post_modified' => '2019-01-21 22:31:59',
  'post_modified_gmt' => '2019-01-21 22:31:59',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?p=178',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'news',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/city-sinset.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 172,
  'post_date' => '2019-01-07 03:39:03',
  'post_date_gmt' => '2019-01-07 03:39:03',
  'post_content' => '<!-- wp:paragraph -->
<p>Labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p></p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Alpine Hikes',
  'post_excerpt' => '',
  'post_name' => 'hiking-in-the-snow-mountain',
  'post_modified' => '2019-01-21 22:32:55',
  'post_modified_gmt' => '2019-01-21 22:32:55',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?p=172',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'lifestyle',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/happy-hiker.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 168,
  'post_date' => '2019-01-06 03:20:16',
  'post_date_gmt' => '2019-01-06 03:20:16',
  'post_content' => '<!-- wp:paragraph -->
<p>Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?”&nbsp; repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis.</p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Winter is Coming',
  'post_excerpt' => '',
  'post_name' => 'winter-is-coming',
  'post_modified' => '2019-01-15 17:21:36',
  'post_modified_gmt' => '2019-01-15 17:21:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?p=168',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'news',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/walking-on-snow.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 191,
  'post_date' => '2019-01-05 07:24:37',
  'post_date_gmt' => '2019-01-05 07:24:37',
  'post_content' => '<!-- wp:paragraph -->
<p>Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur? voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus.</p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'New Withe Sneaker',
  'post_excerpt' => '',
  'post_name' => 'new-withe-sneaker',
  'post_modified' => '2019-01-15 17:22:34',
  'post_modified_gmt' => '2019-01-15 17:22:34',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?p=191',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'lifestyle',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/white-sneaker.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 201,
  'post_date' => '2019-01-04 07:29:46',
  'post_date_gmt' => '2019-01-04 07:29:46',
  'post_content' => '<!-- wp:paragraph -->
<p>Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatu.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis.</p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Manhattan Skycrapper',
  'post_excerpt' => '',
  'post_name' => 'manhattan-skycrapper',
  'post_modified' => '2019-01-15 17:22:47',
  'post_modified_gmt' => '2019-01-15 17:22:47',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?p=201',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'news',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/manhattan.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 389,
  'post_date' => '2019-01-03 10:02:57',
  'post_date_gmt' => '2019-01-03 10:02:57',
  'post_content' => '<!-- wp:paragraph -->
<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt neque porro quisquam.</p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => '5 Fun Things to Do with Kids in Winter',
  'post_excerpt' => '',
  'post_name' => '5-fun-things-to-do-with-kids-in-winter',
  'post_modified' => '2019-01-15 17:22:42',
  'post_modified_gmt' => '2019-01-15 17:22:42',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?p=389',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'tips',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/making-of-snowman.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 392,
  'post_date' => '2019-01-02 10:09:08',
  'post_date_gmt' => '2019-01-02 10:09:08',
  'post_content' => '<!-- wp:paragraph -->
<p>Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.recusandae. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores.</p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Kids Fashion on Winter',
  'post_excerpt' => '',
  'post_name' => 'kids-fashion-on-winter',
  'post_modified' => '2019-01-15 17:23:05',
  'post_modified_gmt' => '2019-01-15 17:23:05',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?p=392',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'news, tips',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/kids-walking.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 395,
  'post_date' => '2019-01-01 10:13:42',
  'post_date_gmt' => '2019-01-01 10:13:42',
  'post_content' => '<!-- wp:paragraph -->
<p>Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?”&nbsp; repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis.<a href="javascript:void(0);"></a><br></p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => '5 Beautiful Places to Visit in Winter',
  'post_excerpt' => '',
  'post_name' => '5-beautiful-places-to-visit-in-winter',
  'post_modified' => '2019-01-15 17:23:13',
  'post_modified_gmt' => '2019-01-15 17:23:13',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?p=395',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'lifestyle, news, tips',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/winter-lake.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 398,
  'post_date' => '2018-12-31 10:32:20',
  'post_date_gmt' => '2018-12-31 10:32:20',
  'post_content' => '<!-- wp:paragraph -->
<p>Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur? voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus.</p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Beginner Skier Tips For Adults',
  'post_excerpt' => '',
  'post_name' => 'beginner-skier-tips-for-adults',
  'post_modified' => '2019-01-15 17:23:18',
  'post_modified_gmt' => '2019-01-15 17:23:18',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?p=398',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'tips',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/ski-at-mountain.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 407,
  'post_date' => '2018-01-30 10:35:32',
  'post_date_gmt' => '2018-01-30 10:35:32',
  'post_content' => '<!-- wp:paragraph -->
<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.</p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Winter Romance',
  'post_excerpt' => '',
  'post_name' => 'winter-romance',
  'post_modified' => '2019-01-15 17:23:24',
  'post_modified_gmt' => '2019-01-15 17:23:24',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?p=407',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'lifestyle, news',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/couple-in-snow.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 30,
  'post_date' => '2019-01-09 03:26:03',
  'post_date_gmt' => '2019-01-09 03:26:03',
  'post_content' => '[woocommerce_cart]',
  'post_title' => 'Cart',
  'post_excerpt' => '',
  'post_name' => 'cart',
  'post_modified' => '2019-01-09 03:26:03',
  'post_modified_gmt' => '2019-01-09 03:26:03',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/cart/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 31,
  'post_date' => '2019-01-09 03:26:03',
  'post_date_gmt' => '2019-01-09 03:26:03',
  'post_content' => '[woocommerce_checkout]',
  'post_title' => 'Checkout',
  'post_excerpt' => '',
  'post_name' => 'checkout',
  'post_modified' => '2019-01-09 03:26:03',
  'post_modified_gmt' => '2019-01-09 03:26:03',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/checkout/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 7,
  'post_date' => '2019-01-09 03:20:18',
  'post_date_gmt' => '2019-01-09 03:20:18',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h3><a href="#about">Welcome</a></h3>
<h3><a href="#portfolio">Portfolio</a></h3>
<h3><a href="#shop">Shop</a></h3>
<h3><a href="#blog">Blog</a></h3>
<h3><a href="https://themify.me/demo/themes/ultra-horizontal/story/">My Story</a></h3>
<h3>Welcome To Horizontal</h3> <p>Feel invigorated, inspired, and bring your memories back to life with the Ultra Horizontal Skin! Using vivid colours, horizontal scrolling, and big visual imagery, allow the reader to step into your memories with your breathtaking travel photos.</p> <p>This is the perfect skin to showcase your landscapes and detail shots all at once, using the section scrolling with fancy parallax scrolling effect. The Ultra Horizontal also makes it easy for you to keep yourself afloat during your travels by using the built-in Portfolio and Shop section. Particularly special is the My Story page. Bring your readers in by sharing the big moments in your journey and how you got to where you are. </p>

<figure> <a href="https://themify.me/demo/themes/ultra-horizontal/product/canon-eos6d-camera/"><img src="https://themify.me/demo/themes/ultra-horizontal/files/2019/01/camera-cannon-e60-500x460.jpg" width="500" height="460" alt="camera-cannon-e60" /></a> </figure> 
 
 <h3><a href="https://themify.me/demo/themes/ultra-horizontal/product/canon-eos6d-camera/" title="Canon EOS6D Camera">Canon EOS6D Camera</a></h3> 
 &#36;600.00 <p><a href="/demo/themes/ultra-horizontal/wp-admin/admin-ajax.php?add-to-cart=275" data-quantity="1" data-product_id="275" data-product_sku="" aria-label="Add &ldquo;Canon EOS6D Camera&rdquo; to your cart" rel="nofollow">Add to cart</a></p> [<a href="https://themify.me/demo/themes/ultra-horizontal/wp-admin/post.php?post=275&#038;action=edit">Edit</a>] 
 
 <figure> <a href="https://themify.me/demo/themes/ultra-horizontal/product/frostbyte-google-ski/"><img src="https://themify.me/demo/themes/ultra-horizontal/files/2019/01/frostbyte-google-sky-500x460.jpg" width="500" height="460" alt="frostbyte-google-sky" /></a> </figure> 
 
 <h3><a href="https://themify.me/demo/themes/ultra-horizontal/product/frostbyte-google-ski/" title="Frostbyte Google Ski">Frostbyte Google Ski</a></h3> 
 &#36;250.00 <p><a href="/demo/themes/ultra-horizontal/wp-admin/admin-ajax.php?add-to-cart=346" data-quantity="1" data-product_id="346" data-product_sku="" aria-label="Add &ldquo;Frostbyte Google Ski&rdquo; to your cart" rel="nofollow">Add to cart</a></p> [<a href="https://themify.me/demo/themes/ultra-horizontal/wp-admin/post.php?post=346&#038;action=edit">Edit</a>] 
 
 <figure> <a href="https://themify.me/demo/themes/ultra-horizontal/product/new-balance-walking-shoes/"><img src="https://themify.me/demo/themes/ultra-horizontal/files/2019/01/new-balance-shoes-500x460.jpg" width="500" height="460" alt="new-balance-shoes" /></a> </figure> 
 
 <h3><a href="https://themify.me/demo/themes/ultra-horizontal/product/new-balance-walking-shoes/" title="New Balance Walking Shoes">New Balance Walking Shoes</a></h3> 
 &#36;250.00 <p><a href="/demo/themes/ultra-horizontal/wp-admin/admin-ajax.php?add-to-cart=280" data-quantity="1" data-product_id="280" data-product_sku="" aria-label="Add &ldquo;New Balance Walking Shoes&rdquo; to your cart" rel="nofollow">Add to cart</a></p> [<a href="https://themify.me/demo/themes/ultra-horizontal/wp-admin/post.php?post=280&#038;action=edit">Edit</a>] 
 
 <figure> <a href="https://themify.me/demo/themes/ultra-horizontal/product/eco-laptop-backpack/"><img src="https://themify.me/demo/themes/ultra-horizontal/files/2019/01/laptop-backpack-500x460.jpg" width="500" height="460" alt="laptop-backpack" /></a> </figure> 
 
 <h3><a href="https://themify.me/demo/themes/ultra-horizontal/product/eco-laptop-backpack/" title="Eco Laptop Backpack">Eco Laptop Backpack</a></h3> 
 &#36;250.00 <p><a href="/demo/themes/ultra-horizontal/wp-admin/admin-ajax.php?add-to-cart=272" data-quantity="1" data-product_id="272" data-product_sku="" aria-label="Add &ldquo;Eco Laptop Backpack&rdquo; to your cart" rel="nofollow">Add to cart</a></p> [<a href="https://themify.me/demo/themes/ultra-horizontal/wp-admin/post.php?post=272&#038;action=edit">Edit</a>] 
 
 <figure> <a href="https://themify.me/demo/themes/ultra-horizontal/product/mens-hiking-boots/"><img src="https://themify.me/demo/themes/ultra-horizontal/files/2019/01/hiking-shoes-funky-500x460.jpg" width="500" height="460" alt="hiking-shoes-funky" /></a> </figure> 
 
 <h3><a href="https://themify.me/demo/themes/ultra-horizontal/product/mens-hiking-boots/" title="Men&#8217;s Hiking Boots">Men&#8217;s Hiking Boots</a></h3> 
 &#36;375.00 <p><a href="/demo/themes/ultra-horizontal/wp-admin/admin-ajax.php?add-to-cart=278" data-quantity="1" data-product_id="278" data-product_sku="" aria-label="Add &ldquo;Men&#039;s Hiking Boots&rdquo; to your cart" rel="nofollow">Add to cart</a></p> [<a href="https://themify.me/demo/themes/ultra-horizontal/wp-admin/post.php?post=278&#038;action=edit">Edit</a>] 
 
 <figure> <a href="https://themify.me/demo/themes/ultra-horizontal/product/giro-rainbow-google-sky/"><img src="https://themify.me/demo/themes/ultra-horizontal/files/2019/01/google-sky-rainbow-500x460.jpg" width="500" height="460" alt="google-sky-rainbow" /></a> </figure> 
 
 <h3><a href="https://themify.me/demo/themes/ultra-horizontal/product/giro-rainbow-google-sky/" title="Giro Rainbow Google Ski">Giro Rainbow Google Ski</a></h3> 
 &#36;650.00 <p><a href="/demo/themes/ultra-horizontal/wp-admin/admin-ajax.php?add-to-cart=268" data-quantity="1" data-product_id="268" data-product_sku="" aria-label="Add &ldquo;Giro Rainbow Google Ski&rdquo; to your cart" rel="nofollow">Add to cart</a></p> [<a href="https://themify.me/demo/themes/ultra-horizontal/wp-admin/post.php?post=268&#038;action=edit">Edit</a>]

<h3>Contact</h3> <p>Let\'s chat! As a freelance photographer and full time explorer, I\'d love to help you tackle your next venture. Let me help you either with a photography session, or by designing a site unique to you and your needs. </p>
<form action="https://themify.me/demo/themes/ultra-horizontal/wp-admin/admin-ajax.php" id="contact-0--form" method="post"> <label for="contact-0--contact-name">Your Name </label> <input type="text" name="contact-name" placeholder="" id="contact-0--contact-name" value="" /> <label for="contact-0--contact-email">Your Email </label> <input type="text" name="contact-email" placeholder="" id="contact-0--contact-email" value="" /> <label for="contact-0--contact-subject">Subject *</label> <input type="text" name="contact-subject" placeholder="" id="contact-0--contact-subject" value="" required /> <label for="contact-0--contact-message">Message *</label> <textarea name="contact-message" placeholder="" id="contact-0--contact-message" rows="8" cols="45" required></textarea> <button type="submit"> Send </button> </form><!--/themify_builder_static-->',
  'post_title' => 'Home',
  'post_excerpt' => '',
  'post_name' => 'home',
  'post_modified' => '2019-09-19 15:28:13',
  'post_modified_gmt' => '2019-09-19 15:28:13',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?page_id=7',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'custom_menu' => 'custom-menu',
    'section_full_scrolling' => 'yes',
    'section_scrolling_direction' => 'horizontal',
    'header_design' => 'header-top-bar',
    'fixed_header' => 'yes',
    'mobile_menu_styles' => 'default',
    'header_wrap' => 'transparent',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"95aa6ba\\",\\"cols\\":[{\\"element_id\\":\\"ba46355\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"45c05a1\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"1.8\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3><a href=\\\\\\\\\\\\\\"#about\\\\\\\\\\\\\\">Welcome<\\\\/a><\\\\/h3>\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-horizontal\\\\/files\\\\/2019\\\\/01\\\\/home-about-bg.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#000000_0.40\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#f7f7f7\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"30\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"a8f85b0\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"n0u5689\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"1.8\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3><a href=\\\\\\\\\\\\\\"#portfolio\\\\\\\\\\\\\\">Portfolio<\\\\/a><\\\\/h3>\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-horizontal\\\\/files\\\\/2019\\\\/01\\\\/home-portfolio-bg.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#000000_0.40\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#f7f7f7\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"8629e52\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"5hdf690\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"1.8\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3><a href=\\\\\\\\\\\\\\"#shop\\\\\\\\\\\\\\">Shop<\\\\/a><\\\\/h3>\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-horizontal\\\\/files\\\\/2019\\\\/01\\\\/home-blog-bg.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#000000_0.40\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#f7f7f7\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"30\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"12e11e7\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"vwvt690\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"1.8\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3><a href=\\\\\\\\\\\\\\"#blog\\\\\\\\\\\\\\">Blog<\\\\/a><\\\\/h3>\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-horizontal\\\\/files\\\\/2019\\\\/01\\\\/hiker-at-the-top-bg-blog.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#000000_0.40\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#f7f7f7\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"30\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"55292b8\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"lsy6690\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"1.8\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3><a href=\\\\\\\\\\\\\\"https://themify.me/demo/themes/ultra-horizontal\\\\/story\\\\/\\\\\\\\\\\\\\">My Story<\\\\/a><\\\\/h3>\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-horizontal\\\\/files\\\\/2019\\\\/01\\\\/tower-bg-contact.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#000000_0.40\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#f7f7f7\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"30\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}}],\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"text_align\\":\\"center\\",\\"text_transform\\":\\"uppercase\\",\\"link_color\\":\\"#ffffff\\",\\"text_decoration\\":\\"none\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth-content\\",\\"row_height\\":\\"fullheight\\",\\"row_anchor\\":\\"home\\"}},{\\"element_id\\":\\"48cec81\\",\\"cols\\":[{\\"element_id\\":\\"d929eda\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"6d0516d\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Welcome To Horizontal<\\\\/h3>\\\\n<p>Feel invigorated, inspired, and bring your memories back to life with the Ultra Horizontal Skin! Using vivid colours, horizontal scrolling, and big visual imagery, allow the reader to step into your memories with your breathtaking travel photos.<\\\\/p>\\\\n<p>This is the perfect skin to showcase your landscapes and detail shots all at once, using the section scrolling with fancy parallax scrolling effect. The Ultra Horizontal also makes it easy for you to keep yourself afloat during your travels by using the built-in Portfolio and Shop section. Particularly special is the My Story page. Bring your readers in by sharing the big moments in your journey and how you got to where you are. <\\\\/p>\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#517ffe\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#ffffff\\",\\"padding_right\\":\\"8\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"16\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"02da060\\",\\"grid_class\\":\\"col4-2\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-horizontal\\\\/files\\\\/2019\\\\/01\\\\/mountain-image.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"150\\",\\"padding_bottom\\":\\"150\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth-content\\",\\"row_height\\":\\"fullheight\\",\\"row_anchor\\":\\"welcome\\",\\"custom_css_id\\":\\"about\\"}},{\\"element_id\\":\\"8f5aa1c\\",\\"cols\\":[{\\"element_id\\":\\"e8eeee1\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"portfolio\\",\\"element_id\\":\\"40748c2\\",\\"mod_settings\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"layout_portfolio\\":\\"grid4\\",\\"type_query_portfolio\\":\\"category\\",\\"category_portfolio\\":\\"0|multiple\\",\\"post_filter\\":\\"no\\",\\"portfolio_gutter\\":\\"no-gutter\\",\\"post_per_page_portfolio\\":\\"4\\",\\"order_portfolio\\":\\"desc\\",\\"orderby_portfolio\\":\\"date\\",\\"display_portfolio\\":\\"none\\",\\"img_width_portfolio\\":\\"700\\",\\"img_height_portfolio\\":\\"800\\",\\"hide_post_date_portfolio\\":\\"yes\\",\\"hide_post_meta_portfolio\\":\\"no\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth-content\\",\\"row_height\\":\\"fullheight\\",\\"row_anchor\\":\\"portfolio\\"}},{\\"element_id\\":\\"vb2b682\\",\\"cols\\":[{\\"element_id\\":\\"a9tf692\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"products\\",\\"element_id\\":\\"25ce259\\",\\"mod_settings\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_p_p_ctr_apply_all\\":\\"1\\",\\"checkbox_m_p_ctr_apply_all\\":\\"1\\",\\"b_p_ctr-type\\":\\"top\\",\\"checkbox_p_p_ct_apply_all\\":\\"1\\",\\"checkbox_m_p_ct_apply_all\\":\\"1\\",\\"b_p_ct-type\\":\\"top\\",\\"checkbox_p_p_t_apply_all\\":\\"1\\",\\"checkbox_m_p_t_apply_all\\":\\"1\\",\\"b_p_t-type\\":\\"top\\",\\"checkbox_p_p_p_apply_all\\":\\"1\\",\\"checkbox_m_p_p_apply_all\\":\\"1\\",\\"b_p_p-type\\":\\"top\\",\\"checkbox_p_p_b_apply_all\\":\\"1\\",\\"checkbox_m_p_b_apply_all\\":\\"1\\",\\"b_p_b-type\\":\\"top\\",\\"query_products\\":\\"all\\",\\"category_products\\":\\"0|multiple\\",\\"hide_child_products\\":\\"no\\",\\"hide_free_products\\":\\"no\\",\\"hide_outofstock_products\\":\\"no\\",\\"post_per_page_products\\":\\"6\\",\\"orderby_products\\":\\"date\\",\\"order_products\\":\\"desc\\",\\"template_products\\":\\"list\\",\\"layout_products\\":\\"grid3\\",\\"layout_slider\\":\\"slider-default\\",\\"visible_opt_slider\\":\\"1\\",\\"mob_visible_opt_slider\\":\\"0\\",\\"auto_scroll_opt_slider\\":\\"off\\",\\"scroll_opt_slider\\":\\"1\\",\\"speed_opt_slider\\":\\"normal\\",\\"effect_slider\\":\\"scroll\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"wrap_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"yes\\",\\"show_arrow_slider\\":\\"yes\\",\\"height_slider\\":\\"variable\\",\\"description_products\\":\\"none\\",\\"hide_feat_img_products\\":\\"no\\",\\"img_width_products\\":\\"500\\",\\"img_height_products\\":\\"460\\",\\"unlink_feat_img_products\\":\\"no\\",\\"hide_post_title_products\\":\\"no\\",\\"unlink_post_title_products\\":\\"no\\",\\"hide_price_products\\":\\"no\\",\\"hide_add_to_cart_products\\":\\"no\\",\\"hide_rating_products\\":\\"no\\",\\"hide_sales_badge\\":\\"no\\",\\"hide_page_nav_products\\":\\"yes\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth-content\\",\\"row_height\\":\\"fullheight\\",\\"row_anchor\\":\\"shop\\"}},{\\"element_id\\":\\"wmto682\\",\\"cols\\":[{\\"element_id\\":\\"tolt693\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"53903a8\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_general_solid\\",\\"checkbox_general_padding_apply_all\\":\\"1\\",\\"checkbox_general_margin_apply_all\\":\\"1\\",\\"general_border-type\\":\\"top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_p_t_apply_all\\":\\"1\\",\\"checkbox_m_t_apply_all\\":\\"1\\",\\"b_t-type\\":\\"top\\",\\"checkbox_p_d_apply_all\\":\\"1\\",\\"checkbox_m_d_apply_all\\":\\"1\\",\\"b_d-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"checkbox_c_m_apply_all\\":\\"1\\",\\"c_b-type\\":\\"top\\",\\"checkbox_p_f_i_apply_all\\":\\"1\\",\\"checkbox_m_f_i_apply_all\\":\\"1\\",\\"b_f_i-type\\":\\"top\\",\\"layout_post\\":\\"grid4\\",\\"post_type_post\\":\\"post\\",\\"type_query_post\\":\\"category\\",\\"category_post\\":\\"0|multiple\\",\\"post_tag_post\\":\\"0|multiple\\",\\"product_cat_post\\":\\"0|multiple\\",\\"product_tag_post\\":\\"0|multiple\\",\\"product_shipping_class_post\\":\\"0|multiple\\",\\"post_filter\\":\\"no\\",\\"post_gutter\\":\\"no-gutter\\",\\"post_per_page_post\\":\\"4\\",\\"order_post\\":\\"desc\\",\\"orderby_post\\":\\"date\\",\\"display_post\\":\\"none\\",\\"img_width_post\\":\\"600\\",\\"img_height_post\\":\\"800\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_page_nav_post\\":\\"yes\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth-content\\",\\"row_height\\":\\"fullheight\\",\\"row_anchor\\":\\"blog\\"}},{\\"element_id\\":\\"28401f3\\",\\"cols\\":[{\\"element_id\\":\\"918d5ed\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ocu1694\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Contact<\\\\/h3>\\\\n<p>Let\\\\\\\\\\\'s chat! As a freelance photographer and full time explorer, I\\\\\\\\\\\'d love to help you tackle your next venture. Let me help you either with a photography session, or by designing a site unique to you and your needs. <\\\\/p>\\"}},{\\"mod_name\\":\\"contact\\",\\"element_id\\":\\"d2b474c\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#858585\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"border_inputs-type\\":\\"top\\",\\"border_send-type\\":\\"top\\",\\"checkbox_padding_success_message_apply_all\\":\\"1\\",\\"checkbox_margin_success_message_apply_all\\":\\"1\\",\\"border_success_message-type\\":\\"top\\",\\"checkbox_padding_error_message_apply_all\\":\\"1\\",\\"checkbox_margin_error_message_apply_all\\":\\"1\\",\\"border_error_message-type\\":\\"top\\",\\"layout_contact\\":\\"animated-label\\",\\"gdpr_label\\":\\"I consent to my submitted data being collected and stored\\",\\"field_name_label\\":\\"Your Name\\",\\"field_email_label\\":\\"Your Email\\",\\"field_subject_label\\":\\"Subject\\",\\"field_subject_require\\":\\"yes\\",\\"field_subject_active\\":\\"yes\\",\\"field_message_label\\":\\"Message\\",\\"field_extra\\":\\"{ \\\\\\\\\\\\\\"fields\\\\\\\\\\\\\\": [] }\\",\\"field_sendcopy_label\\":\\"Send a copy to myself\\",\\"field_order\\":\\"{}\\",\\"field_send_label\\":\\"Send\\",\\"field_send_align\\":\\"left\\",\\"field_email_active\\":\\"yes\\",\\"field_name_active\\":\\"yes\\",\\"field_message_active\\":\\"yes\\",\\"contact_sent_from\\":\\"enable\\",\\"field_sendcopy_active\\":\\"\\",\\"field_captcha_active\\":\\"\\",\\"field_email_require\\":\\"\\",\\"field_name_require\\":\\"\\",\\"post_author\\":\\"\\",\\"send_to_admins\\":\\"true\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#85a8d6\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#ffffff\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"8\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"14\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"14\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"d50c1c8\\",\\"grid_class\\":\\"col4-2\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-horizontal\\\\/files\\\\/2019\\\\/01\\\\/map-marker.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth-content\\",\\"row_height\\":\\"fullheight\\",\\"row_anchor\\":\\"contact\\"}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 32,
  'post_date' => '2019-01-09 03:26:03',
  'post_date_gmt' => '2019-01-09 03:26:03',
  'post_content' => '[woocommerce_my_account]',
  'post_title' => 'My account',
  'post_excerpt' => '',
  'post_name' => 'my-account',
  'post_modified' => '2019-01-09 03:26:03',
  'post_modified_gmt' => '2019-01-09 03:26:03',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/my-account/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 29,
  'post_date' => '2019-01-09 03:26:03',
  'post_date_gmt' => '2019-01-09 03:26:03',
  'post_content' => '',
  'post_title' => 'Shop',
  'post_excerpt' => '',
  'post_name' => 'shop',
  'post_modified' => '2019-01-09 03:26:03',
  'post_modified_gmt' => '2019-01-09 03:26:03',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/shop/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 4,
  'post_date' => '2019-01-09 03:19:25',
  'post_date_gmt' => '2019-01-09 03:19:25',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:paragraph -->
<p></p>
<!-- /wp:paragraph --><!--themify_builder_static--><h4>My Story</h4> 
 
 <h1>The Beginning of My Photography Journey</h1> 
 <p>Photography gallery</p> 
 <h3>Introduction</h3> <p>"Take only memories, leave only footprints." The quote from an unknown albeit, wise man stayed was one of the only things I took with me at the end of my last year of college. As a grant scholar graduating summa cum laude, the weight of my professors, mentors, and parents, rolled off my shoulders as soon as I stepped onto the rich amber sands in Iceland.</p> <p>I had found my place. With the smouldering mix of volcanoes, beaches, and icebergs, the Arctic Circle is where regained my voice. I knew right then that I would pursue capturing moments: the mundane and the exquisite, the great and the small. I was ready.</p> 
 Keep Reading 
 
 <h3><em>"I had found my place. With the smouldering mix of volcanoes, beaches, and icebergs, the Arctic Circle is where regained my voice. "</em></h3> 
 <h3>The Next Chapter</h3> <p>Travelling through Iceland, one of the most harsh yet beautiful island countries struck me like ice through the heart. Southeast Asia got my heart pumping. Though it\'s long been on the travellers’ trail, it doesn’t take too much to get off the beaten track – whether it’s to discover that perfect beach or to delve into the lush surrounds of the rainforest. Overlooking the city of Battambang in Cambodia with my DSLR at the ready, I became entranced with a million different stories I could imagine, etched on each person\'s face.</p> 
 Keep Reading 
 
 <h3>Sunset in Paradise</h3> <p>It didn\'t have to be that perfect beach or the humid rainforest to make me realize. It was that moment of pause - to think about my passion and to realize that there would be a way to reach it after all. Anyone could do it. Why not me? My paradise is the pursuit.</p> 
 <h3>Looking To The Future</h3> <p>I\'ve met some amazing clients who have become almost family to me. The numerous travels and projects abroad haven\'t diminished my love for the unknown, but only heightened it. A journey of a thousand miles starts with a single step. I just lucked out with being able to take mine early on in life. And I want to help you with yours. Let me help you start that journey... from one single step to a thousand. Here\'s to you.</p><!--/themify_builder_static-->',
  'post_title' => 'Story',
  'post_excerpt' => '',
  'post_name' => 'story',
  'post_modified' => '2019-02-01 01:52:14',
  'post_modified_gmt' => '2019-02-01 01:52:14',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?page_id=4',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'section_full_scrolling' => 'yes',
    'section_scrolling_direction' => 'horizontal',
    'header_design' => 'header-minbar',
    'mobile_menu_styles' => 'default',
    'header_wrap' => 'transparent',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"2ddbf45\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"0336a5b\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"63f1aea\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"p_margin_bottom\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h4>My Story<\\\\/h4>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"2ddbf45\\",\\"unstick_when_el_mod_id\\":\\"f0ec4c1\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"3a8f0db\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"#ffffff\\",\\"top_margin_divider\\":\\"20\\",\\"bottom_margin_divider\\":\\"20\\",\\"divider_type\\":\\"custom\\",\\"divider_width\\":\\"46\\",\\"divider_align\\":\\"left\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"2ddbf45\\",\\"unstick_when_el_mod_id\\":\\"f0ec4c1\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"f0ec4c1\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h1>The Beginning of My Photography Journey<\\\\/h1>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"2ddbf45\\",\\"unstick_when_el_mod_id\\":\\"63f1aea\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"63f1aea\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Photography gallery<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"f60ebd2\\",\\"unstick_when_el_mod_id\\":\\"f0ec4c1\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#ffffff\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"e2de761\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-2\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-horizontal\\\\/files\\\\/2019\\\\/01\\\\/story-main-image-1600x999.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth\\",\\"row_height\\":\\"fullheight\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"b900944\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"unstick_when_el_mod_id\\":\\"63f1aea\\"}},{\\"element_id\\":\\"b900944\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"7ed71a6\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"5dedca1\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Introduction<\\\\/h3>\\\\n<p>\\\\\\\\\\\\\\"Take only memories, leave only footprints.\\\\\\\\\\\\\\" The quote from an unknown albeit, wise man stayed was one of the only things I took with me at the end of my last year of college. As a grant scholar graduating summa cum laude, the weight of my professors, mentors, and parents, rolled off my shoulders as soon as I stepped onto the rich amber sands in Iceland.<\\\\/p>\\\\n<p>I had found my place. With the smouldering mix of volcanoes, beaches, and icebergs, the Arctic Circle is where regained my voice. I knew right then that I would pursue capturing moments: the mundane and the exquisite, the great and the small. I was ready.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"2ddbf45\\",\\"unstick_when_el_mod_id\\":\\"f0ec4c1\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"be8c861\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"f_s_i\\":\\"15\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"none\\",\\"icon_position\\":\\"icon_position_right\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-arrow-right\\",\\"icon_color_bg\\":\\"black\\",\\"label\\":\\"Keep Reading\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"2ddbf45\\",\\"unstick_when_el_mod_id\\":\\"f0ec4c1\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"98c2c36\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"2\\",\\"color_divider\\":\\"#d2d5d7\\",\\"bottom_margin_divider\\":\\"50\\",\\"divider_type\\":\\"custom\\",\\"divider_width\\":\\"112\\",\\"divider_align\\":\\"left\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"2ddbf45\\",\\"unstick_when_el_mod_id\\":\\"f0ec4c1\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"2ca1621\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3><em>\\\\\\\\\\\\\\"I had found my place. With the smouldering mix of volcanoes, beaches, and icebergs, the Arctic Circle is where regained my voice. \\\\\\\\\\\\\\"<\\\\/em><\\\\/h3>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"2ddbf45\\",\\"unstick_when_el_mod_id\\":\\"f0ec4c1\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"8\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"6b7ac69\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-horizontal\\\\/files\\\\/2019\\\\/01\\\\/introduction-image-1.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}}],\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"row_height\\":\\"fullheight\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"7\\",\\"padding_top_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"2ddbf45\\",\\"unstick_when_el_mod_id\\":\\"63f1aea\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"b900944\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"7ed71a6\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"5dedca1\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>The Next Chapter<\\\\/h3>\\\\n<p>Travelling through Iceland, one of the most harsh yet beautiful island countries struck me like ice through the heart. Southeast Asia got my heart pumping. Though it\\\\\\\\\\\'s long been on the travellers’ trail, it doesn’t take too much to get off the beaten track – whether it’s to discover that perfect beach or to delve into the lush surrounds of the rainforest. Overlooking the city of Battambang in Cambodia with my DSLR at the ready, I became entranced with a million different stories I could imagine, etched on each person\\\\\\\\\\\'s face.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"2ddbf45\\",\\"unstick_when_el_mod_id\\":\\"f0ec4c1\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"be8c861\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"f_s_i\\":\\".8\\",\\"f_s_i_unit\\":\\"em\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"none\\",\\"icon_position\\":\\"icon_position_right\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-arrow-right\\",\\"icon_color_bg\\":\\"black\\",\\"label\\":\\"Keep Reading\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"2ddbf45\\",\\"unstick_when_el_mod_id\\":\\"f0ec4c1\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"98c2c36\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"2\\",\\"color_divider\\":\\"#d2d5d7\\",\\"bottom_margin_divider\\":\\"50\\",\\"divider_type\\":\\"custom\\",\\"divider_width\\":\\"112\\",\\"divider_align\\":\\"left\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"2ddbf45\\",\\"unstick_when_el_mod_id\\":\\"f0ec4c1\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"6\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"6\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"6b7ac69\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-2\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-horizontal\\\\/files\\\\/2019\\\\/01\\\\/history.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}}],\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"row_height\\":\\"fullheight\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"2ddbf45\\",\\"unstick_when_el_mod_id\\":\\"63f1aea\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"627f8e6\\",\\"row_order\\":\\"3\\",\\"cols\\":[{\\"element_id\\":\\"9938504\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-1\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"thumbnail\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"3500\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"left-top\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"px\\",\\"top-frame_height_unit\\":\\"px\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"px\\",\\"bottom-frame_height_unit\\":\\"px\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"px\\",\\"left-frame_height_unit\\":\\"px\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"px\\",\\"right-frame_height_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"2a03845\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"23a3b0c\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<h3>Sunset in Paradise<\\\\/h3>\\\\n<p>It didn\\\\\\\\\\\'t have to be that perfect beach or the humid rainforest to make me realize. It was that moment of pause - to think about my passion and to realize that there would be a way to reach it after all. Anyone could do it. Why not me? My paradise is the pursuit.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"2ddbf45\\",\\"unstick_when_el_mod_id\\":\\"63f1aea\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#ffffff\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"6d0e3c0\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col4-1\\"}],\\"column_alignment\\":\\"col_align_bottom\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-horizontal\\\\/files\\\\/2019\\\\/01\\\\/sunset-in-paradise.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-bottom\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth-content\\",\\"row_height\\":\\"fullheight\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"2ddbf45\\",\\"unstick_when_el_mod_id\\":\\"63f1aea\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"501f980\\",\\"row_order\\":\\"4\\",\\"cols\\":[{\\"element_id\\":\\"65284e2\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"styling\\":{\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-horizontal\\\\/files\\\\/2019\\\\/01\\\\/future.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-bottom\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth-content\\",\\"row_height\\":\\"fullheight\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"2ddbf45\\",\\"unstick_when_el_mod_id\\":\\"63f1aea\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"501f980\\",\\"row_order\\":\\"5\\",\\"cols\\":[{\\"element_id\\":\\"65284e2\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-horizontal\\\\/files\\\\/2019\\\\/01\\\\/stars-and-snow-mountain.png\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"5208bad\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"2b50a70\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"fb4bc3e\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-1\\",\\"grid_width\\":\\"10\\"},{\\"element_id\\":\\"b1a306c\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"328c1f5\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Looking To The Future<\\\\/h3>\\\\n<p>I\\\\\\\\\\\'ve met some amazing clients who have become almost family to me. The numerous travels and projects abroad haven\\\\\\\\\\\'t diminished my love for the unknown, but only heightened it. A journey of a thousand miles starts with a single step. I just lucked out with being able to take mine early on in life. And I want to help you with yours. Let me help you start that journey... from one single step to a thousand. Here\\\\\\\\\\\'s to you.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"2ddbf45\\",\\"unstick_when_el_mod_id\\":\\"63f1aea\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"grid_width\\":\\"74\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"9\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"afa0f3c\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col4-1\\",\\"grid_width\\":\\"9.6\\"}],\\"column_alignment\\":\\"col_align_top\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#eef0f2\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"2ddbf45\\",\\"unstick_when_el_mod_id\\":\\"63f1aea\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-horizontal\\\\/files\\\\/2019\\\\/01\\\\/latte.jpg\\",\\"background_repeat\\":\\"best-fit-image\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"background_color\\":\\"#eef0f2\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}}],\\"column_alignment\\":\\"col_align_top\\",\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-bottom\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth-content\\",\\"row_height\\":\\"fullheight\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"2ddbf45\\",\\"unstick_when_el_mod_id\\":\\"63f1aea\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"fcab93d\\",\\"row_order\\":\\"6\\",\\"cols\\":[{\\"element_id\\":\\"f3b258e\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 275,
  'post_date' => '2019-01-15 02:17:50',
  'post_date_gmt' => '2019-01-15 02:17:50',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam.',
  'post_title' => 'Canon EOS6D Camera',
  'post_excerpt' => 'Aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem.',
  'post_name' => 'canon-eos6d-camera',
  'post_modified' => '2019-01-22 02:26:38',
  'post_modified_gmt' => '2019-01-22 02:26:38',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?post_type=product&#038;p=275',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1548127650:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"dc4e367\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"48cf245\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'mobile_menu_styles' => 'default',
    '_regular_price' => '600',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.3',
    '_price' => '600',
    '_thumbnail_id' => '540',
    'post_image' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/camera-cannon-e60.jpg',
    '_wp_old_slug' => 'kreedom-ski-google',
    '_wp_old_date' => '2019-01-11',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'gadget',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/camera-cannon-e60.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 346,
  'post_date' => '2019-01-14 04:01:41',
  'post_date_gmt' => '2019-01-14 04:01:41',
  'post_content' => 'Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.
',
  'post_title' => 'Frostbyte Google Ski',
  'post_excerpt' => 'Neque porro quisquam. Voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. ',
  'post_name' => 'frostbyte-google-ski',
  'post_modified' => '2019-01-22 02:22:12',
  'post_modified_gmt' => '2019-01-22 02:22:12',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?post_type=product&#038;p=346',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1548123750:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"58c0b02\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"fda9f23\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '538',
    'post_image' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/frostbyte-google-sky.jpg',
    '_regular_price' => '250',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.3',
    '_price' => '250',
    '_wp_old_date' => '2019-01-15',
    '_wp_old_slug' => 'mens-walking-boot',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'accessories',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/frostbyte-google-sky.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 280,
  'post_date' => '2019-01-13 02:21:38',
  'post_date_gmt' => '2019-01-13 02:21:38',
  'post_content' => ' Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.
',
  'post_title' => 'New Balance Walking Shoes',
  'post_excerpt' => 'Voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam.',
  'post_name' => 'new-balance-walking-shoes',
  'post_modified' => '2019-01-22 02:07:50',
  'post_modified_gmt' => '2019-01-22 02:07:50',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?post_type=product&#038;p=280',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1548122870:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"521363c\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"fa3d5cc\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'mobile_menu_styles' => 'default',
    '_regular_price' => '250',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.3',
    '_price' => '250',
    '_thumbnail_id' => '536',
    'post_image' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/new-balance-shoes.jpg',
    '_wp_old_slug' => 'mens-leather-bag',
    '_wp_old_date' => '2019-01-15',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'shoes',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/new-balance-shoes.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 272,
  'post_date' => '2019-01-11 08:14:48',
  'post_date_gmt' => '2019-01-11 08:14:48',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.',
  'post_title' => 'Eco Laptop Backpack',
  'post_excerpt' => 'Voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione.',
  'post_name' => 'eco-laptop-backpack',
  'post_modified' => '2019-01-22 02:03:59',
  'post_modified_gmt' => '2019-01-22 02:03:59',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?post_type=product&#038;p=272',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1548122588:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"149e50f\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"ef63553\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'mobile_menu_styles' => 'default',
    '_regular_price' => '250',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.3',
    '_price' => '250',
    '_thumbnail_id' => '535',
    '_wp_old_date' => '2019-01-09',
    '_wp_old_slug' => 'mens-sunglasses',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'bag',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/laptop-backpack.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 278,
  'post_date' => '2019-01-09 08:13:33',
  'post_date_gmt' => '2019-01-09 08:13:33',
  'post_content' => ' Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.
',
  'post_title' => 'Men\'s Hiking Boots',
  'post_excerpt' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.',
  'post_name' => 'mens-hiking-boots',
  'post_modified' => '2019-01-22 01:57:02',
  'post_modified_gmt' => '2019-01-22 01:57:02',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?post_type=product&#038;p=278',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1548122222:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"e1eb8da\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"e2d02c4\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'mobile_menu_styles' => 'default',
    '_regular_price' => '375',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.3',
    '_price' => '375',
    '_thumbnail_id' => '534',
    'post_image' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/hiking-shoes-funky.jpg',
    '_wp_old_date' => '2019-01-11',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'shoes',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/hiking-shoes-funky.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 268,
  'post_date' => '2019-01-07 08:07:55',
  'post_date_gmt' => '2019-01-07 08:07:55',
  'post_content' => 'At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus.',
  'post_title' => 'Giro Rainbow Google Ski',
  'post_excerpt' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur.',
  'post_name' => 'giro-rainbow-google-sky',
  'post_modified' => '2019-01-22 04:09:32',
  'post_modified_gmt' => '2019-01-22 04:09:32',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?post_type=product&#038;p=268',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1548130032:172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"a6702f3\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"fce0079\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    '_edit_last' => '172',
    'mobile_menu_styles' => 'default',
    '_regular_price' => '650',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.3',
    '_price' => '650',
    '_thumbnail_id' => '532',
    'post_image' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/google-sky-rainbow.jpg',
    '_wp_old_date' => '2019-01-11',
    '_wp_old_slug' => 'camping-knife',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'accessories',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/google-sky-rainbow.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 263,
  'post_date' => '2019-01-04 07:48:31',
  'post_date_gmt' => '2019-01-04 07:48:31',
  'post_content' => 'Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.
',
  'post_title' => 'Sony Smartwatch 3',
  'post_excerpt' => 'Nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam.',
  'post_name' => 'sony-smartwatch-3',
  'post_modified' => '2019-01-22 06:57:13',
  'post_modified_gmt' => '2019-01-22 06:57:13',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?post_type=product&#038;p=263',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1548140261:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"4283999\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"5ccb9be\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'mobile_menu_styles' => 'default',
    '_regular_price' => '325',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.3',
    '_price' => '325',
    'post_image' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/smartwatch-3-carl-froch.jpg',
    '_wp_old_date' => '2019-01-11',
    '_thumbnail_id' => '554',
    '_wp_old_slug' => 'mens-camping-bag',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'gadget',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/smartwatch-3-carl-froch.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 348,
  'post_date' => '2019-01-03 04:09:32',
  'post_date_gmt' => '2019-01-03 04:09:32',
  'post_content' => 'Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.

',
  'post_title' => 'Carbone Ski Helmet - Green',
  'post_excerpt' => 'Nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam.',
  'post_name' => 'carbone-ski-helmet-green',
  'post_modified' => '2019-01-22 06:58:57',
  'post_modified_gmt' => '2019-01-22 06:58:57',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?post_type=product&#038;p=348',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1548140203:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"1e40c49\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"602a00a\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'mobile_menu_styles' => 'default',
    'post_image' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/green-ski-helmet.jpg',
    '_regular_price' => '375',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.3',
    '_price' => '375',
    '_wp_old_date' => '2019-01-15',
    '_thumbnail_id' => '553',
    '_wp_old_slug' => 'urban-sneakers-series',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'shoes',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/green-ski-helmet.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 266,
  'post_date' => '2019-01-02 08:06:52',
  'post_date_gmt' => '2019-01-02 08:06:52',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.',
  'post_title' => 'Go Pro Hero 7',
  'post_excerpt' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.',
  'post_name' => 'go-pro-hero-7',
  'post_modified' => '2019-01-22 07:01:26',
  'post_modified_gmt' => '2019-01-22 07:01:26',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?post_type=product&#038;p=266',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1548140354:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"452202d\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"2a4441c\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'mobile_menu_styles' => 'default',
    '_regular_price' => '399',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.3',
    '_price' => '399',
    'post_image' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/go-pro-hero-7.jpg',
    '_wp_old_slug' => 'universal-gadget-silicone',
    '_wp_old_date' => '2019-01-11',
    '_thumbnail_id' => '552',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'accessories, gadget',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/go-pro-hero-7.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 347,
  'post_date' => '2019-01-01 04:08:09',
  'post_date_gmt' => '2019-01-01 04:08:09',
  'post_content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_title' => 'Women\'s Baseball Hat',
  'post_excerpt' => 'Eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco.',
  'post_name' => 'womens-baseball-hat',
  'post_modified' => '2019-01-22 07:02:17',
  'post_modified_gmt' => '2019-01-22 07:02:17',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?post_type=product&#038;p=347',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1548141228:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"a4d165d\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"8dabd31\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'mobile_menu_styles' => 'default',
    'post_image' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/woman-hero-baseball-cap-adjustable.jpg',
    '_regular_price' => '125',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.3',
    '_price' => '125',
    '_wp_old_date' => '2019-01-15',
    '_thumbnail_id' => '555',
    '_wp_old_slug' => 'aora-red-smart-watch',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'accessories',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/woman-hero-baseball-cap-adjustable.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 216,
  'post_date' => '2019-01-10 11:19:14',
  'post_date_gmt' => '2019-01-10 11:19:14',
  'post_content' => 'Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates.<span id="more-821"></span>

Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?”  repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis.',
  'post_title' => 'Pine Jungle',
  'post_excerpt' => '',
  'post_name' => 'the-pine-jungle',
  'post_modified' => '2019-01-21 22:41:12',
  'post_modified_gmt' => '2019-01-21 22:41:12',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?post_type=portfolio&#038;p=216',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'project_date' => 'Jan 8, 2019',
    'project_client' => 'Hikers Club',
    'project_services' => 'Photography ',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"c8548f1\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"6c11f8a\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'nature',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/at-the-jungle.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 227,
  'post_date' => '2019-01-09 11:25:34',
  'post_date_gmt' => '2019-01-09 11:25:34',
  'post_content' => 'Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.<span id="more-825"></span>

Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.

. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur? voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus.',
  'post_title' => 'Catch A Wave',
  'post_excerpt' => '',
  'post_name' => 'waiting-big-wave',
  'post_modified' => '2019-01-21 22:26:27',
  'post_modified_gmt' => '2019-01-21 22:26:27',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?post_type=portfolio&#038;p=227',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'project_date' => 'Jan 9, 2019',
    'project_client' => 'Surfing Boys Co',
    'project_services' => 'Photography ',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"fa84b67\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"71f4e8e\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'photography',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/waiting-for-the-wave.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 220,
  'post_date' => '2019-01-08 11:21:26',
  'post_date_gmt' => '2019-01-08 11:21:26',
  'post_content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<span id="more-397"></span>

Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.

Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt neque porro quisquam.',
  'post_title' => 'Nature Times Infinity',
  'post_excerpt' => '',
  'post_name' => 'unlimited-nature',
  'post_modified' => '2019-01-21 22:29:28',
  'post_modified_gmt' => '2019-01-21 22:29:28',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?post_type=portfolio&#038;p=220',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'project_date' => 'Jan 8, 2019',
    'project_client' => 'Hikers Club',
    'project_services' => 'Photography ',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"9215f33\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"809c3c7\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'nature',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/the-blue-sky.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 222,
  'post_date' => '2019-01-07 11:22:31',
  'post_date_gmt' => '2019-01-07 11:22:31',
  'post_content' => 'Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.recusandae. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.<span id="more-378"></span>

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores.',
  'post_title' => 'The Umbrellas of Cherbourg',
  'post_excerpt' => '',
  'post_name' => 'the-umbrellas-of-cherbourg',
  'post_modified' => '2019-06-29 01:22:42',
  'post_modified_gmt' => '2019-06-29 01:22:42',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?post_type=portfolio&#038;p=222',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'project_date' => ' Jan 7, 2019',
    'project_client' => 'The Traveler ',
    'project_services' => 'Photography, Brochure',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"nnb8851\\",\\"cols\\":[{\\"element_id\\":\\"gtxj853\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'adventure, photography',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/umbrellas.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 225,
  'post_date' => '2019-01-06 11:24:55',
  'post_date_gmt' => '2019-01-06 11:24:55',
  'post_content' => 'Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates.<span id="more-393"></span>

Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?”  repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis.',
  'post_title' => 'The Ancient Temple',
  'post_excerpt' => '',
  'post_name' => 'the-ancient-temple',
  'post_modified' => '2019-01-16 02:50:13',
  'post_modified_gmt' => '2019-01-16 02:50:13',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?post_type=portfolio&#038;p=225',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'project_date' => 'Jan 6, 2019',
    'project_client' => 'The Traveler ',
    'project_services' => 'Photography, Brochure',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"3fbf531\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"92a1dec\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'adventure, photography',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/ancient-temple.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 229,
  'post_date' => '2019-01-04 11:27:37',
  'post_date_gmt' => '2019-01-04 11:27:37',
  'post_content' => 'Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatu.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis.',
  'post_title' => 'View from the top',
  'post_excerpt' => '',
  'post_name' => 'view-from-the-top',
  'post_modified' => '2019-01-15 17:20:14',
  'post_modified_gmt' => '2019-01-15 17:20:14',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?post_type=portfolio&#038;p=229',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"3c480a8\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"d187f2c\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'photography',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/the-brave-boy.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 218,
  'post_date' => '2019-01-04 11:19:20',
  'post_date_gmt' => '2019-01-04 11:19:20',
  'post_content' => 'Labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.<span id="more-401"></span>

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.',
  'post_title' => 'Top of Mountain',
  'post_excerpt' => '',
  'post_name' => 'top-of-mountain',
  'post_modified' => '2019-01-16 02:50:29',
  'post_modified_gmt' => '2019-01-16 02:50:29',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?post_type=portfolio&#038;p=218',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'project_date' => 'Jan 4, 2019',
    'project_client' => 'Hikers Club',
    'project_services' => 'Photography ',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"5e6548d\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"47cfa2c\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'adventure',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/hiker-at-the-top.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 416,
  'post_date' => '2019-01-03 10:39:13',
  'post_date_gmt' => '2019-01-03 10:39:13',
  'post_content' => 'Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?”  repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis.

Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates.',
  'post_title' => 'Footprints in the Snow',
  'post_excerpt' => '',
  'post_name' => 'footprints-in-the-snow',
  'post_modified' => '2019-01-16 02:51:13',
  'post_modified_gmt' => '2019-01-16 02:51:13',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?post_type=portfolio&#038;p=416',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'project_date' => 'Jan 3, 2019',
    'project_client' => 'The Traveler ',
    'project_services' => 'Photography, Brochure',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"435c2e1\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"27cb23e\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'photography',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/footprint-on-snow.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 417,
  'post_date' => '2019-01-02 10:41:27',
  'post_date_gmt' => '2019-01-02 10:41:27',
  'post_content' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.

Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur. Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae.

',
  'post_title' => 'Beach Sand',
  'post_excerpt' => '',
  'post_name' => 'beach-sand',
  'post_modified' => '2019-01-16 02:51:31',
  'post_modified_gmt' => '2019-01-16 02:51:31',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?post_type=portfolio&#038;p=417',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'project_date' => ' Jan 2, 2019',
    'project_client' => 'The Traveler ',
    'project_services' => 'Photography, Brochure',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"3892d56\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"b6d471a\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'photography',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/beach-sand.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 420,
  'post_date' => '2019-01-01 17:06:19',
  'post_date_gmt' => '2019-01-01 17:06:19',
  'post_content' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.

Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur. Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae.',
  'post_title' => 'Girl In The Rain',
  'post_excerpt' => '',
  'post_name' => 'girl-in-the-rain',
  'post_modified' => '2019-01-16 02:52:10',
  'post_modified_gmt' => '2019-01-16 02:52:10',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?post_type=portfolio&#038;p=420',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'project_date' => ' Jan 1, 2019',
    'project_client' => 'The Traveler ',
    'project_services' => 'Photography, Advertising',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"4cb3284\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"edfc2ca\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'adventure, photography',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/walking-in-rain.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 419,
  'post_date' => '2019-01-01 17:05:54',
  'post_date_gmt' => '2019-01-01 17:05:54',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.

inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed q',
  'post_title' => 'My Reflection',
  'post_excerpt' => '',
  'post_name' => 'my-reflection',
  'post_modified' => '2019-01-16 02:52:25',
  'post_modified_gmt' => '2019-01-16 02:52:25',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?post_type=portfolio&#038;p=419',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'project_date' => 'Jan 1, 2019',
    'project_client' => 'The Traveler ',
    'project_services' => 'Photography, Brochure',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"07cd418\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"1ba847d\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'photography',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/walking-at-beach.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 421,
  'post_date' => '2018-12-31 17:15:31',
  'post_date_gmt' => '2018-12-31 17:15:31',
  'post_content' => 'Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.


Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio.',
  'post_title' => 'Nature Challenge',
  'post_excerpt' => '',
  'post_name' => 'nature-challenge',
  'post_modified' => '2019-01-16 02:52:47',
  'post_modified_gmt' => '2019-01-16 02:52:47',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?post_type=portfolio&#038;p=421',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'project_date' => 'Dec 31, 2018',
    'project_client' => 'Hikers Club',
    'project_services' => 'Photography, Brochure',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"2959eda\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"3eef68c\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'nature',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/nature-challenger.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 424,
  'post_date' => '2018-12-30 17:15:54',
  'post_date_gmt' => '2018-12-30 17:15:54',
  'post_content' => 'Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus.  Ton provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.

Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur? Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate.',
  'post_title' => 'My Adventure',
  'post_excerpt' => '',
  'post_name' => 'my-adventure',
  'post_modified' => '2019-01-16 02:53:12',
  'post_modified_gmt' => '2019-01-16 02:53:12',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?post_type=portfolio&#038;p=424',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'project_date' => 'Dec 30, 2018',
    'project_client' => 'The Traveler ',
    'project_services' => 'Photography, Brochure',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"380dd1c\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"591fcb3\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'adventure',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-horizontal/files/2019/01/the-adventurer.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 285,
  'post_date' => '2019-01-11 14:21:13',
  'post_date_gmt' => '2019-01-11 14:21:13',
  'post_content' => '',
  'post_title' => 'Home',
  'post_excerpt' => '',
  'post_name' => 'home-2',
  'post_modified' => '2019-01-21 21:08:33',
  'post_modified_gmt' => '2019-01-21 21:08:33',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?p=285',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '285',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#home',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'custom-menu',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 286,
  'post_date' => '2019-01-11 14:21:13',
  'post_date_gmt' => '2019-01-11 14:21:13',
  'post_content' => '',
  'post_title' => 'Welcome',
  'post_excerpt' => '',
  'post_name' => 'about-2',
  'post_modified' => '2019-01-21 21:08:33',
  'post_modified_gmt' => '2019-01-21 21:08:33',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?p=286',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '286',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#welcome',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'custom-menu',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 287,
  'post_date' => '2019-01-11 14:21:13',
  'post_date_gmt' => '2019-01-11 14:21:13',
  'post_content' => '',
  'post_title' => 'Portfolio',
  'post_excerpt' => '',
  'post_name' => 'portfolio-3',
  'post_modified' => '2019-01-21 21:08:33',
  'post_modified_gmt' => '2019-01-21 21:08:33',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?p=287',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '287',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#portfolio',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'custom-menu',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 288,
  'post_date' => '2019-01-11 14:21:13',
  'post_date_gmt' => '2019-01-11 14:21:13',
  'post_content' => '',
  'post_title' => 'Shop',
  'post_excerpt' => '',
  'post_name' => 'shop-2',
  'post_modified' => '2019-01-21 21:08:33',
  'post_modified_gmt' => '2019-01-21 21:08:33',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?p=288',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '288',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#shop',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'custom-menu',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 289,
  'post_date' => '2019-01-11 14:21:13',
  'post_date_gmt' => '2019-01-11 14:21:13',
  'post_content' => '',
  'post_title' => 'Blog',
  'post_excerpt' => '',
  'post_name' => 'blog',
  'post_modified' => '2019-01-21 21:08:33',
  'post_modified_gmt' => '2019-01-21 21:08:33',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?p=289',
  'menu_order' => 5,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '289',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#blog',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'custom-menu',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 290,
  'post_date' => '2019-01-11 14:21:13',
  'post_date_gmt' => '2019-01-11 14:21:13',
  'post_content' => '',
  'post_title' => 'Contact',
  'post_excerpt' => '',
  'post_name' => 'contact-2',
  'post_modified' => '2019-01-21 21:08:33',
  'post_modified_gmt' => '2019-01-21 21:08:33',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?p=290',
  'menu_order' => 6,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '290',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#contact',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'custom-menu',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 305,
  'post_date' => '2019-01-11 14:45:10',
  'post_date_gmt' => '2019-01-11 14:45:10',
  'post_content' => '',
  'post_title' => 'My Story',
  'post_excerpt' => '',
  'post_name' => '305',
  'post_modified' => '2019-01-21 21:08:33',
  'post_modified_gmt' => '2019-01-21 21:08:33',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?p=305',
  'menu_order' => 7,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '4',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'custom-menu',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 107,
  'post_date' => '2019-01-09 11:09:57',
  'post_date_gmt' => '2019-01-09 11:09:57',
  'post_content' => '',
  'post_title' => 'Home',
  'post_excerpt' => '',
  'post_name' => 'home',
  'post_modified' => '2019-01-15 17:41:25',
  'post_modified_gmt' => '2019-01-15 17:41:25',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?p=107',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '107',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-horizontal/#home',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 97,
  'post_date' => '2019-01-09 11:01:28',
  'post_date_gmt' => '2019-01-09 11:01:28',
  'post_content' => '',
  'post_title' => 'About',
  'post_excerpt' => '',
  'post_name' => 'about',
  'post_modified' => '2019-01-15 17:41:25',
  'post_modified_gmt' => '2019-01-15 17:41:25',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?p=97',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '97',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-horizontal/#about',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 98,
  'post_date' => '2019-01-09 11:01:28',
  'post_date_gmt' => '2019-01-09 11:01:28',
  'post_content' => '',
  'post_title' => 'Portfolio',
  'post_excerpt' => '',
  'post_name' => 'portfolio',
  'post_modified' => '2019-01-15 17:41:25',
  'post_modified_gmt' => '2019-01-15 17:41:25',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?p=98',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '98',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-horizontal/#portfolio',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 99,
  'post_date' => '2019-01-09 11:01:28',
  'post_date_gmt' => '2019-01-09 11:01:28',
  'post_content' => '',
  'post_title' => 'Shop',
  'post_excerpt' => '',
  'post_name' => 'shop',
  'post_modified' => '2019-01-15 17:41:25',
  'post_modified_gmt' => '2019-01-15 17:41:25',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?p=99',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '99',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-horizontal/#shop',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 100,
  'post_date' => '2019-01-09 11:01:28',
  'post_date_gmt' => '2019-01-09 11:01:28',
  'post_content' => '',
  'post_title' => 'Blog',
  'post_excerpt' => '',
  'post_name' => 'portfolio-2',
  'post_modified' => '2019-01-15 17:41:25',
  'post_modified_gmt' => '2019-01-15 17:41:25',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?p=100',
  'menu_order' => 5,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '100',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-horizontal/#blog',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 101,
  'post_date' => '2019-01-09 11:01:28',
  'post_date_gmt' => '2019-01-09 11:01:28',
  'post_content' => '',
  'post_title' => 'Contact',
  'post_excerpt' => '',
  'post_name' => 'contact',
  'post_modified' => '2019-01-15 17:41:25',
  'post_modified_gmt' => '2019-01-15 17:41:25',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?p=101',
  'menu_order' => 6,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '101',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-horizontal/#contact',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 128,
  'post_date' => '2019-01-09 15:54:12',
  'post_date_gmt' => '2019-01-09 15:54:12',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '128',
  'post_modified' => '2019-01-15 17:41:25',
  'post_modified_gmt' => '2019-01-15 17:41:25',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-horizontal/?p=128',
  'menu_order' => 7,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '4',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );



function themify_import_get_term_id_from_slug( $slug ) {
	$menu = get_term_by( "slug", $slug, "nav_menu" );
	return is_wp_error( $menu ) ? 0 : (int) $menu->term_id;
}

	$widgets = get_option( "widget_themify-social-links" );
$widgets[1002] = array (
  'title' => '',
  'show_link_name' => NULL,
  'open_new_window' => NULL,
  'icon_size' => 'icon-medium',
  'orientation' => 'horizontal',
);
update_option( "widget_themify-social-links", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1003] = array (
  'title' => 'Our Story',
  'text' => 'A journey of a thousand miles starts with a single step. Let me help you start that journey… from one single step to a thousand. Here\'s to you.

<a href="https://themify.me/demo/themes/ultra-horizontal/story/"><em>Read more</em></a>',
  'filter' => true,
  'visual' => true,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_themify-feature-posts" );
$widgets[1004] = array (
  'title' => 'Latest Posts',
  'category' => '0',
  'show_count' => '4',
  'show_date' => NULL,
  'show_thumb' => 'on',
  'display' => 'none',
  'hide_title' => NULL,
  'thumb_width' => '32',
  'thumb_height' => '32',
  'excerpt_length' => '55',
  'orderby' => 'date',
  'order' => 'DESC',
);
update_option( "widget_themify-feature-posts", $widgets );

$widgets = get_option( "widget_woocommerce_products" );
$widgets[1005] = array (
  'title' => 'Products',
  'number' => 4,
  'show' => '',
  'orderby' => 'date',
  'order' => 'desc',
  'hide_free' => 0,
  'show_hidden' => 0,
);
update_option( "widget_woocommerce_products", $widgets );



$sidebars_widgets = array (
  'footer-social-widget' => 
  array (
    0 => 'themify-social-links-1002',
  ),
  'footer-widget-1' => 
  array (
    0 => 'text-1003',
  ),
  'footer-widget-2' => 
  array (
    0 => 'themify-feature-posts-1004',
  ),
  'footer-widget-3' => 
  array (
    0 => 'woocommerce_products-1005',
  ),
); 
update_option( "sidebars_widgets", $sidebars_widgets );

$menu_locations = array();
$menu = get_terms( "nav_menu", array( "slug" => "main-navigation" ) );
if( is_array( $menu ) && ! empty( $menu ) ) $menu_locations["main-nav"] = $menu[0]->term_id;
set_theme_mod( "nav_menu_locations", $menu_locations );


$homepage = get_posts( array( 'name' => 'home', 'post_type' => 'page' ) );
			if( is_array( $homepage ) && ! empty( $homepage ) ) {
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $homepage[0]->ID );
			}
			
	ob_start(); ?>a:117:{s:21:"setting-webfonts_list";s:11:"recommended";s:22:"setting-default_layout";s:12:"sidebar-none";s:27:"setting-default_post_layout";s:9:"list-post";s:19:"setting-post_filter";s:2:"no";s:23:"setting-disable_masonry";s:3:"yes";s:19:"setting-post_gutter";s:6:"gutter";s:30:"setting-default_layout_display";s:7:"content";s:25:"setting-default_more_text";s:4:"More";s:21:"setting-index_orderby";s:4:"date";s:19:"setting-index_order";s:4:"DESC";s:30:"setting-default_media_position";s:5:"above";s:31:"setting-image_post_feature_size";s:5:"blank";s:24:"setting-image_post_width";s:4:"1200";s:25:"setting-image_post_height";s:3:"500";s:32:"setting-default_page_post_layout";s:12:"sidebar-none";s:37:"setting-default_page_post_layout_type";s:9:"fullwidth";s:42:"setting-default_page_single_media_position";s:5:"above";s:38:"setting-image_post_single_feature_size";s:5:"blank";s:31:"setting-image_post_single_width";s:4:"1440";s:32:"setting-image_post_single_height";s:3:"600";s:36:"setting-search-result_layout_display";s:7:"content";s:36:"setting-search-result_media_position";s:5:"above";s:27:"setting-default_page_layout";s:12:"sidebar-none";s:40:"setting-custom_post_tglobal_style_single";s:8:"sidebar1";s:38:"setting-default_portfolio_index_layout";s:12:"sidebar-none";s:43:"setting-default_portfolio_index_post_layout";s:5:"grid3";s:29:"setting-portfolio_post_filter";s:3:"yes";s:33:"setting-portfolio_disable_masonry";s:3:"yes";s:24:"setting-portfolio_gutter";s:6:"gutter";s:39:"setting-default_portfolio_index_display";s:4:"none";s:50:"setting-default_portfolio_index_post_meta_category";s:3:"yes";s:49:"setting-default_portfolio_index_unlink_post_image";s:3:"yes";s:39:"setting-default_portfolio_single_layout";s:12:"sidebar-none";s:54:"setting-default_portfolio_single_portfolio_layout_type";s:9:"fullwidth";s:50:"setting-default_portfolio_single_unlink_post_image";s:3:"yes";s:49:"setting-default_portfolio_single_image_post_width";s:4:"1440";s:50:"setting-default_portfolio_single_image_post_height";s:3:"600";s:22:"themify_portfolio_slug";s:7:"project";s:19:"setting-shop_layout";s:12:"sidebar-none";s:27:"setting-shop_archive_layout";s:12:"sidebar-none";s:23:"setting-products_layout";s:5:"grid2";s:31:"setting-product_disable_masonry";s:3:"yes";s:29:"setting-single_product_layout";s:12:"sidebar-none";s:30:"setting-related_products_limit";s:1:"3";s:53:"setting-customizer_responsive_design_tablet_landscape";s:4:"1280";s:43:"setting-customizer_responsive_design_tablet";s:3:"768";s:43:"setting-customizer_responsive_design_mobile";s:3:"680";s:33:"setting-mobile_menu_trigger_point";s:4:"1100";s:24:"setting-gallery_lightbox";s:8:"lightbox";s:27:"setting-page_builder_expiry";s:1:"2";s:21:"setting-header_design";s:14:"header-top-bar";s:28:"setting-exclude_site_tagline";s:2:"on";s:19:"setting_search_form";s:11:"live_search";s:19:"setting-exclude_rss";s:2:"on";s:22:"setting-header_widgets";s:4:"none";s:21:"setting-footer_design";s:15:"footer-left-col";s:22:"setting-footer_widgets";s:17:"footerwidget-3col";s:23:"setting-mega_menu_posts";s:1:"5";s:29:"setting-mega_menu_image_width";s:3:"180";s:30:"setting-mega_menu_image_height";s:3:"120";s:27:"setting-imagefilter_applyto";s:12:"featuredonly";s:29:"setting-color_animation_speed";s:1:"5";s:29:"setting-relationship_taxonomy";s:8:"category";s:37:"setting-relationship_taxonomy_entries";s:1:"3";s:45:"setting-relationship_taxonomy_display_content";s:4:"none";s:30:"setting-single_slider_autoplay";s:3:"off";s:27:"setting-single_slider_speed";s:6:"normal";s:28:"setting-single_slider_effect";s:5:"slide";s:28:"setting-single_slider_height";s:4:"auto";s:18:"setting-more_posts";s:8:"infinite";s:19:"setting-entries_nav";s:8:"numbered";s:25:"setting-img_php_base_size";s:5:"large";s:27:"setting-global_feature_size";s:5:"blank";s:22:"setting-link_icon_type";s:9:"font-icon";s:32:"setting-link_type_themify-link-0";s:10:"image-icon";s:33:"setting-link_title_themify-link-0";s:7:"Twitter";s:31:"setting-link_img_themify-link-0";s:110:"https://themify.me/demo/themes/ultra-horizontal/wp-content/themes/themify-ultra/themify/img/social/twitter.png";s:32:"setting-link_type_themify-link-1";s:10:"image-icon";s:33:"setting-link_title_themify-link-1";s:8:"Facebook";s:31:"setting-link_img_themify-link-1";s:111:"https://themify.me/demo/themes/ultra-horizontal/wp-content/themes/themify-ultra/themify/img/social/facebook.png";s:32:"setting-link_type_themify-link-2";s:10:"image-icon";s:33:"setting-link_title_themify-link-2";s:7:"Google+";s:31:"setting-link_img_themify-link-2";s:114:"https://themify.me/demo/themes/ultra-horizontal/wp-content/themes/themify-ultra/themify/img/social/google-plus.png";s:32:"setting-link_type_themify-link-3";s:10:"image-icon";s:33:"setting-link_title_themify-link-3";s:7:"YouTube";s:31:"setting-link_img_themify-link-3";s:110:"https://themify.me/demo/themes/ultra-horizontal/wp-content/themes/themify-ultra/themify/img/social/youtube.png";s:32:"setting-link_type_themify-link-4";s:10:"image-icon";s:33:"setting-link_title_themify-link-4";s:9:"Pinterest";s:31:"setting-link_img_themify-link-4";s:112:"https://themify.me/demo/themes/ultra-horizontal/wp-content/themes/themify-ultra/themify/img/social/pinterest.png";s:32:"setting-link_type_themify-link-5";s:9:"font-icon";s:33:"setting-link_title_themify-link-5";s:7:"Twitter";s:32:"setting-link_link_themify-link-5";s:27:"https://twitter.com/themify";s:33:"setting-link_ficon_themify-link-5";s:10:"fa-twitter";s:32:"setting-link_type_themify-link-6";s:9:"font-icon";s:33:"setting-link_title_themify-link-6";s:8:"Facebook";s:32:"setting-link_link_themify-link-6";s:32:"https://www.facebook.com/themify";s:33:"setting-link_ficon_themify-link-6";s:11:"fa-facebook";s:32:"setting-link_type_themify-link-7";s:9:"font-icon";s:33:"setting-link_title_themify-link-7";s:7:"Google+";s:32:"setting-link_link_themify-link-7";s:45:"https://plus.google.com/109280316400365629341";s:33:"setting-link_ficon_themify-link-7";s:14:"fa-google-plus";s:32:"setting-link_type_themify-link-8";s:9:"font-icon";s:33:"setting-link_title_themify-link-8";s:7:"YouTube";s:32:"setting-link_link_themify-link-8";s:38:"https://www.youtube.com/user/themifyme";s:33:"setting-link_ficon_themify-link-8";s:10:"fa-youtube";s:32:"setting-link_type_themify-link-9";s:9:"font-icon";s:33:"setting-link_title_themify-link-9";s:9:"Pinterest";s:33:"setting-link_ficon_themify-link-9";s:12:"fa-pinterest";s:22:"setting-link_field_ids";s:341:"{"themify-link-0":"themify-link-0","themify-link-1":"themify-link-1","themify-link-2":"themify-link-2","themify-link-3":"themify-link-3","themify-link-4":"themify-link-4","themify-link-5":"themify-link-5","themify-link-6":"themify-link-6","themify-link-7":"themify-link-7","themify-link-8":"themify-link-8","themify-link-9":"themify-link-9"}";s:23:"setting-link_field_hash";s:2:"10";s:30:"setting-page_builder_is_active";s:6:"enable";s:41:"setting-page_builder_animation_appearance";s:4:"none";s:42:"setting-page_builder_animation_parallax_bg";s:4:"none";s:46:"setting-page_builder_animation_parallax_scroll";s:6:"mobile";s:44:"setting-page_builder_animation_sticky_scroll";s:4:"none";s:4:"skin";s:10:"horizontal";s:13:"import_images";s:2:"on";}<?php $themify_data = unserialize( ob_get_clean() );

	// Fix how "skin" option used to save
	if( isset( $themify_data['skin'] ) ) {
		if ( filter_var( $themify_data['skin'], FILTER_VALIDATE_URL ) ) {
			$parsed_skin = parse_url( $value, PHP_URL_PATH );
			$themify_data['skin'] = basename( dirname( $parsed_skin ) );
		}
	}

	themify_set_data( $themify_data );
	
}
themify_do_demo_import();