<?php

defined( 'ABSPATH' ) or die;

$GLOBALS['processed_terms'] = array();
$GLOBALS['processed_posts'] = array();

require_once ABSPATH . 'wp-admin/includes/post.php';
require_once ABSPATH . 'wp-admin/includes/taxonomy.php';
require_once ABSPATH . 'wp-admin/includes/image.php';

/**
 * Add an Import Action, this data is stored for processing after import is done.
 *
 * Each action is sent as an Ajax request and is handled by themify-ajax.php file
 */ 
function themify_add_import_action( $action = '', $data = array() ) {
	global $import_actions;

	if ( ! isset( $import_actions[ $action ] ) ) {
		$import_actions[ $action ] = array();
	}

	$import_actions[ $action ][] = $data;
}

function themify_import_post( $post ) {
	global $processed_posts, $processed_terms;

	if ( ! post_type_exists( $post['post_type'] ) ) {
		return;
	}

	/* Menu items don't have reliable post_title, skip the post_exists check */
	if( $post['post_type'] !== 'nav_menu_item' ) {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
		if ( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
			$processed_posts[ intval( $post['ID'] ) ] = intval( $post_exists );
			return;
		}
	}

	if( $post['post_type'] == 'nav_menu_item' ) {
		if( ! isset( $post['tax_input']['nav_menu'] ) || ! term_exists( $post['tax_input']['nav_menu'], 'nav_menu' ) ) {
			return;
		}
		$_menu_item_type = $post['meta_input']['_menu_item_type'];
		$_menu_item_object_id = $post['meta_input']['_menu_item_object_id'];

		if ( 'taxonomy' == $_menu_item_type && isset( $processed_terms[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_terms[ intval( $_menu_item_object_id ) ];
		} else if ( 'post_type' == $_menu_item_type && isset( $processed_posts[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_posts[ intval( $_menu_item_object_id ) ];
		} else if ( 'custom' != $_menu_item_type ) {
			// associated object is missing or not imported yet, we'll retry later
			// $missing_menu_items[] = $item;
			return;
		}
	}

	$post_parent = ( $post['post_type'] == 'nav_menu_item' ) ? $post['meta_input']['_menu_item_menu_item_parent'] : (int) $post['post_parent'];
	$post['post_parent'] = 0;
	if ( $post_parent ) {
		// if we already know the parent, map it to the new local ID
		if ( isset( $processed_posts[ $post_parent ] ) ) {
			if( $post['post_type'] == 'nav_menu_item' ) {
				$post['meta_input']['_menu_item_menu_item_parent'] = $processed_posts[ $post_parent ];
			} else {
				$post['post_parent'] = $processed_posts[ $post_parent ];
			}
		}
	}

	/**
	 * for hierarchical taxonomies, IDs must be used so wp_set_post_terms can function properly
	 * convert term slugs to IDs for hierarchical taxonomies
	 */
	if( ! empty( $post['tax_input'] ) ) {
		foreach( $post['tax_input'] as $tax => $terms ) {
			if( is_taxonomy_hierarchical( $tax ) ) {
				$terms = explode( ', ', $terms );
				$post['tax_input'][ $tax ] = array_map( 'themify_get_term_id_by_slug', $terms, array_fill( 0, count( $terms ), $tax ) );
			}
		}
	}

	$post['post_author'] = (int) get_current_user_id();
	$post['post_status'] = 'publish';

	$old_id = $post['ID'];

	unset( $post['ID'] );
	$post_id = wp_insert_post( $post, true );
	if( is_wp_error( $post_id ) ) {
		return false;
	} else {
		$processed_posts[ $old_id ] = $post_id;

		return $post_id;
	}
}

function themify_get_placeholder_image() {
	static $placeholder_image = null;

	if( $placeholder_image == null ) {
		if ( ! function_exists( 'WP_Filesystem' ) ) {
			require_once ABSPATH . 'wp-admin/includes/file.php';
		}
		WP_Filesystem();
		global $wp_filesystem;
		$upload = wp_upload_bits( $post['post_name'] . '.jpg', null, $wp_filesystem->get_contents( THEMIFY_DIR . '/img/image-placeholder.jpg' ) );

		if ( $info = wp_check_filetype( $upload['file'] ) )
			$post['post_mime_type'] = $info['type'];
		else
			return new WP_Error( 'attachment_processing_error', __( 'Invalid file type', 'themify' ) );

		$post['guid'] = $upload['url'];
		$post_id = wp_insert_attachment( $post, $upload['file'] );
		wp_update_attachment_metadata( $post_id, wp_generate_attachment_metadata( $post_id, $upload['file'] ) );

		$placeholder_image = $post_id;
	}

	return $placeholder_image;
}

function themify_import_term( $term ) {
	global $processed_terms;

	if( $term_id = term_exists( $term['slug'], $term['taxonomy'] ) ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];
		if ( isset( $term['term_id'] ) )
			$processed_terms[ intval( $term['term_id'] ) ] = (int) $term_id;
		return (int) $term_id;
	}

	if ( empty( $term['parent'] ) ) {
		$parent = 0;
	} else {
		$parent = term_exists( $processed_terms[ intval( $term['parent'] ) ], $term['taxonomy'] );
		if ( is_array( $parent ) ) $parent = $parent['term_id'];
	}

	$id = wp_insert_term( $term['name'], $term['taxonomy'], array(
		'parent' => $parent,
		'slug' => $term['slug'],
		'description' => $term['description'],
	) );
	if ( ! is_wp_error( $id ) ) {
		if ( isset( $term['term_id'] ) ) {
			// success!
			$processed_terms[ intval($term['term_id']) ] = $id['term_id'];
			if ( isset( $term['thumbnail'] ) ) {
				themify_add_import_action( 'term_thumb', array(
					'id' => $id['term_id'],
					'thumb' => $term['thumbnail'],
				) );
			}
			return $term['term_id'];
		}
	}

	return false;
}

function themify_get_term_id_by_slug( $slug, $tax ) {
	$term = get_term_by( 'slug', $slug, $tax );
	if( $term ) {
		return $term->term_id;
	}

	return false;
}

function themify_undo_import_term( $term ) {
	$term_id = term_exists( $term['slug'], $term['taxonomy'] );
	if ( $term_id ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];

		if ( $term_thumbnail = get_term_meta( $term['term_id'], 'thumbnail_id', true ) ) {
			wp_delete_attachment( $term_thumbnail, true );
		}

		if ( isset( $term_id ) ) {
			wp_delete_term( $term_id, $term['taxonomy'] );
		}
	}
}

/**
 * Determine if a post exists based on title, content, and date
 *
 * @global wpdb $wpdb WordPress database abstraction object.
 *
 * @param array $args array of database parameters to check
 * @return int Post ID if post exists, 0 otherwise.
 */
function themify_post_exists( $args = array() ) {
	global $wpdb;

	$query = "SELECT ID FROM $wpdb->posts WHERE 1=1";
	$db_args = array();

	foreach ( $args as $key => $value ) {
		$value = wp_unslash( sanitize_post_field( $key, $value, 0, 'db' ) );
		if( ! empty( $value ) ) {
			$query .= ' AND ' . $key . ' = %s';
			$db_args[] = $value;
		}
	}

	if ( !empty ( $args ) )
		return (int) $wpdb->get_var( $wpdb->prepare($query, $args) );

	return 0;
}

function themify_undo_import_post( $post ) {
	if( $post['post_type'] == 'nav_menu_item' ) {
		$post_exists = themify_post_exists( array(
			'post_name' => $post['post_name'],
			'post_modified' => $post['post_date'],
			'post_type' => 'nav_menu_item',
		) );
	} else {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
	}
	if( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
		/**
		 * check if the post has been modified, if so leave it be
		 *
		 * NOTE: posts are imported using wp_insert_post() which modifies post_modified field
		 * to be the same as post_date, hence to check if the post has been modified,
		 * the post_modified field is compared against post_date in the original post.
		 */
		if( $post['post_date'] == get_post_field( 'post_modified', $post_exists ) ) {
			// find and remove all post attachments
			$attachments = get_posts( array(
				'post_type' => 'attachment',
				'posts_per_page' => -1,
				'post_parent' => $post_exists,
			) );
			if ( $attachments ) {
				foreach ( $attachments as $attachment ) {
					wp_delete_attachment( $attachment->ID, true );
				}
			}
			wp_delete_post( $post_exists, true ); // true: bypass trash
		}
	}
}

function themify_process_post_import( $post ) {
	if( ERASEDEMO ) {
		themify_undo_import_post( $post );
	} else {
		if ( $id = themify_import_post( $post ) ) {
			if ( defined( 'IMPORT_IMAGES' ) && ! IMPORT_IMAGES ) {
				/* if importing images is disabled and post is supposed to have a thumbnail, create a placeholder image instead */
				if ( isset( $post['thumb'] ) ) { // the post is supposed to have featured image
					$placeholder = themify_get_placeholder_image();
					if( ! is_wp_error( $placeholder ) ) {
						set_post_thumbnail( $id, $placeholder );
					}
				}
			} else {
				if ( isset( $post["thumb"] ) ) {
					themify_add_import_action( 'post_thumb', array(
						'id' => $id,
						'thumb' => $post["thumb"],
					) );
				}
				if ( isset( $post["gallery_shortcode"] ) ) {
					themify_add_import_action( 'gallery_field', array(
						'id' => $id,
						'fields' => $post["gallery_shortcode"],
					) );
				}
				if ( isset( $post["_product_image_gallery"] ) ) {
					themify_add_import_action( 'product_gallery', array(
						'id' => $id,
						'images' => $post["_product_image_gallery"],
					) );
				}
			}
		}
	}
}
$thumbs = array();
function themify_do_demo_import() {
global $import_actions;

	if ( isset( $GLOBALS["ThemifyBuilder_Data_Manager"] ) ) {
		remove_action( "save_post", array( $GLOBALS["ThemifyBuilder_Data_Manager"], "save_builder_text_only"), 10, 3 );
	}
$term = array (
  'term_id' => 2,
  'name' => 'Award',
  'slug' => 'award',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 3,
  'name' => 'Event',
  'slug' => 'event',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 4,
  'name' => 'Tutorial',
  'slug' => 'tips',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 5,
  'name' => 'Trend',
  'slug' => 'trend',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 6,
  'name' => 'Main Navigation',
  'slug' => 'main-navigation',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$post = array (
  'ID' => 211,
  'post_date' => '2018-12-24 14:57:53',
  'post_date_gmt' => '2018-12-24 14:57:53',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:heading -->
<h2></h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur? voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p></p>
<!-- /wp:paragraph -->',
  'post_title' => 'Best Female Album 2018',
  'post_excerpt' => '',
  'post_name' => 'best-female-album-2018',
  'post_modified' => '2018-12-24 05:08:11',
  'post_modified_gmt' => '2018-12-24 05:08:11',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-music/?p=211',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'award',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-music/files/2018/12/arian-arys.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 227,
  'post_date' => '2018-12-23 15:19:46',
  'post_date_gmt' => '2018-12-23 15:19:46',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:heading -->
<h2></h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus.&nbsp;Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p></p>
<!-- /wp:paragraph -->',
  'post_title' => 'Dj & Remixer Competition',
  'post_excerpt' => '',
  'post_name' => 'dj-and-hip-hop-competition',
  'post_modified' => '2019-02-22 19:57:32',
  'post_modified_gmt' => '2019-02-22 19:57:32',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-music/?p=227',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'event',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-music/files/2018/12/dj-battle.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 195,
  'post_date' => '2018-12-14 14:21:12',
  'post_date_gmt' => '2018-12-14 14:21:12',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:heading -->
<h2></h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt neque porro quisquam.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p></p>
<!-- /wp:paragraph -->',
  'post_title' => 'Berlin Music Festival 2018',
  'post_excerpt' => '',
  'post_name' => 'berlin-music-festival-2018',
  'post_modified' => '2018-12-15 15:04:36',
  'post_modified_gmt' => '2018-12-15 15:04:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-music/?p=195',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'event',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-music/files/2018/12/pop-festivals.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 207,
  'post_date' => '2018-12-11 14:42:30',
  'post_date_gmt' => '2018-12-11 14:42:30',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:heading -->
<h2></h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>Labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p></p>
<!-- /wp:paragraph -->',
  'post_title' => 'UK Golden Voice Awards',
  'post_excerpt' => '',
  'post_name' => 'uk-golden-voice-awards',
  'post_modified' => '2018-12-15 15:04:46',
  'post_modified_gmt' => '2018-12-15 15:04:46',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-music/?p=207',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'award',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-music/files/2018/12/UK-Golden-Voice-Award.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 231,
  'post_date' => '2018-12-08 15:31:24',
  'post_date_gmt' => '2018-12-08 15:31:24',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:heading -->
<h2></h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?”&nbsp; repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p></p>
<!-- /wp:paragraph -->',
  'post_title' => 'How To Avoid Nerves On Stage',
  'post_excerpt' => '',
  'post_name' => 'how-to-avoid-nervous-on-stage',
  'post_modified' => '2019-02-22 19:58:25',
  'post_modified_gmt' => '2019-02-22 19:58:25',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-music/?p=231',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'tips',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-music/files/2018/12/rockstar.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 239,
  'post_date' => '2018-12-05 16:23:38',
  'post_date_gmt' => '2018-12-05 16:23:38',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:heading -->
<h2></h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>taque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus. &nbsp;Ton provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?&nbsp;Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p></p>
<!-- /wp:paragraph -->',
  'post_title' => '2019 Rap Battle Competition',
  'post_excerpt' => '',
  'post_name' => '2019-rap-battle-competition',
  'post_modified' => '2018-12-15 16:31:10',
  'post_modified_gmt' => '2018-12-15 16:31:10',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-music/?p=239',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'event, trend',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-music/files/2018/12/rap-battle.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 243,
  'post_date' => '2018-12-04 16:32:11',
  'post_date_gmt' => '2018-12-04 16:32:11',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:heading -->
<h2></h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.recusandae. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p></p>
<!-- /wp:paragraph -->',
  'post_title' => 'Why We Love Music',
  'post_excerpt' => '',
  'post_name' => 'why-we-love-music',
  'post_modified' => '2018-12-15 16:40:31',
  'post_modified_gmt' => '2018-12-15 16:40:31',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-music/?p=243',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'trend',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-music/files/2018/12/concert.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 249,
  'post_date' => '2018-12-03 16:45:20',
  'post_date_gmt' => '2018-12-03 16:45:20',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:heading -->
<h2></h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus.&nbsp;Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p></p>
<!-- /wp:paragraph -->',
  'post_title' => 'Rock Band Vocalist Competition',
  'post_excerpt' => '',
  'post_name' => 'rock-band-vocalist-competition',
  'post_modified' => '2018-12-15 16:56:50',
  'post_modified_gmt' => '2018-12-15 16:56:50',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-music/?p=249',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'award',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-music/files/2018/12/rock-vocalist.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 199,
  'post_date' => '2018-12-01 14:39:05',
  'post_date_gmt' => '2018-12-01 14:39:05',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:heading -->
<h2></h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?”&nbsp; repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p></p>
<!-- /wp:paragraph -->',
  'post_title' => 'Become a Guitar Expert in 5 Days',
  'post_excerpt' => '',
  'post_name' => 'guitar-expert-in-5-days',
  'post_modified' => '2019-02-22 19:59:21',
  'post_modified_gmt' => '2019-02-22 19:59:21',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-music/?p=199',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'tips',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-music/files/2018/12/playing-guitar.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 235,
  'post_date' => '2018-11-20 16:11:19',
  'post_date_gmt' => '2018-11-20 16:11:19',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:heading -->
<h2></h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.recusandae. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p></p>
<!-- /wp:paragraph -->',
  'post_title' => '10 Best Selling Music Artists Of All Time',
  'post_excerpt' => '',
  'post_name' => '10-best-selling-music-artists-of-all-time',
  'post_modified' => '2018-12-24 05:11:19',
  'post_modified_gmt' => '2018-12-24 05:11:19',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-music/?p=235',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'trend',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-music/files/2018/12/beatles.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 190,
  'post_date' => '2018-11-15 14:09:51',
  'post_date_gmt' => '2018-11-15 14:09:51',
  'post_content' => '<!-- wp:themify-builder/canvas /-->

<!-- wp:heading -->
<h2></h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?”&nbsp; repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p></p>
<!-- /wp:paragraph -->',
  'post_title' => 'Rise Of  The Rock Music Era',
  'post_excerpt' => '',
  'post_name' => 'rise-of-the-rock-music-era',
  'post_modified' => '2018-12-24 05:09:08',
  'post_modified_gmt' => '2018-12-24 05:09:08',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-music/?p=190',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'trend',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-music/files/2018/12/retro-artist.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 300,
  'post_date' => '2018-12-17 16:48:59',
  'post_date_gmt' => '2018-12-17 16:48:59',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h2>Our Story</h2> <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatu</p> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/our-story-672x446.jpg" width="672" height="446" alt="our story" srcset="https://themify.me/demo/themes/ultra-music/files/2018/12/our-story.jpg 672w, https://themify.me/demo/themes/ultra-music/files/2018/12/our-story-600x398.jpg 600w" sizes="(max-width: 672px) 100vw, 672px" /> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/awards-670x447.jpg" width="670" height="447" alt="awards" srcset="https://themify.me/demo/themes/ultra-music/files/2018/12/awards.jpg 670w, https://themify.me/demo/themes/ultra-music/files/2018/12/awards-600x400.jpg 600w" sizes="(max-width: 670px) 100vw, 670px" /> 
 <h2>Awards</h2> <p>Doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatu Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium.</p> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/mike-angel-560x570.jpg" width="560" height="570" title="Mike Angel" alt="Guitarist" /> <h3> Mike Angel </h3> Guitarist 
 <a href="https://www.facebook.com/themify"> </a> <a href="https://www.twitter.com/themify"> </a> <a href="https://www.instagram.com/themify/"> </a> <a href="https://www.youtube.com/user/themifyme"> </a> 
 <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.  Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/alex-sams-560x468.jpg" width="560" height="468" title="Alex Sams" alt="Pianist" /> <h3> Alex Sams </h3> Pianist 
 <a href="https://www.facebook.com/themify"> </a> <a href="https://www.twitter.com/themify"> </a> <a href="https://www.instagram.com/themify/"> </a> <a href="https://www.youtube.com/user/themifyme"> </a> 
 <p>Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.  Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. </p> 
 <h2>Artists</h2> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/mabelle-howell-big-500x570.jpg" width="500" height="570" title="Mabelle Howell" alt="Lead Vocals" /> <h3> Mabelle Howell </h3> Lead Vocals 
 <a href="https://www.facebook.com/themify"> </a> <a href="https://www.twitter.com/themify"> </a> <a href="https://www.instagram.com/themify/"> </a> <a href="https://www.youtube.com/user/themifyme"> </a> 
 <p>Velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.  Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate.</p> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/miguel-500x469.jpg" width="500" height="469" title="Michelle Leah" alt="Backing Vocals" /> <h3> Michelle Leah </h3> Backing Vocals 
 <a href="https://www.facebook.com/themify"> </a> <a href="https://www.twitter.com/themify"> </a> <a href="https://www.instagram.com/themify/"> </a> <a href="https://www.youtube.com/user/themifyme"> </a> 
 <p>Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. </p> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/timeline-2008-460x310.jpg" width="460" height="310" alt="timeline 2008" /> 
 <h2>2008</h2> <p> Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p> 
 <h2>2010</h2> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/timeline-2010-761x480.jpg" width="761" height="480" alt="timeline 2010" srcset="https://themify.me/demo/themes/ultra-music/files/2018/12/timeline-2010.jpg 761w, https://themify.me/demo/themes/ultra-music/files/2018/12/timeline-2010-600x378.jpg 600w" sizes="(max-width: 761px) 100vw, 761px" /> 
 <p>Nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam.</p> 
 <h2>2011</h2> <p>Incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor.</p> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/timeline-2011-660x400.jpg" width="660" height="400" alt="timeline 2011" srcset="https://themify.me/demo/themes/ultra-music/files/2018/12/timeline-2011.jpg 660w, https://themify.me/demo/themes/ultra-music/files/2018/12/timeline-2011-600x364.jpg 600w" sizes="(max-width: 660px) 100vw, 660px" /> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/timeline-2012-560x350.jpg" width="560" height="350" alt="timeline 2012" /> 
 <h2>2012</h2> <p>Dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure.</p> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/timeline-2014-560x350.jpg" width="560" height="350" alt="timeline 2014" /> 
 <h2>2014</h2> <p>Reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in.</p> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/timeline-2016-360x323.jpg" width="360" height="323" alt="timeline 2016" /> 
 <h2>2016</h2> <p>Laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco.</p> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/timeline-2018-360x323.jpg" width="360" height="323" alt="timeline 2018" /> 
 <h2>2018</h2> <p>Velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate.</p> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/timeline-2019-360x323.jpg" width="360" height="323" alt="timeline 2019" /> 
 <h2>2019</h2> <p>Nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</p><!--/themify_builder_static-->',
  'post_title' => 'About',
  'post_excerpt' => '',
  'post_name' => 'about',
  'post_modified' => '2019-01-07 15:37:36',
  'post_modified_gmt' => '2019-01-07 15:37:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-music/?page_id=300',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"82d1c83\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"a40614c\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/bg-hero-about.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"15\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"79d76db\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"82d1c83\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"a40614c\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"54290d1\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"d695962\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-1\\"},{\\"element_id\\":\\"eaa78ed\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-3\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ac97616\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"5\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>Our Story<\\\\/h2>\\\\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatu<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}]}],\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column-full\\"}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"f847760\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"8d568ca\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-right\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/our-story.jpg\\",\\"width_image\\":\\"672\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"446\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/dot-1-1.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"padding_left\\":\\"3\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"column_alignment\\":\\"col_align_middle\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"},\\"row_width\\":\\"fullwidth-content\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"911c5b7\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"82d1c83\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"a40614c\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"8d568ca\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/awards.jpg\\",\\"width_image\\":\\"670\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"447\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/dot-6.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"3\\",\\"padding_right_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"f847760\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"215c7a7\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"10046ba\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-3\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ac97616\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"5\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>Awards<\\\\/h2>\\\\n<p>Doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatu Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}]},{\\"element_id\\":\\"f3bb1c0\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-1\\"}],\\"col_tablet\\":\\"column-full\\"}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"row_width\\":\\"fullwidth-content\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"911c5b7\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"911c5b7\\",\\"row_order\\":\\"3\\",\\"cols\\":[{\\"element_id\\":\\"71aa916\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"d045c5b\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"border-type\\":\\"top\\",\\"i_t_b-type\\":\\"top\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/mike-angel.jpg\\",\\"width_image\\":\\"560\\",\\"height_image\\":\\"570\\",\\"title_image\\":\\"Mike Angel\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Guitarist\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"ee32038\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_icon\\":\\"#05062a\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"none\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-facebook\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/www.facebook.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\"},{\\"icon\\":\\"ti-twitter-alt\\",\\"link\\":\\"https:\\\\/\\\\/www.twitter.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\",\\"icon_color_bg\\":\\"\\"},{\\"icon\\":\\"ti-instagram\\",\\"link\\":\\"https:\\\\/\\\\/www.instagram.com\\\\/themify\\\\/\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\",\\"icon_color_bg\\":\\"\\"},{\\"icon\\":\\"ti-youtube\\",\\"link\\":\\"https:\\\\/\\\\/www.youtube.com\\\\/user\\\\/themifyme\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\",\\"icon_color_bg\\":\\"\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"864cb92\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"10\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.  Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"d045c5b\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/alex-sams.jpg\\",\\"width_image\\":\\"560\\",\\"height_image\\":\\"468\\",\\"title_image\\":\\"Alex Sams\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Pianist\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"ee32038\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_icon\\":\\"#05062a\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"none\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-facebook\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/www.facebook.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\"},{\\"icon\\":\\"ti-twitter-alt\\",\\"link\\":\\"https:\\\\/\\\\/www.twitter.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\",\\"icon_color_bg\\":\\"\\"},{\\"icon\\":\\"ti-instagram\\",\\"link\\":\\"https:\\\\/\\\\/www.instagram.com\\\\/themify\\\\/\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\",\\"icon_color_bg\\":\\"\\"},{\\"icon\\":\\"ti-youtube\\",\\"link\\":\\"https:\\\\/\\\\/www.youtube.com\\\\/user\\\\/themifyme\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\",\\"icon_color_bg\\":\\"\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"864cb92\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"10\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.  Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. <\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]},{\\"element_id\\":\\"e61ef9d\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"a7c4e9b\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_left\\":\\"30\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"5\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>Artists<\\\\/h2>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"d045c5b\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/mabelle-howell-big.jpg\\",\\"width_image\\":\\"500\\",\\"height_image\\":\\"570\\",\\"title_image\\":\\"Mabelle Howell\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Lead Vocals\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"ee32038\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_icon\\":\\"#05062a\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"none\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-facebook\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/www.facebook.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\"},{\\"icon\\":\\"ti-twitter-alt\\",\\"link\\":\\"https:\\\\/\\\\/www.twitter.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\",\\"icon_color_bg\\":\\"\\"},{\\"icon\\":\\"ti-instagram\\",\\"link\\":\\"https:\\\\/\\\\/www.instagram.com\\\\/themify\\\\/\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\",\\"icon_color_bg\\":\\"\\"},{\\"icon\\":\\"ti-youtube\\",\\"link\\":\\"https:\\\\/\\\\/www.youtube.com\\\\/user\\\\/themifyme\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\",\\"icon_color_bg\\":\\"\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"864cb92\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"10\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.  Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"d045c5b\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/miguel.jpg\\",\\"width_image\\":\\"500\\",\\"height_image\\":\\"469\\",\\"title_image\\":\\"Michelle Leah\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Backing Vocals\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"ee32038\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_icon\\":\\"#05062a\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"none\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-facebook\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/www.facebook.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\"},{\\"icon\\":\\"ti-twitter-alt\\",\\"link\\":\\"https:\\\\/\\\\/www.twitter.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\",\\"icon_color_bg\\":\\"\\"},{\\"icon\\":\\"ti-instagram\\",\\"link\\":\\"https:\\\\/\\\\/www.instagram.com\\\\/themify\\\\/\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\",\\"icon_color_bg\\":\\"\\"},{\\"icon\\":\\"ti-youtube\\",\\"link\\":\\"https:\\\\/\\\\/www.youtube.com\\\\/user\\\\/themifyme\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\",\\"icon_color_bg\\":\\"\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"864cb92\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"10\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. <\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/dot-6.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"tablet_dir\\":\\"rtl\\",\\"mobile_dir\\":\\"rtl\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"},\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"e0b1afc\\",\\"row_order\\":\\"4\\",\\"cols\\":[{\\"element_id\\":\\"d3f9488\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"37dcd82\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/timeline-2008.jpg\\",\\"width_image\\":\\"460\\",\\"height_image\\":\\"310\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]},{\\"element_id\\":\\"3f7006c\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"864cb92\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>2008<\\\\/h2>\\\\n<p> Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"e0b1afc\\",\\"row_order\\":\\"5\\",\\"cols\\":[{\\"element_id\\":\\"d3f9488\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"864cb92\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"right\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>2010<\\\\/h2>\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"custom_parallax_scroll_reverse\\":\\"reverse\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"right\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"right\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}]},{\\"element_id\\":\\"3f7006c\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-3\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"37dcd82\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/timeline-2010.jpg\\",\\"width_image\\":\\"761\\",\\"height_image\\":\\"480\\",\\"param_image\\":\\"regular\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"864cb92\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_right\\":\\"15\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"10\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"8d568ca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"14022e7\\",\\"row_order\\":\\"6\\",\\"cols\\":[{\\"element_id\\":\\"1fb9022\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"9af4b11\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>2011<\\\\/h2>\\\\n<p>Incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}]},{\\"element_id\\":\\"a7b849f\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"8181728\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/timeline-2011.jpg\\",\\"width_image\\":\\"660\\",\\"height_image\\":\\"400\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"3\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"}}}]}],\\"tablet_dir\\":\\"rtl\\",\\"mobile_dir\\":\\"rtl\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"14022e7\\",\\"row_order\\":\\"7\\",\\"cols\\":[{\\"element_id\\":\\"1fb9022\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"8181728\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"4\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/timeline-2012.jpg\\",\\"width_image\\":\\"560\\",\\"height_image\\":\\"350\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"9af4b11\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>2012<\\\\/h2>\\\\n<p>Dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}]},{\\"element_id\\":\\"a7b849f\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"8181728\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"4\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/timeline-2014.jpg\\",\\"width_image\\":\\"560\\",\\"height_image\\":\\"350\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"2\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"9af4b11\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>2014<\\\\/h2>\\\\n<p>Reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"f3e699f\\",\\"row_order\\":\\"8\\",\\"cols\\":[{\\"element_id\\":\\"6e7db44\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"8181728\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/timeline-2016.jpg\\",\\"width_image\\":\\"360\\",\\"height_image\\":\\"323\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"9af4b11\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>2016<\\\\/h2>\\\\n<p>Laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}]},{\\"element_id\\":\\"a7a9457\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"8181728\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/timeline-2018.jpg\\",\\"width_image\\":\\"360\\",\\"height_image\\":\\"323\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"2\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"9af4b11\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>2018<\\\\/h2>\\\\n<p>Velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}]},{\\"element_id\\":\\"a78c71a\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"8181728\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/timeline-2019.jpg\\",\\"width_image\\":\\"360\\",\\"height_image\\":\\"323\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"3\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"9af4b11\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>2019<\\\\/h2>\\\\n<p>Nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}]}],\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"},\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"82d1c83\\",\\"unstick_when_el_mod_id\\":\\"ac97616\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"73eddcf\\",\\"row_order\\":\\"9\\",\\"cols\\":[{\\"element_id\\":\\"b328f04\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 213,
  'post_date' => '2018-12-15 15:00:43',
  'post_date_gmt' => '2018-12-15 15:00:43',
  'post_content' => '<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Blog',
  'post_excerpt' => '',
  'post_name' => 'blog',
  'post_modified' => '2018-12-18 08:24:24',
  'post_modified_gmt' => '2018-12-18 08:24:24',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-music/?page_id=213',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'hide_page_title' => 'yes',
    'mobile_menu_styles' => 'default',
    'query_category' => '0',
    'posts_per_page' => '4',
    'post_filter' => 'no',
    'image_width' => '1160',
    'image_height' => '500',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 437,
  'post_date' => '2018-12-18 04:49:16',
  'post_date_gmt' => '2018-12-18 04:49:16',
  'post_content' => '<!--themify_builder_static--><h2>Contact</h2>
<h2>&amp; Booking Info</h2> <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia.</p>
<img src="https://themify.me/demo/themes/ultra-music/files/2018/12/label-icon-300x300.jpg" width="300" height="300" title="Our Label" alt="Head Office: 3225 Yonge St, Toronto, ON, M4N 2L3, Canada" srcset="https://themify.me/demo/themes/ultra-music/files/2018/12/label-icon.jpg 300w, https://themify.me/demo/themes/ultra-music/files/2018/12/label-icon-150x150.jpg 150w" sizes="(max-width: 300px) 100vw, 300px" /> <h3> Our Label </h3> Head Office: 3225 Yonge St, Toronto, <br> ON, M4N 2L3, Canada
<img src="https://themify.me/demo/themes/ultra-music/files/2018/12/contact-icon-300x300.jpg" width="300" height="300" title="Contact" alt="( 1800) 910-6026 info@musicskin.com" srcset="https://themify.me/demo/themes/ultra-music/files/2018/12/contact-icon.jpg 300w, https://themify.me/demo/themes/ultra-music/files/2018/12/contact-icon-150x150.jpg 150w" sizes="(max-width: 300px) 100vw, 300px" /> <h3> Contact </h3> (+1800) 910-6026 <br> info@musicskin.com
<img src="https://themify.me/demo/themes/ultra-music/files/2018/12/social-network-icon-300x300.jpg" width="300" height="300" title="Social Network" alt="Social Network" srcset="https://themify.me/demo/themes/ultra-music/files/2018/12/social-network-icon.jpg 300w, https://themify.me/demo/themes/ultra-music/files/2018/12/social-network-icon-150x150.jpg 150w" sizes="(max-width: 300px) 100vw, 300px" /> <h3> Social Network </h3>
<a href="https://facebook.com/themify"> </a> <a href="https://twitter.com/themify"> </a> <a href="https://youtube.com/themifyme"> </a> <a href="https://instagram.com/themify"> </a>
<img src="https://themify.me/demo/themes/ultra-music/files/2018/12/press-1-463x619.jpg" width="463" height="619" alt="press 1" srcset="https://themify.me/demo/themes/ultra-music/files/2018/12/press-1.jpg 463w, https://themify.me/demo/themes/ultra-music/files/2018/12/press-1-449x600.jpg 449w" sizes="(max-width: 463px) 100vw, 463px" />
<h2>Press</h2> <p>Read the latest about our tour, latest album, and this year’s awards season – direct from the source!</p>
<a href="https://themify.me/" > Press kit </a>
<img src="https://themify.me/demo/themes/ultra-music/files/2018/12/press-2-260x260.jpg" width="260" height="260" title="Album II" alt="We won Best Folk Album 2018!" srcset="https://themify.me/demo/themes/ultra-music/files/2018/12/press-2.jpg 260w, https://themify.me/demo/themes/ultra-music/files/2018/12/press-2-150x150.jpg 150w" sizes="(max-width: 260px) 100vw, 260px" /> <h3> Album II </h3> We won Best Folk Album 2018!
<img src="https://themify.me/demo/themes/ultra-music/files/2018/12/press-3-260x260.jpg" width="260" height="260" title="Vinyl King" alt="Our album “Young Again” was featured in Vinyl King magazine." srcset="https://themify.me/demo/themes/ultra-music/files/2018/12/press-3.jpg 260w, https://themify.me/demo/themes/ultra-music/files/2018/12/press-3-150x150.jpg 150w" sizes="(max-width: 260px) 100vw, 260px" /> <h3> Vinyl King </h3> Our album “Young Again” was featured in Vinyl King magazine.
Head Office
<h2>We\'d love to hear from you - whether it\'s a booking request or a fan letter. Get in touch now.</h2>
<form action="https://themify.me/demo/themes/ultra-music/wp-admin/admin-ajax.php" id="contact-0--form" method="post"> <label for="contact-0--contact-name">Your Name </label> <input type="text" name="contact-name" placeholder="" id="contact-0--contact-name" value="" /> <label for="contact-0--contact-email">Your Email </label> <input type="text" name="contact-email" placeholder="" id="contact-0--contact-email" value="" /> <label for="contact-0--contact-subject">Subject *</label> <input type="text" name="contact-subject" placeholder="" id="contact-0--contact-subject" value="" required /> <label for="contact-0--contact-message">Message *</label> <textarea name="contact-message" placeholder="" id="contact-0--contact-message" rows="8" cols="45" required></textarea> <button type="submit"> Send Message </button> </form><!--/themify_builder_static-->',
  'post_title' => 'Contact',
  'post_excerpt' => '',
  'post_name' => 'contact',
  'post_modified' => '2019-09-19 15:28:48',
  'post_modified_gmt' => '2019-09-19 15:28:48',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-music/?page_id=437',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"6144552\\",\\"cols\\":[{\\"element_id\\":\\"1ada7ef\\",\\"grid_class\\":\\"col-full\\"}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/bg-hero-contact.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"15\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth\\"}},{\\"element_id\\":\\"1ipv513\\",\\"cols\\":[{\\"element_id\\":\\"76qh530\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"0be3383\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"5\\",\\"font_size_h2_unit\\":\\"em\\",\\"h2_margin_bottom\\":\\"0\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>Contact<\\\\/h2>\\",\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ytmp534\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>&amp; Booking Info<\\\\/h2>\\\\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia.<\\\\/p>\\",\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"2\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"2\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/dot-1.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"3\\",\\"padding_left_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"thumbnail\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"3500\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"left-top\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth\\"}},{\\"element_id\\":\\"4ca2e43\\",\\"cols\\":[{\\"element_id\\":\\"1a8f31a\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"89997a3\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"},\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/label-icon.jpg\\",\\"width_image\\":\\"300\\",\\"height_image\\":\\"300\\",\\"title_image\\":\\"Our Label\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Head Office: 3225 Yonge St, Toronto, <br>\\\\nON, M4N 2L3, Canada\\\\n\\"}}]},{\\"element_id\\":\\"e21023c\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"m07m537\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"},\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/contact-icon.jpg\\",\\"width_image\\":\\"300\\",\\"height_image\\":\\"300\\",\\"title_image\\":\\"Contact\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"(+1800) 910-6026 <br>\\\\ninfo@musicskin.com\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/bg-line-3.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-bottom\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"58708fe\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"2lk1539\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/social-network-icon.jpg\\",\\"width_image\\":\\"300\\",\\"height_image\\":\\"300\\",\\"title_image\\":\\"Social Network\\",\\"param_image\\":\\"regular\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"2fcb6d7\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#05062a\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"text_align\\":\\"center\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_icon\\":\\"#05062a\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"none\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-facebook\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/facebook.com\\\\/themify\\",\\"link_options\\":\\"regular\\"},{\\"icon\\":\\"ti-twitter\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/twitter.com\\\\/themify\\",\\"link_options\\":\\"regular\\"},{\\"icon\\":\\"ti-youtube\\",\\"link\\":\\"https:\\\\/\\\\/youtube.com\\\\/themifyme\\",\\"link_options\\":\\"regular\\",\\"icon_color_bg\\":\\"tb_default_color\\"},{\\"icon\\":\\"ti-instagram\\",\\"link\\":\\"https:\\\\/\\\\/instagram.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"icon_color_bg\\":\\"tb_default_color\\"}],\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}}]}],\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#05062a\\",\\"font_size\\":\\"1.1\\",\\"font_size_unit\\":\\"em\\",\\"line_height\\":\\"2\\",\\"line_height_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"99b6914\\",\\"cols\\":[{\\"element_id\\":\\"e092fcc\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"0ea00a7\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/press-1.jpg\\",\\"width_image\\":\\"463\\",\\"height_image\\":\\"619\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"8\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"}}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/dot-1-1.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"a2eae68\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"763e686\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"1.2\\",\\"font_size_unit\\":\\"em\\",\\"line_height\\":\\"1.3\\",\\"line_height_unit\\":\\"em\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_gradient_color_h2-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size_h2\\":\\"6\\",\\"font_size_h2_unit\\":\\"em\\",\\"h2_margin_bottom\\":\\"20\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<h2>Press<\\\\/h2>\\\\n<p>Read the latest about our tour, latest album, and this year’s awards season – direct from the source!<\\\\/p>\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"289435a\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"25\\",\\"border-type\\":\\"top\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\",\\"buttons_size\\":\\"normal\\",\\"buttons_shape\\":\\"squared\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Press kit\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\",\\"button_color_bg\\":\\"tb_default_color\\"}]}},{\\"element_id\\":\\"cbdba2b\\",\\"cols\\":[{\\"element_id\\":\\"80acdde\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"122de46\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"60\\",\\"border-type\\":\\"top\\",\\"font_color_title\\":\\"#000000\\",\\"font_size_title\\":\\"1.5\\",\\"font_size_title_unit\\":\\"em\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"font_size_caption\\":\\"1\\",\\"font_size_caption_unit\\":\\"em\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/press-2.jpg\\",\\"width_image\\":\\"260\\",\\"height_image\\":\\"260\\",\\"title_image\\":\\"Album II\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"We won Best Folk Album 2018!\\"}}]},{\\"element_id\\":\\"88650a4\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"xtiz548\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_weight_title\\":\\"700\\",\\"font_color_title\\":\\"#000000\\",\\"font_size_title\\":\\"1.5\\",\\"font_size_title_unit\\":\\"em\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"font_size_caption\\":\\"1\\",\\"font_size_caption_unit\\":\\"em\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/press-3.jpg\\",\\"width_image\\":\\"260\\",\\"height_image\\":\\"260\\",\\"title_image\\":\\"Vinyl King\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Our album “Young Again” was featured in Vinyl King magazine.\\"}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"-40\\",\\"border-type\\":\\"top\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"25\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_right\\":\\"6\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"6\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}}],\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"2cef253\\",\\"cols\\":[{\\"element_id\\":\\"441beed\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"maps-pro\\",\\"element_id\\":\\"bfc4eca\\",\\"mod_settings\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"map_display_type\\":\\"dynamic\\",\\"w_map\\":\\"100\\",\\"w_map_unit\\":\\"%\\",\\"w_map_static\\":\\"500\\",\\"h_map\\":\\"450\\",\\"type_map\\":\\"ROADMAP\\",\\"style_map\\":\\"muted-blue\\",\\"scrollwheel_map\\":\\"disable\\",\\"draggable_map\\":\\"desktop_only\\",\\"disable_map_ui\\":\\"no\\",\\"zoom_map\\":\\"15\\",\\"map_polyline\\":\\"no\\",\\"map_polyline_geodesic\\":\\"yes\\",\\"map_polyline_stroke\\":\\"2\\",\\"map_polyline_color\\":\\"ff0000\\",\\"map_center\\":\\"Toronto, ON, Canada\\",\\"markers\\":[{\\"address\\":\\"Toronto, ON, Canada\\",\\"title\\":\\"Head Office\\",\\"image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/pin-map.png\\"}]}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth-content\\"}},{\\"element_id\\":\\"6196bd8\\",\\"cols\\":[{\\"element_id\\":\\"1559a91\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"30011da\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"8\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3.5\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_tablet_landscape\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"2\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"2\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<h2>We\\\\\\\\\\\'d love to hear from you - whether it\\\\\\\\\\\'s a booking request or a fan letter. Get in touch now.<\\\\/h2>\\"}},{\\"mod_name\\":\\"contact\\",\\"element_id\\":\\"7bd62fc\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"border_inputs-type\\":\\"top\\",\\"border_send-type\\":\\"top\\",\\"checkbox_padding_success_message_apply_all\\":\\"1\\",\\"checkbox_margin_success_message_apply_all\\":\\"1\\",\\"border_success_message-type\\":\\"top\\",\\"checkbox_padding_error_message_apply_all\\":\\"1\\",\\"checkbox_margin_error_message_apply_all\\":\\"1\\",\\"border_error_message-type\\":\\"top\\",\\"layout_contact\\":\\"style1\\",\\"gdpr_label\\":\\"I consent to my submitted data being collected and stored\\",\\"field_name_label\\":\\"Your Name\\",\\"field_email_label\\":\\"Your Email\\",\\"field_subject_label\\":\\"Subject\\",\\"field_subject_require\\":\\"yes\\",\\"field_subject_active\\":\\"yes\\",\\"field_message_label\\":\\"Message\\",\\"field_extra\\":\\"{ \\\\\\\\\\\\\\"fields\\\\\\\\\\\\\\": [] }\\",\\"field_sendcopy_label\\":\\"Send a copy to myself\\",\\"field_order\\":\\"{}\\",\\"field_send_label\\":\\"Send Message\\",\\"field_send_align\\":\\"center\\",\\"field_email_active\\":\\"yes\\",\\"field_name_active\\":\\"yes\\",\\"field_message_active\\":\\"yes\\",\\"field_sendcopy_active\\":\\"\\",\\"field_captcha_active\\":\\"\\",\\"field_email_require\\":\\"\\",\\"field_name_require\\":\\"\\",\\"contact_sent_from\\":\\"enable\\",\\"post_author\\":\\"\\",\\"send_to_admins\\":\\"true\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/shape.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"7\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"7\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 5,
  'post_date' => '2018-12-14 11:20:03',
  'post_date_gmt' => '2018-12-14 11:20:03',
  'post_content' => '<!--themify_builder_static--><h1>Music Band</h1> 
 <h1>&amp;<br />Summer Festival</h1> 
 <p>Australia</p> 
 <p>November 30, 2018</p> 
 <a href="https://themify.me/" >Buy Ticket</a> 
 <a href="https://themify.me/demo/themes/ultra-music/" > <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/album-cover-1-500x500.jpg" width="500" height="500" alt="album cover 1" srcset="https://themify.me/demo/themes/ultra-music/files/2018/12/album-cover-1.jpg 500w, https://themify.me/demo/themes/ultra-music/files/2018/12/album-cover-1-150x150.jpg 150w" sizes="(max-width: 500px) 100vw, 500px" /> </a> 
 <p>Gradient colours, bokeh effects, and geometric accents – the Ultra Music Skin is here! This skin has been tailor made for musicians, music &amp; art festivals, and rock bands. Speak for yourself by sharing your story, tour dates, albums, photo gallery, and press excerpts with your followers. Make your tour merchandise accessible for your dearest fans using the online shop!</p> 
 <h2>Latest Album</h2> 
 <p>The Last Sunset of Summer</p> 
 <a href="https://themify.me/" > Buy on iTunes</a> 
 <ol> <li itemprop="track" itemscope="" itemtype="https://schema.org/MusicRecording"> <a href="#" itemprop="url">The Last Sunset of Summer</a> <audio id="audio-0-1" preload="none" style="width: 100%;" controls="controls"><source type="audio/mpeg" src="https://themify.me/demo/themes/themes/wp-content/uploads/addon-samples/sample-song.mp3?_=1" /><a href="https://themify.me/demo/themes/themes/wp-content/uploads/addon-samples/sample-song.mp3">https://themify.me/demo/themes/themes/wp-content/uploads/addon-samples/sample-song.mp3</a></audio> </li> <li itemprop="track" itemscope="" itemtype="https://schema.org/MusicRecording"> <a href="#" itemprop="url">Good Morning </a> <audio id="audio-0-2" preload="none" style="width: 100%;" controls="controls"><source type="audio/mpeg" src="https://themify.me/demo/themes/themes/wp-content/uploads/addon-samples/sample-song.mp3?_=2" /><a href="https://themify.me/demo/themes/themes/wp-content/uploads/addon-samples/sample-song.mp3">https://themify.me/demo/themes/themes/wp-content/uploads/addon-samples/sample-song.mp3</a></audio> </li> <li itemprop="track" itemscope="" itemtype="https://schema.org/MusicRecording"> <a href="#" itemprop="url">Spirit Freed</a> <audio id="audio-0-3" preload="none" style="width: 100%;" controls="controls"><source type="audio/mpeg" src="https://themify.me/demo/themes/themes/wp-content/uploads/addon-samples/sample-song.mp3?_=3" /><a href="https://themify.me/demo/themes/themes/wp-content/uploads/addon-samples/sample-song.mp3">https://themify.me/demo/themes/themes/wp-content/uploads/addon-samples/sample-song.mp3</a></audio> </li> <li itemprop="track" itemscope="" itemtype="https://schema.org/MusicRecording"> <a href="#" itemprop="url">Aloha</a> <audio id="audio-0-4" preload="none" style="width: 100%;" controls="controls"><source type="audio/mpeg" src="https://themify.me/demo/themes/themes/wp-content/uploads/addon-samples/sample-song.mp3?_=4" /><a href="https://themify.me/demo/themes/themes/wp-content/uploads/addon-samples/sample-song.mp3">https://themify.me/demo/themes/themes/wp-content/uploads/addon-samples/sample-song.mp3</a></audio> </li> <li itemprop="track" itemscope="" itemtype="https://schema.org/MusicRecording"> <a href="#" itemprop="url">Run</a> <audio id="audio-0-5" preload="none" style="width: 100%;" controls="controls"><source type="audio/mpeg" src="https://themify.me/demo/themes/themes/wp-content/uploads/addon-samples/sample-song.mp3?_=5" /><a href="https://themify.me/demo/themes/themes/wp-content/uploads/addon-samples/sample-song.mp3">https://themify.me/demo/themes/themes/wp-content/uploads/addon-samples/sample-song.mp3</a></audio> </li> <li itemprop="track" itemscope="" itemtype="https://schema.org/MusicRecording"> <a href="#" itemprop="url">Hello Sunshine</a> <audio id="audio-0-6" preload="none" style="width: 100%;" controls="controls"><source type="audio/mpeg" src="https://themify.me/demo/themes/themes/wp-content/uploads/addon-samples/sample-song.mp3?_=6" /><a href="https://themify.me/demo/themes/themes/wp-content/uploads/addon-samples/sample-song.mp3">https://themify.me/demo/themes/themes/wp-content/uploads/addon-samples/sample-song.mp3</a></audio> </li> <li itemprop="track" itemscope="" itemtype="https://schema.org/MusicRecording"> <a href="#" itemprop="url">King & Queens</a> <audio id="audio-0-7" preload="none" style="width: 100%;" controls="controls"><source type="audio/mpeg" src="https://themify.me/demo/themes/themes/wp-content/uploads/addon-samples/sample-song.mp3?_=7" /><a href="https://themify.me/demo/themes/themes/wp-content/uploads/addon-samples/sample-song.mp3">https://themify.me/demo/themes/themes/wp-content/uploads/addon-samples/sample-song.mp3</a></audio> </li> <li itemprop="track" itemscope="" itemtype="https://schema.org/MusicRecording"> <a href="#" itemprop="url">Lanai</a> <audio id="audio-0-8" preload="none" style="width: 100%;" controls="controls"><source type="audio/mpeg" src="https://themify.me/demo/themes/themes/wp-content/uploads/addon-samples/sample-song.mp3?_=8" /><a href="https://themify.me/demo/themes/themes/wp-content/uploads/addon-samples/sample-song.mp3">https://themify.me/demo/themes/themes/wp-content/uploads/addon-samples/sample-song.mp3</a></audio> </li> </ol> 
 <h2>Others Albums</h2> 
 <a href="https://themify.me/demo/themes/ultra-music/" > <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/album-cover-2-400x400.jpg" width="400" height="400" alt="album cover 2" srcset="https://themify.me/demo/themes/ultra-music/files/2018/12/album-cover-2.jpg 400w, https://themify.me/demo/themes/ultra-music/files/2018/12/album-cover-2-150x150.jpg 150w" sizes="(max-width: 400px) 100vw, 400px" /> </a> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/itunes-button-190x70.png" width="190" height="70" alt="itunes button" /> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/google-play-button-190x70.png" width="190" height="70" alt="google play button" /> 
 <a href="https://themify.me/demo/themes/ultra-music/"> View Releases </a> 
 <a href="https://themify.me/demo/themes/ultra-music/" > <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/album-cover-3-300x300.jpg" width="300" height="300" alt="album cover 3" srcset="https://themify.me/demo/themes/ultra-music/files/2018/12/album-cover-3.jpg 300w, https://themify.me/demo/themes/ultra-music/files/2018/12/album-cover-3-150x150.jpg 150w" sizes="(max-width: 300px) 100vw, 300px" /> </a> 
 <a href="https://themify.me/demo/themes/ultra-music/" > <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/album-cover-4--300x300.jpg" width="300" height="300" alt="album-cover-4-" srcset="https://themify.me/demo/themes/ultra-music/files/2018/12/album-cover-4-.jpg 300w, https://themify.me/demo/themes/ultra-music/files/2018/12/album-cover-4--150x150.jpg 150w" sizes="(max-width: 300px) 100vw, 300px" /> </a> 
 <a href="https://themify.me/demo/themes/ultra-music/" > <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/album-cover-5-340x340.jpg" width="340" height="340" alt="album cover 5" srcset="https://themify.me/demo/themes/ultra-music/files/2018/12/album-cover-5.jpg 340w, https://themify.me/demo/themes/ultra-music/files/2018/12/album-cover-5-150x150.jpg 150w" sizes="(max-width: 340px) 100vw, 340px" /> </a> 
 <a href="https://themify.me/demo/themes/ultra-music/" > <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/album-cover-6--340x340.jpg" width="340" height="340" alt="album cover 6" srcset="https://themify.me/demo/themes/ultra-music/files/2018/12/album-cover-6-.jpg 340w, https://themify.me/demo/themes/ultra-music/files/2018/12/album-cover-6--150x150.jpg 150w" sizes="(max-width: 340px) 100vw, 340px" /> </a> 
 <h2>Tours</h2> 
 <a href="https://themify.me/demo/themes/ultra-music/tours/" >More Concerts</a> 
 <h2>Latest News</h2> 
 <p>Subscribe To Our</p> 
 <h2>Newsletter</h2> 
 <p>Sign up for the latest tour dates and merch releases!</p> 
 <form action="//themify.us2.list-manage.com/subscribe/post?u=03462cf158e86ea00590274ab&amp;id=0f2a95e5de" method="post" id="mc-embedded-subscribe-form" name="mc-embedded-subscribe-form" target="_blank" novalidate> <input type="email" value="" name="EMAIL" id="mce-EMAIL"> <input type="submit" value="Subscribe" name="subscribe" id="mc-embedded-subscribe"> <input type="text" name="b_03462cf158e86ea00590274ab_0f2a95e5de" tabindex="-1" value=""> </form>
 
 <a href="https://themify.me/demo/themes/ultra-music/files/2018/12/erica-montoque.jpg" > <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/photo-1--333x355.jpg" width="333" height="355" alt="photo 1" /> </a> 
 <a href="https://themify.me/demo/themes/ultra-music/files/2018/12/jacob-svensson.jpg" > <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/photo-2-300x320.jpg" width="300" height="320" alt="photo 2" /> </a> 
 <a href="https://themify.me/demo/themes/ultra-music/files/2018/12/jonathan-samuel.jpg" > <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/photo-3--300x320.jpg" width="300" height="320" alt="photo 3" /> </a> 
 <a href="https://themify.me/demo/themes/ultra-music/files/2018/12/frankie-cordoba.jpg" > <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/photo-4--240x247.jpg" width="240" height="247" alt="photo 4" /> </a> 
 <a href="https://themify.me/" >See More</a> 
 <h2>Photos</h2> <p>Feel free to download our photos for your desktop or photo gallery - frame them or tape it on your wall!</p> 
 <a href="https://themify.me/demo/themes/ultra-music/files/2018/12/erick-samuel.jpg" > <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/photo-5-400x427.jpg" width="400" height="427" alt="photo 5" srcset="https://themify.me/demo/themes/ultra-music/files/2018/12/photo-5-400x427.jpg 400w, https://themify.me/demo/themes/ultra-music/files/2018/12/photo-5.jpg 401w" sizes="(max-width: 400px) 100vw, 400px" /> </a> 
 <h2>Videos</h2> <p>Enjoy a collection of our concert snippets. For more videos, check out our YouTube channel.</p> 
 <a href="https://themify.me/" >Youtube</a> 
 <a href="https://www.youtube.com/watch?v=P8Lte26BBN8" data-zoom-config="980px|585px" > <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/video-1-600x338.jpg" width="600" height="338" alt="video 1" /> </a> 
 <a href="https://www.youtube.com/watch?v=FFM6dop3I08" data-zoom-config="980px|585px" > <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/video-2-360x260.jpg" width="360" height="260" alt="video 2" /> </a> 
 <a href="https://www.youtube.com/watch?v=FFM6dop3I08" data-zoom-config="980px|585px" > <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/video-3-360x260.jpg" width="360" height="260" alt="video 3" /> </a> 
 <a href="https://www.youtube.com/watch?v=FFM6dop3I08" data-zoom-config="980px|585px" > <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/video-4-360x260.jpg" width="360" height="260" alt="video 4" /> </a> 
 <h2>The Artists</h2> 
 <a href="https://themify.me/demo/themes/ultra-music/files/2018/12/mabelle-howell.jpg" > <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/mabelle-howell-460x470.jpg" width="460" height="470" title="Mabelle Howell" alt="Lead Vocals" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-music/files/2018/12/mabelle-howell.jpg" > Mabelle Howell </a> </h3> Lead Vocals 
 <a href="https://themify.me/demo/themes/ultra-music/files/2018/12/simone-altraz.jpg" > <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/artist-2-260x260.jpg" width="260" height="260" title="Mike Angel" alt="Guitarist" srcset="https://themify.me/demo/themes/ultra-music/files/2018/12/artist-2.jpg 260w, https://themify.me/demo/themes/ultra-music/files/2018/12/artist-2-150x150.jpg 150w" sizes="(max-width: 260px) 100vw, 260px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-music/files/2018/12/simone-altraz.jpg" > Mike Angel </a> </h3> Guitarist 
 <a href="https://themify.me/demo/themes/ultra-music/files/2018/12/miguel-nerd.jpg" > <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/artist-3-260x260.jpg" width="260" height="260" title="Michelle Leah" alt="Backing Vocals" srcset="https://themify.me/demo/themes/ultra-music/files/2018/12/artist-3.jpg 260w, https://themify.me/demo/themes/ultra-music/files/2018/12/artist-3-150x150.jpg 150w" sizes="(max-width: 260px) 100vw, 260px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-music/files/2018/12/miguel-nerd.jpg" > Michelle Leah </a> </h3> Backing Vocals 
 <a href="https://themify.me/demo/themes/ultra-music/files/2018/12/Alex-Sams.jpg" > <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/alex-sams-260x260.jpg" width="260" height="260" title="Alex Sams" alt="Pianist" srcset="https://themify.me/demo/themes/ultra-music/files/2018/12/alex-sams-260x260.jpg 260w, https://themify.me/demo/themes/ultra-music/files/2018/12/alex-sams-150x150.jpg 150w" sizes="(max-width: 260px) 100vw, 260px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-music/files/2018/12/Alex-Sams.jpg" > Alex Sams </a> </h3> Pianist 
 <p>Read more about us below and don\'t forget to follow us on Instagram and Facebook!</p> 
 <a href="https://themify.me/" >About us</a> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/press-1-463x619.jpg" width="463" height="619" alt="press 1" srcset="https://themify.me/demo/themes/ultra-music/files/2018/12/press-1.jpg 463w, https://themify.me/demo/themes/ultra-music/files/2018/12/press-1-449x600.jpg 449w" sizes="(max-width: 463px) 100vw, 463px" /> 
 <h2>Press</h2> <p>Read the latest about our tour, latest album, and this year\'s awards season - direct from the source!</p> 
 <a href="https://themify.me/" >Press kit</a> 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/press-2-260x260.jpg" width="260" height="260" title="Album II" alt="We won Best Folk Album 2018!" srcset="https://themify.me/demo/themes/ultra-music/files/2018/12/press-2.jpg 260w, https://themify.me/demo/themes/ultra-music/files/2018/12/press-2-150x150.jpg 150w" sizes="(max-width: 260px) 100vw, 260px" /> <h3> Album II </h3> We won Best Folk Album 2018! 
 <img src="https://themify.me/demo/themes/ultra-music/files/2018/12/press-3-260x260.jpg" width="260" height="260" title="Vinyl King" alt="Our album “Young Again” was featured in Vinyl King magazine." srcset="https://themify.me/demo/themes/ultra-music/files/2018/12/press-3.jpg 260w, https://themify.me/demo/themes/ultra-music/files/2018/12/press-3-150x150.jpg 150w" sizes="(max-width: 260px) 100vw, 260px" /> <h3> Vinyl King </h3> Our album “Young Again” was featured in Vinyl King magazine.<!--/themify_builder_static-->',
  'post_title' => 'Home',
  'post_excerpt' => '',
  'post_name' => '5-2',
  'post_modified' => '2019-02-22 19:55:44',
  'post_modified_gmt' => '2019-02-22 19:55:44',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-music/?page_id=5',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'fixed_header' => 'yes',
    'mobile_menu_styles' => 'default',
    'header_wrap' => 'transparent',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"6ecc942\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"d68b6bb\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"9756bff\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#ffffff\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_size_h1\\":\\"5\\",\\"font_size_h1_unit\\":\\"em\\",\\"h1_margin_bottom\\":\\"10\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h1>Music Band<\\\\/h1>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"c92a81c\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_size_h1\\":\\"2.4\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_size_h1\\":\\"2.2\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_size_h1\\":\\"4\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"c92a81c\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#ffe430\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_size_h1\\":\\"5\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_size_h1\\":\\"4\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_size_h1\\":\\"2.2\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_size_h1\\":\\"2.4\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<h1>&amp;<br \\\\/>Summer Festival<\\\\/h1>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"f6b889d\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_family\\":\\"Playfair Display\\",\\"element_font_weight\\":\\"regular\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#ffe430\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"2\\",\\"font_size_unit\\":\\"em\\",\\"text_align\\":\\"center\\",\\"p_margin_bottom\\":\\"20\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Australia<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"c309732\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#ffffff\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"1.5\\",\\"font_size_unit\\":\\"em\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>November 30, 2018<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"289435a\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\",\\"buttons_size\\":\\"normal\\",\\"buttons_shape\\":\\"squared\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Buy Ticket\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/bg-hero-top.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"12\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"65650cb\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"65650cb\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"4e8b1d0\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"4164207\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"25\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/album-cover-1.jpg\\",\\"width_image\\":\\"500\\",\\"height_image\\":\\"500\\",\\"link_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"bd783b0\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_right\\":\\"30\\",\\"margin_right_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Gradient colours, bokeh effects, and geometric accents – the Ultra Music Skin is here! This skin has been tailor made for musicians, music &amp; art festivals, and rock bands. Speak for yourself by sharing your story, tour dates, albums, photo gallery, and press excerpts with your followers. Make your tour merchandise accessible for your dearest fans using the online shop!<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/dot-1.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#888888\\",\\"font_size\\":\\"1.2\\",\\"font_size_unit\\":\\"em\\",\\"line_height\\":\\"1.7\\",\\"line_height_unit\\":\\"em\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_left\\":\\"4\\",\\"padding_left_unit\\":\\"%\\",\\"margin_right\\":\\"-30\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"padding_top_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"a18c0b7\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"763e686\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"30\\",\\"margin_left\\":\\"70\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_weight_h2\\":\\"700\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"5\\",\\"font_size_h2_unit\\":\\"em\\",\\"h2_margin_bottom\\":\\"20\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>Latest Album<\\\\/h2>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"20\\",\\"margin_left\\":\\"0\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"2.2\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"2.2\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3.4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}},{\\"element_id\\":\\"9a9e85f\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"e3627e6\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"734eb45\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"20\\",\\"p_margin_top\\":\\"0\\",\\"p_margin_bottom\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>The Last Sunset of Summer<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]},{\\"element_id\\":\\"05345b7\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"980ba91\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"padding_link_top\\":\\"15\\",\\"padding_link_right\\":\\"20\\",\\"padding_link_bottom\\":\\"15\\",\\"padding_link_left\\":\\"20\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\",\\"buttons_size\\":\\"normal\\",\\"buttons_shape\\":\\"squared\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Buy on iTunes\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon\\":\\"fa-apple\\",\\"icon_alignment\\":\\"left\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"text_align\\":\\"right\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#050529\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#ffffff\\",\\"padding_top\\":\\"25\\",\\"padding_right\\":\\"20\\",\\"padding_bottom\\":\\"25\\",\\"padding_left\\":\\"25\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"audio\\",\\"element_id\\":\\"addb6a3\\",\\"mod_settings\\":{\\"background_color\\":\\"#050529\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#ffffff\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"padding_top\\":\\"5\\",\\"padding_right\\":\\"36\\",\\"padding_bottom\\":\\"15\\",\\"padding_left\\":\\"20\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_button_link_padding_apply_all\\":\\"1\\",\\"checkbox_button_link_margin_apply_all\\":\\"1\\",\\"button_link_border-type\\":\\"top\\",\\"music_playlist\\":[{\\"audio_name\\":\\"The Last Sunset of Summer\\",\\"audio_url\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/themes\\\\/wp-content\\\\/uploads\\\\/addon-samples\\\\/sample-song.mp3\\"},{\\"audio_name\\":\\"Good Morning \\",\\"audio_url\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/themes\\\\/wp-content\\\\/uploads\\\\/addon-samples\\\\/sample-song.mp3\\"},{\\"audio_name\\":\\"Spirit Freed\\",\\"audio_url\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/themes\\\\/wp-content\\\\/uploads\\\\/addon-samples\\\\/sample-song.mp3\\"},{\\"audio_name\\":\\"Aloha\\",\\"audio_url\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/themes\\\\/wp-content\\\\/uploads\\\\/addon-samples\\\\/sample-song.mp3\\"},{\\"audio_name\\":\\"Run\\",\\"audio_url\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/themes\\\\/wp-content\\\\/uploads\\\\/addon-samples\\\\/sample-song.mp3\\"},{\\"audio_name\\":\\"Hello Sunshine\\",\\"audio_url\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/themes\\\\/wp-content\\\\/uploads\\\\/addon-samples\\\\/sample-song.mp3\\"},{\\"audio_name\\":\\"King & Queens\\",\\"audio_url\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/themes\\\\/wp-content\\\\/uploads\\\\/addon-samples\\\\/sample-song.mp3\\"},{\\"audio_name\\":\\"Lanai\\",\\"audio_url\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/themes\\\\/wp-content\\\\/uploads\\\\/addon-samples\\\\/sample-song.mp3\\"}],\\"hide_download_audio\\":\\"yes\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-bottom\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_left\\":\\"-3\\",\\"margin_left_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-bottom\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_left\\":\\"0\\",\\"margin_left_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-bottom\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"6\\",\\"margin_top_unit\\":\\"%\\",\\"margin_bottom\\":\\"3\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}}],\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"7040bd5\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"9e08dcd\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"763e686\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_weight_h2\\":\\"700\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3.6\\",\\"font_size_h2_unit\\":\\"em\\",\\"h2_margin_bottom\\":\\"35\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>Others Albums<\\\\/h2>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"2.2\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"2.2\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"47e0a7c\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"50\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/album-cover-2.jpg\\",\\"width_image\\":\\"400\\",\\"height_image\\":\\"400\\",\\"link_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/\\",\\"param_image\\":\\"regular\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"ec7851f\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"20\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-right\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/itunes-button.png\\",\\"width_image\\":\\"190\\",\\"height_image\\":\\"70\\",\\"param_image\\":\\"regular\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"ec7851f\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-right\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/google-play-button.png\\",\\"width_image\\":\\"190\\",\\"height_image\\":\\"70\\",\\"param_image\\":\\"regular\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"grid_width\\":\\"32\\",\\"styling\\":{\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"da3d1d2\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"c6015ee\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"right\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top_unit\\":\\"%\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"icon_size\\":\\"small\\",\\"icon_style\\":\\"none\\",\\"icon_position\\":\\"icon_position_right\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-arrow-right\\",\\"icon_color_bg\\":\\"black\\",\\"label\\":\\"View Releases\\",\\"link\\":\\"https://themify.me/demo/themes/ultra-music\\\\/\\",\\"link_options\\":\\"regular\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"d25a0be\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"50\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/album-cover-3.jpg\\",\\"width_image\\":\\"300\\",\\"height_image\\":\\"300\\",\\"link_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/\\",\\"param_image\\":\\"regular\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"e8e44c4\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/album-cover-4-.jpg\\",\\"width_image\\":\\"300\\",\\"height_image\\":\\"300\\",\\"link_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/\\",\\"param_image\\":\\"regular\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"10\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"},\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"8\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"}}}],\\"grid_width\\":\\"30.4\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#000000\\",\\"text_transform\\":\\"uppercase\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"bbf9c7e\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"4713e3e\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"50\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/album-cover-5.jpg\\",\\"width_image\\":\\"340\\",\\"height_image\\":\\"340\\",\\"link_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/\\",\\"param_image\\":\\"regular\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"2ee57ba\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/album-cover-6-.jpg\\",\\"width_image\\":\\"340\\",\\"height_image\\":\\"340\\",\\"link_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/\\",\\"param_image\\":\\"regular\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"4\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}}],\\"col_tablet\\":\\"column4-2\\",\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/bg-other-album.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"45e7c84\\",\\"row_order\\":\\"3\\",\\"cols\\":[{\\"element_id\\":\\"8025403\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"327c1a7\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"47b75cf\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"763e686\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"0\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"10\\",\\"font_size_h2_unit\\":\\"em\\",\\"h2_margin_bottom\\":\\"0\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>Tours<\\\\/h2>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"2.2\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"2.2\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}]},{\\"element_id\\":\\"1cc4040\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"289435a\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\",\\"buttons_size\\":\\"xlarge\\",\\"buttons_shape\\":\\"squared\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"More Concerts\\",\\"link\\":\\"https://themify.me/demo/themes/ultra-music\\\\/tours\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"black\\",\\"icon_alignment\\":\\"left\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"text_align\\":\\"right\\",\\"padding_bottom\\":\\"35\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"column_alignment\\":\\"col_align_bottom\\",\\"col_tablet\\":\\"column-full\\"},{\\"mod_name\\":\\"event-posts\\",\\"element_id\\":\\"37b5c7c\\",\\"mod_settings\\":{\\"checkbox_general_padding_apply_all\\":\\"1\\",\\"checkbox_general_margin_apply_all\\":\\"1\\",\\"general_border-type\\":\\"top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_p_t_apply_all\\":\\"1\\",\\"checkbox_m_t_apply_all\\":\\"1\\",\\"b_t-type\\":\\"top\\",\\"checkbox_p_d_apply_all\\":\\"1\\",\\"checkbox_m_d_apply_all\\":\\"1\\",\\"b_d-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"checkbox_c_m_apply_all\\":\\"1\\",\\"c_b-type\\":\\"top\\",\\"checkbox_p_f_i_apply_all\\":\\"1\\",\\"checkbox_m_f_i_apply_all\\":\\"1\\",\\"b_f_i-type\\":\\"top\\",\\"show\\":\\"upcoming\\",\\"style\\":\\"list-post\\",\\"category\\":\\"0|multiple\\",\\"limit\\":\\"4\\",\\"order\\":\\"asc\\",\\"orderby\\":\\"event_date\\",\\"display\\":\\"excerpt\\",\\"image_w\\":\\"80\\",\\"image_h\\":\\"80\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"8bc5efc\\",\\"row_order\\":\\"4\\",\\"cols\\":[{\\"element_id\\":\\"379ffe4\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"763e686\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"40\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_weight_h2\\":\\"700\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"5\\",\\"font_size_h2_unit\\":\\"em\\",\\"h2_margin_bottom\\":\\"20\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>Latest News<\\\\/h2>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"2.2\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"2.2\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}},{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"15f43fb\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_general_solid\\",\\"checkbox_general_padding_apply_all\\":\\"1\\",\\"checkbox_general_margin_apply_all\\":\\"1\\",\\"general_border-type\\":\\"top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_p_t_apply_all\\":\\"1\\",\\"checkbox_m_t_apply_all\\":\\"1\\",\\"b_t-type\\":\\"top\\",\\"checkbox_p_d_apply_all\\":\\"1\\",\\"checkbox_m_d_apply_all\\":\\"1\\",\\"b_d-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"checkbox_c_m_apply_all\\":\\"1\\",\\"c_b-type\\":\\"top\\",\\"checkbox_p_f_i_apply_all\\":\\"1\\",\\"checkbox_m_f_i_apply_all\\":\\"1\\",\\"b_f_i-type\\":\\"top\\",\\"layout_post\\":\\"grid3\\",\\"post_type_post\\":\\"post\\",\\"type_query_post\\":\\"category\\",\\"category_post\\":\\"0|multiple\\",\\"post_tag_post\\":\\"0|multiple\\",\\"event-category_post\\":\\"0|multiple\\",\\"event-tag_post\\":\\"0|multiple\\",\\"post_filter\\":\\"no\\",\\"post_per_page_post\\":\\"3\\",\\"order_post\\":\\"desc\\",\\"orderby_post\\":\\"date\\",\\"display_post\\":\\"excerpt\\",\\"img_width_post\\":\\"360\\",\\"img_height_post\\":\\"240\\",\\"hide_post_meta_post\\":\\"yes\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/pattern-wave-1-1.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-bottom\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"2\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-bottom\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"e2f6448\\",\\"row_order\\":\\"5\\",\\"cols\\":[{\\"element_id\\":\\"123ffb6\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"763e686\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"32\\",\\"line_height\\":\\"32\\",\\"letter_spacing\\":\\"0.2\\",\\"letter_spacing_unit\\":\\"em\\",\\"text_transform\\":\\"uppercase\\",\\"p_margin_top\\":\\"0\\",\\"p_margin_bottom\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1.3\\",\\"font_size_unit\\":\\"em\\",\\"letter_spacing_unit\\":\\"em\\",\\"text_transform\\":\\"uppercase\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1.2\\",\\"font_size_unit\\":\\"em\\",\\"letter_spacing_unit\\":\\"em\\",\\"text_transform\\":\\"uppercase\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<p>Subscribe To Our<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"763e686\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"40\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"6\\",\\"font_size_h2_unit\\":\\"em\\",\\"h2_margin_bottom\\":\\"20\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>Newsletter<\\\\/h2>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"2.2\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"2.2\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}},{\\"element_id\\":\\"70a44a1\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"97b6503\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"2f51f68\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1.3\\",\\"font_size_unit\\":\\"em\\",\\"line_height\\":\\"1.5\\",\\"line_height_unit\\":\\"em\\",\\"text_transform\\":\\"uppercase\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"1\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"text_transform\\":\\"uppercase\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<p>Sign up for the latest tour dates and merch releases!<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]},{\\"element_id\\":\\"0f7d1fd\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"plain-text\\",\\"element_id\\":\\"b4b273b\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"plain_text\\":\\"<div id=\\\\\\\\\\\\\\"mc_embed_signup\\\\\\\\\\\\\\">\\\\n\\\\t<form action=\\\\\\\\\\\\\\"\\\\/\\\\/themify.us2.list-manage.com\\\\/subscribe\\\\/post?u=03462cf158e86ea00590274ab&amp;id=0f2a95e5de\\\\\\\\\\\\\\" method=\\\\\\\\\\\\\\"post\\\\\\\\\\\\\\" id=\\\\\\\\\\\\\\"mc-embedded-subscribe-form\\\\\\\\\\\\\\" name=\\\\\\\\\\\\\\"mc-embedded-subscribe-form\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\"validate\\\\\\\\\\\\\\" target=\\\\\\\\\\\\\\"_blank\\\\\\\\\\\\\\" novalidate>\\\\n\\\\t\\\\t<div id=\\\\\\\\\\\\\\"mc_embed_signup_scroll\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t<div class=\\\\\\\\\\\\\\"mc-field-group\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t\\\\t<input type=\\\\\\\\\\\\\\"email\\\\\\\\\\\\\\" value=\\\\\\\\\\\\\\"\\\\\\\\\\\\\\" name=\\\\\\\\\\\\\\"EMAIL\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\"required email\\\\\\\\\\\\\\" id=\\\\\\\\\\\\\\"mce-EMAIL\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t\\\\t<input type=\\\\\\\\\\\\\\"submit\\\\\\\\\\\\\\" value=\\\\\\\\\\\\\\"Subscribe\\\\\\\\\\\\\\" name=\\\\\\\\\\\\\\"subscribe\\\\\\\\\\\\\\" id=\\\\\\\\\\\\\\"mc-embedded-subscribe\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\"button\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t<\\\\/div>\\\\n\\\\t\\\\t\\\\t<div id=\\\\\\\\\\\\\\"mce-responses\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\"clear\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t\\\\t<div class=\\\\\\\\\\\\\\"response\\\\\\\\\\\\\\" id=\\\\\\\\\\\\\\"mce-error-response\\\\\\\\\\\\\\" style=\\\\\\\\\\\\\\"display:none\\\\\\\\\\\\\\"><\\\\/div>\\\\n\\\\t\\\\t\\\\t\\\\t<div class=\\\\\\\\\\\\\\"response\\\\\\\\\\\\\\" id=\\\\\\\\\\\\\\"mce-success-response\\\\\\\\\\\\\\" style=\\\\\\\\\\\\\\"display:none\\\\\\\\\\\\\\"><\\\\/div>\\\\n\\\\t\\\\t\\\\t<\\\\/div>\\\\n\\\\t\\\\t\\\\t<!-- real people should not fill this in and expect good things - do not remove this or risk form bot signups-->\\\\n\\\\t\\\\t\\\\t<div style=\\\\\\\\\\\\\\"position: absolute; left: -5000px;\\\\\\\\\\\\\\" aria-hidden=\\\\\\\\\\\\\\"true\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t\\\\t<input type=\\\\\\\\\\\\\\"text\\\\\\\\\\\\\\" name=\\\\\\\\\\\\\\"b_03462cf158e86ea00590274ab_0f2a95e5de\\\\\\\\\\\\\\" tabindex=\\\\\\\\\\\\\\"-1\\\\\\\\\\\\\\" value=\\\\\\\\\\\\\\"\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t<\\\\/div>\\\\n\\\\t\\\\t<\\\\/div>\\\\n\\\\t<\\\\/form>\\\\n<\\\\/div>\\\\n<script type=\\\\\\\\\\\'text\\\\/javascript\\\\\\\\\\\' src=\\\\\\\\\\\'\\\\/\\\\/s3.amazonaws.com\\\\/downloads.mailchimp.com\\\\/js\\\\/mc-validate.js\\\\\\\\\\\'><\\\\/script><script type=\\\\\\\\\\\'text\\\\/javascript\\\\\\\\\\\'>(function($) {window.fnames = new Array(); window.ftypes = new Array();fnames[0]=\\\\\\\\\\\'EMAIL\\\\\\\\\\\';ftypes[0]=\\\\\\\\\\\'email\\\\\\\\\\\';fnames[1]=\\\\\\\\\\\'FNAME\\\\\\\\\\\';ftypes[1]=\\\\\\\\\\\'text\\\\\\\\\\\';fnames[2]=\\\\\\\\\\\'LNAME\\\\\\\\\\\';ftypes[2]=\\\\\\\\\\\'text\\\\\\\\\\\';fnames[5]=\\\\\\\\\\\'HOMEPAGE\\\\\\\\\\\';ftypes[5]=\\\\\\\\\\\'text\\\\\\\\\\\';}(jQuery));var $mcj = jQuery.noConflict(true);<\\\\/script>\\\\n\\\\n<style>\\\\n#pagewrap #mc_embed_signup input[type=\\\\\\\\\\\\\\"email\\\\\\\\\\\\\\"] {\\\\n\\\\tpadding: 1.15em;\\\\n\\\\tbox-shadow: 0px 5px 31px 0px rgba(0, 255, 240, 0.51);\\\\n\\\\tmax-width: 24.3em;\\\\n\\\\tvertical-align: top;\\\\n\\\\tcolor: #000;\\\\n}\\\\n@media screen and (max-width: 680px) {\\\\n\\\\t#pagewrap #mc_embed_signup input[type=\\\\\\\\\\\\\\"email\\\\\\\\\\\\\\"] {\\\\n\\\\t\\\\tmax-width: none;\\\\n\\\\t}\\\\n}\\\\n<\\\\/style>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"},\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#ffffff\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/bg-newsletter.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"12\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"text_align\\":\\"center\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"43514ff\\",\\"row_order\\":\\"6\\",\\"cols\\":[{\\"element_id\\":\\"c1c1512\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"e65e49b\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/dot-3.jpg\\",\\"background_repeat\\":\\"no-repeat\\",\\"background_position\\":\\"right-bottom\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_right\\":\\"10\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"margin_right\\":\\"17\\",\\"margin_bottom\\":\\"79\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"b_c_c_h\\":\\"#e6ca4e_0.60\\",\\"f_c_c_h\\":\\"#fee230\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-full-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/photo-1-.jpg\\",\\"width_image\\":\\"333\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"355\\",\\"link_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/erica-montoque.jpg\\",\\"param_image\\":\\"lightbox\\",\\"image_zoom_icon\\":\\"zoom\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"e65e49b\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/dot-3.jpg\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_right\\":\\"10\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"margin_left\\":\\"61\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"b_c_c_h\\":\\"#e6ca4e_0.60\\",\\"f_c_c_h\\":\\"#fee230\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-full-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/photo-2.jpg\\",\\"width_image\\":\\"300\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"320\\",\\"link_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/jacob-svensson.jpg\\",\\"param_image\\":\\"lightbox\\",\\"image_zoom_icon\\":\\"zoom\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"text_align\\":\\"right\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"70441bf\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"e65e49b\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/dot-3.jpg\\",\\"background_repeat\\":\\"no-repeat\\",\\"background_position\\":\\"right-bottom\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_right\\":\\"10\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"margin_bottom\\":\\"51\\",\\"margin_left\\":\\"56\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"b_c_c_h\\":\\"#e6ca4e_0.60\\",\\"f_c_c_h\\":\\"#fee230\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-full-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/photo-3-.jpg\\",\\"width_image\\":\\"300\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"320\\",\\"link_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/jonathan-samuel.jpg\\",\\"param_image\\":\\"lightbox\\",\\"image_zoom_icon\\":\\"zoom\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"e65e49b\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/dot-3.jpg\\",\\"background_repeat\\":\\"no-repeat\\",\\"background_position\\":\\"right-bottom\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_right\\":\\"10\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"margin_bottom\\":\\"60\\",\\"margin_left\\":\\"123\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"b_c_c_h\\":\\"#e6ca4e_0.60\\",\\"f_c_c_h\\":\\"#fee230\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-full-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/photo-4-.jpg\\",\\"width_image\\":\\"240\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"247\\",\\"link_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/frankie-cordoba.jpg\\",\\"param_image\\":\\"lightbox\\",\\"image_zoom_icon\\":\\"zoom\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"289435a\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\",\\"buttons_size\\":\\"normal\\",\\"buttons_shape\\":\\"squared\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"See More\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"text_align\\":\\"right\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"cc43682\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"763e686\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"1.2\\",\\"font_size_unit\\":\\"em\\",\\"line_height\\":\\"1.7\\",\\"line_height_unit\\":\\"em\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"20\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_gradient_color_h2-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size_h2\\":\\"3.8\\",\\"font_size_h2_unit\\":\\"em\\",\\"h2_margin_bottom\\":\\"20\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"3\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"2.2\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"2.2\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<h2>Photos<\\\\/h2>\\\\n<p>Feel free to download our photos for your desktop or photo gallery - frame them or tape it on your wall!<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"e65e49b\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"b_c_c_h\\":\\"#e6ca4e_0.60\\",\\"f_c_c_h\\":\\"#fee230\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-full-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/photo-5.jpg\\",\\"width_image\\":\\"400\\",\\"height_image\\":\\"427\\",\\"link_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/erick-samuel.jpg\\",\\"param_image\\":\\"lightbox\\",\\"image_zoom_icon\\":\\"zoom\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/bg-line.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"37\\",\\"padding_left\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"col_tablet\\":\\"column4-2\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"572cc97\\",\\"row_order\\":\\"7\\",\\"cols\\":[{\\"element_id\\":\\"33da139\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"a7bdd20\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"0dba927\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"763e686\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"no-repeat\\",\\"background_position\\":\\"left-bottom\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"1.2\\",\\"font_size_unit\\":\\"em\\",\\"line_height\\":\\"1.3\\",\\"line_height_unit\\":\\"em\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"20\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_gradient_color_h2-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size_h2\\":\\"5\\",\\"font_size_h2_unit\\":\\"em\\",\\"h2_margin_bottom\\":\\"20\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"no-repeat\\",\\"background_position\\":\\"left-bottom\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"no-repeat\\",\\"background_position\\":\\"left-bottom\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"2.2\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"no-repeat\\",\\"background_position\\":\\"left-bottom\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"2.2\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<h2>Videos<\\\\/h2>\\\\n<p>Enjoy a collection of our concert snippets. For more videos, check out our YouTube channel.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"289435a\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\",\\"buttons_size\\":\\"normal\\",\\"buttons_shape\\":\\"squared\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Youtube\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/bg-line-2.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_bottom\\":\\"15\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"240f878\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"5ef963e\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/video-1.jpg\\",\\"width_image\\":\\"600\\",\\"height_image\\":\\"338\\",\\"link_image\\":\\"https:\\\\/\\\\/www.youtube.com\\\\/watch?v=P8Lte26BBN8\\",\\"param_image\\":\\"lightbox\\",\\"lightbox_width\\":\\"980\\",\\"lightbox_height\\":\\"585\\",\\"image_zoom_icon\\":\\"zoom\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"8\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"}}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"d27c796\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"081a342\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"d9629e3\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/video-2.jpg\\",\\"width_image\\":\\"360\\",\\"height_image\\":\\"260\\",\\"link_image\\":\\"https:\\\\/\\\\/www.youtube.com\\\\/watch?v=FFM6dop3I08\\",\\"param_image\\":\\"lightbox\\",\\"lightbox_width\\":\\"980\\",\\"lightbox_height\\":\\"585\\",\\"image_zoom_icon\\":\\"zoom\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"8\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"}}}]},{\\"element_id\\":\\"d52b134\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"d9629e3\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/video-3.jpg\\",\\"width_image\\":\\"360\\",\\"height_image\\":\\"260\\",\\"link_image\\":\\"https:\\\\/\\\\/www.youtube.com\\\\/watch?v=FFM6dop3I08\\",\\"param_image\\":\\"lightbox\\",\\"lightbox_width\\":\\"980\\",\\"lightbox_height\\":\\"585\\",\\"image_zoom_icon\\":\\"zoom\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"8\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"}}}]},{\\"element_id\\":\\"ebbb984\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"d9629e3\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/video-4.jpg\\",\\"width_image\\":\\"360\\",\\"height_image\\":\\"260\\",\\"link_image\\":\\"https:\\\\/\\\\/www.youtube.com\\\\/watch?v=FFM6dop3I08\\",\\"param_image\\":\\"lightbox\\",\\"lightbox_width\\":\\"980\\",\\"lightbox_height\\":\\"585\\",\\"image_zoom_icon\\":\\"zoom\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"8\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"}}}]}]}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/bg-video-pattern.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"right-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"0be8d21\\",\\"row_order\\":\\"8\\",\\"cols\\":[{\\"element_id\\":\\"3e9757f\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"763e686\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#888888\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"1.4\\",\\"font_size_unit\\":\\"em\\",\\"line_height\\":\\"1.3\\",\\"line_height_unit\\":\\"em\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"20\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_h2\\":\\"#ffffff\\",\\"font_gradient_color_h2-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"h2_margin_bottom\\":\\"20\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h2>The Artists<\\\\/h2>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"2.2\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"2.2\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"347fb84\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"b_c_c_h\\":\\"#e6c54c_0.60\\",\\"f_c_c_h\\":\\"#fee230\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"8\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"},\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/mabelle-howell.jpg\\",\\"width_image\\":\\"460\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"470\\",\\"title_image\\":\\"Mabelle Howell\\",\\"link_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/mabelle-howell.jpg\\",\\"param_image\\":\\"lightbox\\",\\"image_zoom_icon\\":\\"zoom\\",\\"caption_image\\":\\"Lead Vocals\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]},{\\"element_id\\":\\"4709167\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"347fb84\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"50\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"b_c_c_h\\":\\"#e6c54c_0.60\\",\\"f_c_c_h\\":\\"#fee230\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/artist-2.jpg\\",\\"width_image\\":\\"260\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"260\\",\\"title_image\\":\\"Mike Angel\\",\\"link_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/simone-altraz.jpg\\",\\"param_image\\":\\"lightbox\\",\\"image_zoom_icon\\":\\"zoom\\",\\"caption_image\\":\\"Guitarist\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"8\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"}}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"347fb84\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"b_c_c_h\\":\\"#e6c54c_0.60\\",\\"f_c_c_h\\":\\"#fee230\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"8\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"},\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/artist-3.jpg\\",\\"width_image\\":\\"260\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"260\\",\\"title_image\\":\\"Michelle Leah\\",\\"link_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/miguel-nerd.jpg\\",\\"param_image\\":\\"lightbox\\",\\"image_zoom_icon\\":\\"zoom\\",\\"caption_image\\":\\"Backing Vocals\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]},{\\"element_id\\":\\"73f2d0b\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"347fb84\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"50\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"b_c_c_h\\":\\"#e6c54c_0.60\\",\\"f_c_c_h\\":\\"#fee230\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"8\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"},\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/Alex-Sams.jpg\\",\\"width_image\\":\\"260\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"260\\",\\"title_image\\":\\"Alex Sams\\",\\"link_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/Alex-Sams.jpg\\",\\"param_image\\":\\"lightbox\\",\\"image_zoom_icon\\":\\"zoom\\",\\"caption_image\\":\\"Pianist\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"445f3a6\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"1.2\\",\\"font_size_unit\\":\\"em\\",\\"line_height\\":\\"1.7\\",\\"line_height_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Read more about us below and don\\\\\\\\\\\'t forget to follow us on Instagram and Facebook!<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"289435a\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"link_color\\":\\"#000000\\",\\"link_color_hover\\":\\"#ffffff\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\",\\"buttons_size\\":\\"normal\\",\\"buttons_shape\\":\\"squared\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"About us\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\"}}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"96\\",\\"border-type\\":\\"top\\"}}],\\"col_tablet\\":\\"column4-2\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/pattern-wave-blue.jpg\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"background_color\\":\\"#13133e\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#12143d_0.43\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#bfbfbf\\",\\"link_color\\":\\"#ffffff\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"99b6914\\",\\"row_order\\":\\"9\\",\\"cols\\":[{\\"element_id\\":\\"e092fcc\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"0ea00a7\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/press-1.jpg\\",\\"width_image\\":\\"463\\",\\"height_image\\":\\"619\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/dot-1-1.jpg\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"a2eae68\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"763e686\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"1.2\\",\\"font_size_unit\\":\\"em\\",\\"line_height\\":\\"1.3\\",\\"line_height_unit\\":\\"em\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_gradient_color_h2-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size_h2\\":\\"6\\",\\"font_size_h2_unit\\":\\"em\\",\\"h2_margin_bottom\\":\\"20\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"4\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"2.2\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_unit\\":\\"em\\",\\"line_height_unit\\":\\"em\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h2\\":\\"2.2\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"},\\"content_text\\":\\"<h2>Press<\\\\/h2>\\\\n<p>Read the latest about our tour, latest album, and this year\\\\\\\\\\\'s awards season - direct from the source!<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"289435a\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"25\\",\\"border-type\\":\\"top\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\",\\"buttons_size\\":\\"normal\\",\\"buttons_shape\\":\\"squared\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Press kit\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"cbdba2b\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"80acdde\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"122de46\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"60\\",\\"border-type\\":\\"top\\",\\"font_color_title\\":\\"#000000\\",\\"font_size_title\\":\\"1.5\\",\\"font_size_title_unit\\":\\"em\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"font_size_caption\\":\\"1\\",\\"font_size_caption_unit\\":\\"em\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/press-2.jpg\\",\\"width_image\\":\\"260\\",\\"height_image\\":\\"260\\",\\"title_image\\":\\"Album II\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"We won Best Folk Album 2018!\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]},{\\"element_id\\":\\"88650a4\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"122de46\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_weight_title\\":\\"700\\",\\"font_color_title\\":\\"#000000\\",\\"font_size_title\\":\\"1.5\\",\\"font_size_title_unit\\":\\"em\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"font_size_caption\\":\\"1\\",\\"font_size_caption_unit\\":\\"em\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-music\\\\/files\\\\/2018\\\\/12\\\\/press-3.jpg\\",\\"width_image\\":\\"260\\",\\"height_image\\":\\"260\\",\\"title_image\\":\\"Vinyl King\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Our album “Young Again” was featured in Vinyl King magazine.\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"-40\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"25\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"6ecc942\\",\\"unstick_when_el_mod_id\\":\\"9756bff\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"b9d7ef2\\",\\"row_order\\":\\"10\\",\\"cols\\":[{\\"element_id\\":\\"1a9ccc1\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 493,
  'post_date' => '2018-12-18 12:05:49',
  'post_date_gmt' => '2018-12-18 12:05:49',
  'post_content' => '<!--themify_builder_static--><h1>Tours</h1><!--/themify_builder_static-->',
  'post_title' => 'Tours',
  'post_excerpt' => '',
  'post_name' => 'tours',
  'post_modified' => '2018-12-20 07:47:58',
  'post_modified_gmt' => '2018-12-20 07:47:58',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-music/?page_id=493',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"f2b9580\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"7e48b6e\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"63a6ab0\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_size_h1\\":\\"7\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h1>Tours<\\\\/h1>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"f2b9580\\",\\"unstick_when_el_mod_id\\":\\"cc0cbb7\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_size_h1\\":\\"3\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}},{\\"mod_name\\":\\"event-posts\\",\\"element_id\\":\\"cc0cbb7\\",\\"mod_settings\\":{\\"checkbox_general_padding_apply_all\\":\\"1\\",\\"checkbox_general_margin_apply_all\\":\\"1\\",\\"general_border-type\\":\\"top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_p_t_apply_all\\":\\"1\\",\\"checkbox_m_t_apply_all\\":\\"1\\",\\"b_t-type\\":\\"top\\",\\"checkbox_p_d_apply_all\\":\\"1\\",\\"checkbox_m_d_apply_all\\":\\"1\\",\\"b_d-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"checkbox_c_m_apply_all\\":\\"1\\",\\"c_b-type\\":\\"top\\",\\"checkbox_p_f_i_apply_all\\":\\"1\\",\\"checkbox_m_f_i_apply_all\\":\\"1\\",\\"b_f_i-type\\":\\"top\\",\\"show\\":\\"upcoming\\",\\"style\\":\\"list-post\\",\\"category\\":\\"0|multiple\\",\\"limit\\":\\"6\\",\\"order\\":\\"desc\\",\\"orderby\\":\\"event_date\\",\\"display\\":\\"excerpt\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"f2b9580\\",\\"unstick_when_el_mod_id\\":\\"63a6ab0\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"thumbnail\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"3500\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"left-top\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"px\\",\\"top-frame_height_unit\\":\\"px\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"px\\",\\"bottom-frame_height_unit\\":\\"px\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"px\\",\\"left-frame_height_unit\\":\\"px\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"px\\",\\"right-frame_height_unit\\":\\"px\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"1d9911a\\",\\"unstick_when_el_mod_id\\":\\"cc0cbb7\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"1d9911a\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"ecf3a34\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 43,
  'post_date' => '2018-12-13 13:05:39',
  'post_date_gmt' => '2018-12-13 13:05:39',
  'post_content' => 'You know you\'ve made it when you\'ve made it onto Ellen. America\'s beloved comedian and talkshow host came across our YouTube music video one day. We guess she loved it so much, she personally invited us for a taping of a show, and surprised us by bringing us on stage. We\'re thankful for all of your support, and for everyone on the show for giving us such a warm welcome.',
  'post_title' => 'Catch Us On Ellen!',
  'post_excerpt' => '',
  'post_name' => 'black-parade-in-new-york',
  'post_modified' => '2019-02-22 19:52:12',
  'post_modified_gmt' => '2019-02-22 19:52:12',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-music/?post_type=event&#038;p=43',
  'menu_order' => 0,
  'post_type' => 'event',
  'meta_input' => 
  array (
    'start_date' => '2019-09-02 12:00',
    'end_date' => '2019-09-02 17:30',
    'location' => 'The Ellen DeGeneres Show\'s Stage',
    'map_address' => '3400 W Riverside Dr, Burbank, CA 91505',
    'buy_tickets' => 'https://themify.me/',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"bdf0acd\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"2ed2178\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-music/files/2018/12/event-2.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 40,
  'post_date' => '2018-12-13 13:00:25',
  'post_date_gmt' => '2018-12-13 13:00:25',
  'post_content' => 'For the first 500 people who sign up, they\'ll be given a free pink wristband to come see us at a live performance at uncle Jimmy\'s. Come one, come all! Jimmy Kimmel Live performance date to be announced.',
  'post_title' => 'Free Concert At Jimmy Kimmel Live!',
  'post_excerpt' => '',
  'post_name' => 'music-band-walk-festival',
  'post_modified' => '2019-02-22 19:53:02',
  'post_modified_gmt' => '2019-02-22 19:53:02',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-music/?post_type=event&#038;p=40',
  'menu_order' => 0,
  'post_type' => 'event',
  'meta_input' => 
  array (
    'start_date' => '2019-08-24 10:00',
    'end_date' => '2019-08-24 03:30',
    'location' => '6840 Hollywood Blvd, Los Angeles, CA 90028',
    'map_address' => '6840 Hollywood Blvd, Los Angeles, CA 90028',
    'buy_tickets' => 'https://themify.me/',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"0ef056f\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"af84432\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-music/files/2018/12/event-1.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 47,
  'post_date' => '2018-12-12 13:07:32',
  'post_date_gmt' => '2018-12-12 13:07:32',
  'post_content' => 'We\'ve been looking forward to this ever since the launch of our EP - and now thanks to you guys, we\'re making it happen. We\'re excited to see you all across every major city in the U.S. and Canada! And we have some special surprise guests lined up for you to keep things interesting.',
  'post_title' => 'North America Tour Dates 2019 Announced!',
  'post_excerpt' => '',
  'post_name' => 'back-to-nature-parade',
  'post_modified' => '2019-02-22 19:53:26',
  'post_modified_gmt' => '2019-02-22 19:53:26',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-music/?post_type=event&#038;p=47',
  'menu_order' => 0,
  'post_type' => 'event',
  'meta_input' => 
  array (
    'start_date' => '2019-09-16 09:00',
    'end_date' => '2019-09-16 19:00',
    'location' => 'North America and beyond!',
    'map_address' => 'Italy',
    'buy_tickets' => 'https://themify.me/',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"8d7d4a5\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"682a477\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-music/files/2018/12/event-3.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 49,
  'post_date' => '2018-12-11 13:10:56',
  'post_date_gmt' => '2018-12-11 13:10:56',
  'post_content' => 'We\'ll be playing in the smack dab middle of the UK\'s most iconic music festival! Join us as we open for Snoop Dog and play alongside Post Malone for our first gig at Glastonbury! 
',
  'post_title' => 'Join Us For Glastonbury 2019!',
  'post_excerpt' => '',
  'post_name' => 'international-concert',
  'post_modified' => '2019-02-22 19:54:14',
  'post_modified_gmt' => '2019-02-22 19:54:14',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-music/?post_type=event&#038;p=49',
  'menu_order' => 0,
  'post_type' => 'event',
  'meta_input' => 
  array (
    'start_date' => '2019-10-06 10:00',
    'end_date' => '2019-10-06 19:00',
    'location' => 'Worthy Farm, United Kingdom',
    'map_address' => 'Worthy Farm, United Kingdom',
    'buy_tickets' => 'https://themify.me/',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"2f6ba71\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"da81e1c\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-music/files/2018/12/event-4.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 254,
  'post_date' => '2018-12-15 16:57:33',
  'post_date_gmt' => '2018-12-15 16:57:33',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '254',
  'post_modified' => '2018-12-18 12:06:31',
  'post_modified_gmt' => '2018-12-18 12:06:31',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-music/?p=254',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '5',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 325,
  'post_date' => '2018-12-17 19:39:57',
  'post_date_gmt' => '2018-12-17 19:39:57',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '325',
  'post_modified' => '2018-12-18 12:06:31',
  'post_modified_gmt' => '2018-12-18 12:06:31',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-music/?p=325',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '300',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 496,
  'post_date' => '2018-12-18 12:06:31',
  'post_date_gmt' => '2018-12-18 12:06:31',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '496',
  'post_modified' => '2018-12-18 12:06:31',
  'post_modified_gmt' => '2018-12-18 12:06:31',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-music/?p=496',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '493',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 253,
  'post_date' => '2018-12-15 16:57:33',
  'post_date_gmt' => '2018-12-15 16:57:33',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '253',
  'post_modified' => '2018-12-18 12:06:31',
  'post_modified_gmt' => '2018-12-18 12:06:31',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-music/?p=253',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '213',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 442,
  'post_date' => '2018-12-18 04:49:58',
  'post_date_gmt' => '2018-12-18 04:49:58',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '442',
  'post_modified' => '2018-12-18 12:06:31',
  'post_modified_gmt' => '2018-12-18 12:06:31',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-music/?p=442',
  'menu_order' => 5,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '437',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );



function themify_import_get_term_id_from_slug( $slug ) {
	$menu = get_term_by( "slug", $slug, "nav_menu" );
	return is_wp_error( $menu ) ? 0 : (int) $menu->term_id;
}

	$widgets = get_option( "widget_themify-social-links" );
$widgets[1002] = array (
  'title' => '',
  'show_link_name' => NULL,
  'open_new_window' => NULL,
  'icon_size' => 'icon-medium',
  'orientation' => 'horizontal',
);
update_option( "widget_themify-social-links", $widgets );

$widgets = get_option( "widget_media_gallery" );
$widgets[1003] = array (
  'title' => 'New Albums',
  'columns' => 4,
  'size' => 'thumbnail',
  'link_type' => 'file',
  'orderby_random' => false,
  'ids' => 
  array (
    0 => 403,
    1 => 402,
    2 => 330,
    3 => 333,
    4 => 212,
    5 => 390,
    6 => 250,
    7 => 400,
  ),
);
update_option( "widget_media_gallery", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1004] = array (
  'title' => 'News',
  'text' => '<a href="https://themify.me/demo/themes/ultra-music/category/trend/">Trends</a>

<a href="https://themify.me/demo/themes/ultra-music/category/event/">Events</a>

<a href="https://themify.me/demo/themes/ultra-music/category/tips/">Tutorial</a>

<a href="https://themify.me/demo/themes/ultra-music/category/award/">Award</a>',
  'filter' => true,
  'visual' => true,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1005] = array (
  'title' => 'Sitemap',
  'text' => 'Home

<a href="https://themify.me/demo/themes/ultra-music/about/">About</a>

<a href="https://themify.me/demo/themes/ultra-music/tours/">Tours</a>

<a href="https://themify.me/demo/themes/ultra-music/contact/">Contact</a>',
  'filter' => true,
  'visual' => true,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1006] = array (
  'title' => 'Follow Us',
  'text' => '<a href="https://facebook.com/themify">Facebook</a>

<a href="https://twitter.com/themify">Twitter</a>

<a href="https://youtube.com/themifyme">Youtube</a>

<a href="https://instagram.com/themify">Instagram</a>',
  'filter' => true,
  'visual' => true,
);
update_option( "widget_text", $widgets );



$sidebars_widgets = array (
  'social-widget' => 
  array (
    0 => 'themify-social-links-1002',
  ),
  'footer-widget-1' => 
  array (
    0 => 'media_gallery-1003',
  ),
  'footer-widget-2' => 
  array (
    0 => 'text-1004',
  ),
  'footer-widget-3' => 
  array (
    0 => 'text-1005',
  ),
  'footer-widget-4' => 
  array (
    0 => 'text-1006',
  ),
); 
update_option( "sidebars_widgets", $sidebars_widgets );

$menu_locations = array();
$menu = get_terms( "nav_menu", array( "slug" => "main-navigation" ) );
if( is_array( $menu ) && ! empty( $menu ) ) $menu_locations["main-nav"] = $menu[0]->term_id;
set_theme_mod( "nav_menu_locations", $menu_locations );


$homepage = get_posts( array( 'name' => '5-2', 'post_type' => 'page' ) );
			if( is_array( $homepage ) && ! empty( $homepage ) ) {
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $homepage[0]->ID );
			}
			
	ob_start(); ?>a:112:{s:21:"setting-webfonts_list";s:11:"recommended";s:22:"setting-default_layout";s:12:"sidebar-none";s:27:"setting-default_post_layout";s:9:"list-post";s:19:"setting-post_filter";s:2:"no";s:23:"setting-disable_masonry";s:3:"yes";s:19:"setting-post_gutter";s:6:"gutter";s:30:"setting-default_layout_display";s:7:"content";s:25:"setting-default_more_text";s:4:"More";s:21:"setting-index_orderby";s:4:"date";s:19:"setting-index_order";s:4:"DESC";s:30:"setting-default_media_position";s:5:"above";s:31:"setting-image_post_feature_size";s:5:"blank";s:24:"setting-image_post_width";s:4:"1160";s:25:"setting-image_post_height";s:3:"500";s:32:"setting-default_page_post_layout";s:12:"sidebar-none";s:37:"setting-default_page_post_layout_type";s:7:"classic";s:42:"setting-default_page_single_media_position";s:5:"above";s:38:"setting-image_post_single_feature_size";s:5:"blank";s:31:"setting-image_post_single_width";s:4:"1160";s:32:"setting-image_post_single_height";s:3:"500";s:36:"setting-search-result_layout_display";s:7:"content";s:36:"setting-search-result_media_position";s:5:"above";s:27:"setting-default_page_layout";s:8:"sidebar1";s:40:"setting-custom_post_tglobal_style_single";s:8:"sidebar1";s:32:"setting-custom_post_event_single";s:8:"sidebar1";s:38:"setting-default_portfolio_index_layout";s:12:"sidebar-none";s:43:"setting-default_portfolio_index_post_layout";s:5:"grid3";s:29:"setting-portfolio_post_filter";s:3:"yes";s:33:"setting-portfolio_disable_masonry";s:3:"yes";s:24:"setting-portfolio_gutter";s:6:"gutter";s:39:"setting-default_portfolio_index_display";s:4:"none";s:50:"setting-default_portfolio_index_post_meta_category";s:3:"yes";s:49:"setting-default_portfolio_index_unlink_post_image";s:3:"yes";s:39:"setting-default_portfolio_single_layout";s:12:"sidebar-none";s:54:"setting-default_portfolio_single_portfolio_layout_type";s:9:"fullwidth";s:50:"setting-default_portfolio_single_unlink_post_image";s:3:"yes";s:22:"themify_portfolio_slug";s:7:"project";s:53:"setting-customizer_responsive_design_tablet_landscape";s:4:"1280";s:43:"setting-customizer_responsive_design_tablet";s:3:"768";s:43:"setting-customizer_responsive_design_mobile";s:3:"680";s:33:"setting-mobile_menu_trigger_point";s:3:"900";s:24:"setting-gallery_lightbox";s:8:"lightbox";s:27:"setting-page_builder_expiry";s:1:"2";s:21:"setting-header_design";s:17:"header-horizontal";s:28:"setting-exclude_site_tagline";s:2:"on";s:19:"setting_search_form";s:11:"live_search";s:19:"setting-exclude_rss";s:2:"on";s:22:"setting-header_widgets";s:17:"headerwidget-4col";s:21:"setting-footer_design";s:22:"footer-horizontal-left";s:32:"setting-exclude_footer_site_logo";s:2:"on";s:22:"setting-use_float_back";s:2:"on";s:22:"setting-footer_widgets";s:17:"footerwidget-4col";s:30:"setting-footer_widget_position";s:3:"top";s:23:"setting-mega_menu_posts";s:1:"5";s:29:"setting-mega_menu_image_width";s:3:"180";s:30:"setting-mega_menu_image_height";s:3:"120";s:27:"setting-imagefilter_applyto";s:12:"featuredonly";s:29:"setting-color_animation_speed";s:1:"5";s:29:"setting-relationship_taxonomy";s:8:"category";s:37:"setting-relationship_taxonomy_entries";s:1:"3";s:45:"setting-relationship_taxonomy_display_content";s:4:"none";s:30:"setting-single_slider_autoplay";s:3:"off";s:27:"setting-single_slider_speed";s:6:"normal";s:28:"setting-single_slider_effect";s:5:"slide";s:28:"setting-single_slider_height";s:4:"auto";s:18:"setting-more_posts";s:8:"infinite";s:19:"setting-entries_nav";s:8:"numbered";s:25:"setting-img_php_base_size";s:5:"large";s:27:"setting-global_feature_size";s:5:"blank";s:22:"setting-link_icon_type";s:9:"font-icon";s:32:"setting-link_type_themify-link-0";s:10:"image-icon";s:33:"setting-link_title_themify-link-0";s:7:"Twitter";s:31:"setting-link_img_themify-link-0";s:105:"https://themify.me/demo/themes/ultra-music/wp-content/themes/themify-ultra/themify/img/social/twitter.png";s:32:"setting-link_type_themify-link-1";s:10:"image-icon";s:33:"setting-link_title_themify-link-1";s:8:"Facebook";s:31:"setting-link_img_themify-link-1";s:106:"https://themify.me/demo/themes/ultra-music/wp-content/themes/themify-ultra/themify/img/social/facebook.png";s:32:"setting-link_type_themify-link-2";s:10:"image-icon";s:33:"setting-link_title_themify-link-2";s:7:"Google+";s:31:"setting-link_img_themify-link-2";s:109:"https://themify.me/demo/themes/ultra-music/wp-content/themes/themify-ultra/themify/img/social/google-plus.png";s:32:"setting-link_type_themify-link-3";s:10:"image-icon";s:33:"setting-link_title_themify-link-3";s:7:"YouTube";s:31:"setting-link_img_themify-link-3";s:105:"https://themify.me/demo/themes/ultra-music/wp-content/themes/themify-ultra/themify/img/social/youtube.png";s:32:"setting-link_type_themify-link-4";s:10:"image-icon";s:33:"setting-link_title_themify-link-4";s:9:"Pinterest";s:31:"setting-link_img_themify-link-4";s:107:"https://themify.me/demo/themes/ultra-music/wp-content/themes/themify-ultra/themify/img/social/pinterest.png";s:32:"setting-link_type_themify-link-6";s:9:"font-icon";s:33:"setting-link_title_themify-link-6";s:8:"Facebook";s:32:"setting-link_link_themify-link-6";s:32:"https://www.facebook.com/themify";s:33:"setting-link_ficon_themify-link-6";s:11:"fa-facebook";s:32:"setting-link_type_themify-link-5";s:9:"font-icon";s:33:"setting-link_title_themify-link-5";s:7:"Twitter";s:32:"setting-link_link_themify-link-5";s:31:"https://www.twitter.com/themify";s:33:"setting-link_ficon_themify-link-5";s:10:"fa-twitter";s:32:"setting-link_type_themify-link-8";s:9:"font-icon";s:33:"setting-link_title_themify-link-8";s:7:"YouTube";s:32:"setting-link_link_themify-link-8";s:38:"https://www.youtube.com/user/themifyme";s:33:"setting-link_ficon_themify-link-8";s:15:"fa-youtube-play";s:32:"setting-link_type_themify-link-7";s:9:"font-icon";s:33:"setting-link_title_themify-link-7";s:7:"Google+";s:33:"setting-link_ficon_themify-link-7";s:14:"fa-google-plus";s:32:"setting-link_type_themify-link-9";s:9:"font-icon";s:33:"setting-link_title_themify-link-9";s:9:"Pinterest";s:33:"setting-link_ficon_themify-link-9";s:12:"fa-pinterest";s:22:"setting-link_field_ids";s:341:"{"themify-link-0":"themify-link-0","themify-link-1":"themify-link-1","themify-link-2":"themify-link-2","themify-link-3":"themify-link-3","themify-link-4":"themify-link-4","themify-link-6":"themify-link-6","themify-link-5":"themify-link-5","themify-link-8":"themify-link-8","themify-link-7":"themify-link-7","themify-link-9":"themify-link-9"}";s:23:"setting-link_field_hash";s:2:"10";s:30:"setting-page_builder_is_active";s:6:"enable";s:41:"setting-page_builder_animation_appearance";s:4:"none";s:42:"setting-page_builder_animation_parallax_bg";s:4:"none";s:46:"setting-page_builder_animation_parallax_scroll";s:6:"mobile";s:44:"setting-page_builder_animation_sticky_scroll";s:4:"none";s:4:"skin";s:5:"music";s:13:"import_images";s:2:"on";}<?php $themify_data = unserialize( ob_get_clean() );

	// Fix how "skin" option used to save
	if( isset( $themify_data['skin'] ) ) {
		if ( filter_var( $themify_data['skin'], FILTER_VALIDATE_URL ) ) {
			$parsed_skin = parse_url( $value, PHP_URL_PATH );
			$themify_data['skin'] = basename( dirname( $parsed_skin ) );
		}
	}

	themify_set_data( $themify_data );
	
}
themify_do_demo_import();